#define	MAXMARKCHAR	255	/* >= 255 */
#define	NONEXISTANT	-1	/* offset for raster files not found */

struct rastchar_entry {		/* character entry */
    unsigned short width, height;/* width and height in pixels */
    short xoffset, yoffset;	/* x offset and y offset in pixels */
    short dev_font, dev_char;
    unsigned short nbpl;	/* # of bytes per pixel data line */
    union {
	unsigned int fileoffset;
	char *pixptr;
    } where;
    int tfmw;			/* TFM width */
};

struct rastfntinfo {
    float corrfact;
    int nfntchars;
    int dictform;	/* form of dev_font dictionary		*/
    struct rastchar_entry ch[1];	/* character information	*/
};

/* form of dictionary */
#define	PACK		0
#define	DVI		1

#ifdef ANSI
#define	rastfinfo(fe)	(*(struct rastfntinfo **)&(fe->finfo))
#else
#define	rastfinfo(fe)	((struct rastfntinfo *)(fe->finfo))
#endif

/* used to pass information from access to initfontinfo */
struct rastaccessinfo {
    /* int font_mag; */
    float corrfact;
};

/* used to pass information from initfontinfo to readfontinfo
   and to pass marking information */
struct rastinitfontinfo {
    float corrfact;
    int maxc;
    Boolean mark[1];
};

#ifdef ANSI
#define	rastaccinfo(fe)		(*(struct rastaccessinfo **)&(fe->finfo))
#define	rastinifinfo(fe)	(*(struct rastinitfontinfo **)&(fe->finfo))
#else
#define	rastaccinfo(fe)		((struct rastaccessinfo *)(fe->finfo))
#define	rastinifinfo(fe)	((struct rastinitfontinfo *)(fe->finfo))
#endif

struct rastfntinfo *alloc_rastfinfo();
DEV_FONT rast_fontdict();


/*
 * Interface with device driver
 */
void dev_rast_initfe();
void dev_rast_initfontdict();
