#include "SDL.h"
#include "SDL_opengl.h"
#include "font_data.h"

int Font_data::dx() { return 6; }
int Font_data::dy() { return 14; }

void Font_data::drawletter_nodl(char letter,bool smooth) {

	SDL_Rect p;
	for (unsigned int l=0;l<dy();l++) {
		p.y=l;
		for (unsigned int c=0;c<dx();c++) {
			p.x=c;
			glPushMatrix();
			glTranslatef(p.x,p.y,0.0f);
			char chr;
			chr=get_field(letter,c,l);

			float d=0.5f;
			float n=0;
			float o=0;
			if (chr==' ') {
				if (!smooth) { glPopMatrix(); continue;}
				if (get_field(letter,c-1,l)!=' ') {
					n=d;
					o=1.0f-d;
					if (get_field(letter,c,l+1)!=' ') {
						glBegin(GL_TRIANGLES);
						glVertex2f(0,n);
						glVertex2f(o,1);
						glVertex2f(0,1);
						glEnd();
					}

					if (get_field(letter,c,l-1)!=' ') {
						glBegin(GL_TRIANGLES);
						glVertex2f(0,0);
						glVertex2f(o,0);
						glVertex2f(0,o);
						glEnd();
					}

				}
				if (get_field(letter,c+1,l)!=' ') {
					if (get_field(letter,c,l-1)!=' ') {
						glBegin(GL_TRIANGLES);
						glVertex2f(n,0);
						glVertex2f(1,0);
						glVertex2f(1,o);
						glEnd();
					}
					if (get_field(letter,c,l+1)!=' ') {
						glBegin(GL_TRIANGLES);
						glVertex2f(1,n);
						glVertex2f(1,1);
						glVertex2f(o,1);
						glEnd();
					}

				}

				glPopMatrix();
				continue;
			}
			glBegin(GL_QUADS);
			glVertex2f(0.0f,0.0f);
			glVertex2f(1.0f,0.0f);
			glVertex2f(1.0f,1.0f);
			glVertex2f(0.0f,1.0f);
			glEnd();
			glPopMatrix();
		}
	}
}


unsigned int Font_data::gen_dl() {
	unsigned int dls;

	dls=glGenLists(94);
	for (int i=33;i<127;i++) {
		int li;
		li=dls+i-33;
		glNewList(dls+i-33,GL_COMPILE);
		drawletter_nodl((char)i,false);
		glEndList();
	}
	/*dls_smooth=glGenLists(94);
	for (int i=33;i<127;i++) {
		int li;
		li=dls+i-33;
		glNewList(dls_smooth+i-33,GL_COMPILE);
		drawletter_nodl((char)i,true);
		glEndList();
	}*/
	return dls;
}



 static const char * font_all[94][14]= {
{
"      ",
"      ",
"  .   ",
"  .   ",
"  .   ",
"  .   ",
"  .   ",
"  .   ",
"  .   ",
"      ",
"  .   ",
"      ",
"      ",
"      "
},
{
"      ",
"      ",
" . .  ",
" . .  ",
" . .  ",
"      ",
"      ",
"      ",
"      ",
"      ",
"      ",
"      ",
"      ",
"      "
},
{
"      ",
"      ",
"      ",
" . .  ",
" . .  ",
"..... ",
" . .  ",
"..... ",
" . .  ",
" . .  ",
"      ",
"      ",
"      ",
"      "
},
{
"      ",
"      ",
"  .   ",
" .... ",
". .   ",
". .   ",
" ...  ",
"  . . ",
"  . . ",
"....  ",
"  .   ",
"      ",
"      ",
"      "
},
{
"      ",
"      ",
" .  . ",
". . . ",
" . .  ",
"   .  ",
"  .   ",
" .    ",
" . .  ",
". . . ",
".  .  ",
"      ",
"      ",
"      "
},
{
"      ",
"      ",
"      ",
" .    ",
". .   ",
". .   ",
" .    ",
". .   ",
".  .. ",
".  .  ",
" .. . ",
"      ",
"      ",
"      "
},
{
"      ",
"      ",
"  .   ",
"  .   ",
"  .   ",
"      ",
"      ",
"      ",
"      ",
"      ",
"      ",
"      ",
"      ",
"      "
},
{
"      ",
"   .  ",
"  .   ",
"  .   ",
" .    ",
" .    ",
" .    ",
" .    ",
" .    ",
"  .   ",
"  .   ",
"   .  ",
"      ",
"      "
},
{
"      ",
" .    ",
"  .   ",
"  .   ",
"   .  ",
"   .  ",
"   .  ",
"   .  ",
"   .  ",
"  .   ",
"  .   ",
" .    ",
"      ",
"      "
},
{
"      ",
"      ",
"      ",
"  .   ",
". . . ",
"..... ",
" ...  ",
"..... ",
". . . ",
"  .   ",
"      ",
"      ",
"      ",
"      "
},
{
"      ",
"      ",
"      ",
"      ",
"  .   ",
"  .   ",
"..... ",
"  .   ",
"  .   ",
"      ",
"      ",
"      ",
"      ",
"      "
},
{
"      ",
"      ",
"      ",
"      ",
"      ",
"      ",
"      ",
"      ",
"      ",
"  ..  ",
"  .   ",
" .    ",
"      ",
"      "
},
{
"      ",
"      ",
"      ",
"      ",
"      ",
"      ",
"..... ",
"      ",
"      ",
"      ",
"      ",
"      ",
"      ",
"      "
},
{
"      ",
"      ",
"      ",
"      ",
"      ",
"      ",
"      ",
"      ",
"      ",
"  .   ",
" ...  ",
"  .   ",
"      ",
"      "
},
{
"      ",
"      ",
"    . ",
"    . ",
"   .  ",
"   .  ",
"  .   ",
" .    ",
" .    ",
".     ",
".     ",
"      ",
"      ",
"      "
},
{
"      ",
"      ",
"  .   ",
" . .  ",
".   . ",
".   . ",
".   . ",
".   . ",
".   . ",
" . .  ",
"  .   ",
"      ",
"      ",
"      "
},
{
"      ",
"      ",
"  .   ",
" ..   ",
". .   ",
"  .   ",
"  .   ",
"  .   ",
"  .   ",
"  .   ",
"..... ",
"      ",
"      ",
"      "
},
{
"      ",
"      ",
" ...  ",
".   . ",
".   . ",
"    . ",
"   .  ",
"  .   ",
" .    ",
".     ",
"..... ",
"      ",
"      ",
"      "
},
{
"      ",
"      ",
"..... ",
"    . ",
"   .  ",
"  .   ",
" ...  ",
"    . ",
"    . ",
".   . ",
" ...  ",
"      ",
"      ",
"      "
},
{
"      ",
"      ",
"   .  ",
"   .  ",
"  ..  ",
" . .  ",
" . .  ",
".  .  ",
"..... ",
"   .  ",
"   .  ",
"      ",
"      ",
"      "
},
{
"      ",
"      ",
"..... ",
".     ",
".     ",
". ..  ",
"..  . ",
"    . ",
"    . ",
".   . ",
" ...  ",
"      ",
"      ",
"      "
},
{
"      ",
"      ",
" ...  ",
".   . ",
".     ",
".     ",
"....  ",
".   . ",
".   . ",
".   . ",
" ...  ",
"      ",
"      ",
"      "
},
{
"      ",
"      ",
"..... ",
"    . ",
"   .  ",
"   .  ",
"  .   ",
"  .   ",
" .    ",
" .    ",
" .    ",
"      ",
"      ",
"      "
},
{
"      ",
"      ",
" ...  ",
".   . ",
".   . ",
".   . ",
" ...  ",
".   . ",
".   . ",
".   . ",
" ...  ",
"      ",
"      ",
"      "
},
{
"      ",
"      ",
" ...  ",
".   . ",
".   . ",
".   . ",
" .... ",
"    . ",
"    . ",
".   . ",
" ...  ",
"      ",
"      ",
"      "
},
{
"      ",
"      ",
"      ",
"      ",
"  .   ",
" ...  ",
"  .   ",
"      ",
"      ",
"  .   ",
" ...  ",
"  .   ",
"      ",
"      "
},
{
"      ",
"      ",
"      ",
"      ",
"  .   ",
" ...  ",
"  .   ",
"      ",
"      ",
"  ..  ",
"  .   ",
" .    ",
"      ",
"      "
},
{
"      ",
"      ",
"    . ",
"   .  ",
"  .   ",
" .    ",
".     ",
" .    ",
"  .   ",
"   .  ",
"    . ",
"      ",
"      ",
"      "
},
{
"      ",
"      ",
"      ",
"      ",
"      ",
"..... ",
"      ",
"      ",
"..... ",
"      ",
"      ",
"      ",
"      ",
"      "
},
{
"      ",
"      ",
".     ",
" .    ",
"  .   ",
"   .  ",
"    . ",
"   .  ",
"  .   ",
" .    ",
".     ",
"      ",
"      ",
"      "
},
{
"      ",
"      ",
" ...  ",
".   . ",
".   . ",
"    . ",
"   .  ",
"  .   ",
"  .   ",
"      ",
"  .   ",
"      ",
"      ",
"      "
},
{
"      ",
"      ",
" ...  ",
".   . ",
".   . ",
".  .. ",
". . . ",
". . . ",
". ..  ",
".     ",
" .... ",
"      ",
"      ",
"      "
},
{
"      ",
"      ",
"  .   ",
" . .  ",
".   . ",
".   . ",
".   . ",
"..... ",
".   . ",
".   . ",
".   . ",
"      ",
"      ",
"      "
},
{
"      ",
"      ",
"....  ",
" .  . ",
" .  . ",
" .  . ",
" ...  ",
" .  . ",
" .  . ",
" .  . ",
"....  ",
"      ",
"      ",
"      "
},
{
"      ",
"      ",
" ...  ",
".   . ",
".     ",
".     ",
".     ",
".     ",
".     ",
".   . ",
" ...  ",
"      ",
"      ",
"      "
},
{
"      ",
"      ",
"....  ",
" .  . ",
" .  . ",
" .  . ",
" .  . ",
" .  . ",
" .  . ",
" .  . ",
"....  ",
"      ",
"      ",
"      "
},
{
"      ",
"      ",
"..... ",
".     ",
".     ",
".     ",
"....  ",
".     ",
".     ",
".     ",
"..... ",
"      ",
"      ",
"      "
},
{
"      ",
"      ",
"..... ",
".     ",
".     ",
".     ",
"....  ",
".     ",
".     ",
".     ",
".     ",
"      ",
"      ",
"      "
},
{
"      ",
"      ",
" ...  ",
".   . ",
".     ",
".     ",
".     ",
".  .. ",
".   . ",
".   . ",
" ...  ",
"      ",
"      ",
"      "
},
{
"      ",
"      ",
".   . ",
".   . ",
".   . ",
".   . ",
"..... ",
".   . ",
".   . ",
".   . ",
".   . ",
"      ",
"      ",
"      "
},
{
"      ",
"      ",
" ...  ",
"  .   ",
"  .   ",
"  .   ",
"  .   ",
"  .   ",
"  .   ",
"  .   ",
" ...  ",
"      ",
"      ",
"      "
},
{
"      ",
"      ",
"  ... ",
"   .  ",
"   .  ",
"   .  ",
"   .  ",
"   .  ",
"   .  ",
".  .  ",
" ..   ",
"      ",
"      ",
"      "
},
{
"      ",
"      ",
".   . ",
".   . ",
".  .  ",
". .   ",
"..    ",
". .   ",
".  .  ",
".   . ",
".   . ",
"      ",
"      ",
"      "
},
{
"      ",
"      ",
".     ",
".     ",
".     ",
".     ",
".     ",
".     ",
".     ",
".     ",
"..... ",
"      ",
"      ",
"      "
},
{
"      ",
"      ",
".   . ",
".   . ",
".. .. ",
". . . ",
". . . ",
".   . ",
".   . ",
".   . ",
".   . ",
"      ",
"      ",
"      "
},
{
"      ",
"      ",
".   . ",
"..  . ",
"..  . ",
". . . ",
". . . ",
".  .. ",
".  .. ",
".   . ",
".   . ",
"      ",
"      ",
"      "
},
{
"      ",
"      ",
" ...  ",
".   . ",
".   . ",
".   . ",
".   . ",
".   . ",
".   . ",
".   . ",
" ...  ",
"      ",
"      ",
"      "
},
{
"      ",
"      ",
"....  ",
".   . ",
".   . ",
".   . ",
"....  ",
".     ",
".     ",
".     ",
".     ",
"      ",
"      ",
"      "
},
{
"      ",
"      ",
" ...  ",
".   . ",
".   . ",
".   . ",
".   . ",
".   . ",
".   . ",
". . . ",
" ...  ",
"    . ",
"      ",
"      "
},
{
"      ",
"      ",
"....  ",
".   . ",
".   . ",
".   . ",
"....  ",
". .   ",
".  .  ",
".   . ",
".   . ",
"      ",
"      ",
"      "
},
{
"      ",
"      ",
" ...  ",
".   . ",
".     ",
".     ",
" ...  ",
"    . ",
"    . ",
".   . ",
" ...  ",
"      ",
"      ",
"      "
},
{
"      ",
"      ",
"..... ",
"  .   ",
"  .   ",
"  .   ",
"  .   ",
"  .   ",
"  .   ",
"  .   ",
"  .   ",
"      ",
"      ",
"      "
},
{
"      ",
"      ",
".   . ",
".   . ",
".   . ",
".   . ",
".   . ",
".   . ",
".   . ",
".   . ",
" ...  ",
"      ",
"      ",
"      "
},
{
"      ",
"      ",
".   . ",
".   . ",
".   . ",
".   . ",
" . .  ",
" . .  ",
" . .  ",
"  .   ",
"  .   ",
"      ",
"      ",
"      "
},
{
"      ",
"      ",
".   . ",
".   . ",
".   . ",
".   . ",
". . . ",
". . . ",
". . . ",
". . . ",
" . .  ",
"      ",
"      ",
"      "
},
{
"      ",
"      ",
".   . ",
".   . ",
" . .  ",
" . .  ",
"  .   ",
" . .  ",
" . .  ",
".   . ",
".   . ",
"      ",
"      ",
"      "
},
{
"      ",
"      ",
".   . ",
".   . ",
" . .  ",
" . .  ",
"  .   ",
"  .   ",
"  .   ",
"  .   ",
"  .   ",
"      ",
"      ",
"      "
},
{
"      ",
"      ",
"..... ",
"    . ",
"   .  ",
"   .  ",
"  .   ",
" .    ",
" .    ",
".     ",
"..... ",
"      ",
"      ",
"      "
},
{
"      ",
" ...  ",
" .    ",
" .    ",
" .    ",
" .    ",
" .    ",
" .    ",
" .    ",
" .    ",
" .    ",
" ...  ",
"      ",
"      "
},
{
"      ",
"      ",
".     ",
".     ",
" .    ",
" .    ",
"  .   ",
"   .  ",
"   .  ",
"    . ",
"    . ",
"      ",
"      ",
"      "
},
{
"      ",
" ...  ",
"   .  ",
"   .  ",
"   .  ",
"   .  ",
"   .  ",
"   .  ",
"   .  ",
"   .  ",
"   .  ",
" ...  ",
"      ",
"      "
},
{
"      ",
"      ",
"  .   ",
" . .  ",
".   . ",
"      ",
"      ",
"      ",
"      ",
"      ",
"      ",
"      ",
"      ",
"      "
},
{
"      ",
"      ",
"      ",
"      ",
"      ",
"      ",
"      ",
"      ",
"      ",
"      ",
"      ",
"..... ",
"      ",
"      "
},
{
"      ",
"  .   ",
"   .  ",
"      ",
"      ",
"      ",
"      ",
"      ",
"      ",
"      ",
"      ",
"      ",
"      ",
"      "
},
{
"      ",
"      ",
"      ",
"      ",
"      ",
" ...  ",
"    . ",
" .... ",
".   . ",
".  .. ",
" .. . ",
"      ",
"      ",
"      "
},
{
"      ",
"      ",
".     ",
".     ",
".     ",
"....  ",
".   . ",
".   . ",
".   . ",
".   . ",
"....  ",
"      ",
"      ",
"      "
},
{
"      ",
"      ",
"      ",
"      ",
"      ",
" ...  ",
".   . ",
".     ",
".     ",
".   . ",
" ...  ",
"      ",
"      ",
"      "
},
{
"      ",
"      ",
"    . ",
"    . ",
"    . ",
" .... ",
".   . ",
".   . ",
".   . ",
".   . ",
" .... ",
"      ",
"      ",
"      "
},
{
"      ",
"      ",
"      ",
"      ",
"      ",
" ...  ",
".   . ",
"..... ",
".     ",
".   . ",
" ...  ",
"      ",
"      ",
"      "
},
{
"      ",
"      ",
"  ..  ",
" .  . ",
" .    ",
" .    ",
"....  ",
" .    ",
" .    ",
" .    ",
" .    ",
"      ",
"      ",
"      "
},
{
"      ",
"      ",
"      ",
"      ",
"      ",
" ...  ",
".   . ",
".   . ",
".   . ",
" .... ",
"    . ",
".   . ",
" ...  ",
"      "
},
{
"      ",
"      ",
".     ",
".     ",
".     ",
". ..  ",
"..  . ",
".   . ",
".   . ",
".   . ",
".   . ",
"      ",
"      ",
"      "
},
{
"      ",
"      ",
"      ",
"  .   ",
"      ",
" ..   ",
"  .   ",
"  .   ",
"  .   ",
"  .   ",
" ...  ",
"      ",
"      ",
"      "
},
{
"      ",
"      ",
"      ",
"   .  ",
"      ",
"  ..  ",
"   .  ",
"   .  ",
"   .  ",
"   .  ",
".  .  ",
".  .  ",
" ..   ",
"      "
},
{
"      ",
"      ",
".     ",
".     ",
".     ",
".  .  ",
". .   ",
"..    ",
". .   ",
".  .  ",
".   . ",
"      ",
"      ",
"      "
},
{
"      ",
"      ",
" ..   ",
"  .   ",
"  .   ",
"  .   ",
"  .   ",
"  .   ",
"  .   ",
"  .   ",
" ...  ",
"      ",
"      ",
"      "
},
{
"      ",
"      ",
"      ",
"      ",
"      ",
".. .  ",
". . . ",
". . . ",
". . . ",
". . . ",
".   . ",
"      ",
"      ",
"      "
},
{
"      ",
"      ",
"      ",
"      ",
"      ",
". ..  ",
"..  . ",
".   . ",
".   . ",
".   . ",
".   . ",
"      ",
"      ",
"      "
},
{
"      ",
"      ",
"      ",
"      ",
"      ",
" ...  ",
".   . ",
".   . ",
".   . ",
".   . ",
" ...  ",
"      ",
"      ",
"      "
},
{
"      ",
"      ",
"      ",
"      ",
"      ",
"....  ",
".   . ",
".   . ",
".   . ",
"....  ",
".     ",
".     ",
".     ",
"      "
},
{
"      ",
"      ",
"      ",
"      ",
"      ",
" .... ",
".   . ",
".   . ",
".   . ",
" .... ",
"    . ",
"    . ",
"    . ",
"      "
},
{
"      ",
"      ",
"      ",
"      ",
"      ",
". ..  ",
"..  . ",
".     ",
".     ",
".     ",
".     ",
"      ",
"      ",
"      "
},
{
"      ",
"      ",
"      ",
"      ",
"      ",
" ...  ",
".   . ",
" ..   ",
"   .  ",
".   . ",
" ...  ",
"      ",
"      ",
"      "
},
{
"      ",
"      ",
"      ",
" .    ",
" .    ",
"....  ",
" .    ",
" .    ",
" .    ",
" .  . ",
"  ..  ",
"      ",
"      ",
"      "
},
{
"      ",
"      ",
"      ",
"      ",
"      ",
".   . ",
".   . ",
".   . ",
".   . ",
".  .. ",
" .. . ",
"      ",
"      ",
"      "
},
{
"      ",
"      ",
"      ",
"      ",
"      ",
".   . ",
".   . ",
".   . ",
" . .  ",
" . .  ",
"  .   ",
"      ",
"      ",
"      "
},
{
"      ",
"      ",
"      ",
"      ",
"      ",
".   . ",
".   . ",
". . . ",
". . . ",
". . . ",
" . .  ",
"      ",
"      ",
"      "
},
{
"      ",
"      ",
"      ",
"      ",
"      ",
".   . ",
" . .  ",
"  .   ",
"  .   ",
" . .  ",
".   . ",
"      ",
"      ",
"      "
},
{
"      ",
"      ",
"      ",
"      ",
"      ",
".   . ",
".   . ",
".   . ",
".  .. ",
" .. . ",
"    . ",
".   . ",
" ...  ",
"      "
},
{
"      ",
"      ",
"      ",
"      ",
"      ",
"..... ",
"   .  ",
"  .   ",
" .    ",
".     ",
"..... ",
"      ",
"      ",
"      "
},
{
"      ",
"   .. ",
"  .   ",
"  .   ",
"  .   ",
"  .   ",
"..    ",
"  .   ",
"  .   ",
"  .   ",
"  .   ",
"   .. ",
"      ",
"      "
},
{
"      ",
"      ",
"  .   ",
"  .   ",
"  .   ",
"  .   ",
"  .   ",
"  .   ",
"  .   ",
"  .   ",
"  .   ",
"      ",
"      ",
"      "
},
{
"      ",
"..    ",
"  .   ",
"  .   ",
"  .   ",
"  .   ",
"   .. ",
"  .   ",
"  .   ",
"  .   ",
"  .   ",
"..    ",
"      ",
"      "
},
{
"      ",
"      ",
" .  . ",
". . . ",
".  .  ",
"      ",
"      ",
"      ",
"      ",
"      ",
"      ",
"      ",
"      ",
"      "
},
}; 

char Font_data::get_field(int letter,int x,int y) {
	int index=letter-33;
	if (index<0||index>94) { return ' '; }
	if (x<0) return ' ';
	if (x>=dx()) return ' ';

	if (y<0) return ' ';
	if (y>=dy()) return ' ';

	const char *str=font_all[index][y];
	char r;
	r=str[x];
	return r;
}

