/////////////////////////////////////////////////////////////
//                                                         //
// Copyright (c) 2003-2013 by The University of Queensland //
// Earth Systems Science Computational Centre (ESSCC)      //
// http://www.uq.edu.au/esscc                              //
//                                                         //
// Primary Business: Brisbane, Queensland, Australia       //
// Licensed under the Open Software License version 3.0    //
// http://www.opensource.org/licenses/osl-3.0.php          //
//                                                         //
/////////////////////////////////////////////////////////////

#ifndef __VECTOR_TRIANGLE_FIELD_SLAVE_H
#define __VECTOR_TRIANGLE_FIELD_SLAVE_H

// -- project includes --
#include "Fields/FieldSlave.h"
#include "Model/TriMesh.h"
#include "tml/comm/comm.h"

// == STL includes --
#include <map>
using std::map;
using std::multimap;

/*!
  \class VectorTriangleFieldSlave
  \brief Slave part for saving a vector field defined on the triangles
  in a given TriMesh

  \author Steffen Abe
  $Date$
  $Revision$
*/
class VectorTriangleFieldSlave : public AFieldSlave
{
 private:
  map<int,Vec3>  m_data;
 protected: 
  TriMesh *m_mesh;
  Triangle::VectorFieldFunction m_rdf;
  virtual void SendDataFull();
  virtual void SendDataFullDX();

 public:
  VectorTriangleFieldSlave(TML_Comm*,TriMesh*,Triangle::VectorFieldFunction);

  virtual ~VectorTriangleFieldSlave()
  {
  }
  
  virtual void sendData();
};

#endif // __VECTOR_TRIANGLE_FIELD_SLAVE_H
