/*
 Falselogin by Tibor Koleszar <oldw@debian.org> GNU/GPL
 Further development made by Jose Parrella <joseparrella@cantv.net>
*/
#define _GNU_SOURCE
#include <stdio.h>
#include <publib.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <pwd.h>
#include <sys/types.h>
#include <sys/utsname.h>

// This is the maximum length of line buffers for
// configuration files and mailbox files.
#define MAXLEN_BUF 1024

// This is the maximum length of the user names.
#define MAXLEN_USERNAME 50

// This is the default configuration file on Debian,
// attending to FHS.
#define CONFIG_FILE "/etc/falselogin.conf"

// This is the default pattern for counting messages
// in a mailbox.
#define MESSAGE_ID "Message-ID"

// Maximum length for the hostname
#define MAXLEN_HOSTNAME 512

// Maximum length for the Debian version information
#define MAXLEN_DEBVER 50

// Maximum length for quantity of mails
#define MAIL_LEN 50

// Function definitions
int readArgs (char *argv[]);
int countMail (char userName[]);

int main (int argc, char *argv[]) {
	FILE *f, *g;					// f will hold the configuration file
	struct passwd *pwd;				// this holds the pwent
	char s_mail[MAIL_LEN];				// length of mail number
	char *temp, host_n[MAXLEN_HOSTNAME], 
	deb_ver[MAXLEN_DEBVER] = "";			// temp will hold a conffile line
	struct utsname u_name;				// this holds the u_name
	size_t max_buf = MAXLEN_BUF;			// maximum buffer length
	int ok = 0;					// lame control (see passwd filling)

	temp = malloc(MAXLEN_BUF);			// initial allocation (could happen later)
							// thou shalt not cast

	// This fills the passwd struct with the
	// pwent until it ends.
	// (it might be a better way)
	while (!ok) {
		pwd = getpwent ();
		if (pwd->pw_uid == getuid ())
			ok = 1;
	}
	
	// This fills the uname struct with the
	// data and exits if it fails.
	if (uname ((struct utsname *) &u_name) == -1) {
		perror ("Error at calling uname()");
		exit (EXIT_FAILURE);
	}
	
	// Proceeds to open the configuration
	// file specified as a macro constant.
	if ((f = fopen (CONFIG_FILE, "rt")) == NULL) {
		perror ("Can't parse config file");
		exit (EXIT_FAILURE);
	}

	// While we have fun...
	while (!feof (f)) {
		// Main iteration
		// f: The opened CONFIG_FILE in rt mode.
		// &temp: A line, taken from the CONFIG_FILE
		// &max_buf: A reference to the maximum buffer length

		// Now I reset the buffer size
		// (but I don't really resize &temp)
		max_buf = MAXLEN_BUF;

		// This does the same that fgets (temp, 1024, f) does in less iterations,
		// but with a variable buffer size.
		if (getline (&temp, &max_buf, f) == -1) {
			continue;
		}

		// If we still have something to work on...
		// ...and this is not a comment
		if (!feof (f) && strncmp(temp, "#", 1)) {

			// Substitutions follows: they happen on the temp
			// buffer which is 1024 bytes long, so only 1023
			// characters will be allowed.

			// Substitutions using passwd and uname structs

			if (strstr (temp, "%user%") != NULL)
				strgsub (temp, "%user%", pwd->pw_name, max_buf);

			if (strstr (temp, "%sysname%") != NULL)
				strgsub (temp, "%sysname%", u_name.sysname, max_buf);

			if (strstr (temp, "%nodename%") != NULL)
				strgsub (temp, "%nodename%", u_name.nodename, max_buf);

			if (strstr (temp, "%release%") != NULL)
				strgsub (temp, "%release%", u_name.release, max_buf);

			if (strstr (temp, "%version%") != NULL)
				strgsub (temp, "%version%", u_name.version, max_buf);

			if (strstr (temp, "%machine%") != NULL)
				strgsub (temp, "%machine%", u_name.machine, max_buf);

			// Self-contained substitutions

			if (strstr (temp, "%host%") != NULL) {
				gethostname(host_n, MAXLEN_HOSTNAME);
				strgsub (temp, "%host%", host_n, max_buf);
			}

			if (strstr (temp, "%mail%") != NULL) {
				snprintf (s_mail, MAXLEN_BUF, "%d", countMail(pwd->pw_name)); 
				strgsub (temp, "%mail%", s_mail, max_buf);
			}

			if (strstr (temp, "%debian_version%") != NULL) {
				if ((g = fopen ("/etc/debian_version", "rt")) != NULL) {
					fgets(deb_ver, sizeof(deb_ver), g);
					if (*deb_ver && deb_ver[strlen(deb_ver)-1] == '\n')
						deb_ver[strlen(deb_ver)-1] = 0;
					fclose(g);
				};
				strgsub (temp, "%debian_version%", deb_ver, max_buf);
			}
		
			// Prints the new line with substitutions

			printf ("%s", temp);
		}

	}

	// Closes the configuration file after the feof
	fclose (f);

	// Frees the buffer
	free (temp);

	// Now we can check the arguments
	if (argc > 2) {
		if (readArgs(argv) == 255) {
			printf("Unknown arguments were given\n");
		}
	}
	else if (argc > 3 || argc == 2) {
		printf("Wrong number of arguments given\n");
		exit(EXIT_FAILURE);
	}

	// Bye-bye if we don't have arguments
	exit(EXIT_SUCCESS);
}

int countMail (char userName[MAXLEN_USERNAME]) {
	int total = 0;
	char *temp;
	FILE *f;

	temp = (char *) malloc (MAXLEN_BUF);
	snprintf (temp, MAXLEN_BUF, "/var/mail/%s", userName);

	if ( (f = fopen (temp, "rt")) != NULL) {
		while (!feof (f)) {
			fgets (temp, MAXLEN_BUF, f);
			if (!strncasecmp (temp, MESSAGE_ID, strlen (MESSAGE_ID)))
				total++;
		}
		fclose (f);
	}

	return total;
}

int readArgs (char *argv[]) {
	if ( !strncmp(argv[1], "--wait", 6) || !strncmp(argv[1], "-w", 2) ) {
		if ( !strncmp(argv[2], "enter", 5) )
			while (getchar() != '\n');
		else if ( atol(argv[2]) > 0 ) 
			sleep(atol(argv[2]));
	}
	else {
		return 255;
	}
	return 1;
}
