// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file unions.hpp
 * This header file contains the declaration of the described types in the IDL file.
 *
 * This file was generated by the tool fastddsgen (version: 4.1.0).
 */

#ifndef FAST_DDS_GENERATED__UNIONS_HPP
#define FAST_DDS_GENERATED__UNIONS_HPP

#include <cstdint>
#include <functional>
#include <map>
#include <string>
#include <utility>
#include <vector>

#include <fastcdr/cdr/fixed_size_string.hpp>
#include <fastcdr/exceptions/BadParamException.h>

#include "helpers/basic_inner_types.hpp"

#if defined(_WIN32)
#if defined(EPROSIMA_USER_DLL_EXPORT)
#define eProsima_user_DllExport __declspec( dllexport )
#else
#define eProsima_user_DllExport
#endif  // EPROSIMA_USER_DLL_EXPORT
#else
#define eProsima_user_DllExport
#endif  // _WIN32

#if defined(_WIN32)
#if defined(EPROSIMA_USER_DLL_EXPORT)
#if defined(UNIONS_SOURCE)
#define UNIONS_DllAPI __declspec( dllexport )
#else
#define UNIONS_DllAPI __declspec( dllimport )
#endif // UNIONS_SOURCE
#else
#define UNIONS_DllAPI
#endif  // EPROSIMA_USER_DLL_EXPORT
#else
#define UNIONS_DllAPI
#endif // _WIN32

namespace Fixed_String_Module {

typedef eprosima::fastcdr::fixed_string<20> fixed_string_in_module;


} // namespace Fixed_String_Module
/*!
 * @brief This class represents the union Union_Short defined by the user in the IDL file.
 * @ingroup unions
 */
class Union_Short
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Union_Short()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Union_Short()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Union_Short that will be copied.
     */
    eProsima_user_DllExport Union_Short(
            const Union_Short& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            a_() = x.m_a;
                            break;

        }
    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Union_Short that will be copied.
     */
    eProsima_user_DllExport Union_Short(
            Union_Short&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            a_() = std::move(x.m_a);
                            break;

        }
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Union_Short that will be copied.
     */
    eProsima_user_DllExport Union_Short& operator =(
            const Union_Short& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            a_() = x.m_a;
                            break;

        }

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Union_Short that will be copied.
     */
    eProsima_user_DllExport Union_Short& operator =(
            Union_Short&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            a_() = std::move(x.m_a);
                            break;

        }

        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Union_Short object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Union_Short& x) const
    {
        bool ret_value {false};

        if (x.selected_member_ == selected_member_)
        {
            if (0x0FFFFFFFu != selected_member_)
            {
                if (x.m__d == m__d)
                {
                    switch (selected_member_)
                    {
                                                    case 0x00000001:
                                                        ret_value = (x.m_a == m_a);
                                                        break;

                    }
                }
            }
            else
            {
                ret_value = true;
            }
        }

        return ret_value;
    }

    /*!
     * @brief Comparison operator.
     * @param x Union_Short object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Union_Short& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets the discriminator value.
     * @param __d New value for the discriminator.
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the new value doesn't correspond to the selected union member.
     */
    eProsima_user_DllExport void _d(
            int32_t __d)
    {
        bool valid_discriminator = false;

        switch (__d)
        {
                        case 0:
                            if (0x00000001 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

        }

        if (!valid_discriminator)
        {
            throw eprosima::fastcdr::exception::BadParamException("Discriminator doesn't correspond with the selected union member");
        }

        m__d = __d;
    }

    /*!
     * @brief This function returns the value of the discriminator.
     * @return Value of the discriminator
     */
    eProsima_user_DllExport int32_t _d() const
    {
        return m__d;
    }

    /*!
     * @brief This function sets a value in member a
     * @param _a New value for member a
     */
    eProsima_user_DllExport void a(
            int16_t _a)
    {
        a_() = _a;
        m__d = 0;
    }

    /*!
     * @brief This function returns the value of member a
     * @return Value of member a
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int16_t a() const
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_a;
    }

    /*!
     * @brief This function returns a reference to member a
     * @return Reference to member a
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int16_t& a()
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_a;
    }


    void _default()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }

        selected_member_ = 0x0FFFFFFFu;
    }


private:

            int16_t& a_()
            {
                if (0x00000001 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000001;
                    member_destructor_ = nullptr;
                    m_a = {0};

                }

                return m_a;
            }


    int32_t m__d {2147483647};

    union
    {
        int16_t m_a;
    };

    uint32_t selected_member_ {0x0FFFFFFFu};

    std::function<void()> member_destructor_;
};
/*!
 * @brief This class represents the union Union_UShort defined by the user in the IDL file.
 * @ingroup unions
 */
class Union_UShort
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Union_UShort()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Union_UShort()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Union_UShort that will be copied.
     */
    eProsima_user_DllExport Union_UShort(
            const Union_UShort& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            b_() = x.m_b;
                            break;

        }
    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Union_UShort that will be copied.
     */
    eProsima_user_DllExport Union_UShort(
            Union_UShort&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            b_() = std::move(x.m_b);
                            break;

        }
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Union_UShort that will be copied.
     */
    eProsima_user_DllExport Union_UShort& operator =(
            const Union_UShort& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            b_() = x.m_b;
                            break;

        }

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Union_UShort that will be copied.
     */
    eProsima_user_DllExport Union_UShort& operator =(
            Union_UShort&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            b_() = std::move(x.m_b);
                            break;

        }

        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Union_UShort object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Union_UShort& x) const
    {
        bool ret_value {false};

        if (x.selected_member_ == selected_member_)
        {
            if (0x0FFFFFFFu != selected_member_)
            {
                if (x.m__d == m__d)
                {
                    switch (selected_member_)
                    {
                                                    case 0x00000001:
                                                        ret_value = (x.m_b == m_b);
                                                        break;

                    }
                }
            }
            else
            {
                ret_value = true;
            }
        }

        return ret_value;
    }

    /*!
     * @brief Comparison operator.
     * @param x Union_UShort object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Union_UShort& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets the discriminator value.
     * @param __d New value for the discriminator.
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the new value doesn't correspond to the selected union member.
     */
    eProsima_user_DllExport void _d(
            int32_t __d)
    {
        bool valid_discriminator = false;

        switch (__d)
        {
                        case 1:
                            if (0x00000001 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

        }

        if (!valid_discriminator)
        {
            throw eprosima::fastcdr::exception::BadParamException("Discriminator doesn't correspond with the selected union member");
        }

        m__d = __d;
    }

    /*!
     * @brief This function returns the value of the discriminator.
     * @return Value of the discriminator
     */
    eProsima_user_DllExport int32_t _d() const
    {
        return m__d;
    }

    /*!
     * @brief This function sets a value in member b
     * @param _b New value for member b
     */
    eProsima_user_DllExport void b(
            uint16_t _b)
    {
        b_() = _b;
        m__d = 1;
    }

    /*!
     * @brief This function returns the value of member b
     * @return Value of member b
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport uint16_t b() const
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_b;
    }

    /*!
     * @brief This function returns a reference to member b
     * @return Reference to member b
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport uint16_t& b()
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_b;
    }


    void _default()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }

        selected_member_ = 0x0FFFFFFFu;
    }


private:

            uint16_t& b_()
            {
                if (0x00000001 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000001;
                    member_destructor_ = nullptr;
                    m_b = {0};

                }

                return m_b;
            }


    int32_t m__d {2147483647};

    union
    {
        uint16_t m_b;
    };

    uint32_t selected_member_ {0x0FFFFFFFu};

    std::function<void()> member_destructor_;
};
/*!
 * @brief This class represents the union Union_Long defined by the user in the IDL file.
 * @ingroup unions
 */
class Union_Long
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Union_Long()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Union_Long()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Union_Long that will be copied.
     */
    eProsima_user_DllExport Union_Long(
            const Union_Long& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            c_() = x.m_c;
                            break;

        }
    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Union_Long that will be copied.
     */
    eProsima_user_DllExport Union_Long(
            Union_Long&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            c_() = std::move(x.m_c);
                            break;

        }
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Union_Long that will be copied.
     */
    eProsima_user_DllExport Union_Long& operator =(
            const Union_Long& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            c_() = x.m_c;
                            break;

        }

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Union_Long that will be copied.
     */
    eProsima_user_DllExport Union_Long& operator =(
            Union_Long&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            c_() = std::move(x.m_c);
                            break;

        }

        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Union_Long object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Union_Long& x) const
    {
        bool ret_value {false};

        if (x.selected_member_ == selected_member_)
        {
            if (0x0FFFFFFFu != selected_member_)
            {
                if (x.m__d == m__d)
                {
                    switch (selected_member_)
                    {
                                                    case 0x00000001:
                                                        ret_value = (x.m_c == m_c);
                                                        break;

                    }
                }
            }
            else
            {
                ret_value = true;
            }
        }

        return ret_value;
    }

    /*!
     * @brief Comparison operator.
     * @param x Union_Long object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Union_Long& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets the discriminator value.
     * @param __d New value for the discriminator.
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the new value doesn't correspond to the selected union member.
     */
    eProsima_user_DllExport void _d(
            int32_t __d)
    {
        bool valid_discriminator = false;

        switch (__d)
        {
                        case 2:
                            if (0x00000001 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

        }

        if (!valid_discriminator)
        {
            throw eprosima::fastcdr::exception::BadParamException("Discriminator doesn't correspond with the selected union member");
        }

        m__d = __d;
    }

    /*!
     * @brief This function returns the value of the discriminator.
     * @return Value of the discriminator
     */
    eProsima_user_DllExport int32_t _d() const
    {
        return m__d;
    }

    /*!
     * @brief This function sets a value in member c
     * @param _c New value for member c
     */
    eProsima_user_DllExport void c(
            int32_t _c)
    {
        c_() = _c;
        m__d = 2;
    }

    /*!
     * @brief This function returns the value of member c
     * @return Value of member c
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int32_t c() const
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_c;
    }

    /*!
     * @brief This function returns a reference to member c
     * @return Reference to member c
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int32_t& c()
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_c;
    }


    void _default()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }

        selected_member_ = 0x0FFFFFFFu;
    }


private:

            int32_t& c_()
            {
                if (0x00000001 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000001;
                    member_destructor_ = nullptr;
                    m_c = {0};

                }

                return m_c;
            }


    int32_t m__d {2147483647};

    union
    {
        int32_t m_c;
    };

    uint32_t selected_member_ {0x0FFFFFFFu};

    std::function<void()> member_destructor_;
};
/*!
 * @brief This class represents the union Union_ULong defined by the user in the IDL file.
 * @ingroup unions
 */
class Union_ULong
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Union_ULong()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Union_ULong()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Union_ULong that will be copied.
     */
    eProsima_user_DllExport Union_ULong(
            const Union_ULong& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            d_() = x.m_d;
                            break;

        }
    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Union_ULong that will be copied.
     */
    eProsima_user_DllExport Union_ULong(
            Union_ULong&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            d_() = std::move(x.m_d);
                            break;

        }
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Union_ULong that will be copied.
     */
    eProsima_user_DllExport Union_ULong& operator =(
            const Union_ULong& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            d_() = x.m_d;
                            break;

        }

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Union_ULong that will be copied.
     */
    eProsima_user_DllExport Union_ULong& operator =(
            Union_ULong&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            d_() = std::move(x.m_d);
                            break;

        }

        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Union_ULong object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Union_ULong& x) const
    {
        bool ret_value {false};

        if (x.selected_member_ == selected_member_)
        {
            if (0x0FFFFFFFu != selected_member_)
            {
                if (x.m__d == m__d)
                {
                    switch (selected_member_)
                    {
                                                    case 0x00000001:
                                                        ret_value = (x.m_d == m_d);
                                                        break;

                    }
                }
            }
            else
            {
                ret_value = true;
            }
        }

        return ret_value;
    }

    /*!
     * @brief Comparison operator.
     * @param x Union_ULong object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Union_ULong& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets the discriminator value.
     * @param __d New value for the discriminator.
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the new value doesn't correspond to the selected union member.
     */
    eProsima_user_DllExport void _d(
            int32_t __d)
    {
        bool valid_discriminator = false;

        switch (__d)
        {
                        case 3:
                            if (0x00000001 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

        }

        if (!valid_discriminator)
        {
            throw eprosima::fastcdr::exception::BadParamException("Discriminator doesn't correspond with the selected union member");
        }

        m__d = __d;
    }

    /*!
     * @brief This function returns the value of the discriminator.
     * @return Value of the discriminator
     */
    eProsima_user_DllExport int32_t _d() const
    {
        return m__d;
    }

    /*!
     * @brief This function sets a value in member d
     * @param _d New value for member d
     */
    eProsima_user_DllExport void d(
            uint32_t _d)
    {
        d_() = _d;
        m__d = 3;
    }

    /*!
     * @brief This function returns the value of member d
     * @return Value of member d
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport uint32_t d() const
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_d;
    }

    /*!
     * @brief This function returns a reference to member d
     * @return Reference to member d
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport uint32_t& d()
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_d;
    }


    void _default()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }

        selected_member_ = 0x0FFFFFFFu;
    }


private:

            uint32_t& d_()
            {
                if (0x00000001 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000001;
                    member_destructor_ = nullptr;
                    m_d = {0};

                }

                return m_d;
            }


    int32_t m__d {2147483647};

    union
    {
        uint32_t m_d;
    };

    uint32_t selected_member_ {0x0FFFFFFFu};

    std::function<void()> member_destructor_;
};
/*!
 * @brief This class represents the union Union_LongLong defined by the user in the IDL file.
 * @ingroup unions
 */
class Union_LongLong
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Union_LongLong()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Union_LongLong()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Union_LongLong that will be copied.
     */
    eProsima_user_DllExport Union_LongLong(
            const Union_LongLong& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            e_() = x.m_e;
                            break;

        }
    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Union_LongLong that will be copied.
     */
    eProsima_user_DllExport Union_LongLong(
            Union_LongLong&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            e_() = std::move(x.m_e);
                            break;

        }
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Union_LongLong that will be copied.
     */
    eProsima_user_DllExport Union_LongLong& operator =(
            const Union_LongLong& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            e_() = x.m_e;
                            break;

        }

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Union_LongLong that will be copied.
     */
    eProsima_user_DllExport Union_LongLong& operator =(
            Union_LongLong&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            e_() = std::move(x.m_e);
                            break;

        }

        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Union_LongLong object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Union_LongLong& x) const
    {
        bool ret_value {false};

        if (x.selected_member_ == selected_member_)
        {
            if (0x0FFFFFFFu != selected_member_)
            {
                if (x.m__d == m__d)
                {
                    switch (selected_member_)
                    {
                                                    case 0x00000001:
                                                        ret_value = (x.m_e == m_e);
                                                        break;

                    }
                }
            }
            else
            {
                ret_value = true;
            }
        }

        return ret_value;
    }

    /*!
     * @brief Comparison operator.
     * @param x Union_LongLong object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Union_LongLong& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets the discriminator value.
     * @param __d New value for the discriminator.
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the new value doesn't correspond to the selected union member.
     */
    eProsima_user_DllExport void _d(
            int32_t __d)
    {
        bool valid_discriminator = false;

        switch (__d)
        {
                        case 4:
                            if (0x00000001 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

        }

        if (!valid_discriminator)
        {
            throw eprosima::fastcdr::exception::BadParamException("Discriminator doesn't correspond with the selected union member");
        }

        m__d = __d;
    }

    /*!
     * @brief This function returns the value of the discriminator.
     * @return Value of the discriminator
     */
    eProsima_user_DllExport int32_t _d() const
    {
        return m__d;
    }

    /*!
     * @brief This function sets a value in member e
     * @param _e New value for member e
     */
    eProsima_user_DllExport void e(
            int64_t _e)
    {
        e_() = _e;
        m__d = 4;
    }

    /*!
     * @brief This function returns the value of member e
     * @return Value of member e
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int64_t e() const
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_e;
    }

    /*!
     * @brief This function returns a reference to member e
     * @return Reference to member e
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int64_t& e()
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_e;
    }


    void _default()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }

        selected_member_ = 0x0FFFFFFFu;
    }


private:

            int64_t& e_()
            {
                if (0x00000001 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000001;
                    member_destructor_ = nullptr;
                    m_e = {0};

                }

                return m_e;
            }


    int32_t m__d {2147483647};

    union
    {
        int64_t m_e;
    };

    uint32_t selected_member_ {0x0FFFFFFFu};

    std::function<void()> member_destructor_;
};
/*!
 * @brief This class represents the union Union_ULongLOng defined by the user in the IDL file.
 * @ingroup unions
 */
class Union_ULongLOng
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Union_ULongLOng()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Union_ULongLOng()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Union_ULongLOng that will be copied.
     */
    eProsima_user_DllExport Union_ULongLOng(
            const Union_ULongLOng& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            f_() = x.m_f;
                            break;

        }
    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Union_ULongLOng that will be copied.
     */
    eProsima_user_DllExport Union_ULongLOng(
            Union_ULongLOng&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            f_() = std::move(x.m_f);
                            break;

        }
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Union_ULongLOng that will be copied.
     */
    eProsima_user_DllExport Union_ULongLOng& operator =(
            const Union_ULongLOng& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            f_() = x.m_f;
                            break;

        }

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Union_ULongLOng that will be copied.
     */
    eProsima_user_DllExport Union_ULongLOng& operator =(
            Union_ULongLOng&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            f_() = std::move(x.m_f);
                            break;

        }

        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Union_ULongLOng object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Union_ULongLOng& x) const
    {
        bool ret_value {false};

        if (x.selected_member_ == selected_member_)
        {
            if (0x0FFFFFFFu != selected_member_)
            {
                if (x.m__d == m__d)
                {
                    switch (selected_member_)
                    {
                                                    case 0x00000001:
                                                        ret_value = (x.m_f == m_f);
                                                        break;

                    }
                }
            }
            else
            {
                ret_value = true;
            }
        }

        return ret_value;
    }

    /*!
     * @brief Comparison operator.
     * @param x Union_ULongLOng object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Union_ULongLOng& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets the discriminator value.
     * @param __d New value for the discriminator.
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the new value doesn't correspond to the selected union member.
     */
    eProsima_user_DllExport void _d(
            int32_t __d)
    {
        bool valid_discriminator = false;

        switch (__d)
        {
                        case 5:
                            if (0x00000001 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

        }

        if (!valid_discriminator)
        {
            throw eprosima::fastcdr::exception::BadParamException("Discriminator doesn't correspond with the selected union member");
        }

        m__d = __d;
    }

    /*!
     * @brief This function returns the value of the discriminator.
     * @return Value of the discriminator
     */
    eProsima_user_DllExport int32_t _d() const
    {
        return m__d;
    }

    /*!
     * @brief This function sets a value in member f
     * @param _f New value for member f
     */
    eProsima_user_DllExport void f(
            uint64_t _f)
    {
        f_() = _f;
        m__d = 5;
    }

    /*!
     * @brief This function returns the value of member f
     * @return Value of member f
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport uint64_t f() const
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_f;
    }

    /*!
     * @brief This function returns a reference to member f
     * @return Reference to member f
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport uint64_t& f()
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_f;
    }


    void _default()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }

        selected_member_ = 0x0FFFFFFFu;
    }


private:

            uint64_t& f_()
            {
                if (0x00000001 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000001;
                    member_destructor_ = nullptr;
                    m_f = {0};

                }

                return m_f;
            }


    int32_t m__d {2147483647};

    union
    {
        uint64_t m_f;
    };

    uint32_t selected_member_ {0x0FFFFFFFu};

    std::function<void()> member_destructor_;
};
/*!
 * @brief This class represents the union Union_Float defined by the user in the IDL file.
 * @ingroup unions
 */
class Union_Float
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Union_Float()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Union_Float()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Union_Float that will be copied.
     */
    eProsima_user_DllExport Union_Float(
            const Union_Float& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            g_() = x.m_g;
                            break;

        }
    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Union_Float that will be copied.
     */
    eProsima_user_DllExport Union_Float(
            Union_Float&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            g_() = std::move(x.m_g);
                            break;

        }
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Union_Float that will be copied.
     */
    eProsima_user_DllExport Union_Float& operator =(
            const Union_Float& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            g_() = x.m_g;
                            break;

        }

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Union_Float that will be copied.
     */
    eProsima_user_DllExport Union_Float& operator =(
            Union_Float&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            g_() = std::move(x.m_g);
                            break;

        }

        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Union_Float object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Union_Float& x) const
    {
        bool ret_value {false};

        if (x.selected_member_ == selected_member_)
        {
            if (0x0FFFFFFFu != selected_member_)
            {
                if (x.m__d == m__d)
                {
                    switch (selected_member_)
                    {
                                                    case 0x00000001:
                                                        ret_value = (x.m_g == m_g);
                                                        break;

                    }
                }
            }
            else
            {
                ret_value = true;
            }
        }

        return ret_value;
    }

    /*!
     * @brief Comparison operator.
     * @param x Union_Float object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Union_Float& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets the discriminator value.
     * @param __d New value for the discriminator.
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the new value doesn't correspond to the selected union member.
     */
    eProsima_user_DllExport void _d(
            int32_t __d)
    {
        bool valid_discriminator = false;

        switch (__d)
        {
                        case 6:
                            if (0x00000001 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

        }

        if (!valid_discriminator)
        {
            throw eprosima::fastcdr::exception::BadParamException("Discriminator doesn't correspond with the selected union member");
        }

        m__d = __d;
    }

    /*!
     * @brief This function returns the value of the discriminator.
     * @return Value of the discriminator
     */
    eProsima_user_DllExport int32_t _d() const
    {
        return m__d;
    }

    /*!
     * @brief This function sets a value in member g
     * @param _g New value for member g
     */
    eProsima_user_DllExport void g(
            float _g)
    {
        g_() = _g;
        m__d = 6;
    }

    /*!
     * @brief This function returns the value of member g
     * @return Value of member g
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport float g() const
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_g;
    }

    /*!
     * @brief This function returns a reference to member g
     * @return Reference to member g
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport float& g()
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_g;
    }


    void _default()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }

        selected_member_ = 0x0FFFFFFFu;
    }


private:

            float& g_()
            {
                if (0x00000001 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000001;
                    member_destructor_ = nullptr;
                    m_g = {0.0};

                }

                return m_g;
            }


    int32_t m__d {2147483647};

    union
    {
        float m_g;
    };

    uint32_t selected_member_ {0x0FFFFFFFu};

    std::function<void()> member_destructor_;
};
/*!
 * @brief This class represents the union Union_Double defined by the user in the IDL file.
 * @ingroup unions
 */
class Union_Double
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Union_Double()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Union_Double()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Union_Double that will be copied.
     */
    eProsima_user_DllExport Union_Double(
            const Union_Double& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            h_() = x.m_h;
                            break;

        }
    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Union_Double that will be copied.
     */
    eProsima_user_DllExport Union_Double(
            Union_Double&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            h_() = std::move(x.m_h);
                            break;

        }
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Union_Double that will be copied.
     */
    eProsima_user_DllExport Union_Double& operator =(
            const Union_Double& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            h_() = x.m_h;
                            break;

        }

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Union_Double that will be copied.
     */
    eProsima_user_DllExport Union_Double& operator =(
            Union_Double&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            h_() = std::move(x.m_h);
                            break;

        }

        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Union_Double object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Union_Double& x) const
    {
        bool ret_value {false};

        if (x.selected_member_ == selected_member_)
        {
            if (0x0FFFFFFFu != selected_member_)
            {
                if (x.m__d == m__d)
                {
                    switch (selected_member_)
                    {
                                                    case 0x00000001:
                                                        ret_value = (x.m_h == m_h);
                                                        break;

                    }
                }
            }
            else
            {
                ret_value = true;
            }
        }

        return ret_value;
    }

    /*!
     * @brief Comparison operator.
     * @param x Union_Double object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Union_Double& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets the discriminator value.
     * @param __d New value for the discriminator.
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the new value doesn't correspond to the selected union member.
     */
    eProsima_user_DllExport void _d(
            int32_t __d)
    {
        bool valid_discriminator = false;

        switch (__d)
        {
                        case 7:
                            if (0x00000001 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

        }

        if (!valid_discriminator)
        {
            throw eprosima::fastcdr::exception::BadParamException("Discriminator doesn't correspond with the selected union member");
        }

        m__d = __d;
    }

    /*!
     * @brief This function returns the value of the discriminator.
     * @return Value of the discriminator
     */
    eProsima_user_DllExport int32_t _d() const
    {
        return m__d;
    }

    /*!
     * @brief This function sets a value in member h
     * @param _h New value for member h
     */
    eProsima_user_DllExport void h(
            double _h)
    {
        h_() = _h;
        m__d = 7;
    }

    /*!
     * @brief This function returns the value of member h
     * @return Value of member h
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport double h() const
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_h;
    }

    /*!
     * @brief This function returns a reference to member h
     * @return Reference to member h
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport double& h()
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_h;
    }


    void _default()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }

        selected_member_ = 0x0FFFFFFFu;
    }


private:

            double& h_()
            {
                if (0x00000001 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000001;
                    member_destructor_ = nullptr;
                    m_h = {0.0};

                }

                return m_h;
            }


    int32_t m__d {2147483647};

    union
    {
        double m_h;
    };

    uint32_t selected_member_ {0x0FFFFFFFu};

    std::function<void()> member_destructor_;
};
/*!
 * @brief This class represents the union Union_LongDouble defined by the user in the IDL file.
 * @ingroup unions
 */
class Union_LongDouble
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Union_LongDouble()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Union_LongDouble()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Union_LongDouble that will be copied.
     */
    eProsima_user_DllExport Union_LongDouble(
            const Union_LongDouble& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            i_() = x.m_i;
                            break;

        }
    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Union_LongDouble that will be copied.
     */
    eProsima_user_DllExport Union_LongDouble(
            Union_LongDouble&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            i_() = std::move(x.m_i);
                            break;

        }
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Union_LongDouble that will be copied.
     */
    eProsima_user_DllExport Union_LongDouble& operator =(
            const Union_LongDouble& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            i_() = x.m_i;
                            break;

        }

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Union_LongDouble that will be copied.
     */
    eProsima_user_DllExport Union_LongDouble& operator =(
            Union_LongDouble&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            i_() = std::move(x.m_i);
                            break;

        }

        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Union_LongDouble object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Union_LongDouble& x) const
    {
        bool ret_value {false};

        if (x.selected_member_ == selected_member_)
        {
            if (0x0FFFFFFFu != selected_member_)
            {
                if (x.m__d == m__d)
                {
                    switch (selected_member_)
                    {
                                                    case 0x00000001:
                                                        ret_value = (x.m_i == m_i);
                                                        break;

                    }
                }
            }
            else
            {
                ret_value = true;
            }
        }

        return ret_value;
    }

    /*!
     * @brief Comparison operator.
     * @param x Union_LongDouble object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Union_LongDouble& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets the discriminator value.
     * @param __d New value for the discriminator.
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the new value doesn't correspond to the selected union member.
     */
    eProsima_user_DllExport void _d(
            int32_t __d)
    {
        bool valid_discriminator = false;

        switch (__d)
        {
                        case 8:
                            if (0x00000001 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

        }

        if (!valid_discriminator)
        {
            throw eprosima::fastcdr::exception::BadParamException("Discriminator doesn't correspond with the selected union member");
        }

        m__d = __d;
    }

    /*!
     * @brief This function returns the value of the discriminator.
     * @return Value of the discriminator
     */
    eProsima_user_DllExport int32_t _d() const
    {
        return m__d;
    }

    /*!
     * @brief This function sets a value in member i
     * @param _i New value for member i
     */
    eProsima_user_DllExport void i(
            long double _i)
    {
        i_() = _i;
        m__d = 8;
    }

    /*!
     * @brief This function returns the value of member i
     * @return Value of member i
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport long double i() const
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_i;
    }

    /*!
     * @brief This function returns a reference to member i
     * @return Reference to member i
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport long double& i()
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_i;
    }


    void _default()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }

        selected_member_ = 0x0FFFFFFFu;
    }


private:

            long double& i_()
            {
                if (0x00000001 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000001;
                    member_destructor_ = nullptr;
                    m_i = {0.0};

                }

                return m_i;
            }


    int32_t m__d {2147483647};

    union
    {
        long double m_i;
    };

    uint32_t selected_member_ {0x0FFFFFFFu};

    std::function<void()> member_destructor_;
};
/*!
 * @brief This class represents the union Union_Boolean defined by the user in the IDL file.
 * @ingroup unions
 */
class Union_Boolean
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Union_Boolean()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Union_Boolean()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Union_Boolean that will be copied.
     */
    eProsima_user_DllExport Union_Boolean(
            const Union_Boolean& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            j_() = x.m_j;
                            break;

        }
    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Union_Boolean that will be copied.
     */
    eProsima_user_DllExport Union_Boolean(
            Union_Boolean&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            j_() = std::move(x.m_j);
                            break;

        }
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Union_Boolean that will be copied.
     */
    eProsima_user_DllExport Union_Boolean& operator =(
            const Union_Boolean& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            j_() = x.m_j;
                            break;

        }

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Union_Boolean that will be copied.
     */
    eProsima_user_DllExport Union_Boolean& operator =(
            Union_Boolean&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            j_() = std::move(x.m_j);
                            break;

        }

        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Union_Boolean object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Union_Boolean& x) const
    {
        bool ret_value {false};

        if (x.selected_member_ == selected_member_)
        {
            if (0x0FFFFFFFu != selected_member_)
            {
                if (x.m__d == m__d)
                {
                    switch (selected_member_)
                    {
                                                    case 0x00000001:
                                                        ret_value = (x.m_j == m_j);
                                                        break;

                    }
                }
            }
            else
            {
                ret_value = true;
            }
        }

        return ret_value;
    }

    /*!
     * @brief Comparison operator.
     * @param x Union_Boolean object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Union_Boolean& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets the discriminator value.
     * @param __d New value for the discriminator.
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the new value doesn't correspond to the selected union member.
     */
    eProsima_user_DllExport void _d(
            int32_t __d)
    {
        bool valid_discriminator = false;

        switch (__d)
        {
                        case 9:
                            if (0x00000001 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

        }

        if (!valid_discriminator)
        {
            throw eprosima::fastcdr::exception::BadParamException("Discriminator doesn't correspond with the selected union member");
        }

        m__d = __d;
    }

    /*!
     * @brief This function returns the value of the discriminator.
     * @return Value of the discriminator
     */
    eProsima_user_DllExport int32_t _d() const
    {
        return m__d;
    }

    /*!
     * @brief This function sets a value in member j
     * @param _j New value for member j
     */
    eProsima_user_DllExport void j(
            bool _j)
    {
        j_() = _j;
        m__d = 9;
    }

    /*!
     * @brief This function returns the value of member j
     * @return Value of member j
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport bool j() const
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_j;
    }

    /*!
     * @brief This function returns a reference to member j
     * @return Reference to member j
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport bool& j()
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_j;
    }


    void _default()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }

        selected_member_ = 0x0FFFFFFFu;
    }


private:

            bool& j_()
            {
                if (0x00000001 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000001;
                    member_destructor_ = nullptr;
                    m_j = {false};

                }

                return m_j;
            }


    int32_t m__d {2147483647};

    union
    {
        bool m_j;
    };

    uint32_t selected_member_ {0x0FFFFFFFu};

    std::function<void()> member_destructor_;
};
/*!
 * @brief This class represents the union Union_Octet defined by the user in the IDL file.
 * @ingroup unions
 */
class Union_Octet
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Union_Octet()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Union_Octet()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Union_Octet that will be copied.
     */
    eProsima_user_DllExport Union_Octet(
            const Union_Octet& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            k_() = x.m_k;
                            break;

        }
    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Union_Octet that will be copied.
     */
    eProsima_user_DllExport Union_Octet(
            Union_Octet&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            k_() = std::move(x.m_k);
                            break;

        }
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Union_Octet that will be copied.
     */
    eProsima_user_DllExport Union_Octet& operator =(
            const Union_Octet& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            k_() = x.m_k;
                            break;

        }

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Union_Octet that will be copied.
     */
    eProsima_user_DllExport Union_Octet& operator =(
            Union_Octet&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            k_() = std::move(x.m_k);
                            break;

        }

        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Union_Octet object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Union_Octet& x) const
    {
        bool ret_value {false};

        if (x.selected_member_ == selected_member_)
        {
            if (0x0FFFFFFFu != selected_member_)
            {
                if (x.m__d == m__d)
                {
                    switch (selected_member_)
                    {
                                                    case 0x00000001:
                                                        ret_value = (x.m_k == m_k);
                                                        break;

                    }
                }
            }
            else
            {
                ret_value = true;
            }
        }

        return ret_value;
    }

    /*!
     * @brief Comparison operator.
     * @param x Union_Octet object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Union_Octet& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets the discriminator value.
     * @param __d New value for the discriminator.
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the new value doesn't correspond to the selected union member.
     */
    eProsima_user_DllExport void _d(
            int32_t __d)
    {
        bool valid_discriminator = false;

        switch (__d)
        {
                        case 10:
                            if (0x00000001 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

        }

        if (!valid_discriminator)
        {
            throw eprosima::fastcdr::exception::BadParamException("Discriminator doesn't correspond with the selected union member");
        }

        m__d = __d;
    }

    /*!
     * @brief This function returns the value of the discriminator.
     * @return Value of the discriminator
     */
    eProsima_user_DllExport int32_t _d() const
    {
        return m__d;
    }

    /*!
     * @brief This function sets a value in member k
     * @param _k New value for member k
     */
    eProsima_user_DllExport void k(
            uint8_t _k)
    {
        k_() = _k;
        m__d = 10;
    }

    /*!
     * @brief This function returns the value of member k
     * @return Value of member k
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport uint8_t k() const
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_k;
    }

    /*!
     * @brief This function returns a reference to member k
     * @return Reference to member k
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport uint8_t& k()
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_k;
    }


    void _default()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }

        selected_member_ = 0x0FFFFFFFu;
    }


private:

            uint8_t& k_()
            {
                if (0x00000001 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000001;
                    member_destructor_ = nullptr;
                    m_k = {0};

                }

                return m_k;
            }


    int32_t m__d {2147483647};

    union
    {
        uint8_t m_k;
    };

    uint32_t selected_member_ {0x0FFFFFFFu};

    std::function<void()> member_destructor_;
};
/*!
 * @brief This class represents the union Union_Char defined by the user in the IDL file.
 * @ingroup unions
 */
class Union_Char
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Union_Char()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Union_Char()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Union_Char that will be copied.
     */
    eProsima_user_DllExport Union_Char(
            const Union_Char& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            l_() = x.m_l;
                            break;

        }
    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Union_Char that will be copied.
     */
    eProsima_user_DllExport Union_Char(
            Union_Char&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            l_() = std::move(x.m_l);
                            break;

        }
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Union_Char that will be copied.
     */
    eProsima_user_DllExport Union_Char& operator =(
            const Union_Char& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            l_() = x.m_l;
                            break;

        }

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Union_Char that will be copied.
     */
    eProsima_user_DllExport Union_Char& operator =(
            Union_Char&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            l_() = std::move(x.m_l);
                            break;

        }

        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Union_Char object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Union_Char& x) const
    {
        bool ret_value {false};

        if (x.selected_member_ == selected_member_)
        {
            if (0x0FFFFFFFu != selected_member_)
            {
                if (x.m__d == m__d)
                {
                    switch (selected_member_)
                    {
                                                    case 0x00000001:
                                                        ret_value = (x.m_l == m_l);
                                                        break;

                    }
                }
            }
            else
            {
                ret_value = true;
            }
        }

        return ret_value;
    }

    /*!
     * @brief Comparison operator.
     * @param x Union_Char object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Union_Char& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets the discriminator value.
     * @param __d New value for the discriminator.
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the new value doesn't correspond to the selected union member.
     */
    eProsima_user_DllExport void _d(
            int32_t __d)
    {
        bool valid_discriminator = false;

        switch (__d)
        {
                        case 11:
                            if (0x00000001 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

        }

        if (!valid_discriminator)
        {
            throw eprosima::fastcdr::exception::BadParamException("Discriminator doesn't correspond with the selected union member");
        }

        m__d = __d;
    }

    /*!
     * @brief This function returns the value of the discriminator.
     * @return Value of the discriminator
     */
    eProsima_user_DllExport int32_t _d() const
    {
        return m__d;
    }

    /*!
     * @brief This function sets a value in member l
     * @param _l New value for member l
     */
    eProsima_user_DllExport void l(
            char _l)
    {
        l_() = _l;
        m__d = 11;
    }

    /*!
     * @brief This function returns the value of member l
     * @return Value of member l
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport char l() const
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_l;
    }

    /*!
     * @brief This function returns a reference to member l
     * @return Reference to member l
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport char& l()
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_l;
    }


    void _default()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }

        selected_member_ = 0x0FFFFFFFu;
    }


private:

            char& l_()
            {
                if (0x00000001 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000001;
                    member_destructor_ = nullptr;
                    m_l = {0};

                }

                return m_l;
            }


    int32_t m__d {2147483647};

    union
    {
        char m_l;
    };

    uint32_t selected_member_ {0x0FFFFFFFu};

    std::function<void()> member_destructor_;
};
/*!
 * @brief This class represents the union Union_WChar defined by the user in the IDL file.
 * @ingroup unions
 */
class Union_WChar
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Union_WChar()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Union_WChar()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Union_WChar that will be copied.
     */
    eProsima_user_DllExport Union_WChar(
            const Union_WChar& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            m_() = x.m_m;
                            break;

        }
    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Union_WChar that will be copied.
     */
    eProsima_user_DllExport Union_WChar(
            Union_WChar&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            m_() = std::move(x.m_m);
                            break;

        }
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Union_WChar that will be copied.
     */
    eProsima_user_DllExport Union_WChar& operator =(
            const Union_WChar& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            m_() = x.m_m;
                            break;

        }

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Union_WChar that will be copied.
     */
    eProsima_user_DllExport Union_WChar& operator =(
            Union_WChar&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            m_() = std::move(x.m_m);
                            break;

        }

        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Union_WChar object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Union_WChar& x) const
    {
        bool ret_value {false};

        if (x.selected_member_ == selected_member_)
        {
            if (0x0FFFFFFFu != selected_member_)
            {
                if (x.m__d == m__d)
                {
                    switch (selected_member_)
                    {
                                                    case 0x00000001:
                                                        ret_value = (x.m_m == m_m);
                                                        break;

                    }
                }
            }
            else
            {
                ret_value = true;
            }
        }

        return ret_value;
    }

    /*!
     * @brief Comparison operator.
     * @param x Union_WChar object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Union_WChar& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets the discriminator value.
     * @param __d New value for the discriminator.
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the new value doesn't correspond to the selected union member.
     */
    eProsima_user_DllExport void _d(
            int32_t __d)
    {
        bool valid_discriminator = false;

        switch (__d)
        {
                        case 12:
                            if (0x00000001 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

        }

        if (!valid_discriminator)
        {
            throw eprosima::fastcdr::exception::BadParamException("Discriminator doesn't correspond with the selected union member");
        }

        m__d = __d;
    }

    /*!
     * @brief This function returns the value of the discriminator.
     * @return Value of the discriminator
     */
    eProsima_user_DllExport int32_t _d() const
    {
        return m__d;
    }

    /*!
     * @brief This function sets a value in member m
     * @param _m New value for member m
     */
    eProsima_user_DllExport void m(
            wchar_t _m)
    {
        m_() = _m;
        m__d = 12;
    }

    /*!
     * @brief This function returns the value of member m
     * @return Value of member m
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport wchar_t m() const
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_m;
    }

    /*!
     * @brief This function returns a reference to member m
     * @return Reference to member m
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport wchar_t& m()
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_m;
    }


    void _default()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }

        selected_member_ = 0x0FFFFFFFu;
    }


private:

            wchar_t& m_()
            {
                if (0x00000001 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000001;
                    member_destructor_ = nullptr;
                    m_m = {0};

                }

                return m_m;
            }


    int32_t m__d {2147483647};

    union
    {
        wchar_t m_m;
    };

    uint32_t selected_member_ {0x0FFFFFFFu};

    std::function<void()> member_destructor_;
};
/*!
 * @brief This class represents the union Union_String defined by the user in the IDL file.
 * @ingroup unions
 */
class Union_String
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Union_String()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Union_String()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Union_String that will be copied.
     */
    eProsima_user_DllExport Union_String(
            const Union_String& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            n_() = x.m_n;
                            break;

        }
    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Union_String that will be copied.
     */
    eProsima_user_DllExport Union_String(
            Union_String&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            n_() = std::move(x.m_n);
                            break;

        }
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Union_String that will be copied.
     */
    eProsima_user_DllExport Union_String& operator =(
            const Union_String& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            n_() = x.m_n;
                            break;

        }

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Union_String that will be copied.
     */
    eProsima_user_DllExport Union_String& operator =(
            Union_String&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            n_() = std::move(x.m_n);
                            break;

        }

        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Union_String object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Union_String& x) const
    {
        bool ret_value {false};

        if (x.selected_member_ == selected_member_)
        {
            if (0x0FFFFFFFu != selected_member_)
            {
                if (x.m__d == m__d)
                {
                    switch (selected_member_)
                    {
                                                    case 0x00000001:
                                                        ret_value = (x.m_n == m_n);
                                                        break;

                    }
                }
            }
            else
            {
                ret_value = true;
            }
        }

        return ret_value;
    }

    /*!
     * @brief Comparison operator.
     * @param x Union_String object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Union_String& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets the discriminator value.
     * @param __d New value for the discriminator.
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the new value doesn't correspond to the selected union member.
     */
    eProsima_user_DllExport void _d(
            int32_t __d)
    {
        bool valid_discriminator = false;

        switch (__d)
        {
                        case 13:
                            if (0x00000001 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

        }

        if (!valid_discriminator)
        {
            throw eprosima::fastcdr::exception::BadParamException("Discriminator doesn't correspond with the selected union member");
        }

        m__d = __d;
    }

    /*!
     * @brief This function returns the value of the discriminator.
     * @return Value of the discriminator
     */
    eProsima_user_DllExport int32_t _d() const
    {
        return m__d;
    }

    /*!
     * @brief This function copies the value in member n
     * @param _n New value to be copied in member n
     */
    eProsima_user_DllExport void n(
            const std::string& _n)
    {
        n_() = _n;
        m__d = 13;
    }

    /*!
     * @brief This function moves the value in member n
     * @param _n New value to be moved in member n
     */
    eProsima_user_DllExport void n(
            std::string&& _n)
    {
        n_() = _n;
        m__d = 13;
    }

    /*!
     * @brief This function returns a constant reference to member n
     * @return Constant reference to member n
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport const std::string& n() const
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_n;
    }

    /*!
     * @brief This function returns a reference to member n
     * @return Reference to member n
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport std::string& n()
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_n;
    }


    void _default()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }

        selected_member_ = 0x0FFFFFFFu;
    }


private:

            std::string& n_()
            {
                if (0x00000001 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000001;
                    member_destructor_ = [&]()
                    {
                        m_n.~basic_string();
                    };
                    new(&m_n) std::string();

                }

                return m_n;
            }


    int32_t m__d {2147483647};

    union
    {
        std::string m_n;
    };

    uint32_t selected_member_ {0x0FFFFFFFu};

    std::function<void()> member_destructor_;
};
/*!
 * @brief This class represents the union Union_WString defined by the user in the IDL file.
 * @ingroup unions
 */
class Union_WString
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Union_WString()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Union_WString()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Union_WString that will be copied.
     */
    eProsima_user_DllExport Union_WString(
            const Union_WString& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            o_() = x.m_o;
                            break;

        }
    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Union_WString that will be copied.
     */
    eProsima_user_DllExport Union_WString(
            Union_WString&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            o_() = std::move(x.m_o);
                            break;

        }
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Union_WString that will be copied.
     */
    eProsima_user_DllExport Union_WString& operator =(
            const Union_WString& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            o_() = x.m_o;
                            break;

        }

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Union_WString that will be copied.
     */
    eProsima_user_DllExport Union_WString& operator =(
            Union_WString&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            o_() = std::move(x.m_o);
                            break;

        }

        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Union_WString object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Union_WString& x) const
    {
        bool ret_value {false};

        if (x.selected_member_ == selected_member_)
        {
            if (0x0FFFFFFFu != selected_member_)
            {
                if (x.m__d == m__d)
                {
                    switch (selected_member_)
                    {
                                                    case 0x00000001:
                                                        ret_value = (x.m_o == m_o);
                                                        break;

                    }
                }
            }
            else
            {
                ret_value = true;
            }
        }

        return ret_value;
    }

    /*!
     * @brief Comparison operator.
     * @param x Union_WString object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Union_WString& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets the discriminator value.
     * @param __d New value for the discriminator.
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the new value doesn't correspond to the selected union member.
     */
    eProsima_user_DllExport void _d(
            int32_t __d)
    {
        bool valid_discriminator = false;

        switch (__d)
        {
                        case 14:
                            if (0x00000001 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

        }

        if (!valid_discriminator)
        {
            throw eprosima::fastcdr::exception::BadParamException("Discriminator doesn't correspond with the selected union member");
        }

        m__d = __d;
    }

    /*!
     * @brief This function returns the value of the discriminator.
     * @return Value of the discriminator
     */
    eProsima_user_DllExport int32_t _d() const
    {
        return m__d;
    }

    /*!
     * @brief This function copies the value in member o
     * @param _o New value to be copied in member o
     */
    eProsima_user_DllExport void o(
            const std::wstring& _o)
    {
        o_() = _o;
        m__d = 14;
    }

    /*!
     * @brief This function moves the value in member o
     * @param _o New value to be moved in member o
     */
    eProsima_user_DllExport void o(
            std::wstring&& _o)
    {
        o_() = _o;
        m__d = 14;
    }

    /*!
     * @brief This function returns a constant reference to member o
     * @return Constant reference to member o
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport const std::wstring& o() const
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_o;
    }

    /*!
     * @brief This function returns a reference to member o
     * @return Reference to member o
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport std::wstring& o()
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_o;
    }


    void _default()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }

        selected_member_ = 0x0FFFFFFFu;
    }


private:

            std::wstring& o_()
            {
                if (0x00000001 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000001;
                    member_destructor_ = [&]()
                    {
                        m_o.~basic_string();
                    };
                    new(&m_o) std::wstring();

                }

                return m_o;
            }


    int32_t m__d {2147483647};

    union
    {
        std::wstring m_o;
    };

    uint32_t selected_member_ {0x0FFFFFFFu};

    std::function<void()> member_destructor_;
};
/*!
 * @brief This class represents the union Union_BoundedString defined by the user in the IDL file.
 * @ingroup unions
 */
class Union_BoundedString
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Union_BoundedString()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Union_BoundedString()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Union_BoundedString that will be copied.
     */
    eProsima_user_DllExport Union_BoundedString(
            const Union_BoundedString& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            bn_() = x.m_bn;
                            break;

        }
    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Union_BoundedString that will be copied.
     */
    eProsima_user_DllExport Union_BoundedString(
            Union_BoundedString&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            bn_() = std::move(x.m_bn);
                            break;

        }
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Union_BoundedString that will be copied.
     */
    eProsima_user_DllExport Union_BoundedString& operator =(
            const Union_BoundedString& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            bn_() = x.m_bn;
                            break;

        }

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Union_BoundedString that will be copied.
     */
    eProsima_user_DllExport Union_BoundedString& operator =(
            Union_BoundedString&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            bn_() = std::move(x.m_bn);
                            break;

        }

        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Union_BoundedString object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Union_BoundedString& x) const
    {
        bool ret_value {false};

        if (x.selected_member_ == selected_member_)
        {
            if (0x0FFFFFFFu != selected_member_)
            {
                if (x.m__d == m__d)
                {
                    switch (selected_member_)
                    {
                                                    case 0x00000001:
                                                        ret_value = (x.m_bn == m_bn);
                                                        break;

                    }
                }
            }
            else
            {
                ret_value = true;
            }
        }

        return ret_value;
    }

    /*!
     * @brief Comparison operator.
     * @param x Union_BoundedString object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Union_BoundedString& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets the discriminator value.
     * @param __d New value for the discriminator.
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the new value doesn't correspond to the selected union member.
     */
    eProsima_user_DllExport void _d(
            int32_t __d)
    {
        bool valid_discriminator = false;

        switch (__d)
        {
                        case 13:
                            if (0x00000001 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

        }

        if (!valid_discriminator)
        {
            throw eprosima::fastcdr::exception::BadParamException("Discriminator doesn't correspond with the selected union member");
        }

        m__d = __d;
    }

    /*!
     * @brief This function returns the value of the discriminator.
     * @return Value of the discriminator
     */
    eProsima_user_DllExport int32_t _d() const
    {
        return m__d;
    }

    /*!
     * @brief This function copies the value in member bn
     * @param _bn New value to be copied in member bn
     */
    eProsima_user_DllExport void bn(
            const Inner_alias_bounded_string_helper& _bn)
    {
        bn_() = _bn;
        m__d = 13;
    }

    /*!
     * @brief This function moves the value in member bn
     * @param _bn New value to be moved in member bn
     */
    eProsima_user_DllExport void bn(
            Inner_alias_bounded_string_helper&& _bn)
    {
        bn_() = _bn;
        m__d = 13;
    }

    /*!
     * @brief This function returns a constant reference to member bn
     * @return Constant reference to member bn
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport const Inner_alias_bounded_string_helper& bn() const
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_bn;
    }

    /*!
     * @brief This function returns a reference to member bn
     * @return Reference to member bn
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport Inner_alias_bounded_string_helper& bn()
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_bn;
    }


    void _default()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }

        selected_member_ = 0x0FFFFFFFu;
    }


private:

            Inner_alias_bounded_string_helper& bn_()
            {
                if (0x00000001 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000001;
                    member_destructor_ = [&]()
                    {
                        m_bn.~Inner_alias_bounded_string_helper();
                    };
                    new(&m_bn) Inner_alias_bounded_string_helper();

                }

                return m_bn;
            }


    int32_t m__d {2147483647};

    union
    {
        Inner_alias_bounded_string_helper m_bn;
    };

    uint32_t selected_member_ {0x0FFFFFFFu};

    std::function<void()> member_destructor_;
};
/*!
 * @brief This class represents the union Union_BoundedWString defined by the user in the IDL file.
 * @ingroup unions
 */
class Union_BoundedWString
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Union_BoundedWString()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Union_BoundedWString()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Union_BoundedWString that will be copied.
     */
    eProsima_user_DllExport Union_BoundedWString(
            const Union_BoundedWString& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            bo_() = x.m_bo;
                            break;

        }
    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Union_BoundedWString that will be copied.
     */
    eProsima_user_DllExport Union_BoundedWString(
            Union_BoundedWString&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            bo_() = std::move(x.m_bo);
                            break;

        }
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Union_BoundedWString that will be copied.
     */
    eProsima_user_DllExport Union_BoundedWString& operator =(
            const Union_BoundedWString& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            bo_() = x.m_bo;
                            break;

        }

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Union_BoundedWString that will be copied.
     */
    eProsima_user_DllExport Union_BoundedWString& operator =(
            Union_BoundedWString&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            bo_() = std::move(x.m_bo);
                            break;

        }

        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Union_BoundedWString object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Union_BoundedWString& x) const
    {
        bool ret_value {false};

        if (x.selected_member_ == selected_member_)
        {
            if (0x0FFFFFFFu != selected_member_)
            {
                if (x.m__d == m__d)
                {
                    switch (selected_member_)
                    {
                                                    case 0x00000001:
                                                        ret_value = (x.m_bo == m_bo);
                                                        break;

                    }
                }
            }
            else
            {
                ret_value = true;
            }
        }

        return ret_value;
    }

    /*!
     * @brief Comparison operator.
     * @param x Union_BoundedWString object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Union_BoundedWString& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets the discriminator value.
     * @param __d New value for the discriminator.
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the new value doesn't correspond to the selected union member.
     */
    eProsima_user_DllExport void _d(
            int32_t __d)
    {
        bool valid_discriminator = false;

        switch (__d)
        {
                        case 14:
                            if (0x00000001 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

        }

        if (!valid_discriminator)
        {
            throw eprosima::fastcdr::exception::BadParamException("Discriminator doesn't correspond with the selected union member");
        }

        m__d = __d;
    }

    /*!
     * @brief This function returns the value of the discriminator.
     * @return Value of the discriminator
     */
    eProsima_user_DllExport int32_t _d() const
    {
        return m__d;
    }

    /*!
     * @brief This function copies the value in member bo
     * @param _bo New value to be copied in member bo
     */
    eProsima_user_DllExport void bo(
            const Inner_alias_bounded_wstring_helper& _bo)
    {
        bo_() = _bo;
        m__d = 14;
    }

    /*!
     * @brief This function moves the value in member bo
     * @param _bo New value to be moved in member bo
     */
    eProsima_user_DllExport void bo(
            Inner_alias_bounded_wstring_helper&& _bo)
    {
        bo_() = _bo;
        m__d = 14;
    }

    /*!
     * @brief This function returns a constant reference to member bo
     * @return Constant reference to member bo
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport const Inner_alias_bounded_wstring_helper& bo() const
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_bo;
    }

    /*!
     * @brief This function returns a reference to member bo
     * @return Reference to member bo
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport Inner_alias_bounded_wstring_helper& bo()
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_bo;
    }


    void _default()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }

        selected_member_ = 0x0FFFFFFFu;
    }


private:

            Inner_alias_bounded_wstring_helper& bo_()
            {
                if (0x00000001 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000001;
                    member_destructor_ = [&]()
                    {
                        m_bo.~Inner_alias_bounded_wstring_helper();
                    };
                    new(&m_bo) Inner_alias_bounded_wstring_helper();

                }

                return m_bo;
            }


    int32_t m__d {2147483647};

    union
    {
        Inner_alias_bounded_wstring_helper m_bo;
    };

    uint32_t selected_member_ {0x0FFFFFFFu};

    std::function<void()> member_destructor_;
};
/*!
 * @brief This class represents the union Union_InnerEnumHelper defined by the user in the IDL file.
 * @ingroup unions
 */
class Union_InnerEnumHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Union_InnerEnumHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Union_InnerEnumHelper()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Union_InnerEnumHelper that will be copied.
     */
    eProsima_user_DllExport Union_InnerEnumHelper(
            const Union_InnerEnumHelper& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            p_() = x.m_p;
                            break;

        }
    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Union_InnerEnumHelper that will be copied.
     */
    eProsima_user_DllExport Union_InnerEnumHelper(
            Union_InnerEnumHelper&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            p_() = std::move(x.m_p);
                            break;

        }
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Union_InnerEnumHelper that will be copied.
     */
    eProsima_user_DllExport Union_InnerEnumHelper& operator =(
            const Union_InnerEnumHelper& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            p_() = x.m_p;
                            break;

        }

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Union_InnerEnumHelper that will be copied.
     */
    eProsima_user_DllExport Union_InnerEnumHelper& operator =(
            Union_InnerEnumHelper&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            p_() = std::move(x.m_p);
                            break;

        }

        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Union_InnerEnumHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Union_InnerEnumHelper& x) const
    {
        bool ret_value {false};

        if (x.selected_member_ == selected_member_)
        {
            if (0x0FFFFFFFu != selected_member_)
            {
                if (x.m__d == m__d)
                {
                    switch (selected_member_)
                    {
                                                    case 0x00000001:
                                                        ret_value = (x.m_p == m_p);
                                                        break;

                    }
                }
            }
            else
            {
                ret_value = true;
            }
        }

        return ret_value;
    }

    /*!
     * @brief Comparison operator.
     * @param x Union_InnerEnumHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Union_InnerEnumHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets the discriminator value.
     * @param __d New value for the discriminator.
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the new value doesn't correspond to the selected union member.
     */
    eProsima_user_DllExport void _d(
            int32_t __d)
    {
        bool valid_discriminator = false;

        switch (__d)
        {
                        case 15:
                            if (0x00000001 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

        }

        if (!valid_discriminator)
        {
            throw eprosima::fastcdr::exception::BadParamException("Discriminator doesn't correspond with the selected union member");
        }

        m__d = __d;
    }

    /*!
     * @brief This function returns the value of the discriminator.
     * @return Value of the discriminator
     */
    eProsima_user_DllExport int32_t _d() const
    {
        return m__d;
    }

    /*!
     * @brief This function sets a value in member p
     * @param _p New value for member p
     */
    eProsima_user_DllExport void p(
            InnerEnumHelper _p)
    {
        p_() = _p;
        m__d = 15;
    }

    /*!
     * @brief This function returns the value of member p
     * @return Value of member p
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport InnerEnumHelper p() const
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_p;
    }

    /*!
     * @brief This function returns a reference to member p
     * @return Reference to member p
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport InnerEnumHelper& p()
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_p;
    }


    void _default()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }

        selected_member_ = 0x0FFFFFFFu;
    }


private:

            InnerEnumHelper& p_()
            {
                if (0x00000001 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000001;
                    member_destructor_ = nullptr;
                    m_p = {InnerEnumHelper::ENUM_VALUE_1};

                }

                return m_p;
            }


    int32_t m__d {2147483647};

    union
    {
        InnerEnumHelper m_p;
    };

    uint32_t selected_member_ {0x0FFFFFFFu};

    std::function<void()> member_destructor_;
};
/*!
 * @brief This class represents the union Union_InnerBitMaskHelper defined by the user in the IDL file.
 * @ingroup unions
 */
class Union_InnerBitMaskHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Union_InnerBitMaskHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Union_InnerBitMaskHelper()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Union_InnerBitMaskHelper that will be copied.
     */
    eProsima_user_DllExport Union_InnerBitMaskHelper(
            const Union_InnerBitMaskHelper& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            q_() = x.m_q;
                            break;

        }
    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Union_InnerBitMaskHelper that will be copied.
     */
    eProsima_user_DllExport Union_InnerBitMaskHelper(
            Union_InnerBitMaskHelper&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            q_() = std::move(x.m_q);
                            break;

        }
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Union_InnerBitMaskHelper that will be copied.
     */
    eProsima_user_DllExport Union_InnerBitMaskHelper& operator =(
            const Union_InnerBitMaskHelper& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            q_() = x.m_q;
                            break;

        }

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Union_InnerBitMaskHelper that will be copied.
     */
    eProsima_user_DllExport Union_InnerBitMaskHelper& operator =(
            Union_InnerBitMaskHelper&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            q_() = std::move(x.m_q);
                            break;

        }

        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Union_InnerBitMaskHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Union_InnerBitMaskHelper& x) const
    {
        bool ret_value {false};

        if (x.selected_member_ == selected_member_)
        {
            if (0x0FFFFFFFu != selected_member_)
            {
                if (x.m__d == m__d)
                {
                    switch (selected_member_)
                    {
                                                    case 0x00000001:
                                                        ret_value = (x.m_q == m_q);
                                                        break;

                    }
                }
            }
            else
            {
                ret_value = true;
            }
        }

        return ret_value;
    }

    /*!
     * @brief Comparison operator.
     * @param x Union_InnerBitMaskHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Union_InnerBitMaskHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets the discriminator value.
     * @param __d New value for the discriminator.
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the new value doesn't correspond to the selected union member.
     */
    eProsima_user_DllExport void _d(
            int32_t __d)
    {
        bool valid_discriminator = false;

        switch (__d)
        {
                        case 16:
                            if (0x00000001 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

        }

        if (!valid_discriminator)
        {
            throw eprosima::fastcdr::exception::BadParamException("Discriminator doesn't correspond with the selected union member");
        }

        m__d = __d;
    }

    /*!
     * @brief This function returns the value of the discriminator.
     * @return Value of the discriminator
     */
    eProsima_user_DllExport int32_t _d() const
    {
        return m__d;
    }

    /*!
     * @brief This function copies the value in member q
     * @param _q New value to be copied in member q
     */
    eProsima_user_DllExport void q(
            const InnerBitMaskHelper& _q)
    {
        q_() = _q;
        m__d = 16;
    }

    /*!
     * @brief This function moves the value in member q
     * @param _q New value to be moved in member q
     */
    eProsima_user_DllExport void q(
            InnerBitMaskHelper&& _q)
    {
        q_() = _q;
        m__d = 16;
    }

    /*!
     * @brief This function returns a constant reference to member q
     * @return Constant reference to member q
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport const InnerBitMaskHelper& q() const
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_q;
    }

    /*!
     * @brief This function returns a reference to member q
     * @return Reference to member q
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport InnerBitMaskHelper& q()
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_q;
    }


    void _default()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }

        selected_member_ = 0x0FFFFFFFu;
    }


private:

            InnerBitMaskHelper& q_()
            {
                if (0x00000001 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000001;
                    member_destructor_ = [&]()
                    {
                        m_q.~InnerBitMaskHelper();
                    };
                    new(&m_q) InnerBitMaskHelper();

                }

                return m_q;
            }


    int32_t m__d {2147483647};

    union
    {
        InnerBitMaskHelper m_q;
    };

    uint32_t selected_member_ {0x0FFFFFFFu};

    std::function<void()> member_destructor_;
};
/*!
 * @brief This class represents the union Union_InnerAliasHelper defined by the user in the IDL file.
 * @ingroup unions
 */
class Union_InnerAliasHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Union_InnerAliasHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Union_InnerAliasHelper()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Union_InnerAliasHelper that will be copied.
     */
    eProsima_user_DllExport Union_InnerAliasHelper(
            const Union_InnerAliasHelper& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            r_() = x.m_r;
                            break;

        }
    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Union_InnerAliasHelper that will be copied.
     */
    eProsima_user_DllExport Union_InnerAliasHelper(
            Union_InnerAliasHelper&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            r_() = std::move(x.m_r);
                            break;

        }
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Union_InnerAliasHelper that will be copied.
     */
    eProsima_user_DllExport Union_InnerAliasHelper& operator =(
            const Union_InnerAliasHelper& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            r_() = x.m_r;
                            break;

        }

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Union_InnerAliasHelper that will be copied.
     */
    eProsima_user_DllExport Union_InnerAliasHelper& operator =(
            Union_InnerAliasHelper&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            r_() = std::move(x.m_r);
                            break;

        }

        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Union_InnerAliasHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Union_InnerAliasHelper& x) const
    {
        bool ret_value {false};

        if (x.selected_member_ == selected_member_)
        {
            if (0x0FFFFFFFu != selected_member_)
            {
                if (x.m__d == m__d)
                {
                    switch (selected_member_)
                    {
                                                    case 0x00000001:
                                                        ret_value = (x.m_r == m_r);
                                                        break;

                    }
                }
            }
            else
            {
                ret_value = true;
            }
        }

        return ret_value;
    }

    /*!
     * @brief Comparison operator.
     * @param x Union_InnerAliasHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Union_InnerAliasHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets the discriminator value.
     * @param __d New value for the discriminator.
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the new value doesn't correspond to the selected union member.
     */
    eProsima_user_DllExport void _d(
            int32_t __d)
    {
        bool valid_discriminator = false;

        switch (__d)
        {
                        case 17:
                            if (0x00000001 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

        }

        if (!valid_discriminator)
        {
            throw eprosima::fastcdr::exception::BadParamException("Discriminator doesn't correspond with the selected union member");
        }

        m__d = __d;
    }

    /*!
     * @brief This function returns the value of the discriminator.
     * @return Value of the discriminator
     */
    eProsima_user_DllExport int32_t _d() const
    {
        return m__d;
    }

    /*!
     * @brief This function sets a value in member r
     * @param _r New value for member r
     */
    eProsima_user_DllExport void r(
            InnerAliasHelper _r)
    {
        r_() = _r;
        m__d = 17;
    }

    /*!
     * @brief This function returns the value of member r
     * @return Value of member r
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport InnerAliasHelper r() const
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_r;
    }

    /*!
     * @brief This function returns a reference to member r
     * @return Reference to member r
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport InnerAliasHelper& r()
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_r;
    }


    void _default()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }

        selected_member_ = 0x0FFFFFFFu;
    }


private:

            InnerAliasHelper& r_()
            {
                if (0x00000001 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000001;
                    member_destructor_ = nullptr;
                    m_r = {0};

                }

                return m_r;
            }


    int32_t m__d {2147483647};

    union
    {
        InnerAliasHelper m_r;
    };

    uint32_t selected_member_ {0x0FFFFFFFu};

    std::function<void()> member_destructor_;
};
/*!
 * @brief This class represents the union Union_Array defined by the user in the IDL file.
 * @ingroup unions
 */
class Union_Array
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Union_Array()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Union_Array()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Union_Array that will be copied.
     */
    eProsima_user_DllExport Union_Array(
            const Union_Array& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            s_() = x.m_s;
                            break;

        }
    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Union_Array that will be copied.
     */
    eProsima_user_DllExport Union_Array(
            Union_Array&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            s_() = std::move(x.m_s);
                            break;

        }
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Union_Array that will be copied.
     */
    eProsima_user_DllExport Union_Array& operator =(
            const Union_Array& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            s_() = x.m_s;
                            break;

        }

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Union_Array that will be copied.
     */
    eProsima_user_DllExport Union_Array& operator =(
            Union_Array&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            s_() = std::move(x.m_s);
                            break;

        }

        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Union_Array object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Union_Array& x) const
    {
        bool ret_value {false};

        if (x.selected_member_ == selected_member_)
        {
            if (0x0FFFFFFFu != selected_member_)
            {
                if (x.m__d == m__d)
                {
                    switch (selected_member_)
                    {
                                                    case 0x00000001:
                                                        ret_value = (x.m_s == m_s);
                                                        break;

                    }
                }
            }
            else
            {
                ret_value = true;
            }
        }

        return ret_value;
    }

    /*!
     * @brief Comparison operator.
     * @param x Union_Array object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Union_Array& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets the discriminator value.
     * @param __d New value for the discriminator.
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the new value doesn't correspond to the selected union member.
     */
    eProsima_user_DllExport void _d(
            int32_t __d)
    {
        bool valid_discriminator = false;

        switch (__d)
        {
                        case 18:
                            if (0x00000001 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

        }

        if (!valid_discriminator)
        {
            throw eprosima::fastcdr::exception::BadParamException("Discriminator doesn't correspond with the selected union member");
        }

        m__d = __d;
    }

    /*!
     * @brief This function returns the value of the discriminator.
     * @return Value of the discriminator
     */
    eProsima_user_DllExport int32_t _d() const
    {
        return m__d;
    }

    /*!
     * @brief This function copies the value in member s
     * @param _s New value to be copied in member s
     */
    eProsima_user_DllExport void s(
            const Inner_alias_array_helper& _s)
    {
        s_() = _s;
        m__d = 18;
    }

    /*!
     * @brief This function moves the value in member s
     * @param _s New value to be moved in member s
     */
    eProsima_user_DllExport void s(
            Inner_alias_array_helper&& _s)
    {
        s_() = _s;
        m__d = 18;
    }

    /*!
     * @brief This function returns a constant reference to member s
     * @return Constant reference to member s
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport const Inner_alias_array_helper& s() const
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_s;
    }

    /*!
     * @brief This function returns a reference to member s
     * @return Reference to member s
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport Inner_alias_array_helper& s()
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_s;
    }


    void _default()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }

        selected_member_ = 0x0FFFFFFFu;
    }


private:

            Inner_alias_array_helper& s_()
            {
                if (0x00000001 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000001;
                    member_destructor_ = [&]()
                    {
                        m_s.~Inner_alias_array_helper();
                    };
                    new(&m_s) Inner_alias_array_helper();

                }

                return m_s;
            }


    int32_t m__d {2147483647};

    union
    {
        Inner_alias_array_helper m_s;
    };

    uint32_t selected_member_ {0x0FFFFFFFu};

    std::function<void()> member_destructor_;
};
/*!
 * @brief This class represents the union Union_Sequence defined by the user in the IDL file.
 * @ingroup unions
 */
class Union_Sequence
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Union_Sequence()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Union_Sequence()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Union_Sequence that will be copied.
     */
    eProsima_user_DllExport Union_Sequence(
            const Union_Sequence& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            t_() = x.m_t;
                            break;

        }
    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Union_Sequence that will be copied.
     */
    eProsima_user_DllExport Union_Sequence(
            Union_Sequence&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            t_() = std::move(x.m_t);
                            break;

        }
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Union_Sequence that will be copied.
     */
    eProsima_user_DllExport Union_Sequence& operator =(
            const Union_Sequence& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            t_() = x.m_t;
                            break;

        }

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Union_Sequence that will be copied.
     */
    eProsima_user_DllExport Union_Sequence& operator =(
            Union_Sequence&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            t_() = std::move(x.m_t);
                            break;

        }

        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Union_Sequence object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Union_Sequence& x) const
    {
        bool ret_value {false};

        if (x.selected_member_ == selected_member_)
        {
            if (0x0FFFFFFFu != selected_member_)
            {
                if (x.m__d == m__d)
                {
                    switch (selected_member_)
                    {
                                                    case 0x00000001:
                                                        ret_value = (x.m_t == m_t);
                                                        break;

                    }
                }
            }
            else
            {
                ret_value = true;
            }
        }

        return ret_value;
    }

    /*!
     * @brief Comparison operator.
     * @param x Union_Sequence object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Union_Sequence& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets the discriminator value.
     * @param __d New value for the discriminator.
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the new value doesn't correspond to the selected union member.
     */
    eProsima_user_DllExport void _d(
            int32_t __d)
    {
        bool valid_discriminator = false;

        switch (__d)
        {
                        case 19:
                            if (0x00000001 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

        }

        if (!valid_discriminator)
        {
            throw eprosima::fastcdr::exception::BadParamException("Discriminator doesn't correspond with the selected union member");
        }

        m__d = __d;
    }

    /*!
     * @brief This function returns the value of the discriminator.
     * @return Value of the discriminator
     */
    eProsima_user_DllExport int32_t _d() const
    {
        return m__d;
    }

    /*!
     * @brief This function copies the value in member t
     * @param _t New value to be copied in member t
     */
    eProsima_user_DllExport void t(
            const std::vector<int16_t>& _t)
    {
        t_() = _t;
        m__d = 19;
    }

    /*!
     * @brief This function moves the value in member t
     * @param _t New value to be moved in member t
     */
    eProsima_user_DllExport void t(
            std::vector<int16_t>&& _t)
    {
        t_() = _t;
        m__d = 19;
    }

    /*!
     * @brief This function returns a constant reference to member t
     * @return Constant reference to member t
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport const std::vector<int16_t>& t() const
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_t;
    }

    /*!
     * @brief This function returns a reference to member t
     * @return Reference to member t
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport std::vector<int16_t>& t()
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_t;
    }


    void _default()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }

        selected_member_ = 0x0FFFFFFFu;
    }


private:

            std::vector<int16_t>& t_()
            {
                if (0x00000001 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000001;
                    member_destructor_ = [&]()
                    {
                        m_t.~vector();
                    };
                    new(&m_t) std::vector<int16_t>();

                }

                return m_t;
            }


    int32_t m__d {2147483647};

    union
    {
        std::vector<int16_t> m_t;
    };

    uint32_t selected_member_ {0x0FFFFFFFu};

    std::function<void()> member_destructor_;
};
/*!
 * @brief This class represents the union Union_Map defined by the user in the IDL file.
 * @ingroup unions
 */
class Union_Map
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Union_Map()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Union_Map()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Union_Map that will be copied.
     */
    eProsima_user_DllExport Union_Map(
            const Union_Map& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            u_() = x.m_u;
                            break;

        }
    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Union_Map that will be copied.
     */
    eProsima_user_DllExport Union_Map(
            Union_Map&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            u_() = std::move(x.m_u);
                            break;

        }
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Union_Map that will be copied.
     */
    eProsima_user_DllExport Union_Map& operator =(
            const Union_Map& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            u_() = x.m_u;
                            break;

        }

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Union_Map that will be copied.
     */
    eProsima_user_DllExport Union_Map& operator =(
            Union_Map&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            u_() = std::move(x.m_u);
                            break;

        }

        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Union_Map object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Union_Map& x) const
    {
        bool ret_value {false};

        if (x.selected_member_ == selected_member_)
        {
            if (0x0FFFFFFFu != selected_member_)
            {
                if (x.m__d == m__d)
                {
                    switch (selected_member_)
                    {
                                                    case 0x00000001:
                                                        ret_value = (x.m_u == m_u);
                                                        break;

                    }
                }
            }
            else
            {
                ret_value = true;
            }
        }

        return ret_value;
    }

    /*!
     * @brief Comparison operator.
     * @param x Union_Map object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Union_Map& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets the discriminator value.
     * @param __d New value for the discriminator.
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the new value doesn't correspond to the selected union member.
     */
    eProsima_user_DllExport void _d(
            int32_t __d)
    {
        bool valid_discriminator = false;

        switch (__d)
        {
                        case 20:
                            if (0x00000001 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

        }

        if (!valid_discriminator)
        {
            throw eprosima::fastcdr::exception::BadParamException("Discriminator doesn't correspond with the selected union member");
        }

        m__d = __d;
    }

    /*!
     * @brief This function returns the value of the discriminator.
     * @return Value of the discriminator
     */
    eProsima_user_DllExport int32_t _d() const
    {
        return m__d;
    }

    /*!
     * @brief This function copies the value in member u
     * @param _u New value to be copied in member u
     */
    eProsima_user_DllExport void u(
            const std::map<int32_t, int32_t>& _u)
    {
        u_() = _u;
        m__d = 20;
    }

    /*!
     * @brief This function moves the value in member u
     * @param _u New value to be moved in member u
     */
    eProsima_user_DllExport void u(
            std::map<int32_t, int32_t>&& _u)
    {
        u_() = _u;
        m__d = 20;
    }

    /*!
     * @brief This function returns a constant reference to member u
     * @return Constant reference to member u
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport const std::map<int32_t, int32_t>& u() const
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_u;
    }

    /*!
     * @brief This function returns a reference to member u
     * @return Reference to member u
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport std::map<int32_t, int32_t>& u()
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_u;
    }


    void _default()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }

        selected_member_ = 0x0FFFFFFFu;
    }


private:

            std::map<int32_t, int32_t>& u_()
            {
                if (0x00000001 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000001;
                    member_destructor_ = [&]()
                    {
                        m_u.~map();
                    };
                    new(&m_u) std::map<int32_t, int32_t>();

                }

                return m_u;
            }


    int32_t m__d {2147483647};

    union
    {
        std::map<int32_t, int32_t> m_u;
    };

    uint32_t selected_member_ {0x0FFFFFFFu};

    std::function<void()> member_destructor_;
};
/*!
 * @brief This class represents the union Union_InnerUnionHelper defined by the user in the IDL file.
 * @ingroup unions
 */
class Union_InnerUnionHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Union_InnerUnionHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Union_InnerUnionHelper()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Union_InnerUnionHelper that will be copied.
     */
    eProsima_user_DllExport Union_InnerUnionHelper(
            const Union_InnerUnionHelper& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            v_() = x.m_v;
                            break;

        }
    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Union_InnerUnionHelper that will be copied.
     */
    eProsima_user_DllExport Union_InnerUnionHelper(
            Union_InnerUnionHelper&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            v_() = std::move(x.m_v);
                            break;

        }
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Union_InnerUnionHelper that will be copied.
     */
    eProsima_user_DllExport Union_InnerUnionHelper& operator =(
            const Union_InnerUnionHelper& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            v_() = x.m_v;
                            break;

        }

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Union_InnerUnionHelper that will be copied.
     */
    eProsima_user_DllExport Union_InnerUnionHelper& operator =(
            Union_InnerUnionHelper&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            v_() = std::move(x.m_v);
                            break;

        }

        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Union_InnerUnionHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Union_InnerUnionHelper& x) const
    {
        bool ret_value {false};

        if (x.selected_member_ == selected_member_)
        {
            if (0x0FFFFFFFu != selected_member_)
            {
                if (x.m__d == m__d)
                {
                    switch (selected_member_)
                    {
                                                    case 0x00000001:
                                                        ret_value = (x.m_v == m_v);
                                                        break;

                    }
                }
            }
            else
            {
                ret_value = true;
            }
        }

        return ret_value;
    }

    /*!
     * @brief Comparison operator.
     * @param x Union_InnerUnionHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Union_InnerUnionHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets the discriminator value.
     * @param __d New value for the discriminator.
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the new value doesn't correspond to the selected union member.
     */
    eProsima_user_DllExport void _d(
            int32_t __d)
    {
        bool valid_discriminator = false;

        switch (__d)
        {
                        case 21:
                            if (0x00000001 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

        }

        if (!valid_discriminator)
        {
            throw eprosima::fastcdr::exception::BadParamException("Discriminator doesn't correspond with the selected union member");
        }

        m__d = __d;
    }

    /*!
     * @brief This function returns the value of the discriminator.
     * @return Value of the discriminator
     */
    eProsima_user_DllExport int32_t _d() const
    {
        return m__d;
    }

    /*!
     * @brief This function copies the value in member v
     * @param _v New value to be copied in member v
     */
    eProsima_user_DllExport void v(
            const InnerUnionHelper& _v)
    {
        v_() = _v;
        m__d = 21;
    }

    /*!
     * @brief This function moves the value in member v
     * @param _v New value to be moved in member v
     */
    eProsima_user_DllExport void v(
            InnerUnionHelper&& _v)
    {
        v_() = _v;
        m__d = 21;
    }

    /*!
     * @brief This function returns a constant reference to member v
     * @return Constant reference to member v
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport const InnerUnionHelper& v() const
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_v;
    }

    /*!
     * @brief This function returns a reference to member v
     * @return Reference to member v
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport InnerUnionHelper& v()
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_v;
    }


    void _default()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }

        selected_member_ = 0x0FFFFFFFu;
    }


private:

            InnerUnionHelper& v_()
            {
                if (0x00000001 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000001;
                    member_destructor_ = [&]()
                    {
                        m_v.~InnerUnionHelper();
                    };
                    new(&m_v) InnerUnionHelper();

                }

                return m_v;
            }


    int32_t m__d {2147483647};

    union
    {
        InnerUnionHelper m_v;
    };

    uint32_t selected_member_ {0x0FFFFFFFu};

    std::function<void()> member_destructor_;
};
/*!
 * @brief This class represents the union Union_InnerStructureHelper defined by the user in the IDL file.
 * @ingroup unions
 */
class Union_InnerStructureHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Union_InnerStructureHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Union_InnerStructureHelper()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Union_InnerStructureHelper that will be copied.
     */
    eProsima_user_DllExport Union_InnerStructureHelper(
            const Union_InnerStructureHelper& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            w_() = x.m_w;
                            break;

        }
    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Union_InnerStructureHelper that will be copied.
     */
    eProsima_user_DllExport Union_InnerStructureHelper(
            Union_InnerStructureHelper&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            w_() = std::move(x.m_w);
                            break;

        }
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Union_InnerStructureHelper that will be copied.
     */
    eProsima_user_DllExport Union_InnerStructureHelper& operator =(
            const Union_InnerStructureHelper& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            w_() = x.m_w;
                            break;

        }

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Union_InnerStructureHelper that will be copied.
     */
    eProsima_user_DllExport Union_InnerStructureHelper& operator =(
            Union_InnerStructureHelper&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            w_() = std::move(x.m_w);
                            break;

        }

        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Union_InnerStructureHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Union_InnerStructureHelper& x) const
    {
        bool ret_value {false};

        if (x.selected_member_ == selected_member_)
        {
            if (0x0FFFFFFFu != selected_member_)
            {
                if (x.m__d == m__d)
                {
                    switch (selected_member_)
                    {
                                                    case 0x00000001:
                                                        ret_value = (x.m_w == m_w);
                                                        break;

                    }
                }
            }
            else
            {
                ret_value = true;
            }
        }

        return ret_value;
    }

    /*!
     * @brief Comparison operator.
     * @param x Union_InnerStructureHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Union_InnerStructureHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets the discriminator value.
     * @param __d New value for the discriminator.
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the new value doesn't correspond to the selected union member.
     */
    eProsima_user_DllExport void _d(
            int32_t __d)
    {
        bool valid_discriminator = false;

        switch (__d)
        {
                        case 22:
                            if (0x00000001 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

        }

        if (!valid_discriminator)
        {
            throw eprosima::fastcdr::exception::BadParamException("Discriminator doesn't correspond with the selected union member");
        }

        m__d = __d;
    }

    /*!
     * @brief This function returns the value of the discriminator.
     * @return Value of the discriminator
     */
    eProsima_user_DllExport int32_t _d() const
    {
        return m__d;
    }

    /*!
     * @brief This function copies the value in member w
     * @param _w New value to be copied in member w
     */
    eProsima_user_DllExport void w(
            const InnerStructureHelper& _w)
    {
        w_() = _w;
        m__d = 22;
    }

    /*!
     * @brief This function moves the value in member w
     * @param _w New value to be moved in member w
     */
    eProsima_user_DllExport void w(
            InnerStructureHelper&& _w)
    {
        w_() = _w;
        m__d = 22;
    }

    /*!
     * @brief This function returns a constant reference to member w
     * @return Constant reference to member w
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport const InnerStructureHelper& w() const
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_w;
    }

    /*!
     * @brief This function returns a reference to member w
     * @return Reference to member w
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport InnerStructureHelper& w()
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_w;
    }


    void _default()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }

        selected_member_ = 0x0FFFFFFFu;
    }


private:

            InnerStructureHelper& w_()
            {
                if (0x00000001 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000001;
                    member_destructor_ = [&]()
                    {
                        m_w.~InnerStructureHelper();
                    };
                    new(&m_w) InnerStructureHelper();

                }

                return m_w;
            }


    int32_t m__d {2147483647};

    union
    {
        InnerStructureHelper m_w;
    };

    uint32_t selected_member_ {0x0FFFFFFFu};

    std::function<void()> member_destructor_;
};
/*!
 * @brief This class represents the union Union_InnerBitsetHelper defined by the user in the IDL file.
 * @ingroup unions
 */
class Union_InnerBitsetHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Union_InnerBitsetHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Union_InnerBitsetHelper()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Union_InnerBitsetHelper that will be copied.
     */
    eProsima_user_DllExport Union_InnerBitsetHelper(
            const Union_InnerBitsetHelper& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            x_() = x.m_x;
                            break;

        }
    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Union_InnerBitsetHelper that will be copied.
     */
    eProsima_user_DllExport Union_InnerBitsetHelper(
            Union_InnerBitsetHelper&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            x_() = std::move(x.m_x);
                            break;

        }
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Union_InnerBitsetHelper that will be copied.
     */
    eProsima_user_DllExport Union_InnerBitsetHelper& operator =(
            const Union_InnerBitsetHelper& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            x_() = x.m_x;
                            break;

        }

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Union_InnerBitsetHelper that will be copied.
     */
    eProsima_user_DllExport Union_InnerBitsetHelper& operator =(
            Union_InnerBitsetHelper&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            x_() = std::move(x.m_x);
                            break;

        }

        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Union_InnerBitsetHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Union_InnerBitsetHelper& x) const
    {
        bool ret_value {false};

        if (x.selected_member_ == selected_member_)
        {
            if (0x0FFFFFFFu != selected_member_)
            {
                if (x.m__d == m__d)
                {
                    switch (selected_member_)
                    {
                                                    case 0x00000001:
                                                        ret_value = (x.m_x == m_x);
                                                        break;

                    }
                }
            }
            else
            {
                ret_value = true;
            }
        }

        return ret_value;
    }

    /*!
     * @brief Comparison operator.
     * @param x Union_InnerBitsetHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Union_InnerBitsetHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets the discriminator value.
     * @param __d New value for the discriminator.
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the new value doesn't correspond to the selected union member.
     */
    eProsima_user_DllExport void _d(
            int32_t __d)
    {
        bool valid_discriminator = false;

        switch (__d)
        {
                        case 23:
                            if (0x00000001 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

        }

        if (!valid_discriminator)
        {
            throw eprosima::fastcdr::exception::BadParamException("Discriminator doesn't correspond with the selected union member");
        }

        m__d = __d;
    }

    /*!
     * @brief This function returns the value of the discriminator.
     * @return Value of the discriminator
     */
    eProsima_user_DllExport int32_t _d() const
    {
        return m__d;
    }

    /*!
     * @brief This function copies the value in member x
     * @param _x New value to be copied in member x
     */
    eProsima_user_DllExport void x(
            const InnerBitsetHelper& _x)
    {
        x_() = _x;
        m__d = 23;
    }

    /*!
     * @brief This function moves the value in member x
     * @param _x New value to be moved in member x
     */
    eProsima_user_DllExport void x(
            InnerBitsetHelper&& _x)
    {
        x_() = _x;
        m__d = 23;
    }

    /*!
     * @brief This function returns a constant reference to member x
     * @return Constant reference to member x
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport const InnerBitsetHelper& x() const
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_x;
    }

    /*!
     * @brief This function returns a reference to member x
     * @return Reference to member x
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport InnerBitsetHelper& x()
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_x;
    }


    void _default()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }

        selected_member_ = 0x0FFFFFFFu;
    }


private:

            InnerBitsetHelper& x_()
            {
                if (0x00000001 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000001;
                    member_destructor_ = [&]()
                    {
                        m_x.~InnerBitsetHelper();
                    };
                    new(&m_x) InnerBitsetHelper();

                }

                return m_x;
            }


    int32_t m__d {2147483647};

    union
    {
        InnerBitsetHelper m_x;
    };

    uint32_t selected_member_ {0x0FFFFFFFu};

    std::function<void()> member_destructor_;
};
/*!
 * @brief This class represents the union Union_Discriminator_short defined by the user in the IDL file.
 * @ingroup unions
 */
class Union_Discriminator_short
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Union_Discriminator_short()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Union_Discriminator_short()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Union_Discriminator_short that will be copied.
     */
    eProsima_user_DllExport Union_Discriminator_short(
            const Union_Discriminator_short& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            first_() = x.m_first;
                            break;

                        case 0x00000002:
                            second_() = x.m_second;
                            break;

        }
    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Union_Discriminator_short that will be copied.
     */
    eProsima_user_DllExport Union_Discriminator_short(
            Union_Discriminator_short&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            first_() = std::move(x.m_first);
                            break;

                        case 0x00000002:
                            second_() = std::move(x.m_second);
                            break;

        }
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Union_Discriminator_short that will be copied.
     */
    eProsima_user_DllExport Union_Discriminator_short& operator =(
            const Union_Discriminator_short& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            first_() = x.m_first;
                            break;

                        case 0x00000002:
                            second_() = x.m_second;
                            break;

        }

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Union_Discriminator_short that will be copied.
     */
    eProsima_user_DllExport Union_Discriminator_short& operator =(
            Union_Discriminator_short&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            first_() = std::move(x.m_first);
                            break;

                        case 0x00000002:
                            second_() = std::move(x.m_second);
                            break;

        }

        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Union_Discriminator_short object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Union_Discriminator_short& x) const
    {
        bool ret_value {false};

        if (x.selected_member_ == selected_member_)
        {
            if (0x0FFFFFFFu != selected_member_)
            {
                if (x.m__d == m__d)
                {
                    switch (selected_member_)
                    {
                                                    case 0x00000001:
                                                        ret_value = (x.m_first == m_first);
                                                        break;

                                                    case 0x00000002:
                                                        ret_value = (x.m_second == m_second);
                                                        break;

                    }
                }
            }
            else
            {
                ret_value = true;
            }
        }

        return ret_value;
    }

    /*!
     * @brief Comparison operator.
     * @param x Union_Discriminator_short object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Union_Discriminator_short& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets the discriminator value.
     * @param __d New value for the discriminator.
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the new value doesn't correspond to the selected union member.
     */
    eProsima_user_DllExport void _d(
            int16_t __d)
    {
        bool valid_discriminator = false;

        switch (__d)
        {
                        case 1:
                            if (0x00000001 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case -2:
                            if (0x00000002 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

        }

        if (!valid_discriminator)
        {
            throw eprosima::fastcdr::exception::BadParamException("Discriminator doesn't correspond with the selected union member");
        }

        m__d = __d;
    }

    /*!
     * @brief This function returns the value of the discriminator.
     * @return Value of the discriminator
     */
    eProsima_user_DllExport int16_t _d() const
    {
        return m__d;
    }

    /*!
     * @brief This function sets a value in member first
     * @param _first New value for member first
     */
    eProsima_user_DllExport void first(
            int32_t _first)
    {
        first_() = _first;
        m__d = 1;
    }

    /*!
     * @brief This function returns the value of member first
     * @return Value of member first
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int32_t first() const
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_first;
    }

    /*!
     * @brief This function returns a reference to member first
     * @return Reference to member first
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int32_t& first()
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_first;
    }


    /*!
     * @brief This function sets a value in member second
     * @param _second New value for member second
     */
    eProsima_user_DllExport void second(
            int64_t _second)
    {
        second_() = _second;
        m__d = -2;
    }

    /*!
     * @brief This function returns the value of member second
     * @return Value of member second
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int64_t second() const
    {
        if (0x00000002 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_second;
    }

    /*!
     * @brief This function returns a reference to member second
     * @return Reference to member second
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int64_t& second()
    {
        if (0x00000002 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_second;
    }


    void _default()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }

        selected_member_ = 0x0FFFFFFFu;
    }


private:

            int32_t& first_()
            {
                if (0x00000001 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000001;
                    member_destructor_ = nullptr;
                    m_first = {0};

                }

                return m_first;
            }

            int64_t& second_()
            {
                if (0x00000002 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000002;
                    member_destructor_ = nullptr;
                    m_second = {0};

                }

                return m_second;
            }


    int16_t m__d {32767};

    union
    {
        int32_t m_first;
        int64_t m_second;
    };

    uint32_t selected_member_ {0x0FFFFFFFu};

    std::function<void()> member_destructor_;
};
/*!
 * @brief This class represents the union Union_Discriminator_unsigned_short defined by the user in the IDL file.
 * @ingroup unions
 */
class Union_Discriminator_unsigned_short
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Union_Discriminator_unsigned_short()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Union_Discriminator_unsigned_short()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Union_Discriminator_unsigned_short that will be copied.
     */
    eProsima_user_DllExport Union_Discriminator_unsigned_short(
            const Union_Discriminator_unsigned_short& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            first_() = x.m_first;
                            break;

                        case 0x00000002:
                            second_() = x.m_second;
                            break;

        }
    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Union_Discriminator_unsigned_short that will be copied.
     */
    eProsima_user_DllExport Union_Discriminator_unsigned_short(
            Union_Discriminator_unsigned_short&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            first_() = std::move(x.m_first);
                            break;

                        case 0x00000002:
                            second_() = std::move(x.m_second);
                            break;

        }
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Union_Discriminator_unsigned_short that will be copied.
     */
    eProsima_user_DllExport Union_Discriminator_unsigned_short& operator =(
            const Union_Discriminator_unsigned_short& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            first_() = x.m_first;
                            break;

                        case 0x00000002:
                            second_() = x.m_second;
                            break;

        }

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Union_Discriminator_unsigned_short that will be copied.
     */
    eProsima_user_DllExport Union_Discriminator_unsigned_short& operator =(
            Union_Discriminator_unsigned_short&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            first_() = std::move(x.m_first);
                            break;

                        case 0x00000002:
                            second_() = std::move(x.m_second);
                            break;

        }

        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Union_Discriminator_unsigned_short object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Union_Discriminator_unsigned_short& x) const
    {
        bool ret_value {false};

        if (x.selected_member_ == selected_member_)
        {
            if (0x0FFFFFFFu != selected_member_)
            {
                if (x.m__d == m__d)
                {
                    switch (selected_member_)
                    {
                                                    case 0x00000001:
                                                        ret_value = (x.m_first == m_first);
                                                        break;

                                                    case 0x00000002:
                                                        ret_value = (x.m_second == m_second);
                                                        break;

                    }
                }
            }
            else
            {
                ret_value = true;
            }
        }

        return ret_value;
    }

    /*!
     * @brief Comparison operator.
     * @param x Union_Discriminator_unsigned_short object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Union_Discriminator_unsigned_short& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets the discriminator value.
     * @param __d New value for the discriminator.
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the new value doesn't correspond to the selected union member.
     */
    eProsima_user_DllExport void _d(
            uint16_t __d)
    {
        bool valid_discriminator = false;

        switch (__d)
        {
                        case 1:
                            if (0x00000001 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case 2:
                            if (0x00000002 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

        }

        if (!valid_discriminator)
        {
            throw eprosima::fastcdr::exception::BadParamException("Discriminator doesn't correspond with the selected union member");
        }

        m__d = __d;
    }

    /*!
     * @brief This function returns the value of the discriminator.
     * @return Value of the discriminator
     */
    eProsima_user_DllExport uint16_t _d() const
    {
        return m__d;
    }

    /*!
     * @brief This function sets a value in member first
     * @param _first New value for member first
     */
    eProsima_user_DllExport void first(
            int32_t _first)
    {
        first_() = _first;
        m__d = 1;
    }

    /*!
     * @brief This function returns the value of member first
     * @return Value of member first
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int32_t first() const
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_first;
    }

    /*!
     * @brief This function returns a reference to member first
     * @return Reference to member first
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int32_t& first()
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_first;
    }


    /*!
     * @brief This function sets a value in member second
     * @param _second New value for member second
     */
    eProsima_user_DllExport void second(
            int64_t _second)
    {
        second_() = _second;
        m__d = 2;
    }

    /*!
     * @brief This function returns the value of member second
     * @return Value of member second
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int64_t second() const
    {
        if (0x00000002 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_second;
    }

    /*!
     * @brief This function returns a reference to member second
     * @return Reference to member second
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int64_t& second()
    {
        if (0x00000002 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_second;
    }


    void _default()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }

        selected_member_ = 0x0FFFFFFFu;
    }


private:

            int32_t& first_()
            {
                if (0x00000001 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000001;
                    member_destructor_ = nullptr;
                    m_first = {0};

                }

                return m_first;
            }

            int64_t& second_()
            {
                if (0x00000002 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000002;
                    member_destructor_ = nullptr;
                    m_second = {0};

                }

                return m_second;
            }


    uint16_t m__d {32767};

    union
    {
        int32_t m_first;
        int64_t m_second;
    };

    uint32_t selected_member_ {0x0FFFFFFFu};

    std::function<void()> member_destructor_;
};
/*!
 * @brief This class represents the union Union_Discriminator_long defined by the user in the IDL file.
 * @ingroup unions
 */
class Union_Discriminator_long
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Union_Discriminator_long()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Union_Discriminator_long()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Union_Discriminator_long that will be copied.
     */
    eProsima_user_DllExport Union_Discriminator_long(
            const Union_Discriminator_long& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            first_() = x.m_first;
                            break;

                        case 0x00000002:
                            second_() = x.m_second;
                            break;

        }
    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Union_Discriminator_long that will be copied.
     */
    eProsima_user_DllExport Union_Discriminator_long(
            Union_Discriminator_long&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            first_() = std::move(x.m_first);
                            break;

                        case 0x00000002:
                            second_() = std::move(x.m_second);
                            break;

        }
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Union_Discriminator_long that will be copied.
     */
    eProsima_user_DllExport Union_Discriminator_long& operator =(
            const Union_Discriminator_long& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            first_() = x.m_first;
                            break;

                        case 0x00000002:
                            second_() = x.m_second;
                            break;

        }

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Union_Discriminator_long that will be copied.
     */
    eProsima_user_DllExport Union_Discriminator_long& operator =(
            Union_Discriminator_long&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            first_() = std::move(x.m_first);
                            break;

                        case 0x00000002:
                            second_() = std::move(x.m_second);
                            break;

        }

        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Union_Discriminator_long object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Union_Discriminator_long& x) const
    {
        bool ret_value {false};

        if (x.selected_member_ == selected_member_)
        {
            if (0x0FFFFFFFu != selected_member_)
            {
                if (x.m__d == m__d)
                {
                    switch (selected_member_)
                    {
                                                    case 0x00000001:
                                                        ret_value = (x.m_first == m_first);
                                                        break;

                                                    case 0x00000002:
                                                        ret_value = (x.m_second == m_second);
                                                        break;

                    }
                }
            }
            else
            {
                ret_value = true;
            }
        }

        return ret_value;
    }

    /*!
     * @brief Comparison operator.
     * @param x Union_Discriminator_long object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Union_Discriminator_long& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets the discriminator value.
     * @param __d New value for the discriminator.
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the new value doesn't correspond to the selected union member.
     */
    eProsima_user_DllExport void _d(
            int32_t __d)
    {
        bool valid_discriminator = false;

        switch (__d)
        {
                        case 1:
                            if (0x00000001 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case -2:
                            if (0x00000002 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

        }

        if (!valid_discriminator)
        {
            throw eprosima::fastcdr::exception::BadParamException("Discriminator doesn't correspond with the selected union member");
        }

        m__d = __d;
    }

    /*!
     * @brief This function returns the value of the discriminator.
     * @return Value of the discriminator
     */
    eProsima_user_DllExport int32_t _d() const
    {
        return m__d;
    }

    /*!
     * @brief This function sets a value in member first
     * @param _first New value for member first
     */
    eProsima_user_DllExport void first(
            int32_t _first)
    {
        first_() = _first;
        m__d = 1;
    }

    /*!
     * @brief This function returns the value of member first
     * @return Value of member first
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int32_t first() const
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_first;
    }

    /*!
     * @brief This function returns a reference to member first
     * @return Reference to member first
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int32_t& first()
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_first;
    }


    /*!
     * @brief This function sets a value in member second
     * @param _second New value for member second
     */
    eProsima_user_DllExport void second(
            int64_t _second)
    {
        second_() = _second;
        m__d = -2;
    }

    /*!
     * @brief This function returns the value of member second
     * @return Value of member second
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int64_t second() const
    {
        if (0x00000002 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_second;
    }

    /*!
     * @brief This function returns a reference to member second
     * @return Reference to member second
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int64_t& second()
    {
        if (0x00000002 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_second;
    }


    void _default()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }

        selected_member_ = 0x0FFFFFFFu;
    }


private:

            int32_t& first_()
            {
                if (0x00000001 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000001;
                    member_destructor_ = nullptr;
                    m_first = {0};

                }

                return m_first;
            }

            int64_t& second_()
            {
                if (0x00000002 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000002;
                    member_destructor_ = nullptr;
                    m_second = {0};

                }

                return m_second;
            }


    int32_t m__d {2147483647};

    union
    {
        int32_t m_first;
        int64_t m_second;
    };

    uint32_t selected_member_ {0x0FFFFFFFu};

    std::function<void()> member_destructor_;
};
/*!
 * @brief This class represents the union Union_Discriminator_unsigned_long defined by the user in the IDL file.
 * @ingroup unions
 */
class Union_Discriminator_unsigned_long
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Union_Discriminator_unsigned_long()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Union_Discriminator_unsigned_long()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Union_Discriminator_unsigned_long that will be copied.
     */
    eProsima_user_DllExport Union_Discriminator_unsigned_long(
            const Union_Discriminator_unsigned_long& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            first_() = x.m_first;
                            break;

                        case 0x00000002:
                            second_() = x.m_second;
                            break;

        }
    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Union_Discriminator_unsigned_long that will be copied.
     */
    eProsima_user_DllExport Union_Discriminator_unsigned_long(
            Union_Discriminator_unsigned_long&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            first_() = std::move(x.m_first);
                            break;

                        case 0x00000002:
                            second_() = std::move(x.m_second);
                            break;

        }
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Union_Discriminator_unsigned_long that will be copied.
     */
    eProsima_user_DllExport Union_Discriminator_unsigned_long& operator =(
            const Union_Discriminator_unsigned_long& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            first_() = x.m_first;
                            break;

                        case 0x00000002:
                            second_() = x.m_second;
                            break;

        }

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Union_Discriminator_unsigned_long that will be copied.
     */
    eProsima_user_DllExport Union_Discriminator_unsigned_long& operator =(
            Union_Discriminator_unsigned_long&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            first_() = std::move(x.m_first);
                            break;

                        case 0x00000002:
                            second_() = std::move(x.m_second);
                            break;

        }

        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Union_Discriminator_unsigned_long object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Union_Discriminator_unsigned_long& x) const
    {
        bool ret_value {false};

        if (x.selected_member_ == selected_member_)
        {
            if (0x0FFFFFFFu != selected_member_)
            {
                if (x.m__d == m__d)
                {
                    switch (selected_member_)
                    {
                                                    case 0x00000001:
                                                        ret_value = (x.m_first == m_first);
                                                        break;

                                                    case 0x00000002:
                                                        ret_value = (x.m_second == m_second);
                                                        break;

                    }
                }
            }
            else
            {
                ret_value = true;
            }
        }

        return ret_value;
    }

    /*!
     * @brief Comparison operator.
     * @param x Union_Discriminator_unsigned_long object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Union_Discriminator_unsigned_long& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets the discriminator value.
     * @param __d New value for the discriminator.
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the new value doesn't correspond to the selected union member.
     */
    eProsima_user_DllExport void _d(
            uint32_t __d)
    {
        bool valid_discriminator = false;

        switch (__d)
        {
                        case 1:
                            if (0x00000001 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case 2:
                            if (0x00000002 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

        }

        if (!valid_discriminator)
        {
            throw eprosima::fastcdr::exception::BadParamException("Discriminator doesn't correspond with the selected union member");
        }

        m__d = __d;
    }

    /*!
     * @brief This function returns the value of the discriminator.
     * @return Value of the discriminator
     */
    eProsima_user_DllExport uint32_t _d() const
    {
        return m__d;
    }

    /*!
     * @brief This function sets a value in member first
     * @param _first New value for member first
     */
    eProsima_user_DllExport void first(
            int32_t _first)
    {
        first_() = _first;
        m__d = 1;
    }

    /*!
     * @brief This function returns the value of member first
     * @return Value of member first
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int32_t first() const
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_first;
    }

    /*!
     * @brief This function returns a reference to member first
     * @return Reference to member first
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int32_t& first()
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_first;
    }


    /*!
     * @brief This function sets a value in member second
     * @param _second New value for member second
     */
    eProsima_user_DllExport void second(
            int64_t _second)
    {
        second_() = _second;
        m__d = 2;
    }

    /*!
     * @brief This function returns the value of member second
     * @return Value of member second
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int64_t second() const
    {
        if (0x00000002 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_second;
    }

    /*!
     * @brief This function returns a reference to member second
     * @return Reference to member second
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int64_t& second()
    {
        if (0x00000002 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_second;
    }


    void _default()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }

        selected_member_ = 0x0FFFFFFFu;
    }


private:

            int32_t& first_()
            {
                if (0x00000001 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000001;
                    member_destructor_ = nullptr;
                    m_first = {0};

                }

                return m_first;
            }

            int64_t& second_()
            {
                if (0x00000002 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000002;
                    member_destructor_ = nullptr;
                    m_second = {0};

                }

                return m_second;
            }


    uint32_t m__d {2147483647};

    union
    {
        int32_t m_first;
        int64_t m_second;
    };

    uint32_t selected_member_ {0x0FFFFFFFu};

    std::function<void()> member_destructor_;
};
/*!
 * @brief This class represents the union Union_Discriminator_long_long defined by the user in the IDL file.
 * @ingroup unions
 */
class Union_Discriminator_long_long
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Union_Discriminator_long_long()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Union_Discriminator_long_long()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Union_Discriminator_long_long that will be copied.
     */
    eProsima_user_DllExport Union_Discriminator_long_long(
            const Union_Discriminator_long_long& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            first_() = x.m_first;
                            break;

                        case 0x00000002:
                            second_() = x.m_second;
                            break;

        }
    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Union_Discriminator_long_long that will be copied.
     */
    eProsima_user_DllExport Union_Discriminator_long_long(
            Union_Discriminator_long_long&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            first_() = std::move(x.m_first);
                            break;

                        case 0x00000002:
                            second_() = std::move(x.m_second);
                            break;

        }
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Union_Discriminator_long_long that will be copied.
     */
    eProsima_user_DllExport Union_Discriminator_long_long& operator =(
            const Union_Discriminator_long_long& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            first_() = x.m_first;
                            break;

                        case 0x00000002:
                            second_() = x.m_second;
                            break;

        }

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Union_Discriminator_long_long that will be copied.
     */
    eProsima_user_DllExport Union_Discriminator_long_long& operator =(
            Union_Discriminator_long_long&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            first_() = std::move(x.m_first);
                            break;

                        case 0x00000002:
                            second_() = std::move(x.m_second);
                            break;

        }

        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Union_Discriminator_long_long object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Union_Discriminator_long_long& x) const
    {
        bool ret_value {false};

        if (x.selected_member_ == selected_member_)
        {
            if (0x0FFFFFFFu != selected_member_)
            {
                if (x.m__d == m__d)
                {
                    switch (selected_member_)
                    {
                                                    case 0x00000001:
                                                        ret_value = (x.m_first == m_first);
                                                        break;

                                                    case 0x00000002:
                                                        ret_value = (x.m_second == m_second);
                                                        break;

                    }
                }
            }
            else
            {
                ret_value = true;
            }
        }

        return ret_value;
    }

    /*!
     * @brief Comparison operator.
     * @param x Union_Discriminator_long_long object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Union_Discriminator_long_long& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets the discriminator value.
     * @param __d New value for the discriminator.
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the new value doesn't correspond to the selected union member.
     */
    eProsima_user_DllExport void _d(
            int64_t __d)
    {
        bool valid_discriminator = false;

        switch (__d)
        {
                        case 1:
                            if (0x00000001 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case -2:
                            if (0x00000002 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

        }

        if (!valid_discriminator)
        {
            throw eprosima::fastcdr::exception::BadParamException("Discriminator doesn't correspond with the selected union member");
        }

        m__d = __d;
    }

    /*!
     * @brief This function returns the value of the discriminator.
     * @return Value of the discriminator
     */
    eProsima_user_DllExport int64_t _d() const
    {
        return m__d;
    }

    /*!
     * @brief This function sets a value in member first
     * @param _first New value for member first
     */
    eProsima_user_DllExport void first(
            int32_t _first)
    {
        first_() = _first;
        m__d = 1;
    }

    /*!
     * @brief This function returns the value of member first
     * @return Value of member first
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int32_t first() const
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_first;
    }

    /*!
     * @brief This function returns a reference to member first
     * @return Reference to member first
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int32_t& first()
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_first;
    }


    /*!
     * @brief This function sets a value in member second
     * @param _second New value for member second
     */
    eProsima_user_DllExport void second(
            int64_t _second)
    {
        second_() = _second;
        m__d = -2;
    }

    /*!
     * @brief This function returns the value of member second
     * @return Value of member second
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int64_t second() const
    {
        if (0x00000002 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_second;
    }

    /*!
     * @brief This function returns a reference to member second
     * @return Reference to member second
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int64_t& second()
    {
        if (0x00000002 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_second;
    }


    void _default()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }

        selected_member_ = 0x0FFFFFFFu;
    }


private:

            int32_t& first_()
            {
                if (0x00000001 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000001;
                    member_destructor_ = nullptr;
                    m_first = {0};

                }

                return m_first;
            }

            int64_t& second_()
            {
                if (0x00000002 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000002;
                    member_destructor_ = nullptr;
                    m_second = {0};

                }

                return m_second;
            }


    int64_t m__d {9223372036854775807};

    union
    {
        int32_t m_first;
        int64_t m_second;
    };

    uint32_t selected_member_ {0x0FFFFFFFu};

    std::function<void()> member_destructor_;
};
/*!
 * @brief This class represents the union Union_Discriminator_unsigned_long_long defined by the user in the IDL file.
 * @ingroup unions
 */
class Union_Discriminator_unsigned_long_long
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Union_Discriminator_unsigned_long_long()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Union_Discriminator_unsigned_long_long()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Union_Discriminator_unsigned_long_long that will be copied.
     */
    eProsima_user_DllExport Union_Discriminator_unsigned_long_long(
            const Union_Discriminator_unsigned_long_long& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            first_() = x.m_first;
                            break;

                        case 0x00000002:
                            second_() = x.m_second;
                            break;

        }
    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Union_Discriminator_unsigned_long_long that will be copied.
     */
    eProsima_user_DllExport Union_Discriminator_unsigned_long_long(
            Union_Discriminator_unsigned_long_long&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            first_() = std::move(x.m_first);
                            break;

                        case 0x00000002:
                            second_() = std::move(x.m_second);
                            break;

        }
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Union_Discriminator_unsigned_long_long that will be copied.
     */
    eProsima_user_DllExport Union_Discriminator_unsigned_long_long& operator =(
            const Union_Discriminator_unsigned_long_long& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            first_() = x.m_first;
                            break;

                        case 0x00000002:
                            second_() = x.m_second;
                            break;

        }

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Union_Discriminator_unsigned_long_long that will be copied.
     */
    eProsima_user_DllExport Union_Discriminator_unsigned_long_long& operator =(
            Union_Discriminator_unsigned_long_long&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            first_() = std::move(x.m_first);
                            break;

                        case 0x00000002:
                            second_() = std::move(x.m_second);
                            break;

        }

        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Union_Discriminator_unsigned_long_long object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Union_Discriminator_unsigned_long_long& x) const
    {
        bool ret_value {false};

        if (x.selected_member_ == selected_member_)
        {
            if (0x0FFFFFFFu != selected_member_)
            {
                if (x.m__d == m__d)
                {
                    switch (selected_member_)
                    {
                                                    case 0x00000001:
                                                        ret_value = (x.m_first == m_first);
                                                        break;

                                                    case 0x00000002:
                                                        ret_value = (x.m_second == m_second);
                                                        break;

                    }
                }
            }
            else
            {
                ret_value = true;
            }
        }

        return ret_value;
    }

    /*!
     * @brief Comparison operator.
     * @param x Union_Discriminator_unsigned_long_long object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Union_Discriminator_unsigned_long_long& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets the discriminator value.
     * @param __d New value for the discriminator.
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the new value doesn't correspond to the selected union member.
     */
    eProsima_user_DllExport void _d(
            uint64_t __d)
    {
        bool valid_discriminator = false;

        switch (__d)
        {
                        case 2:
                            if (0x00000001 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case 1:
                            if (0x00000002 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

        }

        if (!valid_discriminator)
        {
            throw eprosima::fastcdr::exception::BadParamException("Discriminator doesn't correspond with the selected union member");
        }

        m__d = __d;
    }

    /*!
     * @brief This function returns the value of the discriminator.
     * @return Value of the discriminator
     */
    eProsima_user_DllExport uint64_t _d() const
    {
        return m__d;
    }

    /*!
     * @brief This function sets a value in member first
     * @param _first New value for member first
     */
    eProsima_user_DllExport void first(
            int32_t _first)
    {
        first_() = _first;
        m__d = 2;
    }

    /*!
     * @brief This function returns the value of member first
     * @return Value of member first
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int32_t first() const
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_first;
    }

    /*!
     * @brief This function returns a reference to member first
     * @return Reference to member first
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int32_t& first()
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_first;
    }


    /*!
     * @brief This function sets a value in member second
     * @param _second New value for member second
     */
    eProsima_user_DllExport void second(
            int64_t _second)
    {
        second_() = _second;
        m__d = 1;
    }

    /*!
     * @brief This function returns the value of member second
     * @return Value of member second
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int64_t second() const
    {
        if (0x00000002 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_second;
    }

    /*!
     * @brief This function returns a reference to member second
     * @return Reference to member second
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int64_t& second()
    {
        if (0x00000002 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_second;
    }


    void _default()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }

        selected_member_ = 0x0FFFFFFFu;
    }


private:

            int32_t& first_()
            {
                if (0x00000001 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000001;
                    member_destructor_ = nullptr;
                    m_first = {0};

                }

                return m_first;
            }

            int64_t& second_()
            {
                if (0x00000002 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000002;
                    member_destructor_ = nullptr;
                    m_second = {0};

                }

                return m_second;
            }


    uint64_t m__d {9223372036854775807};

    union
    {
        int32_t m_first;
        int64_t m_second;
    };

    uint32_t selected_member_ {0x0FFFFFFFu};

    std::function<void()> member_destructor_;
};
/*!
 * @brief This class represents the union Union_Discriminator_boolean defined by the user in the IDL file.
 * @ingroup unions
 */
class Union_Discriminator_boolean
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Union_Discriminator_boolean()
    {
        selected_member_ = 0x00000001;
        member_destructor_ = nullptr;
        m_first = {0};

    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Union_Discriminator_boolean()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Union_Discriminator_boolean that will be copied.
     */
    eProsima_user_DllExport Union_Discriminator_boolean(
            const Union_Discriminator_boolean& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            first_() = x.m_first;
                            break;

                        case 0x00000002:
                            second_() = x.m_second;
                            break;

        }
    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Union_Discriminator_boolean that will be copied.
     */
    eProsima_user_DllExport Union_Discriminator_boolean(
            Union_Discriminator_boolean&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            first_() = std::move(x.m_first);
                            break;

                        case 0x00000002:
                            second_() = std::move(x.m_second);
                            break;

        }
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Union_Discriminator_boolean that will be copied.
     */
    eProsima_user_DllExport Union_Discriminator_boolean& operator =(
            const Union_Discriminator_boolean& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            first_() = x.m_first;
                            break;

                        case 0x00000002:
                            second_() = x.m_second;
                            break;

        }

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Union_Discriminator_boolean that will be copied.
     */
    eProsima_user_DllExport Union_Discriminator_boolean& operator =(
            Union_Discriminator_boolean&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            first_() = std::move(x.m_first);
                            break;

                        case 0x00000002:
                            second_() = std::move(x.m_second);
                            break;

        }

        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Union_Discriminator_boolean object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Union_Discriminator_boolean& x) const
    {
        bool ret_value {false};

        if (x.selected_member_ == selected_member_)
        {
            if (0x0FFFFFFFu != selected_member_)
            {
                if (x.m__d == m__d)
                {
                    switch (selected_member_)
                    {
                                                    case 0x00000001:
                                                        ret_value = (x.m_first == m_first);
                                                        break;

                                                    case 0x00000002:
                                                        ret_value = (x.m_second == m_second);
                                                        break;

                    }
                }
            }
            else
            {
                ret_value = true;
            }
        }

        return ret_value;
    }

    /*!
     * @brief Comparison operator.
     * @param x Union_Discriminator_boolean object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Union_Discriminator_boolean& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets the discriminator value.
     * @param __d New value for the discriminator.
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the new value doesn't correspond to the selected union member.
     */
    eProsima_user_DllExport void _d(
            bool __d)
    {
        bool valid_discriminator = false;

        switch (__d)
        {
                        case true:
                            if (0x00000001 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case false:
                            if (0x00000002 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

        }

        if (!valid_discriminator)
        {
            throw eprosima::fastcdr::exception::BadParamException("Discriminator doesn't correspond with the selected union member");
        }

        m__d = __d;
    }

    /*!
     * @brief This function returns the value of the discriminator.
     * @return Value of the discriminator
     */
    eProsima_user_DllExport bool _d() const
    {
        return m__d;
    }

    /*!
     * @brief This function sets a value in member first
     * @param _first New value for member first
     */
    eProsima_user_DllExport void first(
            int32_t _first)
    {
        first_() = _first;
        m__d = true;
    }

    /*!
     * @brief This function returns the value of member first
     * @return Value of member first
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int32_t first() const
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_first;
    }

    /*!
     * @brief This function returns a reference to member first
     * @return Reference to member first
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int32_t& first()
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_first;
    }


    /*!
     * @brief This function sets a value in member second
     * @param _second New value for member second
     */
    eProsima_user_DllExport void second(
            int64_t _second)
    {
        second_() = _second;
        m__d = false;
    }

    /*!
     * @brief This function returns the value of member second
     * @return Value of member second
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int64_t second() const
    {
        if (0x00000002 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_second;
    }

    /*!
     * @brief This function returns a reference to member second
     * @return Reference to member second
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int64_t& second()
    {
        if (0x00000002 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_second;
    }



private:

            int32_t& first_()
            {
                if (0x00000001 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000001;
                    member_destructor_ = nullptr;
                    m_first = {0};

                }

                return m_first;
            }

            int64_t& second_()
            {
                if (0x00000002 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000002;
                    member_destructor_ = nullptr;
                    m_second = {0};

                }

                return m_second;
            }


    bool m__d {true};

    union
    {
        int32_t m_first;
        int64_t m_second;
    };

    uint32_t selected_member_ {0x0FFFFFFFu};

    std::function<void()> member_destructor_;
};
/*!
 * @brief This class represents the union Union_Discriminator_octet defined by the user in the IDL file.
 * @ingroup unions
 */
class Union_Discriminator_octet
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Union_Discriminator_octet()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Union_Discriminator_octet()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Union_Discriminator_octet that will be copied.
     */
    eProsima_user_DllExport Union_Discriminator_octet(
            const Union_Discriminator_octet& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            first_() = x.m_first;
                            break;

                        case 0x00000002:
                            second_() = x.m_second;
                            break;

        }
    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Union_Discriminator_octet that will be copied.
     */
    eProsima_user_DllExport Union_Discriminator_octet(
            Union_Discriminator_octet&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            first_() = std::move(x.m_first);
                            break;

                        case 0x00000002:
                            second_() = std::move(x.m_second);
                            break;

        }
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Union_Discriminator_octet that will be copied.
     */
    eProsima_user_DllExport Union_Discriminator_octet& operator =(
            const Union_Discriminator_octet& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            first_() = x.m_first;
                            break;

                        case 0x00000002:
                            second_() = x.m_second;
                            break;

        }

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Union_Discriminator_octet that will be copied.
     */
    eProsima_user_DllExport Union_Discriminator_octet& operator =(
            Union_Discriminator_octet&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            first_() = std::move(x.m_first);
                            break;

                        case 0x00000002:
                            second_() = std::move(x.m_second);
                            break;

        }

        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Union_Discriminator_octet object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Union_Discriminator_octet& x) const
    {
        bool ret_value {false};

        if (x.selected_member_ == selected_member_)
        {
            if (0x0FFFFFFFu != selected_member_)
            {
                if (x.m__d == m__d)
                {
                    switch (selected_member_)
                    {
                                                    case 0x00000001:
                                                        ret_value = (x.m_first == m_first);
                                                        break;

                                                    case 0x00000002:
                                                        ret_value = (x.m_second == m_second);
                                                        break;

                    }
                }
            }
            else
            {
                ret_value = true;
            }
        }

        return ret_value;
    }

    /*!
     * @brief Comparison operator.
     * @param x Union_Discriminator_octet object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Union_Discriminator_octet& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets the discriminator value.
     * @param __d New value for the discriminator.
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the new value doesn't correspond to the selected union member.
     */
    eProsima_user_DllExport void _d(
            uint8_t __d)
    {
        bool valid_discriminator = false;

        switch (__d)
        {
                        case 0:
                            if (0x00000001 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case 1:
                            if (0x00000002 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

        }

        if (!valid_discriminator)
        {
            throw eprosima::fastcdr::exception::BadParamException("Discriminator doesn't correspond with the selected union member");
        }

        m__d = __d;
    }

    /*!
     * @brief This function returns the value of the discriminator.
     * @return Value of the discriminator
     */
    eProsima_user_DllExport uint8_t _d() const
    {
        return m__d;
    }

    /*!
     * @brief This function sets a value in member first
     * @param _first New value for member first
     */
    eProsima_user_DllExport void first(
            int32_t _first)
    {
        first_() = _first;
        m__d = 0;
    }

    /*!
     * @brief This function returns the value of member first
     * @return Value of member first
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int32_t first() const
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_first;
    }

    /*!
     * @brief This function returns a reference to member first
     * @return Reference to member first
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int32_t& first()
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_first;
    }


    /*!
     * @brief This function sets a value in member second
     * @param _second New value for member second
     */
    eProsima_user_DllExport void second(
            int64_t _second)
    {
        second_() = _second;
        m__d = 1;
    }

    /*!
     * @brief This function returns the value of member second
     * @return Value of member second
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int64_t second() const
    {
        if (0x00000002 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_second;
    }

    /*!
     * @brief This function returns a reference to member second
     * @return Reference to member second
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int64_t& second()
    {
        if (0x00000002 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_second;
    }


    void _default()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }

        selected_member_ = 0x0FFFFFFFu;
    }


private:

            int32_t& first_()
            {
                if (0x00000001 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000001;
                    member_destructor_ = nullptr;
                    m_first = {0};

                }

                return m_first;
            }

            int64_t& second_()
            {
                if (0x00000002 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000002;
                    member_destructor_ = nullptr;
                    m_second = {0};

                }

                return m_second;
            }


    uint8_t m__d {127};

    union
    {
        int32_t m_first;
        int64_t m_second;
    };

    uint32_t selected_member_ {0x0FFFFFFFu};

    std::function<void()> member_destructor_;
};
/*!
 * @brief This class represents the union Union_Discriminator_char defined by the user in the IDL file.
 * @ingroup unions
 */
class Union_Discriminator_char
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Union_Discriminator_char()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Union_Discriminator_char()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Union_Discriminator_char that will be copied.
     */
    eProsima_user_DllExport Union_Discriminator_char(
            const Union_Discriminator_char& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            first_() = x.m_first;
                            break;

                        case 0x00000002:
                            second_() = x.m_second;
                            break;

        }
    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Union_Discriminator_char that will be copied.
     */
    eProsima_user_DllExport Union_Discriminator_char(
            Union_Discriminator_char&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            first_() = std::move(x.m_first);
                            break;

                        case 0x00000002:
                            second_() = std::move(x.m_second);
                            break;

        }
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Union_Discriminator_char that will be copied.
     */
    eProsima_user_DllExport Union_Discriminator_char& operator =(
            const Union_Discriminator_char& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            first_() = x.m_first;
                            break;

                        case 0x00000002:
                            second_() = x.m_second;
                            break;

        }

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Union_Discriminator_char that will be copied.
     */
    eProsima_user_DllExport Union_Discriminator_char& operator =(
            Union_Discriminator_char&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            first_() = std::move(x.m_first);
                            break;

                        case 0x00000002:
                            second_() = std::move(x.m_second);
                            break;

        }

        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Union_Discriminator_char object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Union_Discriminator_char& x) const
    {
        bool ret_value {false};

        if (x.selected_member_ == selected_member_)
        {
            if (0x0FFFFFFFu != selected_member_)
            {
                if (x.m__d == m__d)
                {
                    switch (selected_member_)
                    {
                                                    case 0x00000001:
                                                        ret_value = (x.m_first == m_first);
                                                        break;

                                                    case 0x00000002:
                                                        ret_value = (x.m_second == m_second);
                                                        break;

                    }
                }
            }
            else
            {
                ret_value = true;
            }
        }

        return ret_value;
    }

    /*!
     * @brief Comparison operator.
     * @param x Union_Discriminator_char object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Union_Discriminator_char& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets the discriminator value.
     * @param __d New value for the discriminator.
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the new value doesn't correspond to the selected union member.
     */
    eProsima_user_DllExport void _d(
            char __d)
    {
        bool valid_discriminator = false;

        switch (__d)
        {
                        case 'a':
                            if (0x00000001 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case 'b':
                            if (0x00000002 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

        }

        if (!valid_discriminator)
        {
            throw eprosima::fastcdr::exception::BadParamException("Discriminator doesn't correspond with the selected union member");
        }

        m__d = __d;
    }

    /*!
     * @brief This function returns the value of the discriminator.
     * @return Value of the discriminator
     */
    eProsima_user_DllExport char _d() const
    {
        return m__d;
    }

    /*!
     * @brief This function sets a value in member first
     * @param _first New value for member first
     */
    eProsima_user_DllExport void first(
            int32_t _first)
    {
        first_() = _first;
        m__d = 'a';
    }

    /*!
     * @brief This function returns the value of member first
     * @return Value of member first
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int32_t first() const
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_first;
    }

    /*!
     * @brief This function returns a reference to member first
     * @return Reference to member first
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int32_t& first()
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_first;
    }


    /*!
     * @brief This function sets a value in member second
     * @param _second New value for member second
     */
    eProsima_user_DllExport void second(
            int64_t _second)
    {
        second_() = _second;
        m__d = 'b';
    }

    /*!
     * @brief This function returns the value of member second
     * @return Value of member second
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int64_t second() const
    {
        if (0x00000002 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_second;
    }

    /*!
     * @brief This function returns a reference to member second
     * @return Reference to member second
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int64_t& second()
    {
        if (0x00000002 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_second;
    }


    void _default()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }

        selected_member_ = 0x0FFFFFFFu;
    }


private:

            int32_t& first_()
            {
                if (0x00000001 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000001;
                    member_destructor_ = nullptr;
                    m_first = {0};

                }

                return m_first;
            }

            int64_t& second_()
            {
                if (0x00000002 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000002;
                    member_destructor_ = nullptr;
                    m_second = {0};

                }

                return m_second;
            }


    char m__d {127};

    union
    {
        int32_t m_first;
        int64_t m_second;
    };

    uint32_t selected_member_ {0x0FFFFFFFu};

    std::function<void()> member_destructor_;
};
/*!
 * @brief This class represents the union Union_Discriminator_wchar defined by the user in the IDL file.
 * @ingroup unions
 */
class Union_Discriminator_wchar
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Union_Discriminator_wchar()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Union_Discriminator_wchar()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Union_Discriminator_wchar that will be copied.
     */
    eProsima_user_DllExport Union_Discriminator_wchar(
            const Union_Discriminator_wchar& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            first_() = x.m_first;
                            break;

                        case 0x00000002:
                            second_() = x.m_second;
                            break;

        }
    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Union_Discriminator_wchar that will be copied.
     */
    eProsima_user_DllExport Union_Discriminator_wchar(
            Union_Discriminator_wchar&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            first_() = std::move(x.m_first);
                            break;

                        case 0x00000002:
                            second_() = std::move(x.m_second);
                            break;

        }
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Union_Discriminator_wchar that will be copied.
     */
    eProsima_user_DllExport Union_Discriminator_wchar& operator =(
            const Union_Discriminator_wchar& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            first_() = x.m_first;
                            break;

                        case 0x00000002:
                            second_() = x.m_second;
                            break;

        }

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Union_Discriminator_wchar that will be copied.
     */
    eProsima_user_DllExport Union_Discriminator_wchar& operator =(
            Union_Discriminator_wchar&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            first_() = std::move(x.m_first);
                            break;

                        case 0x00000002:
                            second_() = std::move(x.m_second);
                            break;

        }

        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Union_Discriminator_wchar object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Union_Discriminator_wchar& x) const
    {
        bool ret_value {false};

        if (x.selected_member_ == selected_member_)
        {
            if (0x0FFFFFFFu != selected_member_)
            {
                if (x.m__d == m__d)
                {
                    switch (selected_member_)
                    {
                                                    case 0x00000001:
                                                        ret_value = (x.m_first == m_first);
                                                        break;

                                                    case 0x00000002:
                                                        ret_value = (x.m_second == m_second);
                                                        break;

                    }
                }
            }
            else
            {
                ret_value = true;
            }
        }

        return ret_value;
    }

    /*!
     * @brief Comparison operator.
     * @param x Union_Discriminator_wchar object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Union_Discriminator_wchar& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets the discriminator value.
     * @param __d New value for the discriminator.
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the new value doesn't correspond to the selected union member.
     */
    eProsima_user_DllExport void _d(
            wchar_t __d)
    {
        bool valid_discriminator = false;

        switch (__d)
        {
                        case L'a':
                            if (0x00000001 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case L'b':
                            if (0x00000002 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

        }

        if (!valid_discriminator)
        {
            throw eprosima::fastcdr::exception::BadParamException("Discriminator doesn't correspond with the selected union member");
        }

        m__d = __d;
    }

    /*!
     * @brief This function returns the value of the discriminator.
     * @return Value of the discriminator
     */
    eProsima_user_DllExport wchar_t _d() const
    {
        return m__d;
    }

    /*!
     * @brief This function sets a value in member first
     * @param _first New value for member first
     */
    eProsima_user_DllExport void first(
            int32_t _first)
    {
        first_() = _first;
        m__d = L'a';
    }

    /*!
     * @brief This function returns the value of member first
     * @return Value of member first
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int32_t first() const
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_first;
    }

    /*!
     * @brief This function returns a reference to member first
     * @return Reference to member first
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int32_t& first()
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_first;
    }


    /*!
     * @brief This function sets a value in member second
     * @param _second New value for member second
     */
    eProsima_user_DllExport void second(
            int64_t _second)
    {
        second_() = _second;
        m__d = L'b';
    }

    /*!
     * @brief This function returns the value of member second
     * @return Value of member second
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int64_t second() const
    {
        if (0x00000002 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_second;
    }

    /*!
     * @brief This function returns a reference to member second
     * @return Reference to member second
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int64_t& second()
    {
        if (0x00000002 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_second;
    }


    void _default()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }

        selected_member_ = 0x0FFFFFFFu;
    }


private:

            int32_t& first_()
            {
                if (0x00000001 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000001;
                    member_destructor_ = nullptr;
                    m_first = {0};

                }

                return m_first;
            }

            int64_t& second_()
            {
                if (0x00000002 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000002;
                    member_destructor_ = nullptr;
                    m_second = {0};

                }

                return m_second;
            }


    wchar_t m__d {32767};

    union
    {
        int32_t m_first;
        int64_t m_second;
    };

    uint32_t selected_member_ {0x0FFFFFFFu};

    std::function<void()> member_destructor_;
};
/*!
 * @brief This class represents the union Union_Discriminator_enum defined by the user in the IDL file.
 * @ingroup unions
 */
class Union_Discriminator_enum
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Union_Discriminator_enum()
    {
        selected_member_ = 0x00000003;
        member_destructor_ = nullptr;
        m_third = {0};

    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Union_Discriminator_enum()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Union_Discriminator_enum that will be copied.
     */
    eProsima_user_DllExport Union_Discriminator_enum(
            const Union_Discriminator_enum& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            first_() = x.m_first;
                            break;

                        case 0x00000002:
                            second_() = x.m_second;
                            break;

                        case 0x00000003:
                            third_() = x.m_third;
                            break;

        }
    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Union_Discriminator_enum that will be copied.
     */
    eProsima_user_DllExport Union_Discriminator_enum(
            Union_Discriminator_enum&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            first_() = std::move(x.m_first);
                            break;

                        case 0x00000002:
                            second_() = std::move(x.m_second);
                            break;

                        case 0x00000003:
                            third_() = std::move(x.m_third);
                            break;

        }
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Union_Discriminator_enum that will be copied.
     */
    eProsima_user_DllExport Union_Discriminator_enum& operator =(
            const Union_Discriminator_enum& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            first_() = x.m_first;
                            break;

                        case 0x00000002:
                            second_() = x.m_second;
                            break;

                        case 0x00000003:
                            third_() = x.m_third;
                            break;

        }

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Union_Discriminator_enum that will be copied.
     */
    eProsima_user_DllExport Union_Discriminator_enum& operator =(
            Union_Discriminator_enum&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            first_() = std::move(x.m_first);
                            break;

                        case 0x00000002:
                            second_() = std::move(x.m_second);
                            break;

                        case 0x00000003:
                            third_() = std::move(x.m_third);
                            break;

        }

        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Union_Discriminator_enum object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Union_Discriminator_enum& x) const
    {
        bool ret_value {false};

        if (x.selected_member_ == selected_member_)
        {
            if (0x0FFFFFFFu != selected_member_)
            {
                if (x.m__d == m__d)
                {
                    switch (selected_member_)
                    {
                                                    case 0x00000001:
                                                        ret_value = (x.m_first == m_first);
                                                        break;

                                                    case 0x00000002:
                                                        ret_value = (x.m_second == m_second);
                                                        break;

                                                    case 0x00000003:
                                                        ret_value = (x.m_third == m_third);
                                                        break;

                    }
                }
            }
            else
            {
                ret_value = true;
            }
        }

        return ret_value;
    }

    /*!
     * @brief Comparison operator.
     * @param x Union_Discriminator_enum object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Union_Discriminator_enum& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets the discriminator value.
     * @param __d New value for the discriminator.
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the new value doesn't correspond to the selected union member.
     */
    eProsima_user_DllExport void _d(
            InnerEnumHelper __d)
    {
        bool valid_discriminator = false;

        switch (__d)
        {
                        case InnerEnumHelper::ENUM_VALUE_1:
                            if (0x00000001 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case InnerEnumHelper::ENUM_VALUE_2:
                            if (0x00000002 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        default:
                            if (0x00000003 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

        }

        if (!valid_discriminator)
        {
            throw eprosima::fastcdr::exception::BadParamException("Discriminator doesn't correspond with the selected union member");
        }

        m__d = __d;
    }

    /*!
     * @brief This function returns the value of the discriminator.
     * @return Value of the discriminator
     */
    eProsima_user_DllExport InnerEnumHelper _d() const
    {
        return m__d;
    }

    /*!
     * @brief This function sets a value in member first
     * @param _first New value for member first
     */
    eProsima_user_DllExport void first(
            int32_t _first)
    {
        first_() = _first;
        m__d = InnerEnumHelper::ENUM_VALUE_1;
    }

    /*!
     * @brief This function returns the value of member first
     * @return Value of member first
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int32_t first() const
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_first;
    }

    /*!
     * @brief This function returns a reference to member first
     * @return Reference to member first
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int32_t& first()
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_first;
    }


    /*!
     * @brief This function sets a value in member second
     * @param _second New value for member second
     */
    eProsima_user_DllExport void second(
            int64_t _second)
    {
        second_() = _second;
        m__d = InnerEnumHelper::ENUM_VALUE_2;
    }

    /*!
     * @brief This function returns the value of member second
     * @return Value of member second
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int64_t second() const
    {
        if (0x00000002 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_second;
    }

    /*!
     * @brief This function returns a reference to member second
     * @return Reference to member second
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int64_t& second()
    {
        if (0x00000002 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_second;
    }


    /*!
     * @brief This function sets a value in member third
     * @param _third New value for member third
     */
    eProsima_user_DllExport void third(
            uint8_t _third)
    {
        third_() = _third;
        m__d = InnerEnumHelper::ENUM_VALUE_3;
    }

    /*!
     * @brief This function returns the value of member third
     * @return Value of member third
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport uint8_t third() const
    {
        if (0x00000003 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_third;
    }

    /*!
     * @brief This function returns a reference to member third
     * @return Reference to member third
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport uint8_t& third()
    {
        if (0x00000003 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_third;
    }



private:

            int32_t& first_()
            {
                if (0x00000001 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000001;
                    member_destructor_ = nullptr;
                    m_first = {0};

                }

                return m_first;
            }

            int64_t& second_()
            {
                if (0x00000002 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000002;
                    member_destructor_ = nullptr;
                    m_second = {0};

                }

                return m_second;
            }

            uint8_t& third_()
            {
                if (0x00000003 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000003;
                    member_destructor_ = nullptr;
                    m_third = {0};

                }

                return m_third;
            }


    InnerEnumHelper m__d {InnerEnumHelper::ENUM_VALUE_3};

    union
    {
        int32_t m_first;
        int64_t m_second;
        uint8_t m_third;
    };

    uint32_t selected_member_ {0x0FFFFFFFu};

    std::function<void()> member_destructor_;
};
/*!
 * @brief This class represents the union Union_Discriminator_enum_labels defined by the user in the IDL file.
 * @ingroup unions
 */
class Union_Discriminator_enum_labels
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Union_Discriminator_enum_labels()
    {
        selected_member_ = 0x00000001;
        member_destructor_ = nullptr;
        m_first = {0};

    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Union_Discriminator_enum_labels()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Union_Discriminator_enum_labels that will be copied.
     */
    eProsima_user_DllExport Union_Discriminator_enum_labels(
            const Union_Discriminator_enum_labels& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            first_() = x.m_first;
                            break;

                        case 0x00000002:
                            second_() = x.m_second;
                            break;

        }
    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Union_Discriminator_enum_labels that will be copied.
     */
    eProsima_user_DllExport Union_Discriminator_enum_labels(
            Union_Discriminator_enum_labels&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            first_() = std::move(x.m_first);
                            break;

                        case 0x00000002:
                            second_() = std::move(x.m_second);
                            break;

        }
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Union_Discriminator_enum_labels that will be copied.
     */
    eProsima_user_DllExport Union_Discriminator_enum_labels& operator =(
            const Union_Discriminator_enum_labels& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            first_() = x.m_first;
                            break;

                        case 0x00000002:
                            second_() = x.m_second;
                            break;

        }

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Union_Discriminator_enum_labels that will be copied.
     */
    eProsima_user_DllExport Union_Discriminator_enum_labels& operator =(
            Union_Discriminator_enum_labels&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            first_() = std::move(x.m_first);
                            break;

                        case 0x00000002:
                            second_() = std::move(x.m_second);
                            break;

        }

        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Union_Discriminator_enum_labels object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Union_Discriminator_enum_labels& x) const
    {
        bool ret_value {false};

        if (x.selected_member_ == selected_member_)
        {
            if (0x0FFFFFFFu != selected_member_)
            {
                if (x.m__d == m__d)
                {
                    switch (selected_member_)
                    {
                                                    case 0x00000001:
                                                        ret_value = (x.m_first == m_first);
                                                        break;

                                                    case 0x00000002:
                                                        ret_value = (x.m_second == m_second);
                                                        break;

                    }
                }
            }
            else
            {
                ret_value = true;
            }
        }

        return ret_value;
    }

    /*!
     * @brief Comparison operator.
     * @param x Union_Discriminator_enum_labels object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Union_Discriminator_enum_labels& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets the discriminator value.
     * @param __d New value for the discriminator.
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the new value doesn't correspond to the selected union member.
     */
    eProsima_user_DllExport void _d(
            InnerEnumHelper __d)
    {
        bool valid_discriminator = false;

        switch (__d)
        {
                        case InnerEnumHelper::ENUM_VALUE_3:
                        case InnerEnumHelper::ENUM_VALUE_1:
                            if (0x00000001 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case InnerEnumHelper::ENUM_VALUE_2:
                            if (0x00000002 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

        }

        if (!valid_discriminator)
        {
            throw eprosima::fastcdr::exception::BadParamException("Discriminator doesn't correspond with the selected union member");
        }

        m__d = __d;
    }

    /*!
     * @brief This function returns the value of the discriminator.
     * @return Value of the discriminator
     */
    eProsima_user_DllExport InnerEnumHelper _d() const
    {
        return m__d;
    }

    /*!
     * @brief This function sets a value in member first
     * @param _first New value for member first
     */
    eProsima_user_DllExport void first(
            int16_t _first)
    {
        first_() = _first;
        m__d = InnerEnumHelper::ENUM_VALUE_3;
    }

    /*!
     * @brief This function returns the value of member first
     * @return Value of member first
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int16_t first() const
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_first;
    }

    /*!
     * @brief This function returns a reference to member first
     * @return Reference to member first
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int16_t& first()
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_first;
    }


    /*!
     * @brief This function sets a value in member second
     * @param _second New value for member second
     */
    eProsima_user_DllExport void second(
            int16_t _second)
    {
        second_() = _second;
        m__d = InnerEnumHelper::ENUM_VALUE_2;
    }

    /*!
     * @brief This function returns the value of member second
     * @return Value of member second
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int16_t second() const
    {
        if (0x00000002 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_second;
    }

    /*!
     * @brief This function returns a reference to member second
     * @return Reference to member second
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int16_t& second()
    {
        if (0x00000002 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_second;
    }


    void _default()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }

        selected_member_ = 0x0FFFFFFFu;
    }


private:

            int16_t& first_()
            {
                if (0x00000001 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000001;
                    member_destructor_ = nullptr;
                    m_first = {0};

                }

                return m_first;
            }

            int16_t& second_()
            {
                if (0x00000002 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000002;
                    member_destructor_ = nullptr;
                    m_second = {0};

                }

                return m_second;
            }


    InnerEnumHelper m__d {InnerEnumHelper::ENUM_VALUE_3};

    union
    {
        int16_t m_first;
        int16_t m_second;
    };

    uint32_t selected_member_ {0x0FFFFFFFu};

    std::function<void()> member_destructor_;
};
/*!
 * @brief This class represents the union Union_Discriminator_alias defined by the user in the IDL file.
 * @ingroup unions
 */
class Union_Discriminator_alias
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Union_Discriminator_alias()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Union_Discriminator_alias()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Union_Discriminator_alias that will be copied.
     */
    eProsima_user_DllExport Union_Discriminator_alias(
            const Union_Discriminator_alias& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            first_() = x.m_first;
                            break;

                        case 0x00000002:
                            second_() = x.m_second;
                            break;

        }
    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Union_Discriminator_alias that will be copied.
     */
    eProsima_user_DllExport Union_Discriminator_alias(
            Union_Discriminator_alias&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            first_() = std::move(x.m_first);
                            break;

                        case 0x00000002:
                            second_() = std::move(x.m_second);
                            break;

        }
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Union_Discriminator_alias that will be copied.
     */
    eProsima_user_DllExport Union_Discriminator_alias& operator =(
            const Union_Discriminator_alias& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            first_() = x.m_first;
                            break;

                        case 0x00000002:
                            second_() = x.m_second;
                            break;

        }

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Union_Discriminator_alias that will be copied.
     */
    eProsima_user_DllExport Union_Discriminator_alias& operator =(
            Union_Discriminator_alias&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            first_() = std::move(x.m_first);
                            break;

                        case 0x00000002:
                            second_() = std::move(x.m_second);
                            break;

        }

        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Union_Discriminator_alias object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Union_Discriminator_alias& x) const
    {
        bool ret_value {false};

        if (x.selected_member_ == selected_member_)
        {
            if (0x0FFFFFFFu != selected_member_)
            {
                if (x.m__d == m__d)
                {
                    switch (selected_member_)
                    {
                                                    case 0x00000001:
                                                        ret_value = (x.m_first == m_first);
                                                        break;

                                                    case 0x00000002:
                                                        ret_value = (x.m_second == m_second);
                                                        break;

                    }
                }
            }
            else
            {
                ret_value = true;
            }
        }

        return ret_value;
    }

    /*!
     * @brief Comparison operator.
     * @param x Union_Discriminator_alias object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Union_Discriminator_alias& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets the discriminator value.
     * @param __d New value for the discriminator.
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the new value doesn't correspond to the selected union member.
     */
    eProsima_user_DllExport void _d(
            InnerAliasHelper __d)
    {
        bool valid_discriminator = false;

        switch (__d)
        {
                        case 1:
                            if (0x00000001 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case 2:
                            if (0x00000002 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

        }

        if (!valid_discriminator)
        {
            throw eprosima::fastcdr::exception::BadParamException("Discriminator doesn't correspond with the selected union member");
        }

        m__d = __d;
    }

    /*!
     * @brief This function returns the value of the discriminator.
     * @return Value of the discriminator
     */
    eProsima_user_DllExport InnerAliasHelper _d() const
    {
        return m__d;
    }

    /*!
     * @brief This function sets a value in member first
     * @param _first New value for member first
     */
    eProsima_user_DllExport void first(
            int32_t _first)
    {
        first_() = _first;
        m__d = 1;
    }

    /*!
     * @brief This function returns the value of member first
     * @return Value of member first
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int32_t first() const
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_first;
    }

    /*!
     * @brief This function returns a reference to member first
     * @return Reference to member first
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int32_t& first()
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_first;
    }


    /*!
     * @brief This function sets a value in member second
     * @param _second New value for member second
     */
    eProsima_user_DllExport void second(
            int64_t _second)
    {
        second_() = _second;
        m__d = 2;
    }

    /*!
     * @brief This function returns the value of member second
     * @return Value of member second
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int64_t second() const
    {
        if (0x00000002 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_second;
    }

    /*!
     * @brief This function returns a reference to member second
     * @return Reference to member second
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int64_t& second()
    {
        if (0x00000002 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_second;
    }


    void _default()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }

        selected_member_ = 0x0FFFFFFFu;
    }


private:

            int32_t& first_()
            {
                if (0x00000001 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000001;
                    member_destructor_ = nullptr;
                    m_first = {0};

                }

                return m_first;
            }

            int64_t& second_()
            {
                if (0x00000002 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000002;
                    member_destructor_ = nullptr;
                    m_second = {0};

                }

                return m_second;
            }


    InnerAliasHelper m__d {2147483647};

    union
    {
        int32_t m_first;
        int64_t m_second;
    };

    uint32_t selected_member_ {0x0FFFFFFFu};

    std::function<void()> member_destructor_;
};
/*!
 * @brief This class represents the union Union_Several_Fields defined by the user in the IDL file.
 * @ingroup unions
 */
class Union_Several_Fields
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Union_Several_Fields()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Union_Several_Fields()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Union_Several_Fields that will be copied.
     */
    eProsima_user_DllExport Union_Several_Fields(
            const Union_Several_Fields& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            a_() = x.m_a;
                            break;

                        case 0x00000002:
                            b_() = x.m_b;
                            break;

                        case 0x00000003:
                            c_() = x.m_c;
                            break;

                        case 0x00000004:
                            d_() = x.m_d;
                            break;

                        case 0x00000005:
                            e_() = x.m_e;
                            break;

        }
    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Union_Several_Fields that will be copied.
     */
    eProsima_user_DllExport Union_Several_Fields(
            Union_Several_Fields&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            a_() = std::move(x.m_a);
                            break;

                        case 0x00000002:
                            b_() = std::move(x.m_b);
                            break;

                        case 0x00000003:
                            c_() = std::move(x.m_c);
                            break;

                        case 0x00000004:
                            d_() = std::move(x.m_d);
                            break;

                        case 0x00000005:
                            e_() = std::move(x.m_e);
                            break;

        }
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Union_Several_Fields that will be copied.
     */
    eProsima_user_DllExport Union_Several_Fields& operator =(
            const Union_Several_Fields& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            a_() = x.m_a;
                            break;

                        case 0x00000002:
                            b_() = x.m_b;
                            break;

                        case 0x00000003:
                            c_() = x.m_c;
                            break;

                        case 0x00000004:
                            d_() = x.m_d;
                            break;

                        case 0x00000005:
                            e_() = x.m_e;
                            break;

        }

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Union_Several_Fields that will be copied.
     */
    eProsima_user_DllExport Union_Several_Fields& operator =(
            Union_Several_Fields&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            a_() = std::move(x.m_a);
                            break;

                        case 0x00000002:
                            b_() = std::move(x.m_b);
                            break;

                        case 0x00000003:
                            c_() = std::move(x.m_c);
                            break;

                        case 0x00000004:
                            d_() = std::move(x.m_d);
                            break;

                        case 0x00000005:
                            e_() = std::move(x.m_e);
                            break;

        }

        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Union_Several_Fields object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Union_Several_Fields& x) const
    {
        bool ret_value {false};

        if (x.selected_member_ == selected_member_)
        {
            if (0x0FFFFFFFu != selected_member_)
            {
                if (x.m__d == m__d)
                {
                    switch (selected_member_)
                    {
                                                    case 0x00000001:
                                                        ret_value = (x.m_a == m_a);
                                                        break;

                                                    case 0x00000002:
                                                        ret_value = (x.m_b == m_b);
                                                        break;

                                                    case 0x00000003:
                                                        ret_value = (x.m_c == m_c);
                                                        break;

                                                    case 0x00000004:
                                                        ret_value = (x.m_d == m_d);
                                                        break;

                                                    case 0x00000005:
                                                        ret_value = (x.m_e == m_e);
                                                        break;

                    }
                }
            }
            else
            {
                ret_value = true;
            }
        }

        return ret_value;
    }

    /*!
     * @brief Comparison operator.
     * @param x Union_Several_Fields object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Union_Several_Fields& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets the discriminator value.
     * @param __d New value for the discriminator.
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the new value doesn't correspond to the selected union member.
     */
    eProsima_user_DllExport void _d(
            int32_t __d)
    {
        bool valid_discriminator = false;

        switch (__d)
        {
                        case 0:
                            if (0x00000001 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case 1:
                            if (0x00000002 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case 2:
                            if (0x00000003 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case 3:
                            if (0x00000004 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case 4:
                            if (0x00000005 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

        }

        if (!valid_discriminator)
        {
            throw eprosima::fastcdr::exception::BadParamException("Discriminator doesn't correspond with the selected union member");
        }

        m__d = __d;
    }

    /*!
     * @brief This function returns the value of the discriminator.
     * @return Value of the discriminator
     */
    eProsima_user_DllExport int32_t _d() const
    {
        return m__d;
    }

    /*!
     * @brief This function copies the value in member a
     * @param _a New value to be copied in member a
     */
    eProsima_user_DllExport void a(
            const InnerStructureHelper& _a)
    {
        a_() = _a;
        m__d = 0;
    }

    /*!
     * @brief This function moves the value in member a
     * @param _a New value to be moved in member a
     */
    eProsima_user_DllExport void a(
            InnerStructureHelper&& _a)
    {
        a_() = _a;
        m__d = 0;
    }

    /*!
     * @brief This function returns a constant reference to member a
     * @return Constant reference to member a
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport const InnerStructureHelper& a() const
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_a;
    }

    /*!
     * @brief This function returns a reference to member a
     * @return Reference to member a
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport InnerStructureHelper& a()
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_a;
    }


    /*!
     * @brief This function copies the value in member b
     * @param _b New value to be copied in member b
     */
    eProsima_user_DllExport void b(
            const InnerEmptyStructureHelper& _b)
    {
        b_() = _b;
        m__d = 1;
    }

    /*!
     * @brief This function moves the value in member b
     * @param _b New value to be moved in member b
     */
    eProsima_user_DllExport void b(
            InnerEmptyStructureHelper&& _b)
    {
        b_() = _b;
        m__d = 1;
    }

    /*!
     * @brief This function returns a constant reference to member b
     * @return Constant reference to member b
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport const InnerEmptyStructureHelper& b() const
    {
        if (0x00000002 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_b;
    }

    /*!
     * @brief This function returns a reference to member b
     * @return Reference to member b
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport InnerEmptyStructureHelper& b()
    {
        if (0x00000002 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_b;
    }


    /*!
     * @brief This function copies the value in member c
     * @param _c New value to be copied in member c
     */
    eProsima_user_DllExport void c(
            const Inner_alias_bounded_string_helper& _c)
    {
        c_() = _c;
        m__d = 2;
    }

    /*!
     * @brief This function moves the value in member c
     * @param _c New value to be moved in member c
     */
    eProsima_user_DllExport void c(
            Inner_alias_bounded_string_helper&& _c)
    {
        c_() = _c;
        m__d = 2;
    }

    /*!
     * @brief This function returns a constant reference to member c
     * @return Constant reference to member c
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport const Inner_alias_bounded_string_helper& c() const
    {
        if (0x00000003 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_c;
    }

    /*!
     * @brief This function returns a reference to member c
     * @return Reference to member c
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport Inner_alias_bounded_string_helper& c()
    {
        if (0x00000003 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_c;
    }


    /*!
     * @brief This function copies the value in member d
     * @param _d New value to be copied in member d
     */
    eProsima_user_DllExport void d(
            const Inner_alias_array_helper& _d)
    {
        d_() = _d;
        m__d = 3;
    }

    /*!
     * @brief This function moves the value in member d
     * @param _d New value to be moved in member d
     */
    eProsima_user_DllExport void d(
            Inner_alias_array_helper&& _d)
    {
        d_() = _d;
        m__d = 3;
    }

    /*!
     * @brief This function returns a constant reference to member d
     * @return Constant reference to member d
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport const Inner_alias_array_helper& d() const
    {
        if (0x00000004 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_d;
    }

    /*!
     * @brief This function returns a reference to member d
     * @return Reference to member d
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport Inner_alias_array_helper& d()
    {
        if (0x00000004 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_d;
    }


    /*!
     * @brief This function copies the value in member e
     * @param _e New value to be copied in member e
     */
    eProsima_user_DllExport void e(
            const Inner_alias_sequence_helper& _e)
    {
        e_() = _e;
        m__d = 4;
    }

    /*!
     * @brief This function moves the value in member e
     * @param _e New value to be moved in member e
     */
    eProsima_user_DllExport void e(
            Inner_alias_sequence_helper&& _e)
    {
        e_() = _e;
        m__d = 4;
    }

    /*!
     * @brief This function returns a constant reference to member e
     * @return Constant reference to member e
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport const Inner_alias_sequence_helper& e() const
    {
        if (0x00000005 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_e;
    }

    /*!
     * @brief This function returns a reference to member e
     * @return Reference to member e
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport Inner_alias_sequence_helper& e()
    {
        if (0x00000005 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_e;
    }


    void _default()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }

        selected_member_ = 0x0FFFFFFFu;
    }


private:

            InnerStructureHelper& a_()
            {
                if (0x00000001 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000001;
                    member_destructor_ = [&]()
                    {
                        m_a.~InnerStructureHelper();
                    };
                    new(&m_a) InnerStructureHelper();

                }

                return m_a;
            }

            InnerEmptyStructureHelper& b_()
            {
                if (0x00000002 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000002;
                    member_destructor_ = [&]()
                    {
                        m_b.~InnerEmptyStructureHelper();
                    };
                    new(&m_b) InnerEmptyStructureHelper();

                }

                return m_b;
            }

            Inner_alias_bounded_string_helper& c_()
            {
                if (0x00000003 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000003;
                    member_destructor_ = [&]()
                    {
                        m_c.~Inner_alias_bounded_string_helper();
                    };
                    new(&m_c) Inner_alias_bounded_string_helper();

                }

                return m_c;
            }

            Inner_alias_array_helper& d_()
            {
                if (0x00000004 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000004;
                    member_destructor_ = [&]()
                    {
                        m_d.~Inner_alias_array_helper();
                    };
                    new(&m_d) Inner_alias_array_helper();

                }

                return m_d;
            }

            Inner_alias_sequence_helper& e_()
            {
                if (0x00000005 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000005;
                    member_destructor_ = [&]()
                    {
                        m_e.~Inner_alias_sequence_helper();
                    };
                    new(&m_e) Inner_alias_sequence_helper();

                }

                return m_e;
            }


    int32_t m__d {2147483647};

    union
    {
        InnerStructureHelper m_a;
        InnerEmptyStructureHelper m_b;
        Inner_alias_bounded_string_helper m_c;
        Inner_alias_array_helper m_d;
        Inner_alias_sequence_helper m_e;
    };

    uint32_t selected_member_ {0x0FFFFFFFu};

    std::function<void()> member_destructor_;
};
/*!
 * @brief This class represents the union Union_Several_Fields_With_Default defined by the user in the IDL file.
 * @ingroup unions
 */
class Union_Several_Fields_With_Default
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Union_Several_Fields_With_Default()
    {
        selected_member_ = 0x00000006;
        member_destructor_ = [&]()
        {
            m_f.~vector();
        };
        new(&m_f) std::vector<int16_t>();

    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Union_Several_Fields_With_Default()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Union_Several_Fields_With_Default that will be copied.
     */
    eProsima_user_DllExport Union_Several_Fields_With_Default(
            const Union_Several_Fields_With_Default& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            a_() = x.m_a;
                            break;

                        case 0x00000002:
                            b_() = x.m_b;
                            break;

                        case 0x00000003:
                            c_() = x.m_c;
                            break;

                        case 0x00000004:
                            d_() = x.m_d;
                            break;

                        case 0x00000005:
                            e_() = x.m_e;
                            break;

                        case 0x00000006:
                            f_() = x.m_f;
                            break;

        }
    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Union_Several_Fields_With_Default that will be copied.
     */
    eProsima_user_DllExport Union_Several_Fields_With_Default(
            Union_Several_Fields_With_Default&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            a_() = std::move(x.m_a);
                            break;

                        case 0x00000002:
                            b_() = std::move(x.m_b);
                            break;

                        case 0x00000003:
                            c_() = std::move(x.m_c);
                            break;

                        case 0x00000004:
                            d_() = std::move(x.m_d);
                            break;

                        case 0x00000005:
                            e_() = std::move(x.m_e);
                            break;

                        case 0x00000006:
                            f_() = std::move(x.m_f);
                            break;

        }
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Union_Several_Fields_With_Default that will be copied.
     */
    eProsima_user_DllExport Union_Several_Fields_With_Default& operator =(
            const Union_Several_Fields_With_Default& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            a_() = x.m_a;
                            break;

                        case 0x00000002:
                            b_() = x.m_b;
                            break;

                        case 0x00000003:
                            c_() = x.m_c;
                            break;

                        case 0x00000004:
                            d_() = x.m_d;
                            break;

                        case 0x00000005:
                            e_() = x.m_e;
                            break;

                        case 0x00000006:
                            f_() = x.m_f;
                            break;

        }

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Union_Several_Fields_With_Default that will be copied.
     */
    eProsima_user_DllExport Union_Several_Fields_With_Default& operator =(
            Union_Several_Fields_With_Default&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            a_() = std::move(x.m_a);
                            break;

                        case 0x00000002:
                            b_() = std::move(x.m_b);
                            break;

                        case 0x00000003:
                            c_() = std::move(x.m_c);
                            break;

                        case 0x00000004:
                            d_() = std::move(x.m_d);
                            break;

                        case 0x00000005:
                            e_() = std::move(x.m_e);
                            break;

                        case 0x00000006:
                            f_() = std::move(x.m_f);
                            break;

        }

        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Union_Several_Fields_With_Default object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Union_Several_Fields_With_Default& x) const
    {
        bool ret_value {false};

        if (x.selected_member_ == selected_member_)
        {
            if (0x0FFFFFFFu != selected_member_)
            {
                if (x.m__d == m__d)
                {
                    switch (selected_member_)
                    {
                                                    case 0x00000001:
                                                        ret_value = (x.m_a == m_a);
                                                        break;

                                                    case 0x00000002:
                                                        ret_value = (x.m_b == m_b);
                                                        break;

                                                    case 0x00000003:
                                                        ret_value = (x.m_c == m_c);
                                                        break;

                                                    case 0x00000004:
                                                        ret_value = (x.m_d == m_d);
                                                        break;

                                                    case 0x00000005:
                                                        ret_value = (x.m_e == m_e);
                                                        break;

                                                    case 0x00000006:
                                                        ret_value = (x.m_f == m_f);
                                                        break;

                    }
                }
            }
            else
            {
                ret_value = true;
            }
        }

        return ret_value;
    }

    /*!
     * @brief Comparison operator.
     * @param x Union_Several_Fields_With_Default object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Union_Several_Fields_With_Default& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets the discriminator value.
     * @param __d New value for the discriminator.
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the new value doesn't correspond to the selected union member.
     */
    eProsima_user_DllExport void _d(
            int32_t __d)
    {
        bool valid_discriminator = false;

        switch (__d)
        {
                        case 0:
                            if (0x00000001 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case 1:
                            if (0x00000002 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case 2:
                            if (0x00000003 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case 3:
                            if (0x00000004 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case 4:
                            if (0x00000005 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        default:
                            if (0x00000006 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

        }

        if (!valid_discriminator)
        {
            throw eprosima::fastcdr::exception::BadParamException("Discriminator doesn't correspond with the selected union member");
        }

        m__d = __d;
    }

    /*!
     * @brief This function returns the value of the discriminator.
     * @return Value of the discriminator
     */
    eProsima_user_DllExport int32_t _d() const
    {
        return m__d;
    }

    /*!
     * @brief This function copies the value in member a
     * @param _a New value to be copied in member a
     */
    eProsima_user_DllExport void a(
            const InnerStructureHelper& _a)
    {
        a_() = _a;
        m__d = 0;
    }

    /*!
     * @brief This function moves the value in member a
     * @param _a New value to be moved in member a
     */
    eProsima_user_DllExport void a(
            InnerStructureHelper&& _a)
    {
        a_() = _a;
        m__d = 0;
    }

    /*!
     * @brief This function returns a constant reference to member a
     * @return Constant reference to member a
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport const InnerStructureHelper& a() const
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_a;
    }

    /*!
     * @brief This function returns a reference to member a
     * @return Reference to member a
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport InnerStructureHelper& a()
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_a;
    }


    /*!
     * @brief This function copies the value in member b
     * @param _b New value to be copied in member b
     */
    eProsima_user_DllExport void b(
            const InnerEmptyStructureHelper& _b)
    {
        b_() = _b;
        m__d = 1;
    }

    /*!
     * @brief This function moves the value in member b
     * @param _b New value to be moved in member b
     */
    eProsima_user_DllExport void b(
            InnerEmptyStructureHelper&& _b)
    {
        b_() = _b;
        m__d = 1;
    }

    /*!
     * @brief This function returns a constant reference to member b
     * @return Constant reference to member b
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport const InnerEmptyStructureHelper& b() const
    {
        if (0x00000002 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_b;
    }

    /*!
     * @brief This function returns a reference to member b
     * @return Reference to member b
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport InnerEmptyStructureHelper& b()
    {
        if (0x00000002 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_b;
    }


    /*!
     * @brief This function copies the value in member c
     * @param _c New value to be copied in member c
     */
    eProsima_user_DllExport void c(
            const Inner_alias_bounded_string_helper& _c)
    {
        c_() = _c;
        m__d = 2;
    }

    /*!
     * @brief This function moves the value in member c
     * @param _c New value to be moved in member c
     */
    eProsima_user_DllExport void c(
            Inner_alias_bounded_string_helper&& _c)
    {
        c_() = _c;
        m__d = 2;
    }

    /*!
     * @brief This function returns a constant reference to member c
     * @return Constant reference to member c
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport const Inner_alias_bounded_string_helper& c() const
    {
        if (0x00000003 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_c;
    }

    /*!
     * @brief This function returns a reference to member c
     * @return Reference to member c
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport Inner_alias_bounded_string_helper& c()
    {
        if (0x00000003 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_c;
    }


    /*!
     * @brief This function copies the value in member d
     * @param _d New value to be copied in member d
     */
    eProsima_user_DllExport void d(
            const Inner_alias_array_helper& _d)
    {
        d_() = _d;
        m__d = 3;
    }

    /*!
     * @brief This function moves the value in member d
     * @param _d New value to be moved in member d
     */
    eProsima_user_DllExport void d(
            Inner_alias_array_helper&& _d)
    {
        d_() = _d;
        m__d = 3;
    }

    /*!
     * @brief This function returns a constant reference to member d
     * @return Constant reference to member d
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport const Inner_alias_array_helper& d() const
    {
        if (0x00000004 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_d;
    }

    /*!
     * @brief This function returns a reference to member d
     * @return Reference to member d
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport Inner_alias_array_helper& d()
    {
        if (0x00000004 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_d;
    }


    /*!
     * @brief This function copies the value in member e
     * @param _e New value to be copied in member e
     */
    eProsima_user_DllExport void e(
            const Inner_alias_sequence_helper& _e)
    {
        e_() = _e;
        m__d = 4;
    }

    /*!
     * @brief This function moves the value in member e
     * @param _e New value to be moved in member e
     */
    eProsima_user_DllExport void e(
            Inner_alias_sequence_helper&& _e)
    {
        e_() = _e;
        m__d = 4;
    }

    /*!
     * @brief This function returns a constant reference to member e
     * @return Constant reference to member e
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport const Inner_alias_sequence_helper& e() const
    {
        if (0x00000005 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_e;
    }

    /*!
     * @brief This function returns a reference to member e
     * @return Reference to member e
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport Inner_alias_sequence_helper& e()
    {
        if (0x00000005 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_e;
    }


    /*!
     * @brief This function copies the value in member f
     * @param _f New value to be copied in member f
     */
    eProsima_user_DllExport void f(
            const std::vector<int16_t>& _f)
    {
        f_() = _f;
        m__d = 2147483647;
    }

    /*!
     * @brief This function moves the value in member f
     * @param _f New value to be moved in member f
     */
    eProsima_user_DllExport void f(
            std::vector<int16_t>&& _f)
    {
        f_() = _f;
        m__d = 2147483647;
    }

    /*!
     * @brief This function returns a constant reference to member f
     * @return Constant reference to member f
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport const std::vector<int16_t>& f() const
    {
        if (0x00000006 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_f;
    }

    /*!
     * @brief This function returns a reference to member f
     * @return Reference to member f
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport std::vector<int16_t>& f()
    {
        if (0x00000006 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_f;
    }



private:

            InnerStructureHelper& a_()
            {
                if (0x00000001 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000001;
                    member_destructor_ = [&]()
                    {
                        m_a.~InnerStructureHelper();
                    };
                    new(&m_a) InnerStructureHelper();

                }

                return m_a;
            }

            InnerEmptyStructureHelper& b_()
            {
                if (0x00000002 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000002;
                    member_destructor_ = [&]()
                    {
                        m_b.~InnerEmptyStructureHelper();
                    };
                    new(&m_b) InnerEmptyStructureHelper();

                }

                return m_b;
            }

            Inner_alias_bounded_string_helper& c_()
            {
                if (0x00000003 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000003;
                    member_destructor_ = [&]()
                    {
                        m_c.~Inner_alias_bounded_string_helper();
                    };
                    new(&m_c) Inner_alias_bounded_string_helper();

                }

                return m_c;
            }

            Inner_alias_array_helper& d_()
            {
                if (0x00000004 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000004;
                    member_destructor_ = [&]()
                    {
                        m_d.~Inner_alias_array_helper();
                    };
                    new(&m_d) Inner_alias_array_helper();

                }

                return m_d;
            }

            Inner_alias_sequence_helper& e_()
            {
                if (0x00000005 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000005;
                    member_destructor_ = [&]()
                    {
                        m_e.~Inner_alias_sequence_helper();
                    };
                    new(&m_e) Inner_alias_sequence_helper();

                }

                return m_e;
            }

            std::vector<int16_t>& f_()
            {
                if (0x00000006 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000006;
                    member_destructor_ = [&]()
                    {
                        m_f.~vector();
                    };
                    new(&m_f) std::vector<int16_t>();

                }

                return m_f;
            }


    int32_t m__d {2147483647};

    union
    {
        InnerStructureHelper m_a;
        InnerEmptyStructureHelper m_b;
        Inner_alias_bounded_string_helper m_c;
        Inner_alias_array_helper m_d;
        Inner_alias_sequence_helper m_e;
        std::vector<int16_t> m_f;
    };

    uint32_t selected_member_ {0x0FFFFFFFu};

    std::function<void()> member_destructor_;
};
/*!
 * @brief This class represents the union Union_Fixed_String_In_Module_Alias defined by the user in the IDL file.
 * @ingroup unions
 */
class Union_Fixed_String_In_Module_Alias
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Union_Fixed_String_In_Module_Alias()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Union_Fixed_String_In_Module_Alias()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Union_Fixed_String_In_Module_Alias that will be copied.
     */
    eProsima_user_DllExport Union_Fixed_String_In_Module_Alias(
            const Union_Fixed_String_In_Module_Alias& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            a_() = x.m_a;
                            break;

        }
    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Union_Fixed_String_In_Module_Alias that will be copied.
     */
    eProsima_user_DllExport Union_Fixed_String_In_Module_Alias(
            Union_Fixed_String_In_Module_Alias&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            a_() = std::move(x.m_a);
                            break;

        }
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Union_Fixed_String_In_Module_Alias that will be copied.
     */
    eProsima_user_DllExport Union_Fixed_String_In_Module_Alias& operator =(
            const Union_Fixed_String_In_Module_Alias& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            a_() = x.m_a;
                            break;

        }

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Union_Fixed_String_In_Module_Alias that will be copied.
     */
    eProsima_user_DllExport Union_Fixed_String_In_Module_Alias& operator =(
            Union_Fixed_String_In_Module_Alias&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            a_() = std::move(x.m_a);
                            break;

        }

        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Union_Fixed_String_In_Module_Alias object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Union_Fixed_String_In_Module_Alias& x) const
    {
        bool ret_value {false};

        if (x.selected_member_ == selected_member_)
        {
            if (0x0FFFFFFFu != selected_member_)
            {
                if (x.m__d == m__d)
                {
                    switch (selected_member_)
                    {
                                                    case 0x00000001:
                                                        ret_value = (x.m_a == m_a);
                                                        break;

                    }
                }
            }
            else
            {
                ret_value = true;
            }
        }

        return ret_value;
    }

    /*!
     * @brief Comparison operator.
     * @param x Union_Fixed_String_In_Module_Alias object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Union_Fixed_String_In_Module_Alias& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets the discriminator value.
     * @param __d New value for the discriminator.
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the new value doesn't correspond to the selected union member.
     */
    eProsima_user_DllExport void _d(
            int32_t __d)
    {
        bool valid_discriminator = false;

        switch (__d)
        {
                        case 0:
                            if (0x00000001 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

        }

        if (!valid_discriminator)
        {
            throw eprosima::fastcdr::exception::BadParamException("Discriminator doesn't correspond with the selected union member");
        }

        m__d = __d;
    }

    /*!
     * @brief This function returns the value of the discriminator.
     * @return Value of the discriminator
     */
    eProsima_user_DllExport int32_t _d() const
    {
        return m__d;
    }

    /*!
     * @brief This function copies the value in member a
     * @param _a New value to be copied in member a
     */
    eProsima_user_DllExport void a(
            const Fixed_String_Module::fixed_string_in_module& _a)
    {
        a_() = _a;
        m__d = 0;
    }

    /*!
     * @brief This function moves the value in member a
     * @param _a New value to be moved in member a
     */
    eProsima_user_DllExport void a(
            Fixed_String_Module::fixed_string_in_module&& _a)
    {
        a_() = _a;
        m__d = 0;
    }

    /*!
     * @brief This function returns a constant reference to member a
     * @return Constant reference to member a
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport const Fixed_String_Module::fixed_string_in_module& a() const
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_a;
    }

    /*!
     * @brief This function returns a reference to member a
     * @return Reference to member a
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport Fixed_String_Module::fixed_string_in_module& a()
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_a;
    }


    void _default()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }

        selected_member_ = 0x0FFFFFFFu;
    }


private:

            Fixed_String_Module::fixed_string_in_module& a_()
            {
                if (0x00000001 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000001;
                    member_destructor_ = [&]()
                    {
                        using namespace Fixed_String_Module;
                        m_a.~fixed_string_in_module();
                    };
                    new(&m_a) Fixed_String_Module::fixed_string_in_module();

                }

                return m_a;
            }


    int32_t m__d {2147483647};

    union
    {
        Fixed_String_Module::fixed_string_in_module m_a;
    };

    uint32_t selected_member_ {0x0FFFFFFFu};

    std::function<void()> member_destructor_;
};
/*!
 * @brief This class represents the structure UnionShort defined by the user in the IDL file.
 * @ingroup unions
 */
class UnionShort
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport UnionShort()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~UnionShort()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object UnionShort that will be copied.
     */
    eProsima_user_DllExport UnionShort(
            const UnionShort& x)
    {
                    m_var_union_short = x.m_var_union_short;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object UnionShort that will be copied.
     */
    eProsima_user_DllExport UnionShort(
            UnionShort&& x) noexcept
    {
        m_var_union_short = std::move(x.m_var_union_short);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object UnionShort that will be copied.
     */
    eProsima_user_DllExport UnionShort& operator =(
            const UnionShort& x)
    {

                    m_var_union_short = x.m_var_union_short;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object UnionShort that will be copied.
     */
    eProsima_user_DllExport UnionShort& operator =(
            UnionShort&& x) noexcept
    {

        m_var_union_short = std::move(x.m_var_union_short);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x UnionShort object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const UnionShort& x) const
    {
        return (m_var_union_short == x.m_var_union_short);
    }

    /*!
     * @brief Comparison operator.
     * @param x UnionShort object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const UnionShort& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_union_short
     * @param _var_union_short New value to be copied in member var_union_short
     */
    eProsima_user_DllExport void var_union_short(
            const Union_Short& _var_union_short)
    {
        m_var_union_short = _var_union_short;
    }

    /*!
     * @brief This function moves the value in member var_union_short
     * @param _var_union_short New value to be moved in member var_union_short
     */
    eProsima_user_DllExport void var_union_short(
            Union_Short&& _var_union_short)
    {
        m_var_union_short = std::move(_var_union_short);
    }

    /*!
     * @brief This function returns a constant reference to member var_union_short
     * @return Constant reference to member var_union_short
     */
    eProsima_user_DllExport const Union_Short& var_union_short() const
    {
        return m_var_union_short;
    }

    /*!
     * @brief This function returns a reference to member var_union_short
     * @return Reference to member var_union_short
     */
    eProsima_user_DllExport Union_Short& var_union_short()
    {
        return m_var_union_short;
    }



private:

    Union_Short m_var_union_short;

};
/*!
 * @brief This class represents the structure UnionUShort defined by the user in the IDL file.
 * @ingroup unions
 */
class UnionUShort
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport UnionUShort()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~UnionUShort()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object UnionUShort that will be copied.
     */
    eProsima_user_DllExport UnionUShort(
            const UnionUShort& x)
    {
                    m_var_union_ushort = x.m_var_union_ushort;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object UnionUShort that will be copied.
     */
    eProsima_user_DllExport UnionUShort(
            UnionUShort&& x) noexcept
    {
        m_var_union_ushort = std::move(x.m_var_union_ushort);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object UnionUShort that will be copied.
     */
    eProsima_user_DllExport UnionUShort& operator =(
            const UnionUShort& x)
    {

                    m_var_union_ushort = x.m_var_union_ushort;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object UnionUShort that will be copied.
     */
    eProsima_user_DllExport UnionUShort& operator =(
            UnionUShort&& x) noexcept
    {

        m_var_union_ushort = std::move(x.m_var_union_ushort);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x UnionUShort object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const UnionUShort& x) const
    {
        return (m_var_union_ushort == x.m_var_union_ushort);
    }

    /*!
     * @brief Comparison operator.
     * @param x UnionUShort object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const UnionUShort& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_union_ushort
     * @param _var_union_ushort New value to be copied in member var_union_ushort
     */
    eProsima_user_DllExport void var_union_ushort(
            const Union_UShort& _var_union_ushort)
    {
        m_var_union_ushort = _var_union_ushort;
    }

    /*!
     * @brief This function moves the value in member var_union_ushort
     * @param _var_union_ushort New value to be moved in member var_union_ushort
     */
    eProsima_user_DllExport void var_union_ushort(
            Union_UShort&& _var_union_ushort)
    {
        m_var_union_ushort = std::move(_var_union_ushort);
    }

    /*!
     * @brief This function returns a constant reference to member var_union_ushort
     * @return Constant reference to member var_union_ushort
     */
    eProsima_user_DllExport const Union_UShort& var_union_ushort() const
    {
        return m_var_union_ushort;
    }

    /*!
     * @brief This function returns a reference to member var_union_ushort
     * @return Reference to member var_union_ushort
     */
    eProsima_user_DllExport Union_UShort& var_union_ushort()
    {
        return m_var_union_ushort;
    }



private:

    Union_UShort m_var_union_ushort;

};
/*!
 * @brief This class represents the structure UnionLong defined by the user in the IDL file.
 * @ingroup unions
 */
class UnionLong
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport UnionLong()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~UnionLong()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object UnionLong that will be copied.
     */
    eProsima_user_DllExport UnionLong(
            const UnionLong& x)
    {
                    m_var_union_long = x.m_var_union_long;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object UnionLong that will be copied.
     */
    eProsima_user_DllExport UnionLong(
            UnionLong&& x) noexcept
    {
        m_var_union_long = std::move(x.m_var_union_long);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object UnionLong that will be copied.
     */
    eProsima_user_DllExport UnionLong& operator =(
            const UnionLong& x)
    {

                    m_var_union_long = x.m_var_union_long;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object UnionLong that will be copied.
     */
    eProsima_user_DllExport UnionLong& operator =(
            UnionLong&& x) noexcept
    {

        m_var_union_long = std::move(x.m_var_union_long);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x UnionLong object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const UnionLong& x) const
    {
        return (m_var_union_long == x.m_var_union_long);
    }

    /*!
     * @brief Comparison operator.
     * @param x UnionLong object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const UnionLong& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_union_long
     * @param _var_union_long New value to be copied in member var_union_long
     */
    eProsima_user_DllExport void var_union_long(
            const Union_Long& _var_union_long)
    {
        m_var_union_long = _var_union_long;
    }

    /*!
     * @brief This function moves the value in member var_union_long
     * @param _var_union_long New value to be moved in member var_union_long
     */
    eProsima_user_DllExport void var_union_long(
            Union_Long&& _var_union_long)
    {
        m_var_union_long = std::move(_var_union_long);
    }

    /*!
     * @brief This function returns a constant reference to member var_union_long
     * @return Constant reference to member var_union_long
     */
    eProsima_user_DllExport const Union_Long& var_union_long() const
    {
        return m_var_union_long;
    }

    /*!
     * @brief This function returns a reference to member var_union_long
     * @return Reference to member var_union_long
     */
    eProsima_user_DllExport Union_Long& var_union_long()
    {
        return m_var_union_long;
    }



private:

    Union_Long m_var_union_long;

};
/*!
 * @brief This class represents the structure UnionULong defined by the user in the IDL file.
 * @ingroup unions
 */
class UnionULong
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport UnionULong()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~UnionULong()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object UnionULong that will be copied.
     */
    eProsima_user_DllExport UnionULong(
            const UnionULong& x)
    {
                    m_var_union_ulong = x.m_var_union_ulong;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object UnionULong that will be copied.
     */
    eProsima_user_DllExport UnionULong(
            UnionULong&& x) noexcept
    {
        m_var_union_ulong = std::move(x.m_var_union_ulong);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object UnionULong that will be copied.
     */
    eProsima_user_DllExport UnionULong& operator =(
            const UnionULong& x)
    {

                    m_var_union_ulong = x.m_var_union_ulong;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object UnionULong that will be copied.
     */
    eProsima_user_DllExport UnionULong& operator =(
            UnionULong&& x) noexcept
    {

        m_var_union_ulong = std::move(x.m_var_union_ulong);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x UnionULong object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const UnionULong& x) const
    {
        return (m_var_union_ulong == x.m_var_union_ulong);
    }

    /*!
     * @brief Comparison operator.
     * @param x UnionULong object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const UnionULong& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_union_ulong
     * @param _var_union_ulong New value to be copied in member var_union_ulong
     */
    eProsima_user_DllExport void var_union_ulong(
            const Union_ULong& _var_union_ulong)
    {
        m_var_union_ulong = _var_union_ulong;
    }

    /*!
     * @brief This function moves the value in member var_union_ulong
     * @param _var_union_ulong New value to be moved in member var_union_ulong
     */
    eProsima_user_DllExport void var_union_ulong(
            Union_ULong&& _var_union_ulong)
    {
        m_var_union_ulong = std::move(_var_union_ulong);
    }

    /*!
     * @brief This function returns a constant reference to member var_union_ulong
     * @return Constant reference to member var_union_ulong
     */
    eProsima_user_DllExport const Union_ULong& var_union_ulong() const
    {
        return m_var_union_ulong;
    }

    /*!
     * @brief This function returns a reference to member var_union_ulong
     * @return Reference to member var_union_ulong
     */
    eProsima_user_DllExport Union_ULong& var_union_ulong()
    {
        return m_var_union_ulong;
    }



private:

    Union_ULong m_var_union_ulong;

};
/*!
 * @brief This class represents the structure UnionLongLong defined by the user in the IDL file.
 * @ingroup unions
 */
class UnionLongLong
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport UnionLongLong()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~UnionLongLong()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object UnionLongLong that will be copied.
     */
    eProsima_user_DllExport UnionLongLong(
            const UnionLongLong& x)
    {
                    m_var_union_long_long = x.m_var_union_long_long;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object UnionLongLong that will be copied.
     */
    eProsima_user_DllExport UnionLongLong(
            UnionLongLong&& x) noexcept
    {
        m_var_union_long_long = std::move(x.m_var_union_long_long);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object UnionLongLong that will be copied.
     */
    eProsima_user_DllExport UnionLongLong& operator =(
            const UnionLongLong& x)
    {

                    m_var_union_long_long = x.m_var_union_long_long;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object UnionLongLong that will be copied.
     */
    eProsima_user_DllExport UnionLongLong& operator =(
            UnionLongLong&& x) noexcept
    {

        m_var_union_long_long = std::move(x.m_var_union_long_long);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x UnionLongLong object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const UnionLongLong& x) const
    {
        return (m_var_union_long_long == x.m_var_union_long_long);
    }

    /*!
     * @brief Comparison operator.
     * @param x UnionLongLong object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const UnionLongLong& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_union_long_long
     * @param _var_union_long_long New value to be copied in member var_union_long_long
     */
    eProsima_user_DllExport void var_union_long_long(
            const Union_LongLong& _var_union_long_long)
    {
        m_var_union_long_long = _var_union_long_long;
    }

    /*!
     * @brief This function moves the value in member var_union_long_long
     * @param _var_union_long_long New value to be moved in member var_union_long_long
     */
    eProsima_user_DllExport void var_union_long_long(
            Union_LongLong&& _var_union_long_long)
    {
        m_var_union_long_long = std::move(_var_union_long_long);
    }

    /*!
     * @brief This function returns a constant reference to member var_union_long_long
     * @return Constant reference to member var_union_long_long
     */
    eProsima_user_DllExport const Union_LongLong& var_union_long_long() const
    {
        return m_var_union_long_long;
    }

    /*!
     * @brief This function returns a reference to member var_union_long_long
     * @return Reference to member var_union_long_long
     */
    eProsima_user_DllExport Union_LongLong& var_union_long_long()
    {
        return m_var_union_long_long;
    }



private:

    Union_LongLong m_var_union_long_long;

};
/*!
 * @brief This class represents the structure UnionULongLong defined by the user in the IDL file.
 * @ingroup unions
 */
class UnionULongLong
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport UnionULongLong()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~UnionULongLong()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object UnionULongLong that will be copied.
     */
    eProsima_user_DllExport UnionULongLong(
            const UnionULongLong& x)
    {
                    m_var_union_ulong_long = x.m_var_union_ulong_long;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object UnionULongLong that will be copied.
     */
    eProsima_user_DllExport UnionULongLong(
            UnionULongLong&& x) noexcept
    {
        m_var_union_ulong_long = std::move(x.m_var_union_ulong_long);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object UnionULongLong that will be copied.
     */
    eProsima_user_DllExport UnionULongLong& operator =(
            const UnionULongLong& x)
    {

                    m_var_union_ulong_long = x.m_var_union_ulong_long;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object UnionULongLong that will be copied.
     */
    eProsima_user_DllExport UnionULongLong& operator =(
            UnionULongLong&& x) noexcept
    {

        m_var_union_ulong_long = std::move(x.m_var_union_ulong_long);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x UnionULongLong object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const UnionULongLong& x) const
    {
        return (m_var_union_ulong_long == x.m_var_union_ulong_long);
    }

    /*!
     * @brief Comparison operator.
     * @param x UnionULongLong object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const UnionULongLong& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_union_ulong_long
     * @param _var_union_ulong_long New value to be copied in member var_union_ulong_long
     */
    eProsima_user_DllExport void var_union_ulong_long(
            const Union_ULongLOng& _var_union_ulong_long)
    {
        m_var_union_ulong_long = _var_union_ulong_long;
    }

    /*!
     * @brief This function moves the value in member var_union_ulong_long
     * @param _var_union_ulong_long New value to be moved in member var_union_ulong_long
     */
    eProsima_user_DllExport void var_union_ulong_long(
            Union_ULongLOng&& _var_union_ulong_long)
    {
        m_var_union_ulong_long = std::move(_var_union_ulong_long);
    }

    /*!
     * @brief This function returns a constant reference to member var_union_ulong_long
     * @return Constant reference to member var_union_ulong_long
     */
    eProsima_user_DllExport const Union_ULongLOng& var_union_ulong_long() const
    {
        return m_var_union_ulong_long;
    }

    /*!
     * @brief This function returns a reference to member var_union_ulong_long
     * @return Reference to member var_union_ulong_long
     */
    eProsima_user_DllExport Union_ULongLOng& var_union_ulong_long()
    {
        return m_var_union_ulong_long;
    }



private:

    Union_ULongLOng m_var_union_ulong_long;

};
/*!
 * @brief This class represents the structure UnionFloat defined by the user in the IDL file.
 * @ingroup unions
 */
class UnionFloat
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport UnionFloat()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~UnionFloat()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object UnionFloat that will be copied.
     */
    eProsima_user_DllExport UnionFloat(
            const UnionFloat& x)
    {
                    m_var_union_float = x.m_var_union_float;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object UnionFloat that will be copied.
     */
    eProsima_user_DllExport UnionFloat(
            UnionFloat&& x) noexcept
    {
        m_var_union_float = std::move(x.m_var_union_float);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object UnionFloat that will be copied.
     */
    eProsima_user_DllExport UnionFloat& operator =(
            const UnionFloat& x)
    {

                    m_var_union_float = x.m_var_union_float;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object UnionFloat that will be copied.
     */
    eProsima_user_DllExport UnionFloat& operator =(
            UnionFloat&& x) noexcept
    {

        m_var_union_float = std::move(x.m_var_union_float);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x UnionFloat object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const UnionFloat& x) const
    {
        return (m_var_union_float == x.m_var_union_float);
    }

    /*!
     * @brief Comparison operator.
     * @param x UnionFloat object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const UnionFloat& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_union_float
     * @param _var_union_float New value to be copied in member var_union_float
     */
    eProsima_user_DllExport void var_union_float(
            const Union_Float& _var_union_float)
    {
        m_var_union_float = _var_union_float;
    }

    /*!
     * @brief This function moves the value in member var_union_float
     * @param _var_union_float New value to be moved in member var_union_float
     */
    eProsima_user_DllExport void var_union_float(
            Union_Float&& _var_union_float)
    {
        m_var_union_float = std::move(_var_union_float);
    }

    /*!
     * @brief This function returns a constant reference to member var_union_float
     * @return Constant reference to member var_union_float
     */
    eProsima_user_DllExport const Union_Float& var_union_float() const
    {
        return m_var_union_float;
    }

    /*!
     * @brief This function returns a reference to member var_union_float
     * @return Reference to member var_union_float
     */
    eProsima_user_DllExport Union_Float& var_union_float()
    {
        return m_var_union_float;
    }



private:

    Union_Float m_var_union_float;

};
/*!
 * @brief This class represents the structure UnionDouble defined by the user in the IDL file.
 * @ingroup unions
 */
class UnionDouble
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport UnionDouble()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~UnionDouble()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object UnionDouble that will be copied.
     */
    eProsima_user_DllExport UnionDouble(
            const UnionDouble& x)
    {
                    m_var_union_double = x.m_var_union_double;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object UnionDouble that will be copied.
     */
    eProsima_user_DllExport UnionDouble(
            UnionDouble&& x) noexcept
    {
        m_var_union_double = std::move(x.m_var_union_double);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object UnionDouble that will be copied.
     */
    eProsima_user_DllExport UnionDouble& operator =(
            const UnionDouble& x)
    {

                    m_var_union_double = x.m_var_union_double;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object UnionDouble that will be copied.
     */
    eProsima_user_DllExport UnionDouble& operator =(
            UnionDouble&& x) noexcept
    {

        m_var_union_double = std::move(x.m_var_union_double);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x UnionDouble object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const UnionDouble& x) const
    {
        return (m_var_union_double == x.m_var_union_double);
    }

    /*!
     * @brief Comparison operator.
     * @param x UnionDouble object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const UnionDouble& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_union_double
     * @param _var_union_double New value to be copied in member var_union_double
     */
    eProsima_user_DllExport void var_union_double(
            const Union_Double& _var_union_double)
    {
        m_var_union_double = _var_union_double;
    }

    /*!
     * @brief This function moves the value in member var_union_double
     * @param _var_union_double New value to be moved in member var_union_double
     */
    eProsima_user_DllExport void var_union_double(
            Union_Double&& _var_union_double)
    {
        m_var_union_double = std::move(_var_union_double);
    }

    /*!
     * @brief This function returns a constant reference to member var_union_double
     * @return Constant reference to member var_union_double
     */
    eProsima_user_DllExport const Union_Double& var_union_double() const
    {
        return m_var_union_double;
    }

    /*!
     * @brief This function returns a reference to member var_union_double
     * @return Reference to member var_union_double
     */
    eProsima_user_DllExport Union_Double& var_union_double()
    {
        return m_var_union_double;
    }



private:

    Union_Double m_var_union_double;

};
/*!
 * @brief This class represents the structure UnionLongDouble defined by the user in the IDL file.
 * @ingroup unions
 */
class UnionLongDouble
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport UnionLongDouble()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~UnionLongDouble()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object UnionLongDouble that will be copied.
     */
    eProsima_user_DllExport UnionLongDouble(
            const UnionLongDouble& x)
    {
                    m_var_union_long_double = x.m_var_union_long_double;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object UnionLongDouble that will be copied.
     */
    eProsima_user_DllExport UnionLongDouble(
            UnionLongDouble&& x) noexcept
    {
        m_var_union_long_double = std::move(x.m_var_union_long_double);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object UnionLongDouble that will be copied.
     */
    eProsima_user_DllExport UnionLongDouble& operator =(
            const UnionLongDouble& x)
    {

                    m_var_union_long_double = x.m_var_union_long_double;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object UnionLongDouble that will be copied.
     */
    eProsima_user_DllExport UnionLongDouble& operator =(
            UnionLongDouble&& x) noexcept
    {

        m_var_union_long_double = std::move(x.m_var_union_long_double);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x UnionLongDouble object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const UnionLongDouble& x) const
    {
        return (m_var_union_long_double == x.m_var_union_long_double);
    }

    /*!
     * @brief Comparison operator.
     * @param x UnionLongDouble object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const UnionLongDouble& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_union_long_double
     * @param _var_union_long_double New value to be copied in member var_union_long_double
     */
    eProsima_user_DllExport void var_union_long_double(
            const Union_LongDouble& _var_union_long_double)
    {
        m_var_union_long_double = _var_union_long_double;
    }

    /*!
     * @brief This function moves the value in member var_union_long_double
     * @param _var_union_long_double New value to be moved in member var_union_long_double
     */
    eProsima_user_DllExport void var_union_long_double(
            Union_LongDouble&& _var_union_long_double)
    {
        m_var_union_long_double = std::move(_var_union_long_double);
    }

    /*!
     * @brief This function returns a constant reference to member var_union_long_double
     * @return Constant reference to member var_union_long_double
     */
    eProsima_user_DllExport const Union_LongDouble& var_union_long_double() const
    {
        return m_var_union_long_double;
    }

    /*!
     * @brief This function returns a reference to member var_union_long_double
     * @return Reference to member var_union_long_double
     */
    eProsima_user_DllExport Union_LongDouble& var_union_long_double()
    {
        return m_var_union_long_double;
    }



private:

    Union_LongDouble m_var_union_long_double;

};
/*!
 * @brief This class represents the structure UnionBoolean defined by the user in the IDL file.
 * @ingroup unions
 */
class UnionBoolean
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport UnionBoolean()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~UnionBoolean()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object UnionBoolean that will be copied.
     */
    eProsima_user_DllExport UnionBoolean(
            const UnionBoolean& x)
    {
                    m_var_union_boolean = x.m_var_union_boolean;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object UnionBoolean that will be copied.
     */
    eProsima_user_DllExport UnionBoolean(
            UnionBoolean&& x) noexcept
    {
        m_var_union_boolean = std::move(x.m_var_union_boolean);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object UnionBoolean that will be copied.
     */
    eProsima_user_DllExport UnionBoolean& operator =(
            const UnionBoolean& x)
    {

                    m_var_union_boolean = x.m_var_union_boolean;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object UnionBoolean that will be copied.
     */
    eProsima_user_DllExport UnionBoolean& operator =(
            UnionBoolean&& x) noexcept
    {

        m_var_union_boolean = std::move(x.m_var_union_boolean);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x UnionBoolean object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const UnionBoolean& x) const
    {
        return (m_var_union_boolean == x.m_var_union_boolean);
    }

    /*!
     * @brief Comparison operator.
     * @param x UnionBoolean object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const UnionBoolean& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_union_boolean
     * @param _var_union_boolean New value to be copied in member var_union_boolean
     */
    eProsima_user_DllExport void var_union_boolean(
            const Union_Boolean& _var_union_boolean)
    {
        m_var_union_boolean = _var_union_boolean;
    }

    /*!
     * @brief This function moves the value in member var_union_boolean
     * @param _var_union_boolean New value to be moved in member var_union_boolean
     */
    eProsima_user_DllExport void var_union_boolean(
            Union_Boolean&& _var_union_boolean)
    {
        m_var_union_boolean = std::move(_var_union_boolean);
    }

    /*!
     * @brief This function returns a constant reference to member var_union_boolean
     * @return Constant reference to member var_union_boolean
     */
    eProsima_user_DllExport const Union_Boolean& var_union_boolean() const
    {
        return m_var_union_boolean;
    }

    /*!
     * @brief This function returns a reference to member var_union_boolean
     * @return Reference to member var_union_boolean
     */
    eProsima_user_DllExport Union_Boolean& var_union_boolean()
    {
        return m_var_union_boolean;
    }



private:

    Union_Boolean m_var_union_boolean;

};
/*!
 * @brief This class represents the structure UnionOctet defined by the user in the IDL file.
 * @ingroup unions
 */
class UnionOctet
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport UnionOctet()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~UnionOctet()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object UnionOctet that will be copied.
     */
    eProsima_user_DllExport UnionOctet(
            const UnionOctet& x)
    {
                    m_var_union_octet = x.m_var_union_octet;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object UnionOctet that will be copied.
     */
    eProsima_user_DllExport UnionOctet(
            UnionOctet&& x) noexcept
    {
        m_var_union_octet = std::move(x.m_var_union_octet);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object UnionOctet that will be copied.
     */
    eProsima_user_DllExport UnionOctet& operator =(
            const UnionOctet& x)
    {

                    m_var_union_octet = x.m_var_union_octet;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object UnionOctet that will be copied.
     */
    eProsima_user_DllExport UnionOctet& operator =(
            UnionOctet&& x) noexcept
    {

        m_var_union_octet = std::move(x.m_var_union_octet);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x UnionOctet object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const UnionOctet& x) const
    {
        return (m_var_union_octet == x.m_var_union_octet);
    }

    /*!
     * @brief Comparison operator.
     * @param x UnionOctet object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const UnionOctet& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_union_octet
     * @param _var_union_octet New value to be copied in member var_union_octet
     */
    eProsima_user_DllExport void var_union_octet(
            const Union_Octet& _var_union_octet)
    {
        m_var_union_octet = _var_union_octet;
    }

    /*!
     * @brief This function moves the value in member var_union_octet
     * @param _var_union_octet New value to be moved in member var_union_octet
     */
    eProsima_user_DllExport void var_union_octet(
            Union_Octet&& _var_union_octet)
    {
        m_var_union_octet = std::move(_var_union_octet);
    }

    /*!
     * @brief This function returns a constant reference to member var_union_octet
     * @return Constant reference to member var_union_octet
     */
    eProsima_user_DllExport const Union_Octet& var_union_octet() const
    {
        return m_var_union_octet;
    }

    /*!
     * @brief This function returns a reference to member var_union_octet
     * @return Reference to member var_union_octet
     */
    eProsima_user_DllExport Union_Octet& var_union_octet()
    {
        return m_var_union_octet;
    }



private:

    Union_Octet m_var_union_octet;

};
/*!
 * @brief This class represents the structure UnionChar defined by the user in the IDL file.
 * @ingroup unions
 */
class UnionChar
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport UnionChar()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~UnionChar()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object UnionChar that will be copied.
     */
    eProsima_user_DllExport UnionChar(
            const UnionChar& x)
    {
                    m_var_union_char = x.m_var_union_char;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object UnionChar that will be copied.
     */
    eProsima_user_DllExport UnionChar(
            UnionChar&& x) noexcept
    {
        m_var_union_char = std::move(x.m_var_union_char);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object UnionChar that will be copied.
     */
    eProsima_user_DllExport UnionChar& operator =(
            const UnionChar& x)
    {

                    m_var_union_char = x.m_var_union_char;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object UnionChar that will be copied.
     */
    eProsima_user_DllExport UnionChar& operator =(
            UnionChar&& x) noexcept
    {

        m_var_union_char = std::move(x.m_var_union_char);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x UnionChar object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const UnionChar& x) const
    {
        return (m_var_union_char == x.m_var_union_char);
    }

    /*!
     * @brief Comparison operator.
     * @param x UnionChar object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const UnionChar& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_union_char
     * @param _var_union_char New value to be copied in member var_union_char
     */
    eProsima_user_DllExport void var_union_char(
            const Union_Char& _var_union_char)
    {
        m_var_union_char = _var_union_char;
    }

    /*!
     * @brief This function moves the value in member var_union_char
     * @param _var_union_char New value to be moved in member var_union_char
     */
    eProsima_user_DllExport void var_union_char(
            Union_Char&& _var_union_char)
    {
        m_var_union_char = std::move(_var_union_char);
    }

    /*!
     * @brief This function returns a constant reference to member var_union_char
     * @return Constant reference to member var_union_char
     */
    eProsima_user_DllExport const Union_Char& var_union_char() const
    {
        return m_var_union_char;
    }

    /*!
     * @brief This function returns a reference to member var_union_char
     * @return Reference to member var_union_char
     */
    eProsima_user_DllExport Union_Char& var_union_char()
    {
        return m_var_union_char;
    }



private:

    Union_Char m_var_union_char;

};
/*!
 * @brief This class represents the structure UnionWChar defined by the user in the IDL file.
 * @ingroup unions
 */
class UnionWChar
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport UnionWChar()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~UnionWChar()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object UnionWChar that will be copied.
     */
    eProsima_user_DllExport UnionWChar(
            const UnionWChar& x)
    {
                    m_var_union_wchar = x.m_var_union_wchar;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object UnionWChar that will be copied.
     */
    eProsima_user_DllExport UnionWChar(
            UnionWChar&& x) noexcept
    {
        m_var_union_wchar = std::move(x.m_var_union_wchar);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object UnionWChar that will be copied.
     */
    eProsima_user_DllExport UnionWChar& operator =(
            const UnionWChar& x)
    {

                    m_var_union_wchar = x.m_var_union_wchar;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object UnionWChar that will be copied.
     */
    eProsima_user_DllExport UnionWChar& operator =(
            UnionWChar&& x) noexcept
    {

        m_var_union_wchar = std::move(x.m_var_union_wchar);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x UnionWChar object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const UnionWChar& x) const
    {
        return (m_var_union_wchar == x.m_var_union_wchar);
    }

    /*!
     * @brief Comparison operator.
     * @param x UnionWChar object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const UnionWChar& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_union_wchar
     * @param _var_union_wchar New value to be copied in member var_union_wchar
     */
    eProsima_user_DllExport void var_union_wchar(
            const Union_WChar& _var_union_wchar)
    {
        m_var_union_wchar = _var_union_wchar;
    }

    /*!
     * @brief This function moves the value in member var_union_wchar
     * @param _var_union_wchar New value to be moved in member var_union_wchar
     */
    eProsima_user_DllExport void var_union_wchar(
            Union_WChar&& _var_union_wchar)
    {
        m_var_union_wchar = std::move(_var_union_wchar);
    }

    /*!
     * @brief This function returns a constant reference to member var_union_wchar
     * @return Constant reference to member var_union_wchar
     */
    eProsima_user_DllExport const Union_WChar& var_union_wchar() const
    {
        return m_var_union_wchar;
    }

    /*!
     * @brief This function returns a reference to member var_union_wchar
     * @return Reference to member var_union_wchar
     */
    eProsima_user_DllExport Union_WChar& var_union_wchar()
    {
        return m_var_union_wchar;
    }



private:

    Union_WChar m_var_union_wchar;

};
/*!
 * @brief This class represents the structure UnionString defined by the user in the IDL file.
 * @ingroup unions
 */
class UnionString
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport UnionString()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~UnionString()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object UnionString that will be copied.
     */
    eProsima_user_DllExport UnionString(
            const UnionString& x)
    {
                    m_var_union_string = x.m_var_union_string;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object UnionString that will be copied.
     */
    eProsima_user_DllExport UnionString(
            UnionString&& x) noexcept
    {
        m_var_union_string = std::move(x.m_var_union_string);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object UnionString that will be copied.
     */
    eProsima_user_DllExport UnionString& operator =(
            const UnionString& x)
    {

                    m_var_union_string = x.m_var_union_string;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object UnionString that will be copied.
     */
    eProsima_user_DllExport UnionString& operator =(
            UnionString&& x) noexcept
    {

        m_var_union_string = std::move(x.m_var_union_string);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x UnionString object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const UnionString& x) const
    {
        return (m_var_union_string == x.m_var_union_string);
    }

    /*!
     * @brief Comparison operator.
     * @param x UnionString object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const UnionString& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_union_string
     * @param _var_union_string New value to be copied in member var_union_string
     */
    eProsima_user_DllExport void var_union_string(
            const Union_String& _var_union_string)
    {
        m_var_union_string = _var_union_string;
    }

    /*!
     * @brief This function moves the value in member var_union_string
     * @param _var_union_string New value to be moved in member var_union_string
     */
    eProsima_user_DllExport void var_union_string(
            Union_String&& _var_union_string)
    {
        m_var_union_string = std::move(_var_union_string);
    }

    /*!
     * @brief This function returns a constant reference to member var_union_string
     * @return Constant reference to member var_union_string
     */
    eProsima_user_DllExport const Union_String& var_union_string() const
    {
        return m_var_union_string;
    }

    /*!
     * @brief This function returns a reference to member var_union_string
     * @return Reference to member var_union_string
     */
    eProsima_user_DllExport Union_String& var_union_string()
    {
        return m_var_union_string;
    }



private:

    Union_String m_var_union_string;

};
/*!
 * @brief This class represents the structure UnionWString defined by the user in the IDL file.
 * @ingroup unions
 */
class UnionWString
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport UnionWString()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~UnionWString()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object UnionWString that will be copied.
     */
    eProsima_user_DllExport UnionWString(
            const UnionWString& x)
    {
                    m_var_union_wstring = x.m_var_union_wstring;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object UnionWString that will be copied.
     */
    eProsima_user_DllExport UnionWString(
            UnionWString&& x) noexcept
    {
        m_var_union_wstring = std::move(x.m_var_union_wstring);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object UnionWString that will be copied.
     */
    eProsima_user_DllExport UnionWString& operator =(
            const UnionWString& x)
    {

                    m_var_union_wstring = x.m_var_union_wstring;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object UnionWString that will be copied.
     */
    eProsima_user_DllExport UnionWString& operator =(
            UnionWString&& x) noexcept
    {

        m_var_union_wstring = std::move(x.m_var_union_wstring);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x UnionWString object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const UnionWString& x) const
    {
        return (m_var_union_wstring == x.m_var_union_wstring);
    }

    /*!
     * @brief Comparison operator.
     * @param x UnionWString object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const UnionWString& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_union_wstring
     * @param _var_union_wstring New value to be copied in member var_union_wstring
     */
    eProsima_user_DllExport void var_union_wstring(
            const Union_WString& _var_union_wstring)
    {
        m_var_union_wstring = _var_union_wstring;
    }

    /*!
     * @brief This function moves the value in member var_union_wstring
     * @param _var_union_wstring New value to be moved in member var_union_wstring
     */
    eProsima_user_DllExport void var_union_wstring(
            Union_WString&& _var_union_wstring)
    {
        m_var_union_wstring = std::move(_var_union_wstring);
    }

    /*!
     * @brief This function returns a constant reference to member var_union_wstring
     * @return Constant reference to member var_union_wstring
     */
    eProsima_user_DllExport const Union_WString& var_union_wstring() const
    {
        return m_var_union_wstring;
    }

    /*!
     * @brief This function returns a reference to member var_union_wstring
     * @return Reference to member var_union_wstring
     */
    eProsima_user_DllExport Union_WString& var_union_wstring()
    {
        return m_var_union_wstring;
    }



private:

    Union_WString m_var_union_wstring;

};
/*!
 * @brief This class represents the structure UnionBoundedString defined by the user in the IDL file.
 * @ingroup unions
 */
class UnionBoundedString
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport UnionBoundedString()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~UnionBoundedString()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object UnionBoundedString that will be copied.
     */
    eProsima_user_DllExport UnionBoundedString(
            const UnionBoundedString& x)
    {
                    m_var_union_bounded_string = x.m_var_union_bounded_string;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object UnionBoundedString that will be copied.
     */
    eProsima_user_DllExport UnionBoundedString(
            UnionBoundedString&& x) noexcept
    {
        m_var_union_bounded_string = std::move(x.m_var_union_bounded_string);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object UnionBoundedString that will be copied.
     */
    eProsima_user_DllExport UnionBoundedString& operator =(
            const UnionBoundedString& x)
    {

                    m_var_union_bounded_string = x.m_var_union_bounded_string;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object UnionBoundedString that will be copied.
     */
    eProsima_user_DllExport UnionBoundedString& operator =(
            UnionBoundedString&& x) noexcept
    {

        m_var_union_bounded_string = std::move(x.m_var_union_bounded_string);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x UnionBoundedString object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const UnionBoundedString& x) const
    {
        return (m_var_union_bounded_string == x.m_var_union_bounded_string);
    }

    /*!
     * @brief Comparison operator.
     * @param x UnionBoundedString object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const UnionBoundedString& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_union_bounded_string
     * @param _var_union_bounded_string New value to be copied in member var_union_bounded_string
     */
    eProsima_user_DllExport void var_union_bounded_string(
            const Union_BoundedString& _var_union_bounded_string)
    {
        m_var_union_bounded_string = _var_union_bounded_string;
    }

    /*!
     * @brief This function moves the value in member var_union_bounded_string
     * @param _var_union_bounded_string New value to be moved in member var_union_bounded_string
     */
    eProsima_user_DllExport void var_union_bounded_string(
            Union_BoundedString&& _var_union_bounded_string)
    {
        m_var_union_bounded_string = std::move(_var_union_bounded_string);
    }

    /*!
     * @brief This function returns a constant reference to member var_union_bounded_string
     * @return Constant reference to member var_union_bounded_string
     */
    eProsima_user_DllExport const Union_BoundedString& var_union_bounded_string() const
    {
        return m_var_union_bounded_string;
    }

    /*!
     * @brief This function returns a reference to member var_union_bounded_string
     * @return Reference to member var_union_bounded_string
     */
    eProsima_user_DllExport Union_BoundedString& var_union_bounded_string()
    {
        return m_var_union_bounded_string;
    }



private:

    Union_BoundedString m_var_union_bounded_string;

};
/*!
 * @brief This class represents the structure UnionBoundedWString defined by the user in the IDL file.
 * @ingroup unions
 */
class UnionBoundedWString
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport UnionBoundedWString()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~UnionBoundedWString()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object UnionBoundedWString that will be copied.
     */
    eProsima_user_DllExport UnionBoundedWString(
            const UnionBoundedWString& x)
    {
                    m_var_union_bounded_wstring = x.m_var_union_bounded_wstring;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object UnionBoundedWString that will be copied.
     */
    eProsima_user_DllExport UnionBoundedWString(
            UnionBoundedWString&& x) noexcept
    {
        m_var_union_bounded_wstring = std::move(x.m_var_union_bounded_wstring);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object UnionBoundedWString that will be copied.
     */
    eProsima_user_DllExport UnionBoundedWString& operator =(
            const UnionBoundedWString& x)
    {

                    m_var_union_bounded_wstring = x.m_var_union_bounded_wstring;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object UnionBoundedWString that will be copied.
     */
    eProsima_user_DllExport UnionBoundedWString& operator =(
            UnionBoundedWString&& x) noexcept
    {

        m_var_union_bounded_wstring = std::move(x.m_var_union_bounded_wstring);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x UnionBoundedWString object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const UnionBoundedWString& x) const
    {
        return (m_var_union_bounded_wstring == x.m_var_union_bounded_wstring);
    }

    /*!
     * @brief Comparison operator.
     * @param x UnionBoundedWString object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const UnionBoundedWString& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_union_bounded_wstring
     * @param _var_union_bounded_wstring New value to be copied in member var_union_bounded_wstring
     */
    eProsima_user_DllExport void var_union_bounded_wstring(
            const Union_BoundedWString& _var_union_bounded_wstring)
    {
        m_var_union_bounded_wstring = _var_union_bounded_wstring;
    }

    /*!
     * @brief This function moves the value in member var_union_bounded_wstring
     * @param _var_union_bounded_wstring New value to be moved in member var_union_bounded_wstring
     */
    eProsima_user_DllExport void var_union_bounded_wstring(
            Union_BoundedWString&& _var_union_bounded_wstring)
    {
        m_var_union_bounded_wstring = std::move(_var_union_bounded_wstring);
    }

    /*!
     * @brief This function returns a constant reference to member var_union_bounded_wstring
     * @return Constant reference to member var_union_bounded_wstring
     */
    eProsima_user_DllExport const Union_BoundedWString& var_union_bounded_wstring() const
    {
        return m_var_union_bounded_wstring;
    }

    /*!
     * @brief This function returns a reference to member var_union_bounded_wstring
     * @return Reference to member var_union_bounded_wstring
     */
    eProsima_user_DllExport Union_BoundedWString& var_union_bounded_wstring()
    {
        return m_var_union_bounded_wstring;
    }



private:

    Union_BoundedWString m_var_union_bounded_wstring;

};
/*!
 * @brief This class represents the structure UnionInnerEnumHelper defined by the user in the IDL file.
 * @ingroup unions
 */
class UnionInnerEnumHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport UnionInnerEnumHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~UnionInnerEnumHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object UnionInnerEnumHelper that will be copied.
     */
    eProsima_user_DllExport UnionInnerEnumHelper(
            const UnionInnerEnumHelper& x)
    {
                    m_var_union_my_enum = x.m_var_union_my_enum;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object UnionInnerEnumHelper that will be copied.
     */
    eProsima_user_DllExport UnionInnerEnumHelper(
            UnionInnerEnumHelper&& x) noexcept
    {
        m_var_union_my_enum = std::move(x.m_var_union_my_enum);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object UnionInnerEnumHelper that will be copied.
     */
    eProsima_user_DllExport UnionInnerEnumHelper& operator =(
            const UnionInnerEnumHelper& x)
    {

                    m_var_union_my_enum = x.m_var_union_my_enum;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object UnionInnerEnumHelper that will be copied.
     */
    eProsima_user_DllExport UnionInnerEnumHelper& operator =(
            UnionInnerEnumHelper&& x) noexcept
    {

        m_var_union_my_enum = std::move(x.m_var_union_my_enum);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x UnionInnerEnumHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const UnionInnerEnumHelper& x) const
    {
        return (m_var_union_my_enum == x.m_var_union_my_enum);
    }

    /*!
     * @brief Comparison operator.
     * @param x UnionInnerEnumHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const UnionInnerEnumHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_union_my_enum
     * @param _var_union_my_enum New value to be copied in member var_union_my_enum
     */
    eProsima_user_DllExport void var_union_my_enum(
            const Union_InnerEnumHelper& _var_union_my_enum)
    {
        m_var_union_my_enum = _var_union_my_enum;
    }

    /*!
     * @brief This function moves the value in member var_union_my_enum
     * @param _var_union_my_enum New value to be moved in member var_union_my_enum
     */
    eProsima_user_DllExport void var_union_my_enum(
            Union_InnerEnumHelper&& _var_union_my_enum)
    {
        m_var_union_my_enum = std::move(_var_union_my_enum);
    }

    /*!
     * @brief This function returns a constant reference to member var_union_my_enum
     * @return Constant reference to member var_union_my_enum
     */
    eProsima_user_DllExport const Union_InnerEnumHelper& var_union_my_enum() const
    {
        return m_var_union_my_enum;
    }

    /*!
     * @brief This function returns a reference to member var_union_my_enum
     * @return Reference to member var_union_my_enum
     */
    eProsima_user_DllExport Union_InnerEnumHelper& var_union_my_enum()
    {
        return m_var_union_my_enum;
    }



private:

    Union_InnerEnumHelper m_var_union_my_enum;

};
/*!
 * @brief This class represents the structure UnionInnerBitMaskHelper defined by the user in the IDL file.
 * @ingroup unions
 */
class UnionInnerBitMaskHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport UnionInnerBitMaskHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~UnionInnerBitMaskHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object UnionInnerBitMaskHelper that will be copied.
     */
    eProsima_user_DllExport UnionInnerBitMaskHelper(
            const UnionInnerBitMaskHelper& x)
    {
                    m_var_union_my_bit_mask = x.m_var_union_my_bit_mask;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object UnionInnerBitMaskHelper that will be copied.
     */
    eProsima_user_DllExport UnionInnerBitMaskHelper(
            UnionInnerBitMaskHelper&& x) noexcept
    {
        m_var_union_my_bit_mask = std::move(x.m_var_union_my_bit_mask);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object UnionInnerBitMaskHelper that will be copied.
     */
    eProsima_user_DllExport UnionInnerBitMaskHelper& operator =(
            const UnionInnerBitMaskHelper& x)
    {

                    m_var_union_my_bit_mask = x.m_var_union_my_bit_mask;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object UnionInnerBitMaskHelper that will be copied.
     */
    eProsima_user_DllExport UnionInnerBitMaskHelper& operator =(
            UnionInnerBitMaskHelper&& x) noexcept
    {

        m_var_union_my_bit_mask = std::move(x.m_var_union_my_bit_mask);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x UnionInnerBitMaskHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const UnionInnerBitMaskHelper& x) const
    {
        return (m_var_union_my_bit_mask == x.m_var_union_my_bit_mask);
    }

    /*!
     * @brief Comparison operator.
     * @param x UnionInnerBitMaskHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const UnionInnerBitMaskHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_union_my_bit_mask
     * @param _var_union_my_bit_mask New value to be copied in member var_union_my_bit_mask
     */
    eProsima_user_DllExport void var_union_my_bit_mask(
            const Union_InnerBitMaskHelper& _var_union_my_bit_mask)
    {
        m_var_union_my_bit_mask = _var_union_my_bit_mask;
    }

    /*!
     * @brief This function moves the value in member var_union_my_bit_mask
     * @param _var_union_my_bit_mask New value to be moved in member var_union_my_bit_mask
     */
    eProsima_user_DllExport void var_union_my_bit_mask(
            Union_InnerBitMaskHelper&& _var_union_my_bit_mask)
    {
        m_var_union_my_bit_mask = std::move(_var_union_my_bit_mask);
    }

    /*!
     * @brief This function returns a constant reference to member var_union_my_bit_mask
     * @return Constant reference to member var_union_my_bit_mask
     */
    eProsima_user_DllExport const Union_InnerBitMaskHelper& var_union_my_bit_mask() const
    {
        return m_var_union_my_bit_mask;
    }

    /*!
     * @brief This function returns a reference to member var_union_my_bit_mask
     * @return Reference to member var_union_my_bit_mask
     */
    eProsima_user_DllExport Union_InnerBitMaskHelper& var_union_my_bit_mask()
    {
        return m_var_union_my_bit_mask;
    }



private:

    Union_InnerBitMaskHelper m_var_union_my_bit_mask;

};
/*!
 * @brief This class represents the structure UnionInnerAliasHelper defined by the user in the IDL file.
 * @ingroup unions
 */
class UnionInnerAliasHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport UnionInnerAliasHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~UnionInnerAliasHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object UnionInnerAliasHelper that will be copied.
     */
    eProsima_user_DllExport UnionInnerAliasHelper(
            const UnionInnerAliasHelper& x)
    {
                    m_var_union_my_alias = x.m_var_union_my_alias;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object UnionInnerAliasHelper that will be copied.
     */
    eProsima_user_DllExport UnionInnerAliasHelper(
            UnionInnerAliasHelper&& x) noexcept
    {
        m_var_union_my_alias = std::move(x.m_var_union_my_alias);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object UnionInnerAliasHelper that will be copied.
     */
    eProsima_user_DllExport UnionInnerAliasHelper& operator =(
            const UnionInnerAliasHelper& x)
    {

                    m_var_union_my_alias = x.m_var_union_my_alias;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object UnionInnerAliasHelper that will be copied.
     */
    eProsima_user_DllExport UnionInnerAliasHelper& operator =(
            UnionInnerAliasHelper&& x) noexcept
    {

        m_var_union_my_alias = std::move(x.m_var_union_my_alias);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x UnionInnerAliasHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const UnionInnerAliasHelper& x) const
    {
        return (m_var_union_my_alias == x.m_var_union_my_alias);
    }

    /*!
     * @brief Comparison operator.
     * @param x UnionInnerAliasHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const UnionInnerAliasHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_union_my_alias
     * @param _var_union_my_alias New value to be copied in member var_union_my_alias
     */
    eProsima_user_DllExport void var_union_my_alias(
            const Union_InnerAliasHelper& _var_union_my_alias)
    {
        m_var_union_my_alias = _var_union_my_alias;
    }

    /*!
     * @brief This function moves the value in member var_union_my_alias
     * @param _var_union_my_alias New value to be moved in member var_union_my_alias
     */
    eProsima_user_DllExport void var_union_my_alias(
            Union_InnerAliasHelper&& _var_union_my_alias)
    {
        m_var_union_my_alias = std::move(_var_union_my_alias);
    }

    /*!
     * @brief This function returns a constant reference to member var_union_my_alias
     * @return Constant reference to member var_union_my_alias
     */
    eProsima_user_DllExport const Union_InnerAliasHelper& var_union_my_alias() const
    {
        return m_var_union_my_alias;
    }

    /*!
     * @brief This function returns a reference to member var_union_my_alias
     * @return Reference to member var_union_my_alias
     */
    eProsima_user_DllExport Union_InnerAliasHelper& var_union_my_alias()
    {
        return m_var_union_my_alias;
    }



private:

    Union_InnerAliasHelper m_var_union_my_alias;

};
/*!
 * @brief This class represents the structure UnionArray defined by the user in the IDL file.
 * @ingroup unions
 */
class UnionArray
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport UnionArray()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~UnionArray()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object UnionArray that will be copied.
     */
    eProsima_user_DllExport UnionArray(
            const UnionArray& x)
    {
                    m_var_union_array = x.m_var_union_array;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object UnionArray that will be copied.
     */
    eProsima_user_DllExport UnionArray(
            UnionArray&& x) noexcept
    {
        m_var_union_array = std::move(x.m_var_union_array);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object UnionArray that will be copied.
     */
    eProsima_user_DllExport UnionArray& operator =(
            const UnionArray& x)
    {

                    m_var_union_array = x.m_var_union_array;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object UnionArray that will be copied.
     */
    eProsima_user_DllExport UnionArray& operator =(
            UnionArray&& x) noexcept
    {

        m_var_union_array = std::move(x.m_var_union_array);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x UnionArray object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const UnionArray& x) const
    {
        return (m_var_union_array == x.m_var_union_array);
    }

    /*!
     * @brief Comparison operator.
     * @param x UnionArray object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const UnionArray& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_union_array
     * @param _var_union_array New value to be copied in member var_union_array
     */
    eProsima_user_DllExport void var_union_array(
            const Union_Array& _var_union_array)
    {
        m_var_union_array = _var_union_array;
    }

    /*!
     * @brief This function moves the value in member var_union_array
     * @param _var_union_array New value to be moved in member var_union_array
     */
    eProsima_user_DllExport void var_union_array(
            Union_Array&& _var_union_array)
    {
        m_var_union_array = std::move(_var_union_array);
    }

    /*!
     * @brief This function returns a constant reference to member var_union_array
     * @return Constant reference to member var_union_array
     */
    eProsima_user_DllExport const Union_Array& var_union_array() const
    {
        return m_var_union_array;
    }

    /*!
     * @brief This function returns a reference to member var_union_array
     * @return Reference to member var_union_array
     */
    eProsima_user_DllExport Union_Array& var_union_array()
    {
        return m_var_union_array;
    }



private:

    Union_Array m_var_union_array;

};
/*!
 * @brief This class represents the structure UnionSequence defined by the user in the IDL file.
 * @ingroup unions
 */
class UnionSequence
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport UnionSequence()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~UnionSequence()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object UnionSequence that will be copied.
     */
    eProsima_user_DllExport UnionSequence(
            const UnionSequence& x)
    {
                    m_var_union_sequence = x.m_var_union_sequence;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object UnionSequence that will be copied.
     */
    eProsima_user_DllExport UnionSequence(
            UnionSequence&& x) noexcept
    {
        m_var_union_sequence = std::move(x.m_var_union_sequence);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object UnionSequence that will be copied.
     */
    eProsima_user_DllExport UnionSequence& operator =(
            const UnionSequence& x)
    {

                    m_var_union_sequence = x.m_var_union_sequence;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object UnionSequence that will be copied.
     */
    eProsima_user_DllExport UnionSequence& operator =(
            UnionSequence&& x) noexcept
    {

        m_var_union_sequence = std::move(x.m_var_union_sequence);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x UnionSequence object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const UnionSequence& x) const
    {
        return (m_var_union_sequence == x.m_var_union_sequence);
    }

    /*!
     * @brief Comparison operator.
     * @param x UnionSequence object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const UnionSequence& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_union_sequence
     * @param _var_union_sequence New value to be copied in member var_union_sequence
     */
    eProsima_user_DllExport void var_union_sequence(
            const Union_Sequence& _var_union_sequence)
    {
        m_var_union_sequence = _var_union_sequence;
    }

    /*!
     * @brief This function moves the value in member var_union_sequence
     * @param _var_union_sequence New value to be moved in member var_union_sequence
     */
    eProsima_user_DllExport void var_union_sequence(
            Union_Sequence&& _var_union_sequence)
    {
        m_var_union_sequence = std::move(_var_union_sequence);
    }

    /*!
     * @brief This function returns a constant reference to member var_union_sequence
     * @return Constant reference to member var_union_sequence
     */
    eProsima_user_DllExport const Union_Sequence& var_union_sequence() const
    {
        return m_var_union_sequence;
    }

    /*!
     * @brief This function returns a reference to member var_union_sequence
     * @return Reference to member var_union_sequence
     */
    eProsima_user_DllExport Union_Sequence& var_union_sequence()
    {
        return m_var_union_sequence;
    }



private:

    Union_Sequence m_var_union_sequence;

};
/*!
 * @brief This class represents the structure UnionMap defined by the user in the IDL file.
 * @ingroup unions
 */
class UnionMap
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport UnionMap()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~UnionMap()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object UnionMap that will be copied.
     */
    eProsima_user_DllExport UnionMap(
            const UnionMap& x)
    {
                    m_var_union_map = x.m_var_union_map;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object UnionMap that will be copied.
     */
    eProsima_user_DllExport UnionMap(
            UnionMap&& x) noexcept
    {
        m_var_union_map = std::move(x.m_var_union_map);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object UnionMap that will be copied.
     */
    eProsima_user_DllExport UnionMap& operator =(
            const UnionMap& x)
    {

                    m_var_union_map = x.m_var_union_map;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object UnionMap that will be copied.
     */
    eProsima_user_DllExport UnionMap& operator =(
            UnionMap&& x) noexcept
    {

        m_var_union_map = std::move(x.m_var_union_map);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x UnionMap object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const UnionMap& x) const
    {
        return (m_var_union_map == x.m_var_union_map);
    }

    /*!
     * @brief Comparison operator.
     * @param x UnionMap object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const UnionMap& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_union_map
     * @param _var_union_map New value to be copied in member var_union_map
     */
    eProsima_user_DllExport void var_union_map(
            const Union_Map& _var_union_map)
    {
        m_var_union_map = _var_union_map;
    }

    /*!
     * @brief This function moves the value in member var_union_map
     * @param _var_union_map New value to be moved in member var_union_map
     */
    eProsima_user_DllExport void var_union_map(
            Union_Map&& _var_union_map)
    {
        m_var_union_map = std::move(_var_union_map);
    }

    /*!
     * @brief This function returns a constant reference to member var_union_map
     * @return Constant reference to member var_union_map
     */
    eProsima_user_DllExport const Union_Map& var_union_map() const
    {
        return m_var_union_map;
    }

    /*!
     * @brief This function returns a reference to member var_union_map
     * @return Reference to member var_union_map
     */
    eProsima_user_DllExport Union_Map& var_union_map()
    {
        return m_var_union_map;
    }



private:

    Union_Map m_var_union_map;

};
/*!
 * @brief This class represents the structure UnionInnerUnionHelper defined by the user in the IDL file.
 * @ingroup unions
 */
class UnionInnerUnionHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport UnionInnerUnionHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~UnionInnerUnionHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object UnionInnerUnionHelper that will be copied.
     */
    eProsima_user_DllExport UnionInnerUnionHelper(
            const UnionInnerUnionHelper& x)
    {
                    m_var_union_my_union = x.m_var_union_my_union;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object UnionInnerUnionHelper that will be copied.
     */
    eProsima_user_DllExport UnionInnerUnionHelper(
            UnionInnerUnionHelper&& x) noexcept
    {
        m_var_union_my_union = std::move(x.m_var_union_my_union);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object UnionInnerUnionHelper that will be copied.
     */
    eProsima_user_DllExport UnionInnerUnionHelper& operator =(
            const UnionInnerUnionHelper& x)
    {

                    m_var_union_my_union = x.m_var_union_my_union;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object UnionInnerUnionHelper that will be copied.
     */
    eProsima_user_DllExport UnionInnerUnionHelper& operator =(
            UnionInnerUnionHelper&& x) noexcept
    {

        m_var_union_my_union = std::move(x.m_var_union_my_union);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x UnionInnerUnionHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const UnionInnerUnionHelper& x) const
    {
        return (m_var_union_my_union == x.m_var_union_my_union);
    }

    /*!
     * @brief Comparison operator.
     * @param x UnionInnerUnionHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const UnionInnerUnionHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_union_my_union
     * @param _var_union_my_union New value to be copied in member var_union_my_union
     */
    eProsima_user_DllExport void var_union_my_union(
            const Union_InnerUnionHelper& _var_union_my_union)
    {
        m_var_union_my_union = _var_union_my_union;
    }

    /*!
     * @brief This function moves the value in member var_union_my_union
     * @param _var_union_my_union New value to be moved in member var_union_my_union
     */
    eProsima_user_DllExport void var_union_my_union(
            Union_InnerUnionHelper&& _var_union_my_union)
    {
        m_var_union_my_union = std::move(_var_union_my_union);
    }

    /*!
     * @brief This function returns a constant reference to member var_union_my_union
     * @return Constant reference to member var_union_my_union
     */
    eProsima_user_DllExport const Union_InnerUnionHelper& var_union_my_union() const
    {
        return m_var_union_my_union;
    }

    /*!
     * @brief This function returns a reference to member var_union_my_union
     * @return Reference to member var_union_my_union
     */
    eProsima_user_DllExport Union_InnerUnionHelper& var_union_my_union()
    {
        return m_var_union_my_union;
    }



private:

    Union_InnerUnionHelper m_var_union_my_union;

};
/*!
 * @brief This class represents the structure UnionInnerStructureHelper defined by the user in the IDL file.
 * @ingroup unions
 */
class UnionInnerStructureHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport UnionInnerStructureHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~UnionInnerStructureHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object UnionInnerStructureHelper that will be copied.
     */
    eProsima_user_DllExport UnionInnerStructureHelper(
            const UnionInnerStructureHelper& x)
    {
                    m_var_union_my_structure = x.m_var_union_my_structure;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object UnionInnerStructureHelper that will be copied.
     */
    eProsima_user_DllExport UnionInnerStructureHelper(
            UnionInnerStructureHelper&& x) noexcept
    {
        m_var_union_my_structure = std::move(x.m_var_union_my_structure);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object UnionInnerStructureHelper that will be copied.
     */
    eProsima_user_DllExport UnionInnerStructureHelper& operator =(
            const UnionInnerStructureHelper& x)
    {

                    m_var_union_my_structure = x.m_var_union_my_structure;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object UnionInnerStructureHelper that will be copied.
     */
    eProsima_user_DllExport UnionInnerStructureHelper& operator =(
            UnionInnerStructureHelper&& x) noexcept
    {

        m_var_union_my_structure = std::move(x.m_var_union_my_structure);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x UnionInnerStructureHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const UnionInnerStructureHelper& x) const
    {
        return (m_var_union_my_structure == x.m_var_union_my_structure);
    }

    /*!
     * @brief Comparison operator.
     * @param x UnionInnerStructureHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const UnionInnerStructureHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_union_my_structure
     * @param _var_union_my_structure New value to be copied in member var_union_my_structure
     */
    eProsima_user_DllExport void var_union_my_structure(
            const Union_InnerStructureHelper& _var_union_my_structure)
    {
        m_var_union_my_structure = _var_union_my_structure;
    }

    /*!
     * @brief This function moves the value in member var_union_my_structure
     * @param _var_union_my_structure New value to be moved in member var_union_my_structure
     */
    eProsima_user_DllExport void var_union_my_structure(
            Union_InnerStructureHelper&& _var_union_my_structure)
    {
        m_var_union_my_structure = std::move(_var_union_my_structure);
    }

    /*!
     * @brief This function returns a constant reference to member var_union_my_structure
     * @return Constant reference to member var_union_my_structure
     */
    eProsima_user_DllExport const Union_InnerStructureHelper& var_union_my_structure() const
    {
        return m_var_union_my_structure;
    }

    /*!
     * @brief This function returns a reference to member var_union_my_structure
     * @return Reference to member var_union_my_structure
     */
    eProsima_user_DllExport Union_InnerStructureHelper& var_union_my_structure()
    {
        return m_var_union_my_structure;
    }



private:

    Union_InnerStructureHelper m_var_union_my_structure;

};
/*!
 * @brief This class represents the structure UnionInnerBitsetHelper defined by the user in the IDL file.
 * @ingroup unions
 */
class UnionInnerBitsetHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport UnionInnerBitsetHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~UnionInnerBitsetHelper()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object UnionInnerBitsetHelper that will be copied.
     */
    eProsima_user_DllExport UnionInnerBitsetHelper(
            const UnionInnerBitsetHelper& x)
    {
                    m_var_union_my_bitset = x.m_var_union_my_bitset;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object UnionInnerBitsetHelper that will be copied.
     */
    eProsima_user_DllExport UnionInnerBitsetHelper(
            UnionInnerBitsetHelper&& x) noexcept
    {
        m_var_union_my_bitset = std::move(x.m_var_union_my_bitset);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object UnionInnerBitsetHelper that will be copied.
     */
    eProsima_user_DllExport UnionInnerBitsetHelper& operator =(
            const UnionInnerBitsetHelper& x)
    {

                    m_var_union_my_bitset = x.m_var_union_my_bitset;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object UnionInnerBitsetHelper that will be copied.
     */
    eProsima_user_DllExport UnionInnerBitsetHelper& operator =(
            UnionInnerBitsetHelper&& x) noexcept
    {

        m_var_union_my_bitset = std::move(x.m_var_union_my_bitset);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x UnionInnerBitsetHelper object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const UnionInnerBitsetHelper& x) const
    {
        return (m_var_union_my_bitset == x.m_var_union_my_bitset);
    }

    /*!
     * @brief Comparison operator.
     * @param x UnionInnerBitsetHelper object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const UnionInnerBitsetHelper& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_union_my_bitset
     * @param _var_union_my_bitset New value to be copied in member var_union_my_bitset
     */
    eProsima_user_DllExport void var_union_my_bitset(
            const Union_InnerBitsetHelper& _var_union_my_bitset)
    {
        m_var_union_my_bitset = _var_union_my_bitset;
    }

    /*!
     * @brief This function moves the value in member var_union_my_bitset
     * @param _var_union_my_bitset New value to be moved in member var_union_my_bitset
     */
    eProsima_user_DllExport void var_union_my_bitset(
            Union_InnerBitsetHelper&& _var_union_my_bitset)
    {
        m_var_union_my_bitset = std::move(_var_union_my_bitset);
    }

    /*!
     * @brief This function returns a constant reference to member var_union_my_bitset
     * @return Constant reference to member var_union_my_bitset
     */
    eProsima_user_DllExport const Union_InnerBitsetHelper& var_union_my_bitset() const
    {
        return m_var_union_my_bitset;
    }

    /*!
     * @brief This function returns a reference to member var_union_my_bitset
     * @return Reference to member var_union_my_bitset
     */
    eProsima_user_DllExport Union_InnerBitsetHelper& var_union_my_bitset()
    {
        return m_var_union_my_bitset;
    }



private:

    Union_InnerBitsetHelper m_var_union_my_bitset;

};
/*!
 * @brief This class represents the structure UnionDiscriminatorShort defined by the user in the IDL file.
 * @ingroup unions
 */
class UnionDiscriminatorShort
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport UnionDiscriminatorShort()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~UnionDiscriminatorShort()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object UnionDiscriminatorShort that will be copied.
     */
    eProsima_user_DllExport UnionDiscriminatorShort(
            const UnionDiscriminatorShort& x)
    {
                    m_var_union_discriminator_short = x.m_var_union_discriminator_short;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object UnionDiscriminatorShort that will be copied.
     */
    eProsima_user_DllExport UnionDiscriminatorShort(
            UnionDiscriminatorShort&& x) noexcept
    {
        m_var_union_discriminator_short = std::move(x.m_var_union_discriminator_short);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object UnionDiscriminatorShort that will be copied.
     */
    eProsima_user_DllExport UnionDiscriminatorShort& operator =(
            const UnionDiscriminatorShort& x)
    {

                    m_var_union_discriminator_short = x.m_var_union_discriminator_short;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object UnionDiscriminatorShort that will be copied.
     */
    eProsima_user_DllExport UnionDiscriminatorShort& operator =(
            UnionDiscriminatorShort&& x) noexcept
    {

        m_var_union_discriminator_short = std::move(x.m_var_union_discriminator_short);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x UnionDiscriminatorShort object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const UnionDiscriminatorShort& x) const
    {
        return (m_var_union_discriminator_short == x.m_var_union_discriminator_short);
    }

    /*!
     * @brief Comparison operator.
     * @param x UnionDiscriminatorShort object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const UnionDiscriminatorShort& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_union_discriminator_short
     * @param _var_union_discriminator_short New value to be copied in member var_union_discriminator_short
     */
    eProsima_user_DllExport void var_union_discriminator_short(
            const Union_Discriminator_short& _var_union_discriminator_short)
    {
        m_var_union_discriminator_short = _var_union_discriminator_short;
    }

    /*!
     * @brief This function moves the value in member var_union_discriminator_short
     * @param _var_union_discriminator_short New value to be moved in member var_union_discriminator_short
     */
    eProsima_user_DllExport void var_union_discriminator_short(
            Union_Discriminator_short&& _var_union_discriminator_short)
    {
        m_var_union_discriminator_short = std::move(_var_union_discriminator_short);
    }

    /*!
     * @brief This function returns a constant reference to member var_union_discriminator_short
     * @return Constant reference to member var_union_discriminator_short
     */
    eProsima_user_DllExport const Union_Discriminator_short& var_union_discriminator_short() const
    {
        return m_var_union_discriminator_short;
    }

    /*!
     * @brief This function returns a reference to member var_union_discriminator_short
     * @return Reference to member var_union_discriminator_short
     */
    eProsima_user_DllExport Union_Discriminator_short& var_union_discriminator_short()
    {
        return m_var_union_discriminator_short;
    }



private:

    Union_Discriminator_short m_var_union_discriminator_short;

};
/*!
 * @brief This class represents the structure UnionDiscriminatorUShort defined by the user in the IDL file.
 * @ingroup unions
 */
class UnionDiscriminatorUShort
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport UnionDiscriminatorUShort()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~UnionDiscriminatorUShort()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object UnionDiscriminatorUShort that will be copied.
     */
    eProsima_user_DllExport UnionDiscriminatorUShort(
            const UnionDiscriminatorUShort& x)
    {
                    m_var_union_discriminator_ushort = x.m_var_union_discriminator_ushort;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object UnionDiscriminatorUShort that will be copied.
     */
    eProsima_user_DllExport UnionDiscriminatorUShort(
            UnionDiscriminatorUShort&& x) noexcept
    {
        m_var_union_discriminator_ushort = std::move(x.m_var_union_discriminator_ushort);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object UnionDiscriminatorUShort that will be copied.
     */
    eProsima_user_DllExport UnionDiscriminatorUShort& operator =(
            const UnionDiscriminatorUShort& x)
    {

                    m_var_union_discriminator_ushort = x.m_var_union_discriminator_ushort;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object UnionDiscriminatorUShort that will be copied.
     */
    eProsima_user_DllExport UnionDiscriminatorUShort& operator =(
            UnionDiscriminatorUShort&& x) noexcept
    {

        m_var_union_discriminator_ushort = std::move(x.m_var_union_discriminator_ushort);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x UnionDiscriminatorUShort object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const UnionDiscriminatorUShort& x) const
    {
        return (m_var_union_discriminator_ushort == x.m_var_union_discriminator_ushort);
    }

    /*!
     * @brief Comparison operator.
     * @param x UnionDiscriminatorUShort object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const UnionDiscriminatorUShort& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_union_discriminator_ushort
     * @param _var_union_discriminator_ushort New value to be copied in member var_union_discriminator_ushort
     */
    eProsima_user_DllExport void var_union_discriminator_ushort(
            const Union_Discriminator_unsigned_short& _var_union_discriminator_ushort)
    {
        m_var_union_discriminator_ushort = _var_union_discriminator_ushort;
    }

    /*!
     * @brief This function moves the value in member var_union_discriminator_ushort
     * @param _var_union_discriminator_ushort New value to be moved in member var_union_discriminator_ushort
     */
    eProsima_user_DllExport void var_union_discriminator_ushort(
            Union_Discriminator_unsigned_short&& _var_union_discriminator_ushort)
    {
        m_var_union_discriminator_ushort = std::move(_var_union_discriminator_ushort);
    }

    /*!
     * @brief This function returns a constant reference to member var_union_discriminator_ushort
     * @return Constant reference to member var_union_discriminator_ushort
     */
    eProsima_user_DllExport const Union_Discriminator_unsigned_short& var_union_discriminator_ushort() const
    {
        return m_var_union_discriminator_ushort;
    }

    /*!
     * @brief This function returns a reference to member var_union_discriminator_ushort
     * @return Reference to member var_union_discriminator_ushort
     */
    eProsima_user_DllExport Union_Discriminator_unsigned_short& var_union_discriminator_ushort()
    {
        return m_var_union_discriminator_ushort;
    }



private:

    Union_Discriminator_unsigned_short m_var_union_discriminator_ushort;

};
/*!
 * @brief This class represents the structure UnionDiscriminatorLong defined by the user in the IDL file.
 * @ingroup unions
 */
class UnionDiscriminatorLong
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport UnionDiscriminatorLong()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~UnionDiscriminatorLong()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object UnionDiscriminatorLong that will be copied.
     */
    eProsima_user_DllExport UnionDiscriminatorLong(
            const UnionDiscriminatorLong& x)
    {
                    m_var_union_discriminator_long = x.m_var_union_discriminator_long;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object UnionDiscriminatorLong that will be copied.
     */
    eProsima_user_DllExport UnionDiscriminatorLong(
            UnionDiscriminatorLong&& x) noexcept
    {
        m_var_union_discriminator_long = std::move(x.m_var_union_discriminator_long);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object UnionDiscriminatorLong that will be copied.
     */
    eProsima_user_DllExport UnionDiscriminatorLong& operator =(
            const UnionDiscriminatorLong& x)
    {

                    m_var_union_discriminator_long = x.m_var_union_discriminator_long;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object UnionDiscriminatorLong that will be copied.
     */
    eProsima_user_DllExport UnionDiscriminatorLong& operator =(
            UnionDiscriminatorLong&& x) noexcept
    {

        m_var_union_discriminator_long = std::move(x.m_var_union_discriminator_long);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x UnionDiscriminatorLong object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const UnionDiscriminatorLong& x) const
    {
        return (m_var_union_discriminator_long == x.m_var_union_discriminator_long);
    }

    /*!
     * @brief Comparison operator.
     * @param x UnionDiscriminatorLong object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const UnionDiscriminatorLong& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_union_discriminator_long
     * @param _var_union_discriminator_long New value to be copied in member var_union_discriminator_long
     */
    eProsima_user_DllExport void var_union_discriminator_long(
            const Union_Discriminator_long& _var_union_discriminator_long)
    {
        m_var_union_discriminator_long = _var_union_discriminator_long;
    }

    /*!
     * @brief This function moves the value in member var_union_discriminator_long
     * @param _var_union_discriminator_long New value to be moved in member var_union_discriminator_long
     */
    eProsima_user_DllExport void var_union_discriminator_long(
            Union_Discriminator_long&& _var_union_discriminator_long)
    {
        m_var_union_discriminator_long = std::move(_var_union_discriminator_long);
    }

    /*!
     * @brief This function returns a constant reference to member var_union_discriminator_long
     * @return Constant reference to member var_union_discriminator_long
     */
    eProsima_user_DllExport const Union_Discriminator_long& var_union_discriminator_long() const
    {
        return m_var_union_discriminator_long;
    }

    /*!
     * @brief This function returns a reference to member var_union_discriminator_long
     * @return Reference to member var_union_discriminator_long
     */
    eProsima_user_DllExport Union_Discriminator_long& var_union_discriminator_long()
    {
        return m_var_union_discriminator_long;
    }



private:

    Union_Discriminator_long m_var_union_discriminator_long;

};
/*!
 * @brief This class represents the structure UnionDiscriminatorULong defined by the user in the IDL file.
 * @ingroup unions
 */
class UnionDiscriminatorULong
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport UnionDiscriminatorULong()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~UnionDiscriminatorULong()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object UnionDiscriminatorULong that will be copied.
     */
    eProsima_user_DllExport UnionDiscriminatorULong(
            const UnionDiscriminatorULong& x)
    {
                    m_var_union_discriminator_ulong = x.m_var_union_discriminator_ulong;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object UnionDiscriminatorULong that will be copied.
     */
    eProsima_user_DllExport UnionDiscriminatorULong(
            UnionDiscriminatorULong&& x) noexcept
    {
        m_var_union_discriminator_ulong = std::move(x.m_var_union_discriminator_ulong);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object UnionDiscriminatorULong that will be copied.
     */
    eProsima_user_DllExport UnionDiscriminatorULong& operator =(
            const UnionDiscriminatorULong& x)
    {

                    m_var_union_discriminator_ulong = x.m_var_union_discriminator_ulong;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object UnionDiscriminatorULong that will be copied.
     */
    eProsima_user_DllExport UnionDiscriminatorULong& operator =(
            UnionDiscriminatorULong&& x) noexcept
    {

        m_var_union_discriminator_ulong = std::move(x.m_var_union_discriminator_ulong);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x UnionDiscriminatorULong object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const UnionDiscriminatorULong& x) const
    {
        return (m_var_union_discriminator_ulong == x.m_var_union_discriminator_ulong);
    }

    /*!
     * @brief Comparison operator.
     * @param x UnionDiscriminatorULong object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const UnionDiscriminatorULong& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_union_discriminator_ulong
     * @param _var_union_discriminator_ulong New value to be copied in member var_union_discriminator_ulong
     */
    eProsima_user_DllExport void var_union_discriminator_ulong(
            const Union_Discriminator_unsigned_long& _var_union_discriminator_ulong)
    {
        m_var_union_discriminator_ulong = _var_union_discriminator_ulong;
    }

    /*!
     * @brief This function moves the value in member var_union_discriminator_ulong
     * @param _var_union_discriminator_ulong New value to be moved in member var_union_discriminator_ulong
     */
    eProsima_user_DllExport void var_union_discriminator_ulong(
            Union_Discriminator_unsigned_long&& _var_union_discriminator_ulong)
    {
        m_var_union_discriminator_ulong = std::move(_var_union_discriminator_ulong);
    }

    /*!
     * @brief This function returns a constant reference to member var_union_discriminator_ulong
     * @return Constant reference to member var_union_discriminator_ulong
     */
    eProsima_user_DllExport const Union_Discriminator_unsigned_long& var_union_discriminator_ulong() const
    {
        return m_var_union_discriminator_ulong;
    }

    /*!
     * @brief This function returns a reference to member var_union_discriminator_ulong
     * @return Reference to member var_union_discriminator_ulong
     */
    eProsima_user_DllExport Union_Discriminator_unsigned_long& var_union_discriminator_ulong()
    {
        return m_var_union_discriminator_ulong;
    }



private:

    Union_Discriminator_unsigned_long m_var_union_discriminator_ulong;

};
/*!
 * @brief This class represents the structure UnionDiscriminatorLongLong defined by the user in the IDL file.
 * @ingroup unions
 */
class UnionDiscriminatorLongLong
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport UnionDiscriminatorLongLong()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~UnionDiscriminatorLongLong()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object UnionDiscriminatorLongLong that will be copied.
     */
    eProsima_user_DllExport UnionDiscriminatorLongLong(
            const UnionDiscriminatorLongLong& x)
    {
                    m_var_union_discriminator_long_long = x.m_var_union_discriminator_long_long;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object UnionDiscriminatorLongLong that will be copied.
     */
    eProsima_user_DllExport UnionDiscriminatorLongLong(
            UnionDiscriminatorLongLong&& x) noexcept
    {
        m_var_union_discriminator_long_long = std::move(x.m_var_union_discriminator_long_long);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object UnionDiscriminatorLongLong that will be copied.
     */
    eProsima_user_DllExport UnionDiscriminatorLongLong& operator =(
            const UnionDiscriminatorLongLong& x)
    {

                    m_var_union_discriminator_long_long = x.m_var_union_discriminator_long_long;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object UnionDiscriminatorLongLong that will be copied.
     */
    eProsima_user_DllExport UnionDiscriminatorLongLong& operator =(
            UnionDiscriminatorLongLong&& x) noexcept
    {

        m_var_union_discriminator_long_long = std::move(x.m_var_union_discriminator_long_long);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x UnionDiscriminatorLongLong object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const UnionDiscriminatorLongLong& x) const
    {
        return (m_var_union_discriminator_long_long == x.m_var_union_discriminator_long_long);
    }

    /*!
     * @brief Comparison operator.
     * @param x UnionDiscriminatorLongLong object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const UnionDiscriminatorLongLong& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_union_discriminator_long_long
     * @param _var_union_discriminator_long_long New value to be copied in member var_union_discriminator_long_long
     */
    eProsima_user_DllExport void var_union_discriminator_long_long(
            const Union_Discriminator_long_long& _var_union_discriminator_long_long)
    {
        m_var_union_discriminator_long_long = _var_union_discriminator_long_long;
    }

    /*!
     * @brief This function moves the value in member var_union_discriminator_long_long
     * @param _var_union_discriminator_long_long New value to be moved in member var_union_discriminator_long_long
     */
    eProsima_user_DllExport void var_union_discriminator_long_long(
            Union_Discriminator_long_long&& _var_union_discriminator_long_long)
    {
        m_var_union_discriminator_long_long = std::move(_var_union_discriminator_long_long);
    }

    /*!
     * @brief This function returns a constant reference to member var_union_discriminator_long_long
     * @return Constant reference to member var_union_discriminator_long_long
     */
    eProsima_user_DllExport const Union_Discriminator_long_long& var_union_discriminator_long_long() const
    {
        return m_var_union_discriminator_long_long;
    }

    /*!
     * @brief This function returns a reference to member var_union_discriminator_long_long
     * @return Reference to member var_union_discriminator_long_long
     */
    eProsima_user_DllExport Union_Discriminator_long_long& var_union_discriminator_long_long()
    {
        return m_var_union_discriminator_long_long;
    }



private:

    Union_Discriminator_long_long m_var_union_discriminator_long_long;

};
/*!
 * @brief This class represents the structure UnionDiscriminatorULongLong defined by the user in the IDL file.
 * @ingroup unions
 */
class UnionDiscriminatorULongLong
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport UnionDiscriminatorULongLong()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~UnionDiscriminatorULongLong()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object UnionDiscriminatorULongLong that will be copied.
     */
    eProsima_user_DllExport UnionDiscriminatorULongLong(
            const UnionDiscriminatorULongLong& x)
    {
                    m_var_union_discriminator_ulong_long = x.m_var_union_discriminator_ulong_long;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object UnionDiscriminatorULongLong that will be copied.
     */
    eProsima_user_DllExport UnionDiscriminatorULongLong(
            UnionDiscriminatorULongLong&& x) noexcept
    {
        m_var_union_discriminator_ulong_long = std::move(x.m_var_union_discriminator_ulong_long);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object UnionDiscriminatorULongLong that will be copied.
     */
    eProsima_user_DllExport UnionDiscriminatorULongLong& operator =(
            const UnionDiscriminatorULongLong& x)
    {

                    m_var_union_discriminator_ulong_long = x.m_var_union_discriminator_ulong_long;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object UnionDiscriminatorULongLong that will be copied.
     */
    eProsima_user_DllExport UnionDiscriminatorULongLong& operator =(
            UnionDiscriminatorULongLong&& x) noexcept
    {

        m_var_union_discriminator_ulong_long = std::move(x.m_var_union_discriminator_ulong_long);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x UnionDiscriminatorULongLong object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const UnionDiscriminatorULongLong& x) const
    {
        return (m_var_union_discriminator_ulong_long == x.m_var_union_discriminator_ulong_long);
    }

    /*!
     * @brief Comparison operator.
     * @param x UnionDiscriminatorULongLong object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const UnionDiscriminatorULongLong& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_union_discriminator_ulong_long
     * @param _var_union_discriminator_ulong_long New value to be copied in member var_union_discriminator_ulong_long
     */
    eProsima_user_DllExport void var_union_discriminator_ulong_long(
            const Union_Discriminator_unsigned_long_long& _var_union_discriminator_ulong_long)
    {
        m_var_union_discriminator_ulong_long = _var_union_discriminator_ulong_long;
    }

    /*!
     * @brief This function moves the value in member var_union_discriminator_ulong_long
     * @param _var_union_discriminator_ulong_long New value to be moved in member var_union_discriminator_ulong_long
     */
    eProsima_user_DllExport void var_union_discriminator_ulong_long(
            Union_Discriminator_unsigned_long_long&& _var_union_discriminator_ulong_long)
    {
        m_var_union_discriminator_ulong_long = std::move(_var_union_discriminator_ulong_long);
    }

    /*!
     * @brief This function returns a constant reference to member var_union_discriminator_ulong_long
     * @return Constant reference to member var_union_discriminator_ulong_long
     */
    eProsima_user_DllExport const Union_Discriminator_unsigned_long_long& var_union_discriminator_ulong_long() const
    {
        return m_var_union_discriminator_ulong_long;
    }

    /*!
     * @brief This function returns a reference to member var_union_discriminator_ulong_long
     * @return Reference to member var_union_discriminator_ulong_long
     */
    eProsima_user_DllExport Union_Discriminator_unsigned_long_long& var_union_discriminator_ulong_long()
    {
        return m_var_union_discriminator_ulong_long;
    }



private:

    Union_Discriminator_unsigned_long_long m_var_union_discriminator_ulong_long;

};
/*!
 * @brief This class represents the structure UnionDiscriminatorBoolean defined by the user in the IDL file.
 * @ingroup unions
 */
class UnionDiscriminatorBoolean
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport UnionDiscriminatorBoolean()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~UnionDiscriminatorBoolean()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object UnionDiscriminatorBoolean that will be copied.
     */
    eProsima_user_DllExport UnionDiscriminatorBoolean(
            const UnionDiscriminatorBoolean& x)
    {
                    m_var_union_discriminator_boolean = x.m_var_union_discriminator_boolean;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object UnionDiscriminatorBoolean that will be copied.
     */
    eProsima_user_DllExport UnionDiscriminatorBoolean(
            UnionDiscriminatorBoolean&& x) noexcept
    {
        m_var_union_discriminator_boolean = std::move(x.m_var_union_discriminator_boolean);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object UnionDiscriminatorBoolean that will be copied.
     */
    eProsima_user_DllExport UnionDiscriminatorBoolean& operator =(
            const UnionDiscriminatorBoolean& x)
    {

                    m_var_union_discriminator_boolean = x.m_var_union_discriminator_boolean;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object UnionDiscriminatorBoolean that will be copied.
     */
    eProsima_user_DllExport UnionDiscriminatorBoolean& operator =(
            UnionDiscriminatorBoolean&& x) noexcept
    {

        m_var_union_discriminator_boolean = std::move(x.m_var_union_discriminator_boolean);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x UnionDiscriminatorBoolean object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const UnionDiscriminatorBoolean& x) const
    {
        return (m_var_union_discriminator_boolean == x.m_var_union_discriminator_boolean);
    }

    /*!
     * @brief Comparison operator.
     * @param x UnionDiscriminatorBoolean object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const UnionDiscriminatorBoolean& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_union_discriminator_boolean
     * @param _var_union_discriminator_boolean New value to be copied in member var_union_discriminator_boolean
     */
    eProsima_user_DllExport void var_union_discriminator_boolean(
            const Union_Discriminator_boolean& _var_union_discriminator_boolean)
    {
        m_var_union_discriminator_boolean = _var_union_discriminator_boolean;
    }

    /*!
     * @brief This function moves the value in member var_union_discriminator_boolean
     * @param _var_union_discriminator_boolean New value to be moved in member var_union_discriminator_boolean
     */
    eProsima_user_DllExport void var_union_discriminator_boolean(
            Union_Discriminator_boolean&& _var_union_discriminator_boolean)
    {
        m_var_union_discriminator_boolean = std::move(_var_union_discriminator_boolean);
    }

    /*!
     * @brief This function returns a constant reference to member var_union_discriminator_boolean
     * @return Constant reference to member var_union_discriminator_boolean
     */
    eProsima_user_DllExport const Union_Discriminator_boolean& var_union_discriminator_boolean() const
    {
        return m_var_union_discriminator_boolean;
    }

    /*!
     * @brief This function returns a reference to member var_union_discriminator_boolean
     * @return Reference to member var_union_discriminator_boolean
     */
    eProsima_user_DllExport Union_Discriminator_boolean& var_union_discriminator_boolean()
    {
        return m_var_union_discriminator_boolean;
    }



private:

    Union_Discriminator_boolean m_var_union_discriminator_boolean;

};
/*!
 * @brief This class represents the structure UnionDiscriminatorOctet defined by the user in the IDL file.
 * @ingroup unions
 */
class UnionDiscriminatorOctet
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport UnionDiscriminatorOctet()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~UnionDiscriminatorOctet()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object UnionDiscriminatorOctet that will be copied.
     */
    eProsima_user_DllExport UnionDiscriminatorOctet(
            const UnionDiscriminatorOctet& x)
    {
                    m_var_union_discriminator_octet = x.m_var_union_discriminator_octet;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object UnionDiscriminatorOctet that will be copied.
     */
    eProsima_user_DllExport UnionDiscriminatorOctet(
            UnionDiscriminatorOctet&& x) noexcept
    {
        m_var_union_discriminator_octet = std::move(x.m_var_union_discriminator_octet);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object UnionDiscriminatorOctet that will be copied.
     */
    eProsima_user_DllExport UnionDiscriminatorOctet& operator =(
            const UnionDiscriminatorOctet& x)
    {

                    m_var_union_discriminator_octet = x.m_var_union_discriminator_octet;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object UnionDiscriminatorOctet that will be copied.
     */
    eProsima_user_DllExport UnionDiscriminatorOctet& operator =(
            UnionDiscriminatorOctet&& x) noexcept
    {

        m_var_union_discriminator_octet = std::move(x.m_var_union_discriminator_octet);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x UnionDiscriminatorOctet object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const UnionDiscriminatorOctet& x) const
    {
        return (m_var_union_discriminator_octet == x.m_var_union_discriminator_octet);
    }

    /*!
     * @brief Comparison operator.
     * @param x UnionDiscriminatorOctet object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const UnionDiscriminatorOctet& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_union_discriminator_octet
     * @param _var_union_discriminator_octet New value to be copied in member var_union_discriminator_octet
     */
    eProsima_user_DllExport void var_union_discriminator_octet(
            const Union_Discriminator_octet& _var_union_discriminator_octet)
    {
        m_var_union_discriminator_octet = _var_union_discriminator_octet;
    }

    /*!
     * @brief This function moves the value in member var_union_discriminator_octet
     * @param _var_union_discriminator_octet New value to be moved in member var_union_discriminator_octet
     */
    eProsima_user_DllExport void var_union_discriminator_octet(
            Union_Discriminator_octet&& _var_union_discriminator_octet)
    {
        m_var_union_discriminator_octet = std::move(_var_union_discriminator_octet);
    }

    /*!
     * @brief This function returns a constant reference to member var_union_discriminator_octet
     * @return Constant reference to member var_union_discriminator_octet
     */
    eProsima_user_DllExport const Union_Discriminator_octet& var_union_discriminator_octet() const
    {
        return m_var_union_discriminator_octet;
    }

    /*!
     * @brief This function returns a reference to member var_union_discriminator_octet
     * @return Reference to member var_union_discriminator_octet
     */
    eProsima_user_DllExport Union_Discriminator_octet& var_union_discriminator_octet()
    {
        return m_var_union_discriminator_octet;
    }



private:

    Union_Discriminator_octet m_var_union_discriminator_octet;

};
/*!
 * @brief This class represents the structure UnionDiscriminatorChar defined by the user in the IDL file.
 * @ingroup unions
 */
class UnionDiscriminatorChar
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport UnionDiscriminatorChar()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~UnionDiscriminatorChar()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object UnionDiscriminatorChar that will be copied.
     */
    eProsima_user_DllExport UnionDiscriminatorChar(
            const UnionDiscriminatorChar& x)
    {
                    m_var_union_discriminator_char = x.m_var_union_discriminator_char;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object UnionDiscriminatorChar that will be copied.
     */
    eProsima_user_DllExport UnionDiscriminatorChar(
            UnionDiscriminatorChar&& x) noexcept
    {
        m_var_union_discriminator_char = std::move(x.m_var_union_discriminator_char);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object UnionDiscriminatorChar that will be copied.
     */
    eProsima_user_DllExport UnionDiscriminatorChar& operator =(
            const UnionDiscriminatorChar& x)
    {

                    m_var_union_discriminator_char = x.m_var_union_discriminator_char;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object UnionDiscriminatorChar that will be copied.
     */
    eProsima_user_DllExport UnionDiscriminatorChar& operator =(
            UnionDiscriminatorChar&& x) noexcept
    {

        m_var_union_discriminator_char = std::move(x.m_var_union_discriminator_char);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x UnionDiscriminatorChar object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const UnionDiscriminatorChar& x) const
    {
        return (m_var_union_discriminator_char == x.m_var_union_discriminator_char);
    }

    /*!
     * @brief Comparison operator.
     * @param x UnionDiscriminatorChar object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const UnionDiscriminatorChar& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_union_discriminator_char
     * @param _var_union_discriminator_char New value to be copied in member var_union_discriminator_char
     */
    eProsima_user_DllExport void var_union_discriminator_char(
            const Union_Discriminator_char& _var_union_discriminator_char)
    {
        m_var_union_discriminator_char = _var_union_discriminator_char;
    }

    /*!
     * @brief This function moves the value in member var_union_discriminator_char
     * @param _var_union_discriminator_char New value to be moved in member var_union_discriminator_char
     */
    eProsima_user_DllExport void var_union_discriminator_char(
            Union_Discriminator_char&& _var_union_discriminator_char)
    {
        m_var_union_discriminator_char = std::move(_var_union_discriminator_char);
    }

    /*!
     * @brief This function returns a constant reference to member var_union_discriminator_char
     * @return Constant reference to member var_union_discriminator_char
     */
    eProsima_user_DllExport const Union_Discriminator_char& var_union_discriminator_char() const
    {
        return m_var_union_discriminator_char;
    }

    /*!
     * @brief This function returns a reference to member var_union_discriminator_char
     * @return Reference to member var_union_discriminator_char
     */
    eProsima_user_DllExport Union_Discriminator_char& var_union_discriminator_char()
    {
        return m_var_union_discriminator_char;
    }



private:

    Union_Discriminator_char m_var_union_discriminator_char;

};
/*!
 * @brief This class represents the structure UnionDiscriminatorWChar defined by the user in the IDL file.
 * @ingroup unions
 */
class UnionDiscriminatorWChar
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport UnionDiscriminatorWChar()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~UnionDiscriminatorWChar()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object UnionDiscriminatorWChar that will be copied.
     */
    eProsima_user_DllExport UnionDiscriminatorWChar(
            const UnionDiscriminatorWChar& x)
    {
                    m_var_union_discriminator_wchar = x.m_var_union_discriminator_wchar;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object UnionDiscriminatorWChar that will be copied.
     */
    eProsima_user_DllExport UnionDiscriminatorWChar(
            UnionDiscriminatorWChar&& x) noexcept
    {
        m_var_union_discriminator_wchar = std::move(x.m_var_union_discriminator_wchar);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object UnionDiscriminatorWChar that will be copied.
     */
    eProsima_user_DllExport UnionDiscriminatorWChar& operator =(
            const UnionDiscriminatorWChar& x)
    {

                    m_var_union_discriminator_wchar = x.m_var_union_discriminator_wchar;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object UnionDiscriminatorWChar that will be copied.
     */
    eProsima_user_DllExport UnionDiscriminatorWChar& operator =(
            UnionDiscriminatorWChar&& x) noexcept
    {

        m_var_union_discriminator_wchar = std::move(x.m_var_union_discriminator_wchar);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x UnionDiscriminatorWChar object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const UnionDiscriminatorWChar& x) const
    {
        return (m_var_union_discriminator_wchar == x.m_var_union_discriminator_wchar);
    }

    /*!
     * @brief Comparison operator.
     * @param x UnionDiscriminatorWChar object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const UnionDiscriminatorWChar& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_union_discriminator_wchar
     * @param _var_union_discriminator_wchar New value to be copied in member var_union_discriminator_wchar
     */
    eProsima_user_DllExport void var_union_discriminator_wchar(
            const Union_Discriminator_wchar& _var_union_discriminator_wchar)
    {
        m_var_union_discriminator_wchar = _var_union_discriminator_wchar;
    }

    /*!
     * @brief This function moves the value in member var_union_discriminator_wchar
     * @param _var_union_discriminator_wchar New value to be moved in member var_union_discriminator_wchar
     */
    eProsima_user_DllExport void var_union_discriminator_wchar(
            Union_Discriminator_wchar&& _var_union_discriminator_wchar)
    {
        m_var_union_discriminator_wchar = std::move(_var_union_discriminator_wchar);
    }

    /*!
     * @brief This function returns a constant reference to member var_union_discriminator_wchar
     * @return Constant reference to member var_union_discriminator_wchar
     */
    eProsima_user_DllExport const Union_Discriminator_wchar& var_union_discriminator_wchar() const
    {
        return m_var_union_discriminator_wchar;
    }

    /*!
     * @brief This function returns a reference to member var_union_discriminator_wchar
     * @return Reference to member var_union_discriminator_wchar
     */
    eProsima_user_DllExport Union_Discriminator_wchar& var_union_discriminator_wchar()
    {
        return m_var_union_discriminator_wchar;
    }



private:

    Union_Discriminator_wchar m_var_union_discriminator_wchar;

};
/*!
 * @brief This class represents the structure UnionDiscriminatorEnum defined by the user in the IDL file.
 * @ingroup unions
 */
class UnionDiscriminatorEnum
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport UnionDiscriminatorEnum()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~UnionDiscriminatorEnum()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object UnionDiscriminatorEnum that will be copied.
     */
    eProsima_user_DllExport UnionDiscriminatorEnum(
            const UnionDiscriminatorEnum& x)
    {
                    m_var_union_discriminator_enum = x.m_var_union_discriminator_enum;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object UnionDiscriminatorEnum that will be copied.
     */
    eProsima_user_DllExport UnionDiscriminatorEnum(
            UnionDiscriminatorEnum&& x) noexcept
    {
        m_var_union_discriminator_enum = std::move(x.m_var_union_discriminator_enum);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object UnionDiscriminatorEnum that will be copied.
     */
    eProsima_user_DllExport UnionDiscriminatorEnum& operator =(
            const UnionDiscriminatorEnum& x)
    {

                    m_var_union_discriminator_enum = x.m_var_union_discriminator_enum;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object UnionDiscriminatorEnum that will be copied.
     */
    eProsima_user_DllExport UnionDiscriminatorEnum& operator =(
            UnionDiscriminatorEnum&& x) noexcept
    {

        m_var_union_discriminator_enum = std::move(x.m_var_union_discriminator_enum);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x UnionDiscriminatorEnum object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const UnionDiscriminatorEnum& x) const
    {
        return (m_var_union_discriminator_enum == x.m_var_union_discriminator_enum);
    }

    /*!
     * @brief Comparison operator.
     * @param x UnionDiscriminatorEnum object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const UnionDiscriminatorEnum& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_union_discriminator_enum
     * @param _var_union_discriminator_enum New value to be copied in member var_union_discriminator_enum
     */
    eProsima_user_DllExport void var_union_discriminator_enum(
            const Union_Discriminator_enum& _var_union_discriminator_enum)
    {
        m_var_union_discriminator_enum = _var_union_discriminator_enum;
    }

    /*!
     * @brief This function moves the value in member var_union_discriminator_enum
     * @param _var_union_discriminator_enum New value to be moved in member var_union_discriminator_enum
     */
    eProsima_user_DllExport void var_union_discriminator_enum(
            Union_Discriminator_enum&& _var_union_discriminator_enum)
    {
        m_var_union_discriminator_enum = std::move(_var_union_discriminator_enum);
    }

    /*!
     * @brief This function returns a constant reference to member var_union_discriminator_enum
     * @return Constant reference to member var_union_discriminator_enum
     */
    eProsima_user_DllExport const Union_Discriminator_enum& var_union_discriminator_enum() const
    {
        return m_var_union_discriminator_enum;
    }

    /*!
     * @brief This function returns a reference to member var_union_discriminator_enum
     * @return Reference to member var_union_discriminator_enum
     */
    eProsima_user_DllExport Union_Discriminator_enum& var_union_discriminator_enum()
    {
        return m_var_union_discriminator_enum;
    }



private:

    Union_Discriminator_enum m_var_union_discriminator_enum;

};
/*!
 * @brief This class represents the structure UnionDiscriminatorEnumLabel defined by the user in the IDL file.
 * @ingroup unions
 */
class UnionDiscriminatorEnumLabel
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport UnionDiscriminatorEnumLabel()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~UnionDiscriminatorEnumLabel()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object UnionDiscriminatorEnumLabel that will be copied.
     */
    eProsima_user_DllExport UnionDiscriminatorEnumLabel(
            const UnionDiscriminatorEnumLabel& x)
    {
                    m_var_union_discriminator_enum = x.m_var_union_discriminator_enum;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object UnionDiscriminatorEnumLabel that will be copied.
     */
    eProsima_user_DllExport UnionDiscriminatorEnumLabel(
            UnionDiscriminatorEnumLabel&& x) noexcept
    {
        m_var_union_discriminator_enum = std::move(x.m_var_union_discriminator_enum);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object UnionDiscriminatorEnumLabel that will be copied.
     */
    eProsima_user_DllExport UnionDiscriminatorEnumLabel& operator =(
            const UnionDiscriminatorEnumLabel& x)
    {

                    m_var_union_discriminator_enum = x.m_var_union_discriminator_enum;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object UnionDiscriminatorEnumLabel that will be copied.
     */
    eProsima_user_DllExport UnionDiscriminatorEnumLabel& operator =(
            UnionDiscriminatorEnumLabel&& x) noexcept
    {

        m_var_union_discriminator_enum = std::move(x.m_var_union_discriminator_enum);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x UnionDiscriminatorEnumLabel object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const UnionDiscriminatorEnumLabel& x) const
    {
        return (m_var_union_discriminator_enum == x.m_var_union_discriminator_enum);
    }

    /*!
     * @brief Comparison operator.
     * @param x UnionDiscriminatorEnumLabel object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const UnionDiscriminatorEnumLabel& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_union_discriminator_enum
     * @param _var_union_discriminator_enum New value to be copied in member var_union_discriminator_enum
     */
    eProsima_user_DllExport void var_union_discriminator_enum(
            const Union_Discriminator_enum_labels& _var_union_discriminator_enum)
    {
        m_var_union_discriminator_enum = _var_union_discriminator_enum;
    }

    /*!
     * @brief This function moves the value in member var_union_discriminator_enum
     * @param _var_union_discriminator_enum New value to be moved in member var_union_discriminator_enum
     */
    eProsima_user_DllExport void var_union_discriminator_enum(
            Union_Discriminator_enum_labels&& _var_union_discriminator_enum)
    {
        m_var_union_discriminator_enum = std::move(_var_union_discriminator_enum);
    }

    /*!
     * @brief This function returns a constant reference to member var_union_discriminator_enum
     * @return Constant reference to member var_union_discriminator_enum
     */
    eProsima_user_DllExport const Union_Discriminator_enum_labels& var_union_discriminator_enum() const
    {
        return m_var_union_discriminator_enum;
    }

    /*!
     * @brief This function returns a reference to member var_union_discriminator_enum
     * @return Reference to member var_union_discriminator_enum
     */
    eProsima_user_DllExport Union_Discriminator_enum_labels& var_union_discriminator_enum()
    {
        return m_var_union_discriminator_enum;
    }



private:

    Union_Discriminator_enum_labels m_var_union_discriminator_enum;

};
/*!
 * @brief This class represents the structure UnionDiscriminatorAlias defined by the user in the IDL file.
 * @ingroup unions
 */
class UnionDiscriminatorAlias
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport UnionDiscriminatorAlias()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~UnionDiscriminatorAlias()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object UnionDiscriminatorAlias that will be copied.
     */
    eProsima_user_DllExport UnionDiscriminatorAlias(
            const UnionDiscriminatorAlias& x)
    {
                    m_var_union_discriminator_alias = x.m_var_union_discriminator_alias;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object UnionDiscriminatorAlias that will be copied.
     */
    eProsima_user_DllExport UnionDiscriminatorAlias(
            UnionDiscriminatorAlias&& x) noexcept
    {
        m_var_union_discriminator_alias = std::move(x.m_var_union_discriminator_alias);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object UnionDiscriminatorAlias that will be copied.
     */
    eProsima_user_DllExport UnionDiscriminatorAlias& operator =(
            const UnionDiscriminatorAlias& x)
    {

                    m_var_union_discriminator_alias = x.m_var_union_discriminator_alias;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object UnionDiscriminatorAlias that will be copied.
     */
    eProsima_user_DllExport UnionDiscriminatorAlias& operator =(
            UnionDiscriminatorAlias&& x) noexcept
    {

        m_var_union_discriminator_alias = std::move(x.m_var_union_discriminator_alias);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x UnionDiscriminatorAlias object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const UnionDiscriminatorAlias& x) const
    {
        return (m_var_union_discriminator_alias == x.m_var_union_discriminator_alias);
    }

    /*!
     * @brief Comparison operator.
     * @param x UnionDiscriminatorAlias object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const UnionDiscriminatorAlias& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_union_discriminator_alias
     * @param _var_union_discriminator_alias New value to be copied in member var_union_discriminator_alias
     */
    eProsima_user_DllExport void var_union_discriminator_alias(
            const Union_Discriminator_alias& _var_union_discriminator_alias)
    {
        m_var_union_discriminator_alias = _var_union_discriminator_alias;
    }

    /*!
     * @brief This function moves the value in member var_union_discriminator_alias
     * @param _var_union_discriminator_alias New value to be moved in member var_union_discriminator_alias
     */
    eProsima_user_DllExport void var_union_discriminator_alias(
            Union_Discriminator_alias&& _var_union_discriminator_alias)
    {
        m_var_union_discriminator_alias = std::move(_var_union_discriminator_alias);
    }

    /*!
     * @brief This function returns a constant reference to member var_union_discriminator_alias
     * @return Constant reference to member var_union_discriminator_alias
     */
    eProsima_user_DllExport const Union_Discriminator_alias& var_union_discriminator_alias() const
    {
        return m_var_union_discriminator_alias;
    }

    /*!
     * @brief This function returns a reference to member var_union_discriminator_alias
     * @return Reference to member var_union_discriminator_alias
     */
    eProsima_user_DllExport Union_Discriminator_alias& var_union_discriminator_alias()
    {
        return m_var_union_discriminator_alias;
    }



private:

    Union_Discriminator_alias m_var_union_discriminator_alias;

};
/*!
 * @brief This class represents the structure UnionSeveralFields defined by the user in the IDL file.
 * @ingroup unions
 */
class UnionSeveralFields
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport UnionSeveralFields()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~UnionSeveralFields()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object UnionSeveralFields that will be copied.
     */
    eProsima_user_DllExport UnionSeveralFields(
            const UnionSeveralFields& x)
    {
                    m_var_union_several_fields = x.m_var_union_several_fields;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object UnionSeveralFields that will be copied.
     */
    eProsima_user_DllExport UnionSeveralFields(
            UnionSeveralFields&& x) noexcept
    {
        m_var_union_several_fields = std::move(x.m_var_union_several_fields);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object UnionSeveralFields that will be copied.
     */
    eProsima_user_DllExport UnionSeveralFields& operator =(
            const UnionSeveralFields& x)
    {

                    m_var_union_several_fields = x.m_var_union_several_fields;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object UnionSeveralFields that will be copied.
     */
    eProsima_user_DllExport UnionSeveralFields& operator =(
            UnionSeveralFields&& x) noexcept
    {

        m_var_union_several_fields = std::move(x.m_var_union_several_fields);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x UnionSeveralFields object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const UnionSeveralFields& x) const
    {
        return (m_var_union_several_fields == x.m_var_union_several_fields);
    }

    /*!
     * @brief Comparison operator.
     * @param x UnionSeveralFields object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const UnionSeveralFields& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_union_several_fields
     * @param _var_union_several_fields New value to be copied in member var_union_several_fields
     */
    eProsima_user_DllExport void var_union_several_fields(
            const Union_Several_Fields& _var_union_several_fields)
    {
        m_var_union_several_fields = _var_union_several_fields;
    }

    /*!
     * @brief This function moves the value in member var_union_several_fields
     * @param _var_union_several_fields New value to be moved in member var_union_several_fields
     */
    eProsima_user_DllExport void var_union_several_fields(
            Union_Several_Fields&& _var_union_several_fields)
    {
        m_var_union_several_fields = std::move(_var_union_several_fields);
    }

    /*!
     * @brief This function returns a constant reference to member var_union_several_fields
     * @return Constant reference to member var_union_several_fields
     */
    eProsima_user_DllExport const Union_Several_Fields& var_union_several_fields() const
    {
        return m_var_union_several_fields;
    }

    /*!
     * @brief This function returns a reference to member var_union_several_fields
     * @return Reference to member var_union_several_fields
     */
    eProsima_user_DllExport Union_Several_Fields& var_union_several_fields()
    {
        return m_var_union_several_fields;
    }



private:

    Union_Several_Fields m_var_union_several_fields;

};
/*!
 * @brief This class represents the structure UnionSeveralFieldsWithDefault defined by the user in the IDL file.
 * @ingroup unions
 */
class UnionSeveralFieldsWithDefault
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport UnionSeveralFieldsWithDefault()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~UnionSeveralFieldsWithDefault()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object UnionSeveralFieldsWithDefault that will be copied.
     */
    eProsima_user_DllExport UnionSeveralFieldsWithDefault(
            const UnionSeveralFieldsWithDefault& x)
    {
                    m_var_union_several_fields_with_default = x.m_var_union_several_fields_with_default;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object UnionSeveralFieldsWithDefault that will be copied.
     */
    eProsima_user_DllExport UnionSeveralFieldsWithDefault(
            UnionSeveralFieldsWithDefault&& x) noexcept
    {
        m_var_union_several_fields_with_default = std::move(x.m_var_union_several_fields_with_default);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object UnionSeveralFieldsWithDefault that will be copied.
     */
    eProsima_user_DllExport UnionSeveralFieldsWithDefault& operator =(
            const UnionSeveralFieldsWithDefault& x)
    {

                    m_var_union_several_fields_with_default = x.m_var_union_several_fields_with_default;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object UnionSeveralFieldsWithDefault that will be copied.
     */
    eProsima_user_DllExport UnionSeveralFieldsWithDefault& operator =(
            UnionSeveralFieldsWithDefault&& x) noexcept
    {

        m_var_union_several_fields_with_default = std::move(x.m_var_union_several_fields_with_default);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x UnionSeveralFieldsWithDefault object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const UnionSeveralFieldsWithDefault& x) const
    {
        return (m_var_union_several_fields_with_default == x.m_var_union_several_fields_with_default);
    }

    /*!
     * @brief Comparison operator.
     * @param x UnionSeveralFieldsWithDefault object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const UnionSeveralFieldsWithDefault& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_union_several_fields_with_default
     * @param _var_union_several_fields_with_default New value to be copied in member var_union_several_fields_with_default
     */
    eProsima_user_DllExport void var_union_several_fields_with_default(
            const Union_Several_Fields_With_Default& _var_union_several_fields_with_default)
    {
        m_var_union_several_fields_with_default = _var_union_several_fields_with_default;
    }

    /*!
     * @brief This function moves the value in member var_union_several_fields_with_default
     * @param _var_union_several_fields_with_default New value to be moved in member var_union_several_fields_with_default
     */
    eProsima_user_DllExport void var_union_several_fields_with_default(
            Union_Several_Fields_With_Default&& _var_union_several_fields_with_default)
    {
        m_var_union_several_fields_with_default = std::move(_var_union_several_fields_with_default);
    }

    /*!
     * @brief This function returns a constant reference to member var_union_several_fields_with_default
     * @return Constant reference to member var_union_several_fields_with_default
     */
    eProsima_user_DllExport const Union_Several_Fields_With_Default& var_union_several_fields_with_default() const
    {
        return m_var_union_several_fields_with_default;
    }

    /*!
     * @brief This function returns a reference to member var_union_several_fields_with_default
     * @return Reference to member var_union_several_fields_with_default
     */
    eProsima_user_DllExport Union_Several_Fields_With_Default& var_union_several_fields_with_default()
    {
        return m_var_union_several_fields_with_default;
    }



private:

    Union_Several_Fields_With_Default m_var_union_several_fields_with_default;

};
/*!
 * @brief This class represents the union DefaultAnnotation defined by the user in the IDL file.
 * @ingroup unions
 */
class DefaultAnnotation
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport DefaultAnnotation()
    {
        selected_member_ = 0x00000001;
        member_destructor_ = nullptr;
        m_a = {0};

    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~DefaultAnnotation()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object DefaultAnnotation that will be copied.
     */
    eProsima_user_DllExport DefaultAnnotation(
            const DefaultAnnotation& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            a_() = x.m_a;
                            break;

                        case 0x00000002:
                            b_() = x.m_b;
                            break;

                        case 0x00000003:
                            c_() = x.m_c;
                            break;

        }
    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object DefaultAnnotation that will be copied.
     */
    eProsima_user_DllExport DefaultAnnotation(
            DefaultAnnotation&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            a_() = std::move(x.m_a);
                            break;

                        case 0x00000002:
                            b_() = std::move(x.m_b);
                            break;

                        case 0x00000003:
                            c_() = std::move(x.m_c);
                            break;

        }
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object DefaultAnnotation that will be copied.
     */
    eProsima_user_DllExport DefaultAnnotation& operator =(
            const DefaultAnnotation& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            a_() = x.m_a;
                            break;

                        case 0x00000002:
                            b_() = x.m_b;
                            break;

                        case 0x00000003:
                            c_() = x.m_c;
                            break;

        }

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object DefaultAnnotation that will be copied.
     */
    eProsima_user_DllExport DefaultAnnotation& operator =(
            DefaultAnnotation&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            a_() = std::move(x.m_a);
                            break;

                        case 0x00000002:
                            b_() = std::move(x.m_b);
                            break;

                        case 0x00000003:
                            c_() = std::move(x.m_c);
                            break;

        }

        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x DefaultAnnotation object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const DefaultAnnotation& x) const
    {
        bool ret_value {false};

        if (x.selected_member_ == selected_member_)
        {
            if (0x0FFFFFFFu != selected_member_)
            {
                if (x.m__d == m__d)
                {
                    switch (selected_member_)
                    {
                                                    case 0x00000001:
                                                        ret_value = (x.m_a == m_a);
                                                        break;

                                                    case 0x00000002:
                                                        ret_value = (x.m_b == m_b);
                                                        break;

                                                    case 0x00000003:
                                                        ret_value = (x.m_c == m_c);
                                                        break;

                    }
                }
            }
            else
            {
                ret_value = true;
            }
        }

        return ret_value;
    }

    /*!
     * @brief Comparison operator.
     * @param x DefaultAnnotation object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const DefaultAnnotation& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets the discriminator value.
     * @param __d New value for the discriminator.
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the new value doesn't correspond to the selected union member.
     */
    eProsima_user_DllExport void _d(
            int32_t __d)
    {
        bool valid_discriminator = false;

        switch (__d)
        {
                        case 0:
                            if (0x00000001 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case 1:
                            if (0x00000002 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        default:
                            if (0x00000003 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

        }

        if (!valid_discriminator)
        {
            throw eprosima::fastcdr::exception::BadParamException("Discriminator doesn't correspond with the selected union member");
        }

        m__d = __d;
    }

    /*!
     * @brief This function returns the value of the discriminator.
     * @return Value of the discriminator
     */
    eProsima_user_DllExport int32_t _d() const
    {
        return m__d;
    }

    /*!
     * @brief This function sets a value in member a
     * @param _a New value for member a
     */
    eProsima_user_DllExport void a(
            uint8_t _a)
    {
        a_() = _a;
        m__d = 0;
    }

    /*!
     * @brief This function returns the value of member a
     * @return Value of member a
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport uint8_t a() const
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_a;
    }

    /*!
     * @brief This function returns a reference to member a
     * @return Reference to member a
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport uint8_t& a()
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_a;
    }


    /*!
     * @brief This function sets a value in member b
     * @param _b New value for member b
     */
    eProsima_user_DllExport void b(
            int16_t _b)
    {
        b_() = _b;
        m__d = 1;
    }

    /*!
     * @brief This function returns the value of member b
     * @return Value of member b
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int16_t b() const
    {
        if (0x00000002 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_b;
    }

    /*!
     * @brief This function returns a reference to member b
     * @return Reference to member b
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int16_t& b()
    {
        if (0x00000002 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_b;
    }


    /*!
     * @brief This function sets a value in member c
     * @param _c New value for member c
     */
    eProsima_user_DllExport void c(
            int32_t _c)
    {
        c_() = _c;
        m__d = 2147483647;
    }

    /*!
     * @brief This function returns the value of member c
     * @return Value of member c
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int32_t c() const
    {
        if (0x00000003 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_c;
    }

    /*!
     * @brief This function returns a reference to member c
     * @return Reference to member c
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int32_t& c()
    {
        if (0x00000003 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_c;
    }



private:

            uint8_t& a_()
            {
                if (0x00000001 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000001;
                    member_destructor_ = nullptr;
                    m_a = {0};

                }

                return m_a;
            }

            int16_t& b_()
            {
                if (0x00000002 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000002;
                    member_destructor_ = nullptr;
                    m_b = {0};

                }

                return m_b;
            }

            int32_t& c_()
            {
                if (0x00000003 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000003;
                    member_destructor_ = nullptr;
                    m_c = {0};

                }

                return m_c;
            }


    int32_t m__d {0};

    union
    {
        uint8_t m_a;
        int16_t m_b;
        int32_t m_c;
    };

    uint32_t selected_member_ {0x0FFFFFFFu};

    std::function<void()> member_destructor_;
};
/*!
 * @brief This class represents the union DefaultAnnotationExternalValue defined by the user in the IDL file.
 * @ingroup unions
 */
class DefaultAnnotationExternalValue
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport DefaultAnnotationExternalValue()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~DefaultAnnotationExternalValue()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object DefaultAnnotationExternalValue that will be copied.
     */
    eProsima_user_DllExport DefaultAnnotationExternalValue(
            const DefaultAnnotationExternalValue& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            a_() = x.m_a;
                            break;

                        case 0x00000002:
                            b_() = x.m_b;
                            break;

        }
    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object DefaultAnnotationExternalValue that will be copied.
     */
    eProsima_user_DllExport DefaultAnnotationExternalValue(
            DefaultAnnotationExternalValue&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            a_() = std::move(x.m_a);
                            break;

                        case 0x00000002:
                            b_() = std::move(x.m_b);
                            break;

        }
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object DefaultAnnotationExternalValue that will be copied.
     */
    eProsima_user_DllExport DefaultAnnotationExternalValue& operator =(
            const DefaultAnnotationExternalValue& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            a_() = x.m_a;
                            break;

                        case 0x00000002:
                            b_() = x.m_b;
                            break;

        }

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object DefaultAnnotationExternalValue that will be copied.
     */
    eProsima_user_DllExport DefaultAnnotationExternalValue& operator =(
            DefaultAnnotationExternalValue&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            a_() = std::move(x.m_a);
                            break;

                        case 0x00000002:
                            b_() = std::move(x.m_b);
                            break;

        }

        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x DefaultAnnotationExternalValue object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const DefaultAnnotationExternalValue& x) const
    {
        bool ret_value {false};

        if (x.selected_member_ == selected_member_)
        {
            if (0x0FFFFFFFu != selected_member_)
            {
                if (x.m__d == m__d)
                {
                    switch (selected_member_)
                    {
                                                    case 0x00000001:
                                                        ret_value = (x.m_a == m_a);
                                                        break;

                                                    case 0x00000002:
                                                        ret_value = (x.m_b == m_b);
                                                        break;

                    }
                }
            }
            else
            {
                ret_value = true;
            }
        }

        return ret_value;
    }

    /*!
     * @brief Comparison operator.
     * @param x DefaultAnnotationExternalValue object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const DefaultAnnotationExternalValue& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets the discriminator value.
     * @param __d New value for the discriminator.
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the new value doesn't correspond to the selected union member.
     */
    eProsima_user_DllExport void _d(
            int32_t __d)
    {
        bool valid_discriminator = false;

        switch (__d)
        {
                        case 0:
                            if (0x00000001 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case 1:
                            if (0x00000002 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

        }

        if (!valid_discriminator)
        {
            throw eprosima::fastcdr::exception::BadParamException("Discriminator doesn't correspond with the selected union member");
        }

        m__d = __d;
    }

    /*!
     * @brief This function returns the value of the discriminator.
     * @return Value of the discriminator
     */
    eProsima_user_DllExport int32_t _d() const
    {
        return m__d;
    }

    /*!
     * @brief This function sets a value in member a
     * @param _a New value for member a
     */
    eProsima_user_DllExport void a(
            uint8_t _a)
    {
        a_() = _a;
        m__d = 0;
    }

    /*!
     * @brief This function returns the value of member a
     * @return Value of member a
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport uint8_t a() const
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_a;
    }

    /*!
     * @brief This function returns a reference to member a
     * @return Reference to member a
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport uint8_t& a()
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_a;
    }


    /*!
     * @brief This function sets a value in member b
     * @param _b New value for member b
     */
    eProsima_user_DllExport void b(
            int16_t _b)
    {
        b_() = _b;
        m__d = 1;
    }

    /*!
     * @brief This function returns the value of member b
     * @return Value of member b
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int16_t b() const
    {
        if (0x00000002 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_b;
    }

    /*!
     * @brief This function returns a reference to member b
     * @return Reference to member b
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int16_t& b()
    {
        if (0x00000002 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_b;
    }


    void _default()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }

        selected_member_ = 0x0FFFFFFFu;
    }


private:

            uint8_t& a_()
            {
                if (0x00000001 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000001;
                    member_destructor_ = nullptr;
                    m_a = {0};

                }

                return m_a;
            }

            int16_t& b_()
            {
                if (0x00000002 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000002;
                    member_destructor_ = nullptr;
                    m_b = {0};

                }

                return m_b;
            }


    int32_t m__d {2};

    union
    {
        uint8_t m_a;
        int16_t m_b;
    };

    uint32_t selected_member_ {0x0FFFFFFFu};

    std::function<void()> member_destructor_;
};
/*!
 * @brief This class represents the structure UnionShortExtraMember defined by the user in the IDL file.
 * @ingroup unions
 */
class UnionShortExtraMember
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport UnionShortExtraMember()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~UnionShortExtraMember()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object UnionShortExtraMember that will be copied.
     */
    eProsima_user_DllExport UnionShortExtraMember(
            const UnionShortExtraMember& x)
    {
                    m_var_union_short = x.m_var_union_short;

                    m_var_long = x.m_var_long;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object UnionShortExtraMember that will be copied.
     */
    eProsima_user_DllExport UnionShortExtraMember(
            UnionShortExtraMember&& x) noexcept
    {
        m_var_union_short = std::move(x.m_var_union_short);
        m_var_long = x.m_var_long;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object UnionShortExtraMember that will be copied.
     */
    eProsima_user_DllExport UnionShortExtraMember& operator =(
            const UnionShortExtraMember& x)
    {

                    m_var_union_short = x.m_var_union_short;

                    m_var_long = x.m_var_long;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object UnionShortExtraMember that will be copied.
     */
    eProsima_user_DllExport UnionShortExtraMember& operator =(
            UnionShortExtraMember&& x) noexcept
    {

        m_var_union_short = std::move(x.m_var_union_short);
        m_var_long = x.m_var_long;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x UnionShortExtraMember object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const UnionShortExtraMember& x) const
    {
        return (m_var_union_short == x.m_var_union_short &&
           m_var_long == x.m_var_long);
    }

    /*!
     * @brief Comparison operator.
     * @param x UnionShortExtraMember object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const UnionShortExtraMember& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_union_short
     * @param _var_union_short New value to be copied in member var_union_short
     */
    eProsima_user_DllExport void var_union_short(
            const Union_Short& _var_union_short)
    {
        m_var_union_short = _var_union_short;
    }

    /*!
     * @brief This function moves the value in member var_union_short
     * @param _var_union_short New value to be moved in member var_union_short
     */
    eProsima_user_DllExport void var_union_short(
            Union_Short&& _var_union_short)
    {
        m_var_union_short = std::move(_var_union_short);
    }

    /*!
     * @brief This function returns a constant reference to member var_union_short
     * @return Constant reference to member var_union_short
     */
    eProsima_user_DllExport const Union_Short& var_union_short() const
    {
        return m_var_union_short;
    }

    /*!
     * @brief This function returns a reference to member var_union_short
     * @return Reference to member var_union_short
     */
    eProsima_user_DllExport Union_Short& var_union_short()
    {
        return m_var_union_short;
    }


    /*!
     * @brief This function sets a value in member var_long
     * @param _var_long New value for member var_long
     */
    eProsima_user_DllExport void var_long(
            int32_t _var_long)
    {
        m_var_long = _var_long;
    }

    /*!
     * @brief This function returns the value of member var_long
     * @return Value of member var_long
     */
    eProsima_user_DllExport int32_t var_long() const
    {
        return m_var_long;
    }

    /*!
     * @brief This function returns a reference to member var_long
     * @return Reference to member var_long
     */
    eProsima_user_DllExport int32_t& var_long()
    {
        return m_var_long;
    }



private:

    Union_Short m_var_union_short;
    int32_t m_var_long{0};

};
/*!
 * @brief This class represents the structure UnionFixedStringAlias defined by the user in the IDL file.
 * @ingroup unions
 */
class UnionFixedStringAlias
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport UnionFixedStringAlias()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~UnionFixedStringAlias()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object UnionFixedStringAlias that will be copied.
     */
    eProsima_user_DllExport UnionFixedStringAlias(
            const UnionFixedStringAlias& x)
    {
                    m_var_union_fixed_string_in_module_alias = x.m_var_union_fixed_string_in_module_alias;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object UnionFixedStringAlias that will be copied.
     */
    eProsima_user_DllExport UnionFixedStringAlias(
            UnionFixedStringAlias&& x) noexcept
    {
        m_var_union_fixed_string_in_module_alias = std::move(x.m_var_union_fixed_string_in_module_alias);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object UnionFixedStringAlias that will be copied.
     */
    eProsima_user_DllExport UnionFixedStringAlias& operator =(
            const UnionFixedStringAlias& x)
    {

                    m_var_union_fixed_string_in_module_alias = x.m_var_union_fixed_string_in_module_alias;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object UnionFixedStringAlias that will be copied.
     */
    eProsima_user_DllExport UnionFixedStringAlias& operator =(
            UnionFixedStringAlias&& x) noexcept
    {

        m_var_union_fixed_string_in_module_alias = std::move(x.m_var_union_fixed_string_in_module_alias);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x UnionFixedStringAlias object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const UnionFixedStringAlias& x) const
    {
        return (m_var_union_fixed_string_in_module_alias == x.m_var_union_fixed_string_in_module_alias);
    }

    /*!
     * @brief Comparison operator.
     * @param x UnionFixedStringAlias object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const UnionFixedStringAlias& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_union_fixed_string_in_module_alias
     * @param _var_union_fixed_string_in_module_alias New value to be copied in member var_union_fixed_string_in_module_alias
     */
    eProsima_user_DllExport void var_union_fixed_string_in_module_alias(
            const Union_Fixed_String_In_Module_Alias& _var_union_fixed_string_in_module_alias)
    {
        m_var_union_fixed_string_in_module_alias = _var_union_fixed_string_in_module_alias;
    }

    /*!
     * @brief This function moves the value in member var_union_fixed_string_in_module_alias
     * @param _var_union_fixed_string_in_module_alias New value to be moved in member var_union_fixed_string_in_module_alias
     */
    eProsima_user_DllExport void var_union_fixed_string_in_module_alias(
            Union_Fixed_String_In_Module_Alias&& _var_union_fixed_string_in_module_alias)
    {
        m_var_union_fixed_string_in_module_alias = std::move(_var_union_fixed_string_in_module_alias);
    }

    /*!
     * @brief This function returns a constant reference to member var_union_fixed_string_in_module_alias
     * @return Constant reference to member var_union_fixed_string_in_module_alias
     */
    eProsima_user_DllExport const Union_Fixed_String_In_Module_Alias& var_union_fixed_string_in_module_alias() const
    {
        return m_var_union_fixed_string_in_module_alias;
    }

    /*!
     * @brief This function returns a reference to member var_union_fixed_string_in_module_alias
     * @return Reference to member var_union_fixed_string_in_module_alias
     */
    eProsima_user_DllExport Union_Fixed_String_In_Module_Alias& var_union_fixed_string_in_module_alias()
    {
        return m_var_union_fixed_string_in_module_alias;
    }



private:

    Union_Fixed_String_In_Module_Alias m_var_union_fixed_string_in_module_alias;

};

#endif // _FAST_DDS_GENERATED_UNIONS_HPP_


