/* $Id: cim_eth.c,v 1.9 2009-01-27 17:06:39 potyra Exp $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "compiler.h"

#include "cim_eth.h"

static void
cim_eth_recv(void *_css, const void *buf, unsigned int bufsize)
{
	struct cim_eth *css = (struct cim_eth *) _css;

	cim_send(&css->bridge, buf, bufsize);
}

static void
cim_eth_receive(void *_css, void *_buf, unsigned int bufsize)
{
	struct cim_eth *css = (struct cim_eth *) _css;
	unsigned char *buf = (unsigned char *) _buf;

	sig_eth_send(css->sig_eth, css, buf, bufsize);
}

void
cim_eth_init(struct cim_eth *css, struct sig_eth *sig_eth)
{
	static const struct sig_eth_funcs funcs = {
		.recv = cim_eth_recv,
	};

	cim_connect(&css->bridge, cim_eth_receive, css);

	css->sig_eth = sig_eth;
	sig_eth_connect(sig_eth, css, &funcs);
}

void
cim_eth_create(struct cim_eth *css)
{
	cim_create(&css->bridge);
}

void
cim_eth_destroy(struct cim_eth *css)
{
	cim_destroy(&css->bridge);
}
