/*
 * $Id: sig_icc_bus.h,v 1.12 2012-03-06 14:46:49 siflkres Exp $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __SIG_ICC_BUS_H_INCLUDED
#define __SIG_ICC_BUS_H_INCLUDED

#include <inttypes.h>

#include "sig_gen.h"

struct sig_icc_bus_funcs {
	void (*eoi)(void *s, uint8_t vector);
	void (*msg0)(void *s,
			unsigned int destination_mode,
			unsigned int delivery_mode,
			unsigned int level,
			unsigned int trigger_mode,
			uint8_t vector,
			uint8_t destination);
	void (*status0)(void *s, unsigned int status);
	void (*msg1)(void *s, uint8_t processor_priority);
	void (*status1)(void *s, unsigned int status);
};

struct sig_icc_bus {
	enum sig_gen_type type;
	struct {
		void *s;
		const struct sig_icc_bus_funcs *f;
	} member[32];
	unsigned int nmembers;
};

struct sig_icc_bus_merge {
	struct sig_icc_bus *s0;
	struct sig_icc_bus *s1;
};

extern void
sig_icc_bus_eoi(struct sig_icc_bus *b, void *s,
		uint8_t vector);

extern void
sig_icc_bus_msg0(struct sig_icc_bus *b, void *s,
		unsigned int destination_mode,
		unsigned int delivery_mode,
		unsigned int level,
		unsigned int trigger_mode,
		uint8_t vector,
		uint8_t destination);
extern void
sig_icc_bus_status0(struct sig_icc_bus *b, void *s,
		unsigned int status);
extern void
sig_icc_bus_msg1(struct sig_icc_bus *b, void *s,
		uint8_t processor_priority);
extern void
sig_icc_bus_status1(struct sig_icc_bus *b, void *s,
		unsigned int status);

extern void
sig_icc_bus_connect(struct sig_icc_bus *b,
		void *s, const struct sig_icc_bus_funcs *f);

extern struct sig_icc_bus_merge *
sig_icc_bus_merge(
	struct sig_icc_bus *s0,
	struct sig_icc_bus *s1
);
extern void
sig_icc_bus_split(struct sig_icc_bus_merge *m);

extern struct sig_icc_bus *
sig_icc_bus_create(const char *name);
extern void
sig_icc_bus_destroy(struct sig_icc_bus *sig);

extern void
sig_icc_bus_suspend(struct sig_icc_bus *b, FILE *fSig);
extern void
sig_icc_bus_resume(struct sig_icc_bus *b, FILE *fSig);

#endif /* __SIG_ICC_BUS_H_INCLUDED */
