/*
 * $Id: sig_keyboard.h,v 1.8 2012-03-06 14:46:49 siflkres Exp $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __SIG_KEYBOARD_H_INCLUDED
#define __SIG_KEYBOARD_H_INCLUDED

#include "sig_gen.h"

struct sig_keyboard_funcs {
	int (*key_press)(void *s, unsigned int key);
	int (*key_release)(void *s, unsigned int key);
	int (*led_on)(void *s, unsigned int led);
	int (*led_off)(void *s, unsigned int led);
};

struct sig_keyboard {
	enum sig_gen_type type;
	struct {
		const struct sig_keyboard_funcs *f;
		void *s;
	} member[4];
	unsigned int member_count;
};

extern int
sig_keyboard_key_press(struct sig_keyboard *b, void *s,
		unsigned int key);
extern int
sig_keyboard_key_release(struct sig_keyboard *b, void *s,
		unsigned int key);
extern int
sig_keyboard_led_on(struct sig_keyboard *b, void *s,
		unsigned int led);
extern int
sig_keyboard_led_off(struct sig_keyboard *b, void *s,
		unsigned int led);

extern void
sig_keyboard_connect(struct sig_keyboard *b, void *s,
		const struct sig_keyboard_funcs *f);

extern struct sig_keyboard *
sig_keyboard_create(const char *name);
extern void
sig_keyboard_destroy(struct sig_keyboard *sig);

extern void
sig_keyboard_suspend(struct sig_keyboard *b, FILE *fSig);
extern void
sig_keyboard_resume(struct sig_keyboard *b, FILE *fSig);

#endif /* __SIG_KEYBOARD_H_INCLUDED */
