/* $Id: main.c,v 1.60 2009-04-03 19:13:28 vrsieh Exp $ 
 *
 * Copyright (C) 2004-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#define NDEBUG

#include "compiler.h"
CODE16;

#include "assert.h"
#include "stdio.h"

#include "main.h"
#include "io.h"
#include "const.h"
#include "var.h"
#include "ptrace.h"

#include "vga.h"
#include "vesa.h"

/* FIXME VOSSI */
#define PA_VIDEO_MEMORY_HIGH	0x40000000

extern CONST unsigned char font_8x16[];
extern CONST unsigned char font_8x14[];
extern CONST unsigned char font_8x8_0[];
extern CONST unsigned char font_8x8_128[];

extern void irq10(void);

void
set_mode(unsigned int mode)
{
	struct palette {
		unsigned char r, g, b;
	};

	/* p. 318 */
	static CONST unsigned char gen[0x14] = {
	/*00*/	0x63,
	/*01*/	0x63,
	/*02*/	0x63,
	/*03*/	0x63,
	/*04*/	0x63,
	/*05*/	0x63,
	/*06*/	0x63,
	/*07*/	0xa6,
	/*08*/	0,
	/*09*/	0,
	/*0a*/	0,
	/*0b*/	0,
	/*0c*/	0,
	/*0d*/	0x63,
	/*0e*/	0x63,
	/*0f*/	0xa2,
	/*10*/	0xa3,
	/*11*/	0xe3,
	/*12*/	0xe3,
	/*13*/	0x63,
	};
	/* p. 318 */
	static CONST unsigned char seq[0x14][5] = {
	/*00*/	{ 0x03, 0x09, 0x03, 0x00, 0x02 },
	/*01*/	{ 0x03, 0x09, 0x03, 0x00, 0x02 },
	/*02*/	{ 0x03, 0x01, 0x03, 0x00, 0x02 },
	/*03*/	{ 0x03, 0x01, 0x03, 0x00, 0x02 },
	/*04*/	{ 0x03, 0x09, 0x03, 0x00, 0x02 },
	/*05*/	{ 0x03, 0x09, 0x03, 0x00, 0x02 },
	/*06*/	{ 0x03, 0x01, 0x01, 0x00, 0x06 },
	/*07*/	{ 0x03, 0x00, 0x03, 0x00, 0x02 },
	/*08*/	{ 0 },
	/*09*/	{ 0 },
	/*0a*/	{ 0 },
	/*0b*/	{ 0 },
	/*0c*/	{ 0 },
	/*0d*/	{ 0x03, 0x09, 0x0f, 0x00, 0x06 },
	/*0e*/	{ 0x03, 0x01, 0x0f, 0x00, 0x06 },
	/*0f*/	{ 0x03, 0x01, 0x0f, 0x00, 0x06 },
	/*10*/	{ 0x03, 0x01, 0x0f, 0x00, 0x06 },
	/*11*/	{ 0x03, 0x01, 0x0f, 0x00, 0x06 },
	/*12*/	{ 0x03, 0x01, 0x0f, 0x00, 0x06 },
	/*13*/	{ 0x03, 0x01, 0x0f, 0x00, 0x0e },
	};
	/* p. 318 */
	static CONST unsigned char crtc[0x14][0x19] = {
	/*00*/	{ 0x2d, 0x27, 0x28, 0x90, 0x2b, 0xa0, 0xbf, 0x1f,
		  0x00, 0x4f, 0x06, 0x07, 0x00, 0x00, 0x00, 0x31,
		  0x9c, 0x8e, 0x8f, 0x14, 0x1f, 0x96, 0xb9, 0xa3,
		  0xff },
	/*01*/	{ 0x2d, 0x27, 0x28, 0x90, 0x2b, 0xa0, 0xbf, 0x1f,
		  0x00, 0xc7, 0x06, 0x07, 0x00, 0x00, 0x00, 0x31,
		  0x9c, 0x8e, 0x8f, 0x14, 0x1f, 0x96, 0xb9, 0xa3,
		  0xff },
	/*02*/	{ 0x5f, 0x4f, 0x50, 0x82, 0x55, 0x81, 0xbf, 0x1f,
		  0x00, 0x4f, 0x06, 0x07, 0x00, 0x00, 0x00, 0x59,
		  0x9c, 0x8e, 0x8f, 0x28, 0x1f, 0x96, 0xb9, 0xa3,
		  0xff },
	/*03*/	{ 0x5f, 0x4f, 0x50, 0x82, 0x55, 0x81, 0xbf, 0x1f,
		  0x00, 0x4f, 0x06, 0x07, 0x00, 0x00, 0x00, 0x59,
		  0x9c, 0x8e, 0x8f, 0x28, 0x1f, 0x96, 0xb9, 0xa3,
		  0xff },
	/*04*/	{ 0x2d, 0x27, 0x28, 0x90, 0x2b, 0x80, 0xbf, 0x1f,
		  0x00, 0xc1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x31,
		  0x9c, 0x8e, 0x8f, 0x14, 0x00, 0x96, 0xb9, 0xa2,
		  0xff },
	/*05*/	{ 0x2d, 0x27, 0x28, 0x90, 0x2b, 0x80, 0xbf, 0x1f,
		  0x00, 0xc1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x31,
		  0x9c, 0x8e, 0x8f, 0x14, 0x00, 0x96, 0xb9, 0xa2,
		  0xff },
	/*06*/	{ 0x5f, 0x4f, 0x50, 0x82, 0x54, 0x80, 0xbf, 0x1f,
		  0x00, 0xc1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x59,
		  0x9c, 0x8e, 0x8f, 0x28, 0x00, 0x96, 0xb9, 0xc2,
		  0xff },
	/*07*/	{ 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		  0xff },
	/*08*/	{ 0 },
	/*09*/	{ 0 },
	/*0a*/	{ 0 },
	/*0b*/	{ 0 },
	/*0c*/	{ 0 },
	/*0d*/	{ 0x2d, 0x27, 0x28, 0x90, 0x2b, 0x80, 0xbf, 0x1f,
		  0x00, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x31,
		  0x9c, 0x8e, 0x8f, 0x14, 0x00, 0x96, 0xb9, 0xe3,
		  0xff },
	/*0e*/	{ 0x5f, 0x4f, 0x50, 0x82, 0x54, 0x80, 0xbf, 0x1f,
		  0x00, 0xc1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x59,
		  0x9c, 0x8e, 0x8f, 0x28, 0x00, 0x96, 0xb9, 0xc2,
		  0xff },
	/*0f*/	{ 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		  0xff },
	/*10*/	{ 0x5f, 0x4f, 0x50, 0x82, 0x54, 0x80, 0xbf, 0x1f,
		  0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x59,
		  0x83, 0x85, 0x5d, 0x28, 0x0f, 0x63, 0xba, 0xe3,
		  0xff },
	/*11*/	{ 0x5f, 0x4f, 0x50, 0x82, 0x54, 0x80, 0x0b, 0x3e,
		  0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x59,
		  0xea, 0x8c, 0xdf, 0x28, 0x00, 0xe7, 0x04, 0xc3,
		  0xff },
	/*12*/	{ 0x5f, 0x4f, 0x50, 0x82, 0x54, 0x80, 0x0b, 0x3e,
		  0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x59,
		  0xea, 0x8c, 0xdf, 0x28, 0x00, 0xe7, 0x04, 0xe3,
		  0xff },
	/*13*/	{ 0x5f, 0x4f, 0x50, 0x82, 0x24, 0x80, 0xbf, 0x1f,
		  0x00, 0xc1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x31,
		  0x9c, 0x8e, 0x8f, 0x28, 0x40, 0x96, 0xb9, 0xa3,
		  0xff },
	};
	/* p. 319 */
	static CONST unsigned char graphic[0x14][9] = {
	/*00*/	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x0e, 0x00, 0xff },
	/*01*/	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x0e, 0x00, 0xff },
	/*02*/	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x0e, 0x00, 0xff },
	/*03*/	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x0e, 0x00, 0xff },
	/*04*/	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x0f, 0x00, 0xff },
	/*05*/	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x0f, 0x00, 0xff },
	/*06*/	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x00, 0xff },
	/*07*/	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x0a, 0x00, 0xff },
	/*08*/	{ 0 },
	/*09*/	{ 0 },
	/*0a*/	{ 0 },
	/*0b*/	{ 0 },
	/*0c*/	{ 0 },
	/*0d*/	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x05, 0x00, 0xff },
	/*0e*/	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0f, 0xff },
	/*0f*/	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x05, 0xff },
	/*10*/	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x05, 0x00, 0xff },
	/*11*/	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0xff },
	/*12*/	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0f, 0xff },
	/*13*/	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x05, 0x0f, 0xff },
	};
	/* p. 319 */
	static CONST unsigned char attr[0x14][0x15] = {
	/*00*/	{ 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
		  0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,
		  0x08, 0x00, 0x0f, 0x00, 0x00 },
	/*01*/	{ 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
		  0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,
		  0x08, 0x00, 0x0f, 0x00, 0x00 },
#if 0	/* Don't use info from VGA book. */
	/*02*/	{ 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
		  0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,
		  0x08, 0x00, 0x0f, 0x00, 0x00 },
	/*03*/	{ 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
		  0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,
		  0x08, 0x00, 0x0f, 0x00, 0x00 },
#else
	/*02*/	{ 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x14, 0x07,
		  0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f,
		  0x08, 0x00, 0x0f, 0x00, 0x00 },
	/*03*/	{ 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x14, 0x07,
		  0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f,
		  0x08, 0x00, 0x0f, 0x00, 0x00 },
#endif
	/*04*/	{ 0x00, 0x13, 0x15, 0x17, 0x02, 0x04, 0x06, 0x07,
		  0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,
		  0x01, 0x00, 0x03, 0x00, 0x00 },
	/*05*/	{ 0x00, 0x13, 0x15, 0x17, 0x02, 0x04, 0x06, 0x07,
		  0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,
		  0x01, 0x00, 0x03, 0x00, 0x00 },
	/*06*/	{ 0x00, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17,
		  0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17,
		  0x01, 0x00, 0x01, 0x00, 0x00 },
	/*07*/	{ 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08,
		  0x10, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
		  0x0e, 0x00, 0x0f, 0x00, 0x00 },
	/*08*/	{ 0 },
	/*09*/	{ 0 },
	/*0a*/	{ 0 },
	/*0b*/	{ 0 },
	/*0c*/	{ 0 },
	/*0d*/	{ 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
		  0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,
		  0x01, 0x00, 0x0f, 0x00, 0x00 },
	/*0e*/	{ 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
		  0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,
		  0x01, 0x00, 0x0f, 0x00, 0x00 },
	/*0f*/	{ 0x00, 0x08, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00,
		  0x00, 0x08, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00,
		  0x0b, 0x00, 0x05, 0x00, 0x00 },
	/*10*/	{ 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x14, 0x07,
		  0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f,
		  0x01, 0x00, 0x0f, 0x00, 0x00 },
	/*11*/	{ 0x00, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f,
		  0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f,
		  0x01, 0x00, 0x0f, 0x00, 0x00 },
	/*12*/	{ 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x14, 0x07,
		  0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f,
		  0x01, 0x00, 0x0f, 0x00, 0x00 },
	/*13*/	{ 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x14, 0x07,
		  0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
		  0x41, 0x00, 0x0f, 0x00, 0x00 },
	};
	static CONST unsigned char dacmodel[0x14] = {
	/*00*/	2,
	/*01*/	2,
	/*02*/	2,
	/*03*/	2,
	/*04*/	1,
	/*05*/	1,
	/*06*/	1,
	/*07*/	0,
	/*08*/	0xff,
	/*09*/	0xff,
	/*0a*/	0xff,
	/*0b*/	0xff,
	/*0c*/	0xff,
	/*0d*/	1,
	/*0e*/	1,
	/*0f*/	0,
	/*10*/	2,
	/*11*/	2,
	/*12*/	2,
	/*13*/	3,
	};
	static CONST struct palette palette0[64] = {
		{ 0x00,0x00,0x00 }, { 0x00,0x00,0x00 },
		{ 0x00,0x00,0x00 }, { 0x00,0x00,0x00 },
		{ 0x00,0x00,0x00 }, { 0x00,0x00,0x00 },
		{ 0x00,0x00,0x00 }, { 0x00,0x00,0x00 },
		{ 0x2a,0x2a,0x2a }, { 0x2a,0x2a,0x2a },
		{ 0x2a,0x2a,0x2a }, { 0x2a,0x2a,0x2a },
		{ 0x2a,0x2a,0x2a }, { 0x2a,0x2a,0x2a },
		{ 0x2a,0x2a,0x2a }, { 0x2a,0x2a,0x2a },
		{ 0x2a,0x2a,0x2a }, { 0x2a,0x2a,0x2a },
		{ 0x2a,0x2a,0x2a }, { 0x2a,0x2a,0x2a },
		{ 0x2a,0x2a,0x2a }, { 0x2a,0x2a,0x2a },
		{ 0x2a,0x2a,0x2a }, { 0x2a,0x2a,0x2a },
		{ 0x3f,0x3f,0x3f }, { 0x3f,0x3f,0x3f },
		{ 0x3f,0x3f,0x3f }, { 0x3f,0x3f,0x3f },
		{ 0x3f,0x3f,0x3f }, { 0x3f,0x3f,0x3f },
		{ 0x3f,0x3f,0x3f }, { 0x3f,0x3f,0x3f },
		{ 0x00,0x00,0x00 }, { 0x00,0x00,0x00 },
		{ 0x00,0x00,0x00 }, { 0x00,0x00,0x00 },
		{ 0x00,0x00,0x00 }, { 0x00,0x00,0x00 },
		{ 0x00,0x00,0x00 }, { 0x00,0x00,0x00 },
		{ 0x2a,0x2a,0x2a }, { 0x2a,0x2a,0x2a },
		{ 0x2a,0x2a,0x2a }, { 0x2a,0x2a,0x2a },
		{ 0x2a,0x2a,0x2a }, { 0x2a,0x2a,0x2a },
		{ 0x2a,0x2a,0x2a }, { 0x2a,0x2a,0x2a },
		{ 0x2a,0x2a,0x2a }, { 0x2a,0x2a,0x2a },
		{ 0x2a,0x2a,0x2a }, { 0x2a,0x2a,0x2a },
		{ 0x2a,0x2a,0x2a }, { 0x2a,0x2a,0x2a },
		{ 0x2a,0x2a,0x2a }, { 0x2a,0x2a,0x2a },
		{ 0x3f,0x3f,0x3f }, { 0x3f,0x3f,0x3f },
		{ 0x3f,0x3f,0x3f }, { 0x3f,0x3f,0x3f },
		{ 0x3f,0x3f,0x3f }, { 0x3f,0x3f,0x3f },
		{ 0x3f,0x3f,0x3f }, { 0x3f,0x3f,0x3f }
	};
	static CONST struct palette palette1[64] = {
		{ 0x00,0x00,0x00 }, { 0x00,0x00,0x2a },
		{ 0x00,0x2a,0x00 }, { 0x00,0x2a,0x2a },
		{ 0x2a,0x00,0x00 }, { 0x2a,0x00,0x2a },
		{ 0x2a,0x15,0x00 }, { 0x2a,0x2a,0x2a },
		{ 0x00,0x00,0x00 }, { 0x00,0x00,0x2a },
		{ 0x00,0x2a,0x00 }, { 0x00,0x2a,0x2a },
		{ 0x2a,0x00,0x00 }, { 0x2a,0x00,0x2a },
		{ 0x2a,0x15,0x00 }, { 0x2a,0x2a,0x2a },
		{ 0x15,0x15,0x15 }, { 0x15,0x15,0x3f },
		{ 0x15,0x3f,0x15 }, { 0x15,0x3f,0x3f },
		{ 0x3f,0x15,0x15 }, { 0x3f,0x15,0x3f },
		{ 0x3f,0x3f,0x15 }, { 0x3f,0x3f,0x3f },
		{ 0x15,0x15,0x15 }, { 0x15,0x15,0x3f },
		{ 0x15,0x3f,0x15 }, { 0x15,0x3f,0x3f },
		{ 0x3f,0x15,0x15 }, { 0x3f,0x15,0x3f },
		{ 0x3f,0x3f,0x15 }, { 0x3f,0x3f,0x3f },
		{ 0x00,0x00,0x00 }, { 0x00,0x00,0x2a },
		{ 0x00,0x2a,0x00 }, { 0x00,0x2a,0x2a },
		{ 0x2a,0x00,0x00 }, { 0x2a,0x00,0x2a },
		{ 0x2a,0x15,0x00 }, { 0x2a,0x2a,0x2a },
		{ 0x00,0x00,0x00 }, { 0x00,0x00,0x2a },
		{ 0x00,0x2a,0x00 }, { 0x00,0x2a,0x2a },
		{ 0x2a,0x00,0x00 }, { 0x2a,0x00,0x2a },
		{ 0x2a,0x15,0x00 }, { 0x2a,0x2a,0x2a },
		{ 0x15,0x15,0x15 }, { 0x15,0x15,0x3f },
		{ 0x15,0x3f,0x15 }, { 0x15,0x3f,0x3f },
		{ 0x3f,0x15,0x15 }, { 0x3f,0x15,0x3f },
		{ 0x3f,0x3f,0x15 }, { 0x3f,0x3f,0x3f },
		{ 0x15,0x15,0x15 }, { 0x15,0x15,0x3f },
		{ 0x15,0x3f,0x15 }, { 0x15,0x3f,0x3f },
		{ 0x3f,0x15,0x15 }, { 0x3f,0x15,0x3f },
		{ 0x3f,0x3f,0x15 }, { 0x3f,0x3f,0x3f }
	};
	static CONST struct palette palette2[64] = {
		{ 0x00,0x00,0x00 }, { 0x00,0x00,0x2a },
		{ 0x00,0x2a,0x00 }, { 0x00,0x2a,0x2a },
		{ 0x2a,0x00,0x00 }, { 0x2a,0x00,0x2a },
		{ 0x2a,0x2a,0x00 }, { 0x2a,0x2a,0x2a },
		{ 0x00,0x00,0x15 }, { 0x00,0x00,0x3f },
		{ 0x00,0x2a,0x15 }, { 0x00,0x2a,0x3f },
		{ 0x2a,0x00,0x15 }, { 0x2a,0x00,0x3f },
		{ 0x2a,0x2a,0x15 }, { 0x2a,0x2a,0x3f },
		{ 0x00,0x15,0x00 }, { 0x00,0x15,0x2a },
		{ 0x00,0x3f,0x00 }, { 0x00,0x3f,0x2a },
		{ 0x2a,0x15,0x00 }, { 0x2a,0x15,0x2a },
		{ 0x2a,0x3f,0x00 }, { 0x2a,0x3f,0x2a },
		{ 0x00,0x15,0x15 }, { 0x00,0x15,0x3f },
		{ 0x00,0x3f,0x15 }, { 0x00,0x3f,0x3f },
		{ 0x2a,0x15,0x15 }, { 0x2a,0x15,0x3f },
		{ 0x2a,0x3f,0x15 }, { 0x2a,0x3f,0x3f },
		{ 0x15,0x00,0x00 }, { 0x15,0x00,0x2a },
		{ 0x15,0x2a,0x00 }, { 0x15,0x2a,0x2a },
		{ 0x3f,0x00,0x00 }, { 0x3f,0x00,0x2a },
		{ 0x3f,0x2a,0x00 }, { 0x3f,0x2a,0x2a },
		{ 0x15,0x00,0x15 }, { 0x15,0x00,0x3f },
		{ 0x15,0x2a,0x15 }, { 0x15,0x2a,0x3f },
		{ 0x3f,0x00,0x15 }, { 0x3f,0x00,0x3f },
		{ 0x3f,0x2a,0x15 }, { 0x3f,0x2a,0x3f },
		{ 0x15,0x15,0x00 }, { 0x15,0x15,0x2a },
		{ 0x15,0x3f,0x00 }, { 0x15,0x3f,0x2a },
		{ 0x3f,0x15,0x00 }, { 0x3f,0x15,0x2a },
		{ 0x3f,0x3f,0x00 }, { 0x3f,0x3f,0x2a },
		{ 0x15,0x15,0x15 }, { 0x15,0x15,0x3f },
		{ 0x15,0x3f,0x15 }, { 0x15,0x3f,0x3f },
		{ 0x3f,0x15,0x15 }, { 0x3f,0x15,0x3f },
		{ 0x3f,0x3f,0x15 }, { 0x3f,0x3f,0x3f }
	};
	static CONST struct palette palette3[256] = {
		{ 0x00,0x00,0x00 }, { 0x00,0x00,0x2a },
		{ 0x00,0x2a,0x00 }, { 0x00,0x2a,0x2a },
		{ 0x2a,0x00,0x00 }, { 0x2a,0x00,0x2a },
		{ 0x2a,0x15,0x00 }, { 0x2a,0x2a,0x2a },
		{ 0x15,0x15,0x15 }, { 0x15,0x15,0x3f },
		{ 0x15,0x3f,0x15 }, { 0x15,0x3f,0x3f },
		{ 0x3f,0x15,0x15 }, { 0x3f,0x15,0x3f },
		{ 0x3f,0x3f,0x15 }, { 0x3f,0x3f,0x3f },
		{ 0x00,0x00,0x00 }, { 0x05,0x05,0x05 },
		{ 0x08,0x08,0x08 }, { 0x0b,0x0b,0x0b },
		{ 0x0e,0x0e,0x0e }, { 0x11,0x11,0x11 },
		{ 0x14,0x14,0x14 }, { 0x18,0x18,0x18 },
		{ 0x1c,0x1c,0x1c }, { 0x20,0x20,0x20 },
		{ 0x24,0x24,0x24 }, { 0x28,0x28,0x28 },
		{ 0x2d,0x2d,0x2d }, { 0x32,0x32,0x32 },
		{ 0x38,0x38,0x38 }, { 0x3f,0x3f,0x3f },
		{ 0x00,0x00,0x3f }, { 0x10,0x00,0x3f },
		{ 0x1f,0x00,0x3f }, { 0x2f,0x00,0x3f },
		{ 0x3f,0x00,0x3f }, { 0x3f,0x00,0x2f },
		{ 0x3f,0x00,0x1f }, { 0x3f,0x00,0x10 },
		{ 0x3f,0x00,0x00 }, { 0x3f,0x10,0x00 },
		{ 0x3f,0x1f,0x00 }, { 0x3f,0x2f,0x00 },
		{ 0x3f,0x3f,0x00 }, { 0x2f,0x3f,0x00 },
		{ 0x1f,0x3f,0x00 }, { 0x10,0x3f,0x00 },
		{ 0x00,0x3f,0x00 }, { 0x00,0x3f,0x10 },
		{ 0x00,0x3f,0x1f }, { 0x00,0x3f,0x2f },
		{ 0x00,0x3f,0x3f }, { 0x00,0x2f,0x3f },
		{ 0x00,0x1f,0x3f }, { 0x00,0x10,0x3f },
		{ 0x1f,0x1f,0x3f }, { 0x27,0x1f,0x3f },
		{ 0x2f,0x1f,0x3f }, { 0x37,0x1f,0x3f },
		{ 0x3f,0x1f,0x3f }, { 0x3f,0x1f,0x37 },
		{ 0x3f,0x1f,0x2f }, { 0x3f,0x1f,0x27 },

		{ 0x3f,0x1f,0x1f }, { 0x3f,0x27,0x1f },
		{ 0x3f,0x2f,0x1f }, { 0x3f,0x37,0x1f },
		{ 0x3f,0x3f,0x1f }, { 0x37,0x3f,0x1f },
		{ 0x2f,0x3f,0x1f }, { 0x27,0x3f,0x1f },
		{ 0x1f,0x3f,0x1f }, { 0x1f,0x3f,0x27 },
		{ 0x1f,0x3f,0x2f }, { 0x1f,0x3f,0x37 },
		{ 0x1f,0x3f,0x3f }, { 0x1f,0x37,0x3f },
		{ 0x1f,0x2f,0x3f }, { 0x1f,0x27,0x3f },
		{ 0x2d,0x2d,0x3f }, { 0x31,0x2d,0x3f },
		{ 0x36,0x2d,0x3f }, { 0x3a,0x2d,0x3f },
		{ 0x3f,0x2d,0x3f }, { 0x3f,0x2d,0x3a },
		{ 0x3f,0x2d,0x36 }, { 0x3f,0x2d,0x31 },
		{ 0x3f,0x2d,0x2d }, { 0x3f,0x31,0x2d },
		{ 0x3f,0x36,0x2d }, { 0x3f,0x3a,0x2d },
		{ 0x3f,0x3f,0x2d }, { 0x3a,0x3f,0x2d },
		{ 0x36,0x3f,0x2d }, { 0x31,0x3f,0x2d },
		{ 0x2d,0x3f,0x2d }, { 0x2d,0x3f,0x31 },
		{ 0x2d,0x3f,0x36 }, { 0x2d,0x3f,0x3a },
		{ 0x2d,0x3f,0x3f }, { 0x2d,0x3a,0x3f },
		{ 0x2d,0x36,0x3f }, { 0x2d,0x31,0x3f },
		{ 0x00,0x00,0x1c }, { 0x07,0x00,0x1c },
		{ 0x0e,0x00,0x1c }, { 0x15,0x00,0x1c },
		{ 0x1c,0x00,0x1c }, { 0x1c,0x00,0x15 },
		{ 0x1c,0x00,0x0e }, { 0x1c,0x00,0x07 },
		{ 0x1c,0x00,0x00 }, { 0x1c,0x07,0x00 },
		{ 0x1c,0x0e,0x00 }, { 0x1c,0x15,0x00 },
		{ 0x1c,0x1c,0x00 }, { 0x15,0x1c,0x00 },
		{ 0x0e,0x1c,0x00 }, { 0x07,0x1c,0x00 },
		{ 0x00,0x1c,0x00 }, { 0x00,0x1c,0x07 },
		{ 0x00,0x1c,0x0e }, { 0x00,0x1c,0x15 },
		{ 0x00,0x1c,0x1c }, { 0x00,0x15,0x1c },
		{ 0x00,0x0e,0x1c }, { 0x00,0x07,0x1c },

		{ 0x0e,0x0e,0x1c }, { 0x11,0x0e,0x1c },
		{ 0x15,0x0e,0x1c }, { 0x18,0x0e,0x1c },
		{ 0x1c,0x0e,0x1c }, { 0x1c,0x0e,0x18 },
		{ 0x1c,0x0e,0x15 }, { 0x1c,0x0e,0x11 },
		{ 0x1c,0x0e,0x0e }, { 0x1c,0x11,0x0e },
		{ 0x1c,0x15,0x0e }, { 0x1c,0x18,0x0e },
		{ 0x1c,0x1c,0x0e }, { 0x18,0x1c,0x0e },
		{ 0x15,0x1c,0x0e }, { 0x11,0x1c,0x0e },
		{ 0x0e,0x1c,0x0e }, { 0x0e,0x1c,0x11 },
		{ 0x0e,0x1c,0x15 }, { 0x0e,0x1c,0x18 },
		{ 0x0e,0x1c,0x1c }, { 0x0e,0x18,0x1c },
		{ 0x0e,0x15,0x1c }, { 0x0e,0x11,0x1c },
		{ 0x14,0x14,0x1c }, { 0x16,0x14,0x1c },
		{ 0x18,0x14,0x1c }, { 0x1a,0x14,0x1c },
		{ 0x1c,0x14,0x1c }, { 0x1c,0x14,0x1a },
		{ 0x1c,0x14,0x18 }, { 0x1c,0x14,0x16 },
		{ 0x1c,0x14,0x14 }, { 0x1c,0x16,0x14 },
		{ 0x1c,0x18,0x14 }, { 0x1c,0x1a,0x14 },
		{ 0x1c,0x1c,0x14 }, { 0x1a,0x1c,0x14 },
		{ 0x18,0x1c,0x14 }, { 0x16,0x1c,0x14 },
		{ 0x14,0x1c,0x14 }, { 0x14,0x1c,0x16 },
		{ 0x14,0x1c,0x18 }, { 0x14,0x1c,0x1a },
		{ 0x14,0x1c,0x1c }, { 0x14,0x1a,0x1c },
		{ 0x14,0x18,0x1c }, { 0x14,0x16,0x1c },
		{ 0x00,0x00,0x10 }, { 0x04,0x00,0x10 },
		{ 0x08,0x00,0x10 }, { 0x0c,0x00,0x10 },
		{ 0x10,0x00,0x10 }, { 0x10,0x00,0x0c },
		{ 0x10,0x00,0x08 }, { 0x10,0x00,0x04 },
		{ 0x10,0x00,0x00 }, { 0x10,0x04,0x00 },
		{ 0x10,0x08,0x00 }, { 0x10,0x0c,0x00 },
		{ 0x10,0x10,0x00 }, { 0x0c,0x10,0x00 },
		{ 0x08,0x10,0x00 }, { 0x04,0x10,0x00 },

		{ 0x00,0x10,0x00 }, { 0x00,0x10,0x04 },
		{ 0x00,0x10,0x08 }, { 0x00,0x10,0x0c },
		{ 0x00,0x10,0x10 }, { 0x00,0x0c,0x10 },
		{ 0x00,0x08,0x10 }, { 0x00,0x04,0x10 },
		{ 0x08,0x08,0x10 }, { 0x0a,0x08,0x10 },
		{ 0x0c,0x08,0x10 }, { 0x0e,0x08,0x10 },
		{ 0x10,0x08,0x10 }, { 0x10,0x08,0x0e },
		{ 0x10,0x08,0x0c }, { 0x10,0x08,0x0a },
		{ 0x10,0x08,0x08 }, { 0x10,0x0a,0x08 },
		{ 0x10,0x0c,0x08 }, { 0x10,0x0e,0x08 },
		{ 0x10,0x10,0x08 }, { 0x0e,0x10,0x08 },
		{ 0x0c,0x10,0x08 }, { 0x0a,0x10,0x08 },
		{ 0x08,0x10,0x08 }, { 0x08,0x10,0x0a },
		{ 0x08,0x10,0x0c }, { 0x08,0x10,0x0e },
		{ 0x08,0x10,0x10 }, { 0x08,0x0e,0x10 },
		{ 0x08,0x0c,0x10 }, { 0x08,0x0a,0x10 },
		{ 0x0b,0x0b,0x10 }, { 0x0c,0x0b,0x10 },
		{ 0x0d,0x0b,0x10 }, { 0x0f,0x0b,0x10 },
		{ 0x10,0x0b,0x10 }, { 0x10,0x0b,0x0f },
		{ 0x10,0x0b,0x0d }, { 0x10,0x0b,0x0c },
		{ 0x10,0x0b,0x0b }, { 0x10,0x0c,0x0b },
		{ 0x10,0x0d,0x0b }, { 0x10,0x0f,0x0b },
		{ 0x10,0x10,0x0b }, { 0x0f,0x10,0x0b },
		{ 0x0d,0x10,0x0b }, { 0x0c,0x10,0x0b },
		{ 0x0b,0x10,0x0b }, { 0x0b,0x10,0x0c },
		{ 0x0b,0x10,0x0d }, { 0x0b,0x10,0x0f },
		{ 0x0b,0x10,0x10 }, { 0x0b,0x0f,0x10 },
		{ 0x0b,0x0d,0x10 }, { 0x0b,0x0c,0x10 },
		{ 0x00,0x00,0x00 }, { 0x00,0x00,0x00 },
		{ 0x00,0x00,0x00 }, { 0x00,0x00,0x00 },
		{ 0x00,0x00,0x00 }, { 0x00,0x00,0x00 },
		{ 0x00,0x00,0x00 }, { 0x00,0x00,0x00 }
	};
	unsigned char dontclear;
	unsigned long offset;
	unsigned short i;
	CONST struct palette *palette;
	unsigned short dacregs;

	dontclear = (mode >> 7) & 1;
	mode &= 0x7f;

	/* FIXME VOSSI */
	/* Disable VESA mode. */
	outw(mode, 0x03de);

	/*
	 * Initialize General Registers
	 */
	outb(const_get(gen[mode]), 0x03c2);

	/*
	 * Initialize Sequencer Registers
	 */
	for (i = 0; i < 5; i++) {
		outb(i, 0x03c4);
		outb(const_get(seq[mode][i]), 0x03c5);
	}

	/*
	 * Initialize CRTC Registers
	 */
	for (i = 0; i < 0x19; i++) {
		outb(i, 0x03d4);
		outb(const_get(crtc[mode][i]), 0x03d5);
	}

	/*
	 * Initialize Graphics Controller Registers
	 */
	for (i = 0; i < 9; i++) {
		outb(i, 0x03ce);
		outb(const_get(graphic[mode][i]), 0x03cf);
	}

	/*
	 * Initialize Attribute Controller Registers
	 */
	for (i = 0; i < 0x15; i++) {
		(void) inb(0x03da);
		outb(i, 0x03c0);
		outb(const_get(attr[mode][i]), 0x03c0);
	}

	/*
	 * Initialize Color Registers
	 */
	if        (const_get(dacmodel[mode]) == 0) {
		palette = palette0;
		dacregs = 64;
	} else if (const_get(dacmodel[mode]) == 1) {
		palette = palette1;
		dacregs = 64;
	} else if (const_get(dacmodel[mode]) == 2) {
		palette = palette2;
		dacregs = 64;
	} else if (const_get(dacmodel[mode]) == 3) {
		palette = palette3;
		dacregs = 256;
	} else {
		/* To make gcc happy... */
		palette = (CONST struct palette *) 0;
		dacregs = 0;
		assert(0);
	}
	for (i = 0; i < 256; i++) {
		if (i < dacregs) {
			outb(i, 0x03c8);
			outb(const_get(palette[i].r), 0x03c9);
			outb(const_get(palette[i].g), 0x03c9);
			outb(const_get(palette[i].b), 0x03c9);
		} else {
			outb(i, 0x03c8);
			outb(0, 0x03c9);
			outb(0, 0x03c9);
			outb(0, 0x03c9);
		}
	}

	if (mode == 0x03 || mode == 0x02) {
		/*
		 * Copy standard VGA font to map 1 and map 2.
		 */
		/* See linux/drivers/video/vgacon.c. */
		outb_p(0x00, 0x03c4);	/* Synchronous reset */
		outb_p(0x01, 0x03c5);
		outb_p(0x02, 0x03c4);	/* CPU writes only to map 2 */
		outb_p(0x04, 0x03c5);
		outb_p(0x04, 0x03c4);	/* Sequential addressing */
		outb_p(0x07, 0x03c5);
		outb_p(0x00, 0x03c4);	/* Clear synchronous reset */
		outb_p(0x03, 0x03c5);

		outb_p(0x04, 0x03ce);	/* Select map 2 */
		outb_p(0x02, 0x03cf);
		outb_p(0x05, 0x03ce);	/* disable odd-even addressing */
		outb_p(0x00, 0x03cf);
		outb_p(0x06, 0x03ce);	/* map start at A000:0000 */
		outb_p(0x00, 0x03cf);

		for (offset = 0; offset < 256; offset++) {
			for (i = 0; i < 16; i++) {
				/* first font */
				put_byte(0xa000, (unsigned char *) (offset * 32 + i),
					const_get(font_8x16[offset * 16 + i]));
				/* second font */
				put_byte(0xa000, (unsigned char *) ((offset + 256) * 32 + i),
					const_get(font_8x16[offset * 16 + i]));
			}
		}

		outb_p(0x00, 0x03c4);	/* Synchronous reset */
		outb_p(0x01, 0x03c5);
		outb_p(0x02, 0x03c4);	/* CPU writes to maps 0 and 1 */
		outb_p(0x03, 0x03c5);
		outb_p(0x04, 0x03c4);	/* odd-even addressing */
		outb_p(0x03, 0x03c5);
		outb_p(0x00, 0x03c4);	/* Clear synchronous reset */
		outb_p(0x03, 0x03c5);

		outb_p(0x04, 0x03ce);	/* Select map 0 for CPU */
		outb_p(0x00, 0x03cf);
		outb_p(0x05, 0x03ce);	/* enable odd-even addressing */
		outb_p(0x10, 0x03cf);
		outb_p(0x06, 0x03ce);	/* map start at B000:0000/B800:0000 */
		outb_p(const_get(graphic[mode][6]), 0x03cf);
	}

	/*
	 * Set interrupt vectors.
	 */
	/* INT 1Fh pointer */
	put_word(0x0000, (unsigned short *) (0x1f*4 + 0),
			PTR_SEG(font_8x8_128));
	put_word(0x0000, (unsigned short *) (0x1f*4 + 2),
			PTR_OFF(font_8x8_128));

	/* INT 43h pointer */
	if (16 == 8) {	/* FIXME VOSSI */
		/* System BIOS has 8x8 font at 0xf000:0xfa6e */
		put_word(0x0000, (unsigned short *) (0x43*4 + 0), 0xf000);
		put_word(0x0000, (unsigned short *) (0x43*4 + 2), 0xfa6e);

	} else if (16 == 14) {	/* FIXME VOSSI */
		put_word(0x0000, (unsigned short *) (0x43*4 + 0),
				PTR_SEG(font_8x14));
		put_word(0x0000, (unsigned short *) (0x43*4 + 2),
				PTR_OFF(font_8x14));
	} else if (16 == 16) {	/* FIXME VOSSI */
		put_word(0x0000, (unsigned short *) (0x43*4 + 0),
				PTR_SEG(font_8x16));
		put_word(0x0000, (unsigned short *) (0x43*4 + 2),
				PTR_OFF(font_8x16));
	} else {
		assert(0);
	}

	/*
	 * Set BIOS variables.
	 */
	var_put(vid_mode, mode);
	var_put(vid_mode_r, mode);
	var_put(curr_page, 0);
	for (i = 0; i < 8; i++) {
		var_put(curspos[0].x, 0);
		var_put(curspos[0].y, 0);
	}

	if (mode == 0x03 || mode == 0x02) {
		/* 80x25 text mode */
		var_put(vid_rows, 25 - 1);
		var_put(vid_columns, 80);
		var_put(vid_pageoff, 0);
		var_put(vid_pagesize, (unsigned short)(80 * 25 * 2));

	/* } else if (...) { FIXME MARCEL */

	} else if (mode == 0x12) {
		/* 640x480x16 VGA mode */
		var_put(vid_rows, 30 - 1);
		var_put(vid_columns, 80);
		var_put(vid_pageoff, 0);
		var_put(vid_pagesize, (unsigned short) (480 / 8 * 640));

	} else if (mode == 0x13) {
		/* 320x200x256 VGA mode */
		var_put(vid_rows, 12 - 1); /* actually 12.5 */
		var_put(vid_columns, 40);
		var_put(vid_pageoff, 0);
		var_put(vid_pagesize, (unsigned short) (200 * 320));

	/* } else if (...) { FIXME MARCEL */

	/* } else { */
		/* FIXME MARCEL */
	}

	var_put(vid_cheight, 16);	/* FIXME MARCEL */
	var_put(vid_io, 0x3d4);

	/* FIXME VOSSI */
	var_put(vbe_mode, mode);

	/*
	 * Clear Screen
	 */
	if (! dontclear) {
		if (mode == 0x03 || mode == 0x02) {
			for (offset = 0; offset < 0x8000; offset += 2) {
				put_word(0xb800, (unsigned short *) offset,
					((0x0 << 4) | (0x7 << 0) << 8) | ' ');
			}
		} else if (mode == 0x12 || mode == 0x13) {
			for (offset = 0; offset < 0x10000UL; offset += 2) {
				put_word(0xa000, (unsigned short *) offset, 0);
			}
		}
	}
}

void
set_cursor_shape(unsigned char start, unsigned char end)
{
	unsigned short cheight;
	unsigned short crtc_addr;

	start &= 0x3f;
	end &= 0x1f;

	var_put(curs_start, start);
	var_put(curs_end, end);

	cheight = var_get(vid_cheight);
	if (8 < cheight && end < 8 && start < 0x20) {
		if (end != start + 1) {
			start = (start + 1) * cheight / 8 - 1;
		} else {
			start = (end + 1) * cheight / 8 - 2;
		}
		end = (end + 1) * cheight / 8 - 1;
	}

	crtc_addr = var_get(vid_io);
	outb(0x0a, crtc_addr);	/* select: cursor start */
	outb(start, crtc_addr + 1);
	outb(0x0b, crtc_addr);	/* select: cursor end */
	outb(end, crtc_addr + 1);
}

void
int10(struct regs *regs)
{
	if	(AH == 0x00) {
		/* Set video mode */
		bios_10_00xx(regs);

	} else if (AH == 0x01) {
		bios_10_01xx(regs);

	} else if (AH == 0x02) {
		/* Write cursor position */
		bios_10_02xx(regs);

	} else if (AH == 0x03) {
		/* Read cursor position */
		bios_10_03xx(regs);

	} else if (AH == 0x05) {
		/* Set active page. */
		bios_10_05xx(regs);

	} else if (AH == 0x06) {
		/* Scroll window up */
		bios_10_06xx(regs);

	} else if (AH == 0x07) {
		/* Scroll window down */
		bios_10_07xx(regs);

	} else if (AH == 0x08) {
		/* Read character with attribute */
		bios_10_08xx(regs);

	} else if (AH == 0x09) {
		/* Print character with attribute */
		bios_10_09xx(regs);

	} else if (AH == 0x0a) {
		/* Print character only at cursor position */
		bios_10_0axx(regs);

	} else if (AH == 0x0b) {
		/* Set border/background color. */
		bios_10_0bxx(regs);

	} else if (AH == 0x0c) {
		/* Write pixel */
		bios_10_0cxx(regs);

	} else if (AH == 0x0e) {
		/* Print character */
		bios_10_0exx(regs);

	} else if (AH == 0x0f) {
		/* Read page/mode/width */
		bios_10_0fxx(regs);

	} else if (AX == 0x1000) {
		/* set single palette register */
		bios_10_1000(regs);

	} else if (AX == 0x1002) {
		/* VIDEO - SET ALL PALETTE REGISTERS (PCjr,Tandy,EGA,VGA) */
		bios_10_1002(regs);

	} else if (AX == 0x1003) {
		/* Set/reset intensity/blinking. */
		bios_10_1003(regs);

	} else if (AX == 0x1007) {
		/* get single DAC register */
		bios_10_1007(regs);

	} else if (AX == 0x1009) {
		/* get all palette registers */
		bios_10_1009(regs);

	} else if (AX == 0x1010) {
		/* set single DAC register */
		bios_10_1010(regs);

	} else if (AX == 0x1012) {
		/* set block of DAC registers */
		bios_10_1012(regs);

	} else if (AX == 0x1015) {
		/* read DAC register */
		bios_10_1015(regs);

	} else if (AH == 0x11) {
		bios_10_11xx(regs);

	} else if (AH == 0x12) {
		/* Check EGA/VGA */
		bios_10_12xx(regs);
		cirrus_10_12xx_extensions(regs);

	} else if (AH == 0x13) {
		/* Print string */
		bios_10_13xx(regs);

	} else if (AX == 0x1a00) {
		/* Check for EGA/VGA discrimination */
		bios_10_1a00(regs);

	} else if (AH == 0x1b) {
		/* Get state information. */
		bios_10_1bxx(regs);

	} else if (AH == 0x20) {
		/* WINDOWS NT 4.0 something */
		dprintf("int $0x%02x: ignored sub-function 0x%04x\n", 0x10, AX);

	} else if (AH == 0x4f) {
		/* VESA call */
		bios_10_4fxx(regs);

	} else if (AX == 0x5000) {
		/* Called by eCS */
		/* Do nothing... */
		dprintf("int $0x%02x: ignored sub-function 0x%04x\n", 0x10, AX);

	} else if (AX == 0x6f00) {
		/* Called by win-3.1 */
		/* Do nothing... */
		dprintf("int $0x%02x: ignored sub-function 0x%04x\n", 0x10, AX);

	} else if (AX == 0xfe00) {
		/* Called by win-3.1 ("defrag") */
		/* Do nothing... */
		dprintf("int $0x%02x: ignored sub-function 0x%04x\n", 0x10, AX);

	} else {
		dprintf("int $0x%02x: unknown sub-function 0x%04x\n", 0x10, AX);
	}
}

/*
 * initialize video
 * (assuming CGA compatible graphic adapter - FIXME VOSSI)
 */
void
video_init(void)
{
	unsigned short sys_conf;

	var_put(switches, 0xf9);

	/* cirrus_vga_bios initializes it's extension registers */
	/* (must be done first to properly set up memory) */
	cirrus_extension_init();

	/* set video mode */
	set_mode(3);
	/* set cursor shape */
	set_cursor_shape(14, 15);

	/* Set sys_conf register. */
	/* Initial video mode is 80x25 color. */
	sys_conf = var_get(sys_conf);
	sys_conf &= ~(3 << 4);
	sys_conf |= 2 << 4;
	var_put(sys_conf, sys_conf);

	/* set interrupt vector */
	put_word(0x0000, (unsigned short *) (0x10 * 4 + 0), PTR_OFF(irq10));
	put_word(0x0000, (unsigned short *) (0x10 * 4 + 2), PTR_SEG(irq10));
}
