/****************************************************************
 *								*
 *	Copyright 2001, 2003 Sanchez Computer Associates, Inc.	*
 *								*
 *	This source code contains the intellectual property	*
 *	of its copyright holder(s), and is made available	*
 *	under a license.  If you do not know the terms of	*
 *	the license, please stop and do not read further.	*
 *								*
 ****************************************************************/

/****************************************************************
*								*
*  This module provides translation functions between the	*
*  ASCII and EBCDIC code sets.					*
*								*
****************************************************************/



#include "mdef.h"
#include "ebc_xlat.h"


/* Translation tables */
/* These were generated using iconv between "ISO8859-1" (ASCII) */
/* and "IBM-1047" (EBCDIC));  */

/* EBCDIC to ASCII */

LITDEF unsigned char e2a[256] =
{
  /* 00 - 07: */ 0x0, 0x1, 0x2, 0x3, 0x9c, 0x9, 0x86, 0x7f,
  /* 08 - 0f: */ 0x97, 0x8d, 0x8e, 0xb, 0xc, 0xd, 0xe, 0xf,
  /* 10 - 17: */ 0x10, 0x11, 0x12, 0x13, 0x9d, 0xa, 0x8, 0x87,
  /* 18 - 1f: */ 0x18, 0x19, 0x92, 0x8f, 0x1c, 0x1d, 0x1e, 0x1f,
  /* 20 - 27: */ 0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x17, 0x1b,
  /* 28 - 2f: */ 0x88, 0x89, 0x8a, 0x8b, 0x8c, 0x5, 0x6, 0x7,
  /* 30 - 37: */ 0x90, 0x91, 0x16, 0x93, 0x94, 0x95, 0x96, 0x4,
  /* 38 - 3f: */ 0x98, 0x99, 0x9a, 0x9b, 0x14, 0x15, 0x9e, 0x1a,
  /* 40 - 47: */ 0x20, 0xa0, 0xe2, 0xe4, 0xe0, 0xe1, 0xe3, 0xe5,
  /* 48 - 4f: */ 0xe7, 0xf1, 0xa2, 0x2e, 0x3c, 0x28, 0x2b, 0x7c,
  /* 50 - 57: */ 0x26, 0xe9, 0xea, 0xeb, 0xe8, 0xed, 0xee, 0xef,
  /* 58 - 5f: */ 0xec, 0xdf, 0x21, 0x24, 0x2a, 0x29, 0x3b, 0x5e,
  /* 60 - 67: */ 0x2d, 0x2f, 0xc2, 0xc4, 0xc0, 0xc1, 0xc3, 0xc5,
  /* 68 - 6f: */ 0xc7, 0xd1, 0xa6, 0x2c, 0x25, 0x5f, 0x3e, 0x3f,
  /* 70 - 77: */ 0xf8, 0xc9, 0xca, 0xcb, 0xc8, 0xcd, 0xce, 0xcf,
  /* 78 - 7f: */ 0xcc, 0x60, 0x3a, 0x23, 0x40, 0x27, 0x3d, 0x22,
  /* 80 - 87: */ 0xd8, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67,
  /* 88 - 8f: */ 0x68, 0x69, 0xab, 0xbb, 0xf0, 0xfd, 0xfe, 0xb1,
  /* 90 - 97: */ 0xb0, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f, 0x70,
  /* 98 - 9f: */ 0x71, 0x72, 0xaa, 0xba, 0xe6, 0xb8, 0xc6, 0xa4,
  /* a0 - a7: */ 0xb5, 0x7e, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78,
  /* a8 - af: */ 0x79, 0x7a, 0xa1, 0xbf, 0xd0, 0x5b, 0xde, 0xae,
  /* b0 - b7: */ 0xac, 0xa3, 0xa5, 0xb7, 0xa9, 0xa7, 0xb6, 0xbc,
  /* b8 - bf: */ 0xbd, 0xbe, 0xdd, 0xa8, 0xaf, 0x5d, 0xb4, 0xd7,
  /* c0 - c7: */ 0x7b, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47,
  /* c8 - cf: */ 0x48, 0x49, 0xad, 0xf4, 0xf6, 0xf2, 0xf3, 0xf5,
  /* d0 - d7: */ 0x7d, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f, 0x50,
  /* d8 - df: */ 0x51, 0x52, 0xb9, 0xfb, 0xfc, 0xf9, 0xfa, 0xff,
  /* e0 - e7: */ 0x5c, 0xf7, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58,
  /* e8 - ef: */ 0x59, 0x5a, 0xb2, 0xd4, 0xd6, 0xd2, 0xd3, 0xd5,
  /* f0 - f7: */ 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37,
  /* f8 - ff: */ 0x38, 0x39, 0xb3, 0xdb, 0xdc, 0xd9, 0xda, 0x9f
};



/* ASCII to EBCDIC */

LITDEF unsigned char a2e[256] =
{
  /* 00 - 07: */ 0x0, 0x1, 0x2, 0x3, 0x37, 0x2d, 0x2e, 0x2f,
  /* 08 - 0f: */ 0x16, 0x5, 0x15, 0xb, 0xc, 0xd, 0xe, 0xf,
  /* 10 - 17: */ 0x10, 0x11, 0x12, 0x13, 0x3c, 0x3d, 0x32, 0x26,
  /* 18 - 1f: */ 0x18, 0x19, 0x3f, 0x27, 0x1c, 0x1d, 0x1e, 0x1f,
  /* 20 - 27: */ 0x40, 0x5a, 0x7f, 0x7b, 0x5b, 0x6c, 0x50, 0x7d,
  /* 28 - 2f: */ 0x4d, 0x5d, 0x5c, 0x4e, 0x6b, 0x60, 0x4b, 0x61,
  /* 30 - 37: */ 0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7,
  /* 38 - 3f: */ 0xf8, 0xf9, 0x7a, 0x5e, 0x4c, 0x7e, 0x6e, 0x6f,
  /* 40 - 47: */ 0x7c, 0xc1, 0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0xc7,
  /* 48 - 4f: */ 0xc8, 0xc9, 0xd1, 0xd2, 0xd3, 0xd4, 0xd5, 0xd6,
  /* 50 - 57: */ 0xd7, 0xd8, 0xd9, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6,
  /* 58 - 5f: */ 0xe7, 0xe8, 0xe9, 0xad, 0xe0, 0xbd, 0x5f, 0x6d,
  /* 60 - 67: */ 0x79, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87,
  /* 68 - 6f: */ 0x88, 0x89, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96,
  /* 70 - 77: */ 0x97, 0x98, 0x99, 0xa2, 0xa3, 0xa4, 0xa5, 0xa6,
  /* 78 - 7f: */ 0xa7, 0xa8, 0xa9, 0xc0, 0x4f, 0xd0, 0xa1, 0x7,
  /* 80 - 87: */ 0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x6, 0x17,
  /* 88 - 8f: */ 0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x9, 0xa, 0x1b,
  /* 90 - 97: */ 0x30, 0x31, 0x1a, 0x33, 0x34, 0x35, 0x36, 0x8,
  /* 98 - 9f: */ 0x38, 0x39, 0x3a, 0x3b, 0x4, 0x14, 0x3e, 0xff,
  /* a0 - a7: */ 0x41, 0xaa, 0x4a, 0xb1, 0x9f, 0xb2, 0x6a, 0xb5,
  /* a8 - af: */ 0xbb, 0xb4, 0x9a, 0x8a, 0xb0, 0xca, 0xaf, 0xbc,
  /* b0 - b7: */ 0x90, 0x8f, 0xea, 0xfa, 0xbe, 0xa0, 0xb6, 0xb3,
  /* b8 - bf: */ 0x9d, 0xda, 0x9b, 0x8b, 0xb7, 0xb8, 0xb9, 0xab,
  /* c0 - c7: */ 0x64, 0x65, 0x62, 0x66, 0x63, 0x67, 0x9e, 0x68,
  /* c8 - cf: */ 0x74, 0x71, 0x72, 0x73, 0x78, 0x75, 0x76, 0x77,
  /* d0 - d7: */ 0xac, 0x69, 0xed, 0xee, 0xeb, 0xef, 0xec, 0xbf,
  /* d8 - df: */ 0x80, 0xfd, 0xfe, 0xfb, 0xfc, 0xba, 0xae, 0x59,
  /* e0 - e7: */ 0x44, 0x45, 0x42, 0x46, 0x43, 0x47, 0x9c, 0x48,
  /* e8 - ef: */ 0x54, 0x51, 0x52, 0x53, 0x58, 0x55, 0x56, 0x57,
  /* f0 - f7: */ 0x8c, 0x49, 0xcd, 0xce, 0xcb, 0xcf, 0xcc, 0xe1,
  /* f8 - ff: */ 0x70, 0xdd, 0xde, 0xdb, 0xdc, 0x8d, 0x8e, 0xdf
};



void asc_to_ebc(unsigned char *estring_out, unsigned char *astring_in, int len)
{
	int i;
	unsigned char *in_ptr, *out_ptr;

	for (i = 0, in_ptr = astring_in, out_ptr = estring_out; i < len; i++, in_ptr++, out_ptr++)
		*out_ptr = a2e[*in_ptr];
}

void ebc_to_asc(unsigned char *astring_out, unsigned char *estring_in, int len)
{
	int i;
	unsigned char *in_ptr, *out_ptr;

	for (i = 0, in_ptr = estring_in, out_ptr = astring_out; i < len; i++, in_ptr++, out_ptr++)
		*out_ptr = e2a[*in_ptr];
}
