/* do not edit automatically generated by mc from decl.  */
/* decl.def declaration nodes used to create the AST.

Copyright (C) 2015-2020 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius@glam.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Modula-2; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  */


#if !defined (_decl_H)
#   define _decl_H

#   ifdef __cplusplus
extern "C" {
#   endif
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#   include "GnameKey.h"
#   include "GsymbolKey.h"
#   include "GmcReserved.h"
#   include "GmcComment.h"

#   if defined (_decl_C)
#      define EXTERN
#   else
#      define EXTERN extern
#   endif

#if !defined (decl_node_D)
#  define decl_node_D
   typedef void *decl_node;
#endif

typedef struct decl_isNodeF_p decl_isNodeF;

typedef unsigned int (*decl_isNodeF_t) (decl_node);
struct decl_isNodeF_p { decl_isNodeF_t proc; };


/*
   getDeclaredMod - returns the token number associated with the nodes declaration
                    in the implementation or program module.
*/

EXTERN unsigned int decl_getDeclaredMod (decl_node n);

/*
   getDeclaredDef - returns the token number associated with the nodes declaration
                    in the definition module.
*/

EXTERN unsigned int decl_getDeclaredDef (decl_node n);

/*
   getFirstUsed - returns the token number associated with the first use of
                  node, n.
*/

EXTERN unsigned int decl_getFirstUsed (decl_node n);

/*
   isDef - return TRUE if node, n, is a definition module.
*/

EXTERN unsigned int decl_isDef (decl_node n);

/*
   isImp - return TRUE if node, n, is an implementation module.
*/

EXTERN unsigned int decl_isImp (decl_node n);

/*
   isImpOrModule - returns TRUE if, n, is a program module or implementation module.
*/

EXTERN unsigned int decl_isImpOrModule (decl_node n);

/*
   isVisited - returns TRUE if the node was visited.
*/

EXTERN unsigned int decl_isVisited (decl_node n);

/*
   unsetVisited - unset the visited flag on a def/imp/module node.
*/

EXTERN void decl_unsetVisited (decl_node n);

/*
   setVisited - set the visited flag on a def/imp/module node.
*/

EXTERN void decl_setVisited (decl_node n);

/*
   setEnumsComplete - sets the field inside the def or imp or module, n.
*/

EXTERN void decl_setEnumsComplete (decl_node n);

/*
   getEnumsComplete - gets the field from the def or imp or module, n.
*/

EXTERN unsigned int decl_getEnumsComplete (decl_node n);

/*
   resetEnumPos - resets the index into the saved list of enums inside
                  module, n.
*/

EXTERN void decl_resetEnumPos (decl_node n);

/*
   getNextEnum - returns the next enumeration node.
*/

EXTERN decl_node decl_getNextEnum (void);

/*
   isModule - return TRUE if node, n, is a program module.
*/

EXTERN unsigned int decl_isModule (decl_node n);

/*
   isMainModule - return TRUE if node, n, is the main module specified
                  by the source file.  This might be a definition,
                  implementation or program module.
*/

EXTERN unsigned int decl_isMainModule (decl_node n);

/*
   setMainModule - sets node, n, as the main module to be compiled.
*/

EXTERN void decl_setMainModule (decl_node n);

/*
   setCurrentModule - sets node, n, as the current module being compiled.
*/

EXTERN void decl_setCurrentModule (decl_node n);

/*
   lookupDef - returns a definition module node named, n.
*/

EXTERN decl_node decl_lookupDef (nameKey_Name n);

/*
   lookupImp - returns an implementation module node named, n.
*/

EXTERN decl_node decl_lookupImp (nameKey_Name n);

/*
   lookupModule - returns a module node named, n.
*/

EXTERN decl_node decl_lookupModule (nameKey_Name n);

/*
   putDefForC - the definition module was defined FOR "C".
*/

EXTERN void decl_putDefForC (decl_node n);

/*
   lookupInScope - looks up a symbol named, n, from, scope.
*/

EXTERN decl_node decl_lookupInScope (decl_node scope, nameKey_Name n);

/*
   isConst - returns TRUE if node, n, is a const.
*/

EXTERN unsigned int decl_isConst (decl_node n);

/*
   isType - returns TRUE if node, n, is a type.
*/

EXTERN unsigned int decl_isType (decl_node n);

/*
   putType - places, exp, as the type alias to des.
             TYPE des = exp ;
*/

EXTERN void decl_putType (decl_node des, decl_node exp);

/*
   getType - returns the type associated with node, n.
*/

EXTERN decl_node decl_getType (decl_node n);

/*
   skipType - skips over type aliases.
*/

EXTERN decl_node decl_skipType (decl_node n);

/*
   putTypeHidden - marks type, des, as being a hidden type.
                   TYPE des ;
*/

EXTERN void decl_putTypeHidden (decl_node des);

/*
   isTypeHidden - returns TRUE if type, n, is hidden.
*/

EXTERN unsigned int decl_isTypeHidden (decl_node n);

/*
   hasHidden - returns TRUE if module, n, has a hidden type.
*/

EXTERN unsigned int decl_hasHidden (decl_node n);

/*
   isVar - returns TRUE if node, n, is a type.
*/

EXTERN unsigned int decl_isVar (decl_node n);

/*
   isTemporary - returns TRUE if node, n, is a variable and temporary.
*/

EXTERN unsigned int decl_isTemporary (decl_node n);

/*
   isExported - returns TRUE if symbol, n, is exported from
                the definition module.
*/

EXTERN unsigned int decl_isExported (decl_node n);

/*
   getDeclScope - returns the node representing the
                  current declaration scope.
*/

EXTERN decl_node decl_getDeclScope (void);

/*
   getScope - returns the scope associated with node, n.
*/

EXTERN decl_node decl_getScope (decl_node n);

/*
   isLiteral - returns TRUE if, n, is a literal.
*/

EXTERN unsigned int decl_isLiteral (decl_node n);

/*
   isConstSet - returns TRUE if, n, is a constant set.
*/

EXTERN unsigned int decl_isConstSet (decl_node n);

/*
   isEnumerationField - returns TRUE if, n, is an enumeration field.
*/

EXTERN unsigned int decl_isEnumerationField (decl_node n);

/*
   isEnumeration - returns TRUE if node, n, is an enumeration type.
*/

EXTERN unsigned int decl_isEnumeration (decl_node n);

/*
   isUnbounded - returns TRUE if, n, is an unbounded array.
*/

EXTERN unsigned int decl_isUnbounded (decl_node n);

/*
   isParameter - returns TRUE if, n, is a parameter.
*/

EXTERN unsigned int decl_isParameter (decl_node n);

/*
   isVarParam - returns TRUE if, n, is a var parameter.
*/

EXTERN unsigned int decl_isVarParam (decl_node n);

/*
   isParam - returns TRUE if, n, is a non var parameter.
*/

EXTERN unsigned int decl_isParam (decl_node n);

/*
   isNonVarParam - is an alias to isParam.
*/

EXTERN unsigned int decl_isNonVarParam (decl_node n);

/*
   addOptParameter - returns an optarg which has been created and added to
                     procedure node, proc.  It has a name, id, and, type,
                     and an initial value, init.
*/

EXTERN decl_node decl_addOptParameter (decl_node proc, nameKey_Name id, decl_node type, decl_node init);

/*
   isOptarg - returns TRUE if, n, is an optarg.
*/

EXTERN unsigned int decl_isOptarg (decl_node n);

/*
   isRecord - returns TRUE if, n, is a record.
*/

EXTERN unsigned int decl_isRecord (decl_node n);

/*
   isRecordField - returns TRUE if, n, is a record field.
*/

EXTERN unsigned int decl_isRecordField (decl_node n);

/*
   isVarientField - returns TRUE if, n, is a varient field.
*/

EXTERN unsigned int decl_isVarientField (decl_node n);

/*
   isArray - returns TRUE if, n, is an array.
*/

EXTERN unsigned int decl_isArray (decl_node n);

/*
   isProcType - returns TRUE if, n, is a procedure type.
*/

EXTERN unsigned int decl_isProcType (decl_node n);

/*
   isPointer - returns TRUE if, n, is a pointer.
*/

EXTERN unsigned int decl_isPointer (decl_node n);

/*
   isProcedure - returns TRUE if, n, is a procedure.
*/

EXTERN unsigned int decl_isProcedure (decl_node n);

/*
   isVarient - returns TRUE if, n, is a varient record.
*/

EXTERN unsigned int decl_isVarient (decl_node n);

/*
   isSet - returns TRUE if, n, is a set type.
*/

EXTERN unsigned int decl_isSet (decl_node n);

/*
   isSubrange - returns TRUE if, n, is a subrange type.
*/

EXTERN unsigned int decl_isSubrange (decl_node n);

/*
   isZtype - returns TRUE if, n, is the Z type.
*/

EXTERN unsigned int decl_isZtype (decl_node n);

/*
   isRtype - returns TRUE if, n, is the R type.
*/

EXTERN unsigned int decl_isRtype (decl_node n);

/*
   makeConst - create, initialise and return a const node.
*/

EXTERN decl_node decl_makeConst (nameKey_Name n);

/*
   putConst - places value, v, into node, n.
*/

EXTERN void decl_putConst (decl_node n, decl_node v);

/*
   makeType - create, initialise and return a type node.
*/

EXTERN decl_node decl_makeType (nameKey_Name n);

/*
   makeTypeImp - lookup a type in the definition module
                 and return it.  Otherwise create a new type.
*/

EXTERN decl_node decl_makeTypeImp (nameKey_Name n);

/*
   makeVar - create, initialise and return a var node.
*/

EXTERN decl_node decl_makeVar (nameKey_Name n);

/*
   putVar - places, type, as the type for var.
*/

EXTERN void decl_putVar (decl_node var, decl_node type, decl_node decl);

/*
   makeVarDecl - creates a variable declaration list from
                 identlist, i, and, type, in the current scope.
*/

EXTERN decl_node decl_makeVarDecl (decl_node i, decl_node type);

/*
   makeEnum - creates an enumerated type and returns the node.
*/

EXTERN decl_node decl_makeEnum (void);

/*
   makeEnumField - returns an enumeration field, named, n.
*/

EXTERN decl_node decl_makeEnumField (decl_node e, nameKey_Name n);

/*
   makeSubrange - returns a subrange node, built from range: low..high.
*/

EXTERN decl_node decl_makeSubrange (decl_node low, decl_node high);

/*
   putSubrangeType - assigns, type, to the subrange type, sub.
*/

EXTERN void decl_putSubrangeType (decl_node sub, decl_node type);

/*
   makePointer - returns a pointer of, type, node.
*/

EXTERN decl_node decl_makePointer (decl_node type);

/*
   makeSet - returns a set of, type, node.
*/

EXTERN decl_node decl_makeSet (decl_node type);

/*
   makeArray - returns a node representing ARRAY subrange OF type.
*/

EXTERN decl_node decl_makeArray (decl_node subr, decl_node type);

/*
   putUnbounded - sets array, n, as unbounded.
*/

EXTERN void decl_putUnbounded (decl_node n);

/*
   makeRecord - creates and returns a record node.
*/

EXTERN decl_node decl_makeRecord (void);

/*
   makeVarient - creates a new symbol, a varient symbol for record or varient field
                 symbol, r.
*/

EXTERN decl_node decl_makeVarient (decl_node r);

/*
   addFieldsToRecord - adds fields, i, of type, t, into a record, r.
                       It returns, r.
*/

EXTERN decl_node decl_addFieldsToRecord (decl_node r, decl_node v, decl_node i, decl_node t);

/*
   buildVarientSelector - builds a field of name, tag, of, type, t, varient, r.
*/

EXTERN void decl_buildVarientSelector (decl_node r, decl_node v, nameKey_Name tag, decl_node type);

/*
   buildVarientFieldRecord - builds a varient field into a varient symbol, v.
                             The varient field is returned.
*/

EXTERN decl_node decl_buildVarientFieldRecord (decl_node v, decl_node p);

/*
   getSymName - returns the name of symbol, n.
*/

EXTERN nameKey_Name decl_getSymName (decl_node n);

/*
   import - attempts to add node, n, into the scope of module, m.
            It might fail due to a name clash in which case the
            previous named symbol is returned.  On success, n,
            is returned.
*/

EXTERN decl_node decl_import (decl_node m, decl_node n);

/*
   lookupExported - attempts to lookup a node named, i, from definition
                    module, n.  The node is returned if found.
                    NIL is returned if not found.
*/

EXTERN decl_node decl_lookupExported (decl_node n, nameKey_Name i);

/*
   lookupSym - returns the symbol named, n, from the scope stack.
*/

EXTERN decl_node decl_lookupSym (nameKey_Name n);

/*
   addImportedModule - add module, i, to be imported by, m.
                       If scoped then module, i, is added to the
                       module, m, scope.
*/

EXTERN void decl_addImportedModule (decl_node m, decl_node i, unsigned int scoped);

/*
   setSource - sets the source filename for module, n, to s.
*/

EXTERN void decl_setSource (decl_node n, nameKey_Name s);

/*
   getSource - returns the source filename for module, n.
*/

EXTERN nameKey_Name decl_getSource (decl_node n);

/*
   getMainModule - returns the main module node.
*/

EXTERN decl_node decl_getMainModule (void);

/*
   getCurrentModule - returns the current module being compiled.
*/

EXTERN decl_node decl_getCurrentModule (void);

/*
   foreachDefModuleDo - foreach definition node, n, in the module universe,
                        call p (n).
*/

EXTERN void decl_foreachDefModuleDo (symbolKey_performOperation p);

/*
   foreachModModuleDo - foreach implementation or module node, n, in the module universe,
                        call p (n).
*/

EXTERN void decl_foreachModModuleDo (symbolKey_performOperation p);

/*
   enterScope - pushes symbol, n, to the scope stack.
*/

EXTERN void decl_enterScope (decl_node n);

/*
   leaveScope - removes the top level scope and all enumeration transparent scopes.
*/

EXTERN void decl_leaveScope (void);

/*
   makeProcedure - create, initialise and return a procedure node.
*/

EXTERN decl_node decl_makeProcedure (nameKey_Name n);

/*
   putCommentDefProcedure - remembers the procedure comment (if it exists) as a
                            definition module procedure heading.  NIL is placed
                            if there is no procedure comment available.
*/

EXTERN void decl_putCommentDefProcedure (decl_node n);

/*
   putCommentModProcedure - remembers the procedure comment (if it exists) as an
                            implementation/program module procedure heading.  NIL is placed
                            if there is no procedure comment available.
*/

EXTERN void decl_putCommentModProcedure (decl_node n);

/*
   makeProcType - returns a proctype node.
*/

EXTERN decl_node decl_makeProcType (void);

/*
   putReturnType - sets the return type of procedure or proctype, proc, to, type.
*/

EXTERN void decl_putReturnType (decl_node proc, decl_node type);

/*
   putOptReturn - sets, proctype or procedure, proc, to have an optional return type.
*/

EXTERN void decl_putOptReturn (decl_node proc);

/*
   makeVarParameter - returns a var parameter node with namelist and type.
                      Where the parameters are declared as l: type.
*/

EXTERN decl_node decl_makeVarParameter (decl_node l, decl_node type, decl_node proc);

/*
   makeNonVarParameter - returns a non var parameter node with namelist and type.
                         Where the parameters are declared as l: type.
*/

EXTERN decl_node decl_makeNonVarParameter (decl_node l, decl_node type, decl_node proc);

/*
   paramEnter - reset the parameter count.
*/

EXTERN void decl_paramEnter (decl_node n);

/*
   paramLeave - set paramater checking to TRUE from now onwards.
*/

EXTERN void decl_paramLeave (decl_node n);

/*
   makeIdentList - returns a node which will be used to maintain an ident list.
*/

EXTERN decl_node decl_makeIdentList (void);

/*
   putIdent - places ident, i, into identlist, n.
*/

EXTERN unsigned int decl_putIdent (decl_node n, nameKey_Name i);

/*
   addVarParameters - adds the identlist, i, of, type, to be VAR parameters
                      in procedure, n.
*/

EXTERN void decl_addVarParameters (decl_node n, decl_node i, decl_node type);

/*
   addNonVarParameters - adds the identlist, i, of, type, to be parameters
                         in procedure, n.
*/

EXTERN void decl_addNonVarParameters (decl_node n, decl_node i, decl_node type);

/*
   makeVarargs - returns a varargs node.
*/

EXTERN decl_node decl_makeVarargs (void);

/*
   isVarargs - returns TRUE if, n, is a varargs node.
*/

EXTERN unsigned int decl_isVarargs (decl_node n);

/*
   addParameter - adds a parameter, param, to procedure or proctype, proc.
*/

EXTERN void decl_addParameter (decl_node proc, decl_node param);

/*
   makeBinaryTok - creates and returns a boolean type node with,
                   l, and, r, nodes.
*/

EXTERN decl_node decl_makeBinaryTok (mcReserved_toktype op, decl_node l, decl_node r);

/*
   makeUnaryTok - creates and returns a boolean type node with,
                  e, node.
*/

EXTERN decl_node decl_makeUnaryTok (mcReserved_toktype op, decl_node e);

/*
   makeComponentRef - build a componentref node which accesses, field,
                      within, record, rec.
*/

EXTERN decl_node decl_makeComponentRef (decl_node rec, decl_node field);

/*
   makePointerRef - build a pointerref node which accesses, field,
                    within, pointer to record, ptr.
*/

EXTERN decl_node decl_makePointerRef (decl_node ptr, decl_node field);

/*
   isPointerRef - returns TRUE if, n, is a pointerref node.
*/

EXTERN unsigned int decl_isPointerRef (decl_node n);

/*
   makeDeRef - dereferences the pointer defined by, n.
*/

EXTERN decl_node decl_makeDeRef (decl_node n);

/*
   makeArrayRef - build an arrayref node which access element,
                  index, in, array.  array is a variable/expression/constant
                  which has a type array.
*/

EXTERN decl_node decl_makeArrayRef (decl_node array, decl_node index);

/*
   getLastOp - return the right most non leaf node.
*/

EXTERN decl_node decl_getLastOp (decl_node n);

/*
   getCardinal - returns the cardinal type node.
*/

EXTERN decl_node decl_getCardinal (void);

/*
   makeLiteralInt - creates and returns a literal node based on an integer type.
*/

EXTERN decl_node decl_makeLiteralInt (nameKey_Name n);

/*
   makeLiteralReal - creates and returns a literal node based on a real type.
*/

EXTERN decl_node decl_makeLiteralReal (nameKey_Name n);

/*
   makeString - creates and returns a node containing string, n.
*/

EXTERN decl_node decl_makeString (nameKey_Name n);

/*
   makeSetValue - creates and returns a setvalue node.
*/

EXTERN decl_node decl_makeSetValue (void);

/*
   isSetValue - returns TRUE if, n, is a setvalue node.
*/

EXTERN unsigned int decl_isSetValue (decl_node n);

/*
   putSetValue - assigns the type, t, to the set value, n.  The
                 node, n, is returned.
*/

EXTERN decl_node decl_putSetValue (decl_node n, decl_node t);

/*
   includeSetValue - includes the range l..h into the setvalue.
                     h might be NIL indicating that a single element
                       is to be included into the set.
                     n is returned.
*/

EXTERN decl_node decl_includeSetValue (decl_node n, decl_node l, decl_node h);

/*
   getBuiltinConst - creates and returns a builtin const if available.
*/

EXTERN decl_node decl_getBuiltinConst (nameKey_Name n);

/*
   makeExpList - creates and returns an expList node.
*/

EXTERN decl_node decl_makeExpList (void);

/*
   isExpList - returns TRUE if, n, is an explist node.
*/

EXTERN unsigned int decl_isExpList (decl_node n);

/*
   putExpList - places, expression, e, within the explist, n.
*/

EXTERN void decl_putExpList (decl_node n, decl_node e);

/*
   makeConstExp - returns a constexp node.
*/

EXTERN decl_node decl_makeConstExp (void);

/*
   getNextConstExp - returns the next constexp node.
*/

EXTERN decl_node decl_getNextConstExp (void);

/*
   setConstExpComplete - sets the field inside the def or imp or module, n.
*/

EXTERN void decl_setConstExpComplete (decl_node n);

/*
   fixupConstExp - assign fixup expression, e, into the argument of, c.
*/

EXTERN decl_node decl_fixupConstExp (decl_node c, decl_node e);

/*
   resetConstExpPos - resets the index into the saved list of constexps inside
                      module, n.
*/

EXTERN void decl_resetConstExpPos (decl_node n);

/*
   makeFuncCall - builds a function call to c with param list, n.
*/

EXTERN decl_node decl_makeFuncCall (decl_node c, decl_node n);

/*
   makeStatementSequence - create and return a statement sequence node.
*/

EXTERN decl_node decl_makeStatementSequence (void);

/*
   isStatementSequence - returns TRUE if node, n, is a statement sequence.
*/

EXTERN unsigned int decl_isStatementSequence (decl_node n);

/*
   addStatement - adds node, n, as a statement to statememt sequence, s.
*/

EXTERN void decl_addStatement (decl_node s, decl_node n);

/*
   addCommentBody - adds a body comment to a statement sequence node.
*/

EXTERN void decl_addCommentBody (decl_node n);

/*
   addCommentAfter - adds an after comment to a statement sequence node.
*/

EXTERN void decl_addCommentAfter (decl_node n);

/*
   addIfComments - adds the, body, and, after, comments to if node, n.
*/

EXTERN void decl_addIfComments (decl_node n, decl_node body, decl_node after);

/*
   addElseComments - adds the, body, and, after, comments to an, if, or an elsif, node, n.
*/

EXTERN void decl_addElseComments (decl_node n, decl_node body, decl_node after);

/*
   addIfEndComments - adds the, body, and, after, comments to an, if, node, n.
*/

EXTERN void decl_addIfEndComments (decl_node n, decl_node body, decl_node after);

/*
   makeReturn - creates and returns a return node.
*/

EXTERN decl_node decl_makeReturn (void);

/*
   isReturn - returns TRUE if node, n, is a return.
*/

EXTERN unsigned int decl_isReturn (decl_node n);

/*
   putReturn - assigns node, e, as the expression on the return node.
*/

EXTERN void decl_putReturn (decl_node n, decl_node e);

/*
   makeWhile - creates and returns a while node.
*/

EXTERN decl_node decl_makeWhile (void);

/*
   putWhile - places an expression, e, and statement sequence, s, into the while
              node, n.
*/

EXTERN void decl_putWhile (decl_node n, decl_node e, decl_node s);

/*
   isWhile - returns TRUE if node, n, is a while.
*/

EXTERN unsigned int decl_isWhile (decl_node n);

/*
   addWhileDoComment - adds body and after comments to while node, w.
*/

EXTERN void decl_addWhileDoComment (decl_node w, decl_node body, decl_node after);

/*
   addWhileEndComment - adds body and after comments to the end of a while node, w.
*/

EXTERN void decl_addWhileEndComment (decl_node w, decl_node body, decl_node after);

/*
   makeAssignment - creates and returns an assignment node.
                    The designator is, d, and expression, e.
*/

EXTERN decl_node decl_makeAssignment (decl_node d, decl_node e);

/*
   putBegin - assigns statements, s, to be the normal part in
              block, b.  The block may be a procedure or module,
              or implementation node.
*/

EXTERN void decl_putBegin (decl_node b, decl_node s);

/*
   putFinally - assigns statements, s, to be the final part in
                block, b.  The block may be a module
                or implementation node.
*/

EXTERN void decl_putFinally (decl_node b, decl_node s);

/*
   makeExit - creates and returns an exit node.
*/

EXTERN decl_node decl_makeExit (decl_node l, unsigned int n);

/*
   isExit - returns TRUE if node, n, is an exit.
*/

EXTERN unsigned int decl_isExit (decl_node n);

/*
   makeLoop - creates and returns a loop node.
*/

EXTERN decl_node decl_makeLoop (void);

/*
   isLoop - returns TRUE if, n, is a loop node.
*/

EXTERN unsigned int decl_isLoop (decl_node n);

/*
   putLoop - places statement sequence, s, into loop, l.
*/

EXTERN void decl_putLoop (decl_node l, decl_node s);

/*
   makeComment - creates and returns a comment node.
*/

EXTERN decl_node decl_makeComment (char *a_, unsigned int _a_high);

/*
   makeCommentS - creates and returns a comment node.
*/

EXTERN decl_node decl_makeCommentS (mcComment_commentDesc c);

/*
   makeIf - creates and returns an if node.  The if node
            will have expression, e, and statement sequence, s,
            as the then component.
*/

EXTERN decl_node decl_makeIf (decl_node e, decl_node s);

/*
   isIf - returns TRUE if, n, is an if node.
*/

EXTERN unsigned int decl_isIf (decl_node n);

/*
   makeElsif - creates and returns an elsif node.
               This node has an expression, e, and statement
               sequence, s.
*/

EXTERN decl_node decl_makeElsif (decl_node i, decl_node e, decl_node s);

/*
   isElsif - returns TRUE if node, n, is an elsif node.
*/

EXTERN unsigned int decl_isElsif (decl_node n);

/*
   putElse - the else is grafted onto the if/elsif node, i,
             and the statement sequence will be, s.
*/

EXTERN void decl_putElse (decl_node i, decl_node s);

/*
   makeFor - creates and returns a for node.
*/

EXTERN decl_node decl_makeFor (void);

/*
   isFor - returns TRUE if node, n, is a for node.
*/

EXTERN unsigned int decl_isFor (decl_node n);

/*
   putFor - assigns the fields of the for node with
            ident, i,
            start, s,
            end, e,
            increment, i,
            statements, sq.
*/

EXTERN void decl_putFor (decl_node f, decl_node i, decl_node s, decl_node e, decl_node b, decl_node sq);

/*
   makeRepeat - creates and returns a repeat node.
*/

EXTERN decl_node decl_makeRepeat (void);

/*
   isRepeat - returns TRUE if node, n, is a repeat node.
*/

EXTERN unsigned int decl_isRepeat (decl_node n);

/*
   putRepeat - places statements, s, and expression, e, into
               repeat statement, n.
*/

EXTERN void decl_putRepeat (decl_node n, decl_node s, decl_node e);

/*
   addRepeatComment - adds body and after comments to repeat node, r.
*/

EXTERN void decl_addRepeatComment (decl_node r, decl_node body, decl_node after);

/*
   addUntilComment - adds body and after comments to the until section of a repeat node, r.
*/

EXTERN void decl_addUntilComment (decl_node r, decl_node body, decl_node after);

/*
   makeCase - builds and returns a case statement node.
*/

EXTERN decl_node decl_makeCase (void);

/*
   isCase - returns TRUE if node, n, is a case statement.
*/

EXTERN unsigned int decl_isCase (decl_node n);

/*
   putCaseExpression - places expression, e, into case statement, n.
                       n is returned.
*/

EXTERN decl_node decl_putCaseExpression (decl_node n, decl_node e);

/*
   putCaseElse - places else statement, e, into case statement, n.
                 n is returned.
*/

EXTERN decl_node decl_putCaseElse (decl_node n, decl_node e);

/*
   putCaseStatement - places a caselist, l, and associated
                      statement sequence, s, into case statement, n.
                      n is returned.
*/

EXTERN decl_node decl_putCaseStatement (decl_node n, decl_node l, decl_node s);

/*
   makeCaseLabelList - creates and returns a caselabellist node.
*/

EXTERN decl_node decl_makeCaseLabelList (decl_node l, decl_node s);

/*
   isCaseLabelList - returns TRUE if, n, is a caselabellist.
*/

EXTERN unsigned int decl_isCaseLabelList (decl_node n);

/*
   makeCaseList - creates and returns a case statement node.
*/

EXTERN decl_node decl_makeCaseList (void);

/*
   isCaseList - returns TRUE if, n, is a case list.
*/

EXTERN unsigned int decl_isCaseList (decl_node n);

/*
   putCaseRange - places the case range lo..hi into caselist, n.
*/

EXTERN decl_node decl_putCaseRange (decl_node n, decl_node lo, decl_node hi);

/*
   makeRange - creates and returns a case range.
*/

EXTERN decl_node decl_makeRange (decl_node lo, decl_node hi);

/*
   isRange - returns TRUE if node, n, is a range.
*/

EXTERN unsigned int decl_isRange (decl_node n);

/*
   dupExpr - duplicate the expression nodes, it does not duplicate
             variables, literals, constants but only the expression
             operators (including function calls and parameter lists).
*/

EXTERN decl_node decl_dupExpr (decl_node n);

/*
   setLangC - set the target language as ansi C.
*/

EXTERN void decl_setLangC (void);

/*
   setLangCP - set the target language as C++.
*/

EXTERN void decl_setLangCP (void);

/*
   setLangM2 - set the target language as Modula-2.
*/

EXTERN void decl_setLangM2 (void);

/*
   out - walks the tree of node declarations for the main module
         and writes the output to the outputFile specified in
         mcOptions.  It outputs the declarations in the language
         specified above.
*/

EXTERN void decl_out (void);
#   ifdef __cplusplus
}
#   endif

#   undef EXTERN
#endif
