{
    package GCLang::ZH_CN;

    use utf8;
###################################################
#
#  Copyright 2005-2010 Christian Jodar
#
#  This file is part of GCstar.
#
#  GCstar is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  GCstar is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with GCstar; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###################################################
    
    use strict;
    use base 'Exporter';

    our @EXPORT = qw(%lang);

    our %lang = (

        'LangName' => '中文(简体)',
        
        'Separator' => ': ',
        
        'Warning' => '<b>警告</b>:
        
透过插件从网站上下载的资讯<b>仅限於个人使用</b>。

没有<b>获取额外授权</b>的任何二次转发行为都是非法的。

若想确认哪个网站拥有这些资讯，您可以使用<b>项目细节下的按钮</b>。',
        
        'AllItemsFiltered' => '没有{X}匹配过滤器要求',
        
#Installation
        'InstallDirInfo' => '安装到',
        'InstallMandatory' => '必要组件',
        'InstallOptional' => '可选组件',
        'InstallErrorMissing' => '错误：以下Perl组件必须被安装：',
        'InstallPrompt' => '安装的根目录[/usr/local]: ',
        'InstallEnd' => '安装完毕',
        'InstallNoError' => '没有错误',
        'InstallLaunch' => '想使用这个应用程序，请点击一下',
        'InstallDirectory' => '安装目录',
        'InstallTitle' => 'GCstar 安装程序',
        'InstallDependencies' => '依赖组件',
        'InstallPath' => '路径',
        'InstallOptions' => '选项',
        'InstallSelectDirectory' => '选择安装目录',
        'InstallWithClean' => '删除安装目录中的文件',
        'InstallWithMenu' => '将GCstar添加到应用程序菜单',
        'InstallNoPermission' => '错误：您没有写入指定目录的权限',
        'InstallMissingMandatory' => '必要依赖组件不存在。在获取这些组件前，您不能够安装GCstar。',
        'InstallMissingOptional' => '部份选择依赖组件不存在。详细列表显示于下。 GCstar或许可以安装，但部份功能将会失效。',
        'InstallMissingNone' => '没有任何依赖问题，您可以继续并安装GCstar',
        'InstallOK' => '完成',
        'InstallMissing' => '不存在',
        'InstallMissingFor' => '不存在',
        'InstallCleanDirectory' => '删除目录中的GCstar文件：',
        'InstallCopyDirectory' => '将文件复制到目录：',
        'InstallCopyDesktop' => '复制桌面文件：',

#Update
        'UpdateUseProxy' => '使用代理(如果没有使用代理直接按下ENTER)：',
        'UpdateNoPermission' => '这个目录没有写入权限：',
        'UpdateNone' => '没有发现更新',
        'UpdateFileNotFound' => '文件不存在',

#Splash
        'SplashInit' => '初始化',
        'SplashLoad' => '加载收藏',
        'SplashDisplay' => '正在显示收藏',
        'SplashSort' => '排序收藏',
        'SplashDone' => '准备完成',

#Import from GCfilms
        'GCfilmsImportQuestion' => '您似乎以前用过GCfilms，您想要导入GCfilms资料到GCstar中吗(这不会破坏您的GCfilms资料)？',
        'GCfilmsImportOptions' => '设置',
        'GCfilmsImportData' => '电影列表',

#Menus
        'MenuFile' => '文件(_F)',
            'MenuNewList' => '新收藏(_N)',
            'MenuStats' => '统计',
            'MenuHistory' => '最近使用的收藏(_R)',
            'MenuLend' => '显示被借走的东西(_B)',
            'MenuImport' => '导入(_I)',	
            'MenuExport' => '导出(_E)',
            'MenuAddItem' => '添加{1}(_A)', # Accepts model codes
    
        'MenuEdit'  => '编辑(_E)',
            'MenuDuplicate' => '复制{1}(_p)',
            'MenuDuplicatePlural' => '复制{X}(_p)',
            'MenuEditSelectAllItems' => '选择所有{X}(_A)', # Accepts model codes
            'MenuEditDeleteCurrent' => '删除{1}(_R)',
            'MenuEditDeleteCurrentPlural' => '删除{X}(_R)',
            'MenuEditFields' => '变更收藏字段(_C)',
            'MenuEditLockItems' => '锁定收藏(_L)',
    
        'MenuDisplay' => '过滤器(_i)',
            'MenuSavedSearches' => '保存搜索',
                'MenuSavedSearchesSave' => '保存当前搜索',
                'MenuSavedSearchesEdit' => '变更已经保存的搜索',
            'MenuAdvancedSearch' => '高级搜索(_d)',
            'MenuViewAllItems' => '显示全部{X}(_A)',
            'MenuNoFilter' => '全部(_A)',
    
        'MenuConfiguration' => '设置(_S)',
            'MenuDisplayMenu' => 'Display',
                'MenuDisplayFullScreen' => 'Full screen',
                'MenuDisplayMenuBar' => 'Menus',
                'MenuDisplayToolBar' => 'Toolbar',
                'MenuDisplayStatusBar' => 'Bottom bar',
            'MenuDisplayOptions' => '显示信息(_D)',
            'MenuBorrowers' => '出借对象(_B)',
            'MenuToolbarConfiguration' => '工具栏控制(_T)',
            'MenuDefaultValues' => 'Default values for new item', # Accepts model codes
            'MenuGenresConversion' => '类型转换(_C)',
        
        'MenuBookmarks' => '我的收藏(_C)',
            'MenuBookmarksAdd' => '添加到当前收藏(_A)',
            'MenuBookmarksEdit' => '编辑添加到书签的收藏(_E)',

        'MenuHelp' => '帮助(_H)',
            'MenuHelpContent' => '内容(_C)',
            'MenuAllPlugins' => '查看插件(_P)',
            'MenuBugReport' => '报告问题',
            'MenuAbout' => '关于GCstar(_A)',
    
        'MenuNewWindow' => '在新窗口中显示{1}(_N)',
        'MenuNewWindowPlural' => '在新窗口中显示{X}(_N)',
        
        'ContextExpandAll' => '展开全部',
        'ContextCollapseAll' => '折叠全部',
        'ContextChooseImage' => '选择图片(_I)',
        'ContextOpenWith' => '用指定程序打开(_h)...',
        'ContextImageEditor' => '图像编辑器',
        'ContextImgFront' => '封面',
        'ContextImgBack' => '封底',
        'ContextChooseFile' => '请选择要使用的文件',
        'ContextChooseFolder' => '选择一个目录',

        'DialogEnterNumber' => '请输入数值',

        'RemoveConfirm' => '您确定要删除这个{X}？',
        'RemoveConfirmPlural' => '您确定要删除这个{X}？',
        'DefaultNewItem' => '新{X}',
        'NewItemTooltip' => '添加一个新{1}',
        'NoItemFound' => '没有发现，想要搜索其他站点吗？',
        'OpenList' => '请选择收藏',
        'SaveList' => '请选择要将这个收藏保存在哪里？',
        'SaveListTooltip' => '保存当前的收藏',
        'SaveUnsavedChanges' => '您收藏中的变更还未保存，现在保存吗？',
        'SaveDontSave' => '不保存',
        'PreferencesTooltip' => '设置',
        'ViewTooltip' => '改变收藏显示',
        'PlayTooltip' => '针对{1}启动文件关联',
        'PlayFileNotFound' => '在指定位置上没有发现目标文件：',
        'PlayRetry' => '重试',

        'StatusSave' => '保存中...',
        'StatusLoad' => '载入中...',
        'StatusSearch' => '搜索正在进行...',
        'StatusGetInfo' => '取得资讯...',
        'StatusGetImage' => '取得图片...',
                
        'SaveError' => '不能保存项目列表，请检查文件存取权限与剩余软盘空间。',
        'OpenError' => '不能开启项目列表，请检查文件存取权限。',
        'OpenFormatError' => '不能开启项目列表，因为文件格式不正确。',
        'OpenVersionWarning' => '本收藏由更新版本的GCstar建立。如果您保存，您可能会失去某些信息。',
        'OpenVersionQuestion' => '您依然想继续吗？',
        'ImageError' => '选择保存图片的目录不正确，请选择另一个。',
        'OptionsCreationError'=> '不能建立设置档。',
        'OptionsOpenError'=> '不能打开设置档：',
        'OptionsSaveError'=> '不能保存设置档：',
        'ErrorModelNotFound' => '未发现模块：',
        'ErrorModelUserDir' => '使用者定义模块在：',
        
        'RandomTooltip' => '今天晚上看什么?',
        'RandomError'=> '没有{X}可供选择',
        'RandomEnd'=> '没有更多{X}',
        'RandomNextTip'=> '下一个建议',
        'RandomOkTip'=> '接受这个建议',
        
        'AboutTitle' => '关于GCstar',
        'AboutDesc' => '个人收藏品管理器',
        'AboutVersion' => '版本',
        'AboutTeam' => '团队',
        'AboutWho' => 'Christian Jodar (Tian): 项目管理, 程序员
Nyall Dawson (Zombiepig): 程序员
TPF: 程序员
Adolfo González: 程序员
',
        'AboutLicense' => '以GNU GPL授权发佈
Logos Copyright le Spektre',
        'AboutTranslation' => '简体中文翻译由白文斯密制作',
        'AboutDesign' => 'Łukasz Kowalczk (Qoolman): 皮肤设计
Logo和网络设计： le Spektre',

        'UnsavedCollection' => '未保存的收藏',
        'ModelsSelect' => '选择一个收藏类型',
        'ModelsPersonal' => '个人模块',
        'ModelsDefault' => '默认模块',
        'ModelsList' => '收藏定义',
        'ModelSettings' => '收藏设置',
        'ModelNewType' => '新的收藏类型',
        'ModelName' => '收藏类型的名字：',
		'ModelFields' => '字段',
		'ModelOptions'	=> '选项',
		'ModelFilters'	=> '过滤器',
        'ModelNewField' => '新字段',
        'ModelFieldInformation' => '资讯',
        'ModelFieldName' => '字段名称：',
        'ModelFieldType' => '类型：',
        'ModelFieldGroup' => '组別：',
        'ModelFieldValues' => '值',
        'ModelFieldInit' => '默认：',
        'ModelFieldMin' => '最小：',
        'ModelFieldMax' => '最大：',
        'ModelFieldList' => '列表：',
        'ModelFieldListLegend' => '<i>用半角逗号分隔</i>',
        'ModelFieldDisplayAs' => '显示成：',
        'ModelFieldDisplayAsText' => '文字',
        'ModelFieldDisplayAsGraphical' => '评分条',
        'ModelFieldTypeShortText' => '短文字',
        'ModelFieldTypeLongText' => '长文字',
        'ModelFieldTypeYesNo' => '布尔值',
        'ModelFieldTypeNumber' => '数字',
        'ModelFieldTypeDate' => '日期',
        'ModelFieldTypeOptions' => '预定义选择列表',
        'ModelFieldTypeImage' => '图片',
        'ModelFieldTypeSingleList' => '简表',
        'ModelFieldTypeFile' => '文件',
        'ModelFieldTypeFormatted' => '依赖其他字段',
        'ModelFieldParameters' => '变量',
        'ModelFieldHasHistory' => '使用历史信息',
        'ModelFieldFlat' => '单行显示',
        'ModelFieldStep' => '步长：',
        'ModelFieldFileFormat' => '文件格式：',
        'ModelFieldFileFile' => '一般文件',
        'ModelFieldFileImage' => '图片',
        'ModelFieldFileVideo' => '影片',
        'ModelFieldFileAudio' => '音频',
        'ModelFieldFileProgram' => '程序',
        'ModelFieldFileUrl' => '统一资源定义符(URL)',
        'ModelFieldFileEbook' => '电子书',
        'ModelOptionsFields' => '使用字段',
        'ModelOptionsFieldsAuto' => '自动',
        'ModelOptionsFieldsNone' => '无',
        'ModelOptionsFieldsTitle' => '作为标题',
        'ModelOptionsFieldsId' => '作为ID',
        'ModelOptionsFieldsCover' => '作为封面',
        'ModelOptionsFieldsPlay' => '连接播放按钮',
        'ModelCollectionSettings' => '收藏设置',
        'ModelCollectionSettingsLending' => '可被借出',
        'ModelCollectionSettingsTagging' => '可加标签',
        'ModelFilterActivated' => '收录进搜索框内',
        'ModelFilterComparison' => '比较',
        'ModelFilterContain' => '含有',
        'ModelFilterDoesNotContain' => '未含有',
        'ModelFilterRegexp' => '正则表示式',
        'ModelFilterRange' => '范围',
        'ModelFilterNumeric' => '以数字比较',
        'ModelFilterQuick' => '建立一个快速过滤器',
        'ModelTooltipName' => '建立名字以供其他收藏使用。如果空白，相关设置会直接保存在收藏里面。',
        'ModelTooltipLabel' => '用来显示的字段名称',
        'ModelTooltipGroup' => '供字段的分组使用，不设置会将字段归入默认分组',
        'ModelTooltipHistory' => '过去的输入值将会被建成列表供选择',
        'ModelTooltipFormat' => '格式将会决定播放按钮关联到什么程序',
        'ModelTooltipLending' => '这会在收藏里添加一些字段来管理借出资讯',
        'ModelTooltipTagging' => '这会添加一些字段来管理标签',
        'ModelTooltipNumeric' => '这个值将会被当作数字来比较',
        'ModelTooltipQuick' => '这将会在“过滤器”下添加一个子菜单',
        
        'ResultsTitle' => '选择一个{X}',
        'ResultsNextTip' => '搜索下一个网站',
        'ResultsPreview' => '预览',
        'ResultsInfo' => '借由按住Ctrl或shift键，您可以添加多个项目到收藏中',
        
        'OptionsTitle' => '设置',
		'OptionsExpertMode' => '专家模式',
        'OptionsPrograms' => '对不同类型的文件用不同的程序开启，若留白则使用系统默认值',
        'OptionsBrowser' => '网页浏览器',
        'OptionsPlayer' => '影片播放器',
        'OptionsAudio' => '音频播放器',
        'OptionsImageEditor' => '图像编辑器',
        'OptionsCdDevice' => 'CD设备',
        'OptionsImages' => '图片目录',
        'OptionsUseRelativePaths' => '对图片使用相对路径',
        'OptionsLayout' => '窗口布局方式',
        'OptionsStatus' => '显示状态条',
        'OptionsUseStars' => '使用星号来显示评分',
        'OptionsWarning' => '警告：改变这个标签页后必须要重启程序才会生效。',
        'OptionsRemoveConfirm' => '在项目删除前要求确认',
        'OptionsAutoSave' => '自动保存收藏',
        'OptionsAutoLoad' => '在启动时载入先前的收藏',
        'OptionsSplash' => '显示启动画面',
        'OptionsTearoffMenus' => '允许撕开菜单',
        'OptionsSpellCheck' => '在长文字字段使用语法检查',
        'OptionsProgramTitle' => '选择使用的程序',
		'OptionsPlugins' => '从哪些网站取得项目资料',
		'OptionsAskPlugins' => '询问 (全部网站)',
		'OptionsPluginsMulti' => '多数网站',
		'OptionsPluginsMultiAsk' => '询问 (多数网站)',
        'OptionsPluginsMultiPerField' => '多个网站(每个字段)',
        'OptionsPluginsMultiPerFieldWindowTitle' => '多个网站的顺序',
        'OptionsPluginsMultiPerFieldDesc' => '每个字段将填入从左开始第一个非空信息',
        'OptionsPluginsMultiPerFieldFirst' => '第一',
        'OptionsPluginsMultiPerFieldLast' => '最后',
        'OptionsPluginsMultiPerFieldRemove' => '删除',
        'OptionsPluginsMultiPerFieldClearSelected' => '清空选择字段列表',
		'OptionsPluginsList' => '设置列表',
        'OptionsAskImport' => '选择字段来汇入',
		'OptionsProxy' => '使用代理',
		'OptionsCookieJar' => '使用cookie jar文件',
        'OptionsLang' => '语言',
        'OptionsMain' => '主要',
        'OptionsPaths' => '路径',
        'OptionsInternet' => '网络',
        'OptionsConveniences' => '其他特征',
        'OptionsDisplay' => '显示',
        'OptionsToolbar' => '工具列',
        'OptionsToolbars' => {0 => '无', 1 => '小', 2 => '大', 3 => '系统设置'},
        'OptionsToolbarPosition' => '位置',
        'OptionsToolbarPositions' => {0 => '上', 1 => '下', 2 => '左', 3 => '右'},
        'OptionsExpandersMode' => '过长的文字',
        'OptionsExpandersModes' => {'asis' => '不管它', 'cut' => '切断', 'wrap' => '自动换行'},
        'OptionsDateFormat' => '日期格式',
        'OptionsDateFormatTooltip' => '使用strftime(3)格式，默认值为%d/%m/%Y',
        'OptionsView' => '项目列表',
        'OptionsViews' => {0 => '文字', 1 => '图片', 2 => '细节'},
        'OptionsColumns' => '栏',
        'OptionsMailer' => '寄信程序',
        'OptionsSMTP' => '服务器',
        'OptionsFrom' => '您的e-mail',
        'OptionsTransform' => '将冠词放在标题的末尾',
        'OptionsArticles' => '冠词(用逗点分开)',
        'OptionsSearchStop' => '允许搜索被放弃',
        'OptionsBigPics' => '在可以的状况下使用大图片',
        'OptionsAlwaysOriginal' => '如果没有原始标题用主要标题代替',
        'OptionsRestoreAccelerators' => '恢复加速',
        'OptionsHistory' => '历史大小',
        'OptionsClearHistory' => '清除历史',
		'OptionsStyle' => '面板',
        'OptionsDontAsk' => '別再询问',
        'OptionsPathProgramsGroup' => '程序',
        'OptionsProgramsSystem' => '使用系统定义的程序',
        'OptionsProgramsUser' => '复写默认的程序',
        'OptionsProgramsSet' => '设置程序',
        'OptionsPathImagesGroup' => '图片',
        'OptionsInternetDataGroup' => '资料汇入',
        'OptionsInternetSettingsGroup' => '设置',
        'OptionsDisplayInformationGroup' => '信息显示方式',
        'OptionsDisplayArticlesGroup' => '冠词',
        'OptionsImagesDisplayGroup' => '显示',
        'OptionsImagesStyleGroup' => '风格',
        'OptionsDetailedPreferencesGroup' => '设置',
        'OptionsFeaturesConveniencesGroup' => '便利',
        'OptionsPicturesFormat' => '图片前缀：',
        'OptionsPicturesFormatInternal' => 'gcstar__',
        'OptionsPicturesFormatTitle' => '关联项目的标题或名字',
        'OptionsPicturesWorkingDir' => '%WORKING_DIR% 或 . 被用来代指收藏目录(在路径的开始处)',
        'OptionsPicturesFileBase' => '%FILE_BASE% 被用来代指没有后缀的收藏档名(.gcs)',
        'OptionsPicturesWorkingDirError' => '%WORKING_DIR% 只能被用在图片路径的开头',
        'OptionsConfigureMailers' => '设置邮件程序',

        'ImagesOptionsButton' => '设置',
        'ImagesOptionsTitle' => '设置图片列表',
        'ImagesOptionsSelectColor' => '选择一个颜色',
        'ImagesOptionsUseOverlays' => '使用图像层叠',
        'ImagesOptionsBg' => '背景',
        'ImagesOptionsBgPicture' => '使用背景图片',
        'ImagesOptionsFg'=> '选择',
        'ImagesOptionsBgTooltip' => '改变背景色',
        'ImagesOptionsFgTooltip'=> '改变选择颜色',
        'ImagesOptionsResizeImgList' => '自动改变栏的数字',
        'ImagesOptionsAnimateImgList' => 'Use animations',
        'ImagesOptionsSizeLabel' => '尺寸',
        'ImagesOptionsSizeList' => {0 => '极小', 1 => '小', 2 => '中', 3 => '大', 4 => '极大'},
        'ImagesOptionsSizeTooltip' => '选择图片尺寸',
		        
        'DetailedOptionsTitle' => '设置细节列表',
        'DetailedOptionsImageSize' => '图片尺寸',
        'DetailedOptionsGroupItems' => '项目分组依据',
        'DetailedOptionsSecondarySort' => '为子字段排序',
		'DetailedOptionsFields' => '选择显示字段',
        'DetailedOptionsGroupedFirst' => '将孤儿项目放在一起',
        'DetailedOptionsAddCount' => '显示类型中项目的数目',

        'ExtractButton' => '信息',
        'ExtractTitle' => '文件信息',
        'ExtractImport' => '使用值',

        'FieldsListOpen' => '从文件载入字段列表',
        'FieldsListSave' => '保存字段列表到文件',
        'FieldsListError' => '这个字段列表不能被用在这个类型的收藏上',
        'FieldsListIgnore' => '--- 忽略',

        'ExportTitle' => '汇出项目列表',
        'ExportFilter' => '仅汇出显示的项目',
        'ExportFieldsTitle' => '字段被汇出',
        'ExportFieldsTip' => '选择您想汇出的字段',
        'ExportWithPictures' => '复制子目录中的图片',
        'ExportSortBy' => '排序依据',
        'ExportOrder' => '次序',

        'ImportListTitle' => '汇入另一个项目列表',
        'ImportExportData' => '资料',
        'ImportExportFile' => '文件',
        'ImportExportFieldsUnused' => '未使用字段',
        'ImportExportFieldsUsed' => '使用字段',
        'ImportExportFieldsFill' => '添加全部',
        'ImportExportFieldsClear' => '删除全部',
        'ImportExportFieldsEmpty' => '您至少必须选择一个字段',
        'ImportExportFileEmpty' => '您必须指定一个文件名称',
        'ImportFieldsTitle' => '要导入的字段',
        'ImportFieldsTip' => '选择您想汇入的字段',
        'ImportNewList' => '建立一个新的收藏',
        'ImportCurrentList' => '添加到当前的收藏',
        'ImportDropError' => '至少有一个文件打开错误，将加载之前的列表。',
        'ImportGenerateId' => '对每个项目产生ID',

        'FileChooserOpenFile' => '请选择要使用的文件',
        'FileChooserDirectory' => '目录',
        'FileChooserOpenDirectory' => '选择一个目录',
        'FileChooserOverwrite' => '这个文件已经存在，您要覆盖它吗？',
        'FileAllFiles' => '所有文件',
        'FileVideoFiles' => '视频文件',
        'FileEbookFiles' => '电子书',
        'FileAudioFiles' => '音频文件',
        'FileGCstarFiles' => 'GCstar收藏',

        #Some default panels
        'PanelCompact' => '简洁',
        'PanelReadOnly' => '只读',
        'PanelForm' => '分页',

        'PanelSearchButton' => '获取资讯',
        'PanelSearchTip' => '搜索网路上关于这个名字的资讯',
        'PanelSearchContextChooseOne' => '选择一个网站...',
        'PanelSearchContextMultiSite' => '使用"多网站"',
        'PanelSearchContextMultiSitePerField' => '使用"每个字段多个网站"',
        'PanelSearchContextOptions' => '改变选项...',
        'PanelImageTipOpen' => '点击图片以选择另一个。',
        'PanelImageTipView' => '点击图片浏览真实尺寸。',
        'PanelImageTipMenu' => ' 更多选择请按右键',
        'PanelImageTitle' => '选择一张图片',
        'PanelImageNoImage' => '没有图片',
        'PanelSelectFileTitle' => '选择一个文件',
        'PanelLaunch' => '打开',        
        'PanelRestoreDefault' => '复原到默认值',
        'PanelRefresh' => '更新',
        'PanelRefreshTip' => '从网络上更新',

        'PanelFrom' =>'从',
        'PanelTo' =>'至',

        'PanelWeb' => '浏览资讯',
        'PanelWebTip' => '浏览网路上关于这个项目的资讯',
        'PanelRemoveTip' => '删除当前项目',

        'PanelDateSelect' => '选择',
        'PanelNobody' => '没有人',
        'PanelUnknown' => '未知',
        'PanelAdded' => '添加日期',
        'PanelRating' => '评价',
        'PanelPressRating' => '媒体评价',
        'PanelLocation' => '位置',

        'PanelLending' => '出借状况',
        'PanelBorrower' => '借出对象',
        'PanelLendDate' => '出借日期',
        'PanelHistory' => '出借记录',
        'PanelReturned' => '物品归还',
        'PanelReturnDate' => '归还日期',
        'PanelLendedYes' => '出借中',
        'PanelLendedNo' => '可用',

        'PanelTags' => '标签',
        'PanelFavourite' => '最爱',
        'TagsAssigned' => '标签', 

        'PanelUser' => '使用者字段',

        'CheckUndef' => '未定义',
        'CheckYes' => '是',
        'CheckNo' => '不是',

        'ToolbarRandom' => '随机选取',
        'ToolbarAll' => '浏览全部',
        'ToolbarAllTooltip' => '浏览全部项目',
        'ToolbarGroupBy' => '分组依据',
        'ToolbarGroupByTooltip' => '选择一个字段给项目列表分组',
        'ToolbarQuickSearch' => '快速搜索',
        'ToolbarQuickSearchLabel' => '搜索',
        'ToolbarQuickSearchTooltip' => '选择这个字段来搜索，输入要搜索的字串后按ENTER。',
        'ToolbarSeparator' => '分隔',
        
        'PluginsTitle' => '搜索一个项目',
        'PluginsQuery' => '查询',
        'PluginsFrame' => '搜索站点',
        'PluginsLogo' => 'Logo',
        'PluginsName' => '名字',
        'PluginsSearchFields' => '搜索字段',
        'PluginsAuthor' => '作者',
        'PluginsLang' => '语言',
        'PluginsUseSite' => '使用被选择的站点供未来搜索',
        'PluginsPreferredTooltip' => 'GCstar推荐站点',
        'PluginDisabled' => '无效',

        'BorrowersTitle' => '出借对象设置',
        'BorrowersList' => '出借对象',
        'BorrowersName' => '名字',
        'BorrowersEmail' => 'E-mail',
        'BorrowersAdd' => '添加',
        'BorrowersRemove' => '删除',
        'BorrowersEdit' => '编辑',
        'BorrowersTemplate' => '邮件模板',
        'BorrowersSubject' => '邮件主题',
        'BorrowersNotice1' => '%1 将会被取代为出借对象的名字',
        'BorrowersNotice2' => '%2 将会被取代为物品名称',
        'BorrowersNotice3' => '%3 将会被取代为出借日期',

        'BorrowersImportTitle' => '导入出借对象的信息',
        'BorrowersImportType' => '文件格式：',
        'BorrowersImportFile' => '文件：',

        'BorrowedTitle' => '被借走的东西',
        'BorrowedDate' => '从',
        'BorrowedDisplayInPanel' => '在主窗口显示物品',

        'MailTitle' => '发一封email',
        'MailFrom' => '寄信人：',
        'MailTo' => '收信人：',
        'MailSubject' => '主题：',
        'MailSmtpError' => '连线到SMTP服务器时出现问题',
        'MailSendmailError' => '寄送信件时出现问题',

        'SearchTooltip' => '搜索所有项目',
        'SearchTitle' => '项目搜索',
        'SearchNoField' => '搜索没有选择任何字段。
在收藏设置中的过滤器标签中加入。',

        'QueryReplaceField' => '替换字段',
        'QueryReplaceOld' => '当前值',
        'QueryReplaceNew' => '新值',
        'QueryReplaceLaunch' => '替换',
        
        'ImportWindowTitle' => '选择要导入的字段',
        'ImportViewPicture' => '浏览图片',
        'ImportSelectAll' => '全选',
        'ImportSelectNone' => '全部不选',

        'MultiSiteTitle' => '用来搜索的网站',
        'MultiSiteUnused' => '未使用的插件',
        'MultiSiteUsed' => '被使用的插件',
        'MultiSiteLang' => '添加英语插件至列表',
        'MultiSiteEmptyError' => '您的站点列表为空',
        'MultiSiteClear' => '清除列表',
        
        'DisplayOptionsTitle' => '显示项目',
        'DisplayOptionsAll' => '全选',
        'DisplayOptionsSearch' => '选择按钮',

        'GenresTitle' => '类型转换',
        'GenresCategoryName' => '使用类型',
        'GenresCategoryMembers' => '替换类型',
        'GenresLoad' => '读取一个列表',
        'GenresExport' => '将列表存到文件',
        'GenresModify' => '编辑转换',

        'PropertiesName' => '收藏名称',
        'PropertiesLang' => '语言编码',
        'PropertiesOwner' => '拥有者',
        'PropertiesEmail' => 'Email',
        'PropertiesDescription' => '描述',
        'PropertiesFile' => '文件信息',
        'PropertiesFilePath' => '完整路径',
        'PropertiesItemsNumber' => '项目数目',
        'PropertiesFileSize' => '大小',
        'PropertiesFileSizeSymbols' => ['字节', 'KB', 'MB', 'GB', 'TB', 'PB', 'EB', 'ZB', 'YB'],
        'PropertiesCollection' => '收藏属性',
        'PropertiesDefaultPicture' => '默认图片',

        'MailProgramsTitle' => '寄件软体',
        'MailProgramsName' => '名字',
        'MailProgramsCommand' => '指令行',
        'MailProgramsRestore' => '回复默认值',
        'MailProgramsAdd' => '添加一个程序',
        'MailProgramsInstructions' => '在指令行中，您可以用下面的变量来替换：
 %f 可被替换为使用者的电子邮件地址。
 %t 可被替换为接收地址。
 %s 可被替换为邮件主题。
 %b 可被替换为邮件信息。',

        'BookmarksBookmarks' => '书签',
        'BookmarksFolder' => '目录',
        'BookmarksLabel' => '书签名',
        'BookmarksPath' => '路径',
        'BookmarksNewFolder' => '新目录',

        'AdvancedSearchType' => '搜索类型',
        'AdvancedSearchTypeAnd' => '项目匹配所有条件',
        'AdvancedSearchTypeOr' => '项目匹配至少一个条件',
        'AdvancedSearchCriteria' => '条件',
        'AdvancedSearchAnyField' => '所有字段',
        'AdvancedSearchSaveTitle' => '保存搜索',
        'AdvancedSearchSaveName' => '名称',
        'AdvancedSearchSaveOverwrite' => '一个使用相同名字的搜索已经存在，请使用另一个名字。',
        'AdvancedSearchUseCase' => '大小写敏感',
        'AdvancedSearchIgnoreDiacritics' => '忽略重音等发音记号',

        'BugReportSubject' => 'GCstar生成错误报告',
        'BugReportVersion' => '版本',
        'BugReportPlatform' => '操作系统',
        'BugReportMessage' => '错误信息',
        'BugReportInformation' => '附加资讯',

#Statistics
        'StatsFieldToUse' => '使用字段',
        'StatsSortByNumber' => '按{lowercaseX}数目排序',
        'StatsGenerate' => '生成',
        'StatsKindOfGraph' => '统计图类型',
        'StatsBars' => '柱状',
        'StatsPie' => '饼状',
        'Stats3DPie' => '三维饼状',
        'StatsArea' => '范围',
        'StatsHistory' => '历史',
        'StatsWidth' => '宽度',
        'StatsHeight' => '高度',
        'StatsFontSize' => '字体大小',
        'StatsDisplayNumber' => '显示数字',
        'StatsSave' => '保存统计图',
        'StatsAccumulate' => '累计值',
        'StatsShowAllDates' => '显示所有数据',

        'DefaultValuesTip' => 'Values set in this window will be used as the default values when creating a new {lowercase1}',
    );
}
1;
