
module Main(main) where

--import Int( Num(fromInt) )

newtype RNG_State = RNG_State (Int, Int, Int)

new_random i = RNG_State (i `mod` 30269, i `mod` 30307, i `mod` 30323)

next_unit_random (RNG_State (a,b,c)) =
  (r, RNG_State (a1,b1,c1))
  where a1 = (a * 171) `mod` 30269
        b1 = (b * 172) `mod` 30307
        c1 = (c * 170) `mod` 30323
        t  = fromIntegral a1/30269.0 +
             fromIntegral b1/30307.0 +
             fromIntegral c1/30323.0
        r  = t - fromIntegral (truncate t)

next_random_bool p s =
  (r < p, s1)
  where (r,s1) = next_unit_random s

next_random_list f n s =
  loop [] n s
  where loop ps 0 s = (ps, s)
        loop ps m s = loop (p:ps) (m-1) s1
                      where (p,s1) = f s

rpart []     _ _ ps qs s = ((ps, qs), s)
rpart (x:xs) n d ps qs s =
    if   d*r < n
    then rpart xs (n-1.0) (d-1.0) (x:ps) qs s1
    else rpart xs    n    (d-1.0) ps (x:qs) s1
    where (r, s1) = next_unit_random s

random_permutation xs s =
  rperm xs (length xs) [] s
  where rperm []      0 ps s = (ps, s)
        rperm [x1]    1 ps s = ((x1:ps), s)
        rperm [x1,x2] 2 ps s =
          if b then (x1:x2:ps, s1) else (x2:x1:ps, s1)
          where (b, s1) = next_random_bool 0.5 s
        rperm xs d ps s =
          let n = d `div` 2
              ((ys, zs), s1) = rpart xs (fromIntegral n) (fromIntegral d) [] [] s
              (zps, s2) = rperm zs (d-n) ps s1
          in rperm ys n zps s2
          
minit m n g =
  outer (m-1) []
  where outer (-1) xss = xss
        outer m xss = outer (m-1) (inner (n-1) [] : xss)
                      where inner (-1) xs = xs
                            inner n    xs = inner (n-1) (g m n : xs)

vadd [] [] = []
vadd (x:xs) (y:ys) = x+y : vadd xs ys

madd [] [] = []
madd (xs:xss) (ys:yss) = vadd xs ys : madd xss yss

vaddx [] [] _ = []
vaddx (x:xs) (y:ys) a = x+y*a : vaddx xs ys a

vsub [] [] = []
vsub (x:xs) (y:ys) = x-y : vsub xs ys

vmulx [] _ = []
vmulx (x:xs) a = x*a : vmulx xs a

mmulx [] _ = []
mmulx (xs:xss) a = vmulx xs a : mmulx xss a

vdist xs ys =
  loop xs ys 0.0
  where loop []     []     s = s
        loop (x:xs) (y:ys) s = loop xs ys (s+d*d)
                               where d = x-y

vdot xs ys =
  loop xs ys 0.0
  where loop []     []     s = s
        loop (x:xs) (y:ys) s = loop xs ys (s+x*y)

vmmul []     []     = []
vmmul (x:xs) (r:rs) =
  loop xs rs (vmulx r x)
  where loop []     []     ws = ws
        loop (x:xs) (r:rs) ws = loop xs rs (vaddx ws r x)

vupdate []     _  []     _ = []
vupdate (r:rs) xs (y:ys) c = vaddx r xs (y*c) : vupdate rs xs ys c

vscale [] [] = []
vscale (x:xs) (y:ys) = x*y*(1.0-y) : vscale xs ys

sigmoid x = 1.0/(1.0 + exp (0.0-x))

mrand m n l u s =
  next_random_list (next_random_list f n) m s
  where f s = (l + (u-l)*r, s1)
        (r, s1) = next_unit_random s

train pats i_h_wt i_h_ch h_o_wt h_o_ch epochs s =
  loop pats1 i_h_ch h_o_ch 0.0
  where
    (pats1, s1) = random_permutation pats s
    loop [] i_h_ch h_o_ch e0
      | e <  criterion = ((e,0,i_h_wt,h_o_wt), s1)
      | epochs <= 0    = ((e,1,i_h_wt,h_o_wt), s1)
      | True =
        train pats (madd i_h_wt i_h_ch) (mmulx i_h_ch momentum)
                   (madd h_o_wt h_o_ch) (mmulx h_o_ch momentum) (epochs-1) s1
      where e = e0/(fromIntegral (length pats) * fromIntegral (length h_o_wt))
    loop ((in_pat, out_pat):ps) i_h_ch h_o_ch e =
        loop ps (vupdate i_h_ch in_act  (tail hid_err) rate)
                (vupdate h_o_ch hid_act out_err        rate)
                (e + vdist out_pat out_act)
        where
          in_act  = 1.0:in_pat
          hid_act = 1.0:map (\w -> sigmoid (vdot in_act  w)) i_h_wt
          out_act =     map (\w -> sigmoid (vdot hid_act w)) h_o_wt
          out_err = vscale (vsub out_pat out_act) out_act
          hid_err = vscale (vmmul out_err h_o_wt) hid_act

main = putStrLn (show ans)
    where (in1,out1)   = head patterns
          nin          = length in1
          nhid         = nin
          nout         = length out1
          s0           = new_random 353721
          (i_h_wt, s1) = mrand nhid (nin +1) (0.0-0.3) 0.3 s0
          i_h_ch       = minit nhid (nin +1) (\i j -> 0.0)
          (h_o_wt, s2) = mrand nout (nhid+1) (0.0-0.3) 0.3 s1
          h_o_ch       = minit nout (nhid+1) (\i j -> 0.0)
          (ans, _)     = train patterns i_h_wt i_h_ch h_o_wt h_o_ch epochs s2

rate = 0.05

momentum = 0.9

criterion = 0.01

--epochs = 100

--patterns = [([1.0,0.0],[1.0]),
--            ([0.0,1.0],[1.0]),
--            ([0.0,0.0],[0.0]),
--            ([1.0,1.0],[0.0])]

epochs = 90

patterns =
 [([0.955809, 0.095706, 0.269204, 0.824671, 0.448012, 0.722709,
    0.327677, 0.148595, 0.063143, 0.007019, 0.135166, 0.928800, 0.298593,
    0.931150, 0.711234, 0.432630, 0.913450, 0.545061, 0.651082, 0.692984,
    0.371532, 0.940641, 0.202521, 0.064852, 0.965941, 0.523637, 0.914884,
    0.159062, 0.031648, 0.866848, 0.516526, 0.684317, 0.152135, 0.923734,
    0.177435, 0.228339, 0.766503, 0.885159, 0.812220, 0.510208, 0.082949,
    0.459792, 0.580920, 0.134190, 0.705741, 0.859523, 0.243171, 0.377117,
    0.880551, 0.271218, 0.521989, 0.039888, 0.765862, 0.096347, 0.133702,
    0.895138, 0.635548, 0.738853, 0.640126, 0.761162, 0.419599, 0.223579,
    0.779260, 0.734947, 0.488937, 0.426038, 0.430799, 0.613788, 0.090487,
    0.194372, 0.872494, 0.038179, 0.339183, 0.145482, 0.483932, 0.386425,
    0.172430, 0.416150, 0.553850, 0.952422, 0.174200, 0.150365, 0.347056,
    0.438063, 0.674154, 0.004456, 0.087527, 0.291269, 0.028474, 0.450819,
    0.013642, 0.920896, 0.488815, 0.161840, 0.162084, 0.319803, 0.564989,
    0.255287, 0.036348, 0.127750, 0.288461, 0.681906, 0.816370, 0.664449,
    0.282235, 0.537126, 0.265328, 0.964965, 0.043672, 0.577898, 0.990173,
    0.348186, 0.346446, 0.725700, 0.211463, 0.549821, 0.167943, 0.837062,
    0.700003, 0.950896, 0.048341, 0.523087, 0.034761, 0.933439, 0.287393,
    0.299081, 0.840144, 0.894284, 0.885464, 0.845302, 0.157476, 0.948210,
    0.635060, 0.660421, 0.607990, 0.852107, 0.268868, 0.888760, 0.502518,
    0.180609, 0.070650, 0.602802, 0.555223, 0.285440, 0.855495, 0.321665,
    0.356700, 0.068758, 0.725059, 0.047487, 0.263344, 0.102695, 0.504959,
    0.600452, 0.858974, 0.125217, 0.269662, 0.533982, 0.644642, 0.444838,
    0.861721, 0.411145, 0.113712, 0.284371, 0.811182, 0.723930, 0.867702,
    0.595538, 0.561968, 0.235847, 0.929167, 0.375408, 0.410901, 0.030122,
    0.908536, 0.016297, 0.065859, 0.043977, 0.180425, 0.719810, 0.229469,
    0.370403, 0.726096, 0.506699, 0.114353, 0.108921, 0.797998, 0.853908,
    0.296274, 0.046419, 0.063143, 0.489364, 0.811396, 0.949217, 0.380902,
    0.376751, 0.903958, 0.747703, 0.872127, 0.420392, 0.330729, 0.395032,
    0.435102, 0.922697, 0.628071, 0.680502, 0.365703, 0.324259, 0.248299,
    0.779656, 0.236610, 0.258950, 0.971496, 0.821680, 0.692892, 0.454146,
    0.498856, 0.255776, 0.319895, 0.508377, 0.634022, 0.297617, 0.239479,
    0.076937, 0.958342, 0.237007, 0.591144, 0.497055, 0.406842, 0.888241,
    0.554064, 0.383587, 0.650624],
   [0.234896, 0.423061, 0.263443, 0.123426,
    0.794525, 0.243195, 0.176474, 0.282455, 0.620580, 0.126517, 0.858114,
    0.150592, 0.351949, 0.153976, 0.480803, 0.272537, 0.062543, 0.525171,
    0.896010, 0.872203, 0.431661, 0.702341, 0.385838, 0.951113, 0.058039,
    0.563982, 0.981357, 0.319594, 0.190779, 0.159156, 0.182152, 0.912154,
    0.046355, 0.322471, 0.190853, 0.146977, 0.556987, 0.432033, 0.849777,
    0.397618, 0.800925, 0.817440, 0.103982, 0.417800, 0.982832, 0.123455,
    0.075878, 0.578246, 0.575774, 0.662847, 0.121769, 0.310270, 0.451505,
    0.871721, 0.263607, 0.963375, 0.198854, 0.249971, 0.273863, 0.592648,
    0.133579, 0.119994, 0.679855, 0.626287, 0.174323, 0.164256, 0.841121,
    0.752313, 0.501021, 0.569367, 0.804985, 0.639864, 0.272153, 0.055158,
    0.281015, 0.090302, 0.648710, 0.526850, 0.121161, 0.620315, 0.383709,
    0.487889, 0.739381, 0.609108, 0.181023, 0.419480, 0.453455, 0.658062,
    0.054643, 0.832708, 0.255309, 0.744293, 0.909823, 0.895573, 0.934952,
    0.332162, 0.514298, 0.129617, 0.568588, 0.459891, 0.512871, 0.708730,
    0.244905, 0.504490, 0.408360, 0.724549, 0.263859, 0.126921, 0.917366,
    0.128843, 0.761606, 0.295994, 0.485532, 0.364426, 0.209157, 0.331918,
    0.923155, 0.832404, 0.344705, 0.992287, 0.797664, 0.513933, 0.197295,
    0.898075, 0.321190, 0.766076, 0.896433, 0.510118, 0.555644, 0.731407,
    0.336166, 0.961858, 0.108792, 0.274650, 0.447974, 0.322401, 0.519439,
    0.127972, 0.743228, 0.095587, 0.442358, 0.065578, 0.427339, 0.867874,
    0.115209, 0.391970, 0.222726, 0.427568, 0.562064, 0.073965, 0.500635,
    0.103580, 0.193423, 0.463678, 0.352990, 0.872354, 0.266832, 0.066053,
    0.567679, 0.465254, 0.715300, 0.890676, 0.962122, 0.823967, 0.085568,
    0.195321, 0.730473, 0.142718, 0.589829, 0.954951, 0.190184, 0.350517,
    0.593301, 0.582699, 0.060864, 0.072237, 0.305630, 0.417032, 0.670941,
    0.430787, 0.876681, 0.244844, 0.060370, 0.274557, 0.598552, 0.194049,
    0.661775, 0.251685, 0.143953, 0.228740, 0.268005, 0.353289, 0.234517,
    0.866899, 0.382406, 0.826395, 0.551468, 0.910383, 0.677785, 0.487901,
    0.408431, 0.465832, 0.226357, 0.897554, 0.717515, 0.630160, 0.664560,
    0.807919, 0.184460, 0.314334, 0.122805, 0.073591, 0.617129, 0.220999,
    0.050125, 0.388057, 0.262980, 0.898668, 0.103295, 0.798561, 0.110919,
    0.451100, 0.852923, 0.263962, 0.169917, 0.891759, 0.902670, 0.074144,
    0.746980, 0.667262, 0.158418, 0.192804, 0.468950]),

  ([0.964202, 0.066500, 0.226936, 0.692160, 0.655660, 0.898740, 0.524033,
    0.579821, 0.196814, 0.235450, 0.473617, 0.647664, 0.698416, 0.424787,
    0.767571, 0.187048, 0.029542, 0.048921, 0.508835, 0.956023, 0.030000,
    0.973724, 0.787866, 0.432691, 0.833460, 0.532731, 0.948271, 0.219459,
    0.583239, 0.502701, 0.073183, 0.503311, 0.322489, 0.025788, 0.723991,
    0.979400, 0.338694, 0.135716, 0.461501, 0.143620, 0.745018, 0.043428,
    0.182409, 0.360729, 0.578967, 0.839015, 0.800714, 0.613727, 0.199988,
    0.765618, 0.306711, 0.341594, 0.267281, 0.722098, 0.733726, 0.270852,
    0.078555, 0.150273, 0.064547, 0.647755, 0.551744, 0.963408, 0.608631,
    0.776727, 0.630360, 0.671590, 0.880856, 0.272225, 0.393933, 0.361126,
    0.513932, 0.929319, 0.654927, 0.683248, 0.235145, 0.619770, 0.322947,
    0.509049, 0.438612, 0.119938, 0.318155, 0.406720, 0.384625, 0.276345,
    0.314371, 0.597186, 0.557329, 0.415448, 0.093722, 0.544572, 0.211493,
    0.403851, 0.794000, 0.837703, 0.640553, 0.265084, 0.829402, 0.518754,
    0.195807, 0.759392, 0.766900, 0.515610, 0.589740, 0.832545, 0.938505,
    0.333811, 0.512986, 0.340007, 0.071291, 0.664602, 0.097476, 0.953063,
    0.716330, 0.065249, 0.256539, 0.652181, 0.757408, 0.367809, 0.432722,
    0.715354, 0.781518, 0.972747, 0.785791, 0.606159, 0.591449, 0.683523,
    0.350780, 0.668813, 0.642537, 0.238472, 0.198431, 0.035859, 0.684408,
    0.196112, 0.128605, 0.655354, 0.388958, 0.330393, 0.928220, 0.843074,
    0.246040, 0.191717, 0.724906, 0.266549, 0.507981, 0.990509, 0.467574,
    0.767113, 0.463881, 0.458998, 0.065279, 0.925687, 0.825770, 0.848079,
    0.215400, 0.779382, 0.506851, 0.714957, 0.452528, 0.594592, 0.573901,
    0.658132, 0.449507, 0.102847, 0.654500, 0.655812, 0.101474, 0.105991,
    0.580767, 0.164403, 0.424482, 0.856655, 0.550645, 0.632588, 0.799554,
    0.120334, 0.587909, 0.587939, 0.594195, 0.325510, 0.582446, 0.952055,
    0.691580, 0.707785, 0.691580, 0.740196, 0.959563, 0.854366, 0.384228,
    0.802393, 0.190100, 0.555376, 0.908933, 0.761345, 0.541063, 0.367840,
    0.466506, 0.804132, 0.010590, 0.799005, 0.869655, 0.483566, 0.976623,
    0.514817, 0.969665, 0.185705, 0.331492, 0.480422, 0.632160, 0.419385,
    0.244026, 0.438002, 0.543016, 0.584490, 0.079379, 0.629322, 0.625263,
    0.374889, 0.508713, 0.168279, 0.348827, 0.472396, 0.339213, 0.970336,
    0.714225, 0.688009, 0.096377, 0.644551, 0.190954, 0.206671, 0.889401,
    0.255043, 0.392529],
   [ 0.347267, 0.395278, 0.312221, 0.271034, 0.606466,
    0.281430, 0.206116, 0.433894, 0.811608, 0.149699, 0.930589, 0.131576,
    0.606860, 0.168244, 0.510042, 0.318780, 0.017318, 0.390086, 0.887702,
    0.856325, 0.410205, 0.731879, 0.429107, 0.951366, 0.090044, 0.460008,
    0.982247, 0.365122, 0.274204, 0.137115, 0.153039, 0.951211, 0.065363,
    0.265502, 0.089683, 0.080594, 0.583010, 0.702345, 0.741734, 0.195394,
    0.694880, 0.634725, 0.110399, 0.510145, 0.984661, 0.095715, 0.060022,
    0.603920, 0.771879, 0.818352, 0.082082, 0.618599, 0.573476, 0.893264,
    0.229809, 0.985823, 0.317123, 0.178742, 0.319886, 0.742494, 0.070001,
    0.097983, 0.799138, 0.627735, 0.234819, 0.174270, 0.832352, 0.747531,
    0.647704, 0.705891, 0.773991, 0.515965, 0.364954, 0.068576, 0.245708,
    0.052415, 0.660207, 0.516471, 0.116974, 0.402301, 0.668778, 0.478975,
    0.759934, 0.675118, 0.254879, 0.420252, 0.301185, 0.501663, 0.106245,
    0.885773, 0.233874, 0.852706, 0.920644, 0.903723, 0.918905, 0.397496,
    0.508660, 0.350752, 0.525033, 0.525978, 0.501128, 0.591062, 0.327965,
    0.501709, 0.383894, 0.685330, 0.354505, 0.031559, 0.873401, 0.127268,
    0.798431, 0.353377, 0.460709, 0.275419, 0.208795, 0.362425, 0.876697,
    0.927418, 0.263693, 0.985030, 0.725649, 0.371198, 0.304175, 0.897437,
    0.436677, 0.633838, 0.883890, 0.471352, 0.563572, 0.763623, 0.364169,
    0.958443, 0.068425, 0.260482, 0.313543, 0.394317, 0.443647, 0.121875,
    0.780465, 0.211723, 0.268817, 0.067533, 0.660574, 0.821465, 0.084727,
    0.520244, 0.288125, 0.675550, 0.580184, 0.116487, 0.701141, 0.082960,
    0.262049, 0.478233, 0.452062, 0.902427, 0.540173, 0.098391, 0.338498,
    0.422226, 0.634723, 0.927242, 0.954212, 0.803277, 0.096551, 0.200374,
    0.689030, 0.291707, 0.580938, 0.939620, 0.151359, 0.232785, 0.503464,
    0.695066, 0.052623, 0.060584, 0.175948, 0.382867, 0.590377, 0.137340,
    0.854693, 0.227445, 0.042913, 0.300106, 0.598812, 0.232287, 0.684412,
    0.365377, 0.094614, 0.097589, 0.241374, 0.555737, 0.246608, 0.794405,
    0.244149, 0.733437, 0.394148, 0.893992, 0.702754, 0.580066, 0.313107,
    0.633119, 0.305982, 0.934299, 0.642923, 0.551348, 0.624630, 0.790857,
    0.331221, 0.474498, 0.189123, 0.110964, 0.484088, 0.151825, 0.119752,
    0.369902, 0.186865, 0.815287, 0.074211, 0.710128, 0.272505, 0.428258,
    0.913809, 0.370850, 0.101142, 0.907882, 0.813830, 0.169027, 0.828513,
    0.535021, 0.157700, 0.154209, 0.657740] ),

  ([0.091800, 0.590747, 0.357860, 0.768944, 0.705832, 0.861995, 0.219123,
    0.097995, 0.202826, 0.055971, 0.621387, 0.056795, 0.750175, 0.527818,
    0.164159, 0.654408, 0.634266, 0.384625, 0.464583, 0.807123, 0.907865,
    0.206702, 0.164922, 0.837733, 0.734306, 0.770074, 0.152898, 0.179693,
    0.085452, 0.302530, 0.901242, 0.067660, 0.949400, 0.304209, 0.332316,
    0.495651, 0.703909, 0.463515, 0.115024, 0.223945, 0.812586, 0.700278,
    0.798822, 0.116245, 0.499100, 0.867183, 0.692465, 0.587878, 0.556658,
    0.140294, 0.892911, 0.446852, 0.947905, 0.630696, 0.370830, 0.908597,
    0.352580, 0.247810, 0.519211, 0.065737, 0.318644, 0.345988, 0.070711,
    0.594501, 0.172735, 0.185614, 0.790979, 0.978179, 0.347209, 0.739830,
    0.852931, 0.029786, 0.279061, 0.878292, 0.299570, 0.995025, 0.537614,
    0.459029, 0.500534, 0.015748, 0.336619, 0.359905, 0.009095, 0.237007,
    0.087802, 0.980621, 0.726005, 0.337168, 0.151524, 0.246712, 0.775872,
    0.763451, 0.440596, 0.646962, 0.003052, 0.453749, 0.034516, 0.334819,
    0.492813, 0.326060, 0.459212, 0.825983, 0.023896, 0.316568, 0.789178,
    0.322672, 0.859310, 0.248024, 0.228217, 0.196203, 0.781091, 0.309366,
    0.324992, 0.658956, 0.775445, 0.427870, 0.479324, 0.157048, 0.274606,
    0.315165, 0.895993, 0.515091, 0.361614, 0.468337, 0.642048, 0.363872,
    0.844020, 0.907407, 0.963775, 0.882931, 0.603198, 0.930235, 0.519639,
    0.388195, 0.125248, 0.666524, 0.685812, 0.797388, 0.619831, 0.711478,
    0.589740, 0.502792, 0.632923, 0.621326, 0.028840, 0.684194, 0.560228,
    0.550920, 0.930204, 0.591937, 0.967132, 0.815455, 0.507126, 0.832453,
    0.121433, 0.657216, 0.769890, 0.186468, 0.645528, 0.998627, 0.545610,
    0.992279, 0.693594, 0.462813, 0.664510, 0.624012, 0.560564, 0.443159,
    0.468307, 0.097537, 0.129246, 0.502792, 0.297189, 0.334117, 0.061190,
    0.885464, 0.111545, 0.113559, 0.138157, 0.418867, 0.904599, 0.248360,
    0.660176, 0.592181, 0.062349, 0.009522, 0.306528, 0.088137, 0.327311,
    0.335643, 0.365917, 0.551897, 0.521531, 0.856471, 0.741783, 0.877163,
    0.686026, 0.262154, 0.639637, 0.791314, 0.792169, 0.049593, 0.341929,
    0.020661, 0.681936, 0.176702, 0.977325, 0.816828, 0.392651, 0.656301,
    0.690176, 0.125736, 0.522843, 0.620746, 0.116733, 0.180731, 0.795282,
    0.888485, 0.574419, 0.800439, 0.473739, 0.563616, 0.869655, 0.172918,
    0.789270, 0.700369, 0.131840, 0.407849, 0.032655, 0.562670, 0.578539,
    0.636982, 0.469131],
   [0.250121, 0.483413, 0.264094, 0.307941, 0.733994,
    0.238909, 0.172450, 0.289615, 0.639522, 0.156406, 0.927321, 0.115653,
    0.439196, 0.138059, 0.430463, 0.210567, 0.043311, 0.427593, 0.713422,
    0.874737, 0.349128, 0.641711, 0.307643, 0.960792, 0.057629, 0.274816,
    0.959588, 0.398889, 0.271323, 0.171029, 0.242094, 0.978259, 0.096858,
    0.335654, 0.139114, 0.149906, 0.430454, 0.483910, 0.630219, 0.285243,
    0.744639, 0.707501, 0.128506, 0.505621, 0.986704, 0.086747, 0.267839,
    0.638377, 0.606427, 0.850217, 0.108584, 0.368790, 0.415063, 0.828986,
    0.366711, 0.960958, 0.215415, 0.253284, 0.268513, 0.436681, 0.111406,
    0.103739, 0.653758, 0.511406, 0.359645, 0.142705, 0.886096, 0.729033,
    0.570775, 0.475699, 0.781399, 0.624880, 0.453394, 0.105905, 0.258093,
    0.043573, 0.695208, 0.381172, 0.131100, 0.470651, 0.494271, 0.329024,
    0.677485, 0.566830, 0.452777, 0.283240, 0.187764, 0.614069, 0.110264,
    0.810169, 0.297650, 0.804280, 0.875188, 0.876858, 0.950973, 0.347310,
    0.568015, 0.203545, 0.636385, 0.402638, 0.561527, 0.704415, 0.335657,
    0.416779, 0.371755, 0.656713, 0.245263, 0.069130, 0.858867, 0.117609,
    0.814266, 0.357809, 0.368650, 0.195525, 0.253112, 0.273989, 0.897546,
    0.737842, 0.188547, 0.991165, 0.751005, 0.552062, 0.267549, 0.903292,
    0.309227, 0.766666, 0.885213, 0.570977, 0.382676, 0.564119, 0.461571,
    0.938216, 0.127708, 0.189827, 0.276506, 0.377828, 0.537514, 0.231975,
    0.575255, 0.211339, 0.194267, 0.110436, 0.330972, 0.823506, 0.087909,
    0.405803, 0.398364, 0.585681, 0.676848, 0.126466, 0.459028, 0.068184,
    0.229350, 0.508934, 0.295492, 0.876380, 0.290811, 0.034688, 0.401911,
    0.337465, 0.767958, 0.852948, 0.981002, 0.763970, 0.070562, 0.312852,
    0.691511, 0.244069, 0.497265, 0.912701, 0.104435, 0.312821, 0.663720,
    0.688728, 0.072052, 0.040471, 0.113943, 0.208670, 0.557001, 0.255511,
    0.744639, 0.166425, 0.049652, 0.223302, 0.492090, 0.229562, 0.573484,
    0.590362, 0.206928, 0.294928, 0.183751, 0.270976, 0.310734, 0.917243,
    0.200381, 0.691783, 0.425492, 0.882956, 0.635164, 0.618051, 0.253056,
    0.505014, 0.434698, 0.910271, 0.737867, 0.553463, 0.588869, 0.748615,
    0.244402, 0.282370, 0.257965, 0.119861, 0.620997, 0.124454, 0.112210,
    0.383214, 0.245615, 0.853594, 0.145247, 0.776892, 0.166819, 0.548061,
    0.802385, 0.142570, 0.098268, 0.887335, 0.906549, 0.087140, 0.690883,
    0.731714, 0.239845, 0.207338, 0.304361] ),

  ([0.511246, 0.618427, 0.945036, 0.731468, 0.048402, 0.198859, 0.911771,
    0.848018, 0.052889, 0.803369, 0.046754, 0.561571, 0.734703, 0.006043,
    0.897824, 0.095798, 0.342509, 0.988769, 0.114628, 0.024812, 0.153844,
    0.927488, 0.248695, 0.402722, 0.780084, 0.654073, 0.570818, 0.809198,
    0.316813, 0.499557, 0.687429, 0.467269, 0.371319, 0.725608, 0.237007,
    0.089572, 0.498337, 0.449721, 0.447890, 0.609638, 0.075076, 0.471175,
    0.838435, 0.453658, 0.147130, 0.903470, 0.841304, 0.510117, 0.276162,
    0.019532, 0.632557, 0.452528, 0.921018, 0.216407, 0.947417, 0.572161,
    0.382977, 0.504929, 0.163121, 0.776605, 0.847072, 0.431288, 0.431196,
    0.910825, 0.550035, 0.836573, 0.139134, 0.056368, 0.606738, 0.360027,
    0.484054, 0.965941, 0.525834, 0.093295, 0.438520, 0.288186, 0.946165,
    0.290719, 0.890316, 0.740532, 0.625294, 0.543016, 0.237251, 0.885006,
    0.211066, 0.319712, 0.218513, 0.663961, 0.827631, 0.287240, 0.263222,
    0.352092, 0.007172, 0.308573, 0.138035, 0.080264, 0.998840, 0.530656,
    0.174993, 0.588122, 0.985260, 0.466170, 0.860317, 0.361461, 0.239326,
    0.475600, 0.065981, 0.810541, 0.751152, 0.555773, 0.705252, 0.645741,
    0.356883, 0.841639, 0.093051, 0.106632, 0.901242, 0.726859, 0.792779,
    0.200873, 0.463912, 0.010041, 0.230628, 0.609210, 0.182226, 0.972442,
    0.859035, 0.412427, 0.700308, 0.793481, 0.149602, 0.297342, 0.776666,
    0.210761, 0.198004, 0.397015, 0.081118, 0.830256, 0.221076, 0.422315,
    0.712790, 0.992767, 0.727836, 0.240638, 0.469253, 0.604083, 0.645497,
    0.558153, 0.399884, 0.833644, 0.182073, 0.861904, 0.672903, 0.088626,
    0.706290, 0.277627, 0.288400, 0.170141, 0.426405, 0.500320, 0.668447,
    0.016816, 0.149052, 0.452895, 0.655019, 0.942717, 0.899747, 0.829737,
    0.947935, 0.775628, 0.685324, 0.181372, 0.512894, 0.802149, 0.180853,
    0.696341, 0.991943, 0.925413, 0.621357, 0.336467, 0.646809, 0.942015,
    0.679678, 0.482131, 0.867000, 0.344493, 0.612293, 0.743370, 0.773278,
    0.555376, 0.453688, 0.093204, 0.948363, 0.998871, 0.540880, 0.979797,
    0.825709, 0.917112, 0.149327, 0.572924, 0.767724, 0.336436, 0.521439,
    0.801843, 0.364666, 0.090609, 0.068575, 0.340251, 0.985717, 0.306742,
    0.028718, 0.194739, 0.112888, 0.260231, 0.360057, 0.053102, 0.489731,
    0.005432, 0.151982, 0.048616, 0.615528, 0.687857, 0.335643, 0.096561,
    0.616504, 0.943907, 0.973693, 0.459304, 0.025239, 0.295297, 0.911924,
    0.696127, 0.499680],
   [0.372363, 0.313207, 0.276106, 0.279324, 0.820741,
    0.205839, 0.328552, 0.399419, 0.774962, 0.215105, 0.853020, 0.226282,
    0.571785, 0.173005, 0.436688, 0.238419, 0.019348, 0.460500, 0.847289,
    0.878880, 0.228861, 0.695937, 0.239922, 0.971454, 0.036638, 0.461105,
    0.972190, 0.455536, 0.254031, 0.210429, 0.335951, 0.912823, 0.057891,
    0.222266, 0.176725, 0.124067, 0.581808, 0.736316, 0.652302, 0.248547,
    0.704722, 0.716806, 0.087022, 0.515832, 0.973141, 0.095332, 0.098511,
    0.549793, 0.810595, 0.823819, 0.070312, 0.561088, 0.364184, 0.852806,
    0.259421, 0.961891, 0.135451, 0.210059, 0.366696, 0.553164, 0.115941,
    0.097627, 0.862905, 0.499057, 0.464813, 0.240171, 0.903088, 0.744335,
    0.613677, 0.796010, 0.774554, 0.611191, 0.427484, 0.043273, 0.272693,
    0.091735, 0.626866, 0.598557, 0.314647, 0.606310, 0.660126, 0.401762,
    0.782298, 0.587858, 0.140014, 0.598725, 0.358832, 0.437350, 0.217892,
    0.874923, 0.189696, 0.806172, 0.853777, 0.849070, 0.872760, 0.442148,
    0.530084, 0.230444, 0.608441, 0.564128, 0.408068, 0.732274, 0.456723,
    0.421654, 0.596509, 0.737912, 0.407249, 0.036761, 0.856259, 0.132400,
    0.832515, 0.371338, 0.573567, 0.425011, 0.247448, 0.522633, 0.942719,
    0.907415, 0.228517, 0.986824, 0.848198, 0.284663, 0.271171, 0.915369,
    0.547810, 0.745923, 0.881908, 0.504883, 0.428851, 0.661564, 0.298134,
    0.974143, 0.105652, 0.342785, 0.412873, 0.440510, 0.350132, 0.211733,
    0.810887, 0.132996, 0.237006, 0.051134, 0.598440, 0.778627, 0.090580,
    0.634583, 0.339945, 0.511342, 0.660187, 0.184938, 0.614215, 0.064794,
    0.270805, 0.456836, 0.536392, 0.940503, 0.295905, 0.129487, 0.447837,
    0.526879, 0.729304, 0.910458, 0.972890, 0.761394, 0.249717, 0.346499,
    0.779652, 0.299671, 0.729285, 0.934442, 0.192382, 0.281585, 0.555343,
    0.601925, 0.071142, 0.063458, 0.207701, 0.356162, 0.631022, 0.165572,
    0.760330, 0.131365, 0.021257, 0.262862, 0.640069, 0.250123, 0.642715,
    0.204412, 0.149900, 0.125013, 0.202026, 0.475843, 0.260838, 0.853036,
    0.272570, 0.625518, 0.496405, 0.928861, 0.852380, 0.627557, 0.282402,
    0.475618, 0.273318, 0.944023, 0.592831, 0.608529, 0.662162, 0.839359,
    0.161527, 0.473947, 0.200285, 0.107977, 0.738683, 0.100967, 0.083270,
    0.366952, 0.199829, 0.879304, 0.068496, 0.810832, 0.152595, 0.411953,
    0.930309, 0.339304, 0.144649, 0.935868, 0.843733, 0.110269, 0.859667,
    0.592107, 0.216361, 0.175124, 0.385298] ),

  ([0.943571, 0.073397, 0.654073, 0.012421, 0.871151, 0.176305, 0.656026,
    0.542619, 0.655629, 0.156926, 0.542405, 0.800378, 0.902829, 0.078860,
    0.722526, 0.016022, 0.705557, 0.810053, 0.891964, 0.325236, 0.033692,
    0.248329, 0.572222, 0.780511, 0.462539, 0.377392, 0.129032, 0.521500,
    0.144963, 0.933775, 0.425214, 0.134312, 0.434156, 0.966491, 0.764672,
    0.731895, 0.062868, 0.070772, 0.283547, 0.786004, 0.285745, 0.576525,
    0.445143, 0.242653, 0.890561, 0.473159, 0.794336, 0.951994, 0.485031,
    0.352306, 0.628040, 0.943632, 0.965209, 0.149022, 0.738151, 0.579333,
    0.571642, 0.963286, 0.882778, 0.113498, 0.439985, 0.742515, 0.142247,
    0.693381, 0.051637, 0.107181, 0.816492, 0.329875, 0.491256, 0.099826,
    0.018921, 0.870327, 0.917081, 0.139225, 0.624866, 0.504471, 0.150365,
    0.961089, 0.728721, 0.834925, 0.790429, 0.825892, 0.267861, 0.043214,
    0.760887, 0.776238, 0.968657, 0.183111, 0.694266, 0.223640, 0.270516,
    0.131596, 0.060457, 0.646962, 0.385601, 0.229835, 0.445692, 0.683218,
    0.148625, 0.144536, 0.887997, 0.392621, 0.814661, 0.981414, 0.675863,
    0.978240, 0.459761, 0.181738, 0.515610, 0.742088, 0.142125, 0.233406,
    0.474563, 0.559130, 0.478713, 0.727805, 0.605640, 0.649739, 0.794183,
    0.793298, 0.659810, 0.932279, 0.498611, 0.437361, 0.792779, 0.737205,
    0.849818, 0.827906, 0.672170, 0.163610, 0.756523, 0.045228, 0.891018,
    0.859615, 0.779260, 0.336314, 0.094516, 0.507736, 0.984222, 0.401685,
    0.725700, 0.796930, 0.807337, 0.747398, 0.796442, 0.161718, 0.584033,
    0.632344, 0.590472, 0.070559, 0.901578, 0.642506, 0.703818, 0.144047,
    0.429609, 0.423597, 0.329569, 0.884640, 0.385693, 0.603046, 0.193243,
    0.298593, 0.291696, 0.432661, 0.044496, 0.192328, 0.177679, 0.183294,
    0.111820, 0.423322, 0.888943, 0.822748, 0.426374, 0.887570, 0.653188,
    0.007904, 0.421369, 0.524461, 0.563555, 0.923124, 0.712760, 0.120975,
    0.133824, 0.994690, 0.468154, 0.195196, 0.582293, 0.014374, 0.269692,
    0.741783, 0.000336, 0.702048, 0.877377, 0.119633, 0.062075, 0.238655,
    0.798944, 0.863826, 0.431074, 0.801965, 0.072726, 0.701865, 0.520829,
    0.634602, 0.169713, 0.557176, 0.765007, 0.677358, 0.420850, 0.819544,
    0.053285, 0.297617, 0.876003, 0.664510, 0.490219, 0.144963, 0.000885,
    0.703085, 0.131718, 0.665090, 0.118290, 0.742485, 0.857143, 0.302835,
    0.999176, 0.939543, 0.031739, 0.926389, 0.510941, 0.128086, 0.116794,
    0.503006, 0.728446],
   [0.351222, 0.278591, 0.283138, 0.122628, 0.763695,
    0.308245, 0.231191, 0.327072, 0.669178, 0.237753, 0.933039, 0.161955,
    0.527918, 0.162872, 0.276862, 0.338759, 0.013447, 0.500357, 0.758393,
    0.890117, 0.286404, 0.614922, 0.471315, 0.955186, 0.089488, 0.366257,
    0.978455, 0.616409, 0.306164, 0.160409, 0.159356, 0.978049, 0.097219,
    0.344033, 0.186289, 0.116885, 0.728207, 0.627205, 0.714860, 0.208562,
    0.727131, 0.828565, 0.158439, 0.466829, 0.971232, 0.121343, 0.161650,
    0.661611, 0.618124, 0.841358, 0.046860, 0.452121, 0.341010, 0.865947,
    0.152254, 0.966536, 0.213056, 0.304055, 0.335217, 0.523691, 0.087881,
    0.064809, 0.795485, 0.452027, 0.317999, 0.116250, 0.898968, 0.803284,
    0.544429, 0.616822, 0.841354, 0.611205, 0.371687, 0.033215, 0.256717,
    0.064430, 0.627021, 0.627504, 0.191870, 0.526017, 0.501716, 0.287086,
    0.784309, 0.622639, 0.183675, 0.468426, 0.212266, 0.355046, 0.108475,
    0.889961, 0.275599, 0.872669, 0.942839, 0.877238, 0.920511, 0.392231,
    0.563621, 0.144615, 0.633087, 0.349760, 0.505776, 0.827315, 0.389287,
    0.540466, 0.506721, 0.612825, 0.373225, 0.041362, 0.902200, 0.092558,
    0.739404, 0.272585, 0.388132, 0.298448, 0.321686, 0.374587, 0.935410,
    0.898459, 0.192054, 0.991002, 0.725184, 0.382465, 0.319403, 0.858241,
    0.597066, 0.710496, 0.882099, 0.531761, 0.456813, 0.845161, 0.499102,
    0.969086, 0.106525, 0.332143, 0.326130, 0.364720, 0.654414, 0.171305,
    0.596477, 0.110804, 0.178501, 0.057372, 0.576870, 0.814650, 0.061785,
    0.478826, 0.367008, 0.320375, 0.650806, 0.181174, 0.468965, 0.037388,
    0.270917, 0.385496, 0.362564, 0.833518, 0.339478, 0.046834, 0.462328,
    0.608506, 0.601353, 0.894656, 0.955409, 0.723455, 0.147482, 0.237962,
    0.735452, 0.206749, 0.757557, 0.933967, 0.214645, 0.375817, 0.574143,
    0.817046, 0.041647, 0.069035, 0.130061, 0.486610, 0.681156, 0.481305,
    0.869591, 0.204328, 0.104596, 0.343107, 0.564518, 0.275226, 0.611070,
    0.249097, 0.084293, 0.199324, 0.278827, 0.330948, 0.206980, 0.806283,
    0.256766, 0.588891, 0.445696, 0.906602, 0.709172, 0.561304, 0.262893,
    0.710889, 0.551355, 0.953251, 0.692670, 0.754259, 0.498363, 0.792302,
    0.159659, 0.299479, 0.167739, 0.071807, 0.487328, 0.132015, 0.081683,
    0.272535, 0.177688, 0.930233, 0.106226, 0.619949, 0.120131, 0.334437,
    0.914901, 0.213753, 0.088482, 0.942437, 0.858771, 0.095054, 0.726020,
    0.678025, 0.174585, 0.250140, 0.419005] ),

  ([0.601306, 0.883114, 0.558214, 0.413923, 0.130222, 0.384136, 0.449324,
    0.272683, 0.500229, 0.345470, 0.984649, 0.890042, 0.345927, 0.126225,
    0.419813, 0.756462, 0.566454, 0.909177, 0.362194, 0.286752, 0.101840,
    0.275582, 0.614643, 0.239540, 0.352245, 0.821070, 0.490219, 0.443525,
    0.020661, 0.968566, 0.628559, 0.236457, 0.661061, 0.635151, 0.845820,
    0.523545, 0.712516, 0.908383, 0.048616, 0.860897, 0.301248, 0.388562,
    0.744163, 0.470901, 0.591296, 0.353648, 0.176855, 0.595355, 0.965209,
    0.402234, 0.623585, 0.092685, 0.816248, 0.731590, 0.877987, 0.685690,
    0.233009, 0.706626, 0.455763, 0.765831, 0.358135, 0.876186, 0.551866,
    0.160466, 0.701590, 0.092624, 0.280770, 0.769280, 0.190893, 0.891629,
    0.231391, 0.475784, 0.238411, 0.787347, 0.867458, 0.240974, 0.607837,
    0.640522, 0.805078, 0.784509, 0.360515, 0.754662, 0.498337, 0.759972,
    0.663198, 0.857143, 0.364544, 0.830958, 0.738365, 0.621326, 0.879940,
    0.553301, 0.738395, 0.885830, 0.677480, 0.470473, 0.824793, 0.227515,
    0.177862, 0.328135, 0.233619, 0.044069, 0.784997, 0.813868, 0.608844,
    0.802728, 0.177038, 0.728782, 0.384106, 0.611042, 0.724540, 0.996948,
    0.494827, 0.766533, 0.566729, 0.418714, 0.201544, 0.440626, 0.377331,
    0.575030, 0.305979, 0.154241, 0.350841, 0.787622, 0.540605, 0.199896,
    0.441176, 0.542680, 0.413648, 0.667959, 0.382977, 0.283364, 0.290170,
    0.232246, 0.528031, 0.977935, 0.990936, 0.352031, 0.026643, 0.369121,
    0.689871, 0.045808, 0.386700, 0.311991, 0.391797, 0.894131, 0.940397,
    0.105319, 0.771477, 0.426649, 0.250557, 0.223823, 0.654927, 0.550768,
    0.987945, 0.356761, 0.925199, 0.177038, 0.309977, 0.159551, 0.132481,
    0.698355, 0.273354, 0.624531, 0.591235, 0.478805, 0.310312, 0.477004,
    0.244270, 0.008667, 0.301309, 0.503098, 0.076144, 0.881558, 0.274270,
    0.215339, 0.356426, 0.249977, 0.262093, 0.762444, 0.494186, 0.915983,
    0.349712, 0.489517, 0.785394, 0.712516, 0.441755, 0.054872, 0.833766,
    0.332133, 0.782250, 0.509812, 0.926908, 0.259377, 0.757439, 0.247291,
    0.148778, 0.962706, 0.013001, 0.226386, 0.509751, 0.002441, 0.417310,
    0.378002, 0.875271, 0.211280, 0.901120, 0.598773, 0.974853, 0.602954,
    0.705924, 0.238899, 0.272378, 0.165716, 0.071505, 0.490493, 0.978912,
    0.197302, 0.894253, 0.582476, 0.989257, 0.336314, 0.387463, 0.188452,
    0.023652, 0.948027, 0.274850, 0.953734, 0.756066, 0.019135, 0.548418,
    0.547594, 0.209479],
   [0.271663, 0.525723, 0.267998, 0.250128, 0.702226,
    0.229707, 0.175555, 0.297942, 0.860000, 0.169436, 0.887007, 0.126692,
    0.384973, 0.182938, 0.553939, 0.253207, 0.029636, 0.425111, 0.846293,
    0.842762, 0.304010, 0.762392, 0.447713, 0.952176, 0.056503, 0.447279,
    0.970657, 0.412395, 0.340561, 0.121831, 0.176847, 0.956278, 0.114158,
    0.355843, 0.137279, 0.076094, 0.595278, 0.711299, 0.589624, 0.171310,
    0.768125, 0.554197, 0.121300, 0.554864, 0.976230, 0.161199, 0.085808,
    0.386882, 0.683964, 0.831818, 0.057765, 0.313484, 0.508615, 0.827996,
    0.333389, 0.971560, 0.189127, 0.211048, 0.345118, 0.566802, 0.105797,
    0.080436, 0.782501, 0.518403, 0.218373, 0.281876, 0.906947, 0.889611,
    0.479506, 0.629542, 0.654916, 0.480508, 0.389275, 0.082686, 0.280760,
    0.109858, 0.733491, 0.446057, 0.249002, 0.541121, 0.502550, 0.371208,
    0.721902, 0.436620, 0.244237, 0.250580, 0.226793, 0.627351, 0.160097,
    0.747408, 0.375859, 0.871497, 0.926349, 0.874001, 0.869867, 0.307266,
    0.483985, 0.124589, 0.578719, 0.366280, 0.412193, 0.594651, 0.369025,
    0.481161, 0.576671, 0.467754, 0.224526, 0.031813, 0.821986, 0.090304,
    0.836334, 0.444711, 0.408687, 0.205362, 0.263692, 0.475828, 0.905762,
    0.909118, 0.301838, 0.988982, 0.774767, 0.589240, 0.246877, 0.876037,
    0.457144, 0.741628, 0.921321, 0.527897, 0.302698, 0.768976, 0.397204,
    0.953512, 0.101570, 0.219640, 0.337110, 0.454909, 0.462697, 0.162126,
    0.761869, 0.168659, 0.298322, 0.061892, 0.703901, 0.867304, 0.080736,
    0.314129, 0.380475, 0.314903, 0.665137, 0.094841, 0.523808, 0.073543,
    0.279188, 0.490220, 0.451759, 0.926845, 0.472939, 0.145560, 0.309754,
    0.286070, 0.687752, 0.920453, 0.965685, 0.776630, 0.163112, 0.167838,
    0.626627, 0.243982, 0.641384, 0.902528, 0.114211, 0.308358, 0.492737,
    0.566340, 0.048890, 0.067968, 0.103615, 0.316475, 0.394561, 0.284335,
    0.879411, 0.207121, 0.036808, 0.216855, 0.550790, 0.368205, 0.531398,
    0.365759, 0.165072, 0.177080, 0.274344, 0.397236, 0.225324, 0.880869,
    0.228650, 0.783659, 0.547302, 0.814027, 0.767327, 0.545063, 0.256435,
    0.519250, 0.316496, 0.922818, 0.742588, 0.447345, 0.628000, 0.811624,
    0.252169, 0.572887, 0.213673, 0.089029, 0.696801, 0.113802, 0.091420,
    0.428054, 0.235681, 0.820236, 0.133022, 0.686627, 0.107302, 0.561399,
    0.916099, 0.288236, 0.200918, 0.935256, 0.871452, 0.071271, 0.844837,
    0.711053, 0.182887, 0.241940, 0.460490] ),

  ([0.219306, 0.322092, 0.147404, 0.200659, 0.284280, 0.812433, 0.760430,
    0.114444, 0.378002, 0.977233, 0.289865, 0.789850, 0.589251, 0.843959,
    0.751396, 0.798212, 0.219275, 0.058535, 0.546159, 0.895779, 0.016999,
    0.686483, 0.196661, 0.930845, 0.017365, 0.796655, 0.452040, 0.987487,
    0.139592, 0.860195, 0.168432, 0.046815, 0.201483, 0.494491, 0.871120,
    0.947172, 0.506088, 0.584613, 0.404584, 0.924009, 0.656545, 0.312540,
    0.576678, 0.511643, 0.756066, 0.126225, 0.203162, 0.087252, 0.648824,
    0.179022, 0.458876, 0.838771, 0.357830, 0.271249, 0.941954, 0.437727,
    0.376904, 0.824976, 0.356761, 0.198767, 0.971770, 0.923154, 0.222907,
    0.006409, 0.147496, 0.944456, 0.515183, 0.790796, 0.438429, 0.825312,
    0.641896, 0.833399, 0.176000, 0.479720, 0.666982, 0.684164, 0.392041,
    0.408856, 0.182928, 0.971374, 0.012452, 0.031281, 0.739891, 0.884854,
    0.498703, 0.765130, 0.237953, 0.614887, 0.592303, 0.393262, 0.188604,
    0.526902, 0.319590, 0.743370, 0.251320, 0.354137, 0.912076, 0.213263,
    0.951964, 0.188818, 0.799341, 0.173467, 0.989166, 0.553789, 0.330271,
    0.777825, 0.034639, 0.334971, 0.379254, 0.213538, 0.434095, 0.856960,
    0.493179, 0.922300, 0.714560, 0.881954, 0.735740, 0.822626, 0.304758,
    0.814142, 0.885464, 0.066225, 0.374645, 0.890103, 0.143284, 0.358257,
    0.200201, 0.637074, 0.006165, 0.373455, 0.959990, 0.379772, 0.463057,
    0.299265, 0.369518, 0.077609, 0.169347, 0.037141, 0.059816, 0.272897,
    0.756066, 0.093295, 0.106357, 0.431806, 0.929991, 0.690115, 0.614643,
    0.459212, 0.521317, 0.129551, 0.768517, 0.668508, 0.134556, 0.939848,
    0.248054, 0.987823, 0.559313, 0.836421, 0.422315, 0.683584, 0.597034,
    0.028748, 0.224067, 0.383435, 0.460158, 0.904111, 0.112278, 0.678640,
    0.399579, 0.619312, 0.028840, 0.088046, 0.717002, 0.632313, 0.755638,
    0.664907, 0.818293, 0.704154, 0.578021, 0.027009, 0.464095, 0.402936,
    0.661733, 0.092349, 0.874020, 0.641255, 0.048372, 0.300729, 0.840358,
    0.277657, 0.676748, 0.603351, 0.508164, 0.314188, 0.335276, 0.000824,
    0.977386, 0.720634, 0.953093, 0.911679, 0.383465, 0.417096, 0.134404,
    0.151738, 0.612903, 0.446089, 0.344005, 0.806513, 0.309671, 0.865047,
    0.648915, 0.777062, 0.328990, 0.391095, 0.423078, 0.281167, 0.294504,
    0.328928, 0.921384, 0.090823, 0.415387, 0.813135, 0.128697, 0.787164,
    0.219306, 0.896023, 0.790979, 0.814234, 0.357738, 0.512772, 0.033723,
    0.612995, 0.139805],
   [0.337469, 0.211019, 0.303828, 0.169147, 0.566631,
    0.265004, 0.229917, 0.266692, 0.707275, 0.181060, 0.891105, 0.151850,
    0.330346, 0.236540, 0.566669, 0.367808, 0.022893, 0.342128, 0.828586,
    0.836092, 0.288965, 0.520367, 0.340710, 0.948377, 0.068229, 0.481998,
    0.961949, 0.321867, 0.409557, 0.096625, 0.235185, 0.963402, 0.086902,
    0.304833, 0.136653, 0.100314, 0.555993, 0.473476, 0.687371, 0.091541,
    0.824397, 0.761128, 0.176079, 0.461218, 0.972764, 0.101685, 0.092011,
    0.704997, 0.786809, 0.845653, 0.048572, 0.532518, 0.294126, 0.790332,
    0.263704, 0.972708, 0.345158, 0.097973, 0.310588, 0.411926, 0.068545,
    0.167609, 0.738812, 0.590916, 0.165281, 0.483342, 0.827012, 0.874491,
    0.706514, 0.764947, 0.810091, 0.569694, 0.516268, 0.052071, 0.182505,
    0.087599, 0.683585, 0.451136, 0.172146, 0.361382, 0.584432, 0.524382,
    0.697889, 0.607622, 0.269281, 0.404014, 0.383005, 0.465719, 0.133359,
    0.848459, 0.329923, 0.676798, 0.918466, 0.925962, 0.912074, 0.448496,
    0.592100, 0.143557, 0.664445, 0.531189, 0.525847, 0.767499, 0.299313,
    0.578332, 0.624400, 0.466934, 0.132613, 0.062552, 0.904959, 0.127579,
    0.818607, 0.446923, 0.465014, 0.273226, 0.337396, 0.414281, 0.956502,
    0.834423, 0.290169, 0.990990, 0.851944, 0.418151, 0.380813, 0.826651,
    0.462244, 0.779744, 0.812940, 0.421702, 0.511798, 0.737402, 0.242433,
    0.976064, 0.082025, 0.373773, 0.357622, 0.499017, 0.402349, 0.271163,
    0.773220, 0.143733, 0.266738, 0.050067, 0.499764, 0.788335, 0.090030,
    0.517396, 0.443833, 0.574189, 0.552392, 0.191110, 0.418867, 0.138714,
    0.305420, 0.657505, 0.572325, 0.943814, 0.480564, 0.142950, 0.344197,
    0.370294, 0.751791, 0.917778, 0.979460, 0.802610, 0.237874, 0.154067,
    0.546123, 0.157159, 0.840947, 0.881112, 0.184218, 0.258215, 0.482485,
    0.519804, 0.043765, 0.055481, 0.093186, 0.499097, 0.448311, 0.311212,
    0.855592, 0.258039, 0.041089, 0.214369, 0.600970, 0.397062, 0.636188,
    0.356101, 0.081942, 0.210988, 0.129305, 0.371435, 0.371639, 0.813555,
    0.371106, 0.809968, 0.372638, 0.920697, 0.714700, 0.493914, 0.314693,
    0.564047, 0.208476, 0.945736, 0.642147, 0.532650, 0.600253, 0.861064,
    0.231185, 0.557751, 0.243577, 0.108949, 0.781807, 0.164608, 0.116768,
    0.415680, 0.234421, 0.906828, 0.111577, 0.653296, 0.165778, 0.443490,
    0.832201, 0.205338, 0.099455, 0.939522, 0.892921, 0.067812, 0.864319,
    0.700760, 0.271345, 0.210610, 0.439696] ),

  ([0.854610, 0.475326, 0.616596, 0.950865, 0.181310, 0.239937, 0.388104,
    0.212043, 0.604663, 0.777734, 0.682180, 0.037111, 0.873531, 0.897580,
    0.711814, 0.242958, 0.692618, 0.919034, 0.401349, 0.869625, 0.605152,
    0.349773, 0.907193, 0.866420, 0.971740, 0.994659, 0.187109, 0.100467,
    0.075686, 0.902371, 0.899991, 0.343669, 0.887173, 0.056734, 0.416395,
    0.394208, 0.516037, 0.218085, 0.222419, 0.989471, 0.886166, 0.821223,
    0.496567, 0.665883, 0.661061, 0.336375, 0.142308, 0.222571, 0.953185,
    0.999573, 0.056734, 0.944517, 0.847346, 0.317728, 0.916807, 0.241737,
    0.270089, 0.256111, 0.264321, 0.861171, 0.235817, 0.513260, 0.171300,
    0.326365, 0.001282, 0.790063, 0.266274, 0.762535, 0.159398, 0.459365,
    0.403455, 0.762322, 0.203894, 0.542253, 0.755608, 0.448927, 0.595691,
    0.397046, 0.611988, 0.392743, 0.862850, 0.027497, 0.662709, 0.537706,
    0.764550, 0.416578, 0.050600, 0.793786, 0.051119, 0.791528, 0.971892,
    0.451552, 0.850826, 0.227088, 0.106937, 0.075411, 0.214850, 0.492874,
    0.662587, 0.031648, 0.851985, 0.550890, 0.306497, 0.307230, 0.583544,
    0.610065, 0.775964, 0.776147, 0.550768, 0.143223, 0.441389, 0.569140,
    0.705100, 0.773644, 0.606220, 0.703238, 0.612903, 0.436659, 0.824488,
    0.627277, 0.106082, 0.723136, 0.016999, 0.839625, 0.809595, 0.810663,
    0.668081, 0.234626, 0.076937, 0.889065, 0.882870, 0.333628, 0.365429,
    0.486129, 0.587970, 0.057009, 0.581957, 0.600085, 0.655538, 0.193640,
    0.430799, 0.044923, 0.232307, 0.223701, 0.294565, 0.914945, 0.055483,
    0.651296, 0.679708, 0.574450, 0.035493, 0.503189, 0.757500, 0.079470,
    0.888302, 0.149663, 0.032319, 0.437056, 0.097079, 0.104068, 0.667837,
    0.608753, 0.985992, 0.956877, 0.502762, 0.664693, 0.185675, 0.100833,
    0.287271, 0.994018, 0.273446, 0.403882, 0.171575, 0.978393, 0.867855,
    0.484603, 0.977294, 0.034639, 0.959990, 0.748314, 0.283578, 0.432752,
    0.762108, 0.838771, 0.859127, 0.795434, 0.855464, 0.662252, 0.470412,
    0.685659, 0.917722, 0.640034, 0.599139, 0.188330, 0.812006, 0.345836,
    0.098178, 0.892514, 0.318552, 0.184057, 0.318918, 0.179724, 0.290109,
    0.265450, 0.740165, 0.226020, 0.512284, 0.136235, 0.630360, 0.622272,
    0.050356, 0.516984, 0.774438, 0.020600, 0.363872, 0.707480, 0.795923,
    0.712027, 0.969573, 0.814051, 0.106540, 0.542009, 0.934843, 0.455031,
    0.013642, 0.070437, 0.982299, 0.101444, 0.017182, 0.381726, 0.486923,
    0.708243, 0.827479],
   [0.358315, 0.270049, 0.342954, 0.214249, 0.838752,
    0.310564, 0.336771, 0.491659, 0.732358, 0.146048, 0.875334, 0.177203,
    0.340052, 0.229098, 0.470689, 0.199422, 0.013477, 0.437964, 0.834417,
    0.801902, 0.374778, 0.710470, 0.380647, 0.932384, 0.136688, 0.415547,
    0.964993, 0.435191, 0.308797, 0.163246, 0.208703, 0.966874, 0.093376,
    0.265505, 0.059608, 0.236134, 0.535674, 0.631452, 0.664845, 0.282025,
    0.768258, 0.736782, 0.122918, 0.461566, 0.987912, 0.084404, 0.129183,
    0.480177, 0.727945, 0.669787, 0.062807, 0.564469, 0.428409, 0.826974,
    0.384675, 0.966756, 0.210445, 0.272487, 0.317097, 0.370697, 0.125074,
    0.121726, 0.635255, 0.498751, 0.333923, 0.279037, 0.831576, 0.742353,
    0.554140, 0.759262, 0.788903, 0.342407, 0.402883, 0.054452, 0.192420,
    0.161426, 0.594132, 0.626459, 0.311456, 0.580723, 0.643488, 0.466939,
    0.751366, 0.460380, 0.344418, 0.299266, 0.238402, 0.530317, 0.201173,
    0.845135, 0.368270, 0.901918, 0.933553, 0.879270, 0.896686, 0.242673,
    0.645876, 0.221722, 0.671788, 0.696868, 0.613856, 0.594100, 0.345442,
    0.478488, 0.365499, 0.560186, 0.419429, 0.068769, 0.764765, 0.122668,
    0.800360, 0.269527, 0.402713, 0.334230, 0.186238, 0.417001, 0.967712,
    0.853496, 0.310179, 0.990401, 0.731177, 0.343208, 0.224512, 0.855574,
    0.460790, 0.815310, 0.857852, 0.702756, 0.390921, 0.820575, 0.520593,
    0.972868, 0.068325, 0.330995, 0.461637, 0.405847, 0.510358, 0.189043,
    0.743286, 0.146544, 0.298520, 0.047979, 0.553638, 0.834975, 0.179460,
    0.576135, 0.432415, 0.424000, 0.680846, 0.195304, 0.569258, 0.102375,
    0.234922, 0.416825, 0.427743, 0.919058, 0.366473, 0.080673, 0.323088,
    0.458077, 0.866718, 0.887048, 0.954464, 0.853763, 0.211882, 0.257413,
    0.401140, 0.143234, 0.711803, 0.858469, 0.176694, 0.376906, 0.538888,
    0.499580, 0.083381, 0.049338, 0.126933, 0.301235, 0.503423, 0.417381,
    0.790785, 0.244376, 0.054084, 0.341139, 0.605380, 0.327142, 0.557695,
    0.273406, 0.123661, 0.177072, 0.239960, 0.264496, 0.289714, 0.758051,
    0.287238, 0.796446, 0.445350, 0.931600, 0.752621, 0.391089, 0.172409,
    0.373470, 0.299196, 0.900410, 0.786394, 0.402751, 0.604255, 0.859393,
    0.225666, 0.533102, 0.141675, 0.139006, 0.737770, 0.172180, 0.215538,
    0.462962, 0.197081, 0.947766, 0.109388, 0.597156, 0.074044, 0.534133,
    0.892876, 0.319288, 0.078681, 0.906544, 0.855450, 0.069378, 0.791340,
    0.571897, 0.240928, 0.309915, 0.333618] ),

  ([0.451521, 0.147221, 0.793268, 0.134800, 0.476577, 0.611164, 0.619312,
    0.662313, 0.073580, 0.838679, 0.636280, 0.533280, 0.753319, 0.481674,
    0.839106, 0.484176, 0.576586, 0.062868, 0.198126, 0.954619, 0.398022,
    0.234657, 0.817927, 0.585437, 0.603961, 0.899411, 0.980773, 0.156499,
    0.750755, 0.472213, 0.731285, 0.494858, 0.009735, 0.067598, 0.158452,
    0.385083, 0.825037, 0.891324, 0.030732, 0.012787, 0.690573, 0.618091,
    0.941404, 0.972564, 0.452345, 0.037629, 0.619587, 0.371441, 0.042665,
    0.748924, 0.563768, 0.059786, 0.051729, 0.184606, 0.653706, 0.519852,
    0.043977, 0.747215, 0.897092, 0.444105, 0.024262, 0.337168, 0.967315,
    0.534165, 0.961150, 0.055483, 0.688437, 0.551775, 0.772637, 0.360759,
    0.123692, 0.152776, 0.681478, 0.463057, 0.423811, 0.535783, 0.345561,
    0.235115, 0.091189, 0.436445, 0.670095, 0.422437, 0.816492, 0.498489,
    0.707541, 0.433393, 0.543687, 0.553453, 0.551897, 0.490768, 0.920011,
    0.839228, 0.633168, 0.425855, 0.786615, 0.689840, 0.318613, 0.896237,
    0.866817, 0.726920, 0.226783, 0.308817, 0.307596, 0.084445, 0.160772,
    0.229316, 0.231239, 0.697897, 0.066927, 0.558763, 0.952391, 0.189154,
    0.924924, 0.259499, 0.018006, 0.378399, 0.976012, 0.910947, 0.725455,
    0.954070, 0.195318, 0.876461, 0.275369, 0.332316, 0.414594, 0.363414,
    0.215857, 0.237434, 0.001343, 0.156438, 0.333476, 0.033784, 0.501236,
    0.306101, 0.648152, 0.341227, 0.149297, 0.553819, 0.667592, 0.964965,
    0.656789, 0.774438, 0.557909, 0.670919, 0.179449, 0.217383, 0.386395,
    0.838435, 0.873989, 0.828394, 0.092746, 0.520737, 0.948180, 0.431837,
    0.345286, 0.945158, 0.611988, 0.056398, 0.937925, 0.983947, 0.834864,
    0.184088, 0.884640, 0.627003, 0.315989, 0.204352, 0.867244, 0.987884,
    0.573992, 0.854793, 0.193091, 0.874325, 0.561632, 0.929228, 0.918790,
    0.454176, 0.712302, 0.034577, 0.295877, 0.048708, 0.824549, 0.678182,
    0.195654, 0.583819, 0.690542, 0.465743, 0.668020, 0.730705, 0.874996,
    0.692587, 0.291879, 0.267403, 0.550737, 0.108310, 0.472610, 0.692251,
    0.797235, 0.136631, 0.343059, 0.620319, 0.268136, 0.331645, 0.424207,
    0.994598, 0.634236, 0.351482, 0.702170, 0.642689, 0.708243, 0.230903,
    0.277017, 0.210700, 0.657064, 0.234046, 0.240455, 0.004852, 0.208808,
    0.068270, 0.938200, 0.773156, 0.259468, 0.740928, 0.273110, 0.957274,
    0.786981, 0.839503, 0.206091, 0.446608, 0.477462, 0.517289, 0.109989,
    0.365703, 0.971221],
   [0.322975, 0.414170, 0.161146, 0.219434, 0.685011,
    0.207119, 0.124562, 0.313554, 0.680383, 0.204607, 0.926401, 0.123031,
    0.342319, 0.160562, 0.383025, 0.263413, 0.031530, 0.278214, 0.854517,
    0.938668, 0.207718, 0.530081, 0.599408, 0.967141, 0.060306, 0.216206,
    0.956149, 0.457582, 0.287160, 0.123662, 0.170455, 0.944915, 0.075664,
    0.367949, 0.137354, 0.245977, 0.789458, 0.601613, 0.753918, 0.205538,
    0.801701, 0.727608, 0.099538, 0.372815, 0.980670, 0.128872, 0.153952,
    0.733913, 0.697334, 0.832264, 0.048116, 0.476656, 0.542969, 0.813115,
    0.428087, 0.974934, 0.283452, 0.267722, 0.308373, 0.467845, 0.073733,
    0.060755, 0.726314, 0.632607, 0.207968, 0.198739, 0.724649, 0.827431,
    0.659246, 0.606561, 0.804978, 0.605795, 0.421802, 0.080890, 0.184399,
    0.042613, 0.669469, 0.636515, 0.163279, 0.506129, 0.443891, 0.538560,
    0.687417, 0.616605, 0.243001, 0.421577, 0.417744, 0.332821, 0.104680,
    0.814680, 0.274723, 0.854675, 0.928105, 0.822819, 0.907391, 0.392828,
    0.560366, 0.167488, 0.771640, 0.421482, 0.502021, 0.705366, 0.356323,
    0.236132, 0.465837, 0.673047, 0.271604, 0.044967, 0.875918, 0.101957,
    0.690344, 0.418263, 0.416007, 0.385675, 0.177956, 0.381637, 0.926377,
    0.834779, 0.212896, 0.991925, 0.837922, 0.493060, 0.257955, 0.881184,
    0.455624, 0.759888, 0.797075, 0.476411, 0.546274, 0.653626, 0.437864,
    0.979247, 0.101421, 0.310239, 0.301380, 0.315334, 0.540806, 0.179717,
    0.803455, 0.157591, 0.320087, 0.061332, 0.563749, 0.755219, 0.043938,
    0.411661, 0.403751, 0.445964, 0.558204, 0.265296, 0.639173, 0.087912,
    0.230078, 0.404120, 0.337301, 0.932361, 0.434332, 0.084389, 0.343341,
    0.257858, 0.761906, 0.918835, 0.952784, 0.774380, 0.105933, 0.159839,
    0.830403, 0.338071, 0.526166, 0.863985, 0.233685, 0.379596, 0.616285,
    0.618324, 0.069956, 0.031873, 0.139768, 0.470940, 0.707807, 0.243367,
    0.727987, 0.305121, 0.104586, 0.262189, 0.546923, 0.339179, 0.566545,
    0.340525, 0.118514, 0.187525, 0.391617, 0.309406, 0.182629, 0.782616,
    0.233684, 0.765575, 0.523726, 0.866878, 0.699958, 0.572039, 0.237482,
    0.526532, 0.374557, 0.928282, 0.707831, 0.618044, 0.446578, 0.624965,
    0.199537, 0.468197, 0.182506, 0.083061, 0.585536, 0.276978, 0.076367,
    0.358145, 0.224962, 0.838192, 0.129973, 0.763684, 0.229108, 0.557319,
    0.866519, 0.293349, 0.163828, 0.895601, 0.903358, 0.058000, 0.789358,
    0.591071, 0.270399, 0.131062, 0.486600] ),

  ([0.965209, 0.133641, 0.925626, 0.133671, 0.650899, 0.231605, 0.871517,
    0.258309, 0.107364, 0.016541, 0.557054, 0.607166, 0.550859, 0.089724,
    0.176702, 0.195593, 0.110752, 0.006592, 0.188025, 0.227668, 0.951659,
    0.533219, 0.454115, 0.087741, 0.069246, 0.349925, 0.138401, 0.295358,
    0.041841, 0.858791, 0.882534, 0.328928, 0.517289, 0.250343, 0.298502,
    0.725211, 0.718314, 0.486862, 0.306864, 0.359874, 0.746239, 0.357524,
    0.351665, 0.316630, 0.964873, 0.262246, 0.023408, 0.249794, 0.245796,
    0.880398, 0.122013, 0.647938, 0.356243, 0.380047, 0.689871, 0.903531,
    0.270577, 0.325297, 0.047121, 0.595904, 0.687124, 0.936308, 0.360454,
    0.893399, 0.531205, 0.859523, 0.775628, 0.480361, 0.725822, 0.103824,
    0.646290, 0.916501, 0.010987, 0.299142, 0.889737, 0.833583, 0.093417,
    0.933103, 0.000305, 0.876553, 0.907254, 0.722800, 0.753166, 0.794946,
    0.267495, 0.777764, 0.127628, 0.590930, 0.697531, 0.709616, 0.483627,
    0.130345, 0.711173, 0.345744, 0.520463, 0.122745, 0.331400, 0.202582,
    0.050539, 0.876949, 0.126804, 0.374828, 0.118503, 0.737968, 0.546495,
    0.997009, 0.497635, 0.612384, 0.835261, 0.933500, 0.093997, 0.487197,
    0.310099, 0.853481, 0.290597, 0.349590, 0.279397, 0.346660, 0.761834,
    0.412946, 0.385571, 0.236427, 0.789911, 0.056154, 0.653279, 0.746544,
    0.614765, 0.381603, 0.023560, 0.677328, 0.848170, 0.798975, 0.655934,
    0.248329, 0.483566, 0.540361, 0.778741, 0.762841, 0.533067, 0.513596,
    0.370281, 0.751061, 0.822260, 0.399396, 0.450819, 0.748253, 0.974914,
    0.399030, 0.267159, 0.363384, 0.118046, 0.538774, 0.151311, 0.795740,
    0.339244, 0.937040, 0.334025, 0.454329, 0.426740, 0.940641, 0.494705,
    0.837642, 0.924558, 0.536699, 0.328990, 0.329020, 0.032716, 0.946013,
    0.914975, 0.064608, 0.384930, 0.804102, 0.159703, 0.529588, 0.234169,
    0.837001, 0.106906, 0.039155, 0.077731, 0.436689, 0.387310, 0.760826,
    0.253212, 0.043825, 0.592669, 0.433638, 0.536180, 0.742943, 0.855220,
    0.441084, 0.271157, 0.976867, 0.412976, 0.393719, 0.067049, 0.786706,
    0.443129, 0.877956, 0.588458, 0.483413, 0.943754, 0.526688, 0.473434,
    0.156957, 0.945952, 0.069094, 0.910062, 0.930143, 0.837275, 0.514573,
    0.902127, 0.362255, 0.077548, 0.128025, 0.755486, 0.909848, 0.088778,
    0.352489, 0.816553, 0.850124, 0.599902, 0.334941, 0.993927, 0.573504,
    0.227882, 0.212073, 0.094333, 0.651753, 0.576739, 0.812311, 0.504532,
    0.587451, 0.634816],
   [0.302431, 0.592346, 0.385344, 0.262467, 0.590451,
    0.183795, 0.213462, 0.439501, 0.685453, 0.160185, 0.933631, 0.128044,
    0.473315, 0.155567, 0.492202, 0.220253, 0.019522, 0.469708, 0.877853,
    0.882415, 0.430326, 0.645252, 0.298033, 0.974497, 0.075881, 0.454331,
    0.980756, 0.353203, 0.227064, 0.112352, 0.204441, 0.986582, 0.111204,
    0.360922, 0.104295, 0.042607, 0.664624, 0.575153, 0.703935, 0.219955,
    0.724316, 0.760176, 0.086626, 0.569313, 0.985771, 0.070120, 0.125450,
    0.608872, 0.735175, 0.869160, 0.116281, 0.382006, 0.535477, 0.916268,
    0.339548, 0.951149, 0.269138, 0.158267, 0.227921, 0.496810, 0.078373,
    0.109946, 0.857936, 0.460175, 0.325318, 0.226608, 0.881037, 0.765901,
    0.643060, 0.624702, 0.860348, 0.550049, 0.440815, 0.045541, 0.260502,
    0.076994, 0.577882, 0.615792, 0.139510, 0.358114, 0.612593, 0.347721,
    0.818075, 0.526762, 0.377618, 0.514885, 0.205696, 0.501251, 0.196091,
    0.886461, 0.334135, 0.829124, 0.919315, 0.913637, 0.931191, 0.463876,
    0.534980, 0.183099, 0.612192, 0.441730, 0.502768, 0.648400, 0.513146,
    0.572191, 0.598630, 0.502384, 0.334881, 0.031650, 0.855085, 0.124462,
    0.852059, 0.450404, 0.460454, 0.470191, 0.387106, 0.341040, 0.953467,
    0.868460, 0.346095, 0.991675, 0.840988, 0.432867, 0.309167, 0.832854,
    0.502416, 0.631140, 0.913146, 0.646113, 0.533057, 0.744471, 0.344817,
    0.940144, 0.095737, 0.351065, 0.352773, 0.470006, 0.334397, 0.168739,
    0.758467, 0.118992, 0.163775, 0.065261, 0.683652, 0.880562, 0.097123,
    0.524062, 0.373206, 0.612702, 0.639353, 0.118260, 0.626205, 0.073664,
    0.238101, 0.415854, 0.550570, 0.891418, 0.355098, 0.070208, 0.362777,
    0.318568, 0.738166, 0.900724, 0.976352, 0.702925, 0.146500, 0.299967,
    0.705262, 0.364984, 0.552743, 0.965066, 0.116578, 0.213095, 0.466038,
    0.747374, 0.067506, 0.087477, 0.178816, 0.416269, 0.468249, 0.214696,
    0.835123, 0.118108, 0.025186, 0.379601, 0.633495, 0.177899, 0.682522,
    0.295777, 0.141661, 0.153813, 0.116872, 0.401177, 0.173447, 0.851914,
    0.213767, 0.629566, 0.332266, 0.909032, 0.721796, 0.678533, 0.154774,
    0.709337, 0.292937, 0.943155, 0.633317, 0.467546, 0.571542, 0.892620,
    0.209587, 0.472640, 0.425492, 0.096146, 0.488989, 0.063471, 0.114715,
    0.354080, 0.168293, 0.811268, 0.093427, 0.730772, 0.163385, 0.495506,
    0.936379, 0.234286, 0.082734, 0.884049, 0.750206, 0.102785, 0.857904,
    0.691171, 0.194803, 0.207255, 0.440377] ),

  ([0.929533, 0.249916, 0.651570, 0.752678, 0.825922, 0.961516, 0.715232,
    0.981933, 0.119022, 0.782250, 0.481582, 0.056917, 0.710440, 0.744163,
    0.024689, 0.800104, 0.911008, 0.647359, 0.041017, 0.232368, 0.420331,
    0.972259, 0.720145, 0.170141, 0.315378, 0.856197, 0.640889, 0.589434,
    0.705618, 0.666005, 0.599170, 0.539232, 0.209906, 0.197089, 0.773492,
    0.884823, 0.912564, 0.031281, 0.134800, 0.662252, 0.953429, 0.083590,
    0.506851, 0.325632, 0.409558, 0.869930, 0.182592, 0.668203, 0.624042,
    0.526902, 0.504379, 0.698263, 0.637928, 0.114566, 0.312449, 0.251686,
    0.882595, 0.233741, 0.669393, 0.622059, 0.787561, 0.489059, 0.765893,
    0.989288, 0.460860, 0.828913, 0.414533, 0.928587, 0.097812, 0.293558,
    0.037843, 0.780816, 0.274758, 0.202918, 0.556444, 0.165197, 0.783349,
    0.314676, 0.083987, 0.416028, 0.162694, 0.984741, 0.835170, 0.224250,
    0.584674, 0.860591, 0.152470, 0.265755, 0.248909, 0.139317, 0.058779,
    0.096744, 0.944182, 0.921293, 0.241127, 0.098422, 0.931639, 0.690481,
    0.872860, 0.751366, 0.806818, 0.453597, 0.179449, 0.021455, 0.496414,
    0.568194, 0.155065, 0.138371, 0.045839, 0.791528, 0.335582, 0.547716,
    0.354442, 0.581622, 0.034608, 0.318491, 0.513718, 0.181249, 0.948485,
    0.786798, 0.905820, 0.516587, 0.536851, 0.716880, 0.717704, 0.441359,
    0.084780, 0.761498, 0.027741, 0.358196, 0.852809, 0.501877, 0.120792,
    0.747978, 0.220954, 0.849330, 0.187933, 0.638630, 0.233589, 0.089114,
    0.067476, 0.544877, 0.450301, 0.348674, 0.182867, 0.909635, 0.510178,
    0.770287, 0.334483, 0.578784, 0.314920, 0.170507, 0.500961, 0.340342,
    0.237617, 0.467055, 0.306589, 0.059359, 0.262856, 0.654500, 0.310953,
    0.439802, 0.464888, 0.610065, 0.777306, 0.944517, 0.730033, 0.510666,
    0.075198, 0.904721, 0.129185, 0.142705, 0.374828, 0.350352, 0.847346,
    0.885556, 0.787927, 0.592059, 0.075533, 0.650136, 0.612690, 0.086581,
    0.772607, 0.553880, 0.838374, 0.616688, 0.701407, 0.613178, 0.565600,
    0.316538, 0.647694, 0.234718, 0.499344, 0.574175, 0.226051, 0.787072,
    0.170141, 0.342265, 0.180517, 0.033082, 0.040284, 0.888180, 0.585284,
    0.705618, 0.150731, 0.514817, 0.852107, 0.006226, 0.465651, 0.283395,
    0.950774, 0.309885, 0.570208, 0.269387, 0.748466, 0.855129, 0.878201,
    0.383007, 0.874722, 0.702322, 0.005676, 0.285348, 0.017823, 0.740684,
    0.467086, 0.431471, 0.059359, 0.025330, 0.349376, 0.771599, 0.952605,
    0.225471, 0.121464],
   [0.471172, 0.394669, 0.206750, 0.210992, 0.672674,
    0.219721, 0.244692, 0.426030, 0.784261, 0.125930, 0.920721, 0.154459,
    0.450891, 0.147751, 0.367723, 0.353484, 0.026113, 0.408033, 0.834816,
    0.836353, 0.222549, 0.727688, 0.436814, 0.937279, 0.062492, 0.322380,
    0.970168, 0.358693, 0.165828, 0.163289, 0.179660, 0.946080, 0.107585,
    0.214507, 0.120466, 0.146463, 0.513517, 0.744142, 0.796061, 0.229379,
    0.872125, 0.699375, 0.097177, 0.456963, 0.983115, 0.103819, 0.067400,
    0.572813, 0.619288, 0.738678, 0.064006, 0.534990, 0.457646, 0.821854,
    0.245365, 0.935265, 0.292294, 0.273248, 0.484045, 0.650145, 0.134589,
    0.129359, 0.760950, 0.500222, 0.244806, 0.295520, 0.888711, 0.794874,
    0.648125, 0.671853, 0.861657, 0.618463, 0.418073, 0.037680, 0.213474,
    0.081569, 0.498616, 0.466083, 0.254703, 0.579328, 0.489857, 0.365154,
    0.823990, 0.691592, 0.177938, 0.402626, 0.413972, 0.432276, 0.128408,
    0.861022, 0.334743, 0.852509, 0.905923, 0.855449, 0.907655, 0.449490,
    0.525716, 0.146824, 0.576212, 0.621424, 0.631967, 0.680759, 0.213491,
    0.453037, 0.455632, 0.589247, 0.386547, 0.051896, 0.834187, 0.065552,
    0.821578, 0.352428, 0.257310, 0.496232, 0.325953, 0.415318, 0.944347,
    0.879332, 0.271775, 0.994542, 0.755022, 0.297164, 0.397653, 0.922277,
    0.248507, 0.646424, 0.828524, 0.605859, 0.566800, 0.766935, 0.501635,
    0.968145, 0.101199, 0.250424, 0.261777, 0.417199, 0.420268, 0.129902,
    0.670874, 0.244133, 0.465330, 0.072836, 0.635216, 0.847806, 0.110087,
    0.366808, 0.501077, 0.518786, 0.719245, 0.116495, 0.614688, 0.075322,
    0.230603, 0.497451, 0.382493, 0.916194, 0.445191, 0.092338, 0.298070,
    0.477992, 0.755918, 0.914011, 0.974732, 0.707787, 0.173469, 0.199932,
    0.765572, 0.213141, 0.596297, 0.892776, 0.147179, 0.364556, 0.506639,
    0.737935, 0.078835, 0.081713, 0.207005, 0.301130, 0.607415, 0.176493,
    0.729900, 0.207783, 0.024178, 0.266947, 0.655454, 0.133159, 0.598460,
    0.426653, 0.098941, 0.108835, 0.144931, 0.394514, 0.293194, 0.870920,
    0.156846, 0.751377, 0.464677, 0.895932, 0.790477, 0.579755, 0.462048,
    0.682392, 0.230107, 0.921158, 0.641127, 0.610895, 0.569350, 0.699673,
    0.178217, 0.276934, 0.170802, 0.081585, 0.765277, 0.194187, 0.089230,
    0.378231, 0.151939, 0.827206, 0.093455, 0.748796, 0.175005, 0.362430,
    0.899749, 0.406536, 0.105491, 0.936633, 0.825872, 0.095697, 0.877409,
    0.610769, 0.203597, 0.204503, 0.606680] ),

  ([0.142003, 0.751518, 0.465590, 0.234352, 0.876461, 0.696310, 0.339915,
    0.668569, 0.669485, 0.761986, 0.382611, 0.085208, 0.223121, 0.575793,
    0.773675, 0.736900, 0.707907, 0.110324, 0.562853, 0.794153, 0.569628,
    0.058077, 0.192145, 0.244758, 0.713095, 0.294137, 0.598560, 0.021302,
    0.594043, 0.332591, 0.677908, 0.513382, 0.250404, 0.183752, 0.391614,
    0.120975, 0.804621, 0.517899, 0.296945, 0.005188, 0.467360, 0.541704,
    0.782586, 0.692190, 0.574999, 0.494095, 0.790277, 0.687185, 0.691214,
    0.167272, 0.304422, 0.754418, 0.304331, 0.359569, 0.390179, 0.019105,
    0.151738, 0.666005, 0.061647, 0.548479, 0.702445, 0.513138, 0.761681,
    0.566820, 0.828913, 0.844234, 0.733970, 0.962340, 0.199927, 0.361064,
    0.069002, 0.240516, 0.425275, 0.728690, 0.705344, 0.581744, 0.483444,
    0.649129, 0.166875, 0.158025, 0.464034, 0.210852, 0.317911, 0.366222,
    0.155736, 0.419538, 0.917020, 0.133152, 0.511338, 0.316782, 0.250801,
    0.949675, 0.520859, 0.593127, 0.629414, 0.788903, 0.524155, 0.101291,
    0.024079, 0.566149, 0.494308, 0.176244, 0.628986, 0.295633, 0.322825,
    0.167791, 0.627735, 0.600818, 0.638203, 0.092868, 0.946715, 0.734642,
    0.188726, 0.812616, 0.275399, 0.765618, 0.321360, 0.641591, 0.136143,
    0.086184, 0.587024, 0.794610, 0.283456, 0.899930, 0.004608, 0.577685,
    0.214942, 0.842891, 0.014191, 0.729667, 0.074770, 0.396619, 0.650868,
    0.820124, 0.731040, 0.247932, 0.970763, 0.110355, 0.307810, 0.252602,
    0.260140, 0.783593, 0.954222, 0.158452, 0.058901, 0.950316, 0.130284,
    0.744774, 0.529954, 0.335520, 0.192419, 0.533708, 0.205237, 0.053743,
    0.558275, 0.730583, 0.640339, 0.378185, 0.233345, 0.548448, 0.008240,
    0.910215, 0.980041, 0.574084, 0.163976, 0.055635, 0.910550, 0.331095,
    0.211127, 0.213782, 0.784875, 0.696524, 0.101505, 0.585772, 0.795099,
    0.327189, 0.299417, 0.007965, 0.117161, 0.752190, 0.041505, 0.717429,
    0.011841, 0.287454, 0.223609, 0.454909, 0.755211, 0.429151, 0.445753,
    0.812281, 0.180944, 0.881344, 0.246742, 0.230079, 0.115024, 0.875149,
    0.059297, 0.551988, 0.484176, 0.934996, 0.917264, 0.541856, 0.379467,
    0.748222, 0.445784, 0.270180, 0.856349, 0.294778, 0.166387, 0.775903,
    0.751946, 0.892605, 0.647328, 0.909574, 0.301675, 0.315500, 0.531083,
    0.764855, 0.835444, 0.639454, 0.970031, 0.603778, 0.335368, 0.973693,
    0.501480, 0.682699, 0.136326, 0.732688, 0.893765, 0.884610, 0.549852,
    0.605731, 0.993652],
   [0.253504, 0.534326, 0.251760, 0.237928, 0.664410,
    0.126609, 0.132684, 0.418006, 0.666470, 0.215330, 0.920184, 0.117055,
    0.355147, 0.170783, 0.327884, 0.256327, 0.027910, 0.470747, 0.880988,
    0.889491, 0.479139, 0.521001, 0.393600, 0.972722, 0.085265, 0.415580,
    0.972281, 0.482544, 0.346985, 0.134187, 0.148290, 0.967033, 0.064457,
    0.308757, 0.091188, 0.106056, 0.666364, 0.644436, 0.738676, 0.157409,
    0.796504, 0.819582, 0.161226, 0.572395, 0.985212, 0.056289, 0.124700,
    0.684193, 0.738343, 0.858700, 0.119422, 0.531593, 0.540814, 0.806578,
    0.255111, 0.953920, 0.375051, 0.132877, 0.304271, 0.424460, 0.108830,
    0.140324, 0.726330, 0.390954, 0.344656, 0.297103, 0.836113, 0.845710,
    0.541340, 0.593495, 0.799546, 0.607697, 0.385357, 0.059555, 0.275257,
    0.043167, 0.741677, 0.452371, 0.186232, 0.458056, 0.634944, 0.440253,
    0.781245, 0.585590, 0.386615, 0.299644, 0.311233, 0.638113, 0.139079,
    0.818473, 0.272349, 0.785139, 0.910448, 0.847825, 0.909313, 0.463918,
    0.570289, 0.136830, 0.605815, 0.361042, 0.480547, 0.633562, 0.233467,
    0.466913, 0.601511, 0.711690, 0.285150, 0.039565, 0.908040, 0.081223,
    0.741324, 0.409105, 0.448214, 0.349451, 0.247382, 0.355812, 0.891038,
    0.892278, 0.230916, 0.983817, 0.739059, 0.550368, 0.366082, 0.896731,
    0.351754, 0.755379, 0.861318, 0.627702, 0.478943, 0.759569, 0.411450,
    0.968553, 0.062213, 0.275821, 0.331454, 0.331865, 0.397601, 0.223281,
    0.710319, 0.145954, 0.317140, 0.057056, 0.578738, 0.816384, 0.047016,
    0.525610, 0.336833, 0.552102, 0.683525, 0.119884, 0.484933, 0.066421,
    0.280478, 0.551438, 0.287947, 0.877956, 0.468814, 0.059983, 0.421428,
    0.275246, 0.737221, 0.887111, 0.973068, 0.761741, 0.125024, 0.179706,
    0.712262, 0.175115, 0.647305, 0.929135, 0.099306, 0.232157, 0.620496,
    0.679094, 0.034862, 0.051003, 0.142482, 0.370931, 0.493494, 0.258032,
    0.837991, 0.177554, 0.086700, 0.207737, 0.563446, 0.417696, 0.483721,
    0.268154, 0.138681, 0.203293, 0.290859, 0.364657, 0.312939, 0.843912,
    0.214481, 0.670471, 0.528396, 0.848559, 0.746439, 0.552310, 0.207122,
    0.532526, 0.364218, 0.940528, 0.635287, 0.556140, 0.505382, 0.879060,
    0.255610, 0.447759, 0.191044, 0.081017, 0.529700, 0.163505, 0.202604,
    0.245266, 0.199667, 0.866675, 0.114402, 0.669242, 0.149501, 0.338364,
    0.852990, 0.361792, 0.111204, 0.925449, 0.829030, 0.085374, 0.849162,
    0.590237, 0.245031, 0.150276, 0.340917] ),

  ([0.564470, 0.693442, 0.879666, 0.107578, 0.513840, 0.306131, 0.271432,
    0.947142, 0.450636, 0.831721, 0.927030, 0.669912, 0.940580, 0.550462,
    0.742088, 0.047792, 0.156682, 0.041353, 0.661550, 0.293374, 0.382855,
    0.755455, 0.113773, 0.575396, 0.667714, 0.981658, 0.235786, 0.755394,
    0.535142, 0.986694, 0.045747, 0.376049, 0.157872, 0.609790, 0.218940,
    0.432936, 0.899991, 0.093966, 0.623646, 0.960265, 0.634938, 0.434828,
    0.272652, 0.962981, 0.745201, 0.027924, 0.847713, 0.725242, 0.209784,
    0.896725, 0.451704, 0.027467, 0.685934, 0.281228, 0.746239, 0.302713,
    0.991058, 0.869991, 0.129826, 0.263619, 0.891629, 0.455061, 0.113681,
    0.031587, 0.604541, 0.292825, 0.550615, 0.298959, 0.918088, 0.950591,
    0.874081, 0.555651, 0.337840, 0.920957, 0.003021, 0.911557, 0.164525,
    0.785180, 0.069155, 0.545976, 0.909726, 0.206366, 0.622486, 0.315073,
    0.955535, 0.534104, 0.471877, 0.548936, 0.864864, 0.301584, 0.816462,
    0.569140, 0.248146, 0.396710, 0.824427, 0.958556, 0.593219, 0.188147,
    0.315226, 0.114170, 0.963958, 0.387860, 0.701682, 0.114353, 0.974639,
    0.930906, 0.847865, 0.431928, 0.945891, 0.654439, 0.999481, 0.524003,
    0.648366, 0.056551, 0.442701, 0.830317, 0.540605, 0.916623, 0.047761,
    0.210761, 0.907559, 0.057924, 0.353465, 0.353740, 0.805231, 0.034425,
    0.349071, 0.186407, 0.218818, 0.022553, 0.609790, 0.818262, 0.339518,
    0.699057, 0.941710, 0.048799, 0.366863, 0.386822, 0.193091, 0.971587,
    0.742851, 0.249214, 0.387860, 0.704428, 0.223762, 0.814692, 0.837397,
    0.778466, 0.696280, 0.612629, 0.387249, 0.216193, 0.143742, 0.201758,
    0.455000, 0.830653, 0.669515, 0.372478, 0.015076, 0.776055, 0.982635,
    0.804102, 0.187414, 0.882138, 0.253090, 0.958678, 0.585559, 0.802576,
    0.742302, 0.492080, 0.080996, 0.509293, 0.115177, 0.964324, 0.139897,
    0.163701, 0.840327, 0.129429, 0.387829, 0.896115, 0.583880, 0.587237,
    0.559923, 0.524461, 0.004425, 0.077090, 0.491440, 0.744163, 0.853969,
    0.196173, 0.306101, 0.819422, 0.792077, 0.822077, 0.457564, 0.307962,
    0.819178, 0.022309, 0.780969, 0.850459, 0.734977, 0.731315, 0.210089,
    0.555071, 0.529038, 0.975768, 0.317301, 0.009491, 0.108585, 0.930784,
    0.331614, 0.451064, 0.271065, 0.586749, 0.791589, 0.126011, 0.326701,
    0.309183, 0.489364, 0.369976, 0.277749, 0.072176, 0.861965, 0.439833,
    0.960906, 0.647023, 0.485916, 0.629292, 0.058443, 0.527085, 0.831874,
    0.698630, 0.385174],
   [0.495618, 0.441464, 0.557017, 0.272405, 0.594053,
    0.213913, 0.095401, 0.330141, 0.756265, 0.213387, 0.945661, 0.215836,
    0.478364, 0.166789, 0.265475, 0.224600, 0.011292, 0.356525, 0.881330,
    0.899717, 0.340867, 0.762765, 0.398643, 0.959794, 0.076373, 0.411068,
    0.956087, 0.425671, 0.267392, 0.086429, 0.230950, 0.969761, 0.077102,
    0.364494, 0.110616, 0.201659, 0.655970, 0.529764, 0.775525, 0.178886,
    0.732134, 0.748248, 0.129081, 0.515934, 0.980429, 0.110490, 0.140175,
    0.754832, 0.623327, 0.732077, 0.072652, 0.447853, 0.313085, 0.880703,
    0.231171, 0.966561, 0.265433, 0.153128, 0.496576, 0.485365, 0.232871,
    0.147871, 0.742083, 0.608403, 0.367386, 0.242410, 0.889346, 0.726072,
    0.567069, 0.541939, 0.876543, 0.588447, 0.463390, 0.048924, 0.332279,
    0.112237, 0.583767, 0.708608, 0.194895, 0.406334, 0.623418, 0.521972,
    0.732477, 0.736640, 0.234700, 0.436454, 0.332746, 0.552401, 0.149503,
    0.896181, 0.132756, 0.723063, 0.864270, 0.737282, 0.896088, 0.500499,
    0.435932, 0.208168, 0.772405, 0.552217, 0.466660, 0.676089, 0.363508,
    0.511280, 0.383914, 0.680339, 0.244844, 0.037614, 0.821954, 0.097665,
    0.866579, 0.369076, 0.428357, 0.289866, 0.218990, 0.386788, 0.958202,
    0.895966, 0.332165, 0.987714, 0.837437, 0.415629, 0.234766, 0.762833,
    0.575631, 0.802375, 0.868664, 0.547072, 0.361121, 0.787932, 0.372006,
    0.962287, 0.132690, 0.364041, 0.272380, 0.455698, 0.386066, 0.211024,
    0.726992, 0.223019, 0.238927, 0.028980, 0.619901, 0.829672, 0.114443,
    0.530184, 0.384064, 0.570925, 0.593174, 0.172192, 0.479118, 0.055151,
    0.175546, 0.543465, 0.386083, 0.921652, 0.407870, 0.111462, 0.413042,
    0.409689, 0.804235, 0.840629, 0.970208, 0.698751, 0.221048, 0.330415,
    0.674973, 0.245212, 0.661346, 0.911649, 0.197003, 0.272622, 0.678364,
    0.645042, 0.082575, 0.073088, 0.102925, 0.483113, 0.540776, 0.190397,
    0.789439, 0.199725, 0.028167, 0.298789, 0.666024, 0.294616, 0.698567,
    0.244601, 0.071771, 0.145942, 0.372541, 0.500928, 0.208398, 0.810336,
    0.256493, 0.752106, 0.419867, 0.844875, 0.739738, 0.589028, 0.172165,
    0.576336, 0.388612, 0.942727, 0.605002, 0.466328, 0.573021, 0.868937,
    0.193609, 0.484958, 0.312042, 0.164538, 0.625321, 0.355834, 0.114481,
    0.326462, 0.120043, 0.885765, 0.155206, 0.625728, 0.175445, 0.336309,
    0.853385, 0.299478, 0.164527, 0.921071, 0.777973, 0.099571, 0.860153,
    0.491092, 0.205249, 0.258365, 0.463333] ),

  ([0.870357, 0.935087, 0.150121, 0.356639, 0.240822, 0.138127, 0.380718,
    0.045442, 0.429823, 0.562517, 0.242409, 0.731742, 0.138768, 0.464309,
    0.042634, 0.353954, 0.804498, 0.131626, 0.514969, 0.766320, 0.348430,
    0.478835, 0.791864, 0.209052, 0.130772, 0.994385, 0.910764, 0.898007,
    0.891110, 0.198492, 0.884426, 0.139439, 0.956359, 0.266915, 0.867061,
    0.876614, 0.498032, 0.976684, 0.447493, 0.073946, 0.119053, 0.630573,
    0.600482, 0.846004, 0.552141, 0.116428, 0.327250, 0.735923, 0.750786,
    0.757378, 0.517228, 0.051332, 0.154057, 0.109104, 0.061281, 0.662770,
    0.406384, 0.361095, 0.748314, 0.171056, 0.313822, 0.497330, 0.976440,
    0.850581, 0.317667, 0.872921, 0.809565, 0.273690, 0.267159, 0.363384,
    0.411298, 0.023469, 0.772149, 0.742088, 0.386822, 0.400220, 0.916929,
    0.442579, 0.064089, 0.528459, 0.617023, 0.361950, 0.246193, 0.770837,
    0.399457, 0.861446, 0.465133, 0.854518, 0.888180, 0.620563, 0.269173,
    0.617115, 0.776025, 0.500992, 0.574511, 0.777551, 0.563921, 0.076479,
    0.612659, 0.639058, 0.849269, 0.985076, 0.504776, 0.129612, 0.444014,
    0.759636, 0.994293, 0.087008, 0.104495, 0.293527, 0.368694, 0.193701,
    0.153478, 0.596973, 0.102481, 0.468856, 0.776269, 0.000702, 0.251717,
    0.723014, 0.271676, 0.463393, 0.131748, 0.881924, 0.039613, 0.138493,
    0.309763, 0.585681, 0.585986, 0.857418, 0.442610, 0.969939, 0.326548,
    0.684713, 0.991852, 0.034211, 0.470840, 0.201971, 0.346904, 0.505295,
    0.767449, 0.676412, 0.387707, 0.600116, 0.391675, 0.770318, 0.017975,
    0.595965, 0.757439, 0.948088, 0.700552, 0.613239, 0.533708, 0.236518,
    0.525773, 0.517441, 0.647847, 0.495041, 0.844569, 0.346507, 0.555956,
    0.851680, 0.996948, 0.169897, 0.562578, 0.461623, 0.167638, 0.785394,
    0.470077, 0.244209, 0.900052, 0.160161, 0.339549, 0.754509, 0.299173,
    0.022309, 0.644307, 0.846034, 0.455824, 0.508805, 0.597034, 0.280923,
    0.122440, 0.276406, 0.932340, 0.943175, 0.172155, 0.982025, 0.925138,
    0.812067, 0.872494, 0.537828, 0.927244, 0.351482, 0.504379, 0.048799,
    0.202124, 0.471297, 0.358623, 0.837458, 0.340373, 0.717582, 0.640278,
    0.463027, 0.035951, 0.847407, 0.312296, 0.141240, 0.505356, 0.444563,
    0.410382, 0.470290, 0.330546, 0.732871, 0.859432, 0.869991, 0.006806,
    0.242683, 0.323160, 0.640065, 0.977264, 0.487289, 0.118381, 0.043641,
    0.434400, 0.305338, 0.724967, 0.322703, 0.671255, 0.025483, 0.922483,
    0.050966, 0.261727],
   [0.260157, 0.307517, 0.358097, 0.252689, 0.772330,
    0.168730, 0.199755, 0.263603, 0.796697, 0.181093, 0.908662, 0.220840,
    0.448967, 0.056864, 0.383428, 0.252245, 0.028268, 0.379121, 0.920537,
    0.931111, 0.376615, 0.702265, 0.339892, 0.951384, 0.054280, 0.473895,
    0.985559, 0.437227, 0.257565, 0.131997, 0.163347, 0.974754, 0.051855,
    0.364200, 0.179886, 0.139106, 0.533888, 0.439360, 0.658220, 0.284960,
    0.802907, 0.717600, 0.108974, 0.423505, 0.979426, 0.072133, 0.140069,
    0.642677, 0.641243, 0.648287, 0.086454, 0.332935, 0.442687, 0.900471,
    0.324827, 0.970455, 0.321905, 0.153388, 0.273655, 0.560316, 0.054492,
    0.164323, 0.775053, 0.618409, 0.320127, 0.217728, 0.806489, 0.830306,
    0.422330, 0.576379, 0.884398, 0.516388, 0.381542, 0.044992, 0.252025,
    0.077069, 0.768432, 0.381270, 0.154768, 0.518110, 0.765505, 0.365825,
    0.591896, 0.683737, 0.155926, 0.240362, 0.234728, 0.662729, 0.099457,
    0.899237, 0.244236, 0.906834, 0.903701, 0.839181, 0.900426, 0.410311,
    0.610486, 0.151047, 0.777519, 0.399258, 0.474944, 0.605231, 0.337552,
    0.385688, 0.341139, 0.679593, 0.385755, 0.035838, 0.872824, 0.144731,
    0.756607, 0.337629, 0.336516, 0.400295, 0.349064, 0.239996, 0.890461,
    0.918159, 0.191377, 0.993292, 0.743830, 0.487235, 0.297947, 0.904181,
    0.347443, 0.796035, 0.902446, 0.487609, 0.457696, 0.661949, 0.538200,
    0.961316, 0.048804, 0.252998, 0.376427, 0.402341, 0.368201, 0.151905,
    0.719359, 0.208973, 0.274783, 0.051515, 0.586169, 0.870502, 0.067245,
    0.473591, 0.397839, 0.618277, 0.627337, 0.094868, 0.342847, 0.082950,
    0.306641, 0.610109, 0.216219, 0.850829, 0.415679, 0.109415, 0.430899,
    0.368500, 0.672157, 0.943332, 0.973869, 0.654748, 0.097660, 0.130777,
    0.714200, 0.168292, 0.513323, 0.919240, 0.323300, 0.443992, 0.613737,
    0.690707, 0.038421, 0.054618, 0.152763, 0.333967, 0.530286, 0.307992,
    0.929752, 0.188744, 0.063666, 0.359969, 0.680815, 0.212698, 0.676648,
    0.319024, 0.140095, 0.220252, 0.142314, 0.333826, 0.266799, 0.812927,
    0.297978, 0.767975, 0.598235, 0.890015, 0.710723, 0.567831, 0.346083,
    0.587204, 0.342478, 0.962254, 0.687791, 0.580150, 0.457589, 0.859200,
    0.168856, 0.500052, 0.205292, 0.075898, 0.546948, 0.241454, 0.054149,
    0.449954, 0.299996, 0.883236, 0.178772, 0.792651, 0.196661, 0.379851,
    0.872677, 0.203970, 0.132733, 0.919790, 0.809352, 0.089786, 0.863894,
    0.624949, 0.109569, 0.242875, 0.490815] ),

  ([0.109653, 0.085360, 0.731498, 0.853023, 0.430921, 0.667531, 0.044008,
    0.850154, 0.842463, 0.407300, 0.649648, 0.774590, 0.193823, 0.284799,
    0.957732, 0.577776, 0.450789, 0.762169, 0.762383, 0.691122, 0.074648,
    0.338389, 0.154241, 0.093356, 0.318003, 0.949950, 0.613880, 0.177160,
    0.592273, 0.248024, 0.692862, 0.695242, 0.564287, 0.284463, 0.189398,
    0.568255, 0.137181, 0.636647, 0.224097, 0.835078, 0.972625, 0.503494,
    0.122288, 0.527024, 0.709952, 0.803125, 0.509537, 0.746971, 0.539415,
    0.803919, 0.525956, 0.734947, 0.284402, 0.319864, 0.566210, 0.201239,
    0.650410, 0.001801, 0.450911, 0.708457, 0.795862, 0.755516, 0.436171,
    0.383374, 0.881466, 0.817835, 0.966979, 0.740532, 0.754509, 0.522599,
    0.581103, 0.897977, 0.424116, 0.287027, 0.869961, 0.967071, 0.483627,
    0.850154, 0.901700, 0.897488, 0.136662, 0.294290, 0.014008, 0.558214,
    0.982940, 0.881375, 0.382244, 0.336375, 0.219855, 0.234382, 0.268654,
    0.034822, 0.416761, 0.896359, 0.360271, 0.349834, 0.517472, 0.797082,
    0.100467, 0.709983, 0.227424, 0.659627, 0.420942, 0.757775, 0.442335,
    0.877346, 0.780511, 0.255074, 0.873501, 0.892941, 0.916623, 0.693625,
    0.527085, 0.610584, 0.216132, 0.391614, 0.192969, 0.872768, 0.111423,
    0.358409, 0.599780, 0.532609, 0.408124, 0.707389, 0.391797, 0.153142,
    0.950774, 0.899533, 0.584887, 0.864986, 0.532609, 0.597858, 0.656850,
    0.413190, 0.455794, 0.414716, 0.928922, 0.925077, 0.648213, 0.332713,
    0.394421, 0.429762, 0.743095, 0.080905, 0.651234, 0.661153, 0.027985,
    0.247139, 0.093509, 0.175176, 0.669027, 0.408185, 0.019929, 0.312784,
    0.116611, 0.058351, 0.813959, 0.039888, 0.099429, 0.618641, 0.852504,
    0.195654, 0.112186, 0.306833, 0.299783, 0.180029, 0.804041, 0.150334,
    0.441664, 0.612049, 0.173437, 0.922910, 0.717612, 0.990204, 0.976043,
    0.286172, 0.106082, 0.885769, 0.251625, 0.918027, 0.019684, 0.700980,
    0.376598, 0.907865, 0.366314, 0.522385, 0.547777, 0.201270, 0.932493,
    0.101688, 0.104434, 0.374615, 0.745384, 0.494430, 0.594440, 0.520707,
    0.569597, 0.388134, 0.990387, 0.527390, 0.194708, 0.651479, 0.962951,
    0.529740, 0.670400, 0.134983, 0.616688, 0.817530, 0.144810, 0.255318,
    0.595294, 0.978668, 0.463027, 0.393689, 0.961913, 0.560747, 0.181127,
    0.640217, 0.761345, 0.030885, 0.152898, 0.915036, 0.670125, 0.316111,
    0.344829, 0.997864, 0.640645, 0.704550, 0.035859, 0.496719, 0.945677,
    0.389813, 0.058412],
   [0.454856, 0.248515, 0.361389, 0.122148, 0.694139,
    0.146798, 0.280774, 0.412776, 0.702364, 0.163216, 0.902092, 0.093065,
    0.474958, 0.264249, 0.434468, 0.227983, 0.011746, 0.387684, 0.926212,
    0.733468, 0.251994, 0.594014, 0.524123, 0.948130, 0.157794, 0.383516,
    0.975607, 0.466704, 0.307640, 0.100712, 0.141646, 0.956370, 0.042512,
    0.297531, 0.085487, 0.093468, 0.596480, 0.690076, 0.797975, 0.267221,
    0.753295, 0.774192, 0.116699, 0.464241, 0.985235, 0.073823, 0.089206,
    0.447433, 0.719236, 0.815190, 0.046099, 0.489775, 0.405497, 0.906062,
    0.254434, 0.967531, 0.295697, 0.102913, 0.406725, 0.519415, 0.081144,
    0.196076, 0.755829, 0.377023, 0.214420, 0.150418, 0.858558, 0.876656,
    0.635810, 0.630952, 0.729097, 0.625271, 0.333465, 0.042126, 0.224886,
    0.142931, 0.763860, 0.603410, 0.175108, 0.380019, 0.666179, 0.447647,
    0.869742, 0.579908, 0.245852, 0.371972, 0.344010, 0.359698, 0.081658,
    0.833780, 0.219437, 0.796887, 0.949882, 0.901161, 0.913896, 0.377543,
    0.619674, 0.128213, 0.516002, 0.422384, 0.409693, 0.684524, 0.425780,
    0.548613, 0.520597, 0.594379, 0.261667, 0.079061, 0.904477, 0.080815,
    0.801571, 0.404271, 0.580455, 0.402241, 0.263298, 0.523119, 0.942118,
    0.916117, 0.335429, 0.988195, 0.777338, 0.500755, 0.323573, 0.857648,
    0.592954, 0.611505, 0.838570, 0.625515, 0.332418, 0.798301, 0.539981,
    0.981028, 0.122947, 0.425385, 0.327212, 0.369861, 0.378286, 0.154940,
    0.779355, 0.110862, 0.317416, 0.040495, 0.507705, 0.858675, 0.089329,
    0.297920, 0.288036, 0.377962, 0.567168, 0.167161, 0.586962, 0.064270,
    0.234567, 0.532191, 0.422919, 0.913402, 0.394611, 0.032129, 0.312803,
    0.443883, 0.683181, 0.931617, 0.976537, 0.787270, 0.157918, 0.235750,
    0.617241, 0.176583, 0.705436, 0.958141, 0.218316, 0.217251, 0.681318,
    0.793152, 0.079533, 0.080840, 0.214927, 0.437709, 0.604961, 0.227055,
    0.805453, 0.181182, 0.030641, 0.358724, 0.664910, 0.292232, 0.570454,
    0.224660, 0.089332, 0.112569, 0.273717, 0.225018, 0.222019, 0.788015,
    0.214029, 0.802656, 0.590121, 0.912856, 0.734046, 0.469630, 0.260610,
    0.592389, 0.334603, 0.936535, 0.760104, 0.684230, 0.639625, 0.771056,
    0.221245, 0.374172, 0.134190, 0.110979, 0.800637, 0.245717, 0.135946,
    0.260575, 0.133939, 0.933764, 0.118476, 0.528121, 0.136099, 0.495127,
    0.832425, 0.290466, 0.117380, 0.906839, 0.875183, 0.109638, 0.801086,
    0.592449, 0.213508, 0.105856, 0.559403] ),

  ([0.287667, 0.529618, 0.438673, 0.236427, 0.456221, 0.072512, 0.464156,
    0.676840, 0.272042, 0.673482, 0.784814, 0.071169, 0.228248, 0.558977,
    0.351512, 0.662923, 0.676229, 0.723411, 0.223273, 0.037019, 0.087497,
    0.907071, 0.873074, 0.388348, 0.473739, 0.818476, 0.104709, 0.424421,
    0.996277, 0.007080, 0.862880, 0.559435, 0.296335, 0.292642, 0.716330,
    0.555620, 0.577166, 0.157262, 0.296731, 0.267830, 0.969390, 0.006928,
    0.473403, 0.648152, 0.210730, 0.708121, 0.546007, 0.666372, 0.171728,
    0.306284, 0.235694, 0.302835, 0.258034, 0.332102, 0.756676, 0.269784,
    0.221168, 0.601794, 0.748833, 0.617328, 0.408521, 0.918088, 0.353099,
    0.880612, 0.984344, 0.577532, 0.210608, 0.924131, 0.152379, 0.090884,
    0.667013, 0.139714, 0.912015, 0.022645, 0.962706, 0.154088, 0.378460,
    0.355846, 0.691366, 0.702475, 0.199225, 0.288553, 0.306650, 0.824641,
    0.096835, 0.868343, 0.959380, 0.039155, 0.070467, 0.370739, 0.445662,
    0.652913, 0.286416, 0.828272, 0.548173, 0.860988, 0.189764, 0.615894,
    0.550707, 0.794305, 0.867641, 0.499588, 0.208014, 0.170660, 0.195868,
    0.053896, 0.952147, 0.705496, 0.800104, 0.854976, 0.615955, 0.938505,
    0.362468, 0.355022, 0.455947, 0.632893, 0.305307, 0.845149, 0.754814,
    0.402814, 0.383221, 0.411695, 0.785363, 0.725791, 0.214209, 0.293527,
    0.417158, 0.996002, 0.282022, 0.545701, 0.146947, 0.774834, 0.439955,
    0.415845, 0.834132, 0.895138, 0.448195, 0.340190, 0.922422, 0.575060,
    0.575457, 0.964476, 0.429365, 0.197882, 0.796442, 0.096713, 0.484603,
    0.914396, 0.616108, 0.998077, 0.697958, 0.723258, 0.052217, 0.917264,
    0.139195, 0.186743, 0.807428, 0.276101, 0.210242, 0.437208, 0.161779,
    0.411145, 0.191046, 0.630543, 0.617695, 0.278390, 0.740867, 0.503739,
    0.827418, 0.027253, 0.135472, 0.191687, 0.835658, 0.849696, 0.522507,
    0.960417, 0.167425, 0.011017, 0.974883, 0.012116, 0.793146, 0.468978,
    0.624958, 0.019257, 0.501572, 0.986328, 0.659841, 0.542924, 0.712699,
    0.144322, 0.458937, 0.992523, 0.260903, 0.162633, 0.655873, 0.282632,
    0.180303, 0.932218, 0.405011, 0.843440, 0.023194, 0.167119, 0.634602,
    0.140690, 0.743034, 0.082095, 0.567461, 0.362041, 0.672964, 0.501450,
    0.290262, 0.425428, 0.631581, 0.805994, 0.653279, 0.965941, 0.686575,
    0.624012, 0.281045, 0.457595, 0.608081, 0.672903, 0.976012, 0.126011,
    0.542528, 0.656941, 0.295572, 0.808527, 0.938688, 0.628498, 0.584643,
    0.417402, 0.256569],
   [0.218635, 0.357876, 0.173623, 0.173806, 0.673032,
    0.189860, 0.351286, 0.442685, 0.692897, 0.138260, 0.929152, 0.187127,
    0.499222, 0.119533, 0.454319, 0.261703, 0.018971, 0.302934, 0.747664,
    0.921815, 0.284514, 0.658830, 0.284149, 0.956592, 0.066063, 0.446204,
    0.972693, 0.393397, 0.309208, 0.095630, 0.181192, 0.938930, 0.067703,
    0.237331, 0.113878, 0.093320, 0.503422, 0.681623, 0.733120, 0.312091,
    0.650519, 0.652697, 0.137933, 0.532398, 0.983085, 0.084617, 0.065343,
    0.549961, 0.745401, 0.892501, 0.074734, 0.519583, 0.376233, 0.753947,
    0.242325, 0.964071, 0.286072, 0.208462, 0.337912, 0.594345, 0.092390,
    0.212956, 0.694319, 0.460707, 0.237936, 0.361339, 0.858933, 0.819767,
    0.467638, 0.727528, 0.746701, 0.532651, 0.330979, 0.050657, 0.332196,
    0.035503, 0.658197, 0.457472, 0.193841, 0.467948, 0.537894, 0.345733,
    0.718487, 0.513743, 0.333842, 0.380397, 0.321536, 0.427051, 0.148436,
    0.799359, 0.348584, 0.849755, 0.868229, 0.841677, 0.909258, 0.539411,
    0.690853, 0.152109, 0.660805, 0.456971, 0.539072, 0.776359, 0.274709,
    0.519946, 0.582156, 0.705097, 0.382707, 0.054506, 0.834956, 0.064999,
    0.809754, 0.418180, 0.407116, 0.378793, 0.226499, 0.431485, 0.869723,
    0.873152, 0.149430, 0.982588, 0.630468, 0.370831, 0.299135, 0.909328,
    0.323344, 0.720702, 0.875886, 0.584744, 0.507132, 0.548361, 0.426220,
    0.959330, 0.112001, 0.223089, 0.350064, 0.521868, 0.493527, 0.204729,
    0.762551, 0.219292, 0.210416, 0.070511, 0.560222, 0.754688, 0.060908,
    0.647756, 0.250738, 0.593946, 0.819360, 0.207920, 0.412829, 0.103411,
    0.364463, 0.585421, 0.424595, 0.913237, 0.494716, 0.067945, 0.427710,
    0.381549, 0.765270, 0.912343, 0.971849, 0.806889, 0.129748, 0.287356,
    0.736490, 0.295920, 0.689556, 0.923895, 0.205147, 0.320950, 0.615522,
    0.694049, 0.058830, 0.072159, 0.210321, 0.362232, 0.547235, 0.186022,
    0.851536, 0.164144, 0.022905, 0.236097, 0.560682, 0.291979, 0.590515,
    0.365463, 0.178689, 0.189426, 0.202501, 0.315727, 0.251595, 0.922035,
    0.244061, 0.671076, 0.500123, 0.894621, 0.834322, 0.546120, 0.309387,
    0.600686, 0.311961, 0.941726, 0.612745, 0.578015, 0.654615, 0.818524,
    0.202517, 0.443512, 0.141913, 0.090282, 0.711760, 0.207059, 0.192837,
    0.374708, 0.308595, 0.899807, 0.086978, 0.753923, 0.143085, 0.494978,
    0.853515, 0.231696, 0.082054, 0.950877, 0.857621, 0.094328, 0.831074,
    0.575920, 0.180761, 0.182903, 0.451331] ),

  ([0.718009, 0.244209, 0.163427, 0.491195, 0.639515, 0.517624, 0.195013,
    0.041749, 0.877834, 0.575610, 0.809778, 0.957854, 0.963408, 0.181585,
    0.894559, 0.093814, 0.741722, 0.717978, 0.750359, 0.202765, 0.042695,
    0.855434, 0.958098, 0.501022, 0.656911, 0.645558, 0.441786, 0.734794,
    0.024689, 0.319102, 0.385052, 0.279641, 0.544420, 0.570025, 0.157659,
    0.305033, 0.906003, 0.607593, 0.907834, 0.533891, 0.356182, 0.756920,
    0.976928, 0.629597, 0.301828, 0.889828, 0.792657, 0.741111, 0.157048,
    0.466933, 0.397015, 0.237220, 0.840907, 0.472427, 0.265328, 0.162053,
    0.831782, 0.022462, 0.572344, 0.441908, 0.184606, 0.928922, 0.562059,
    0.375927, 0.417127, 0.999023, 0.177313, 0.440596, 0.671804, 0.353252,
    0.605213, 0.940550, 0.058901, 0.541429, 0.894925, 0.535783, 0.588183,
    0.739128, 0.304025, 0.177526, 0.593890, 0.805506, 0.529710, 0.483230,
    0.060884, 0.483535, 0.480575, 0.082461, 0.756981, 0.524247, 0.746330,
    0.964660, 0.578143, 0.015839, 0.420362, 0.360057, 0.013123, 0.699393,
    0.432600, 0.185247, 0.133427, 0.551744, 0.048128, 0.584246, 0.014496,
    0.417707, 0.688009, 0.596515, 0.995483, 0.971984, 0.728782, 0.483383,
    0.682394, 0.792535, 0.436720, 0.743736, 0.102390, 0.826472, 0.692984,
    0.350414, 0.914212, 0.029969, 0.666128, 0.238746, 0.081515, 0.463027,
    0.088076, 0.578051, 0.915708, 0.620594, 0.289987, 0.857662, 0.893735,
    0.281381, 0.653859, 0.318766, 0.157811, 0.655507, 0.636708, 0.763237,
    0.103030, 0.112033, 0.023133, 0.270272, 0.958892, 0.268075, 0.562639,
    0.852962, 0.771264, 0.720237, 0.647908, 0.585314, 0.691366, 0.200079,
    0.190405, 0.231269, 0.977233, 0.434706, 0.349742, 0.907041, 0.614277,
    0.493332, 0.272164, 0.807581, 0.961699, 0.901822, 0.495834, 0.529160,
    0.329905, 0.305857, 0.177801, 0.018616, 0.896573, 0.964263, 0.799707,
    0.680990, 0.866024, 0.853542, 0.508316, 0.676382, 0.279611, 0.665059,
    0.746910, 0.937742, 0.382702, 0.476272, 0.334086, 0.940519, 0.954009,
    0.376476, 0.645924, 0.755516, 0.504685, 0.829615, 0.058077, 0.416181,
    0.752617, 0.053926, 0.303842, 0.131596, 0.278085, 0.201056, 0.904294,
    0.376568, 0.767815, 0.614795, 0.327250, 0.389630, 0.752647, 0.951445,
    0.030793, 0.110721, 0.245949, 0.442457, 0.047884, 0.089572, 0.188604,
    0.081332, 0.268227, 0.395978, 0.106754, 0.015137, 0.073580, 0.063143,
    0.888882, 0.922636, 0.482986, 0.095767, 0.087985, 0.659810, 0.463851,
    0.573687, 0.655934],
   [0.426641, 0.368498, 0.324384, 0.244630, 0.810313,
    0.154400, 0.349735, 0.383929, 0.592216, 0.152524, 0.905401, 0.140957,
    0.476962, 0.196000, 0.330754, 0.277185, 0.018883, 0.277773, 0.862392,
    0.903272, 0.303903, 0.594118, 0.361856, 0.941660, 0.079700, 0.480783,
    0.969456, 0.472912, 0.230198, 0.098414, 0.160896, 0.968786, 0.046620,
    0.262502, 0.139625, 0.175795, 0.361952, 0.682237, 0.823679, 0.267849,
    0.790622, 0.778540, 0.116554, 0.395309, 0.970600, 0.098625, 0.083999,
    0.714550, 0.748284, 0.835519, 0.077502, 0.521743, 0.326032, 0.755997,
    0.251540, 0.976562, 0.302812, 0.305042, 0.410685, 0.551413, 0.117068,
    0.132348, 0.621621, 0.626591, 0.383646, 0.184807, 0.834431, 0.780612,
    0.507623, 0.612959, 0.794717, 0.533914, 0.477495, 0.029843, 0.227917,
    0.108277, 0.660436, 0.700065, 0.209277, 0.487593, 0.541569, 0.553619,
    0.731494, 0.580211, 0.275850, 0.372828, 0.243097, 0.420385, 0.098984,
    0.857177, 0.250690, 0.833313, 0.913703, 0.867545, 0.951534, 0.361687,
    0.527698, 0.243859, 0.717807, 0.467260, 0.580161, 0.714308, 0.267384,
    0.456982, 0.374384, 0.692335, 0.299550, 0.083761, 0.919893, 0.096244,
    0.848201, 0.232173, 0.484829, 0.245712, 0.249837, 0.437164, 0.970420,
    0.887475, 0.244833, 0.991818, 0.763004, 0.286520, 0.264178, 0.806474,
    0.660562, 0.674266, 0.860876, 0.734945, 0.467590, 0.805231, 0.447643,
    0.964540, 0.110531, 0.299224, 0.495899, 0.439600, 0.515685, 0.221798,
    0.708328, 0.123330, 0.259151, 0.045842, 0.530350, 0.760107, 0.140522,
    0.285037, 0.378773, 0.458631, 0.583821, 0.141129, 0.426094, 0.055360,
    0.322095, 0.582423, 0.468241, 0.884921, 0.413174, 0.046554, 0.445516,
    0.540792, 0.812143, 0.869259, 0.956194, 0.762436, 0.207954, 0.269481,
    0.813644, 0.223316, 0.794380, 0.903227, 0.153186, 0.216683, 0.710133,
    0.745967, 0.076032, 0.082960, 0.138856, 0.522247, 0.371434, 0.332129,
    0.891117, 0.218265, 0.071134, 0.248548, 0.680875, 0.198809, 0.592904,
    0.277751, 0.089860, 0.167141, 0.243550, 0.326903, 0.306565, 0.898553,
    0.198083, 0.618236, 0.607264, 0.941108, 0.790631, 0.602020, 0.208493,
    0.649504, 0.429139, 0.913258, 0.681561, 0.603627, 0.630023, 0.737105,
    0.243026, 0.483829, 0.173393, 0.060755, 0.683204, 0.284398, 0.103508,
    0.451004, 0.147505, 0.885852, 0.105137, 0.803031, 0.112451, 0.412019,
    0.725960, 0.227560, 0.200442, 0.915390, 0.853311, 0.078259, 0.842300,
    0.799232, 0.236802, 0.236590, 0.327087] ),

  ([0.954619, 0.565477, 0.882290, 0.514939, 0.431104, 0.530839, 0.601520,
    0.873959, 0.745659, 0.043428, 0.083987, 0.694906, 0.115177, 0.264992,
    0.254036, 0.215796, 0.019532, 0.320292, 0.658498, 0.936796, 0.358745,
    0.385907, 0.300882, 0.975127, 0.846828, 0.538285, 0.290017, 0.195654,
    0.922880, 0.018097, 0.834101, 0.023194, 0.961272, 0.066805, 0.612140,
    0.342235, 0.061831, 0.991760, 0.053194, 0.391247, 0.201239, 0.615833,
    0.555406, 0.057314, 0.027192, 0.768517, 0.175451, 0.477218, 0.076205,
    0.973907, 0.820093, 0.351512, 0.696615, 0.992309, 0.470962, 0.877926,
    0.457930, 0.371685, 0.473708, 0.709677, 0.327677, 0.665059, 0.422895,
    0.846034, 0.397076, 0.470138, 0.673788, 0.860347, 0.436934, 0.947569,
    0.012513, 0.372204, 0.064577, 0.973785, 0.515427, 0.170415, 0.803797,
    0.585101, 0.129429, 0.892026, 0.818018, 0.868954, 0.004059, 0.664693,
    0.599261, 0.958464, 0.106784, 0.618000, 0.392895, 0.287179, 0.152989,
    0.670248, 0.640126, 0.759484, 0.381329, 0.496689, 0.219337, 0.993439,
    0.206183, 0.086032, 0.767602, 0.292032, 0.278512, 0.790704, 0.863277,
    0.499344, 0.985839, 0.277596, 0.351390, 0.397595, 0.922941, 0.285684,
    0.592853, 0.801569, 0.364940, 0.596271, 0.918546, 0.006256, 0.273080,
    0.122410, 0.069948, 0.744957, 0.865230, 0.523911, 0.907346, 0.312357,
    0.281869, 0.253761, 0.166540, 0.010956, 0.379498, 0.442518, 0.546251,
    0.575243, 0.181585, 0.526841, 0.906095, 0.730888, 0.019501, 0.028474,
    0.857814, 0.545152, 0.894040, 0.389874, 0.529893, 0.724143, 0.088504,
    0.272439, 0.787500, 0.513932, 0.565783, 0.224372, 0.688589, 0.361431,
    0.178961, 0.123508, 0.457686, 0.990905, 0.228339, 0.302072, 0.758507,
    0.053224, 0.395123, 0.759056, 0.546556, 0.003449, 0.583239, 0.367016,
    0.283151, 0.362987, 0.700766, 0.479049, 0.791986, 0.023072, 0.912137,
    0.842555, 0.539506, 0.745323, 0.391858, 0.225715, 0.620411, 0.515885,
    0.112064, 0.663411, 0.229438, 0.909360, 0.694113, 0.728050, 0.900784,
    0.118595, 0.855739, 0.732658, 0.296213, 0.807093, 0.485733, 0.271249,
    0.823481, 0.439283, 0.876308, 0.003815, 0.865810, 0.246467, 0.145054,
    0.091372, 0.904202, 0.483016, 0.377850, 0.187872, 0.313334, 0.130009,
    0.523209, 0.394818, 0.112827, 0.702780, 0.570452, 0.085238, 0.454512,
    0.317667, 0.041719, 0.002808, 0.127476, 0.675253, 0.330271, 0.542833,
    0.861965, 0.115421, 0.915250, 0.620991, 0.713157, 0.401471, 0.984863,
    0.036164, 0.306619],
   [0.359776, 0.367097, 0.360432, 0.206506, 0.754471,
    0.285965, 0.166168, 0.326315, 0.800244, 0.206862, 0.902224, 0.139618,
    0.610692, 0.143672, 0.351668, 0.325182, 0.025730, 0.455092, 0.929569,
    0.796769, 0.251855, 0.747627, 0.331670, 0.964723, 0.081021, 0.389377,
    0.981844, 0.573396, 0.213534, 0.174239, 0.116232, 0.955129, 0.098010,
    0.382178, 0.106874, 0.088279, 0.545543, 0.621791, 0.575619, 0.146018,
    0.761163, 0.653365, 0.150332, 0.606838, 0.980184, 0.110615, 0.146229,
    0.514361, 0.704054, 0.766151, 0.064525, 0.409417, 0.439298, 0.897061,
    0.299828, 0.971770, 0.367509, 0.291184, 0.281051, 0.502794, 0.096782,
    0.083478, 0.840663, 0.583090, 0.395116, 0.281379, 0.877926, 0.828898,
    0.625191, 0.619742, 0.853877, 0.536377, 0.372904, 0.073845, 0.199405,
    0.100709, 0.606060, 0.473555, 0.180722, 0.531621, 0.601256, 0.244270,
    0.741130, 0.594147, 0.163998, 0.204984, 0.241442, 0.590100, 0.134714,
    0.816974, 0.270377, 0.806844, 0.880223, 0.902738, 0.878790, 0.222071,
    0.650206, 0.154455, 0.539164, 0.455021, 0.436253, 0.719163, 0.462310,
    0.466113, 0.538283, 0.504002, 0.245044, 0.046836, 0.881469, 0.148622,
    0.804958, 0.406845, 0.435662, 0.364701, 0.291077, 0.404339, 0.948996,
    0.888650, 0.217218, 0.988262, 0.810153, 0.354070, 0.251472, 0.892376,
    0.390826, 0.855087, 0.934166, 0.635453, 0.402146, 0.843193, 0.463845,
    0.975613, 0.078484, 0.275776, 0.417762, 0.424582, 0.351462, 0.152584,
    0.709934, 0.176501, 0.342223, 0.045484, 0.523229, 0.867291, 0.180673,
    0.433035, 0.494813, 0.457182, 0.578500, 0.122501, 0.627640, 0.059493,
    0.203059, 0.417564, 0.405842, 0.883510, 0.382213, 0.080276, 0.288037,
    0.366680, 0.771502, 0.868585, 0.984384, 0.748690, 0.225509, 0.208029,
    0.508301, 0.300714, 0.593630, 0.933136, 0.149565, 0.327301, 0.570310,
    0.512326, 0.044906, 0.068581, 0.171144, 0.334918, 0.595896, 0.244451,
    0.868130, 0.306131, 0.023271, 0.230718, 0.581006, 0.262223, 0.475655,
    0.306093, 0.119837, 0.192525, 0.192306, 0.363700, 0.344519, 0.844001,
    0.236159, 0.757393, 0.441866, 0.873148, 0.723895, 0.628312, 0.289490,
    0.471274, 0.276109, 0.933656, 0.774933, 0.515753, 0.508829, 0.878633,
    0.161455, 0.487705, 0.194438, 0.073326, 0.719559, 0.146848, 0.064468,
    0.295699, 0.159501, 0.841205, 0.130773, 0.727858, 0.213309, 0.529196,
    0.900356, 0.375119, 0.133807, 0.913048, 0.900510, 0.175900, 0.858299,
    0.624336, 0.144456, 0.290592, 0.449766] ),

  ([0.388440, 0.499100, 0.733940, 0.225929, 0.232795, 0.223090, 0.876339,
    0.324351, 0.299356, 0.762169, 0.124699, 0.241615, 0.421522, 0.130528,
    0.041871, 0.907041, 0.671590, 0.884213, 0.019318, 0.309915, 0.296731,
    0.349498, 0.636219, 0.319224, 0.977630, 0.978820, 0.856349, 0.833064,
    0.065096, 0.364208, 0.969207, 0.039460, 0.952208, 0.940916, 0.681356,
    0.069918, 0.236579, 0.911008, 0.264534, 0.826624, 0.830744, 0.419446,
    0.166601, 0.264809, 0.675344, 0.513321, 0.991638, 0.911466, 0.212561,
    0.915128, 0.255379, 0.901486, 0.275369, 0.142155, 0.822535, 0.312845,
    0.549120, 0.002838, 0.431623, 0.081851, 0.261422, 0.000977, 0.214240,
    0.279397, 0.257302, 0.679678, 0.614551, 0.030152, 0.114689, 0.435926,
    0.615497, 0.855617, 0.457808, 0.837184, 0.677969, 0.721702, 0.123600,
    0.971038, 0.298898, 0.573473, 0.338267, 0.859340, 0.594989, 0.636738,
    0.559618, 0.468276, 0.817927, 0.268838, 0.141697, 0.345042, 0.207495,
    0.639485, 0.478042, 0.412946, 0.088961, 0.022736, 0.779626, 0.955870,
    0.620685, 0.981933, 0.143742, 0.323527, 0.098392, 0.227912, 0.070437,
    0.388592, 0.222510, 0.432844, 0.082003, 0.287027, 0.234504, 0.780084,
    0.602710, 0.472945, 0.328471, 0.531602, 0.754234, 0.619098, 0.244667,
    0.394452, 0.223426, 0.394330, 0.450758, 0.967101, 0.858760, 0.649190,
    0.817225, 0.047121, 0.151219, 0.041231, 0.193121, 0.081668, 0.256630,
    0.630696, 0.788629, 0.541459, 0.714805, 0.478256, 0.770287, 0.500076,
    0.522507, 0.776086, 0.975463, 0.199438, 0.716086, 0.543352, 0.152318,
    0.883206, 0.120151, 0.417158, 0.631336, 0.678243, 0.418531, 0.570818,
    0.834529, 0.807184, 0.203528, 0.290048, 0.529160, 0.911405, 0.160436,
    0.238777, 0.231574, 0.767174, 0.042421, 0.945555, 0.667928, 0.175390,
    0.593280, 0.541917, 0.697378, 0.306375, 0.073183, 0.284127, 0.604968,
    0.281075, 0.544816, 0.889096, 0.169347, 0.269845, 0.574664, 0.216163,
    0.412732, 0.889950, 0.507523, 0.325938, 0.438124, 0.183325, 0.968780,
    0.447096, 0.261116, 0.955596, 0.751854, 0.882717, 0.041932, 0.757408,
    0.746513, 0.387494, 0.624226, 0.290139, 0.064486, 0.046663, 0.786370,
    0.516160, 0.018586, 0.188360, 0.112522, 0.255684, 0.111606, 0.360057,
    0.888607, 0.551195, 0.691214, 0.901181, 0.929960, 0.580615, 0.427168,
    0.142399, 0.747154, 0.400586, 0.266976, 0.763115, 0.955779, 0.301065,
    0.026276, 0.338481, 0.336375, 0.052614, 0.270486, 0.607135, 0.451674,
    0.827326, 0.643361],
   [0.341520, 0.354248, 0.277172, 0.160909, 0.797057,
    0.240798, 0.202232, 0.531780, 0.648235, 0.247807, 0.899272, 0.204557,
    0.643516, 0.176589, 0.498432, 0.206448, 0.025146, 0.357909, 0.889836,
    0.870475, 0.239393, 0.718789, 0.405395, 0.966255, 0.060351, 0.494726,
    0.973623, 0.450753, 0.274252, 0.156538, 0.144262, 0.967449, 0.117045,
    0.347548, 0.190970, 0.086992, 0.503627, 0.736885, 0.627200, 0.147963,
    0.625970, 0.729231, 0.144069, 0.508258, 0.979544, 0.100684, 0.155637,
    0.614090, 0.726387, 0.819368, 0.064838, 0.369947, 0.284572, 0.910960,
    0.231451, 0.965955, 0.243170, 0.194659, 0.336649, 0.518927, 0.181495,
    0.160324, 0.764995, 0.434198, 0.334108, 0.141132, 0.895691, 0.739906,
    0.519881, 0.575619, 0.774124, 0.553721, 0.448064, 0.045919, 0.193842,
    0.091922, 0.777352, 0.523866, 0.113049, 0.299497, 0.627231, 0.439321,
    0.832294, 0.576561, 0.340493, 0.339656, 0.307748, 0.471689, 0.148783,
    0.872684, 0.317473, 0.791259, 0.918053, 0.786497, 0.862708, 0.431441,
    0.684761, 0.260587, 0.733843, 0.426337, 0.532126, 0.655947, 0.510283,
    0.364938, 0.552296, 0.762060, 0.360770, 0.052184, 0.840864, 0.127741,
    0.689611, 0.300560, 0.320230, 0.241689, 0.372612, 0.472813, 0.967107,
    0.929884, 0.252993, 0.992958, 0.742849, 0.411894, 0.345896, 0.770270,
    0.572115, 0.658990, 0.814392, 0.655808, 0.420486, 0.707766, 0.345577,
    0.975158, 0.085844, 0.406723, 0.249006, 0.238066, 0.539499, 0.145692,
    0.790438, 0.168272, 0.230688, 0.057680, 0.571479, 0.740323, 0.066511,
    0.489331, 0.318142, 0.492005, 0.589285, 0.132762, 0.636211, 0.046943,
    0.332692, 0.462977, 0.288413, 0.866029, 0.322398, 0.070890, 0.418203,
    0.476348, 0.784088, 0.918616, 0.971825, 0.687118, 0.119708, 0.226636,
    0.739284, 0.164853, 0.567597, 0.948301, 0.253904, 0.454577, 0.630131,
    0.797070, 0.069375, 0.062262, 0.181825, 0.514047, 0.579143, 0.347091,
    0.790777, 0.249278, 0.041634, 0.302402, 0.692700, 0.223413, 0.806465,
    0.255903, 0.078892, 0.196589, 0.233383, 0.438091, 0.133392, 0.873997,
    0.187271, 0.777030, 0.369699, 0.892954, 0.791136, 0.568050, 0.271141,
    0.550761, 0.438786, 0.966893, 0.695801, 0.625005, 0.646452, 0.847563,
    0.206998, 0.480985, 0.149400, 0.125530, 0.576586, 0.184683, 0.119176,
    0.215631, 0.154857, 0.888609, 0.251622, 0.675261, 0.155464, 0.353164,
    0.907869, 0.196696, 0.109431, 0.930597, 0.817032, 0.075295, 0.760376,
    0.463851, 0.244921, 0.108898, 0.363699] ),

  ([0.490799, 0.225929, 0.074892, 0.299295, 0.397198, 0.393933, 0.135197,
    0.595447, 0.837336, 0.225318, 0.868160, 0.699576, 0.888455, 0.430280,
    0.082522, 0.270516, 0.534074, 0.653493, 0.045015, 0.866939, 0.412214,
    0.461928, 0.850429, 0.240822, 0.002838, 0.233283, 0.934324, 0.172216,
    0.786401, 0.850764, 0.509842, 0.001007, 0.403821, 0.611042, 0.209449,
    0.512284, 0.350383, 0.251167, 0.712882, 0.331492, 0.233283, 0.501053,
    0.642750, 0.485702, 0.125431, 0.067263, 0.509201, 0.286843, 0.046144,
    0.455184, 0.984191, 0.193701, 0.099704, 0.534806, 0.287484, 0.808802,
    0.303781, 0.257302, 0.965209, 0.665822, 0.638356, 0.428144, 0.841853,
    0.964843, 0.346568, 0.942930, 0.427839, 0.910703, 0.018830, 0.392499,
    0.563128, 0.811274, 0.491501, 0.443617, 0.578448, 0.591876, 0.090976,
    0.900815, 0.755394, 0.881619, 0.255013, 0.856624, 0.366649, 0.328623,
    0.062166, 0.835719, 0.077364, 0.299783, 0.700522, 0.339396, 0.989319,
    0.621662, 0.407453, 0.696799, 0.108737, 0.518509, 0.911039, 0.629048,
    0.519395, 0.403943, 0.904782, 0.432417, 0.041688, 0.682455, 0.586871,
    0.186987, 0.659810, 0.216529, 0.795068, 0.896878, 0.497147, 0.616626,
    0.768395, 0.968383, 0.622394, 0.009156, 0.067385, 0.932310, 0.466384,
    0.439619, 0.683523, 0.816675, 0.131870, 0.566332, 0.869289, 0.075869,
    0.377178, 0.801874, 0.720511, 0.483139, 0.554643, 0.557756, 0.041597,
    0.891690, 0.285531, 0.748955, 0.525468, 0.271493, 0.152684, 0.214423,
    0.778893, 0.927824, 0.191748, 0.209876, 0.225135, 0.307291, 0.462600,
    0.629200, 0.414502, 0.298441, 0.482101, 0.110355, 0.774560, 0.432508,
    0.799402, 0.682699, 0.330760, 0.890835, 0.495071, 0.111087, 0.429548,
    0.725181, 0.885434, 0.594012, 0.994079, 0.197241, 0.212867, 0.971038,
    0.344646, 0.643666, 0.604266, 0.096530, 0.115024, 0.772210, 0.077700,
    0.535691, 0.295450, 0.796472, 0.879727, 0.238716, 0.933805, 0.314280,
    0.933409, 0.350383, 0.526536, 0.336650, 0.679617, 0.809870, 0.630024,
    0.373333, 0.091556, 0.898587, 0.723991, 0.981353, 0.144749, 0.390881,
    0.858089, 0.682424, 0.523148, 0.465102, 0.112980, 0.656240, 0.842891,
    0.030122, 0.407239, 0.114841, 0.174810, 0.624500, 0.680746, 0.765282,
    0.147374, 0.544084, 0.986877, 0.266182, 0.410352, 0.354198, 0.523759,
    0.084964, 0.741539, 0.443220, 0.136418, 0.661367, 0.577044, 0.772942,
    0.320780, 0.284127, 0.246986, 0.482833, 0.260842, 0.586688, 0.697104,
    0.503922, 0.930418],
   [0.424107, 0.396879, 0.414405, 0.114626, 0.785829,
    0.223161, 0.220193, 0.579817, 0.719536, 0.172066, 0.875931, 0.125967,
    0.394629, 0.199909, 0.343574, 0.187285, 0.027203, 0.308855, 0.855927,
    0.876132, 0.397154, 0.704915, 0.341795, 0.949075, 0.098719, 0.354898,
    0.976726, 0.321007, 0.223962, 0.124901, 0.175442, 0.971870, 0.143232,
    0.219022, 0.142665, 0.053376, 0.474999, 0.543850, 0.804155, 0.310526,
    0.791216, 0.762469, 0.169269, 0.528699, 0.985355, 0.087431, 0.175909,
    0.577205, 0.625587, 0.768158, 0.096223, 0.503537, 0.413709, 0.885578,
    0.191869, 0.926045, 0.329703, 0.186974, 0.282816, 0.604256, 0.109594,
    0.178356, 0.753140, 0.517298, 0.515606, 0.216674, 0.820059, 0.804815,
    0.611976, 0.631029, 0.803835, 0.591237, 0.322586, 0.052500, 0.328980,
    0.123051, 0.620348, 0.532733, 0.144982, 0.391361, 0.613410, 0.383974,
    0.734064, 0.532324, 0.344537, 0.422938, 0.254770, 0.530569, 0.153824,
    0.835986, 0.547887, 0.832646, 0.901160, 0.830598, 0.935647, 0.287002,
    0.598803, 0.108118, 0.799591, 0.405487, 0.543971, 0.689053, 0.329327,
    0.383579, 0.390946, 0.614205, 0.349351, 0.048845, 0.904713, 0.143100,
    0.771536, 0.357421, 0.459892, 0.389907, 0.224094, 0.376756, 0.948369,
    0.888373, 0.273341, 0.992956, 0.780531, 0.400960, 0.424054, 0.878922,
    0.436259, 0.647822, 0.800395, 0.634784, 0.492485, 0.799851, 0.479985,
    0.964370, 0.058900, 0.276129, 0.348107, 0.391172, 0.603799, 0.216043,
    0.688422, 0.219302, 0.464335, 0.091783, 0.600059, 0.873305, 0.044057,
    0.450227, 0.399348, 0.499331, 0.611188, 0.133346, 0.474435, 0.073997,
    0.290723, 0.628574, 0.407430, 0.898788, 0.407404, 0.074780, 0.427978,
    0.480693, 0.685756, 0.861848, 0.948614, 0.789383, 0.103810, 0.242024,
    0.591603, 0.202827, 0.707913, 0.928032, 0.219192, 0.375436, 0.620618,
    0.740555, 0.085314, 0.073262, 0.123595, 0.291393, 0.559089, 0.284462,
    0.905447, 0.173849, 0.075588, 0.443385, 0.643536, 0.251822, 0.598107,
    0.282495, 0.110525, 0.149146, 0.151177, 0.353747, 0.285400, 0.869472,
    0.224384, 0.648134, 0.328993, 0.908896, 0.810594, 0.513033, 0.234783,
    0.575107, 0.211473, 0.963435, 0.609522, 0.609734, 0.516709, 0.787513,
    0.218430, 0.318520, 0.172837, 0.092019, 0.536853, 0.163634, 0.178079,
    0.368606, 0.184779, 0.929009, 0.159243, 0.748073, 0.172109, 0.597596,
    0.901627, 0.175661, 0.128399, 0.923317, 0.852674, 0.072980, 0.825466,
    0.662855, 0.122188, 0.163042, 0.256912] )]
