/* gmp-mparam.h -- Compiler/machine parameter header file.

Copyright 1991, 1993, 1994, 1999-2003, 2009, 2010, 2012, 2015 Free Software
Foundation, Inc.

This file is part of the GNU MP Library.

The GNU MP Library is free software; you can redistribute it and/or modify
it under the terms of either:

  * the GNU Lesser General Public License as published by the Free
    Software Foundation; either version 3 of the License, or (at your
    option) any later version.

or

  * the GNU General Public License as published by the Free Software
    Foundation; either version 2 of the License, or (at your option) any
    later version.

or both in parallel, as here.

The GNU MP Library is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received copies of the GNU General Public License and the
GNU Lesser General Public License along with the GNU MP Library.  If not,
see https://www.gnu.org/licenses/.  */

#define GMP_LIMB_BITS 32
#define GMP_LIMB_BYTES 4

/* 700 MHz ARM11 (raspberry pi) */
/* FFT tuning limit = 10 M */
/* Generated by tuneup.c, 2015-10-05, gcc 4.6 */

#define DIVREM_1_NORM_THRESHOLD              0  /* preinv always */
#define DIVREM_1_UNNORM_THRESHOLD            0  /* always */
#define MOD_1_NORM_THRESHOLD                 0  /* always */
#define MOD_1_UNNORM_THRESHOLD               0  /* always */
#define MOD_1N_TO_MOD_1_1_THRESHOLD          3
#define MOD_1U_TO_MOD_1_1_THRESHOLD          6
#define MOD_1_1_TO_MOD_1_2_THRESHOLD         0  /* never mpn_mod_1_1p */
#define MOD_1_2_TO_MOD_1_4_THRESHOLD     MP_SIZE_T_MAX
#define PREINV_MOD_1_TO_MOD_1_THRESHOLD     19
#define USE_PREINV_DIVREM_1                  1  /* preinv always */
#define DIV_QR_1N_PI1_METHOD                 1
#define DIV_QR_1_NORM_THRESHOLD          MP_SIZE_T_MAX  /* never */
#define DIV_QR_1_UNNORM_THRESHOLD        MP_SIZE_T_MAX  /* never */
#define DIV_QR_2_PI2_THRESHOLD           MP_SIZE_T_MAX  /* never */
#define DIVEXACT_1_THRESHOLD                 0  /* always (native) */
#define BMOD_1_TO_MOD_1_THRESHOLD           39

#define MUL_TOOM22_THRESHOLD                44
#define MUL_TOOM33_THRESHOLD               138
#define MUL_TOOM44_THRESHOLD               517
#define MUL_TOOM6H_THRESHOLD                 0  /* always */
#define MUL_TOOM8H_THRESHOLD               692

#define MUL_TOOM32_TO_TOOM43_THRESHOLD     141
#define MUL_TOOM32_TO_TOOM53_THRESHOLD     407
#define MUL_TOOM42_TO_TOOM53_THRESHOLD     132
#define MUL_TOOM42_TO_TOOM63_THRESHOLD     211
#define MUL_TOOM43_TO_TOOM54_THRESHOLD     225

#define SQR_BASECASE_THRESHOLD               0  /* always (native) */
#define SQR_TOOM2_THRESHOLD                 56
#define SQR_TOOM3_THRESHOLD                173
#define SQR_TOOM4_THRESHOLD                711
#define SQR_TOOM6_THRESHOLD                  0  /* always */
#define SQR_TOOM8_THRESHOLD                915

#define MULMID_TOOM42_THRESHOLD             70

#define MULMOD_BNM1_THRESHOLD               24
#define SQRMOD_BNM1_THRESHOLD               28

#define MUL_FFT_MODF_THRESHOLD             560  /* k = 5 */
#define MUL_FFT_TABLE3                                      \
  { {    560, 5}, {     27, 6}, {     15, 5}, {     31, 6}, \
    {     28, 7}, {     15, 6}, {     33, 7}, {     17, 6}, \
    {     36, 7}, {     19, 6}, {     39, 7}, {     23, 6}, \
    {     47, 7}, {     25, 6}, {     51, 7}, {     27, 6}, \
    {     55, 7}, {     29, 8}, {     15, 7}, {     37, 8}, \
    {     19, 7}, {     43, 8}, {     23, 7}, {     51, 8}, \
    {     27, 7}, {     55, 8}, {     31, 7}, {     63, 8}, \
    {     35, 7}, {     71, 8}, {     43, 9}, {     23, 8}, \
    {     55, 9}, {     31, 8}, {     71, 9}, {     39, 8}, \
    {     83, 9}, {     47, 8}, {     99, 9}, {     55,10}, \
    {     31, 9}, {     79,10}, {     47, 9}, {    103,11}, \
    {     31,10}, {     63, 9}, {    135,10}, {     79, 9}, \
    {    159,10}, {     95, 9}, {    191,10}, {    111,11}, \
    {     63,10}, {    159,11}, {     95,10}, {    207,12}, \
    {     63,11}, {    127,10}, {    255, 9}, {    511,10}, \
    {    271,11}, {    159,10}, {    335,11}, {    191,10}, \
    {    399,11}, {    223,12}, {    127,11}, {    255,10}, \
    {    511,11}, {    287,10}, {    575,11}, {    319,10}, \
    {    639,11}, {    351,12}, {    191,11}, {    383,10}, \
    {    767,11}, {    415,13}, {    127,12}, {    255,11}, \
    {    575,12}, {    319,11}, {    703,12}, {    383,11}, \
    {    799,12}, {    447,13}, {    255,12}, {    511,11}, \
    {   1023,12}, {    575,11}, {   1151,12}, {    703,13}, \
    {    383,12}, {    831,14}, {    255,13}, {    511,12}, \
    {   1151,13}, {    639,12}, {   1343,13}, {    767,12}, \
    {   1599,13}, {    895,14}, {    511,13}, {   1023,12}, \
    {   2111,13}, {   1151,12}, {   2367,13}, {   8192,14}, \
    {  16384,15}, {  32768,16} }
#define MUL_FFT_TABLE3_SIZE 110
#define MUL_FFT_THRESHOLD                 5760

#define SQR_FFT_MODF_THRESHOLD             505  /* k = 5 */
#define SQR_FFT_TABLE3                                      \
  { {    505, 5}, {     27, 6}, {     15, 5}, {     31, 6}, \
    {     29, 7}, {     15, 6}, {     33, 7}, {     17, 6}, \
    {     35, 7}, {     19, 6}, {     40, 7}, {     23, 6}, \
    {     47, 7}, {     29, 8}, {     15, 7}, {     37, 8}, \
    {     19, 7}, {     43, 8}, {     23, 7}, {     49, 8}, \
    {     27, 7}, {     55, 8}, {     31, 7}, {     63, 8}, \
    {     43, 9}, {     23, 8}, {     55, 9}, {     31, 8}, \
    {     71, 9}, {     39, 8}, {     83, 9}, {     47, 8}, \
    {     99, 9}, {     55,10}, {     31, 9}, {     79,10}, \
    {     47, 9}, {    103,11}, {     31,10}, {     63, 9}, \
    {    135,10}, {     79, 9}, {    159,10}, {     95, 9}, \
    {    191,10}, {    111,11}, {     63,10}, {    127, 9}, \
    {    255,10}, {    143, 9}, {    287,10}, {    159,11}, \
    {     95,10}, {    191, 9}, {    383,12}, {     63,11}, \
    {    127,10}, {    255, 9}, {    511,10}, {    271, 9}, \
    {    543,10}, {    287,11}, {    159,10}, {    351,11}, \
    {    191,10}, {    415,11}, {    223,12}, {    127,11}, \
    {    255,10}, {    543,11}, {    287,10}, {    607,11}, \
    {    319,10}, {    639,11}, {    351,12}, {    191,11}, \
    {    383,10}, {    767,11}, {    415,13}, {    127,12}, \
    {    255,11}, {    607,12}, {    319,11}, {    703,12}, \
    {    383,11}, {    831,12}, {    447,13}, {    255,12}, \
    {    511,11}, {   1023,12}, {    703,13}, {    383,12}, \
    {    831,14}, {    255,13}, {    511,12}, {   1087,13}, \
    {    639,12}, {   1343,13}, {    767,12}, {   1599,13}, \
    {    895,14}, {    511,13}, {   1023,12}, {   2111,13}, \
    {   1151,12}, {   2431,13}, {   8192,14}, {  16384,15}, \
    {  32768,16} }
#define SQR_FFT_TABLE3_SIZE 109
#define SQR_FFT_THRESHOLD                 4672

#define MULLO_BASECASE_THRESHOLD             0  /* always */
#define MULLO_DC_THRESHOLD                  55
#define MULLO_MUL_N_THRESHOLD            11278
#define SQRLO_BASECASE_THRESHOLD             8
#define SQRLO_DC_THRESHOLD                  51
#define SQRLO_SQR_THRESHOLD               8907

#define DC_DIV_QR_THRESHOLD                 46
#define DC_DIVAPPR_Q_THRESHOLD             148
#define DC_BDIV_QR_THRESHOLD                57
#define DC_BDIV_Q_THRESHOLD                160

#define INV_MULMOD_BNM1_THRESHOLD           86
#define INV_NEWTON_THRESHOLD               138
#define INV_APPR_THRESHOLD                 139

#define BINV_NEWTON_THRESHOLD              216
#define REDC_1_TO_REDC_2_THRESHOLD           6
#define REDC_2_TO_REDC_N_THRESHOLD         124

#define MU_DIV_QR_THRESHOLD               2642
#define MU_DIVAPPR_Q_THRESHOLD            2492
#define MUPI_DIV_QR_THRESHOLD               74
#define MU_BDIV_QR_THRESHOLD              2130
#define MU_BDIV_Q_THRESHOLD               2541

#define POWM_SEC_TABLE  5,26,143,446

#define GET_STR_DC_THRESHOLD                20
#define GET_STR_PRECOMPUTE_THRESHOLD        39
#define SET_STR_DC_THRESHOLD               527
#define SET_STR_PRECOMPUTE_THRESHOLD      1069

#define FAC_DSC_THRESHOLD                  430
#define FAC_ODD_THRESHOLD                   55

#define MATRIX22_STRASSEN_THRESHOLD         23
#define HGCD_THRESHOLD                      79
#define HGCD_APPR_THRESHOLD                 71
#define HGCD_REDUCE_THRESHOLD             3810
#define GCD_DC_THRESHOLD                   283
#define GCDEXT_DC_THRESHOLD                253
#define JACOBI_BASE_METHOD                   1
