#!/bin/sh

enable_color() {
  ENABLECOLOR='-c '
	ANSI_BLACK="\e[30m"
	ANSI_RED="\e[31m"
	ANSI_GREEN="\e[32m"
	ANSI_YELLOW="\e[33m"
	ANSI_BLUE="\e[34m"
	ANSI_MAGENTA="\e[35m"
	ANSI_CYAN="\e[36m"
	ANSI_DARK_GRAY="\e[90m"
	ANSI_LIGHT_GRAY="\e[37m"
	ANSI_LIGHT_RED="\e[91m"
	ANSI_LIGHT_GREEN="\e[92m"
	ANSI_LIGHT_YELLOW="\e[93m"
	ANSI_LIGHT_BLUE="\e[94m"
	ANSI_LIGHT_MAGENTA="\e[95m"
	ANSI_LIGHT_CYAN="\e[96m"
	ANSI_WHITE="\e[97m"
	ANSI_NOCOLOR="\e[0m"

	# red texts
	COLORED_ERROR="${ANSI_RED}[ERROR]"
	COLORED_WARNING="${ANSI_YELLOW}[WARNING]"
	COLORED_FAILED="${ANSI_RED}[FAILED]${ANSI_NOCOLOR}"

	# green texts
	COLORED_DONE="${ANSI_GREEN}[DONE]${ANSI_NOCOLOR}"
	COLORED_SUCCESSFUL="${ANSI_GREEN}[SUCCESSFUL]${ANSI_NOCOLOR}"
}

disable_color() {
	unset ENABLECOLOR
	unset ANSI_BLACK ANSI_RED ANSI_GREEN ANSI_YELLOW ANSI_BLUE ANSI_MAGENTA ANSI_CYAN ANSI_DARK_GRAY
	unset ANSI_LIGHT_GRAY ANSI_LIGHT_RED ANSI_LIGHT_GREEN ANSI_LIGHT_YELLOW ANSI_LIGHT_BLUE ANSI_LIGHT_MAGENTA ANSI_LIGHT_CYAN
	unset ANSI_NOCOLOR

	COLORED_ERROR="[ERROR]"
	COLORED_WARNING="[WARNING]"
	COLORED_FAILED="[FAILED]"

	COLORED_DONE="[DONE]"
	COLORED_SUCCESSFUL="[SUCCESSFUL]"
}

enable_color
