#!/usr/bin/env bash
#               GMT EXAMPLE 46
#
# Purpose:      Illustrate use of solar to plot day/night terminators
# GMT modules:  solar, coast, plot
#

gmt begin ex46
	gmt coast -Rd -JKs0/10i -A5000 -W0.5p -N1/0.5p,gray -S175/210/255 -Bafg --MAP_FRAME_TYPE=plain -Xc
	gmt solar -Td+d2016-02-09T16:00:00 -Gnavy@95
	gmt solar -Tc+d2016-02-09T16:00:00 -Gnavy@85
	gmt solar -Tn+d2016-02-09T16:00:00 -Gnavy@80
	gmt solar -Ta+d2016-02-09T16:00:00 -Gnavy@80
	gmt solar -I+d2016-02-09T16:00:00 -C | gmt plot -Sk@sunglasses/1.5c
gmt end show
