-------------------------------------------------------------------------------
--
--  Filename        : $Source: /cvsroot/gnade/gnade/contrib/gsql/contents_manager-gui.adb,v $
--  Description     : GUI for the data base client
--  Author          : Michael Erdmann
--  Created         : 8.8.2001
--  Last Modified By: $Author: me $
--  Last Modified On: $Date: 2001/10/07 11:49:20 $
--  Status          : $State: Exp $
--
--  Copyright (C) 2000 Michael Erdmann
--                                                                           --
--  GNADE is free software;  you can redistribute it  and/or modify it under --
--  terms of the  GNU General Public License as published  by the Free Soft- --
--  ware  Foundation;  either version 2,  or (at your option) any later ver- --
--  sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
--  OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
--  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
--  for  more details.  You should have  received  a copy of the GNU General --
--  Public License  distributed with GNAT;  see file COPYING.  If not, write --
--  to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
--  MA 02111-1307, USA.                                                      --
--                                                                           --
--  As a special exception,  if other files  instantiate  generics from this --
--  unit, or you link  this unit with other files  to produce an executable, --
--  this  unit  does not  by itself cause  the resulting  executable  to  be --
--  covered  by the  GNU  General  Public  License.  This exception does not --
--  however invalidate  any other reasons why  the executable file  might be --
--  covered by the  GNU Public License.                                      --
--  Author: Michael Erdmann <michael.erdmann@snafu.de>                       --
--                                                                           --
--  Functional description                                                   --
--  ======================                                                   --
--                                                                           --
--  Author                                                                   --
--  ======                                                                   --
--                                                                           --
--  Author: Michael Erdmann <michael.erdmann@snafu.de>                       --
--                                                                           --
--  Restrictions                                                             --
--  ============                                                             --
--  GNADE is implemented to work with GNAT, the GNU Ada compiler.            --
--                                                                           --
-------------------------------------------------------------------------------

with Ada.Text_Io;              use Ada.Text_IO;
with Ada.Exceptions;           use Ada.Exceptions;
with Ada.Strings;              use Ada.Strings;
with Ada.Strings.Fixed;        use Ada.Strings.Fixed;

-- GTK Support packages (gtkada package)

with Glib;                use Glib;

with Gtk;                 use Gtk;
with Gtk.List;            use Gtk.List;
with Gtk.Adjustment;      use Gtk.Adjustment;
with Gtk.Box;             use Gtk.Box;
with Gtk.Enums;           use Gtk.Enums;
with Gtk.Frame;           use Gtk.Frame;
with Gtk.Handlers;        use Gtk.Handlers;
with Gtk.Tree;            use Gtk.Tree;
with Gtk.Tree_Item;       use Gtk.Tree_Item;
with Gtk.Widget;          use Gtk.Widget;

with Unchecked_Conversion;
with GUI_Logging;         use GUI_Logging;

package body Contents_Manager.GUI is

   Version : constant String := "$Id: contents_manager-gui.adb,v 1.6 2001/10/07 11:49:20 me Exp $";

   --- *************************************************************************** --
   --- ***                    L O C A L   D A T A    TYPES                     *** --
   --- *************************************************************************** --
   Component_Tree : Gtk_Tree;

   -----------------------------
   -- Component Tree Elements --
   -----------------------------
   type Component_Tree_Item_Record;
   type Component_Tree_Item is access all Component_Tree_Item_Record;

   type Component_Tree_Item_Record is new Gtk_Tree_Item_Record with
      record
         Id           : Element_Id          := Null_Element_ID;
         Subtree      : Gtk_Tree            := null;
         Display_Name : Unbounded_String    := Null_Unbounded_String;
         Parent       : Element_Id          := Null_Element_ID;
      end record;

   -------------------------------
   -- Table of contents records --
   -------------------------------
   CT : array( Element_ID ) of Component_Tree_Item := (others=>null);

   --- *************************************************************************** --
   --- ***           H A N D L E  THE  C O M P O N E N T   T R E E             *** --
   --- *************************************************************************** --

   package Tree_Element_Cb is new Gtk.Handlers.User_Callback
     (Widget_Type => Gtk.Tree.Gtk_Tree_Record,
      User_Type => Integer);

   --------------------
   -- Component Tree --
   --------------------
   package Tree_Cb is new Handlers.Callback (Gtk_Tree_Record);

   ----------------------
   -- Support Packages --
   ----------------------
   function To_Tree is new Unchecked_Conversion
     (Gtk_Tree_Item, Gtk_Tree);
   function From_Tree is new Unchecked_Conversion
     (Gtk_Tree, Gtk_Tree_Item);

   -------------------------
   -- CB_Component_Select --
   -------------------------
   procedure CB_Component_Select (
      Tree    : access Gtk_Tree_Record'Class;
      Item_P  : access Gtk_Widget_Record'Class;
      Data    : Integer) is
      -- handle all selects of components
      Item          : Component_Tree_Item := Component_Tree_Item( Item_P );
   begin
      Last_Selected := Item.Id;
      Selected( Item.Id );
   exception
      when The_Error : others =>
         Error("Exception " & Exception_Name( The_Error ) & " occured " );
         Error("          " & Exception_Message( The_Error ) );
         raise;
   end Cb_Component_Select;

   ---------------------
   -- Cb_Tree_Changed --
   --------------------
   procedure Cb_Tree_Changed (
      Tree : access GTK_Tree_Record'Class) is

      use Widget_List;
      Selected_List : Widget_List.Glist;
      Nb_Selected   : Guint;
   begin
      Selected_List := Get_Selection (Tree);
      Nb_Selected   := Length (Selected_List);
   end Cb_Tree_Changed;

   -----------------------------
   -- Show_table_Of_Contents  --
   -----------------------------
   procedure Show_Table_Of_Contents(
      Hbox : in out Gtk_Box )  is
      ---
      Root_Element : Gtk_Tree_Item;
      Ts           : Gtk_Tree;
      ---
   begin
      Gtk_New( Ts );
      Set_USize( Ts, 200, 500 );

      Gtk_New(Root_Element, "Root" );
      Append( Ts, Root_Element );
      Show(Ts);

      Gtk_New(Component_Tree);
      Set_Subtree(Root_Element, Component_Tree );
      Show(Component_Tree);

      Pack_Start(Hbox, Child=>Ts, Expand=>False);

      -- install the major call backs
      Tree_Element_Cb.Connect(
         Component_Tree, "select_child",
         Tree_Element_Cb.To_Marshaller (CB_Component_Select'Access),
         0);

      Tree_Cb.Object_Connect(
         Component_Tree, "selection_changed",
         Tree_Cb.To_Marshaller (Cb_Tree_Changed'Access),
         Slot_Object => Component_Tree);

   end Show_Table_Of_Contents;

   -- *************************************************************************** --
   -- ***    C O N T E N T S   M A N A G E M E N T    P R O C E D U R E S     *** --
   -- *************************************************************************** --


   --------------------
   -- Delete_Element --
   --------------------
   procedure Delete_Widget(
      Id         : in Element_ID ) is
      -- delete an element from the compnent tree
      use Widget_List;
      Clear_List : Widget_List.Glist;
   begin
      Widget_List.Prepend( Clear_List, Gtk_Widget(CT(Id)) );
      List_Reverse( Clear_List );
      Remove_Items( CT(CT(Id).Parent).Subtree, Clear_List );
      Free( Clear_List );
   end Delete_Widget;

   -----------------
   -- Add_Element --
   -----------------
   function Add_Element(
      Title   : in String;
      Parent  : in Element_ID := Null_Element_Id;
      Content : in Contents_Handler.Handle := null ) return Element_ID is
      --
      -- Add a section to the table of contents.
      -- R.0 - The object does not yet exist then create a contents
      --       element in the contents manager.
      -- R.1 - if the parent does not yet have a subtree to insert
      --       the element create a subtree.
      -- R.2 - if the parent is null, then assume the root element as
      --       parent.
      --
      Id      : Element_ID := Contents_Manager.Get_Element_ID( Title, Parent );
   begin
      if Id = Null_Element_ID then                                       -- R.0
         Id := Add_Contents_Element(To_Unbounded_String(Title), Content, Parent);
      end if;

      declare
         Item    : Component_Tree_Item renames CT(Id);
         Subtree : Gtk_Tree;
      begin
         if Item /= null then
            return id;
         end if;

         Item := new Component_Tree_Item_Record;
         Item.Display_Name := To_Unbounded_String( Title );
         Item.Id           := Id;
         Item.Parent       := Parent;

         if Parent /= Null_Element_ID then                                 -- R.1
            if CT(Parent).Subtree = null then
               Gtk_New(Subtree);

               CT(Parent).Subtree := Subtree;
               Tree_Element_Cb.Connect(
                     Subtree, "select_child",
                     Tree_Element_Cb.To_Marshaller (CB_Component_Select'Access),
                     0
               );
               Set_Subtree( CT(Parent), Subtree );
               Show( Subtree );
            else
               Subtree := CT(Parent).Subtree;
            end if;
         else
            Subtree := Component_Tree;                                     -- R.2
         end if;

         Gtk.Tree_Item.Initialize (Item, Title );
         Put_Line("Adding subtree");
         Append( Subtree, Item );
         Put_Line("return from Add_element");
         Show(item);
      end ;

      return Id;
   end Add_Element;

   --------------------
   -- Delete_Element --
   --------------------
   procedure Delete_Element(
      Id         : in Element_ID ) is
      -- delete an element from the compnent tree
      use Widget_List;
      Clear_List : Widget_List.Glist;
   begin
      if CT(Id) /= null then
         Widget_List.Prepend( Clear_List, Gtk_Widget(CT(Id)) );
         Remove_Items( CT(CT(Id).Parent).Subtree, Clear_List );
         Contents_Manager.Remove_Contents_Element( Id );
         Free( Clear_List );

         CT(Id) := null;
      else
         Error("Element does not exisits, id=" & Element_ID'Image(Id) );
      end if;

   end Delete_Element;

end Contents_Manager.GUI;

