#ifndef __GM_TRAY_H__
#define __GM_TRAY_H__

#include <gtk/gtk.h>
#include "eggtrayicon.h"

G_BEGIN_DECLS

/*
 * Type checking and casting macros
 */
#define GM_TYPE_TRAY				(gm_tray_get_type())
#define GM_TRAY(obj)				(G_TYPE_CHECK_INSTANCE_CAST((obj), \
		GM_TYPE_TRAY, GmTray))
#define GM_TRAY_CONST(obj)			(G_TYPE_CHECK_INSTANCE_CAST((obj), \
		GM_TYPE_TRAY, GmTray const))
#define GM_TRAY_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST((klass), \
		GM_TYPE_TRAY, GmTrayClass))
#define GM_IS_TRAY(obj)				(G_TYPE_CHECK_INSTANCE_TYPE((obj), \
		GM_TYPE_TRAY))
#define GM_IS_TRAY_CLASS(klass)		(G_TYPE_CHECK_CLASS_TYPE ((klass), \
		GM_TYPE_TRAY))
#define GM_TRAY_GET_CLASS(obj)		(G_TYPE_INSTANCE_GET_CLASS((obj), \
		GM_TYPE_TRAY, GmTrayClass))

/* Private structure type */
typedef struct _GmTrayPrivate GmTrayPrivate;

typedef enum _GmTrayState {
	TRAY_STATE_NORMAL,
	TRAY_STATE_ACTIVE,
	TRAY_STATE_ACTIVITY,
	TRAY_STATE_NOTIFY,
	NUM_TRAY_STATES
} GmTrayState;

/*
 * Main object structure
 */
typedef struct _GmTray GmTray;
 
struct _GmTray {
	EggTrayIcon trayicon;
	
	/*< private > */
	GmTrayPrivate *priv;
};

/*
 * Class definition
 */
typedef struct _GmTrayClass 	GmTrayClass;

struct _GmTrayClass {
	EggTrayIconClass parent_class;

	/* Signals */
};

GType gm_tray_get_type(void) G_GNUC_CONST;
GmTray *gm_tray_new(gchar const *title);
void gm_tray_set_icon(GmTray *tray, GmTrayState state, GdkPixbuf *icon); 

void gm_tray_activate(GmTray *tray);
void gm_tray_normal(GmTray *tray);
void gm_tray_active(GmTray *tray);
void gm_tray_notify(GmTray *tray, gchar const *message);

void gm_tray_message(GmTray *tray, gchar const *message);
void gm_tray_set_tip(GmTray *tray, gchar const *message);
GmTrayState gm_tray_get_state(GmTray *tray);

gboolean gm_tray_has_manager();

G_END_DECLS
#endif /* __GM_TRAY_H__ */
