// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package servicecatalog provides a client for AWS Service Catalog.
package servicecatalog

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opDescribeProduct = "DescribeProduct"

// DescribeProductRequest generates a "aws/request.Request" representing the
// client's request for the DescribeProduct operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeProduct for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeProduct method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeProductRequest method.
//    req, resp := client.DescribeProductRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *ServiceCatalog) DescribeProductRequest(input *DescribeProductInput) (req *request.Request, output *DescribeProductOutput) {
	op := &request.Operation{
		Name:       opDescribeProduct,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeProductInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeProductOutput{}
	req.Data = output
	return
}

// DescribeProduct API operation for AWS Service Catalog.
//
// Retrieves information about a specified product.
//
// This operation is functionally identical to DescribeProductView except that
// it takes as input ProductId instead of ProductViewId.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Service Catalog's
// API operation DescribeProduct for usage and error information.
//
// Returned Error Codes:
//   * ResourceNotFoundException
//   The specified resource was not found.
//
//   * InvalidParametersException
//   One or more parameters provided to the operation are invalid.
//
func (c *ServiceCatalog) DescribeProduct(input *DescribeProductInput) (*DescribeProductOutput, error) {
	req, out := c.DescribeProductRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeProductView = "DescribeProductView"

// DescribeProductViewRequest generates a "aws/request.Request" representing the
// client's request for the DescribeProductView operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeProductView for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeProductView method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeProductViewRequest method.
//    req, resp := client.DescribeProductViewRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *ServiceCatalog) DescribeProductViewRequest(input *DescribeProductViewInput) (req *request.Request, output *DescribeProductViewOutput) {
	op := &request.Operation{
		Name:       opDescribeProductView,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeProductViewInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeProductViewOutput{}
	req.Data = output
	return
}

// DescribeProductView API operation for AWS Service Catalog.
//
// Retrieves information about a specified product.
//
// This operation is functionally identical to DescribeProduct except that it
// takes as input ProductViewId instead of ProductId.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Service Catalog's
// API operation DescribeProductView for usage and error information.
//
// Returned Error Codes:
//   * ResourceNotFoundException
//   The specified resource was not found.
//
//   * InvalidParametersException
//   One or more parameters provided to the operation are invalid.
//
func (c *ServiceCatalog) DescribeProductView(input *DescribeProductViewInput) (*DescribeProductViewOutput, error) {
	req, out := c.DescribeProductViewRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeProvisioningParameters = "DescribeProvisioningParameters"

// DescribeProvisioningParametersRequest generates a "aws/request.Request" representing the
// client's request for the DescribeProvisioningParameters operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeProvisioningParameters for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeProvisioningParameters method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeProvisioningParametersRequest method.
//    req, resp := client.DescribeProvisioningParametersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *ServiceCatalog) DescribeProvisioningParametersRequest(input *DescribeProvisioningParametersInput) (req *request.Request, output *DescribeProvisioningParametersOutput) {
	op := &request.Operation{
		Name:       opDescribeProvisioningParameters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeProvisioningParametersInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeProvisioningParametersOutput{}
	req.Data = output
	return
}

// DescribeProvisioningParameters API operation for AWS Service Catalog.
//
// Provides information about parameters required to provision a specified product
// in a specified manner. Use this operation to obtain the list of ProvisioningArtifactParameters
// parameters available to call the ProvisionProduct operation for the specified
// product.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Service Catalog's
// API operation DescribeProvisioningParameters for usage and error information.
//
// Returned Error Codes:
//   * InvalidParametersException
//   One or more parameters provided to the operation are invalid.
//
//   * ResourceNotFoundException
//   The specified resource was not found.
//
func (c *ServiceCatalog) DescribeProvisioningParameters(input *DescribeProvisioningParametersInput) (*DescribeProvisioningParametersOutput, error) {
	req, out := c.DescribeProvisioningParametersRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeRecord = "DescribeRecord"

// DescribeRecordRequest generates a "aws/request.Request" representing the
// client's request for the DescribeRecord operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeRecord for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeRecord method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeRecordRequest method.
//    req, resp := client.DescribeRecordRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *ServiceCatalog) DescribeRecordRequest(input *DescribeRecordInput) (req *request.Request, output *DescribeRecordOutput) {
	op := &request.Operation{
		Name:       opDescribeRecord,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeRecordInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeRecordOutput{}
	req.Data = output
	return
}

// DescribeRecord API operation for AWS Service Catalog.
//
// Retrieves a paginated list of the full details of a specific request. Use
// this operation after calling a request operation (ProvisionProduct, TerminateProvisionedProduct,
// or UpdateProvisionedProduct).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Service Catalog's
// API operation DescribeRecord for usage and error information.
//
// Returned Error Codes:
//   * ResourceNotFoundException
//   The specified resource was not found.
//
func (c *ServiceCatalog) DescribeRecord(input *DescribeRecordInput) (*DescribeRecordOutput, error) {
	req, out := c.DescribeRecordRequest(input)
	err := req.Send()
	return out, err
}

const opListLaunchPaths = "ListLaunchPaths"

// ListLaunchPathsRequest generates a "aws/request.Request" representing the
// client's request for the ListLaunchPaths operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListLaunchPaths for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListLaunchPaths method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListLaunchPathsRequest method.
//    req, resp := client.ListLaunchPathsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *ServiceCatalog) ListLaunchPathsRequest(input *ListLaunchPathsInput) (req *request.Request, output *ListLaunchPathsOutput) {
	op := &request.Operation{
		Name:       opListLaunchPaths,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListLaunchPathsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListLaunchPathsOutput{}
	req.Data = output
	return
}

// ListLaunchPaths API operation for AWS Service Catalog.
//
// Returns a paginated list of all paths to a specified product. A path is how
// the user has access to a specified product, and is necessary when provisioning
// a product. A path also determines the constraints put on the product.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Service Catalog's
// API operation ListLaunchPaths for usage and error information.
//
// Returned Error Codes:
//   * InvalidParametersException
//   One or more parameters provided to the operation are invalid.
//
//   * ResourceNotFoundException
//   The specified resource was not found.
//
func (c *ServiceCatalog) ListLaunchPaths(input *ListLaunchPathsInput) (*ListLaunchPathsOutput, error) {
	req, out := c.ListLaunchPathsRequest(input)
	err := req.Send()
	return out, err
}

const opListRecordHistory = "ListRecordHistory"

// ListRecordHistoryRequest generates a "aws/request.Request" representing the
// client's request for the ListRecordHistory operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListRecordHistory for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListRecordHistory method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListRecordHistoryRequest method.
//    req, resp := client.ListRecordHistoryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *ServiceCatalog) ListRecordHistoryRequest(input *ListRecordHistoryInput) (req *request.Request, output *ListRecordHistoryOutput) {
	op := &request.Operation{
		Name:       opListRecordHistory,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListRecordHistoryInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListRecordHistoryOutput{}
	req.Data = output
	return
}

// ListRecordHistory API operation for AWS Service Catalog.
//
// Returns a paginated list of all performed requests, in the form of RecordDetails
// objects that are filtered as specified.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Service Catalog's
// API operation ListRecordHistory for usage and error information.
//
// Returned Error Codes:
//   * InvalidParametersException
//   One or more parameters provided to the operation are invalid.
//
func (c *ServiceCatalog) ListRecordHistory(input *ListRecordHistoryInput) (*ListRecordHistoryOutput, error) {
	req, out := c.ListRecordHistoryRequest(input)
	err := req.Send()
	return out, err
}

const opProvisionProduct = "ProvisionProduct"

// ProvisionProductRequest generates a "aws/request.Request" representing the
// client's request for the ProvisionProduct operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ProvisionProduct for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ProvisionProduct method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ProvisionProductRequest method.
//    req, resp := client.ProvisionProductRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *ServiceCatalog) ProvisionProductRequest(input *ProvisionProductInput) (req *request.Request, output *ProvisionProductOutput) {
	op := &request.Operation{
		Name:       opProvisionProduct,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ProvisionProductInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ProvisionProductOutput{}
	req.Data = output
	return
}

// ProvisionProduct API operation for AWS Service Catalog.
//
// Requests a Provision of a specified product. A ProvisionedProduct is a resourced
// instance for a product. For example, provisioning a CloudFormation-template-backed
// product results in launching a CloudFormation stack and all the underlying
// resources that come with it.
//
// You can check the status of this request using the DescribeRecord operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Service Catalog's
// API operation ProvisionProduct for usage and error information.
//
// Returned Error Codes:
//   * InvalidParametersException
//   One or more parameters provided to the operation are invalid.
//
//   * ResourceNotFoundException
//   The specified resource was not found.
//
//   * DuplicateResourceException
//   The specified resource is a duplicate.
//
func (c *ServiceCatalog) ProvisionProduct(input *ProvisionProductInput) (*ProvisionProductOutput, error) {
	req, out := c.ProvisionProductRequest(input)
	err := req.Send()
	return out, err
}

const opScanProvisionedProducts = "ScanProvisionedProducts"

// ScanProvisionedProductsRequest generates a "aws/request.Request" representing the
// client's request for the ScanProvisionedProducts operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ScanProvisionedProducts for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ScanProvisionedProducts method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ScanProvisionedProductsRequest method.
//    req, resp := client.ScanProvisionedProductsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *ServiceCatalog) ScanProvisionedProductsRequest(input *ScanProvisionedProductsInput) (req *request.Request, output *ScanProvisionedProductsOutput) {
	op := &request.Operation{
		Name:       opScanProvisionedProducts,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ScanProvisionedProductsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ScanProvisionedProductsOutput{}
	req.Data = output
	return
}

// ScanProvisionedProducts API operation for AWS Service Catalog.
//
// Returns a paginated list of all the ProvisionedProduct objects that are currently
// available (not terminated).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Service Catalog's
// API operation ScanProvisionedProducts for usage and error information.
//
// Returned Error Codes:
//   * InvalidParametersException
//   One or more parameters provided to the operation are invalid.
//
func (c *ServiceCatalog) ScanProvisionedProducts(input *ScanProvisionedProductsInput) (*ScanProvisionedProductsOutput, error) {
	req, out := c.ScanProvisionedProductsRequest(input)
	err := req.Send()
	return out, err
}

const opSearchProducts = "SearchProducts"

// SearchProductsRequest generates a "aws/request.Request" representing the
// client's request for the SearchProducts operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See SearchProducts for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the SearchProducts method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the SearchProductsRequest method.
//    req, resp := client.SearchProductsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *ServiceCatalog) SearchProductsRequest(input *SearchProductsInput) (req *request.Request, output *SearchProductsOutput) {
	op := &request.Operation{
		Name:       opSearchProducts,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SearchProductsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &SearchProductsOutput{}
	req.Data = output
	return
}

// SearchProducts API operation for AWS Service Catalog.
//
// Returns a paginated list all of the Products objects to which the caller
// has access.
//
// The output of this operation can be used as input for other operations, such
// as DescribeProductView.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Service Catalog's
// API operation SearchProducts for usage and error information.
//
// Returned Error Codes:
//   * InvalidParametersException
//   One or more parameters provided to the operation are invalid.
//
func (c *ServiceCatalog) SearchProducts(input *SearchProductsInput) (*SearchProductsOutput, error) {
	req, out := c.SearchProductsRequest(input)
	err := req.Send()
	return out, err
}

const opTerminateProvisionedProduct = "TerminateProvisionedProduct"

// TerminateProvisionedProductRequest generates a "aws/request.Request" representing the
// client's request for the TerminateProvisionedProduct operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See TerminateProvisionedProduct for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the TerminateProvisionedProduct method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the TerminateProvisionedProductRequest method.
//    req, resp := client.TerminateProvisionedProductRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *ServiceCatalog) TerminateProvisionedProductRequest(input *TerminateProvisionedProductInput) (req *request.Request, output *TerminateProvisionedProductOutput) {
	op := &request.Operation{
		Name:       opTerminateProvisionedProduct,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TerminateProvisionedProductInput{}
	}

	req = c.newRequest(op, input, output)
	output = &TerminateProvisionedProductOutput{}
	req.Data = output
	return
}

// TerminateProvisionedProduct API operation for AWS Service Catalog.
//
// Requests termination of an existing ProvisionedProduct object. If there are
// Tags associated with the object, they are terminated when the ProvisionedProduct
// object is terminated.
//
// This operation does not delete any records associated with the ProvisionedProduct
// object.
//
// You can check the status of this request using the DescribeRecord operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Service Catalog's
// API operation TerminateProvisionedProduct for usage and error information.
//
// Returned Error Codes:
//   * ResourceNotFoundException
//   The specified resource was not found.
//
func (c *ServiceCatalog) TerminateProvisionedProduct(input *TerminateProvisionedProductInput) (*TerminateProvisionedProductOutput, error) {
	req, out := c.TerminateProvisionedProductRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateProvisionedProduct = "UpdateProvisionedProduct"

// UpdateProvisionedProductRequest generates a "aws/request.Request" representing the
// client's request for the UpdateProvisionedProduct operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateProvisionedProduct for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateProvisionedProduct method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateProvisionedProductRequest method.
//    req, resp := client.UpdateProvisionedProductRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *ServiceCatalog) UpdateProvisionedProductRequest(input *UpdateProvisionedProductInput) (req *request.Request, output *UpdateProvisionedProductOutput) {
	op := &request.Operation{
		Name:       opUpdateProvisionedProduct,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateProvisionedProductInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdateProvisionedProductOutput{}
	req.Data = output
	return
}

// UpdateProvisionedProduct API operation for AWS Service Catalog.
//
// Requests updates to the configuration of an existing ProvisionedProduct object.
// If there are tags associated with the object, they cannot be updated or added
// with this operation. Depending on the specific updates requested, this operation
// may update with no interruption, with some interruption, or replace the ProvisionedProduct
// object entirely.
//
// You can check the status of this request using the DescribeRecord operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Service Catalog's
// API operation UpdateProvisionedProduct for usage and error information.
//
// Returned Error Codes:
//   * InvalidParametersException
//   One or more parameters provided to the operation are invalid.
//
//   * ResourceNotFoundException
//   The specified resource was not found.
//
func (c *ServiceCatalog) UpdateProvisionedProduct(input *UpdateProvisionedProductInput) (*UpdateProvisionedProductOutput, error) {
	req, out := c.UpdateProvisionedProductRequest(input)
	err := req.Send()
	return out, err
}

// The access level to limit results.
type AccessLevelFilter struct {
	_ struct{} `type:"structure"`

	// Specifies the access level.
	//
	// Account allows results at the account level.
	//
	// Role allows results based on the federated role of the specified user.
	//
	// User allows results limited to the specified user.
	Key *string `type:"string" enum:"AccessLevelFilterKey"`

	// Specifies the user to which the access level applies. A value of Self is
	// currently supported.
	Value *string `type:"string"`
}

// String returns the string representation
func (s AccessLevelFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccessLevelFilter) GoString() string {
	return s.String()
}

// An administrator-specified constraint to apply when provisioning a product.
type ConstraintSummary struct {
	_ struct{} `type:"structure"`

	// The text description of the constraint.
	Description *string `type:"string"`

	// The type of the constraint.
	Type *string `type:"string"`
}

// String returns the string representation
func (s ConstraintSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConstraintSummary) GoString() string {
	return s.String()
}

type DescribeProductInput struct {
	_ struct{} `type:"structure"`

	// The language code to use for this operation. Supported language codes are
	// as follows:
	//
	// "en" (English)
	//
	// "jp" (Japanese)
	//
	// "zh" (Chinese)
	//
	// If no code is specified, "en" is used as the default.
	AcceptLanguage *string `type:"string"`

	// The ProductId of the product to describe.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeProductInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeProductInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeProductInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeProductInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeProductOutput struct {
	_ struct{} `type:"structure"`

	// The summary metadata about the specified product.
	ProductViewSummary *ProductViewSummary `type:"structure"`

	// A list of provisioning artifact objects for the specified product. The ProvisioningArtifacts
	// parameter represent the ways the specified product can be provisioned.
	ProvisioningArtifacts []*ProvisioningArtifact `type:"list"`
}

// String returns the string representation
func (s DescribeProductOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeProductOutput) GoString() string {
	return s.String()
}

type DescribeProductViewInput struct {
	_ struct{} `type:"structure"`

	// The language code to use for this operation. Supported language codes are
	// as follows:
	//
	// "en" (English)
	//
	// "jp" (Japanese)
	//
	// "zh" (Chinese)
	//
	// If no code is specified, "en" is used as the default.
	AcceptLanguage *string `type:"string"`

	// The ProductViewId of the product to describe.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeProductViewInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeProductViewInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeProductViewInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeProductViewInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeProductViewOutput struct {
	_ struct{} `type:"structure"`

	// The summary metadata about the specified product.
	ProductViewSummary *ProductViewSummary `type:"structure"`

	// A list of provisioning artifact objects for the specified product. The ProvisioningArtifacts
	// represent the ways in which the specified product can be provisioned.
	ProvisioningArtifacts []*ProvisioningArtifact `type:"list"`
}

// String returns the string representation
func (s DescribeProductViewOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeProductViewOutput) GoString() string {
	return s.String()
}

type DescribeProvisioningParametersInput struct {
	_ struct{} `type:"structure"`

	// The language code to use for this operation. Supported language codes are
	// as follows:
	//
	// "en" (English)
	//
	// "jp" (Japanese)
	//
	// "zh" (Chinese)
	//
	// If no code is specified, "en" is used as the default.
	AcceptLanguage *string `type:"string"`

	// The identifier of the path for this product's provisioning. This value is
	// optional if the product has a default path, and is required if there is more
	// than one path for the specified product.
	PathId *string `min:"1" type:"string"`

	// The identifier of the product.
	//
	// ProductId is a required field
	ProductId *string `min:"1" type:"string" required:"true"`

	// The provisioning artifact identifier for this product.
	//
	// ProvisioningArtifactId is a required field
	ProvisioningArtifactId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeProvisioningParametersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeProvisioningParametersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeProvisioningParametersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeProvisioningParametersInput"}
	if s.PathId != nil && len(*s.PathId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PathId", 1))
	}
	if s.ProductId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProductId"))
	}
	if s.ProductId != nil && len(*s.ProductId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProductId", 1))
	}
	if s.ProvisioningArtifactId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProvisioningArtifactId"))
	}
	if s.ProvisioningArtifactId != nil && len(*s.ProvisioningArtifactId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProvisioningArtifactId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeProvisioningParametersOutput struct {
	_ struct{} `type:"structure"`

	// The list of constraint summaries that apply to provisioning this product.
	ConstraintSummaries []*ConstraintSummary `type:"list"`

	// The list of parameters used to successfully provision the product. Each parameter
	// includes a list of allowable values and additional metadata about each parameter.
	ProvisioningArtifactParameters []*ProvisioningArtifactParameter `type:"list"`

	// Any additional metadata specifically related to the provisioning of the product.
	// For example, see the Version field of the CloudFormation template.
	UsageInstructions []*UsageInstruction `type:"list"`
}

// String returns the string representation
func (s DescribeProvisioningParametersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeProvisioningParametersOutput) GoString() string {
	return s.String()
}

type DescribeRecordInput struct {
	_ struct{} `type:"structure"`

	// The language code to use for this operation. Supported language codes are
	// as follows:
	//
	// "en" (English)
	//
	// "jp" (Japanese)
	//
	// "zh" (Chinese)
	//
	// If no code is specified, "en" is used as the default.
	AcceptLanguage *string `type:"string"`

	// The record identifier of the ProvisionedProduct object for which to retrieve
	// output information. This is the RecordDetail.RecordId obtained from the request
	// operation's response.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// The maximum number of items to return in the results. If more results exist
	// than fit in the specified PageSize, the value of NextPageToken in the response
	// is non-null.
	PageSize *int64 `type:"integer"`

	// The page token of the first page retrieved. If null, this retrieves the first
	// page of size PageSize.
	PageToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeRecordInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeRecordInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeRecordInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeRecordInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeRecordOutput struct {
	_ struct{} `type:"structure"`

	// The page token to use to retrieve the next page of results for this operation.
	// If there are no more pages, this value is null.
	NextPageToken *string `type:"string"`

	// Detailed record information for the specified product.
	RecordDetail *RecordDetail `type:"structure"`

	// A list of outputs for the specified Product object created as the result
	// of a request. For example, a CloudFormation-backed product that creates an
	// S3 bucket would have an output for the S3 bucket URL.
	RecordOutputs []*RecordOutput `type:"list"`
}

// String returns the string representation
func (s DescribeRecordOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeRecordOutput) GoString() string {
	return s.String()
}

// Summary information about a path for a user to have access to a specified
// product.
type LaunchPathSummary struct {
	_ struct{} `type:"structure"`

	// List of constraints on the portfolio-product relationship.
	ConstraintSummaries []*ConstraintSummary `type:"list"`

	// The unique identifier of the product path.
	Id *string `min:"1" type:"string"`

	// Corresponds to the name of the portfolio to which the user was assigned.
	Name *string `type:"string"`

	// List of tags used by this launch path.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s LaunchPathSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LaunchPathSummary) GoString() string {
	return s.String()
}

type ListLaunchPathsInput struct {
	_ struct{} `type:"structure"`

	// The language code to use for this operation. Supported language codes are
	// as follows:
	//
	// "en" (English)
	//
	// "jp" (Japanese)
	//
	// "zh" (Chinese)
	//
	// If no code is specified, "en" is used as the default.
	AcceptLanguage *string `type:"string"`

	// The maximum number of items to return in the results. If more results exist
	// than fit in the specified PageSize, the value of NextPageToken in the response
	// is non-null.
	PageSize *int64 `type:"integer"`

	// The page token of the first page retrieved. If null, this retrieves the first
	// page of size PageSize.
	PageToken *string `type:"string"`

	// Identifies the product for which to retrieve LaunchPathSummaries information.
	//
	// ProductId is a required field
	ProductId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListLaunchPathsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListLaunchPathsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListLaunchPathsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListLaunchPathsInput"}
	if s.ProductId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProductId"))
	}
	if s.ProductId != nil && len(*s.ProductId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProductId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListLaunchPathsOutput struct {
	_ struct{} `type:"structure"`

	// List of launch path information summaries for the specified PageToken.
	LaunchPathSummaries []*LaunchPathSummary `type:"list"`

	// The page token to use to retrieve the next page of results for this operation.
	// If there are no more pages, this value is null.
	NextPageToken *string `type:"string"`
}

// String returns the string representation
func (s ListLaunchPathsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListLaunchPathsOutput) GoString() string {
	return s.String()
}

type ListRecordHistoryInput struct {
	_ struct{} `type:"structure"`

	// The language code to use for this operation. Supported language codes are
	// as follows:
	//
	// "en" (English)
	//
	// "jp" (Japanese)
	//
	// "zh" (Chinese)
	//
	// If no code is specified, "en" is used as the default.
	AcceptLanguage *string `type:"string"`

	// The access level for obtaining results. If left unspecified, User level access
	// is used.
	AccessLevelFilter *AccessLevelFilter `type:"structure"`

	// The maximum number of items to return in the results. If more results exist
	// than fit in the specified PageSize, the value of NextPageToken in the response
	// is non-null.
	PageSize *int64 `type:"integer"`

	// The page token of the first page retrieved. If null, this retrieves the first
	// page of size PageSize.
	PageToken *string `type:"string"`

	// The filter to limit search results.
	SearchFilter *ListRecordHistorySearchFilter `type:"structure"`
}

// String returns the string representation
func (s ListRecordHistoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRecordHistoryInput) GoString() string {
	return s.String()
}

type ListRecordHistoryOutput struct {
	_ struct{} `type:"structure"`

	// The page token to use to retrieve the next page of results for this operation.
	// If there are no more pages, this value is null.
	NextPageToken *string `type:"string"`

	// A list of record detail objects, listed in reverse chronological order.
	RecordDetails []*RecordDetail `type:"list"`
}

// String returns the string representation
func (s ListRecordHistoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRecordHistoryOutput) GoString() string {
	return s.String()
}

// The search filter to limit results when listing request history records.
type ListRecordHistorySearchFilter struct {
	_ struct{} `type:"structure"`

	// The filter key.
	Key *string `type:"string"`

	// The filter value for Key.
	Value *string `type:"string"`
}

// String returns the string representation
func (s ListRecordHistorySearchFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRecordHistorySearchFilter) GoString() string {
	return s.String()
}

// The constraints that the administrator has put on the parameter.
type ParameterConstraints struct {
	_ struct{} `type:"structure"`

	// The values that the administrator has allowed for the parameter.
	AllowedValues []*string `type:"list"`
}

// String returns the string representation
func (s ParameterConstraints) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ParameterConstraints) GoString() string {
	return s.String()
}

// A single product view aggregation value/count pair, containing metadata about
// each product to which the calling user has access.
type ProductViewAggregationValue struct {
	_ struct{} `type:"structure"`

	// An approximate count of the products that match the value.
	ApproximateCount *int64 `type:"integer"`

	// The value of the product view aggregation.
	Value *string `type:"string"`
}

// String returns the string representation
func (s ProductViewAggregationValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ProductViewAggregationValue) GoString() string {
	return s.String()
}

// The summary metadata about the specified product.
type ProductViewSummary struct {
	_ struct{} `type:"structure"`

	// The distributor of the product. Contact the product administrator for the
	// significance of this value.
	Distributor *string `type:"string"`

	// A value of false indicates that the product does not have a default path,
	// while a value of true indicates that it does. If it's false, call ListLaunchPaths
	// to disambiguate between paths. If true, ListLaunchPaths is not required,
	// and the output of the ProductViewSummary operation can be used directly with
	// DescribeProvisioningParameters.
	HasDefaultPath *bool `type:"boolean"`

	// The product view identifier.
	Id *string `min:"1" type:"string"`

	// The name of the product.
	Name *string `type:"string"`

	// The owner of the product. Contact the product administrator for the significance
	// of this value.
	Owner *string `type:"string"`

	// The product identifier.
	ProductId *string `min:"1" type:"string"`

	// Short description of the product.
	ShortDescription *string `type:"string"`

	// The description of the support for this Product.
	SupportDescription *string `type:"string"`

	// The email contact information to obtain support for this Product.
	SupportEmail *string `type:"string"`

	// The URL information to obtain support for this Product.
	SupportUrl *string `type:"string"`

	// The product type. Contact the product administrator for the significance
	// of this value.
	Type *string `type:"string"`
}

// String returns the string representation
func (s ProductViewSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ProductViewSummary) GoString() string {
	return s.String()
}

type ProvisionProductInput struct {
	_ struct{} `type:"structure"`

	// The language code to use for this operation. Supported language codes are
	// as follows:
	//
	// "en" (English)
	//
	// "jp" (Japanese)
	//
	// "zh" (Chinese)
	//
	// If no code is specified, "en" is used as the default.
	AcceptLanguage *string `type:"string"`

	// Passed to CloudFormation. The SNS topic ARNs to which to publish stack-related
	// events.
	NotificationArns []*string `type:"list"`

	// The identifier of the path for this product's provisioning. This value is
	// optional if the product has a default path, and is required if there is more
	// than one path for the specified product.
	PathId *string `min:"1" type:"string"`

	// The identifier of the product.
	//
	// ProductId is a required field
	ProductId *string `min:"1" type:"string" required:"true"`

	// An idempotency token that uniquely identifies the provisioning request.
	//
	// ProvisionToken is a required field
	ProvisionToken *string `min:"1" type:"string" required:"true" idempotencyToken:"true"`

	// A user-friendly name to identify the ProvisionedProduct object. This value
	// must be unique for the AWS account and cannot be updated after the product
	// is provisioned.
	//
	// ProvisionedProductName is a required field
	ProvisionedProductName *string `type:"string" required:"true"`

	// The provisioning artifact identifier for this product.
	//
	// ProvisioningArtifactId is a required field
	ProvisioningArtifactId *string `min:"1" type:"string" required:"true"`

	// Parameters specified by the administrator that are required for provisioning
	// the product.
	ProvisioningParameters []*ProvisioningParameter `type:"list"`

	// A list of tags to use as provisioning options.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s ProvisionProductInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ProvisionProductInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ProvisionProductInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ProvisionProductInput"}
	if s.PathId != nil && len(*s.PathId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PathId", 1))
	}
	if s.ProductId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProductId"))
	}
	if s.ProductId != nil && len(*s.ProductId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProductId", 1))
	}
	if s.ProvisionToken == nil {
		invalidParams.Add(request.NewErrParamRequired("ProvisionToken"))
	}
	if s.ProvisionToken != nil && len(*s.ProvisionToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProvisionToken", 1))
	}
	if s.ProvisionedProductName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProvisionedProductName"))
	}
	if s.ProvisioningArtifactId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProvisioningArtifactId"))
	}
	if s.ProvisioningArtifactId != nil && len(*s.ProvisioningArtifactId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProvisioningArtifactId", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ProvisionProductOutput struct {
	_ struct{} `type:"structure"`

	// The detailed result of the ProvisionProduct request, containing the inputs
	// made to that request, the current state of the request, a pointer to the
	// ProvisionedProduct object of the request, and a list of any errors that the
	// request encountered.
	RecordDetail *RecordDetail `type:"structure"`
}

// String returns the string representation
func (s ProvisionProductOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ProvisionProductOutput) GoString() string {
	return s.String()
}

// Detailed information about a ProvisionedProduct object.
type ProvisionedProductDetail struct {
	_ struct{} `type:"structure"`

	// The ARN associated with the ProvisionedProduct object.
	Arn *string `min:"1" type:"string"`

	// The time the ProvisionedProduct was created.
	CreatedTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The identifier of the ProvisionedProduct object.
	Id *string `type:"string"`

	// An idempotency token that uniquely identifies this ProvisionedProduct.
	IdempotencyToken *string `min:"1" type:"string"`

	// The record identifier of the last request performed on this ProvisionedProduct
	// object.
	LastRecordId *string `type:"string"`

	// The user-friendly name of the ProvisionedProduct object.
	Name *string `min:"1" type:"string"`

	// The current status of the ProvisionedProduct.
	Status *string `type:"string" enum:"RecordStatus"`

	// The current status message of the ProvisionedProduct.
	StatusMessage *string `type:"string"`

	// The type of the ProvisionedProduct object.
	Type *string `type:"string"`
}

// String returns the string representation
func (s ProvisionedProductDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ProvisionedProductDetail) GoString() string {
	return s.String()
}

// Contains information indicating the ways in which a product can be provisioned.
type ProvisioningArtifact struct {
	_ struct{} `type:"structure"`

	// The time that the artifact was created by the Administrator.
	CreatedTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The text description of the artifact.
	Description *string `type:"string"`

	// The identifier for the artifact.
	Id *string `min:"1" type:"string"`

	// The name of the artifact.
	Name *string `type:"string"`
}

// String returns the string representation
func (s ProvisioningArtifact) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ProvisioningArtifact) GoString() string {
	return s.String()
}

// A parameter used to successfully provision the product. This value includes
// a list of allowable values and additional metadata.
type ProvisioningArtifactParameter struct {
	_ struct{} `type:"structure"`

	// The default value for this parameter.
	DefaultValue *string `type:"string"`

	// The text description of the parameter.
	Description *string `type:"string"`

	// If this value is true, the value for this parameter is obfuscated from view
	// when the parameter is retrieved. This parameter is used to hide sensitive
	// information.
	IsNoEcho *bool `type:"boolean"`

	// The list of constraints that the administrator has put on the parameter.
	ParameterConstraints *ParameterConstraints `type:"structure"`

	// The parameter key.
	ParameterKey *string `type:"string"`

	// The parameter type.
	ParameterType *string `type:"string"`
}

// String returns the string representation
func (s ProvisioningArtifactParameter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ProvisioningArtifactParameter) GoString() string {
	return s.String()
}

// The arameter key/value pairs used to provision a product.
type ProvisioningParameter struct {
	_ struct{} `type:"structure"`

	// The ProvisioningArtifactParameter.ParameterKey parameter from DescribeProvisioningParameters.
	Key *string `type:"string"`

	// The value to use for provisioning. Any constraints on this value can be found
	// in ProvisioningArtifactParameter for Key.
	Value *string `type:"string"`
}

// String returns the string representation
func (s ProvisioningParameter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ProvisioningParameter) GoString() string {
	return s.String()
}

// The full details of a specific ProvisionedProduct object.
type RecordDetail struct {
	_ struct{} `type:"structure"`

	// The time when the record for the ProvisionedProduct object was created.
	CreatedTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The identifier of the path for this product's provisioning.
	PathId *string `min:"1" type:"string"`

	// The identifier of the product.
	ProductId *string `min:"1" type:"string"`

	// The identifier of the ProvisionedProduct object.
	ProvisionedProductId *string `min:"1" type:"string"`

	// The user-friendly name of the ProvisionedProduct object.
	ProvisionedProductName *string `type:"string"`

	// The type of the ProvisionedProduct object.
	ProvisionedProductType *string `type:"string"`

	// The provisioning artifact identifier for this product.
	ProvisioningArtifactId *string `min:"1" type:"string"`

	// A list of errors that occurred while processing the request.
	RecordErrors []*RecordError `type:"list"`

	// The identifier of the ProvisionedProduct object record.
	RecordId *string `min:"1" type:"string"`

	// List of tags associated with this record.
	RecordTags []*RecordTag `type:"list"`

	// The record type for this record.
	RecordType *string `type:"string"`

	// The status of the ProvisionedProduct object.
	Status *string `type:"string" enum:"RecordStatus"`

	// The time when the record for the ProvisionedProduct object was last updated.
	UpdatedTime *time.Time `type:"timestamp" timestampFormat:"unix"`
}

// String returns the string representation
func (s RecordDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RecordDetail) GoString() string {
	return s.String()
}

// The error code and description resulting from an operation.
type RecordError struct {
	_ struct{} `type:"structure"`

	// The numeric value of the error.
	Code *string `type:"string"`

	// The text description of the error.
	Description *string `type:"string"`
}

// String returns the string representation
func (s RecordError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RecordError) GoString() string {
	return s.String()
}

// An output for the specified Product object created as the result of a request.
// For example, a CloudFormation-backed product that creates an S3 bucket would
// have an output for the S3 bucket URL.
type RecordOutput struct {
	_ struct{} `type:"structure"`

	// The text description of the output.
	Description *string `type:"string"`

	// The output key.
	OutputKey *string `type:"string"`

	// The output value.
	OutputValue *string `type:"string"`
}

// String returns the string representation
func (s RecordOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RecordOutput) GoString() string {
	return s.String()
}

// A tag associated with the record, stored as a key-value pair.
type RecordTag struct {
	_ struct{} `type:"structure"`

	// The key for this tag.
	Key *string `min:"1" type:"string"`

	// The value for this tag.
	Value *string `min:"1" type:"string"`
}

// String returns the string representation
func (s RecordTag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RecordTag) GoString() string {
	return s.String()
}

type ScanProvisionedProductsInput struct {
	_ struct{} `type:"structure"`

	// The language code to use for this operation. Supported language codes are
	// as follows:
	//
	// "en" (English)
	//
	// "jp" (Japanese)
	//
	// "zh" (Chinese)
	//
	// If no code is specified, "en" is used as the default.
	AcceptLanguage *string `type:"string"`

	// The access level for obtaining results. If left unspecified, User level access
	// is used.
	AccessLevelFilter *AccessLevelFilter `type:"structure"`

	// The maximum number of items to return in the results. If more results exist
	// than fit in the specified PageSize, the value of NextPageToken in the response
	// is non-null.
	PageSize *int64 `type:"integer"`

	// The page token of the first page retrieved. If null, this retrieves the first
	// page of size PageSize.
	PageToken *string `type:"string"`
}

// String returns the string representation
func (s ScanProvisionedProductsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ScanProvisionedProductsInput) GoString() string {
	return s.String()
}

type ScanProvisionedProductsOutput struct {
	_ struct{} `type:"structure"`

	// The page token to use to retrieve the next page of results for this operation.
	// If there are no more pages, this value is null.
	NextPageToken *string `type:"string"`

	// A list of ProvisionedProduct detail objects.
	ProvisionedProducts []*ProvisionedProductDetail `type:"list"`
}

// String returns the string representation
func (s ScanProvisionedProductsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ScanProvisionedProductsOutput) GoString() string {
	return s.String()
}

type SearchProductsInput struct {
	_ struct{} `type:"structure"`

	// The language code to use for this operation. Supported language codes are
	// as follows:
	//
	// "en" (English)
	//
	// "jp" (Japanese)
	//
	// "zh" (Chinese)
	//
	// If no code is specified, "en" is used as the default.
	AcceptLanguage *string `type:"string"`

	// The list of filters with which to limit search results. If no search filters
	// are specified, the output is all the products to which the calling user has
	// access.
	Filters map[string][]*string `type:"map"`

	// The maximum number of items to return in the results. If more results exist
	// than fit in the specified PageSize, the value of NextPageToken in the response
	// is non-null.
	PageSize *int64 `type:"integer"`

	// The page token of the first page retrieved. If null, this retrieves the first
	// page of size PageSize.
	PageToken *string `type:"string"`

	// The sort field specifier. If no value is specified, results are not sorted.
	SortBy *string `type:"string" enum:"ProductViewSortBy"`

	// The sort order specifier. If no value is specified, results are not sorted.
	SortOrder *string `type:"string" enum:"SortOrder"`
}

// String returns the string representation
func (s SearchProductsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SearchProductsInput) GoString() string {
	return s.String()
}

type SearchProductsOutput struct {
	_ struct{} `type:"structure"`

	// The page token to use to retrieve the next page of results for this operation.
	// If there are no more pages, this value is null.
	NextPageToken *string `type:"string"`

	// A list of the product view aggregation value objects.
	ProductViewAggregations map[string][]*ProductViewAggregationValue `type:"map"`

	// A list of the product view summary objects.
	ProductViewSummaries []*ProductViewSummary `type:"list"`
}

// String returns the string representation
func (s SearchProductsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SearchProductsOutput) GoString() string {
	return s.String()
}

// Key/value pairs to associate with this provisioning. These tags are entirely
// discretionary and are propagated to the resources created in the provisioning.
type Tag struct {
	_ struct{} `type:"structure"`

	// The ProvisioningArtifactParameter.TagKey parameter from DescribeProvisioningParameters.
	Key *string `min:"1" type:"string"`

	// The esired value for this key.
	Value *string `min:"1" type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type TerminateProvisionedProductInput struct {
	_ struct{} `type:"structure"`

	// The language code to use for this operation. Supported language codes are
	// as follows:
	//
	// "en" (English)
	//
	// "jp" (Japanese)
	//
	// "zh" (Chinese)
	//
	// If no code is specified, "en" is used as the default.
	AcceptLanguage *string `type:"string"`

	// If set to true, AWS Service Catalog stops managing the specified ProvisionedProduct
	// object even if it cannot delete the underlying resources.
	IgnoreErrors *bool `type:"boolean"`

	// The identifier of the ProvisionedProduct object to terminate. You must specify
	// either ProvisionedProductName or ProvisionedProductId, but not both.
	ProvisionedProductId *string `min:"1" type:"string"`

	// The name of the ProvisionedProduct object to terminate. You must specify
	// either ProvisionedProductName or ProvisionedProductId, but not both.
	ProvisionedProductName *string `min:"1" type:"string"`

	// An idempotency token that uniquely identifies the termination request. This
	// token is only valid during the termination process. After the ProvisionedProduct
	// object is terminated, further requests to terminate the same ProvisionedProduct
	// object always return ResourceNotFound regardless of the value of TerminateToken.
	//
	// TerminateToken is a required field
	TerminateToken *string `min:"1" type:"string" required:"true" idempotencyToken:"true"`
}

// String returns the string representation
func (s TerminateProvisionedProductInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TerminateProvisionedProductInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TerminateProvisionedProductInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TerminateProvisionedProductInput"}
	if s.ProvisionedProductId != nil && len(*s.ProvisionedProductId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProvisionedProductId", 1))
	}
	if s.ProvisionedProductName != nil && len(*s.ProvisionedProductName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProvisionedProductName", 1))
	}
	if s.TerminateToken == nil {
		invalidParams.Add(request.NewErrParamRequired("TerminateToken"))
	}
	if s.TerminateToken != nil && len(*s.TerminateToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TerminateToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type TerminateProvisionedProductOutput struct {
	_ struct{} `type:"structure"`

	// The detailed result of the TerminateProvisionedProduct request, containing
	// the inputs made to that request, the current state of the request, a pointer
	// to the ProvisionedProduct object that the request is modifying, and a list
	// of any errors that the request encountered.
	RecordDetail *RecordDetail `type:"structure"`
}

// String returns the string representation
func (s TerminateProvisionedProductOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TerminateProvisionedProductOutput) GoString() string {
	return s.String()
}

type UpdateProvisionedProductInput struct {
	_ struct{} `type:"structure"`

	// The language code to use for this operation. Supported language codes are
	// as follows:
	//
	// "en" (English)
	//
	// "jp" (Japanese)
	//
	// "zh" (Chinese)
	//
	// If no code is specified, "en" is used as the default.
	AcceptLanguage *string `type:"string"`

	// The identifier of the path to use in the updated ProvisionedProduct object.
	// This value is optional if the product has a default path, and is required
	// if there is more than one path for the specified product.
	PathId *string `min:"1" type:"string"`

	// The identifier of the ProvisionedProduct object.
	ProductId *string `min:"1" type:"string"`

	// The identifier of the ProvisionedProduct object to update. You must specify
	// either ProvisionedProductName or ProvisionedProductId, but not both.
	ProvisionedProductId *string `min:"1" type:"string"`

	// The updated name of the ProvisionedProduct object . You must specify either
	// ProvisionedProductName or ProvisionedProductId, but not both.
	ProvisionedProductName *string `min:"1" type:"string"`

	// The provisioning artifact identifier for this product.
	ProvisioningArtifactId *string `min:"1" type:"string"`

	// A list of ProvisioningParameter objects used to update the ProvisionedProduct
	// object.
	ProvisioningParameters []*UpdateProvisioningParameter `type:"list"`

	// The idempotency token that uniquely identifies the provisioning update request.
	//
	// UpdateToken is a required field
	UpdateToken *string `min:"1" type:"string" required:"true" idempotencyToken:"true"`
}

// String returns the string representation
func (s UpdateProvisionedProductInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateProvisionedProductInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateProvisionedProductInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateProvisionedProductInput"}
	if s.PathId != nil && len(*s.PathId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PathId", 1))
	}
	if s.ProductId != nil && len(*s.ProductId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProductId", 1))
	}
	if s.ProvisionedProductId != nil && len(*s.ProvisionedProductId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProvisionedProductId", 1))
	}
	if s.ProvisionedProductName != nil && len(*s.ProvisionedProductName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProvisionedProductName", 1))
	}
	if s.ProvisioningArtifactId != nil && len(*s.ProvisioningArtifactId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProvisioningArtifactId", 1))
	}
	if s.UpdateToken == nil {
		invalidParams.Add(request.NewErrParamRequired("UpdateToken"))
	}
	if s.UpdateToken != nil && len(*s.UpdateToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UpdateToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type UpdateProvisionedProductOutput struct {
	_ struct{} `type:"structure"`

	// The detailed result of the UpdateProvisionedProduct request, containing the
	// inputs made to that request, the current state of the request, a pointer
	// to the ProvisionedProduct object that the request is modifying, and a list
	// of any errors that the request encountered.
	RecordDetail *RecordDetail `type:"structure"`
}

// String returns the string representation
func (s UpdateProvisionedProductOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateProvisionedProductOutput) GoString() string {
	return s.String()
}

// The parameter key/value pair used to update a ProvisionedProduct object.
// If UsePreviousValue is set to true, Value is ignored and the value for Key
// is kept as previously set (current value).
type UpdateProvisioningParameter struct {
	_ struct{} `type:"structure"`

	// The ProvisioningArtifactParameter.ParameterKey parameter from DescribeProvisioningParameters.
	Key *string `type:"string"`

	// If true, uses the currently set value for Key, ignoring UpdateProvisioningParameter.Value.
	UsePreviousValue *bool `type:"boolean"`

	// The value to use for updating the product provisioning. Any constraints on
	// this value can be found in the ProvisioningArtifactParameter parameter for
	// Key.
	Value *string `type:"string"`
}

// String returns the string representation
func (s UpdateProvisioningParameter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateProvisioningParameter) GoString() string {
	return s.String()
}

// Additional information provided by the administrator.
type UsageInstruction struct {
	_ struct{} `type:"structure"`

	// The usage instruction type for the value.
	Type *string `type:"string"`

	// The usage instruction value for this type.
	Value *string `type:"string"`
}

// String returns the string representation
func (s UsageInstruction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UsageInstruction) GoString() string {
	return s.String()
}

const (
	// AccessLevelFilterKeyAccount is a AccessLevelFilterKey enum value
	AccessLevelFilterKeyAccount = "Account"

	// AccessLevelFilterKeyRole is a AccessLevelFilterKey enum value
	AccessLevelFilterKeyRole = "Role"

	// AccessLevelFilterKeyUser is a AccessLevelFilterKey enum value
	AccessLevelFilterKeyUser = "User"
)

const (
	// ProductViewFilterByFullTextSearch is a ProductViewFilterBy enum value
	ProductViewFilterByFullTextSearch = "FullTextSearch"

	// ProductViewFilterByOwner is a ProductViewFilterBy enum value
	ProductViewFilterByOwner = "Owner"

	// ProductViewFilterByProductType is a ProductViewFilterBy enum value
	ProductViewFilterByProductType = "ProductType"
)

const (
	// ProductViewSortByTitle is a ProductViewSortBy enum value
	ProductViewSortByTitle = "Title"

	// ProductViewSortByVersionCount is a ProductViewSortBy enum value
	ProductViewSortByVersionCount = "VersionCount"

	// ProductViewSortByCreationDate is a ProductViewSortBy enum value
	ProductViewSortByCreationDate = "CreationDate"
)

const (
	// RecordStatusInProgress is a RecordStatus enum value
	RecordStatusInProgress = "IN_PROGRESS"

	// RecordStatusSucceeded is a RecordStatus enum value
	RecordStatusSucceeded = "SUCCEEDED"

	// RecordStatusError is a RecordStatus enum value
	RecordStatusError = "ERROR"
)

const (
	// SortOrderAscending is a SortOrder enum value
	SortOrderAscending = "ASCENDING"

	// SortOrderDescending is a SortOrder enum value
	SortOrderDescending = "DESCENDING"
)
