#!/bin/sh
# script for conversion of filetypes.conf into filetypes.h
# (called by Makefile before compilation)
# (2020-1-16 // HB9KNS)
cat <<EOH
/* $outp autogenerated on `date -u` by $0 */

#define FILETYPES \\
EOH
# slurp $inpt and get gopher type and list of extensions
while read gtype exts
do if ! test "$gtype" = "" -o "$gtype" = "#"
# process extensions, removing trailing SPC,
# prepending '"' and appending '","gophertype",' to each,
# and prepending TAB and appending ' \'
 then echo $exts | sed -e "s/\([^ ][^ ]*\) */\"\1\",\"$gtype\",/g;s/^/	/;s/\$/ \\\\/"
 fi
done
cat <<EOF
	NULL, NULL
EOF
