/*
 * This file is part of the GROMACS molecular simulation package.
 *
 * Copyright (c) 2012, by the GROMACS development team, led by
 * David van der Spoel, Berk Hess, Erik Lindahl, and including many
 * others, as listed in the AUTHORS file in the top-level source
 * directory and at http://www.gromacs.org.
 *
 * GROMACS is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 *
 * GROMACS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with GROMACS; if not, see
 * http://www.gnu.org/licenses, or write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * If you want to redistribute modifications to GROMACS, please
 * consider that scientific software is very special. Version
 * control is crucial - bugs must be traceable. We will be happy to
 * consider code for inclusion in the official distribution, but
 * derived work must not be called official GROMACS. Details are found
 * in the README & COPYING files - if they are missing, get the
 * official version at http://www.gromacs.org.
 *
 * To help us fund GROMACS development, we humbly ask that you cite
 * the research papers on the package. Check out http://www.gromacs.org.
 */
/*
 * Note: this file was generated by the GROMACS sparc64_hpc_ace_double kernel generator.
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <math.h>

#include "../nb_kernel.h"
#include "types/simple.h"
#include "vec.h"
#include "nrnb.h"

#include "kernelutil_sparc64_hpc_ace_double.h"

/*
 * Gromacs nonbonded kernel:   nb_kernel_ElecCSTab_VdwLJ_GeomW4W4_VF_sparc64_hpc_ace_double
 * Electrostatics interaction: CubicSplineTable
 * VdW interaction:            LennardJones
 * Geometry:                   Water4-Water4
 * Calculate force/pot:        PotentialAndForce
 */
void
nb_kernel_ElecCSTab_VdwLJ_GeomW4W4_VF_sparc64_hpc_ace_double
                    (t_nblist * gmx_restrict                nlist,
                     rvec * gmx_restrict                    xx,
                     rvec * gmx_restrict                    ff,
                     t_forcerec * gmx_restrict              fr,
                     t_mdatoms * gmx_restrict               mdatoms,
                     nb_kernel_data_t * gmx_restrict        kernel_data,
                     t_nrnb * gmx_restrict                  nrnb)
{
    /* Suffixes 0,1,2,3 refer to particle indices for waters in the inner or outer loop, or
     * just 0 for non-waters.
     * Suffixes A,B refer to j loop unrolling done with double precision SIMD, e.g. for the two different
     * jnr indices corresponding to data put in the four positions in the SIMD register.
     */
    int              i_shift_offset,i_coord_offset,outeriter,inneriter;
    int              j_index_start,j_index_end,jidx,nri,inr,ggid,iidx;
    int              jnrA,jnrB;
    int              j_coord_offsetA,j_coord_offsetB;
    int              *iinr,*jindex,*jjnr,*shiftidx,*gid;
    real             rcutoff_scalar;
    real             *shiftvec,*fshift,*x,*f;
    _fjsp_v2r8       tx,ty,tz,fscal,rcutoff,rcutoff2,jidxall;
    int              vdwioffset0;
    _fjsp_v2r8       ix0,iy0,iz0,fix0,fiy0,fiz0,iq0,isai0;
    int              vdwioffset1;
    _fjsp_v2r8       ix1,iy1,iz1,fix1,fiy1,fiz1,iq1,isai1;
    int              vdwioffset2;
    _fjsp_v2r8       ix2,iy2,iz2,fix2,fiy2,fiz2,iq2,isai2;
    int              vdwioffset3;
    _fjsp_v2r8       ix3,iy3,iz3,fix3,fiy3,fiz3,iq3,isai3;
    int              vdwjidx0A,vdwjidx0B;
    _fjsp_v2r8       jx0,jy0,jz0,fjx0,fjy0,fjz0,jq0,isaj0;
    int              vdwjidx1A,vdwjidx1B;
    _fjsp_v2r8       jx1,jy1,jz1,fjx1,fjy1,fjz1,jq1,isaj1;
    int              vdwjidx2A,vdwjidx2B;
    _fjsp_v2r8       jx2,jy2,jz2,fjx2,fjy2,fjz2,jq2,isaj2;
    int              vdwjidx3A,vdwjidx3B;
    _fjsp_v2r8       jx3,jy3,jz3,fjx3,fjy3,fjz3,jq3,isaj3;
    _fjsp_v2r8       dx00,dy00,dz00,rsq00,rinv00,rinvsq00,r00,qq00,c6_00,c12_00;
    _fjsp_v2r8       dx11,dy11,dz11,rsq11,rinv11,rinvsq11,r11,qq11,c6_11,c12_11;
    _fjsp_v2r8       dx12,dy12,dz12,rsq12,rinv12,rinvsq12,r12,qq12,c6_12,c12_12;
    _fjsp_v2r8       dx13,dy13,dz13,rsq13,rinv13,rinvsq13,r13,qq13,c6_13,c12_13;
    _fjsp_v2r8       dx21,dy21,dz21,rsq21,rinv21,rinvsq21,r21,qq21,c6_21,c12_21;
    _fjsp_v2r8       dx22,dy22,dz22,rsq22,rinv22,rinvsq22,r22,qq22,c6_22,c12_22;
    _fjsp_v2r8       dx23,dy23,dz23,rsq23,rinv23,rinvsq23,r23,qq23,c6_23,c12_23;
    _fjsp_v2r8       dx31,dy31,dz31,rsq31,rinv31,rinvsq31,r31,qq31,c6_31,c12_31;
    _fjsp_v2r8       dx32,dy32,dz32,rsq32,rinv32,rinvsq32,r32,qq32,c6_32,c12_32;
    _fjsp_v2r8       dx33,dy33,dz33,rsq33,rinv33,rinvsq33,r33,qq33,c6_33,c12_33;
    _fjsp_v2r8       velec,felec,velecsum,facel,crf,krf,krf2;
    real             *charge;
    int              nvdwtype;
    _fjsp_v2r8       rinvsix,rvdw,vvdw,vvdw6,vvdw12,fvdw,fvdw6,fvdw12,vvdwsum,sh_vdw_invrcut6;
    int              *vdwtype;
    real             *vdwparam;
    _fjsp_v2r8       one_sixth   = gmx_fjsp_set1_v2r8(1.0/6.0);
    _fjsp_v2r8       one_twelfth = gmx_fjsp_set1_v2r8(1.0/12.0);
    _fjsp_v2r8       rt,vfeps,vftabscale,Y,F,G,H,Heps,Fp,VV,FF,twovfeps;
    real             *vftab;
    _fjsp_v2r8       itab_tmp;
    _fjsp_v2r8       dummy_mask,cutoff_mask;
    _fjsp_v2r8       one     = gmx_fjsp_set1_v2r8(1.0);
    _fjsp_v2r8       two     = gmx_fjsp_set1_v2r8(2.0);
    union { _fjsp_v2r8 simd; long long int i[2]; } vfconv,gbconv,ewconv;

    x                = xx[0];
    f                = ff[0];

    nri              = nlist->nri;
    iinr             = nlist->iinr;
    jindex           = nlist->jindex;
    jjnr             = nlist->jjnr;
    shiftidx         = nlist->shift;
    gid              = nlist->gid;
    shiftvec         = fr->shift_vec[0];
    fshift           = fr->fshift[0];
    facel            = gmx_fjsp_set1_v2r8(fr->epsfac);
    charge           = mdatoms->chargeA;
    nvdwtype         = fr->ntype;
    vdwparam         = fr->nbfp;
    vdwtype          = mdatoms->typeA;

    vftab            = kernel_data->table_elec->data;
    vftabscale       = gmx_fjsp_set1_v2r8(kernel_data->table_elec->scale);

    /* Setup water-specific parameters */
    inr              = nlist->iinr[0];
    iq1              = _fjsp_mul_v2r8(facel,gmx_fjsp_set1_v2r8(charge[inr+1]));
    iq2              = _fjsp_mul_v2r8(facel,gmx_fjsp_set1_v2r8(charge[inr+2]));
    iq3              = _fjsp_mul_v2r8(facel,gmx_fjsp_set1_v2r8(charge[inr+3]));
    vdwioffset0      = 2*nvdwtype*vdwtype[inr+0];

    jq1              = gmx_fjsp_set1_v2r8(charge[inr+1]);
    jq2              = gmx_fjsp_set1_v2r8(charge[inr+2]);
    jq3              = gmx_fjsp_set1_v2r8(charge[inr+3]);
    vdwjidx0A        = 2*vdwtype[inr+0];
    c6_00            = gmx_fjsp_set1_v2r8(vdwparam[vdwioffset0+vdwjidx0A]);
    c12_00           = gmx_fjsp_set1_v2r8(vdwparam[vdwioffset0+vdwjidx0A+1]);
    qq11             = _fjsp_mul_v2r8(iq1,jq1);
    qq12             = _fjsp_mul_v2r8(iq1,jq2);
    qq13             = _fjsp_mul_v2r8(iq1,jq3);
    qq21             = _fjsp_mul_v2r8(iq2,jq1);
    qq22             = _fjsp_mul_v2r8(iq2,jq2);
    qq23             = _fjsp_mul_v2r8(iq2,jq3);
    qq31             = _fjsp_mul_v2r8(iq3,jq1);
    qq32             = _fjsp_mul_v2r8(iq3,jq2);
    qq33             = _fjsp_mul_v2r8(iq3,jq3);

    /* Avoid stupid compiler warnings */
    jnrA = jnrB = 0;
    j_coord_offsetA = 0;
    j_coord_offsetB = 0;

    outeriter        = 0;
    inneriter        = 0;

    /* Start outer loop over neighborlists */
    for(iidx=0; iidx<nri; iidx++)
    {
        /* Load shift vector for this list */
        i_shift_offset   = DIM*shiftidx[iidx];

        /* Load limits for loop over neighbors */
        j_index_start    = jindex[iidx];
        j_index_end      = jindex[iidx+1];

        /* Get outer coordinate index */
        inr              = iinr[iidx];
        i_coord_offset   = DIM*inr;

        /* Load i particle coords and add shift vector */
        gmx_fjsp_load_shift_and_4rvec_broadcast_v2r8(shiftvec+i_shift_offset,x+i_coord_offset,
                                                 &ix0,&iy0,&iz0,&ix1,&iy1,&iz1,&ix2,&iy2,&iz2,&ix3,&iy3,&iz3);

        fix0             = _fjsp_setzero_v2r8();
        fiy0             = _fjsp_setzero_v2r8();
        fiz0             = _fjsp_setzero_v2r8();
        fix1             = _fjsp_setzero_v2r8();
        fiy1             = _fjsp_setzero_v2r8();
        fiz1             = _fjsp_setzero_v2r8();
        fix2             = _fjsp_setzero_v2r8();
        fiy2             = _fjsp_setzero_v2r8();
        fiz2             = _fjsp_setzero_v2r8();
        fix3             = _fjsp_setzero_v2r8();
        fiy3             = _fjsp_setzero_v2r8();
        fiz3             = _fjsp_setzero_v2r8();

        /* Reset potential sums */
        velecsum         = _fjsp_setzero_v2r8();
        vvdwsum          = _fjsp_setzero_v2r8();

        /* Start inner kernel loop */
        for(jidx=j_index_start; jidx<j_index_end-1; jidx+=2)
        {

            /* Get j neighbor index, and coordinate index */
            jnrA             = jjnr[jidx];
            jnrB             = jjnr[jidx+1];
            j_coord_offsetA  = DIM*jnrA;
            j_coord_offsetB  = DIM*jnrB;

            /* load j atom coordinates */
            gmx_fjsp_load_4rvec_2ptr_swizzle_v2r8(x+j_coord_offsetA,x+j_coord_offsetB,
                                              &jx0,&jy0,&jz0,&jx1,&jy1,&jz1,&jx2,
                                              &jy2,&jz2,&jx3,&jy3,&jz3);

            /* Calculate displacement vector */
            dx00             = _fjsp_sub_v2r8(ix0,jx0);
            dy00             = _fjsp_sub_v2r8(iy0,jy0);
            dz00             = _fjsp_sub_v2r8(iz0,jz0);
            dx11             = _fjsp_sub_v2r8(ix1,jx1);
            dy11             = _fjsp_sub_v2r8(iy1,jy1);
            dz11             = _fjsp_sub_v2r8(iz1,jz1);
            dx12             = _fjsp_sub_v2r8(ix1,jx2);
            dy12             = _fjsp_sub_v2r8(iy1,jy2);
            dz12             = _fjsp_sub_v2r8(iz1,jz2);
            dx13             = _fjsp_sub_v2r8(ix1,jx3);
            dy13             = _fjsp_sub_v2r8(iy1,jy3);
            dz13             = _fjsp_sub_v2r8(iz1,jz3);
            dx21             = _fjsp_sub_v2r8(ix2,jx1);
            dy21             = _fjsp_sub_v2r8(iy2,jy1);
            dz21             = _fjsp_sub_v2r8(iz2,jz1);
            dx22             = _fjsp_sub_v2r8(ix2,jx2);
            dy22             = _fjsp_sub_v2r8(iy2,jy2);
            dz22             = _fjsp_sub_v2r8(iz2,jz2);
            dx23             = _fjsp_sub_v2r8(ix2,jx3);
            dy23             = _fjsp_sub_v2r8(iy2,jy3);
            dz23             = _fjsp_sub_v2r8(iz2,jz3);
            dx31             = _fjsp_sub_v2r8(ix3,jx1);
            dy31             = _fjsp_sub_v2r8(iy3,jy1);
            dz31             = _fjsp_sub_v2r8(iz3,jz1);
            dx32             = _fjsp_sub_v2r8(ix3,jx2);
            dy32             = _fjsp_sub_v2r8(iy3,jy2);
            dz32             = _fjsp_sub_v2r8(iz3,jz2);
            dx33             = _fjsp_sub_v2r8(ix3,jx3);
            dy33             = _fjsp_sub_v2r8(iy3,jy3);
            dz33             = _fjsp_sub_v2r8(iz3,jz3);

            /* Calculate squared distance and things based on it */
            rsq00            = gmx_fjsp_calc_rsq_v2r8(dx00,dy00,dz00);
            rsq11            = gmx_fjsp_calc_rsq_v2r8(dx11,dy11,dz11);
            rsq12            = gmx_fjsp_calc_rsq_v2r8(dx12,dy12,dz12);
            rsq13            = gmx_fjsp_calc_rsq_v2r8(dx13,dy13,dz13);
            rsq21            = gmx_fjsp_calc_rsq_v2r8(dx21,dy21,dz21);
            rsq22            = gmx_fjsp_calc_rsq_v2r8(dx22,dy22,dz22);
            rsq23            = gmx_fjsp_calc_rsq_v2r8(dx23,dy23,dz23);
            rsq31            = gmx_fjsp_calc_rsq_v2r8(dx31,dy31,dz31);
            rsq32            = gmx_fjsp_calc_rsq_v2r8(dx32,dy32,dz32);
            rsq33            = gmx_fjsp_calc_rsq_v2r8(dx33,dy33,dz33);

            rinv11           = gmx_fjsp_invsqrt_v2r8(rsq11);
            rinv12           = gmx_fjsp_invsqrt_v2r8(rsq12);
            rinv13           = gmx_fjsp_invsqrt_v2r8(rsq13);
            rinv21           = gmx_fjsp_invsqrt_v2r8(rsq21);
            rinv22           = gmx_fjsp_invsqrt_v2r8(rsq22);
            rinv23           = gmx_fjsp_invsqrt_v2r8(rsq23);
            rinv31           = gmx_fjsp_invsqrt_v2r8(rsq31);
            rinv32           = gmx_fjsp_invsqrt_v2r8(rsq32);
            rinv33           = gmx_fjsp_invsqrt_v2r8(rsq33);

            rinvsq00         = gmx_fjsp_inv_v2r8(rsq00);

            fjx0             = _fjsp_setzero_v2r8();
            fjy0             = _fjsp_setzero_v2r8();
            fjz0             = _fjsp_setzero_v2r8();
            fjx1             = _fjsp_setzero_v2r8();
            fjy1             = _fjsp_setzero_v2r8();
            fjz1             = _fjsp_setzero_v2r8();
            fjx2             = _fjsp_setzero_v2r8();
            fjy2             = _fjsp_setzero_v2r8();
            fjz2             = _fjsp_setzero_v2r8();
            fjx3             = _fjsp_setzero_v2r8();
            fjy3             = _fjsp_setzero_v2r8();
            fjz3             = _fjsp_setzero_v2r8();

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            /* LENNARD-JONES DISPERSION/REPULSION */

            rinvsix          = _fjsp_mul_v2r8(_fjsp_mul_v2r8(rinvsq00,rinvsq00),rinvsq00);
            vvdw6            = _fjsp_mul_v2r8(c6_00,rinvsix);
            vvdw12           = _fjsp_mul_v2r8(c12_00,_fjsp_mul_v2r8(rinvsix,rinvsix));
            vvdw             = _fjsp_msub_v2r8( vvdw12,one_twelfth, _fjsp_mul_v2r8(vvdw6,one_sixth) );
            fvdw             = _fjsp_mul_v2r8(_fjsp_sub_v2r8(vvdw12,vvdw6),rinvsq00);

            /* Update potential sum for this i atom from the interaction with this j atom. */
            vvdwsum          = _fjsp_add_v2r8(vvdwsum,vvdw);

            fscal            = fvdw;

            /* Update vectorial force */
            fix0             = _fjsp_madd_v2r8(dx00,fscal,fix0);
            fiy0             = _fjsp_madd_v2r8(dy00,fscal,fiy0);
            fiz0             = _fjsp_madd_v2r8(dz00,fscal,fiz0);
            
            fjx0             = _fjsp_madd_v2r8(dx00,fscal,fjx0);
            fjy0             = _fjsp_madd_v2r8(dy00,fscal,fjy0);
            fjz0             = _fjsp_madd_v2r8(dz00,fscal,fjz0);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r11              = _fjsp_mul_v2r8(rsq11,rinv11);

            /* Calculate table index by multiplying r with table scale and truncate to integer */
            rt               = _fjsp_mul_v2r8(r11,vftabscale);
            itab_tmp         = _fjsp_dtox_v2r8(rt);
            vfeps            = _fjsp_sub_v2r8(rt, _fjsp_xtod_v2r8(itab_tmp));
            twovfeps         = _fjsp_add_v2r8(vfeps,vfeps);
            _fjsp_store_v2r8(&vfconv.simd,itab_tmp);

            vfconv.i[0]     *= 4;
            vfconv.i[1]     *= 4;

            /* CUBIC SPLINE TABLE ELECTROSTATICS */
            Y                = _fjsp_load_v2r8( vftab + vfconv.i[0] );
            F                = _fjsp_load_v2r8( vftab + vfconv.i[1] );
            GMX_FJSP_TRANSPOSE2_V2R8(Y,F);
            G                = _fjsp_load_v2r8( vftab + vfconv.i[0] +2);
            H                = _fjsp_load_v2r8( vftab + vfconv.i[1] +2);
            GMX_FJSP_TRANSPOSE2_V2R8(G,H);
            Fp               = _fjsp_madd_v2r8(vfeps,_fjsp_madd_v2r8(vfeps,H,G),F);
            VV               = _fjsp_madd_v2r8(vfeps,Fp,Y);
            velec            = _fjsp_mul_v2r8(qq11,VV);
            FF               = _fjsp_madd_v2r8(_fjsp_madd_v2r8(twovfeps,H,G),vfeps,Fp);
            felec            = _fjsp_neg_v2r8(_fjsp_mul_v2r8(_fjsp_mul_v2r8(qq11,FF),_fjsp_mul_v2r8(vftabscale,rinv11)));

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velecsum         = _fjsp_add_v2r8(velecsum,velec);

            fscal            = felec;

            /* Update vectorial force */
            fix1             = _fjsp_madd_v2r8(dx11,fscal,fix1);
            fiy1             = _fjsp_madd_v2r8(dy11,fscal,fiy1);
            fiz1             = _fjsp_madd_v2r8(dz11,fscal,fiz1);
            
            fjx1             = _fjsp_madd_v2r8(dx11,fscal,fjx1);
            fjy1             = _fjsp_madd_v2r8(dy11,fscal,fjy1);
            fjz1             = _fjsp_madd_v2r8(dz11,fscal,fjz1);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r12              = _fjsp_mul_v2r8(rsq12,rinv12);

            /* Calculate table index by multiplying r with table scale and truncate to integer */
            rt               = _fjsp_mul_v2r8(r12,vftabscale);
            itab_tmp         = _fjsp_dtox_v2r8(rt);
            vfeps            = _fjsp_sub_v2r8(rt, _fjsp_xtod_v2r8(itab_tmp));
            twovfeps         = _fjsp_add_v2r8(vfeps,vfeps);
            _fjsp_store_v2r8(&vfconv.simd,itab_tmp);

            vfconv.i[0]     *= 4;
            vfconv.i[1]     *= 4;

            /* CUBIC SPLINE TABLE ELECTROSTATICS */
            Y                = _fjsp_load_v2r8( vftab + vfconv.i[0] );
            F                = _fjsp_load_v2r8( vftab + vfconv.i[1] );
            GMX_FJSP_TRANSPOSE2_V2R8(Y,F);
            G                = _fjsp_load_v2r8( vftab + vfconv.i[0] +2);
            H                = _fjsp_load_v2r8( vftab + vfconv.i[1] +2);
            GMX_FJSP_TRANSPOSE2_V2R8(G,H);
            Fp               = _fjsp_madd_v2r8(vfeps,_fjsp_madd_v2r8(vfeps,H,G),F);
            VV               = _fjsp_madd_v2r8(vfeps,Fp,Y);
            velec            = _fjsp_mul_v2r8(qq12,VV);
            FF               = _fjsp_madd_v2r8(_fjsp_madd_v2r8(twovfeps,H,G),vfeps,Fp);
            felec            = _fjsp_neg_v2r8(_fjsp_mul_v2r8(_fjsp_mul_v2r8(qq12,FF),_fjsp_mul_v2r8(vftabscale,rinv12)));

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velecsum         = _fjsp_add_v2r8(velecsum,velec);

            fscal            = felec;

            /* Update vectorial force */
            fix1             = _fjsp_madd_v2r8(dx12,fscal,fix1);
            fiy1             = _fjsp_madd_v2r8(dy12,fscal,fiy1);
            fiz1             = _fjsp_madd_v2r8(dz12,fscal,fiz1);
            
            fjx2             = _fjsp_madd_v2r8(dx12,fscal,fjx2);
            fjy2             = _fjsp_madd_v2r8(dy12,fscal,fjy2);
            fjz2             = _fjsp_madd_v2r8(dz12,fscal,fjz2);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r13              = _fjsp_mul_v2r8(rsq13,rinv13);

            /* Calculate table index by multiplying r with table scale and truncate to integer */
            rt               = _fjsp_mul_v2r8(r13,vftabscale);
            itab_tmp         = _fjsp_dtox_v2r8(rt);
            vfeps            = _fjsp_sub_v2r8(rt, _fjsp_xtod_v2r8(itab_tmp));
            twovfeps         = _fjsp_add_v2r8(vfeps,vfeps);
            _fjsp_store_v2r8(&vfconv.simd,itab_tmp);

            vfconv.i[0]     *= 4;
            vfconv.i[1]     *= 4;

            /* CUBIC SPLINE TABLE ELECTROSTATICS */
            Y                = _fjsp_load_v2r8( vftab + vfconv.i[0] );
            F                = _fjsp_load_v2r8( vftab + vfconv.i[1] );
            GMX_FJSP_TRANSPOSE2_V2R8(Y,F);
            G                = _fjsp_load_v2r8( vftab + vfconv.i[0] +2);
            H                = _fjsp_load_v2r8( vftab + vfconv.i[1] +2);
            GMX_FJSP_TRANSPOSE2_V2R8(G,H);
            Fp               = _fjsp_madd_v2r8(vfeps,_fjsp_madd_v2r8(vfeps,H,G),F);
            VV               = _fjsp_madd_v2r8(vfeps,Fp,Y);
            velec            = _fjsp_mul_v2r8(qq13,VV);
            FF               = _fjsp_madd_v2r8(_fjsp_madd_v2r8(twovfeps,H,G),vfeps,Fp);
            felec            = _fjsp_neg_v2r8(_fjsp_mul_v2r8(_fjsp_mul_v2r8(qq13,FF),_fjsp_mul_v2r8(vftabscale,rinv13)));

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velecsum         = _fjsp_add_v2r8(velecsum,velec);

            fscal            = felec;

            /* Update vectorial force */
            fix1             = _fjsp_madd_v2r8(dx13,fscal,fix1);
            fiy1             = _fjsp_madd_v2r8(dy13,fscal,fiy1);
            fiz1             = _fjsp_madd_v2r8(dz13,fscal,fiz1);
            
            fjx3             = _fjsp_madd_v2r8(dx13,fscal,fjx3);
            fjy3             = _fjsp_madd_v2r8(dy13,fscal,fjy3);
            fjz3             = _fjsp_madd_v2r8(dz13,fscal,fjz3);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r21              = _fjsp_mul_v2r8(rsq21,rinv21);

            /* Calculate table index by multiplying r with table scale and truncate to integer */
            rt               = _fjsp_mul_v2r8(r21,vftabscale);
            itab_tmp         = _fjsp_dtox_v2r8(rt);
            vfeps            = _fjsp_sub_v2r8(rt, _fjsp_xtod_v2r8(itab_tmp));
            twovfeps         = _fjsp_add_v2r8(vfeps,vfeps);
            _fjsp_store_v2r8(&vfconv.simd,itab_tmp);

            vfconv.i[0]     *= 4;
            vfconv.i[1]     *= 4;

            /* CUBIC SPLINE TABLE ELECTROSTATICS */
            Y                = _fjsp_load_v2r8( vftab + vfconv.i[0] );
            F                = _fjsp_load_v2r8( vftab + vfconv.i[1] );
            GMX_FJSP_TRANSPOSE2_V2R8(Y,F);
            G                = _fjsp_load_v2r8( vftab + vfconv.i[0] +2);
            H                = _fjsp_load_v2r8( vftab + vfconv.i[1] +2);
            GMX_FJSP_TRANSPOSE2_V2R8(G,H);
            Fp               = _fjsp_madd_v2r8(vfeps,_fjsp_madd_v2r8(vfeps,H,G),F);
            VV               = _fjsp_madd_v2r8(vfeps,Fp,Y);
            velec            = _fjsp_mul_v2r8(qq21,VV);
            FF               = _fjsp_madd_v2r8(_fjsp_madd_v2r8(twovfeps,H,G),vfeps,Fp);
            felec            = _fjsp_neg_v2r8(_fjsp_mul_v2r8(_fjsp_mul_v2r8(qq21,FF),_fjsp_mul_v2r8(vftabscale,rinv21)));

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velecsum         = _fjsp_add_v2r8(velecsum,velec);

            fscal            = felec;

            /* Update vectorial force */
            fix2             = _fjsp_madd_v2r8(dx21,fscal,fix2);
            fiy2             = _fjsp_madd_v2r8(dy21,fscal,fiy2);
            fiz2             = _fjsp_madd_v2r8(dz21,fscal,fiz2);
            
            fjx1             = _fjsp_madd_v2r8(dx21,fscal,fjx1);
            fjy1             = _fjsp_madd_v2r8(dy21,fscal,fjy1);
            fjz1             = _fjsp_madd_v2r8(dz21,fscal,fjz1);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r22              = _fjsp_mul_v2r8(rsq22,rinv22);

            /* Calculate table index by multiplying r with table scale and truncate to integer */
            rt               = _fjsp_mul_v2r8(r22,vftabscale);
            itab_tmp         = _fjsp_dtox_v2r8(rt);
            vfeps            = _fjsp_sub_v2r8(rt, _fjsp_xtod_v2r8(itab_tmp));
            twovfeps         = _fjsp_add_v2r8(vfeps,vfeps);
            _fjsp_store_v2r8(&vfconv.simd,itab_tmp);

            vfconv.i[0]     *= 4;
            vfconv.i[1]     *= 4;

            /* CUBIC SPLINE TABLE ELECTROSTATICS */
            Y                = _fjsp_load_v2r8( vftab + vfconv.i[0] );
            F                = _fjsp_load_v2r8( vftab + vfconv.i[1] );
            GMX_FJSP_TRANSPOSE2_V2R8(Y,F);
            G                = _fjsp_load_v2r8( vftab + vfconv.i[0] +2);
            H                = _fjsp_load_v2r8( vftab + vfconv.i[1] +2);
            GMX_FJSP_TRANSPOSE2_V2R8(G,H);
            Fp               = _fjsp_madd_v2r8(vfeps,_fjsp_madd_v2r8(vfeps,H,G),F);
            VV               = _fjsp_madd_v2r8(vfeps,Fp,Y);
            velec            = _fjsp_mul_v2r8(qq22,VV);
            FF               = _fjsp_madd_v2r8(_fjsp_madd_v2r8(twovfeps,H,G),vfeps,Fp);
            felec            = _fjsp_neg_v2r8(_fjsp_mul_v2r8(_fjsp_mul_v2r8(qq22,FF),_fjsp_mul_v2r8(vftabscale,rinv22)));

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velecsum         = _fjsp_add_v2r8(velecsum,velec);

            fscal            = felec;

            /* Update vectorial force */
            fix2             = _fjsp_madd_v2r8(dx22,fscal,fix2);
            fiy2             = _fjsp_madd_v2r8(dy22,fscal,fiy2);
            fiz2             = _fjsp_madd_v2r8(dz22,fscal,fiz2);
            
            fjx2             = _fjsp_madd_v2r8(dx22,fscal,fjx2);
            fjy2             = _fjsp_madd_v2r8(dy22,fscal,fjy2);
            fjz2             = _fjsp_madd_v2r8(dz22,fscal,fjz2);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r23              = _fjsp_mul_v2r8(rsq23,rinv23);

            /* Calculate table index by multiplying r with table scale and truncate to integer */
            rt               = _fjsp_mul_v2r8(r23,vftabscale);
            itab_tmp         = _fjsp_dtox_v2r8(rt);
            vfeps            = _fjsp_sub_v2r8(rt, _fjsp_xtod_v2r8(itab_tmp));
            twovfeps         = _fjsp_add_v2r8(vfeps,vfeps);
            _fjsp_store_v2r8(&vfconv.simd,itab_tmp);

            vfconv.i[0]     *= 4;
            vfconv.i[1]     *= 4;

            /* CUBIC SPLINE TABLE ELECTROSTATICS */
            Y                = _fjsp_load_v2r8( vftab + vfconv.i[0] );
            F                = _fjsp_load_v2r8( vftab + vfconv.i[1] );
            GMX_FJSP_TRANSPOSE2_V2R8(Y,F);
            G                = _fjsp_load_v2r8( vftab + vfconv.i[0] +2);
            H                = _fjsp_load_v2r8( vftab + vfconv.i[1] +2);
            GMX_FJSP_TRANSPOSE2_V2R8(G,H);
            Fp               = _fjsp_madd_v2r8(vfeps,_fjsp_madd_v2r8(vfeps,H,G),F);
            VV               = _fjsp_madd_v2r8(vfeps,Fp,Y);
            velec            = _fjsp_mul_v2r8(qq23,VV);
            FF               = _fjsp_madd_v2r8(_fjsp_madd_v2r8(twovfeps,H,G),vfeps,Fp);
            felec            = _fjsp_neg_v2r8(_fjsp_mul_v2r8(_fjsp_mul_v2r8(qq23,FF),_fjsp_mul_v2r8(vftabscale,rinv23)));

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velecsum         = _fjsp_add_v2r8(velecsum,velec);

            fscal            = felec;

            /* Update vectorial force */
            fix2             = _fjsp_madd_v2r8(dx23,fscal,fix2);
            fiy2             = _fjsp_madd_v2r8(dy23,fscal,fiy2);
            fiz2             = _fjsp_madd_v2r8(dz23,fscal,fiz2);
            
            fjx3             = _fjsp_madd_v2r8(dx23,fscal,fjx3);
            fjy3             = _fjsp_madd_v2r8(dy23,fscal,fjy3);
            fjz3             = _fjsp_madd_v2r8(dz23,fscal,fjz3);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r31              = _fjsp_mul_v2r8(rsq31,rinv31);

            /* Calculate table index by multiplying r with table scale and truncate to integer */
            rt               = _fjsp_mul_v2r8(r31,vftabscale);
            itab_tmp         = _fjsp_dtox_v2r8(rt);
            vfeps            = _fjsp_sub_v2r8(rt, _fjsp_xtod_v2r8(itab_tmp));
            twovfeps         = _fjsp_add_v2r8(vfeps,vfeps);
            _fjsp_store_v2r8(&vfconv.simd,itab_tmp);

            vfconv.i[0]     *= 4;
            vfconv.i[1]     *= 4;

            /* CUBIC SPLINE TABLE ELECTROSTATICS */
            Y                = _fjsp_load_v2r8( vftab + vfconv.i[0] );
            F                = _fjsp_load_v2r8( vftab + vfconv.i[1] );
            GMX_FJSP_TRANSPOSE2_V2R8(Y,F);
            G                = _fjsp_load_v2r8( vftab + vfconv.i[0] +2);
            H                = _fjsp_load_v2r8( vftab + vfconv.i[1] +2);
            GMX_FJSP_TRANSPOSE2_V2R8(G,H);
            Fp               = _fjsp_madd_v2r8(vfeps,_fjsp_madd_v2r8(vfeps,H,G),F);
            VV               = _fjsp_madd_v2r8(vfeps,Fp,Y);
            velec            = _fjsp_mul_v2r8(qq31,VV);
            FF               = _fjsp_madd_v2r8(_fjsp_madd_v2r8(twovfeps,H,G),vfeps,Fp);
            felec            = _fjsp_neg_v2r8(_fjsp_mul_v2r8(_fjsp_mul_v2r8(qq31,FF),_fjsp_mul_v2r8(vftabscale,rinv31)));

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velecsum         = _fjsp_add_v2r8(velecsum,velec);

            fscal            = felec;

            /* Update vectorial force */
            fix3             = _fjsp_madd_v2r8(dx31,fscal,fix3);
            fiy3             = _fjsp_madd_v2r8(dy31,fscal,fiy3);
            fiz3             = _fjsp_madd_v2r8(dz31,fscal,fiz3);
            
            fjx1             = _fjsp_madd_v2r8(dx31,fscal,fjx1);
            fjy1             = _fjsp_madd_v2r8(dy31,fscal,fjy1);
            fjz1             = _fjsp_madd_v2r8(dz31,fscal,fjz1);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r32              = _fjsp_mul_v2r8(rsq32,rinv32);

            /* Calculate table index by multiplying r with table scale and truncate to integer */
            rt               = _fjsp_mul_v2r8(r32,vftabscale);
            itab_tmp         = _fjsp_dtox_v2r8(rt);
            vfeps            = _fjsp_sub_v2r8(rt, _fjsp_xtod_v2r8(itab_tmp));
            twovfeps         = _fjsp_add_v2r8(vfeps,vfeps);
            _fjsp_store_v2r8(&vfconv.simd,itab_tmp);

            vfconv.i[0]     *= 4;
            vfconv.i[1]     *= 4;

            /* CUBIC SPLINE TABLE ELECTROSTATICS */
            Y                = _fjsp_load_v2r8( vftab + vfconv.i[0] );
            F                = _fjsp_load_v2r8( vftab + vfconv.i[1] );
            GMX_FJSP_TRANSPOSE2_V2R8(Y,F);
            G                = _fjsp_load_v2r8( vftab + vfconv.i[0] +2);
            H                = _fjsp_load_v2r8( vftab + vfconv.i[1] +2);
            GMX_FJSP_TRANSPOSE2_V2R8(G,H);
            Fp               = _fjsp_madd_v2r8(vfeps,_fjsp_madd_v2r8(vfeps,H,G),F);
            VV               = _fjsp_madd_v2r8(vfeps,Fp,Y);
            velec            = _fjsp_mul_v2r8(qq32,VV);
            FF               = _fjsp_madd_v2r8(_fjsp_madd_v2r8(twovfeps,H,G),vfeps,Fp);
            felec            = _fjsp_neg_v2r8(_fjsp_mul_v2r8(_fjsp_mul_v2r8(qq32,FF),_fjsp_mul_v2r8(vftabscale,rinv32)));

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velecsum         = _fjsp_add_v2r8(velecsum,velec);

            fscal            = felec;

            /* Update vectorial force */
            fix3             = _fjsp_madd_v2r8(dx32,fscal,fix3);
            fiy3             = _fjsp_madd_v2r8(dy32,fscal,fiy3);
            fiz3             = _fjsp_madd_v2r8(dz32,fscal,fiz3);
            
            fjx2             = _fjsp_madd_v2r8(dx32,fscal,fjx2);
            fjy2             = _fjsp_madd_v2r8(dy32,fscal,fjy2);
            fjz2             = _fjsp_madd_v2r8(dz32,fscal,fjz2);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r33              = _fjsp_mul_v2r8(rsq33,rinv33);

            /* Calculate table index by multiplying r with table scale and truncate to integer */
            rt               = _fjsp_mul_v2r8(r33,vftabscale);
            itab_tmp         = _fjsp_dtox_v2r8(rt);
            vfeps            = _fjsp_sub_v2r8(rt, _fjsp_xtod_v2r8(itab_tmp));
            twovfeps         = _fjsp_add_v2r8(vfeps,vfeps);
            _fjsp_store_v2r8(&vfconv.simd,itab_tmp);

            vfconv.i[0]     *= 4;
            vfconv.i[1]     *= 4;

            /* CUBIC SPLINE TABLE ELECTROSTATICS */
            Y                = _fjsp_load_v2r8( vftab + vfconv.i[0] );
            F                = _fjsp_load_v2r8( vftab + vfconv.i[1] );
            GMX_FJSP_TRANSPOSE2_V2R8(Y,F);
            G                = _fjsp_load_v2r8( vftab + vfconv.i[0] +2);
            H                = _fjsp_load_v2r8( vftab + vfconv.i[1] +2);
            GMX_FJSP_TRANSPOSE2_V2R8(G,H);
            Fp               = _fjsp_madd_v2r8(vfeps,_fjsp_madd_v2r8(vfeps,H,G),F);
            VV               = _fjsp_madd_v2r8(vfeps,Fp,Y);
            velec            = _fjsp_mul_v2r8(qq33,VV);
            FF               = _fjsp_madd_v2r8(_fjsp_madd_v2r8(twovfeps,H,G),vfeps,Fp);
            felec            = _fjsp_neg_v2r8(_fjsp_mul_v2r8(_fjsp_mul_v2r8(qq33,FF),_fjsp_mul_v2r8(vftabscale,rinv33)));

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velecsum         = _fjsp_add_v2r8(velecsum,velec);

            fscal            = felec;

            /* Update vectorial force */
            fix3             = _fjsp_madd_v2r8(dx33,fscal,fix3);
            fiy3             = _fjsp_madd_v2r8(dy33,fscal,fiy3);
            fiz3             = _fjsp_madd_v2r8(dz33,fscal,fiz3);
            
            fjx3             = _fjsp_madd_v2r8(dx33,fscal,fjx3);
            fjy3             = _fjsp_madd_v2r8(dy33,fscal,fjy3);
            fjz3             = _fjsp_madd_v2r8(dz33,fscal,fjz3);

            gmx_fjsp_decrement_4rvec_2ptr_swizzle_v2r8(f+j_coord_offsetA,f+j_coord_offsetB,fjx0,fjy0,fjz0,fjx1,fjy1,fjz1,fjx2,fjy2,fjz2,fjx3,fjy3,fjz3);

            /* Inner loop uses 452 flops */
        }

        if(jidx<j_index_end)
        {

            jnrA             = jjnr[jidx];
            j_coord_offsetA  = DIM*jnrA;

            /* load j atom coordinates */
            gmx_fjsp_load_4rvec_1ptr_swizzle_v2r8(x+j_coord_offsetA,
                                              &jx0,&jy0,&jz0,&jx1,&jy1,&jz1,&jx2,
                                              &jy2,&jz2,&jx3,&jy3,&jz3);

            /* Calculate displacement vector */
            dx00             = _fjsp_sub_v2r8(ix0,jx0);
            dy00             = _fjsp_sub_v2r8(iy0,jy0);
            dz00             = _fjsp_sub_v2r8(iz0,jz0);
            dx11             = _fjsp_sub_v2r8(ix1,jx1);
            dy11             = _fjsp_sub_v2r8(iy1,jy1);
            dz11             = _fjsp_sub_v2r8(iz1,jz1);
            dx12             = _fjsp_sub_v2r8(ix1,jx2);
            dy12             = _fjsp_sub_v2r8(iy1,jy2);
            dz12             = _fjsp_sub_v2r8(iz1,jz2);
            dx13             = _fjsp_sub_v2r8(ix1,jx3);
            dy13             = _fjsp_sub_v2r8(iy1,jy3);
            dz13             = _fjsp_sub_v2r8(iz1,jz3);
            dx21             = _fjsp_sub_v2r8(ix2,jx1);
            dy21             = _fjsp_sub_v2r8(iy2,jy1);
            dz21             = _fjsp_sub_v2r8(iz2,jz1);
            dx22             = _fjsp_sub_v2r8(ix2,jx2);
            dy22             = _fjsp_sub_v2r8(iy2,jy2);
            dz22             = _fjsp_sub_v2r8(iz2,jz2);
            dx23             = _fjsp_sub_v2r8(ix2,jx3);
            dy23             = _fjsp_sub_v2r8(iy2,jy3);
            dz23             = _fjsp_sub_v2r8(iz2,jz3);
            dx31             = _fjsp_sub_v2r8(ix3,jx1);
            dy31             = _fjsp_sub_v2r8(iy3,jy1);
            dz31             = _fjsp_sub_v2r8(iz3,jz1);
            dx32             = _fjsp_sub_v2r8(ix3,jx2);
            dy32             = _fjsp_sub_v2r8(iy3,jy2);
            dz32             = _fjsp_sub_v2r8(iz3,jz2);
            dx33             = _fjsp_sub_v2r8(ix3,jx3);
            dy33             = _fjsp_sub_v2r8(iy3,jy3);
            dz33             = _fjsp_sub_v2r8(iz3,jz3);

            /* Calculate squared distance and things based on it */
            rsq00            = gmx_fjsp_calc_rsq_v2r8(dx00,dy00,dz00);
            rsq11            = gmx_fjsp_calc_rsq_v2r8(dx11,dy11,dz11);
            rsq12            = gmx_fjsp_calc_rsq_v2r8(dx12,dy12,dz12);
            rsq13            = gmx_fjsp_calc_rsq_v2r8(dx13,dy13,dz13);
            rsq21            = gmx_fjsp_calc_rsq_v2r8(dx21,dy21,dz21);
            rsq22            = gmx_fjsp_calc_rsq_v2r8(dx22,dy22,dz22);
            rsq23            = gmx_fjsp_calc_rsq_v2r8(dx23,dy23,dz23);
            rsq31            = gmx_fjsp_calc_rsq_v2r8(dx31,dy31,dz31);
            rsq32            = gmx_fjsp_calc_rsq_v2r8(dx32,dy32,dz32);
            rsq33            = gmx_fjsp_calc_rsq_v2r8(dx33,dy33,dz33);

            rinv11           = gmx_fjsp_invsqrt_v2r8(rsq11);
            rinv12           = gmx_fjsp_invsqrt_v2r8(rsq12);
            rinv13           = gmx_fjsp_invsqrt_v2r8(rsq13);
            rinv21           = gmx_fjsp_invsqrt_v2r8(rsq21);
            rinv22           = gmx_fjsp_invsqrt_v2r8(rsq22);
            rinv23           = gmx_fjsp_invsqrt_v2r8(rsq23);
            rinv31           = gmx_fjsp_invsqrt_v2r8(rsq31);
            rinv32           = gmx_fjsp_invsqrt_v2r8(rsq32);
            rinv33           = gmx_fjsp_invsqrt_v2r8(rsq33);

            rinvsq00         = gmx_fjsp_inv_v2r8(rsq00);

            fjx0             = _fjsp_setzero_v2r8();
            fjy0             = _fjsp_setzero_v2r8();
            fjz0             = _fjsp_setzero_v2r8();
            fjx1             = _fjsp_setzero_v2r8();
            fjy1             = _fjsp_setzero_v2r8();
            fjz1             = _fjsp_setzero_v2r8();
            fjx2             = _fjsp_setzero_v2r8();
            fjy2             = _fjsp_setzero_v2r8();
            fjz2             = _fjsp_setzero_v2r8();
            fjx3             = _fjsp_setzero_v2r8();
            fjy3             = _fjsp_setzero_v2r8();
            fjz3             = _fjsp_setzero_v2r8();

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            /* LENNARD-JONES DISPERSION/REPULSION */

            rinvsix          = _fjsp_mul_v2r8(_fjsp_mul_v2r8(rinvsq00,rinvsq00),rinvsq00);
            vvdw6            = _fjsp_mul_v2r8(c6_00,rinvsix);
            vvdw12           = _fjsp_mul_v2r8(c12_00,_fjsp_mul_v2r8(rinvsix,rinvsix));
            vvdw             = _fjsp_msub_v2r8( vvdw12,one_twelfth, _fjsp_mul_v2r8(vvdw6,one_sixth) );
            fvdw             = _fjsp_mul_v2r8(_fjsp_sub_v2r8(vvdw12,vvdw6),rinvsq00);

            /* Update potential sum for this i atom from the interaction with this j atom. */
            vvdw             = _fjsp_unpacklo_v2r8(vvdw,_fjsp_setzero_v2r8());
            vvdwsum          = _fjsp_add_v2r8(vvdwsum,vvdw);

            fscal            = fvdw;

            fscal            = _fjsp_unpacklo_v2r8(fscal,_fjsp_setzero_v2r8());

            /* Update vectorial force */
            fix0             = _fjsp_madd_v2r8(dx00,fscal,fix0);
            fiy0             = _fjsp_madd_v2r8(dy00,fscal,fiy0);
            fiz0             = _fjsp_madd_v2r8(dz00,fscal,fiz0);
            
            fjx0             = _fjsp_madd_v2r8(dx00,fscal,fjx0);
            fjy0             = _fjsp_madd_v2r8(dy00,fscal,fjy0);
            fjz0             = _fjsp_madd_v2r8(dz00,fscal,fjz0);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r11              = _fjsp_mul_v2r8(rsq11,rinv11);

            /* Calculate table index by multiplying r with table scale and truncate to integer */
            rt               = _fjsp_mul_v2r8(r11,vftabscale);
            itab_tmp         = _fjsp_dtox_v2r8(rt);
            vfeps            = _fjsp_sub_v2r8(rt, _fjsp_xtod_v2r8(itab_tmp));
            twovfeps         = _fjsp_add_v2r8(vfeps,vfeps);
            _fjsp_store_v2r8(&vfconv.simd,itab_tmp);

            vfconv.i[0]     *= 4;
            vfconv.i[1]     *= 4;

            /* CUBIC SPLINE TABLE ELECTROSTATICS */
            Y                = _fjsp_load_v2r8( vftab + vfconv.i[0] );
            F                = _fjsp_setzero_v2r8();
            GMX_FJSP_TRANSPOSE2_V2R8(Y,F);
            G                = _fjsp_load_v2r8( vftab + vfconv.i[0] +2);
            H                = _fjsp_setzero_v2r8();
            GMX_FJSP_TRANSPOSE2_V2R8(G,H);
            Fp               = _fjsp_madd_v2r8(vfeps,_fjsp_madd_v2r8(vfeps,H,G),F);
            VV               = _fjsp_madd_v2r8(vfeps,Fp,Y);
            velec            = _fjsp_mul_v2r8(qq11,VV);
            FF               = _fjsp_madd_v2r8(_fjsp_madd_v2r8(twovfeps,H,G),vfeps,Fp);
            felec            = _fjsp_neg_v2r8(_fjsp_mul_v2r8(_fjsp_mul_v2r8(qq11,FF),_fjsp_mul_v2r8(vftabscale,rinv11)));

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _fjsp_unpacklo_v2r8(velec,_fjsp_setzero_v2r8());
            velecsum         = _fjsp_add_v2r8(velecsum,velec);

            fscal            = felec;

            fscal            = _fjsp_unpacklo_v2r8(fscal,_fjsp_setzero_v2r8());

            /* Update vectorial force */
            fix1             = _fjsp_madd_v2r8(dx11,fscal,fix1);
            fiy1             = _fjsp_madd_v2r8(dy11,fscal,fiy1);
            fiz1             = _fjsp_madd_v2r8(dz11,fscal,fiz1);
            
            fjx1             = _fjsp_madd_v2r8(dx11,fscal,fjx1);
            fjy1             = _fjsp_madd_v2r8(dy11,fscal,fjy1);
            fjz1             = _fjsp_madd_v2r8(dz11,fscal,fjz1);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r12              = _fjsp_mul_v2r8(rsq12,rinv12);

            /* Calculate table index by multiplying r with table scale and truncate to integer */
            rt               = _fjsp_mul_v2r8(r12,vftabscale);
            itab_tmp         = _fjsp_dtox_v2r8(rt);
            vfeps            = _fjsp_sub_v2r8(rt, _fjsp_xtod_v2r8(itab_tmp));
            twovfeps         = _fjsp_add_v2r8(vfeps,vfeps);
            _fjsp_store_v2r8(&vfconv.simd,itab_tmp);

            vfconv.i[0]     *= 4;
            vfconv.i[1]     *= 4;

            /* CUBIC SPLINE TABLE ELECTROSTATICS */
            Y                = _fjsp_load_v2r8( vftab + vfconv.i[0] );
            F                = _fjsp_setzero_v2r8();
            GMX_FJSP_TRANSPOSE2_V2R8(Y,F);
            G                = _fjsp_load_v2r8( vftab + vfconv.i[0] +2);
            H                = _fjsp_setzero_v2r8();
            GMX_FJSP_TRANSPOSE2_V2R8(G,H);
            Fp               = _fjsp_madd_v2r8(vfeps,_fjsp_madd_v2r8(vfeps,H,G),F);
            VV               = _fjsp_madd_v2r8(vfeps,Fp,Y);
            velec            = _fjsp_mul_v2r8(qq12,VV);
            FF               = _fjsp_madd_v2r8(_fjsp_madd_v2r8(twovfeps,H,G),vfeps,Fp);
            felec            = _fjsp_neg_v2r8(_fjsp_mul_v2r8(_fjsp_mul_v2r8(qq12,FF),_fjsp_mul_v2r8(vftabscale,rinv12)));

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _fjsp_unpacklo_v2r8(velec,_fjsp_setzero_v2r8());
            velecsum         = _fjsp_add_v2r8(velecsum,velec);

            fscal            = felec;

            fscal            = _fjsp_unpacklo_v2r8(fscal,_fjsp_setzero_v2r8());

            /* Update vectorial force */
            fix1             = _fjsp_madd_v2r8(dx12,fscal,fix1);
            fiy1             = _fjsp_madd_v2r8(dy12,fscal,fiy1);
            fiz1             = _fjsp_madd_v2r8(dz12,fscal,fiz1);
            
            fjx2             = _fjsp_madd_v2r8(dx12,fscal,fjx2);
            fjy2             = _fjsp_madd_v2r8(dy12,fscal,fjy2);
            fjz2             = _fjsp_madd_v2r8(dz12,fscal,fjz2);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r13              = _fjsp_mul_v2r8(rsq13,rinv13);

            /* Calculate table index by multiplying r with table scale and truncate to integer */
            rt               = _fjsp_mul_v2r8(r13,vftabscale);
            itab_tmp         = _fjsp_dtox_v2r8(rt);
            vfeps            = _fjsp_sub_v2r8(rt, _fjsp_xtod_v2r8(itab_tmp));
            twovfeps         = _fjsp_add_v2r8(vfeps,vfeps);
            _fjsp_store_v2r8(&vfconv.simd,itab_tmp);

            vfconv.i[0]     *= 4;
            vfconv.i[1]     *= 4;

            /* CUBIC SPLINE TABLE ELECTROSTATICS */
            Y                = _fjsp_load_v2r8( vftab + vfconv.i[0] );
            F                = _fjsp_setzero_v2r8();
            GMX_FJSP_TRANSPOSE2_V2R8(Y,F);
            G                = _fjsp_load_v2r8( vftab + vfconv.i[0] +2);
            H                = _fjsp_setzero_v2r8();
            GMX_FJSP_TRANSPOSE2_V2R8(G,H);
            Fp               = _fjsp_madd_v2r8(vfeps,_fjsp_madd_v2r8(vfeps,H,G),F);
            VV               = _fjsp_madd_v2r8(vfeps,Fp,Y);
            velec            = _fjsp_mul_v2r8(qq13,VV);
            FF               = _fjsp_madd_v2r8(_fjsp_madd_v2r8(twovfeps,H,G),vfeps,Fp);
            felec            = _fjsp_neg_v2r8(_fjsp_mul_v2r8(_fjsp_mul_v2r8(qq13,FF),_fjsp_mul_v2r8(vftabscale,rinv13)));

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _fjsp_unpacklo_v2r8(velec,_fjsp_setzero_v2r8());
            velecsum         = _fjsp_add_v2r8(velecsum,velec);

            fscal            = felec;

            fscal            = _fjsp_unpacklo_v2r8(fscal,_fjsp_setzero_v2r8());

            /* Update vectorial force */
            fix1             = _fjsp_madd_v2r8(dx13,fscal,fix1);
            fiy1             = _fjsp_madd_v2r8(dy13,fscal,fiy1);
            fiz1             = _fjsp_madd_v2r8(dz13,fscal,fiz1);
            
            fjx3             = _fjsp_madd_v2r8(dx13,fscal,fjx3);
            fjy3             = _fjsp_madd_v2r8(dy13,fscal,fjy3);
            fjz3             = _fjsp_madd_v2r8(dz13,fscal,fjz3);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r21              = _fjsp_mul_v2r8(rsq21,rinv21);

            /* Calculate table index by multiplying r with table scale and truncate to integer */
            rt               = _fjsp_mul_v2r8(r21,vftabscale);
            itab_tmp         = _fjsp_dtox_v2r8(rt);
            vfeps            = _fjsp_sub_v2r8(rt, _fjsp_xtod_v2r8(itab_tmp));
            twovfeps         = _fjsp_add_v2r8(vfeps,vfeps);
            _fjsp_store_v2r8(&vfconv.simd,itab_tmp);

            vfconv.i[0]     *= 4;
            vfconv.i[1]     *= 4;

            /* CUBIC SPLINE TABLE ELECTROSTATICS */
            Y                = _fjsp_load_v2r8( vftab + vfconv.i[0] );
            F                = _fjsp_setzero_v2r8();
            GMX_FJSP_TRANSPOSE2_V2R8(Y,F);
            G                = _fjsp_load_v2r8( vftab + vfconv.i[0] +2);
            H                = _fjsp_setzero_v2r8();
            GMX_FJSP_TRANSPOSE2_V2R8(G,H);
            Fp               = _fjsp_madd_v2r8(vfeps,_fjsp_madd_v2r8(vfeps,H,G),F);
            VV               = _fjsp_madd_v2r8(vfeps,Fp,Y);
            velec            = _fjsp_mul_v2r8(qq21,VV);
            FF               = _fjsp_madd_v2r8(_fjsp_madd_v2r8(twovfeps,H,G),vfeps,Fp);
            felec            = _fjsp_neg_v2r8(_fjsp_mul_v2r8(_fjsp_mul_v2r8(qq21,FF),_fjsp_mul_v2r8(vftabscale,rinv21)));

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _fjsp_unpacklo_v2r8(velec,_fjsp_setzero_v2r8());
            velecsum         = _fjsp_add_v2r8(velecsum,velec);

            fscal            = felec;

            fscal            = _fjsp_unpacklo_v2r8(fscal,_fjsp_setzero_v2r8());

            /* Update vectorial force */
            fix2             = _fjsp_madd_v2r8(dx21,fscal,fix2);
            fiy2             = _fjsp_madd_v2r8(dy21,fscal,fiy2);
            fiz2             = _fjsp_madd_v2r8(dz21,fscal,fiz2);
            
            fjx1             = _fjsp_madd_v2r8(dx21,fscal,fjx1);
            fjy1             = _fjsp_madd_v2r8(dy21,fscal,fjy1);
            fjz1             = _fjsp_madd_v2r8(dz21,fscal,fjz1);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r22              = _fjsp_mul_v2r8(rsq22,rinv22);

            /* Calculate table index by multiplying r with table scale and truncate to integer */
            rt               = _fjsp_mul_v2r8(r22,vftabscale);
            itab_tmp         = _fjsp_dtox_v2r8(rt);
            vfeps            = _fjsp_sub_v2r8(rt, _fjsp_xtod_v2r8(itab_tmp));
            twovfeps         = _fjsp_add_v2r8(vfeps,vfeps);
            _fjsp_store_v2r8(&vfconv.simd,itab_tmp);

            vfconv.i[0]     *= 4;
            vfconv.i[1]     *= 4;

            /* CUBIC SPLINE TABLE ELECTROSTATICS */
            Y                = _fjsp_load_v2r8( vftab + vfconv.i[0] );
            F                = _fjsp_setzero_v2r8();
            GMX_FJSP_TRANSPOSE2_V2R8(Y,F);
            G                = _fjsp_load_v2r8( vftab + vfconv.i[0] +2);
            H                = _fjsp_setzero_v2r8();
            GMX_FJSP_TRANSPOSE2_V2R8(G,H);
            Fp               = _fjsp_madd_v2r8(vfeps,_fjsp_madd_v2r8(vfeps,H,G),F);
            VV               = _fjsp_madd_v2r8(vfeps,Fp,Y);
            velec            = _fjsp_mul_v2r8(qq22,VV);
            FF               = _fjsp_madd_v2r8(_fjsp_madd_v2r8(twovfeps,H,G),vfeps,Fp);
            felec            = _fjsp_neg_v2r8(_fjsp_mul_v2r8(_fjsp_mul_v2r8(qq22,FF),_fjsp_mul_v2r8(vftabscale,rinv22)));

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _fjsp_unpacklo_v2r8(velec,_fjsp_setzero_v2r8());
            velecsum         = _fjsp_add_v2r8(velecsum,velec);

            fscal            = felec;

            fscal            = _fjsp_unpacklo_v2r8(fscal,_fjsp_setzero_v2r8());

            /* Update vectorial force */
            fix2             = _fjsp_madd_v2r8(dx22,fscal,fix2);
            fiy2             = _fjsp_madd_v2r8(dy22,fscal,fiy2);
            fiz2             = _fjsp_madd_v2r8(dz22,fscal,fiz2);
            
            fjx2             = _fjsp_madd_v2r8(dx22,fscal,fjx2);
            fjy2             = _fjsp_madd_v2r8(dy22,fscal,fjy2);
            fjz2             = _fjsp_madd_v2r8(dz22,fscal,fjz2);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r23              = _fjsp_mul_v2r8(rsq23,rinv23);

            /* Calculate table index by multiplying r with table scale and truncate to integer */
            rt               = _fjsp_mul_v2r8(r23,vftabscale);
            itab_tmp         = _fjsp_dtox_v2r8(rt);
            vfeps            = _fjsp_sub_v2r8(rt, _fjsp_xtod_v2r8(itab_tmp));
            twovfeps         = _fjsp_add_v2r8(vfeps,vfeps);
            _fjsp_store_v2r8(&vfconv.simd,itab_tmp);

            vfconv.i[0]     *= 4;
            vfconv.i[1]     *= 4;

            /* CUBIC SPLINE TABLE ELECTROSTATICS */
            Y                = _fjsp_load_v2r8( vftab + vfconv.i[0] );
            F                = _fjsp_setzero_v2r8();
            GMX_FJSP_TRANSPOSE2_V2R8(Y,F);
            G                = _fjsp_load_v2r8( vftab + vfconv.i[0] +2);
            H                = _fjsp_setzero_v2r8();
            GMX_FJSP_TRANSPOSE2_V2R8(G,H);
            Fp               = _fjsp_madd_v2r8(vfeps,_fjsp_madd_v2r8(vfeps,H,G),F);
            VV               = _fjsp_madd_v2r8(vfeps,Fp,Y);
            velec            = _fjsp_mul_v2r8(qq23,VV);
            FF               = _fjsp_madd_v2r8(_fjsp_madd_v2r8(twovfeps,H,G),vfeps,Fp);
            felec            = _fjsp_neg_v2r8(_fjsp_mul_v2r8(_fjsp_mul_v2r8(qq23,FF),_fjsp_mul_v2r8(vftabscale,rinv23)));

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _fjsp_unpacklo_v2r8(velec,_fjsp_setzero_v2r8());
            velecsum         = _fjsp_add_v2r8(velecsum,velec);

            fscal            = felec;

            fscal            = _fjsp_unpacklo_v2r8(fscal,_fjsp_setzero_v2r8());

            /* Update vectorial force */
            fix2             = _fjsp_madd_v2r8(dx23,fscal,fix2);
            fiy2             = _fjsp_madd_v2r8(dy23,fscal,fiy2);
            fiz2             = _fjsp_madd_v2r8(dz23,fscal,fiz2);
            
            fjx3             = _fjsp_madd_v2r8(dx23,fscal,fjx3);
            fjy3             = _fjsp_madd_v2r8(dy23,fscal,fjy3);
            fjz3             = _fjsp_madd_v2r8(dz23,fscal,fjz3);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r31              = _fjsp_mul_v2r8(rsq31,rinv31);

            /* Calculate table index by multiplying r with table scale and truncate to integer */
            rt               = _fjsp_mul_v2r8(r31,vftabscale);
            itab_tmp         = _fjsp_dtox_v2r8(rt);
            vfeps            = _fjsp_sub_v2r8(rt, _fjsp_xtod_v2r8(itab_tmp));
            twovfeps         = _fjsp_add_v2r8(vfeps,vfeps);
            _fjsp_store_v2r8(&vfconv.simd,itab_tmp);

            vfconv.i[0]     *= 4;
            vfconv.i[1]     *= 4;

            /* CUBIC SPLINE TABLE ELECTROSTATICS */
            Y                = _fjsp_load_v2r8( vftab + vfconv.i[0] );
            F                = _fjsp_setzero_v2r8();
            GMX_FJSP_TRANSPOSE2_V2R8(Y,F);
            G                = _fjsp_load_v2r8( vftab + vfconv.i[0] +2);
            H                = _fjsp_setzero_v2r8();
            GMX_FJSP_TRANSPOSE2_V2R8(G,H);
            Fp               = _fjsp_madd_v2r8(vfeps,_fjsp_madd_v2r8(vfeps,H,G),F);
            VV               = _fjsp_madd_v2r8(vfeps,Fp,Y);
            velec            = _fjsp_mul_v2r8(qq31,VV);
            FF               = _fjsp_madd_v2r8(_fjsp_madd_v2r8(twovfeps,H,G),vfeps,Fp);
            felec            = _fjsp_neg_v2r8(_fjsp_mul_v2r8(_fjsp_mul_v2r8(qq31,FF),_fjsp_mul_v2r8(vftabscale,rinv31)));

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _fjsp_unpacklo_v2r8(velec,_fjsp_setzero_v2r8());
            velecsum         = _fjsp_add_v2r8(velecsum,velec);

            fscal            = felec;

            fscal            = _fjsp_unpacklo_v2r8(fscal,_fjsp_setzero_v2r8());

            /* Update vectorial force */
            fix3             = _fjsp_madd_v2r8(dx31,fscal,fix3);
            fiy3             = _fjsp_madd_v2r8(dy31,fscal,fiy3);
            fiz3             = _fjsp_madd_v2r8(dz31,fscal,fiz3);
            
            fjx1             = _fjsp_madd_v2r8(dx31,fscal,fjx1);
            fjy1             = _fjsp_madd_v2r8(dy31,fscal,fjy1);
            fjz1             = _fjsp_madd_v2r8(dz31,fscal,fjz1);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r32              = _fjsp_mul_v2r8(rsq32,rinv32);

            /* Calculate table index by multiplying r with table scale and truncate to integer */
            rt               = _fjsp_mul_v2r8(r32,vftabscale);
            itab_tmp         = _fjsp_dtox_v2r8(rt);
            vfeps            = _fjsp_sub_v2r8(rt, _fjsp_xtod_v2r8(itab_tmp));
            twovfeps         = _fjsp_add_v2r8(vfeps,vfeps);
            _fjsp_store_v2r8(&vfconv.simd,itab_tmp);

            vfconv.i[0]     *= 4;
            vfconv.i[1]     *= 4;

            /* CUBIC SPLINE TABLE ELECTROSTATICS */
            Y                = _fjsp_load_v2r8( vftab + vfconv.i[0] );
            F                = _fjsp_setzero_v2r8();
            GMX_FJSP_TRANSPOSE2_V2R8(Y,F);
            G                = _fjsp_load_v2r8( vftab + vfconv.i[0] +2);
            H                = _fjsp_setzero_v2r8();
            GMX_FJSP_TRANSPOSE2_V2R8(G,H);
            Fp               = _fjsp_madd_v2r8(vfeps,_fjsp_madd_v2r8(vfeps,H,G),F);
            VV               = _fjsp_madd_v2r8(vfeps,Fp,Y);
            velec            = _fjsp_mul_v2r8(qq32,VV);
            FF               = _fjsp_madd_v2r8(_fjsp_madd_v2r8(twovfeps,H,G),vfeps,Fp);
            felec            = _fjsp_neg_v2r8(_fjsp_mul_v2r8(_fjsp_mul_v2r8(qq32,FF),_fjsp_mul_v2r8(vftabscale,rinv32)));

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _fjsp_unpacklo_v2r8(velec,_fjsp_setzero_v2r8());
            velecsum         = _fjsp_add_v2r8(velecsum,velec);

            fscal            = felec;

            fscal            = _fjsp_unpacklo_v2r8(fscal,_fjsp_setzero_v2r8());

            /* Update vectorial force */
            fix3             = _fjsp_madd_v2r8(dx32,fscal,fix3);
            fiy3             = _fjsp_madd_v2r8(dy32,fscal,fiy3);
            fiz3             = _fjsp_madd_v2r8(dz32,fscal,fiz3);
            
            fjx2             = _fjsp_madd_v2r8(dx32,fscal,fjx2);
            fjy2             = _fjsp_madd_v2r8(dy32,fscal,fjy2);
            fjz2             = _fjsp_madd_v2r8(dz32,fscal,fjz2);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r33              = _fjsp_mul_v2r8(rsq33,rinv33);

            /* Calculate table index by multiplying r with table scale and truncate to integer */
            rt               = _fjsp_mul_v2r8(r33,vftabscale);
            itab_tmp         = _fjsp_dtox_v2r8(rt);
            vfeps            = _fjsp_sub_v2r8(rt, _fjsp_xtod_v2r8(itab_tmp));
            twovfeps         = _fjsp_add_v2r8(vfeps,vfeps);
            _fjsp_store_v2r8(&vfconv.simd,itab_tmp);

            vfconv.i[0]     *= 4;
            vfconv.i[1]     *= 4;

            /* CUBIC SPLINE TABLE ELECTROSTATICS */
            Y                = _fjsp_load_v2r8( vftab + vfconv.i[0] );
            F                = _fjsp_setzero_v2r8();
            GMX_FJSP_TRANSPOSE2_V2R8(Y,F);
            G                = _fjsp_load_v2r8( vftab + vfconv.i[0] +2);
            H                = _fjsp_setzero_v2r8();
            GMX_FJSP_TRANSPOSE2_V2R8(G,H);
            Fp               = _fjsp_madd_v2r8(vfeps,_fjsp_madd_v2r8(vfeps,H,G),F);
            VV               = _fjsp_madd_v2r8(vfeps,Fp,Y);
            velec            = _fjsp_mul_v2r8(qq33,VV);
            FF               = _fjsp_madd_v2r8(_fjsp_madd_v2r8(twovfeps,H,G),vfeps,Fp);
            felec            = _fjsp_neg_v2r8(_fjsp_mul_v2r8(_fjsp_mul_v2r8(qq33,FF),_fjsp_mul_v2r8(vftabscale,rinv33)));

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _fjsp_unpacklo_v2r8(velec,_fjsp_setzero_v2r8());
            velecsum         = _fjsp_add_v2r8(velecsum,velec);

            fscal            = felec;

            fscal            = _fjsp_unpacklo_v2r8(fscal,_fjsp_setzero_v2r8());

            /* Update vectorial force */
            fix3             = _fjsp_madd_v2r8(dx33,fscal,fix3);
            fiy3             = _fjsp_madd_v2r8(dy33,fscal,fiy3);
            fiz3             = _fjsp_madd_v2r8(dz33,fscal,fiz3);
            
            fjx3             = _fjsp_madd_v2r8(dx33,fscal,fjx3);
            fjy3             = _fjsp_madd_v2r8(dy33,fscal,fjy3);
            fjz3             = _fjsp_madd_v2r8(dz33,fscal,fjz3);

            gmx_fjsp_decrement_4rvec_1ptr_swizzle_v2r8(f+j_coord_offsetA,fjx0,fjy0,fjz0,fjx1,fjy1,fjz1,fjx2,fjy2,fjz2,fjx3,fjy3,fjz3);

            /* Inner loop uses 452 flops */
        }

        /* End of innermost loop */

        gmx_fjsp_update_iforce_4atom_swizzle_v2r8(fix0,fiy0,fiz0,fix1,fiy1,fiz1,fix2,fiy2,fiz2,fix3,fiy3,fiz3,
                                              f+i_coord_offset,fshift+i_shift_offset);

        ggid                        = gid[iidx];
        /* Update potential energies */
        gmx_fjsp_update_1pot_v2r8(velecsum,kernel_data->energygrp_elec+ggid);
        gmx_fjsp_update_1pot_v2r8(vvdwsum,kernel_data->energygrp_vdw+ggid);

        /* Increment number of inner iterations */
        inneriter                  += j_index_end - j_index_start;

        /* Outer loop uses 26 flops */
    }

    /* Increment number of outer iterations */
    outeriter        += nri;

    /* Update outer/inner flops */

    inc_nrnb(nrnb,eNR_NBKERNEL_ELEC_VDW_W4W4_VF,outeriter*26 + inneriter*452);
}
/*
 * Gromacs nonbonded kernel:   nb_kernel_ElecCSTab_VdwLJ_GeomW4W4_F_sparc64_hpc_ace_double
 * Electrostatics interaction: CubicSplineTable
 * VdW interaction:            LennardJones
 * Geometry:                   Water4-Water4
 * Calculate force/pot:        Force
 */
void
nb_kernel_ElecCSTab_VdwLJ_GeomW4W4_F_sparc64_hpc_ace_double
                    (t_nblist * gmx_restrict                nlist,
                     rvec * gmx_restrict                    xx,
                     rvec * gmx_restrict                    ff,
                     t_forcerec * gmx_restrict              fr,
                     t_mdatoms * gmx_restrict               mdatoms,
                     nb_kernel_data_t * gmx_restrict        kernel_data,
                     t_nrnb * gmx_restrict                  nrnb)
{
    /* Suffixes 0,1,2,3 refer to particle indices for waters in the inner or outer loop, or
     * just 0 for non-waters.
     * Suffixes A,B refer to j loop unrolling done with double precision SIMD, e.g. for the two different
     * jnr indices corresponding to data put in the four positions in the SIMD register.
     */
    int              i_shift_offset,i_coord_offset,outeriter,inneriter;
    int              j_index_start,j_index_end,jidx,nri,inr,ggid,iidx;
    int              jnrA,jnrB;
    int              j_coord_offsetA,j_coord_offsetB;
    int              *iinr,*jindex,*jjnr,*shiftidx,*gid;
    real             rcutoff_scalar;
    real             *shiftvec,*fshift,*x,*f;
    _fjsp_v2r8       tx,ty,tz,fscal,rcutoff,rcutoff2,jidxall;
    int              vdwioffset0;
    _fjsp_v2r8       ix0,iy0,iz0,fix0,fiy0,fiz0,iq0,isai0;
    int              vdwioffset1;
    _fjsp_v2r8       ix1,iy1,iz1,fix1,fiy1,fiz1,iq1,isai1;
    int              vdwioffset2;
    _fjsp_v2r8       ix2,iy2,iz2,fix2,fiy2,fiz2,iq2,isai2;
    int              vdwioffset3;
    _fjsp_v2r8       ix3,iy3,iz3,fix3,fiy3,fiz3,iq3,isai3;
    int              vdwjidx0A,vdwjidx0B;
    _fjsp_v2r8       jx0,jy0,jz0,fjx0,fjy0,fjz0,jq0,isaj0;
    int              vdwjidx1A,vdwjidx1B;
    _fjsp_v2r8       jx1,jy1,jz1,fjx1,fjy1,fjz1,jq1,isaj1;
    int              vdwjidx2A,vdwjidx2B;
    _fjsp_v2r8       jx2,jy2,jz2,fjx2,fjy2,fjz2,jq2,isaj2;
    int              vdwjidx3A,vdwjidx3B;
    _fjsp_v2r8       jx3,jy3,jz3,fjx3,fjy3,fjz3,jq3,isaj3;
    _fjsp_v2r8       dx00,dy00,dz00,rsq00,rinv00,rinvsq00,r00,qq00,c6_00,c12_00;
    _fjsp_v2r8       dx11,dy11,dz11,rsq11,rinv11,rinvsq11,r11,qq11,c6_11,c12_11;
    _fjsp_v2r8       dx12,dy12,dz12,rsq12,rinv12,rinvsq12,r12,qq12,c6_12,c12_12;
    _fjsp_v2r8       dx13,dy13,dz13,rsq13,rinv13,rinvsq13,r13,qq13,c6_13,c12_13;
    _fjsp_v2r8       dx21,dy21,dz21,rsq21,rinv21,rinvsq21,r21,qq21,c6_21,c12_21;
    _fjsp_v2r8       dx22,dy22,dz22,rsq22,rinv22,rinvsq22,r22,qq22,c6_22,c12_22;
    _fjsp_v2r8       dx23,dy23,dz23,rsq23,rinv23,rinvsq23,r23,qq23,c6_23,c12_23;
    _fjsp_v2r8       dx31,dy31,dz31,rsq31,rinv31,rinvsq31,r31,qq31,c6_31,c12_31;
    _fjsp_v2r8       dx32,dy32,dz32,rsq32,rinv32,rinvsq32,r32,qq32,c6_32,c12_32;
    _fjsp_v2r8       dx33,dy33,dz33,rsq33,rinv33,rinvsq33,r33,qq33,c6_33,c12_33;
    _fjsp_v2r8       velec,felec,velecsum,facel,crf,krf,krf2;
    real             *charge;
    int              nvdwtype;
    _fjsp_v2r8       rinvsix,rvdw,vvdw,vvdw6,vvdw12,fvdw,fvdw6,fvdw12,vvdwsum,sh_vdw_invrcut6;
    int              *vdwtype;
    real             *vdwparam;
    _fjsp_v2r8       one_sixth   = gmx_fjsp_set1_v2r8(1.0/6.0);
    _fjsp_v2r8       one_twelfth = gmx_fjsp_set1_v2r8(1.0/12.0);
    _fjsp_v2r8       rt,vfeps,vftabscale,Y,F,G,H,Heps,Fp,VV,FF,twovfeps;
    real             *vftab;
    _fjsp_v2r8       itab_tmp;
    _fjsp_v2r8       dummy_mask,cutoff_mask;
    _fjsp_v2r8       one     = gmx_fjsp_set1_v2r8(1.0);
    _fjsp_v2r8       two     = gmx_fjsp_set1_v2r8(2.0);
    union { _fjsp_v2r8 simd; long long int i[2]; } vfconv,gbconv,ewconv;

    x                = xx[0];
    f                = ff[0];

    nri              = nlist->nri;
    iinr             = nlist->iinr;
    jindex           = nlist->jindex;
    jjnr             = nlist->jjnr;
    shiftidx         = nlist->shift;
    gid              = nlist->gid;
    shiftvec         = fr->shift_vec[0];
    fshift           = fr->fshift[0];
    facel            = gmx_fjsp_set1_v2r8(fr->epsfac);
    charge           = mdatoms->chargeA;
    nvdwtype         = fr->ntype;
    vdwparam         = fr->nbfp;
    vdwtype          = mdatoms->typeA;

    vftab            = kernel_data->table_elec->data;
    vftabscale       = gmx_fjsp_set1_v2r8(kernel_data->table_elec->scale);

    /* Setup water-specific parameters */
    inr              = nlist->iinr[0];
    iq1              = _fjsp_mul_v2r8(facel,gmx_fjsp_set1_v2r8(charge[inr+1]));
    iq2              = _fjsp_mul_v2r8(facel,gmx_fjsp_set1_v2r8(charge[inr+2]));
    iq3              = _fjsp_mul_v2r8(facel,gmx_fjsp_set1_v2r8(charge[inr+3]));
    vdwioffset0      = 2*nvdwtype*vdwtype[inr+0];

    jq1              = gmx_fjsp_set1_v2r8(charge[inr+1]);
    jq2              = gmx_fjsp_set1_v2r8(charge[inr+2]);
    jq3              = gmx_fjsp_set1_v2r8(charge[inr+3]);
    vdwjidx0A        = 2*vdwtype[inr+0];
    c6_00            = gmx_fjsp_set1_v2r8(vdwparam[vdwioffset0+vdwjidx0A]);
    c12_00           = gmx_fjsp_set1_v2r8(vdwparam[vdwioffset0+vdwjidx0A+1]);
    qq11             = _fjsp_mul_v2r8(iq1,jq1);
    qq12             = _fjsp_mul_v2r8(iq1,jq2);
    qq13             = _fjsp_mul_v2r8(iq1,jq3);
    qq21             = _fjsp_mul_v2r8(iq2,jq1);
    qq22             = _fjsp_mul_v2r8(iq2,jq2);
    qq23             = _fjsp_mul_v2r8(iq2,jq3);
    qq31             = _fjsp_mul_v2r8(iq3,jq1);
    qq32             = _fjsp_mul_v2r8(iq3,jq2);
    qq33             = _fjsp_mul_v2r8(iq3,jq3);

    /* Avoid stupid compiler warnings */
    jnrA = jnrB = 0;
    j_coord_offsetA = 0;
    j_coord_offsetB = 0;

    outeriter        = 0;
    inneriter        = 0;

    /* Start outer loop over neighborlists */
    for(iidx=0; iidx<nri; iidx++)
    {
        /* Load shift vector for this list */
        i_shift_offset   = DIM*shiftidx[iidx];

        /* Load limits for loop over neighbors */
        j_index_start    = jindex[iidx];
        j_index_end      = jindex[iidx+1];

        /* Get outer coordinate index */
        inr              = iinr[iidx];
        i_coord_offset   = DIM*inr;

        /* Load i particle coords and add shift vector */
        gmx_fjsp_load_shift_and_4rvec_broadcast_v2r8(shiftvec+i_shift_offset,x+i_coord_offset,
                                                 &ix0,&iy0,&iz0,&ix1,&iy1,&iz1,&ix2,&iy2,&iz2,&ix3,&iy3,&iz3);

        fix0             = _fjsp_setzero_v2r8();
        fiy0             = _fjsp_setzero_v2r8();
        fiz0             = _fjsp_setzero_v2r8();
        fix1             = _fjsp_setzero_v2r8();
        fiy1             = _fjsp_setzero_v2r8();
        fiz1             = _fjsp_setzero_v2r8();
        fix2             = _fjsp_setzero_v2r8();
        fiy2             = _fjsp_setzero_v2r8();
        fiz2             = _fjsp_setzero_v2r8();
        fix3             = _fjsp_setzero_v2r8();
        fiy3             = _fjsp_setzero_v2r8();
        fiz3             = _fjsp_setzero_v2r8();

        /* Start inner kernel loop */
        for(jidx=j_index_start; jidx<j_index_end-1; jidx+=2)
        {

            /* Get j neighbor index, and coordinate index */
            jnrA             = jjnr[jidx];
            jnrB             = jjnr[jidx+1];
            j_coord_offsetA  = DIM*jnrA;
            j_coord_offsetB  = DIM*jnrB;

            /* load j atom coordinates */
            gmx_fjsp_load_4rvec_2ptr_swizzle_v2r8(x+j_coord_offsetA,x+j_coord_offsetB,
                                              &jx0,&jy0,&jz0,&jx1,&jy1,&jz1,&jx2,
                                              &jy2,&jz2,&jx3,&jy3,&jz3);

            /* Calculate displacement vector */
            dx00             = _fjsp_sub_v2r8(ix0,jx0);
            dy00             = _fjsp_sub_v2r8(iy0,jy0);
            dz00             = _fjsp_sub_v2r8(iz0,jz0);
            dx11             = _fjsp_sub_v2r8(ix1,jx1);
            dy11             = _fjsp_sub_v2r8(iy1,jy1);
            dz11             = _fjsp_sub_v2r8(iz1,jz1);
            dx12             = _fjsp_sub_v2r8(ix1,jx2);
            dy12             = _fjsp_sub_v2r8(iy1,jy2);
            dz12             = _fjsp_sub_v2r8(iz1,jz2);
            dx13             = _fjsp_sub_v2r8(ix1,jx3);
            dy13             = _fjsp_sub_v2r8(iy1,jy3);
            dz13             = _fjsp_sub_v2r8(iz1,jz3);
            dx21             = _fjsp_sub_v2r8(ix2,jx1);
            dy21             = _fjsp_sub_v2r8(iy2,jy1);
            dz21             = _fjsp_sub_v2r8(iz2,jz1);
            dx22             = _fjsp_sub_v2r8(ix2,jx2);
            dy22             = _fjsp_sub_v2r8(iy2,jy2);
            dz22             = _fjsp_sub_v2r8(iz2,jz2);
            dx23             = _fjsp_sub_v2r8(ix2,jx3);
            dy23             = _fjsp_sub_v2r8(iy2,jy3);
            dz23             = _fjsp_sub_v2r8(iz2,jz3);
            dx31             = _fjsp_sub_v2r8(ix3,jx1);
            dy31             = _fjsp_sub_v2r8(iy3,jy1);
            dz31             = _fjsp_sub_v2r8(iz3,jz1);
            dx32             = _fjsp_sub_v2r8(ix3,jx2);
            dy32             = _fjsp_sub_v2r8(iy3,jy2);
            dz32             = _fjsp_sub_v2r8(iz3,jz2);
            dx33             = _fjsp_sub_v2r8(ix3,jx3);
            dy33             = _fjsp_sub_v2r8(iy3,jy3);
            dz33             = _fjsp_sub_v2r8(iz3,jz3);

            /* Calculate squared distance and things based on it */
            rsq00            = gmx_fjsp_calc_rsq_v2r8(dx00,dy00,dz00);
            rsq11            = gmx_fjsp_calc_rsq_v2r8(dx11,dy11,dz11);
            rsq12            = gmx_fjsp_calc_rsq_v2r8(dx12,dy12,dz12);
            rsq13            = gmx_fjsp_calc_rsq_v2r8(dx13,dy13,dz13);
            rsq21            = gmx_fjsp_calc_rsq_v2r8(dx21,dy21,dz21);
            rsq22            = gmx_fjsp_calc_rsq_v2r8(dx22,dy22,dz22);
            rsq23            = gmx_fjsp_calc_rsq_v2r8(dx23,dy23,dz23);
            rsq31            = gmx_fjsp_calc_rsq_v2r8(dx31,dy31,dz31);
            rsq32            = gmx_fjsp_calc_rsq_v2r8(dx32,dy32,dz32);
            rsq33            = gmx_fjsp_calc_rsq_v2r8(dx33,dy33,dz33);

            rinv11           = gmx_fjsp_invsqrt_v2r8(rsq11);
            rinv12           = gmx_fjsp_invsqrt_v2r8(rsq12);
            rinv13           = gmx_fjsp_invsqrt_v2r8(rsq13);
            rinv21           = gmx_fjsp_invsqrt_v2r8(rsq21);
            rinv22           = gmx_fjsp_invsqrt_v2r8(rsq22);
            rinv23           = gmx_fjsp_invsqrt_v2r8(rsq23);
            rinv31           = gmx_fjsp_invsqrt_v2r8(rsq31);
            rinv32           = gmx_fjsp_invsqrt_v2r8(rsq32);
            rinv33           = gmx_fjsp_invsqrt_v2r8(rsq33);

            rinvsq00         = gmx_fjsp_inv_v2r8(rsq00);

            fjx0             = _fjsp_setzero_v2r8();
            fjy0             = _fjsp_setzero_v2r8();
            fjz0             = _fjsp_setzero_v2r8();
            fjx1             = _fjsp_setzero_v2r8();
            fjy1             = _fjsp_setzero_v2r8();
            fjz1             = _fjsp_setzero_v2r8();
            fjx2             = _fjsp_setzero_v2r8();
            fjy2             = _fjsp_setzero_v2r8();
            fjz2             = _fjsp_setzero_v2r8();
            fjx3             = _fjsp_setzero_v2r8();
            fjy3             = _fjsp_setzero_v2r8();
            fjz3             = _fjsp_setzero_v2r8();

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            /* LENNARD-JONES DISPERSION/REPULSION */

            rinvsix          = _fjsp_mul_v2r8(_fjsp_mul_v2r8(rinvsq00,rinvsq00),rinvsq00);
            fvdw             = _fjsp_mul_v2r8(_fjsp_msub_v2r8(c12_00,rinvsix,c6_00),_fjsp_mul_v2r8(rinvsix,rinvsq00));

            fscal            = fvdw;

            /* Update vectorial force */
            fix0             = _fjsp_madd_v2r8(dx00,fscal,fix0);
            fiy0             = _fjsp_madd_v2r8(dy00,fscal,fiy0);
            fiz0             = _fjsp_madd_v2r8(dz00,fscal,fiz0);
            
            fjx0             = _fjsp_madd_v2r8(dx00,fscal,fjx0);
            fjy0             = _fjsp_madd_v2r8(dy00,fscal,fjy0);
            fjz0             = _fjsp_madd_v2r8(dz00,fscal,fjz0);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r11              = _fjsp_mul_v2r8(rsq11,rinv11);

            /* Calculate table index by multiplying r with table scale and truncate to integer */
            rt               = _fjsp_mul_v2r8(r11,vftabscale);
            itab_tmp         = _fjsp_dtox_v2r8(rt);
            vfeps            = _fjsp_sub_v2r8(rt, _fjsp_xtod_v2r8(itab_tmp));
            twovfeps         = _fjsp_add_v2r8(vfeps,vfeps);
            _fjsp_store_v2r8(&vfconv.simd,itab_tmp);

            vfconv.i[0]     *= 4;
            vfconv.i[1]     *= 4;

            /* CUBIC SPLINE TABLE ELECTROSTATICS */
            Y                = _fjsp_load_v2r8( vftab + vfconv.i[0] );
            F                = _fjsp_load_v2r8( vftab + vfconv.i[1] );
            GMX_FJSP_TRANSPOSE2_V2R8(Y,F);
            G                = _fjsp_load_v2r8( vftab + vfconv.i[0] +2);
            H                = _fjsp_load_v2r8( vftab + vfconv.i[1] +2);
            GMX_FJSP_TRANSPOSE2_V2R8(G,H);
            Fp               = _fjsp_madd_v2r8(vfeps,_fjsp_madd_v2r8(vfeps,H,G),F);
            FF               = _fjsp_madd_v2r8(_fjsp_madd_v2r8(twovfeps,H,G),vfeps,Fp);
            felec            = _fjsp_neg_v2r8(_fjsp_mul_v2r8(_fjsp_mul_v2r8(qq11,FF),_fjsp_mul_v2r8(vftabscale,rinv11)));

            fscal            = felec;

            /* Update vectorial force */
            fix1             = _fjsp_madd_v2r8(dx11,fscal,fix1);
            fiy1             = _fjsp_madd_v2r8(dy11,fscal,fiy1);
            fiz1             = _fjsp_madd_v2r8(dz11,fscal,fiz1);
            
            fjx1             = _fjsp_madd_v2r8(dx11,fscal,fjx1);
            fjy1             = _fjsp_madd_v2r8(dy11,fscal,fjy1);
            fjz1             = _fjsp_madd_v2r8(dz11,fscal,fjz1);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r12              = _fjsp_mul_v2r8(rsq12,rinv12);

            /* Calculate table index by multiplying r with table scale and truncate to integer */
            rt               = _fjsp_mul_v2r8(r12,vftabscale);
            itab_tmp         = _fjsp_dtox_v2r8(rt);
            vfeps            = _fjsp_sub_v2r8(rt, _fjsp_xtod_v2r8(itab_tmp));
            twovfeps         = _fjsp_add_v2r8(vfeps,vfeps);
            _fjsp_store_v2r8(&vfconv.simd,itab_tmp);

            vfconv.i[0]     *= 4;
            vfconv.i[1]     *= 4;

            /* CUBIC SPLINE TABLE ELECTROSTATICS */
            Y                = _fjsp_load_v2r8( vftab + vfconv.i[0] );
            F                = _fjsp_load_v2r8( vftab + vfconv.i[1] );
            GMX_FJSP_TRANSPOSE2_V2R8(Y,F);
            G                = _fjsp_load_v2r8( vftab + vfconv.i[0] +2);
            H                = _fjsp_load_v2r8( vftab + vfconv.i[1] +2);
            GMX_FJSP_TRANSPOSE2_V2R8(G,H);
            Fp               = _fjsp_madd_v2r8(vfeps,_fjsp_madd_v2r8(vfeps,H,G),F);
            FF               = _fjsp_madd_v2r8(_fjsp_madd_v2r8(twovfeps,H,G),vfeps,Fp);
            felec            = _fjsp_neg_v2r8(_fjsp_mul_v2r8(_fjsp_mul_v2r8(qq12,FF),_fjsp_mul_v2r8(vftabscale,rinv12)));

            fscal            = felec;

            /* Update vectorial force */
            fix1             = _fjsp_madd_v2r8(dx12,fscal,fix1);
            fiy1             = _fjsp_madd_v2r8(dy12,fscal,fiy1);
            fiz1             = _fjsp_madd_v2r8(dz12,fscal,fiz1);
            
            fjx2             = _fjsp_madd_v2r8(dx12,fscal,fjx2);
            fjy2             = _fjsp_madd_v2r8(dy12,fscal,fjy2);
            fjz2             = _fjsp_madd_v2r8(dz12,fscal,fjz2);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r13              = _fjsp_mul_v2r8(rsq13,rinv13);

            /* Calculate table index by multiplying r with table scale and truncate to integer */
            rt               = _fjsp_mul_v2r8(r13,vftabscale);
            itab_tmp         = _fjsp_dtox_v2r8(rt);
            vfeps            = _fjsp_sub_v2r8(rt, _fjsp_xtod_v2r8(itab_tmp));
            twovfeps         = _fjsp_add_v2r8(vfeps,vfeps);
            _fjsp_store_v2r8(&vfconv.simd,itab_tmp);

            vfconv.i[0]     *= 4;
            vfconv.i[1]     *= 4;

            /* CUBIC SPLINE TABLE ELECTROSTATICS */
            Y                = _fjsp_load_v2r8( vftab + vfconv.i[0] );
            F                = _fjsp_load_v2r8( vftab + vfconv.i[1] );
            GMX_FJSP_TRANSPOSE2_V2R8(Y,F);
            G                = _fjsp_load_v2r8( vftab + vfconv.i[0] +2);
            H                = _fjsp_load_v2r8( vftab + vfconv.i[1] +2);
            GMX_FJSP_TRANSPOSE2_V2R8(G,H);
            Fp               = _fjsp_madd_v2r8(vfeps,_fjsp_madd_v2r8(vfeps,H,G),F);
            FF               = _fjsp_madd_v2r8(_fjsp_madd_v2r8(twovfeps,H,G),vfeps,Fp);
            felec            = _fjsp_neg_v2r8(_fjsp_mul_v2r8(_fjsp_mul_v2r8(qq13,FF),_fjsp_mul_v2r8(vftabscale,rinv13)));

            fscal            = felec;

            /* Update vectorial force */
            fix1             = _fjsp_madd_v2r8(dx13,fscal,fix1);
            fiy1             = _fjsp_madd_v2r8(dy13,fscal,fiy1);
            fiz1             = _fjsp_madd_v2r8(dz13,fscal,fiz1);
            
            fjx3             = _fjsp_madd_v2r8(dx13,fscal,fjx3);
            fjy3             = _fjsp_madd_v2r8(dy13,fscal,fjy3);
            fjz3             = _fjsp_madd_v2r8(dz13,fscal,fjz3);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r21              = _fjsp_mul_v2r8(rsq21,rinv21);

            /* Calculate table index by multiplying r with table scale and truncate to integer */
            rt               = _fjsp_mul_v2r8(r21,vftabscale);
            itab_tmp         = _fjsp_dtox_v2r8(rt);
            vfeps            = _fjsp_sub_v2r8(rt, _fjsp_xtod_v2r8(itab_tmp));
            twovfeps         = _fjsp_add_v2r8(vfeps,vfeps);
            _fjsp_store_v2r8(&vfconv.simd,itab_tmp);

            vfconv.i[0]     *= 4;
            vfconv.i[1]     *= 4;

            /* CUBIC SPLINE TABLE ELECTROSTATICS */
            Y                = _fjsp_load_v2r8( vftab + vfconv.i[0] );
            F                = _fjsp_load_v2r8( vftab + vfconv.i[1] );
            GMX_FJSP_TRANSPOSE2_V2R8(Y,F);
            G                = _fjsp_load_v2r8( vftab + vfconv.i[0] +2);
            H                = _fjsp_load_v2r8( vftab + vfconv.i[1] +2);
            GMX_FJSP_TRANSPOSE2_V2R8(G,H);
            Fp               = _fjsp_madd_v2r8(vfeps,_fjsp_madd_v2r8(vfeps,H,G),F);
            FF               = _fjsp_madd_v2r8(_fjsp_madd_v2r8(twovfeps,H,G),vfeps,Fp);
            felec            = _fjsp_neg_v2r8(_fjsp_mul_v2r8(_fjsp_mul_v2r8(qq21,FF),_fjsp_mul_v2r8(vftabscale,rinv21)));

            fscal            = felec;

            /* Update vectorial force */
            fix2             = _fjsp_madd_v2r8(dx21,fscal,fix2);
            fiy2             = _fjsp_madd_v2r8(dy21,fscal,fiy2);
            fiz2             = _fjsp_madd_v2r8(dz21,fscal,fiz2);
            
            fjx1             = _fjsp_madd_v2r8(dx21,fscal,fjx1);
            fjy1             = _fjsp_madd_v2r8(dy21,fscal,fjy1);
            fjz1             = _fjsp_madd_v2r8(dz21,fscal,fjz1);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r22              = _fjsp_mul_v2r8(rsq22,rinv22);

            /* Calculate table index by multiplying r with table scale and truncate to integer */
            rt               = _fjsp_mul_v2r8(r22,vftabscale);
            itab_tmp         = _fjsp_dtox_v2r8(rt);
            vfeps            = _fjsp_sub_v2r8(rt, _fjsp_xtod_v2r8(itab_tmp));
            twovfeps         = _fjsp_add_v2r8(vfeps,vfeps);
            _fjsp_store_v2r8(&vfconv.simd,itab_tmp);

            vfconv.i[0]     *= 4;
            vfconv.i[1]     *= 4;

            /* CUBIC SPLINE TABLE ELECTROSTATICS */
            Y                = _fjsp_load_v2r8( vftab + vfconv.i[0] );
            F                = _fjsp_load_v2r8( vftab + vfconv.i[1] );
            GMX_FJSP_TRANSPOSE2_V2R8(Y,F);
            G                = _fjsp_load_v2r8( vftab + vfconv.i[0] +2);
            H                = _fjsp_load_v2r8( vftab + vfconv.i[1] +2);
            GMX_FJSP_TRANSPOSE2_V2R8(G,H);
            Fp               = _fjsp_madd_v2r8(vfeps,_fjsp_madd_v2r8(vfeps,H,G),F);
            FF               = _fjsp_madd_v2r8(_fjsp_madd_v2r8(twovfeps,H,G),vfeps,Fp);
            felec            = _fjsp_neg_v2r8(_fjsp_mul_v2r8(_fjsp_mul_v2r8(qq22,FF),_fjsp_mul_v2r8(vftabscale,rinv22)));

            fscal            = felec;

            /* Update vectorial force */
            fix2             = _fjsp_madd_v2r8(dx22,fscal,fix2);
            fiy2             = _fjsp_madd_v2r8(dy22,fscal,fiy2);
            fiz2             = _fjsp_madd_v2r8(dz22,fscal,fiz2);
            
            fjx2             = _fjsp_madd_v2r8(dx22,fscal,fjx2);
            fjy2             = _fjsp_madd_v2r8(dy22,fscal,fjy2);
            fjz2             = _fjsp_madd_v2r8(dz22,fscal,fjz2);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r23              = _fjsp_mul_v2r8(rsq23,rinv23);

            /* Calculate table index by multiplying r with table scale and truncate to integer */
            rt               = _fjsp_mul_v2r8(r23,vftabscale);
            itab_tmp         = _fjsp_dtox_v2r8(rt);
            vfeps            = _fjsp_sub_v2r8(rt, _fjsp_xtod_v2r8(itab_tmp));
            twovfeps         = _fjsp_add_v2r8(vfeps,vfeps);
            _fjsp_store_v2r8(&vfconv.simd,itab_tmp);

            vfconv.i[0]     *= 4;
            vfconv.i[1]     *= 4;

            /* CUBIC SPLINE TABLE ELECTROSTATICS */
            Y                = _fjsp_load_v2r8( vftab + vfconv.i[0] );
            F                = _fjsp_load_v2r8( vftab + vfconv.i[1] );
            GMX_FJSP_TRANSPOSE2_V2R8(Y,F);
            G                = _fjsp_load_v2r8( vftab + vfconv.i[0] +2);
            H                = _fjsp_load_v2r8( vftab + vfconv.i[1] +2);
            GMX_FJSP_TRANSPOSE2_V2R8(G,H);
            Fp               = _fjsp_madd_v2r8(vfeps,_fjsp_madd_v2r8(vfeps,H,G),F);
            FF               = _fjsp_madd_v2r8(_fjsp_madd_v2r8(twovfeps,H,G),vfeps,Fp);
            felec            = _fjsp_neg_v2r8(_fjsp_mul_v2r8(_fjsp_mul_v2r8(qq23,FF),_fjsp_mul_v2r8(vftabscale,rinv23)));

            fscal            = felec;

            /* Update vectorial force */
            fix2             = _fjsp_madd_v2r8(dx23,fscal,fix2);
            fiy2             = _fjsp_madd_v2r8(dy23,fscal,fiy2);
            fiz2             = _fjsp_madd_v2r8(dz23,fscal,fiz2);
            
            fjx3             = _fjsp_madd_v2r8(dx23,fscal,fjx3);
            fjy3             = _fjsp_madd_v2r8(dy23,fscal,fjy3);
            fjz3             = _fjsp_madd_v2r8(dz23,fscal,fjz3);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r31              = _fjsp_mul_v2r8(rsq31,rinv31);

            /* Calculate table index by multiplying r with table scale and truncate to integer */
            rt               = _fjsp_mul_v2r8(r31,vftabscale);
            itab_tmp         = _fjsp_dtox_v2r8(rt);
            vfeps            = _fjsp_sub_v2r8(rt, _fjsp_xtod_v2r8(itab_tmp));
            twovfeps         = _fjsp_add_v2r8(vfeps,vfeps);
            _fjsp_store_v2r8(&vfconv.simd,itab_tmp);

            vfconv.i[0]     *= 4;
            vfconv.i[1]     *= 4;

            /* CUBIC SPLINE TABLE ELECTROSTATICS */
            Y                = _fjsp_load_v2r8( vftab + vfconv.i[0] );
            F                = _fjsp_load_v2r8( vftab + vfconv.i[1] );
            GMX_FJSP_TRANSPOSE2_V2R8(Y,F);
            G                = _fjsp_load_v2r8( vftab + vfconv.i[0] +2);
            H                = _fjsp_load_v2r8( vftab + vfconv.i[1] +2);
            GMX_FJSP_TRANSPOSE2_V2R8(G,H);
            Fp               = _fjsp_madd_v2r8(vfeps,_fjsp_madd_v2r8(vfeps,H,G),F);
            FF               = _fjsp_madd_v2r8(_fjsp_madd_v2r8(twovfeps,H,G),vfeps,Fp);
            felec            = _fjsp_neg_v2r8(_fjsp_mul_v2r8(_fjsp_mul_v2r8(qq31,FF),_fjsp_mul_v2r8(vftabscale,rinv31)));

            fscal            = felec;

            /* Update vectorial force */
            fix3             = _fjsp_madd_v2r8(dx31,fscal,fix3);
            fiy3             = _fjsp_madd_v2r8(dy31,fscal,fiy3);
            fiz3             = _fjsp_madd_v2r8(dz31,fscal,fiz3);
            
            fjx1             = _fjsp_madd_v2r8(dx31,fscal,fjx1);
            fjy1             = _fjsp_madd_v2r8(dy31,fscal,fjy1);
            fjz1             = _fjsp_madd_v2r8(dz31,fscal,fjz1);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r32              = _fjsp_mul_v2r8(rsq32,rinv32);

            /* Calculate table index by multiplying r with table scale and truncate to integer */
            rt               = _fjsp_mul_v2r8(r32,vftabscale);
            itab_tmp         = _fjsp_dtox_v2r8(rt);
            vfeps            = _fjsp_sub_v2r8(rt, _fjsp_xtod_v2r8(itab_tmp));
            twovfeps         = _fjsp_add_v2r8(vfeps,vfeps);
            _fjsp_store_v2r8(&vfconv.simd,itab_tmp);

            vfconv.i[0]     *= 4;
            vfconv.i[1]     *= 4;

            /* CUBIC SPLINE TABLE ELECTROSTATICS */
            Y                = _fjsp_load_v2r8( vftab + vfconv.i[0] );
            F                = _fjsp_load_v2r8( vftab + vfconv.i[1] );
            GMX_FJSP_TRANSPOSE2_V2R8(Y,F);
            G                = _fjsp_load_v2r8( vftab + vfconv.i[0] +2);
            H                = _fjsp_load_v2r8( vftab + vfconv.i[1] +2);
            GMX_FJSP_TRANSPOSE2_V2R8(G,H);
            Fp               = _fjsp_madd_v2r8(vfeps,_fjsp_madd_v2r8(vfeps,H,G),F);
            FF               = _fjsp_madd_v2r8(_fjsp_madd_v2r8(twovfeps,H,G),vfeps,Fp);
            felec            = _fjsp_neg_v2r8(_fjsp_mul_v2r8(_fjsp_mul_v2r8(qq32,FF),_fjsp_mul_v2r8(vftabscale,rinv32)));

            fscal            = felec;

            /* Update vectorial force */
            fix3             = _fjsp_madd_v2r8(dx32,fscal,fix3);
            fiy3             = _fjsp_madd_v2r8(dy32,fscal,fiy3);
            fiz3             = _fjsp_madd_v2r8(dz32,fscal,fiz3);
            
            fjx2             = _fjsp_madd_v2r8(dx32,fscal,fjx2);
            fjy2             = _fjsp_madd_v2r8(dy32,fscal,fjy2);
            fjz2             = _fjsp_madd_v2r8(dz32,fscal,fjz2);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r33              = _fjsp_mul_v2r8(rsq33,rinv33);

            /* Calculate table index by multiplying r with table scale and truncate to integer */
            rt               = _fjsp_mul_v2r8(r33,vftabscale);
            itab_tmp         = _fjsp_dtox_v2r8(rt);
            vfeps            = _fjsp_sub_v2r8(rt, _fjsp_xtod_v2r8(itab_tmp));
            twovfeps         = _fjsp_add_v2r8(vfeps,vfeps);
            _fjsp_store_v2r8(&vfconv.simd,itab_tmp);

            vfconv.i[0]     *= 4;
            vfconv.i[1]     *= 4;

            /* CUBIC SPLINE TABLE ELECTROSTATICS */
            Y                = _fjsp_load_v2r8( vftab + vfconv.i[0] );
            F                = _fjsp_load_v2r8( vftab + vfconv.i[1] );
            GMX_FJSP_TRANSPOSE2_V2R8(Y,F);
            G                = _fjsp_load_v2r8( vftab + vfconv.i[0] +2);
            H                = _fjsp_load_v2r8( vftab + vfconv.i[1] +2);
            GMX_FJSP_TRANSPOSE2_V2R8(G,H);
            Fp               = _fjsp_madd_v2r8(vfeps,_fjsp_madd_v2r8(vfeps,H,G),F);
            FF               = _fjsp_madd_v2r8(_fjsp_madd_v2r8(twovfeps,H,G),vfeps,Fp);
            felec            = _fjsp_neg_v2r8(_fjsp_mul_v2r8(_fjsp_mul_v2r8(qq33,FF),_fjsp_mul_v2r8(vftabscale,rinv33)));

            fscal            = felec;

            /* Update vectorial force */
            fix3             = _fjsp_madd_v2r8(dx33,fscal,fix3);
            fiy3             = _fjsp_madd_v2r8(dy33,fscal,fiy3);
            fiz3             = _fjsp_madd_v2r8(dz33,fscal,fiz3);
            
            fjx3             = _fjsp_madd_v2r8(dx33,fscal,fjx3);
            fjy3             = _fjsp_madd_v2r8(dy33,fscal,fjy3);
            fjz3             = _fjsp_madd_v2r8(dz33,fscal,fjz3);

            gmx_fjsp_decrement_4rvec_2ptr_swizzle_v2r8(f+j_coord_offsetA,f+j_coord_offsetB,fjx0,fjy0,fjz0,fjx1,fjy1,fjz1,fjx2,fjy2,fjz2,fjx3,fjy3,fjz3);

            /* Inner loop uses 411 flops */
        }

        if(jidx<j_index_end)
        {

            jnrA             = jjnr[jidx];
            j_coord_offsetA  = DIM*jnrA;

            /* load j atom coordinates */
            gmx_fjsp_load_4rvec_1ptr_swizzle_v2r8(x+j_coord_offsetA,
                                              &jx0,&jy0,&jz0,&jx1,&jy1,&jz1,&jx2,
                                              &jy2,&jz2,&jx3,&jy3,&jz3);

            /* Calculate displacement vector */
            dx00             = _fjsp_sub_v2r8(ix0,jx0);
            dy00             = _fjsp_sub_v2r8(iy0,jy0);
            dz00             = _fjsp_sub_v2r8(iz0,jz0);
            dx11             = _fjsp_sub_v2r8(ix1,jx1);
            dy11             = _fjsp_sub_v2r8(iy1,jy1);
            dz11             = _fjsp_sub_v2r8(iz1,jz1);
            dx12             = _fjsp_sub_v2r8(ix1,jx2);
            dy12             = _fjsp_sub_v2r8(iy1,jy2);
            dz12             = _fjsp_sub_v2r8(iz1,jz2);
            dx13             = _fjsp_sub_v2r8(ix1,jx3);
            dy13             = _fjsp_sub_v2r8(iy1,jy3);
            dz13             = _fjsp_sub_v2r8(iz1,jz3);
            dx21             = _fjsp_sub_v2r8(ix2,jx1);
            dy21             = _fjsp_sub_v2r8(iy2,jy1);
            dz21             = _fjsp_sub_v2r8(iz2,jz1);
            dx22             = _fjsp_sub_v2r8(ix2,jx2);
            dy22             = _fjsp_sub_v2r8(iy2,jy2);
            dz22             = _fjsp_sub_v2r8(iz2,jz2);
            dx23             = _fjsp_sub_v2r8(ix2,jx3);
            dy23             = _fjsp_sub_v2r8(iy2,jy3);
            dz23             = _fjsp_sub_v2r8(iz2,jz3);
            dx31             = _fjsp_sub_v2r8(ix3,jx1);
            dy31             = _fjsp_sub_v2r8(iy3,jy1);
            dz31             = _fjsp_sub_v2r8(iz3,jz1);
            dx32             = _fjsp_sub_v2r8(ix3,jx2);
            dy32             = _fjsp_sub_v2r8(iy3,jy2);
            dz32             = _fjsp_sub_v2r8(iz3,jz2);
            dx33             = _fjsp_sub_v2r8(ix3,jx3);
            dy33             = _fjsp_sub_v2r8(iy3,jy3);
            dz33             = _fjsp_sub_v2r8(iz3,jz3);

            /* Calculate squared distance and things based on it */
            rsq00            = gmx_fjsp_calc_rsq_v2r8(dx00,dy00,dz00);
            rsq11            = gmx_fjsp_calc_rsq_v2r8(dx11,dy11,dz11);
            rsq12            = gmx_fjsp_calc_rsq_v2r8(dx12,dy12,dz12);
            rsq13            = gmx_fjsp_calc_rsq_v2r8(dx13,dy13,dz13);
            rsq21            = gmx_fjsp_calc_rsq_v2r8(dx21,dy21,dz21);
            rsq22            = gmx_fjsp_calc_rsq_v2r8(dx22,dy22,dz22);
            rsq23            = gmx_fjsp_calc_rsq_v2r8(dx23,dy23,dz23);
            rsq31            = gmx_fjsp_calc_rsq_v2r8(dx31,dy31,dz31);
            rsq32            = gmx_fjsp_calc_rsq_v2r8(dx32,dy32,dz32);
            rsq33            = gmx_fjsp_calc_rsq_v2r8(dx33,dy33,dz33);

            rinv11           = gmx_fjsp_invsqrt_v2r8(rsq11);
            rinv12           = gmx_fjsp_invsqrt_v2r8(rsq12);
            rinv13           = gmx_fjsp_invsqrt_v2r8(rsq13);
            rinv21           = gmx_fjsp_invsqrt_v2r8(rsq21);
            rinv22           = gmx_fjsp_invsqrt_v2r8(rsq22);
            rinv23           = gmx_fjsp_invsqrt_v2r8(rsq23);
            rinv31           = gmx_fjsp_invsqrt_v2r8(rsq31);
            rinv32           = gmx_fjsp_invsqrt_v2r8(rsq32);
            rinv33           = gmx_fjsp_invsqrt_v2r8(rsq33);

            rinvsq00         = gmx_fjsp_inv_v2r8(rsq00);

            fjx0             = _fjsp_setzero_v2r8();
            fjy0             = _fjsp_setzero_v2r8();
            fjz0             = _fjsp_setzero_v2r8();
            fjx1             = _fjsp_setzero_v2r8();
            fjy1             = _fjsp_setzero_v2r8();
            fjz1             = _fjsp_setzero_v2r8();
            fjx2             = _fjsp_setzero_v2r8();
            fjy2             = _fjsp_setzero_v2r8();
            fjz2             = _fjsp_setzero_v2r8();
            fjx3             = _fjsp_setzero_v2r8();
            fjy3             = _fjsp_setzero_v2r8();
            fjz3             = _fjsp_setzero_v2r8();

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            /* LENNARD-JONES DISPERSION/REPULSION */

            rinvsix          = _fjsp_mul_v2r8(_fjsp_mul_v2r8(rinvsq00,rinvsq00),rinvsq00);
            fvdw             = _fjsp_mul_v2r8(_fjsp_msub_v2r8(c12_00,rinvsix,c6_00),_fjsp_mul_v2r8(rinvsix,rinvsq00));

            fscal            = fvdw;

            fscal            = _fjsp_unpacklo_v2r8(fscal,_fjsp_setzero_v2r8());

            /* Update vectorial force */
            fix0             = _fjsp_madd_v2r8(dx00,fscal,fix0);
            fiy0             = _fjsp_madd_v2r8(dy00,fscal,fiy0);
            fiz0             = _fjsp_madd_v2r8(dz00,fscal,fiz0);
            
            fjx0             = _fjsp_madd_v2r8(dx00,fscal,fjx0);
            fjy0             = _fjsp_madd_v2r8(dy00,fscal,fjy0);
            fjz0             = _fjsp_madd_v2r8(dz00,fscal,fjz0);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r11              = _fjsp_mul_v2r8(rsq11,rinv11);

            /* Calculate table index by multiplying r with table scale and truncate to integer */
            rt               = _fjsp_mul_v2r8(r11,vftabscale);
            itab_tmp         = _fjsp_dtox_v2r8(rt);
            vfeps            = _fjsp_sub_v2r8(rt, _fjsp_xtod_v2r8(itab_tmp));
            twovfeps         = _fjsp_add_v2r8(vfeps,vfeps);
            _fjsp_store_v2r8(&vfconv.simd,itab_tmp);

            vfconv.i[0]     *= 4;
            vfconv.i[1]     *= 4;

            /* CUBIC SPLINE TABLE ELECTROSTATICS */
            Y                = _fjsp_load_v2r8( vftab + vfconv.i[0] );
            F                = _fjsp_setzero_v2r8();
            GMX_FJSP_TRANSPOSE2_V2R8(Y,F);
            G                = _fjsp_load_v2r8( vftab + vfconv.i[0] +2);
            H                = _fjsp_setzero_v2r8();
            GMX_FJSP_TRANSPOSE2_V2R8(G,H);
            Fp               = _fjsp_madd_v2r8(vfeps,_fjsp_madd_v2r8(vfeps,H,G),F);
            FF               = _fjsp_madd_v2r8(_fjsp_madd_v2r8(twovfeps,H,G),vfeps,Fp);
            felec            = _fjsp_neg_v2r8(_fjsp_mul_v2r8(_fjsp_mul_v2r8(qq11,FF),_fjsp_mul_v2r8(vftabscale,rinv11)));

            fscal            = felec;

            fscal            = _fjsp_unpacklo_v2r8(fscal,_fjsp_setzero_v2r8());

            /* Update vectorial force */
            fix1             = _fjsp_madd_v2r8(dx11,fscal,fix1);
            fiy1             = _fjsp_madd_v2r8(dy11,fscal,fiy1);
            fiz1             = _fjsp_madd_v2r8(dz11,fscal,fiz1);
            
            fjx1             = _fjsp_madd_v2r8(dx11,fscal,fjx1);
            fjy1             = _fjsp_madd_v2r8(dy11,fscal,fjy1);
            fjz1             = _fjsp_madd_v2r8(dz11,fscal,fjz1);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r12              = _fjsp_mul_v2r8(rsq12,rinv12);

            /* Calculate table index by multiplying r with table scale and truncate to integer */
            rt               = _fjsp_mul_v2r8(r12,vftabscale);
            itab_tmp         = _fjsp_dtox_v2r8(rt);
            vfeps            = _fjsp_sub_v2r8(rt, _fjsp_xtod_v2r8(itab_tmp));
            twovfeps         = _fjsp_add_v2r8(vfeps,vfeps);
            _fjsp_store_v2r8(&vfconv.simd,itab_tmp);

            vfconv.i[0]     *= 4;
            vfconv.i[1]     *= 4;

            /* CUBIC SPLINE TABLE ELECTROSTATICS */
            Y                = _fjsp_load_v2r8( vftab + vfconv.i[0] );
            F                = _fjsp_setzero_v2r8();
            GMX_FJSP_TRANSPOSE2_V2R8(Y,F);
            G                = _fjsp_load_v2r8( vftab + vfconv.i[0] +2);
            H                = _fjsp_setzero_v2r8();
            GMX_FJSP_TRANSPOSE2_V2R8(G,H);
            Fp               = _fjsp_madd_v2r8(vfeps,_fjsp_madd_v2r8(vfeps,H,G),F);
            FF               = _fjsp_madd_v2r8(_fjsp_madd_v2r8(twovfeps,H,G),vfeps,Fp);
            felec            = _fjsp_neg_v2r8(_fjsp_mul_v2r8(_fjsp_mul_v2r8(qq12,FF),_fjsp_mul_v2r8(vftabscale,rinv12)));

            fscal            = felec;

            fscal            = _fjsp_unpacklo_v2r8(fscal,_fjsp_setzero_v2r8());

            /* Update vectorial force */
            fix1             = _fjsp_madd_v2r8(dx12,fscal,fix1);
            fiy1             = _fjsp_madd_v2r8(dy12,fscal,fiy1);
            fiz1             = _fjsp_madd_v2r8(dz12,fscal,fiz1);
            
            fjx2             = _fjsp_madd_v2r8(dx12,fscal,fjx2);
            fjy2             = _fjsp_madd_v2r8(dy12,fscal,fjy2);
            fjz2             = _fjsp_madd_v2r8(dz12,fscal,fjz2);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r13              = _fjsp_mul_v2r8(rsq13,rinv13);

            /* Calculate table index by multiplying r with table scale and truncate to integer */
            rt               = _fjsp_mul_v2r8(r13,vftabscale);
            itab_tmp         = _fjsp_dtox_v2r8(rt);
            vfeps            = _fjsp_sub_v2r8(rt, _fjsp_xtod_v2r8(itab_tmp));
            twovfeps         = _fjsp_add_v2r8(vfeps,vfeps);
            _fjsp_store_v2r8(&vfconv.simd,itab_tmp);

            vfconv.i[0]     *= 4;
            vfconv.i[1]     *= 4;

            /* CUBIC SPLINE TABLE ELECTROSTATICS */
            Y                = _fjsp_load_v2r8( vftab + vfconv.i[0] );
            F                = _fjsp_setzero_v2r8();
            GMX_FJSP_TRANSPOSE2_V2R8(Y,F);
            G                = _fjsp_load_v2r8( vftab + vfconv.i[0] +2);
            H                = _fjsp_setzero_v2r8();
            GMX_FJSP_TRANSPOSE2_V2R8(G,H);
            Fp               = _fjsp_madd_v2r8(vfeps,_fjsp_madd_v2r8(vfeps,H,G),F);
            FF               = _fjsp_madd_v2r8(_fjsp_madd_v2r8(twovfeps,H,G),vfeps,Fp);
            felec            = _fjsp_neg_v2r8(_fjsp_mul_v2r8(_fjsp_mul_v2r8(qq13,FF),_fjsp_mul_v2r8(vftabscale,rinv13)));

            fscal            = felec;

            fscal            = _fjsp_unpacklo_v2r8(fscal,_fjsp_setzero_v2r8());

            /* Update vectorial force */
            fix1             = _fjsp_madd_v2r8(dx13,fscal,fix1);
            fiy1             = _fjsp_madd_v2r8(dy13,fscal,fiy1);
            fiz1             = _fjsp_madd_v2r8(dz13,fscal,fiz1);
            
            fjx3             = _fjsp_madd_v2r8(dx13,fscal,fjx3);
            fjy3             = _fjsp_madd_v2r8(dy13,fscal,fjy3);
            fjz3             = _fjsp_madd_v2r8(dz13,fscal,fjz3);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r21              = _fjsp_mul_v2r8(rsq21,rinv21);

            /* Calculate table index by multiplying r with table scale and truncate to integer */
            rt               = _fjsp_mul_v2r8(r21,vftabscale);
            itab_tmp         = _fjsp_dtox_v2r8(rt);
            vfeps            = _fjsp_sub_v2r8(rt, _fjsp_xtod_v2r8(itab_tmp));
            twovfeps         = _fjsp_add_v2r8(vfeps,vfeps);
            _fjsp_store_v2r8(&vfconv.simd,itab_tmp);

            vfconv.i[0]     *= 4;
            vfconv.i[1]     *= 4;

            /* CUBIC SPLINE TABLE ELECTROSTATICS */
            Y                = _fjsp_load_v2r8( vftab + vfconv.i[0] );
            F                = _fjsp_setzero_v2r8();
            GMX_FJSP_TRANSPOSE2_V2R8(Y,F);
            G                = _fjsp_load_v2r8( vftab + vfconv.i[0] +2);
            H                = _fjsp_setzero_v2r8();
            GMX_FJSP_TRANSPOSE2_V2R8(G,H);
            Fp               = _fjsp_madd_v2r8(vfeps,_fjsp_madd_v2r8(vfeps,H,G),F);
            FF               = _fjsp_madd_v2r8(_fjsp_madd_v2r8(twovfeps,H,G),vfeps,Fp);
            felec            = _fjsp_neg_v2r8(_fjsp_mul_v2r8(_fjsp_mul_v2r8(qq21,FF),_fjsp_mul_v2r8(vftabscale,rinv21)));

            fscal            = felec;

            fscal            = _fjsp_unpacklo_v2r8(fscal,_fjsp_setzero_v2r8());

            /* Update vectorial force */
            fix2             = _fjsp_madd_v2r8(dx21,fscal,fix2);
            fiy2             = _fjsp_madd_v2r8(dy21,fscal,fiy2);
            fiz2             = _fjsp_madd_v2r8(dz21,fscal,fiz2);
            
            fjx1             = _fjsp_madd_v2r8(dx21,fscal,fjx1);
            fjy1             = _fjsp_madd_v2r8(dy21,fscal,fjy1);
            fjz1             = _fjsp_madd_v2r8(dz21,fscal,fjz1);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r22              = _fjsp_mul_v2r8(rsq22,rinv22);

            /* Calculate table index by multiplying r with table scale and truncate to integer */
            rt               = _fjsp_mul_v2r8(r22,vftabscale);
            itab_tmp         = _fjsp_dtox_v2r8(rt);
            vfeps            = _fjsp_sub_v2r8(rt, _fjsp_xtod_v2r8(itab_tmp));
            twovfeps         = _fjsp_add_v2r8(vfeps,vfeps);
            _fjsp_store_v2r8(&vfconv.simd,itab_tmp);

            vfconv.i[0]     *= 4;
            vfconv.i[1]     *= 4;

            /* CUBIC SPLINE TABLE ELECTROSTATICS */
            Y                = _fjsp_load_v2r8( vftab + vfconv.i[0] );
            F                = _fjsp_setzero_v2r8();
            GMX_FJSP_TRANSPOSE2_V2R8(Y,F);
            G                = _fjsp_load_v2r8( vftab + vfconv.i[0] +2);
            H                = _fjsp_setzero_v2r8();
            GMX_FJSP_TRANSPOSE2_V2R8(G,H);
            Fp               = _fjsp_madd_v2r8(vfeps,_fjsp_madd_v2r8(vfeps,H,G),F);
            FF               = _fjsp_madd_v2r8(_fjsp_madd_v2r8(twovfeps,H,G),vfeps,Fp);
            felec            = _fjsp_neg_v2r8(_fjsp_mul_v2r8(_fjsp_mul_v2r8(qq22,FF),_fjsp_mul_v2r8(vftabscale,rinv22)));

            fscal            = felec;

            fscal            = _fjsp_unpacklo_v2r8(fscal,_fjsp_setzero_v2r8());

            /* Update vectorial force */
            fix2             = _fjsp_madd_v2r8(dx22,fscal,fix2);
            fiy2             = _fjsp_madd_v2r8(dy22,fscal,fiy2);
            fiz2             = _fjsp_madd_v2r8(dz22,fscal,fiz2);
            
            fjx2             = _fjsp_madd_v2r8(dx22,fscal,fjx2);
            fjy2             = _fjsp_madd_v2r8(dy22,fscal,fjy2);
            fjz2             = _fjsp_madd_v2r8(dz22,fscal,fjz2);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r23              = _fjsp_mul_v2r8(rsq23,rinv23);

            /* Calculate table index by multiplying r with table scale and truncate to integer */
            rt               = _fjsp_mul_v2r8(r23,vftabscale);
            itab_tmp         = _fjsp_dtox_v2r8(rt);
            vfeps            = _fjsp_sub_v2r8(rt, _fjsp_xtod_v2r8(itab_tmp));
            twovfeps         = _fjsp_add_v2r8(vfeps,vfeps);
            _fjsp_store_v2r8(&vfconv.simd,itab_tmp);

            vfconv.i[0]     *= 4;
            vfconv.i[1]     *= 4;

            /* CUBIC SPLINE TABLE ELECTROSTATICS */
            Y                = _fjsp_load_v2r8( vftab + vfconv.i[0] );
            F                = _fjsp_setzero_v2r8();
            GMX_FJSP_TRANSPOSE2_V2R8(Y,F);
            G                = _fjsp_load_v2r8( vftab + vfconv.i[0] +2);
            H                = _fjsp_setzero_v2r8();
            GMX_FJSP_TRANSPOSE2_V2R8(G,H);
            Fp               = _fjsp_madd_v2r8(vfeps,_fjsp_madd_v2r8(vfeps,H,G),F);
            FF               = _fjsp_madd_v2r8(_fjsp_madd_v2r8(twovfeps,H,G),vfeps,Fp);
            felec            = _fjsp_neg_v2r8(_fjsp_mul_v2r8(_fjsp_mul_v2r8(qq23,FF),_fjsp_mul_v2r8(vftabscale,rinv23)));

            fscal            = felec;

            fscal            = _fjsp_unpacklo_v2r8(fscal,_fjsp_setzero_v2r8());

            /* Update vectorial force */
            fix2             = _fjsp_madd_v2r8(dx23,fscal,fix2);
            fiy2             = _fjsp_madd_v2r8(dy23,fscal,fiy2);
            fiz2             = _fjsp_madd_v2r8(dz23,fscal,fiz2);
            
            fjx3             = _fjsp_madd_v2r8(dx23,fscal,fjx3);
            fjy3             = _fjsp_madd_v2r8(dy23,fscal,fjy3);
            fjz3             = _fjsp_madd_v2r8(dz23,fscal,fjz3);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r31              = _fjsp_mul_v2r8(rsq31,rinv31);

            /* Calculate table index by multiplying r with table scale and truncate to integer */
            rt               = _fjsp_mul_v2r8(r31,vftabscale);
            itab_tmp         = _fjsp_dtox_v2r8(rt);
            vfeps            = _fjsp_sub_v2r8(rt, _fjsp_xtod_v2r8(itab_tmp));
            twovfeps         = _fjsp_add_v2r8(vfeps,vfeps);
            _fjsp_store_v2r8(&vfconv.simd,itab_tmp);

            vfconv.i[0]     *= 4;
            vfconv.i[1]     *= 4;

            /* CUBIC SPLINE TABLE ELECTROSTATICS */
            Y                = _fjsp_load_v2r8( vftab + vfconv.i[0] );
            F                = _fjsp_setzero_v2r8();
            GMX_FJSP_TRANSPOSE2_V2R8(Y,F);
            G                = _fjsp_load_v2r8( vftab + vfconv.i[0] +2);
            H                = _fjsp_setzero_v2r8();
            GMX_FJSP_TRANSPOSE2_V2R8(G,H);
            Fp               = _fjsp_madd_v2r8(vfeps,_fjsp_madd_v2r8(vfeps,H,G),F);
            FF               = _fjsp_madd_v2r8(_fjsp_madd_v2r8(twovfeps,H,G),vfeps,Fp);
            felec            = _fjsp_neg_v2r8(_fjsp_mul_v2r8(_fjsp_mul_v2r8(qq31,FF),_fjsp_mul_v2r8(vftabscale,rinv31)));

            fscal            = felec;

            fscal            = _fjsp_unpacklo_v2r8(fscal,_fjsp_setzero_v2r8());

            /* Update vectorial force */
            fix3             = _fjsp_madd_v2r8(dx31,fscal,fix3);
            fiy3             = _fjsp_madd_v2r8(dy31,fscal,fiy3);
            fiz3             = _fjsp_madd_v2r8(dz31,fscal,fiz3);
            
            fjx1             = _fjsp_madd_v2r8(dx31,fscal,fjx1);
            fjy1             = _fjsp_madd_v2r8(dy31,fscal,fjy1);
            fjz1             = _fjsp_madd_v2r8(dz31,fscal,fjz1);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r32              = _fjsp_mul_v2r8(rsq32,rinv32);

            /* Calculate table index by multiplying r with table scale and truncate to integer */
            rt               = _fjsp_mul_v2r8(r32,vftabscale);
            itab_tmp         = _fjsp_dtox_v2r8(rt);
            vfeps            = _fjsp_sub_v2r8(rt, _fjsp_xtod_v2r8(itab_tmp));
            twovfeps         = _fjsp_add_v2r8(vfeps,vfeps);
            _fjsp_store_v2r8(&vfconv.simd,itab_tmp);

            vfconv.i[0]     *= 4;
            vfconv.i[1]     *= 4;

            /* CUBIC SPLINE TABLE ELECTROSTATICS */
            Y                = _fjsp_load_v2r8( vftab + vfconv.i[0] );
            F                = _fjsp_setzero_v2r8();
            GMX_FJSP_TRANSPOSE2_V2R8(Y,F);
            G                = _fjsp_load_v2r8( vftab + vfconv.i[0] +2);
            H                = _fjsp_setzero_v2r8();
            GMX_FJSP_TRANSPOSE2_V2R8(G,H);
            Fp               = _fjsp_madd_v2r8(vfeps,_fjsp_madd_v2r8(vfeps,H,G),F);
            FF               = _fjsp_madd_v2r8(_fjsp_madd_v2r8(twovfeps,H,G),vfeps,Fp);
            felec            = _fjsp_neg_v2r8(_fjsp_mul_v2r8(_fjsp_mul_v2r8(qq32,FF),_fjsp_mul_v2r8(vftabscale,rinv32)));

            fscal            = felec;

            fscal            = _fjsp_unpacklo_v2r8(fscal,_fjsp_setzero_v2r8());

            /* Update vectorial force */
            fix3             = _fjsp_madd_v2r8(dx32,fscal,fix3);
            fiy3             = _fjsp_madd_v2r8(dy32,fscal,fiy3);
            fiz3             = _fjsp_madd_v2r8(dz32,fscal,fiz3);
            
            fjx2             = _fjsp_madd_v2r8(dx32,fscal,fjx2);
            fjy2             = _fjsp_madd_v2r8(dy32,fscal,fjy2);
            fjz2             = _fjsp_madd_v2r8(dz32,fscal,fjz2);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            r33              = _fjsp_mul_v2r8(rsq33,rinv33);

            /* Calculate table index by multiplying r with table scale and truncate to integer */
            rt               = _fjsp_mul_v2r8(r33,vftabscale);
            itab_tmp         = _fjsp_dtox_v2r8(rt);
            vfeps            = _fjsp_sub_v2r8(rt, _fjsp_xtod_v2r8(itab_tmp));
            twovfeps         = _fjsp_add_v2r8(vfeps,vfeps);
            _fjsp_store_v2r8(&vfconv.simd,itab_tmp);

            vfconv.i[0]     *= 4;
            vfconv.i[1]     *= 4;

            /* CUBIC SPLINE TABLE ELECTROSTATICS */
            Y                = _fjsp_load_v2r8( vftab + vfconv.i[0] );
            F                = _fjsp_setzero_v2r8();
            GMX_FJSP_TRANSPOSE2_V2R8(Y,F);
            G                = _fjsp_load_v2r8( vftab + vfconv.i[0] +2);
            H                = _fjsp_setzero_v2r8();
            GMX_FJSP_TRANSPOSE2_V2R8(G,H);
            Fp               = _fjsp_madd_v2r8(vfeps,_fjsp_madd_v2r8(vfeps,H,G),F);
            FF               = _fjsp_madd_v2r8(_fjsp_madd_v2r8(twovfeps,H,G),vfeps,Fp);
            felec            = _fjsp_neg_v2r8(_fjsp_mul_v2r8(_fjsp_mul_v2r8(qq33,FF),_fjsp_mul_v2r8(vftabscale,rinv33)));

            fscal            = felec;

            fscal            = _fjsp_unpacklo_v2r8(fscal,_fjsp_setzero_v2r8());

            /* Update vectorial force */
            fix3             = _fjsp_madd_v2r8(dx33,fscal,fix3);
            fiy3             = _fjsp_madd_v2r8(dy33,fscal,fiy3);
            fiz3             = _fjsp_madd_v2r8(dz33,fscal,fiz3);
            
            fjx3             = _fjsp_madd_v2r8(dx33,fscal,fjx3);
            fjy3             = _fjsp_madd_v2r8(dy33,fscal,fjy3);
            fjz3             = _fjsp_madd_v2r8(dz33,fscal,fjz3);

            gmx_fjsp_decrement_4rvec_1ptr_swizzle_v2r8(f+j_coord_offsetA,fjx0,fjy0,fjz0,fjx1,fjy1,fjz1,fjx2,fjy2,fjz2,fjx3,fjy3,fjz3);

            /* Inner loop uses 411 flops */
        }

        /* End of innermost loop */

        gmx_fjsp_update_iforce_4atom_swizzle_v2r8(fix0,fiy0,fiz0,fix1,fiy1,fiz1,fix2,fiy2,fiz2,fix3,fiy3,fiz3,
                                              f+i_coord_offset,fshift+i_shift_offset);

        /* Increment number of inner iterations */
        inneriter                  += j_index_end - j_index_start;

        /* Outer loop uses 24 flops */
    }

    /* Increment number of outer iterations */
    outeriter        += nri;

    /* Update outer/inner flops */

    inc_nrnb(nrnb,eNR_NBKERNEL_ELEC_VDW_W4W4_F,outeriter*24 + inneriter*411);
}
