{-# LANGUAGE ForeignFunctionInterface #-}

#include <bindings.dsl.h>
#include <nettle/des.h>

module Bindings.Nettle.Cipher.DES where
#strict_import

#num DES_BLOCK_SIZE
#num DES_KEY_SIZE

#starttype struct des_ctx
#stoptype

#ccall des_set_key , Ptr <struct des_ctx> -> Ptr CUChar -> IO ()
#ccall des_encrypt , Ptr <struct des_ctx> -> CUInt -> Ptr CUChar -> Ptr CUChar -> IO ()
#ccall des_decrypt , Ptr <struct des_ctx> -> CUInt -> Ptr CUChar -> Ptr CUChar -> IO ()
#ccall des_check_parity , CUInt -> Ptr CUChar -> IO ()
#ccall des_fix_parity , CUInt -> Ptr CUChar -> Ptr CUChar -> IO ()

#num DES3_BLOCK_SIZE
#num DES3_KEY_SIZE

#starttype struct des3_ctx
#stoptype

#ccall des3_set_key , Ptr <struct des3_ctx> -> Ptr CUChar -> IO ()
#ccall des3_encrypt , Ptr <struct des3_ctx> -> CUInt -> Ptr CUChar -> Ptr CUChar -> IO ()
#ccall des3_decrypt , Ptr <struct des3_ctx> -> CUInt -> Ptr CUChar -> Ptr CUChar -> IO ()

