module Main(main) where

import Codec.Utils
import Data.Digest.SHA1(hash,Word160(Word160))
import Codec.Encryption.RSA.MGF
import Codec.Encryption.RSA.EMEOAEP
import Codec.Encryption.RSA
import Test.HUnit

n :: [Octet]
n =
   [0xbb, 0xf8, 0x2f, 0x09, 0x06, 0x82, 0xce, 0x9c, 
    0x23, 0x38, 0xac, 0x2b, 0x9d, 0xa8, 0x71, 0xf7,
    0x36, 0x8d, 0x07, 0xee, 0xd4, 0x10, 0x43, 0xa4,
    0x40, 0xd6, 0xb6, 0xf0, 0x74, 0x54, 0xf5, 0x1f,
    0xb8, 0xdf, 0xba, 0xaf, 0x03, 0x5c, 0x02, 0xab,
    0x61, 0xea, 0x48, 0xce, 0xeb, 0x6f, 0xcd, 0x48,
    0x76, 0xed, 0x52, 0x0d, 0x60, 0xe1, 0xec, 0x46,
    0x19, 0x71, 0x9d, 0x8a, 0x5b, 0x8b, 0x80, 0x7f,
    0xaf, 0xb8, 0xe0, 0xa3, 0xdf, 0xc7, 0x37, 0x72,
    0x3e, 0xe6, 0xb4, 0xb7, 0xd9, 0x3a, 0x25, 0x84,
    0xee, 0x6a, 0x64, 0x9d, 0x06, 0x09, 0x53, 0x74,
    0x88, 0x34, 0xb2, 0x45, 0x45, 0x98, 0x39, 0x4e,
    0xe0, 0xaa, 0xb1, 0x2d, 0x7b, 0x61, 0xa5, 0x1f,
    0x52, 0x7a, 0x9a, 0x41, 0xf6, 0xc1, 0x68, 0x7f,
    0xe2, 0x53, 0x72, 0x98, 0xca, 0x2a, 0x8f, 0x59, 
    0x46, 0xf8, 0xe5, 0xfd, 0x09, 0x1d, 0xbd, 0xcb]

p :: [Octet]
p = [0xee, 0xcf, 0xae, 0x81, 0xb1, 0xb9, 0xb3, 0xc9,
     0x08, 0x81, 0x0b, 0x10, 0xa1, 0xb5, 0x60, 0x01,
     0x99, 0xeb, 0x9f, 0x44, 0xae, 0xf4, 0xfd, 0xa4, 
     0x93, 0xb8, 0x1a, 0x9e, 0x3d, 0x84, 0xf6, 0x32,
     0x12, 0x4e, 0xf0, 0x23, 0x6e, 0x5d, 0x1e, 0x3b, 
     0x7e, 0x28, 0xfa, 0xe7, 0xaa, 0x04, 0x0a, 0x2d,
     0x5b, 0x25, 0x21, 0x76, 0x45, 0x9d, 0x1f, 0x39, 
     0x75, 0x41, 0xba, 0x2a, 0x58, 0xfb, 0x65, 0x99]

q :: [Octet]
q = [0xc9, 0x7f, 0xb1, 0xf0, 0x27, 0xf4, 0x53, 0xf6, 
     0x34, 0x12, 0x33, 0xea, 0xaa, 0xd1, 0xd9, 0x35,
     0x3f, 0x6c, 0x42, 0xd0, 0x88, 0x66, 0xb1, 0xd0, 
     0x5a, 0x0f, 0x20, 0x35, 0x02, 0x8b, 0x9d, 0x86,
     0x98, 0x40, 0xb4, 0x16, 0x66, 0xb4, 0x2e, 0x92, 
     0xea, 0x0d, 0xa3, 0xb4, 0x32, 0x04, 0xb5, 0xcf,
     0xce, 0x33, 0x52, 0x52, 0x4d, 0x04, 0x16, 0xa5, 
     0xa4, 0x41, 0xe7, 0x00, 0xaf, 0x46, 0x15, 0x03]

popTest = 
   TestCase (
      assertEqual "Product of Primes"
                  (fromOctets 256 n) 
                  ((fromOctets 256 p)*(fromOctets 256 q))
   )

d :: [Octet]
d = [0xa5, 0xda, 0xfc, 0x53, 0x41, 0xfa, 0xf2,
     0x89, 0xc4, 0xb9, 0x88, 0xdb, 0x30, 0xc1, 0xcd,
     0xf8, 0x3f, 0x31, 0x25, 0x1e, 0x06, 0x68, 0xb4,
     0x27, 0x84, 0x81, 0x38, 0x01, 0x57, 0x96, 0x41,
     0xb2, 0x94, 0x10, 0xb3, 0xc7, 0x99, 0x8d, 0x6b,
     0xc4, 0x65, 0x74, 0x5e, 0x5c, 0x39, 0x26, 0x69,
     0xd6, 0x87, 0x0d, 0xa2, 0xc0, 0x82, 0xa9, 0x39,
     0xe3, 0x7f, 0xdc, 0xb8, 0x2e, 0xc9, 0x3e, 0xda,
     0xc9, 0x7f, 0xf3, 0xad, 0x59, 0x50, 0xac, 0xcf,
     0xbc, 0x11, 0x1c, 0x76, 0xf1, 0xa9, 0x52, 0x94,
     0x44, 0xe5, 0x6a, 0xaf, 0x68, 0xc5, 0x6c, 0x09,
     0x2c, 0xd3, 0x8d, 0xc3, 0xbe, 0xf5, 0xd2, 0x0a,
     0x93, 0x99, 0x26, 0xed, 0x4f, 0x74, 0xa1, 0x3e,
     0xdd, 0xfb, 0xe1, 0xa1, 0xce, 0xcc, 0x48, 0x94,
     0xaf, 0x94, 0x28, 0xc2, 0xb7, 0xb8, 0x88, 0x3f,
     0xe4, 0x46, 0x3a, 0x4b, 0xc8, 0x5b, 0x1c, 0xb3,
     0xc1]

dP :: [Octet]
dP = [0x54, 0x49, 0x4c, 0xa6, 0x3e, 0xba, 0x03, 0x37,
      0xe4, 0xe2, 0x40, 0x23, 0xfc, 0xd6, 0x9a, 0x5a,
      0xeb, 0x07, 0xdd, 0xdc, 0x01, 0x83, 0xa4, 0xd0, 
      0xac, 0x9b, 0x54, 0xb0, 0x51, 0xf2, 0xb1, 0x3e,
      0xd9, 0x49, 0x09, 0x75, 0xea, 0xb7, 0x74, 0x14, 
      0xff, 0x59, 0xc1, 0xf7, 0x69, 0x2e, 0x9a, 0x2e,
      0x20, 0x2b, 0x38, 0xfc, 0x91, 0x0a, 0x47, 0x41, 
      0x74, 0xad, 0xc9, 0x3c, 0x1f, 0x67, 0xc9, 0x81]

exponent1 = 
  toOctets 256 $ (fromOctets 256 d) `mod` ((fromOctets 256 p) - 1)

e1Test = 
   TestCase (
      assertEqual "Exponent" dP exponent1
   )

dQ :: [Octet]
dQ = [0x47, 0x1e, 0x02, 0x90, 0xff, 0x0a, 0xf0, 0x75, 
      0x03, 0x51, 0xb7, 0xf8, 0x78, 0x86, 0x4c, 0xa9,
      0x61, 0xad, 0xbd, 0x3a, 0x8a, 0x7e, 0x99, 0x1c, 
      0x5c, 0x05, 0x56, 0xa9, 0x4c, 0x31, 0x46, 0xa7,
      0xf9, 0x80, 0x3f, 0x8f, 0x6f, 0x8a, 0xe3, 0x42, 
      0xe9, 0x31, 0xfd, 0x8a, 0xe4, 0x7a, 0x22, 0x0d,
      0x1b, 0x99, 0xa4, 0x95, 0x84, 0x98, 0x07, 0xfe, 
      0x39, 0xf9, 0x24, 0x5a, 0x98, 0x36, 0xda, 0x3d]

m :: [Octet]
m = [0xd4, 0x36, 0xe9, 0x95, 0x69, 0xfd, 0x32, 0xa7,
     0xc8, 0xa0, 0x5b, 0xbc, 0x90, 0xd3, 0x2c, 0x49]

seed :: [Octet]
seed = [0xaa, 0xfd, 0x12, 0xf6, 0x59, 0xca, 0xe6, 0x34,
        0x89, 0xb4, 0x79, 0xe5, 0x07, 0x6d, 0xde, 0xc2, 
        0xf0, 0x6c, 0xb5, 0x8f]

e :: [Octet]
e = [0x11]

hash' xs = let (Word160 a b c d e) = hash xs in concatMap (toOctets 256) [a,b,c,d,e]

encodedText = encode mgf hash' [] seed n m

decodedText = decode mgf hash' [] encodedText

encodingTest = 
   TestCase (
      assertEqual "Encoding / Decoding" m decodedText
   )

cipherText = encrypt (n,e) encodedText

plainText = decrypt (n,d) cipherText

decodedText' = decode mgf hash' [] plainText

encryptionTest = 
   TestCase (
      assertEqual "Encrypting / Decrypting" m decodedText
   )

tests = TestList [popTest, e1Test, encodingTest, encryptionTest]

main = runTestTT tests
