/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.scriptio;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.zip.GZIPInputStream;
import org.hsqldb.Database;
import org.hsqldb.Session;
import org.hsqldb.error.Error;
import org.hsqldb.lib.LineReader;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.persist.Crypto;
import org.hsqldb.rowio.RowInputTextLog;
import org.hsqldb.scriptio.ScriptReaderText;

public class ScriptReaderDecode
extends ScriptReaderText {
    DataInputStream dataInput;
    Crypto crypto;
    byte[] buffer = new byte[256];

    public ScriptReaderDecode(Database database, String string, Crypto crypto, boolean bl) throws IOException {
        this(database, database.logger.getFileAccess().openInputStreamElement(string), crypto, bl);
    }

    public ScriptReaderDecode(Database database, InputStream inputStream, Crypto crypto, boolean bl) throws IOException {
        super(database);
        this.crypto = crypto;
        this.rowIn = new RowInputTextLog();
        if (bl) {
            this.dataInput = new DataInputStream(new BufferedInputStream(inputStream));
        } else {
            InputStream inputStream2 = crypto.getInputStream(new BufferedInputStream(inputStream));
            inputStream2 = new GZIPInputStream(inputStream2);
            this.dataStreamIn = new LineReader(inputStream2, "ISO-8859-1");
        }
    }

    @Override
    public boolean readLoggedStatement(Session session) {
        String string;
        int n;
        if (this.dataInput == null) {
            return super.readLoggedStatement(session);
        }
        try {
            n = this.dataInput.readInt();
            if (n * 2 > this.buffer.length) {
                this.buffer = new byte[n * 2];
            }
            this.dataInput.readFully(this.buffer, 0, n);
        }
        catch (Throwable throwable) {
            return false;
        }
        n = this.crypto.decode(this.buffer, 0, n, this.buffer, 0);
        try {
            string = new String(this.buffer, 0, n, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw Error.error(unsupportedEncodingException, 452, null);
        }
        ++this.lineCount;
        this.statement = StringConverter.unicodeStringToString(string);
        if (this.statement == null) {
            return false;
        }
        this.processStatement(session);
        return true;
    }

    @Override
    public void close() {
        try {
            if (this.dataStreamIn != null) {
                this.dataStreamIn.close();
            }
            if (this.dataInput != null) {
                this.dataInput.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

