/* IMSpector - Instant Messenger Transparent Proxy Service
 * http://www.imspector.org/
 * (c) Lawrence Manning <lawrence@aslak.net>, 2006
 *          
 * Released under the GPL v2. */

#include "imspector.h"

#define PLUGIN_NAME "Misc IMSpector filter plugin"
#define PLUGIN_SHORT_NAME "Misc"

extern "C"
{
	bool initfilterplugin(struct filterplugininfo &filterplugininfo,
		class Options &options, bool debugmode);
	void closefilterplugin(void);
	bool filter(char *originalbuffer, char *modifiedbuffer, struct imevent &imevent);
};

bool blockfiles = false;
bool blockwebcams = false;
bool localdebugmode = false;

bool initfilterplugin(struct filterplugininfo &filterplugininfo,
	class Options &options, bool debugmode)
{
	localdebugmode = debugmode;

	filterplugininfo.pluginname = PLUGIN_NAME;
		
	if (options["block_files"] == "on")
	{
		blockfiles = true;
		debugprint(localdebugmode, PLUGIN_SHORT_NAME ": Blocking all file transfers");
	}
	if (options["block_webcams"] == "on")
	{
		blockwebcams = true;
		debugprint(localdebugmode, PLUGIN_SHORT_NAME ": Blocking all webcams");
	}

	/* Neither is enabled, so disable plugin. */
	if (!blockwebcams && !blockfiles) return false;

	return true;
}

void closefilterplugin(void)
{
	return;
}

/* The main plugin function. See eventplugin.cpp. */
bool filter(char *originalbuffer, char *modifiedbuffer, struct imevent &imevent)
{
	bool filtered = false;

	if ((imevent.type == TYPE_WEBCAM && blockwebcams) ||
		(imevent.type == TYPE_FILE && blockfiles))
	{
		filtered = true;
	}
	
	debugprint(localdebugmode, PLUGIN_SHORT_NAME ": Filtering: %d", filtered);
	
	return filtered;
}
