/*
 The MIT License

 Copyright (c) 2004-2013 Paul R. Holser, Jr.

 Permission is hereby granted, free of charge, to any person obtaining
 a copy of this software and associated documentation files (the
 "Software"), to deal in the Software without restriction, including
 without limitation the rights to use, copy, modify, merge, publish,
 distribute, sublicense, and/or sell copies of the Software, and to
 permit persons to whom the Software is furnished to do so, subject to
 the following conditions:

 The above copyright notice and this permission notice shall be
 included in all copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

package joptsimple;

import static java.util.Collections.*;

/**
 * Thrown when the option parser detects an unacceptable number of {@code linkplain NonOptionArgumentSpec
 * non-option arguments}.
 *
 * @author <a href="mailto:pholser@alumni.rice.edu">Paul Holser</a>
 */
class UnacceptableNumberOfNonOptionsException extends OptionException {
    private static final long serialVersionUID = -1L;
    private final int minimum;
    private final int maximum;
    private final int actual;

    UnacceptableNumberOfNonOptionsException( int minimum, int maximum, int actual ) {
        super( singletonList( NonOptionArgumentSpec.NAME ) );

        this.minimum = minimum;
        this.maximum = maximum;
        this.actual = actual;
    }

    @Override
    public String getMessage() {
        return String.format( "actual = %d, minimum = %d, maximum = %d", actual, minimum, maximum );
    }
}
