
/*!
 * \file
 * \ingroup db
 * \brief Database support for modules.
 *
 * Database support functions for modules.
 *
 * @cond
 * WARNING:
 * This file was autogenerated from the XML source file
 * ../../modules/matrix/kamailio-matrix.xml.
 * It can be regenerated by running 'make modules' in the db/schema
 * directory of the source code. You need to have xsltproc and
 * docbook-xsl stylesheets installed.
 * ALL CHANGES DONE HERE WILL BE LOST IF THE FILE IS REGENERATED
 * @endcond
 */

#ifndef db_matrix_h
#define db_matrix_h


/* necessary includes */
#include "../../lib/srdb1/db.h"
#include "../../core/str.h"
#include "../../core/ut.h"

#include <string.h>


/* database variables */

extern str matrix_db_url;
extern db1_con_t * matrix_dbh;
extern db_func_t matrix_dbf;

#define matrix_DB_URL { "db_url", PARAM_STR, &matrix_db_url },

#define matrix_DB_TABLE { "matrix_table", PARAM_STR, &matrix_table },

extern str matrix_table;

/* column names */
extern str matrix_first_col;
extern str matrix_second_col;
extern str matrix_res_col;
#define matrix_DB_COLS \
{ "matrix_first_col", PARAM_STR, &matrix_first_col }, \
{ "matrix_second_col", PARAM_STR, &matrix_second_col }, \
{ "matrix_res_col", PARAM_STR, &matrix_res_col }, \

/* table version */
extern const unsigned int matrix_version;


/*
 * Closes the DB connection.
 */
void matrix_db_close(void);

/*!
 * Initialises the DB API, check the table version and closes the connection.
 * This should be called from the mod_init function.
 *
 * \return 0 means ok, -1 means an error occurred.
 */
int matrix_db_init(void);

/*!
 * Initialize the DB connection without checking the table version and DB URL.
 * This should be called from child_init. An already existing database
 * connection will be closed, and a new one created.
 *
 * \return 0 means ok, -1 means an error occurred.
 */
int matrix_db_open(void);

#endif
