module Portability64 where

import Lib
import System.IO
import System.Environment
import qualified Data.Map as Map

-- GHC 6.4 and above library incompatibilities.

environment :: String -> IO (Maybe String)
environment x = catch (do e <- getEnv x
		          return (Just e))
		      (\_ -> return Nothing)

tempfile :: IO (FilePath, Handle)
tempfile = do env <- environment "TMPDIR"
	      let dir = case env of
		    Nothing -> tmpdir
		    (Just d) -> d
	      openTempFile tmpdir "kaya"

type Dict k v = Map.Map k v

dictInsert :: Ord k => k -> v -> Dict k v -> Dict k v
dictInsert = Map.insert
dictElems = Map.elems
dictEmpty = Map.empty

dictLookup :: Ord k => k -> Dict k v -> Maybe v
dictLookup = Map.lookup
