/***************************************************************************
 *   Copyright (C) 2006-2007 by Julien Lemoine, Simon Viennot              *
 *   lapinot@tuxfamily.org                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "widgetprincipal.h"

#include <QtGui>

/*-------------------------------------------------------------------------------------------------
// Widget Principal
//-----------------------------------------------------------------------------------------------*/

Principal::Principal( QWidget *parent ) : QMainWindow( parent ) {
	//Dfinition des textes affichs
	//la classe Principal possde la macro Q_OBJECT et donc peut faire des appels  tr
	texte_version="Kitsune "+ global::numero_version;
	texte_renard_repos=tr("Kitsune");
	texte_renard_ceb=tr("Le compte est bon !");
	texte_renard_pds=tr("Il n'y a pas de solution.");
	texte_renard_gagne=tr("Gagn !");
	texte_renard_perdu=tr("Perdu.");
	texte_statut_attente=tr("En attente.");
	texte_statut_en_cours=tr("Calcul en cours...");
	texte_statut_duree=tr("Dure du calcul : ");
	
	//mapper pour la lecture de fichiers textes
	lireTexte_Mapper=new QSignalMapper(this);
	connect( lireTexte_Mapper, SIGNAL(mapped(int)), this, SLOT(lire_texte(int)) );
	
	//barre de titre
	setWindowTitle(QString(tr("Kitsune")));
	
	//Barre de menus
	QMenuBar *MenuBar = new QMenuBar( this );
	setMenuBar(MenuBar);
	MenuBar->setFont( font_normal );
	
	QMenu *fichierMenu = new QMenu ( this );
	QMenu *infoMenu = new QMenu ( this );
	
	QAction *optionsAction = new QAction( this );
	QAction *fileExitAction = new QAction( this );
	
	fichierMenu = menuBar()->addMenu(tr("&Fichier"));
	fichierMenu->addAction(optionsAction);
	fichierMenu->addAction(fileExitAction);
	fichierMenu->setFont( font_normal );
	
	QAction *helpAideAction = new QAction( this );
	QAction *helpLicenceAction = new QAction( this );
	QAction *helpAboutAction = new QAction( this );
	infoMenu = menuBar()->addMenu(tr("&Info"));
	infoMenu->setFont( font_normal );
	infoMenu->addAction(helpAideAction);
	infoMenu->addAction(helpLicenceAction);
	infoMenu->addAction(helpAboutAction);
	
	//initialisation des menus
	fileExitAction->setText(tr("&Quitter"));
	optionsAction->setText(tr("&Options"));
	helpAideAction->setText(tr("Ai&de"));
	helpLicenceAction->setText(tr("&Licence"));
	helpAboutAction->setText(tr("A &propos"));
	
	//fonctions de connexion signal<--->slot
	//fonctions pour la barre de menus
	connect( fileExitAction, SIGNAL( triggered() ), this, SLOT( close() ) );
	connect( optionsAction, SIGNAL( triggered() ), this, SLOT( options() ) );
	connect( helpAideAction, SIGNAL( triggered() ), lireTexte_Mapper, SLOT(map()) );
	connect( helpLicenceAction, SIGNAL( triggered() ), lireTexte_Mapper, SLOT(map()) );
	connect( helpAboutAction, SIGNAL( triggered() ), lireTexte_Mapper, SLOT(map()) );
	lireTexte_Mapper->setMapping(helpAideAction, 2);
	lireTexte_Mapper->setMapping(helpLicenceAction, 1);
	lireTexte_Mapper->setMapping(helpAboutAction, 0);
	
	//Pour la barre de statut, temps de calcul
	heure = new QTime();
	
	//Widget horizontal parent
	QWidget *hbox = new QWidget( this );
	QHBoxLayout *hboxLayout = new QHBoxLayout( hbox );
	
	hboxLayout->setSpacing(1);
	hboxLayout->setMargin(1);
	
	setCentralWidget(hbox);
	
	//Bote verticale contenant tous les lments de la gauche de la fentre
	QWidget *vboxA = new QWidget( hbox );
	QVBoxLayout *vboxLayoutA = new QVBoxLayout( vboxA );
	
	vboxA->setFixedWidth(288);
	vboxLayoutA->setSpacing(0);
	vboxLayoutA->setMargin(0);
	
	//Bote verticale contenant tous les lments du milieu de la fentre
	QWidget *vboxB = new QWidget( hbox );
	QVBoxLayout *vboxLayoutB = new QVBoxLayout( vboxB );
	
	vboxLayoutB->setSpacing(0);
	vboxLayoutB->setMargin(0);
	vboxB->setFixedWidth(200);
	
	//cadre de texte pour les rsultats, colonne de droite
	textEditC = new QTextEdit( hbox );
	textEditC->setReadOnly( TRUE );
	textEditC->setFixedWidth(288);
	textEditC->setFont( font_monospace );
	
	//insertion des widgets dans le layout
	hboxLayout->addStretch( 1 );
	hboxLayout->addWidget( vboxA );
	hboxLayout->addStretch( 1 );
	hboxLayout->addWidget( vboxB );
	hboxLayout->addStretch( 1 );
	hboxLayout->addWidget( textEditC );
	hboxLayout->addStretch( 1 );
	
	//----------Colonne de gauche--------------------------------------------------------------
	//Widgets aligns verticalement  gauche
	QWidget *horLayout1 = new QWidget( vboxA );
	QHBoxLayout *hboxLayout1 = new QHBoxLayout(horLayout1);
	hboxLayout1->setSpacing(0);
	hboxLayout1->setMargin(0);
	QWidget *horLayout2 = new QWidget( vboxA );
	QHBoxLayout *hboxLayout2 = new QHBoxLayout(horLayout2);
	hboxLayout2->setSpacing(0);
	hboxLayout2->setMargin(0);
	QWidget *horLayout3 = new QWidget( vboxA );
	QHBoxLayout *hboxLayout3 = new QHBoxLayout(horLayout3);
	hboxLayout3->setSpacing(0);
	hboxLayout3->setMargin(0);
	resol= new WidgetResolution(horLayout3);
	//barre de progression pour le temps
	horloge=new WidgetHorloge( vboxA );
	horloge->setFixedHeight( 15 );
	BarreStatut = new QStatusBar ( vboxA );
	
	//insertion des widgets dans le layout
	vboxLayoutA->addStretch( 1 );
	vboxLayoutA->addWidget( horLayout1 );
	vboxLayoutA->addWidget( horLayout2 );
	vboxLayoutA->addWidget( horLayout3 );
	vboxLayoutA->addSpacing( 5 );
	vboxLayoutA->addWidget( horloge );
	vboxLayoutA->addWidget( BarreStatut );
	vboxLayoutA->addStretch( 1 );
	
	//premire ligne : le compte + les modifieurs
	//WidgetPlaque 10, 11 et 12
	hboxLayout1->addStretch( 1 );
	
	for(int Wi=0; Wi<3; Wi++) {
		WidgetPlaque *plaque= new WidgetPlaque(horLayout1, Wi+10, 0);
		hboxLayout1->addWidget( plaque );
		connect( this, SIGNAL(refresh(int, int)), plaque, SLOT(displayRefresh(int, int)) );
		connect( plaque, SIGNAL(change(int, bool)), this, SLOT(compte_change(int, bool)) );
		connect( this, SIGNAL(plaqueReglable(bool)), plaque, SLOT(estReglable(bool)) );
	}
	
	hboxLayout1->addStretch( 1 );
	
	//deuxime ligne : les plaques + les modifieurs
	horLayout2->setFixedHeight( 43 );
	
	for(int Wi=0; Wi<6; Wi++) {
		WidgetPlaque *plaque= new WidgetPlaque(horLayout2, Wi, 1);
		hboxLayout2->addWidget( plaque );
		connect( this, SIGNAL(refresh(int, int)), plaque, SLOT(displayRefresh(int, int)) );
		connect( this, SIGNAL(changeEtat(int, int)), plaque, SLOT(updateEtat(int, int)) );
		connect( resol, SIGNAL(changeEtat(int, int)), plaque, SLOT(updateEtat(int, int)) );
		connect( plaque, SIGNAL(change(int, bool)), this, SLOT(tirage_change(int, bool)) );
		connect( this, SIGNAL(plaqueReglable(bool)), plaque, SLOT(estReglable(bool)) );
		connect( plaque, SIGNAL(valeur(int,int)), resol, SLOT(gestionPlaque(int,int)) );
	}
	
	//troisime ligne : le widget de rsolution
	hboxLayout3->addStretch( 1 );
	hboxLayout3->addWidget( resol );
	hboxLayout3->addStretch( 1 );
	
	connect( resol, SIGNAL(la_victoire()), this, SLOT(victoire()) );
	
	//cinquime ligne : la barre de statut
	BarreStatut->setSizeGripEnabled ( false );
	BarreStatut->setFont( font_normal );
	
	connect( horloge, SIGNAL(TempsEpuise()), this, SLOT(defaite()) );
	
	//----------Deuxime colonne---------------------------------------------------------------
	
	//image du renard
	QWidget *horLayoutB1 = new QWidget( vboxB );
	QHBoxLayout *hboxLayoutB1 = new QHBoxLayout(horLayoutB1);
	hboxLayoutB1->setSpacing(0);
	hboxLayoutB1->setMargin(0);
	
	horLayoutB1->setFixedHeight(150);
	
	pixmapLabelRenard = new QLabel( horLayoutB1 );
	renard_normal = new QPixmap(":/images/normal-150x150.png");
	renard_heureux = new QPixmap(":/images/heureux-150x150.png");
	renard_triste = new QPixmap(":/images/triste-150x150.png");
	pixmapLabelRenard->setFixedSize( 150, 150 );
	
	hboxLayoutB1->addStretch( 1 );
	hboxLayoutB1->addWidget(pixmapLabelRenard);
	hboxLayoutB1->addStretch( 1 );
	
	//le texte sous le renard
	texte_renard = new QLabel( vboxB );
	texte_renard->setFont( font_gros );
	texte_renard->setAlignment( Qt::AlignHCenter );
	
	//les boutons
	pbJouer = new QPushButton(tr("Jouer"), vboxB );
	pbRes = new QPushButton(tr("Rsoudre"), vboxB );
	pbAlea = new QPushButton(tr("Alatoire"), vboxB );
	pbZero = new QPushButton(tr("Mise  zro"), vboxB );
	
	pbJouer->setFont( font_normal );
	pbRes->setFont( font_normal );
	pbAlea->setFont( font_normal );
	pbZero->setFont( font_normal );
	pbJouer->setFixedWidth( 100 );
	pbRes->setFixedWidth( 100 );
	pbAlea->setFixedWidth( 100 );
	pbZero->setFixedWidth( 100 );
	
	//au dmarrage de l'application, le focus est positionn sur le bouton "alatoire"
	pbAlea->setFocus();
	
	//insertion des widgets dans le layout
	vboxLayoutB->addStretch( 3 );
	vboxLayoutB->addWidget( horLayoutB1 );
	vboxLayoutB->addWidget( texte_renard );
	vboxLayoutB->addStretch( 3 );
	vboxLayoutB->addWidget( pbJouer );
	vboxLayoutB->addStretch( 1 );
	vboxLayoutB->addWidget( pbAlea );
	vboxLayoutB->addStretch( 1 );
	vboxLayoutB->addWidget( pbRes );
	vboxLayoutB->addStretch( 1 );
	vboxLayoutB->addWidget( pbZero );
	vboxLayoutB->addStretch( 3 );
	
	vboxLayoutB->setAlignment(pbJouer,Qt::AlignHCenter);
	vboxLayoutB->setAlignment(pbRes,Qt::AlignHCenter);
	vboxLayoutB->setAlignment(pbAlea,Qt::AlignHCenter);
	vboxLayoutB->setAlignment(pbZero,Qt::AlignHCenter);
	
	//----------Initialisations----------------------------------------------------------------
	
	//pour avoir du vrai alatoire, pas toujours les mmes valeurs
	srand (time (NULL));
	
	//l'mission du signal permet de bloquer ou de dbloquer le module de rsolution
	connect( this, SIGNAL(bloque_module(bool)), resol, SLOT(bloque_le_module(bool)) );
	
	//fonctions pour les boutons
	connect( pbJouer, SIGNAL(clicked()), this, SLOT(jouer()) );
	connect( pbRes, SIGNAL(clicked()), this, SLOT(resoudre()) );
	connect( pbAlea, SIGNAL(clicked()), this, SLOT(aleatoire()) );
	connect( pbZero, SIGNAL(clicked()), this, SLOT(mise_a_zero()) );
	
	//init et connection de la classe jeu
	J =new jeu;
	connect( J, SIGNAL(finished()), this, SLOT(fin_calcul()) );
	
	//initialisation des paramtres
	mise_a_zero();
}

/*-------------------------------------------------------------------------------------------------
// Fonctions appeles par la barre de menus en haut de l'interface
//-----------------------------------------------------------------------------------------------*/

//fonction d'ouverture pour le cochage des options
void Principal::options() {
	//note : ancien_nb_plaques est actuellement inutile car on relance l'appli lorsque le nb de plaques change
	int ancien_nb_plaques=tirage::nb_plaques;
	int ancien_compte_minimal=tirage::compte_minimal;
	int ancien_compte_maximal=tirage::compte_maximal;
	
	WidgetOptions opt( this );
	opt.exec();
	
	if(ancien_nb_plaques!=tirage::nb_plaques || ancien_compte_minimal!=tirage::compte_minimal || ancien_compte_maximal!=tirage::compte_maximal){
		mise_a_zero();
	}
}

//Fonction appele lors d'un clic dans le menu "Info"
void Principal::lire_texte(int num) {
	if(num==0) {
		//fentre " propos"
		WidgetPopup popup( this, false, QString(tr(":/txt/about-fr.html")), QString(texte_version));
		popup.exec();
	} else if(num==1) {
		//popup de licence (true)
		WidgetPopup popup( this, true, QString(tr(":/txt/licence-fr.html")), QString(tr("Licence de Kitsune")));
		popup.exec();
	} else if(num==2) {
		//fentre d'aide
		WidgetPopup popup( this, false, QString(tr(":/txt/aide-fr.html")), QString(tr("Aide")));
		popup.exec();
	}
}

/*-------------------------------------------------------------------------------------------------
// Fonctions appeles lors d'un clic sur un des boutons
//-----------------------------------------------------------------------------------------------*/

//on rsout un problme rentr manuellement
void Principal::jouer() {
	jeu_en_cours=true;
	trop_tard=false;
	textEditC->setPlainText("");		//rinitialisation de la zone des rsultats
	pbAlea->setEnabled( false );
	pbJouer->setEnabled( false );
	emit plaqueReglable( false );
	resol->init();
	reinit_plaques_tirage( false );
	reinit_statut();
	horloge->remise_a_zero();
	
	//lancement de la resolution en tache de fond
	lancement_calcul();
}

//on rsout le calcul si ce n'est pas dj fait en mmoire, et on affiche les solutions
void Principal::resoudre() {
	if(jeu_en_cours){
		emit bloque_module( true );
		emit plaqueReglable( true );
		reinit_plaques_tirage( false );
		pbJouer->setEnabled( true );
		horloge->arrete();
		defaite();
		jeu_en_cours=false;
		affiche_solutions();
	} else {
		lancement_calcul();
	}
}

//dtermination alatoire d'un nouveau problme
void Principal::aleatoire(){
	//tat de l'application
	jeu_en_cours=true;
	trop_tard=false;
	textEditC->setPlainText("");		//rinitialisation de la zone des rsultats
	pbAlea->setEnabled( false );
	pbJouer->setEnabled( false );
	emit plaqueReglable( false );
	resol->init();
	reinit_plaques_tirage( false );
	reinit_statut();
	horloge->remise_a_zero();
	
	//dtermination du nouveau compte
	liste_des_chiffres.clear();
	liste_des_chiffres.assign(3,0);
	
	int valeur_compte=tirage::compte_minimal+rand()%(tirage::compte_maximal-tirage::compte_minimal+1);
	
	liste_des_chiffres[0]=valeur_compte/100;
	liste_des_chiffres[1]=(valeur_compte/10)%10;
	liste_des_chiffres[2]=(valeur_compte)%10;
	
	//dtermination des plaques et du tirage
	t.tab.clear();
	
	pseudo_tirage pt;  //pseudo-tirage pour le calcul alatoire des plaques
	pt.assign(tirage::nb_plaques,0);
	liste_des_plaques.clear();
	liste_des_plaques.assign(tirage::nb_plaques,0);
	int i;
	int hasard;
	vector<int> v;
	v.assign(24,0);
	for(i=0;i<=23;i++){
		v[i]=i;
	}
	for(i=0;i<tirage::nb_plaques;i++){
		hasard=rand()%(24-i);
		pt[i]=v[hasard];
		v.erase(v.begin()+hasard);
		switch (pt[i]){
			case 23: liste_des_plaques[i]=100; break;
			case 22: liste_des_plaques[i]=75; break;
			case 21: liste_des_plaques[i]=50; break;
			case 20: liste_des_plaques[i]=25; break;
			default: liste_des_plaques[i]=(1+pt[i]/2); break;
		}
	}
	t=pseudo_en_tirage(pt);
	
	//lancement de la resolution en tache de fond
	lancement_calcul();
}

//remise de l'application dans l'tat initial
void Principal::mise_a_zero(){
	//tat de l'application
	jeu_en_cours=false;
	trop_tard=false;
	
	//initialisation des textes et images
	reinit_statut();
	textEditC->setPlainText("");
	resol->init();
	reinit_plaques_tirage(false);
	
	//barre de progression pour le temps coul
	horloge->arrete();
	horloge->remise_a_zero();
	
	//initialisation du compte  la valeur (compte minimal+compte maximal+1)/2
	//(+1 car on arrondit  la valeur suprieure)
	liste_des_chiffres.clear();
	liste_des_chiffres.assign(3,0);
	int tirage_par_defaut=(tirage::compte_minimal+tirage::compte_maximal+1)/2;
	liste_des_chiffres[0]=tirage_par_defaut/100;
	liste_des_chiffres[1]=(tirage_par_defaut/10)%10;
	liste_des_chiffres[2]=tirage_par_defaut%10;
	
	//initialisation des plaques
	int i;
	liste_des_plaques.clear();
	liste_des_plaques.assign(tirage::nb_plaques,0);
	for(i=0;i<tirage::nb_plaques;i++){
		liste_des_plaques[i]=i+1;
	}
	
	//initialisation du tirage
	t.tab.clear();
	for(i=1;i<=tirage::nb_plaques;i++){
		t.tab[i]++;
	}
	
	//mise  jour de l'affichage
	update_affichage_plaques();
	update_affichage_compte();
	
	//un clic sur une plaque permet de rgler sa valeur
	emit plaqueReglable( true );
	emit bloque_module( true );
	pbAlea->setEnabled( true );
	pbJouer->setEnabled( true );
}

/*-------------------------------------------------------------------------------------------------
// Fonctions pour le lancement et la fin d'un calcul
//-----------------------------------------------------------------------------------------------*/

//lance le thread de rsolution du problme
void Principal::lancement_calcul(){
	//TODO: dsactiver le clic sur les plaques du tirage
	
	//les boutons sont dsactivs le temps du calcul
	pbRes->setEnabled( false );
	pbZero->setEnabled( false );
	pbAlea->setEnabled( false );
	pbJouer->setEnabled( false );
	
	//affichage
	BarreStatut->showMessage( QString(texte_statut_en_cours) );
	setCursor( QCursor(Qt::WaitCursor));		//la souris est un sablier pendant le calcul
	
	//initialisation du compteur pour connaitre le temps de calcul
	heure->start();
	
	//calcul du compte  tudier
	compte le_compte_etudie=liste_des_chiffres[0]*100+liste_des_chiffres[1]*10+liste_des_chiffres[2];
	
	//tude du tirage
	J->init(t,le_compte_etudie,le_compte_etudie);
	J->start();	//lance etude_tirage sous forme d'un thread
}

//appel automatiquement en fin de calcul (connect au signal J.finished)
void Principal::fin_calcul() {
	//calcul termin => on rtablit la flche de la souris
	setCursor( QCursor(Qt::ArrowCursor));
	
	affiche_temps_de_calcul();
	
	if(jeu_en_cours){
		//mise  jour de l'affichage
		update_affichage_compte();
		update_affichage_plaques();
		
		//on indique la meilleure solution possible au widget de rsolution
		int dist=J->distance_a_la_solution();
		resol->cible.first=J->lim_inf-dist;	//J->lim_inf stocke le compte tudi
		resol->cible.second=J->lim_inf+dist;
		
		//on dbloque le widget de rsolution
		emit bloque_module( false );
		reinit_plaques_tirage( true );
		
		horloge->lance();		//le compte  rebours commence
	} else {
		affiche_solutions();
		renard_apres_calcul();
		//boutons ractivs
		pbAlea->setEnabled( true );
		pbJouer->setEnabled( true );
	}
	
	//boutons ractivs
	pbRes->setEnabled( true );
	pbZero->setEnabled( true );
}

/*-------------------------------------------------------------------------------------------------
// Fonctions de mise  jour de l'affichage
//-----------------------------------------------------------------------------------------------*/

//une fonction pour mettre  jour l'affichage du compte
void Principal::update_affichage_compte() {
	for(int Wi=0; Wi<3; Wi++) {
		emit refresh(Wi+10, liste_des_chiffres[Wi]);
	}
}

//une fonction pour mettre  jour l'affichage des plaques
void Principal::update_affichage_plaques() {
	for(int Wi=0; Wi<6; Wi++) {
		emit refresh(Wi, liste_des_plaques[Wi]);
	}
}

//on rend les plaques du tirage blanches
void Principal::reinit_plaques_tirage(bool cliquable){
	int valeur=1;
	if(cliquable) {valeur=0;}
	for(int i=0;i<6;i++){
		emit changeEtat(i,valeur);
	}
}

//une fonction pour mettre  jour l'affichage du statut, du renard et du texte
void Principal::reinit_statut() {
	BarreStatut->showMessage( texte_statut_attente );
	pixmapLabelRenard->setPixmap(*renard_normal);
	texte_renard->setText( texte_renard_repos );
}

/*-------------------------------------------------------------------------------------------------
// Fonctions d'affichage des rsultats
//-----------------------------------------------------------------------------------------------*/

//le joueur a trouv le bon compte ou la meilleure approx avec le widget de rsolution
void Principal::victoire(){
	jeu_en_cours=false;
	emit bloque_module( true );
	emit plaqueReglable( true );
	reinit_plaques_tirage( false );
	affiche_solutions();
	horloge->arrete();
	pbAlea->setEnabled( true );
	pbJouer->setEnabled( true );
	
	if(!trop_tard){
		renard_apres_jeu(true);
	}
}

//le temps s'est coul avant que le joueur ait trouv le bon compte, ou il a abandonn
void Principal::defaite(){
	trop_tard=true;
	renard_apres_jeu(false);
	pbAlea->setEnabled( true );
}

//Affiche le temps que la machine a pris pour calculer les solutions dans la barre d'tat en bas de l'interface
void Principal::affiche_temps_de_calcul(){
	//dtermination du temps que le calcul a pris
	int temps_ecoule=heure->elapsed();
	
	//calcul et affichage du temps coul
	int secondes=temps_ecoule/1000;
	int centiemes=(temps_ecoule%1000)/10;
	QString resultat=QString(texte_statut_duree);
	resultat.append( QString().sprintf("%d,", secondes) );
	if(centiemes<10){		//pour viter la blague du 1.7s au lieu de 1.07s
		resultat.append( QString("0"));
	}
	resultat.append( QString().sprintf("%d s", centiemes) );
	
	BarreStatut->showMessage( resultat );
}

//affichage des solutions
void Principal::affiche_solutions() {
	//rappel du tirage et du compte
	textEditC->setPlainText("");
	textEditC->insertPlainText(QString(tr("Tirage : ")));
	textEditC->insertPlainText(QString(J->afficheProbleme().c_str()));
	textEditC->insertPlainText(QString("\n"));
	
	//rappel du compte
	textEditC->insertPlainText(QString(tr("Compte : ")));
	textEditC->insertPlainText(QString("%1").arg(J->lim_inf));
	textEditC->insertPlainText(QString("\n\n"));
	
	//affichage des rsultats dans le cadre de texte prvu  cet effet
	textEditC->insertPlainText(J->afficheBase());
}

//met  jour l'affichage du renard une fois un calcul normal termin
void Principal::renard_apres_calcul(){
	if(J->distance_a_la_solution()==0){
		texte_renard->setText( texte_renard_ceb );
		pixmapLabelRenard->setPixmap(*renard_heureux);
	}
	else{
		texte_renard->setText( texte_renard_pds );
		pixmapLabelRenard->setPixmap(*renard_triste);
	}
}

//met  jour l'affichage du renard une fois le jeu termin
void Principal::renard_apres_jeu(bool gagne){
	//petite phrase d'information en bas de la fentre + image
	if(gagne){
		texte_renard->setText( texte_renard_gagne );
		pixmapLabelRenard->setPixmap(*renard_heureux);
	}
	else{
		texte_renard->setText( texte_renard_perdu );
		pixmapLabelRenard->setPixmap(*renard_triste);
	}
}

/*-------------------------------------------------------------------------------------------------
// Fonctions de modification des plaques
//-----------------------------------------------------------------------------------------------*/

//fonction appele  chaque modification du compte
void Principal::compte_change(int numero_plaque, bool est_plus) {
	if(est_plus) {
		liste_des_chiffres[numero_plaque-10]=liste_des_chiffres[numero_plaque-10]+1;
	} else {
		liste_des_chiffres[numero_plaque-10]=liste_des_chiffres[numero_plaque-10]-1;
	}
	
	int nouveau_compte=liste_des_chiffres[0]*100+liste_des_chiffres[1]*10+liste_des_chiffres[2];
	
	if(nouveau_compte>=tirage::compte_minimal && nouveau_compte <= tirage::compte_maximal) {
		liste_des_chiffres[0]=nouveau_compte/100;
		liste_des_chiffres[1]=(nouveau_compte/10)%10;
		liste_des_chiffres[2]=(nouveau_compte)%10;
		update_affichage_compte();
		reinit_plaques_tirage( false );
		reinit_statut();
		return;
	}
	
	//annulation de la modif
	if(est_plus) {
		liste_des_chiffres[numero_plaque-10]=liste_des_chiffres[numero_plaque-10]-1;
	} else {
		liste_des_chiffres[numero_plaque-10]=liste_des_chiffres[numero_plaque-10]+1;
	}
}

//fonction appele  chaque modification d'une plaque du tirage
void Principal::tirage_change(int numero_plaque, bool est_plus) {
	plaque plaque_passee=liste_des_plaques[numero_plaque];
	plaque plaque_future=0;
	if(est_plus){
		plaque_future=plus_petite_plaque_sup(t,plaque_passee);
	} else{
		plaque_future=plus_petite_plaque_inf(t,plaque_passee);
	}
	
	if(plaque_future!=0){
		liste_des_plaques[numero_plaque]=plaque_future;
		t.tab[plaque_passee]--;
		t.tab[plaque_future]++;
	
		//affichage
		update_affichage_plaques();
		reinit_plaques_tirage( false );
		reinit_statut();
	}
}

