
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2024 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQTransform.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QTransform>
#include <QLine>
#include <QLineF>
#include <QPainterPath>
#include <QPoint>
#include <QPointF>
#include <QPolygon>
#include <QPolygonF>
#include <QRect>
#include <QRectF>
#include <QRegion>
#include "gsiQt.h"
#include "gsiQtGuiCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QTransform

//  Constructor QTransform::QTransform()


static void _init_ctor_QTransform_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QTransform> ();
}

static void _call_ctor_QTransform_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QTransform *> (new QTransform ());
}


//  Constructor QTransform::QTransform(double h11, double h12, double h13, double h21, double h22, double h23, double h31, double h32, double h33)


static void _init_ctor_QTransform_8775 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("h11");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("h12");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("h13");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h21");
  decl->add_arg<double > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("h22");
  decl->add_arg<double > (argspec_4);
  static gsi::ArgSpecBase argspec_5 ("h23");
  decl->add_arg<double > (argspec_5);
  static gsi::ArgSpecBase argspec_6 ("h31");
  decl->add_arg<double > (argspec_6);
  static gsi::ArgSpecBase argspec_7 ("h32");
  decl->add_arg<double > (argspec_7);
  static gsi::ArgSpecBase argspec_8 ("h33");
  decl->add_arg<double > (argspec_8);
  decl->set_return_new<QTransform> ();
}

static void _call_ctor_QTransform_8775 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  double arg3 = gsi::arg_reader<double >() (args, heap);
  double arg4 = gsi::arg_reader<double >() (args, heap);
  double arg5 = gsi::arg_reader<double >() (args, heap);
  double arg6 = gsi::arg_reader<double >() (args, heap);
  double arg7 = gsi::arg_reader<double >() (args, heap);
  double arg8 = gsi::arg_reader<double >() (args, heap);
  double arg9 = gsi::arg_reader<double >() (args, heap);
  ret.write<QTransform *> (new QTransform (arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9));
}


//  Constructor QTransform::QTransform(double h11, double h12, double h21, double h22, double dx, double dy)


static void _init_ctor_QTransform_5886 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("h11");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("h12");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("h21");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h22");
  decl->add_arg<double > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("dx");
  decl->add_arg<double > (argspec_4);
  static gsi::ArgSpecBase argspec_5 ("dy");
  decl->add_arg<double > (argspec_5);
  decl->set_return_new<QTransform> ();
}

static void _call_ctor_QTransform_5886 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  double arg3 = gsi::arg_reader<double >() (args, heap);
  double arg4 = gsi::arg_reader<double >() (args, heap);
  double arg5 = gsi::arg_reader<double >() (args, heap);
  double arg6 = gsi::arg_reader<double >() (args, heap);
  ret.write<QTransform *> (new QTransform (arg1, arg2, arg3, arg4, arg5, arg6));
}


//  Constructor QTransform::QTransform(const QTransform &other)


static void _init_ctor_QTransform_2350 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QTransform & > (argspec_0);
  decl->set_return_new<QTransform> ();
}

static void _call_ctor_QTransform_2350 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QTransform &arg1 = gsi::arg_reader<const QTransform & >() (args, heap);
  ret.write<QTransform *> (new QTransform (arg1));
}


// QTransform QTransform::adjoint()


static void _init_f_adjoint_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QTransform > ();
}

static void _call_f_adjoint_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QTransform > ((QTransform)((QTransform *)cls)->adjoint ());
}


// double QTransform::determinant()


static void _init_f_determinant_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_determinant_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QTransform *)cls)->determinant ());
}


// double QTransform::dx()


static void _init_f_dx_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_dx_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QTransform *)cls)->dx ());
}


// double QTransform::dy()


static void _init_f_dy_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_dy_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QTransform *)cls)->dy ());
}


// QTransform QTransform::inverted(bool *invertible)


static void _init_f_inverted_c1050 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("invertible", true, "nullptr");
  decl->add_arg<bool * > (argspec_0);
  decl->set_return<QTransform > ();
}

static void _call_f_inverted_c1050 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool *arg1 = args ? gsi::arg_reader<bool * >() (args, heap) : gsi::arg_maker<bool * >() (nullptr, heap);
  ret.write<QTransform > ((QTransform)((QTransform *)cls)->inverted (arg1));
}


// bool QTransform::isAffine()


static void _init_f_isAffine_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isAffine_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QTransform *)cls)->isAffine ());
}


// bool QTransform::isIdentity()


static void _init_f_isIdentity_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isIdentity_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QTransform *)cls)->isIdentity ());
}


// bool QTransform::isInvertible()


static void _init_f_isInvertible_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isInvertible_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QTransform *)cls)->isInvertible ());
}


// bool QTransform::isRotating()


static void _init_f_isRotating_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isRotating_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QTransform *)cls)->isRotating ());
}


// bool QTransform::isScaling()


static void _init_f_isScaling_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isScaling_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QTransform *)cls)->isScaling ());
}


// bool QTransform::isTranslating()


static void _init_f_isTranslating_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isTranslating_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QTransform *)cls)->isTranslating ());
}


// double QTransform::m11()


static void _init_f_m11_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_m11_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QTransform *)cls)->m11 ());
}


// double QTransform::m12()


static void _init_f_m12_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_m12_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QTransform *)cls)->m12 ());
}


// double QTransform::m13()


static void _init_f_m13_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_m13_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QTransform *)cls)->m13 ());
}


// double QTransform::m21()


static void _init_f_m21_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_m21_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QTransform *)cls)->m21 ());
}


// double QTransform::m22()


static void _init_f_m22_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_m22_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QTransform *)cls)->m22 ());
}


// double QTransform::m23()


static void _init_f_m23_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_m23_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QTransform *)cls)->m23 ());
}


// double QTransform::m31()


static void _init_f_m31_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_m31_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QTransform *)cls)->m31 ());
}


// double QTransform::m32()


static void _init_f_m32_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_m32_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QTransform *)cls)->m32 ());
}


// double QTransform::m33()


static void _init_f_m33_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_m33_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QTransform *)cls)->m33 ());
}


// QPoint QTransform::map(const QPoint &p)


static void _init_f_map_c1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<QPoint > ();
}

static void _call_f_map_c1916 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = gsi::arg_reader<const QPoint & >() (args, heap);
  ret.write<QPoint > ((QPoint)((QTransform *)cls)->map (arg1));
}


// QPointF QTransform::map(const QPointF &p)


static void _init_f_map_c1986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPointF & > (argspec_0);
  decl->set_return<QPointF > ();
}

static void _call_f_map_c1986 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPointF &arg1 = gsi::arg_reader<const QPointF & >() (args, heap);
  ret.write<QPointF > ((QPointF)((QTransform *)cls)->map (arg1));
}


// QLine QTransform::map(const QLine &l)


static void _init_f_map_c1786 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("l");
  decl->add_arg<const QLine & > (argspec_0);
  decl->set_return<QLine > ();
}

static void _call_f_map_c1786 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QLine &arg1 = gsi::arg_reader<const QLine & >() (args, heap);
  ret.write<QLine > ((QLine)((QTransform *)cls)->map (arg1));
}


// QLineF QTransform::map(const QLineF &l)


static void _init_f_map_c1856 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("l");
  decl->add_arg<const QLineF & > (argspec_0);
  decl->set_return<QLineF > ();
}

static void _call_f_map_c1856 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QLineF &arg1 = gsi::arg_reader<const QLineF & >() (args, heap);
  ret.write<QLineF > ((QLineF)((QTransform *)cls)->map (arg1));
}


// QPolygonF QTransform::map(const QPolygonF &a)


static void _init_f_map_c2208 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("a");
  decl->add_arg<const QPolygonF & > (argspec_0);
  decl->set_return<QPolygonF > ();
}

static void _call_f_map_c2208 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPolygonF &arg1 = gsi::arg_reader<const QPolygonF & >() (args, heap);
  ret.write<QPolygonF > ((QPolygonF)((QTransform *)cls)->map (arg1));
}


// QPolygon QTransform::map(const QPolygon &a)


static void _init_f_map_c2138 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("a");
  decl->add_arg<const QPolygon & > (argspec_0);
  decl->set_return<QPolygon > ();
}

static void _call_f_map_c2138 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPolygon &arg1 = gsi::arg_reader<const QPolygon & >() (args, heap);
  ret.write<QPolygon > ((QPolygon)((QTransform *)cls)->map (arg1));
}


// QRegion QTransform::map(const QRegion &r)


static void _init_f_map_c2006 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("r");
  decl->add_arg<const QRegion & > (argspec_0);
  decl->set_return<QRegion > ();
}

static void _call_f_map_c2006 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRegion &arg1 = gsi::arg_reader<const QRegion & >() (args, heap);
  ret.write<QRegion > ((QRegion)((QTransform *)cls)->map (arg1));
}


// QPainterPath QTransform::map(const QPainterPath &p)


static void _init_f_map_c2514 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPainterPath & > (argspec_0);
  decl->set_return<QPainterPath > ();
}

static void _call_f_map_c2514 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPainterPath &arg1 = gsi::arg_reader<const QPainterPath & >() (args, heap);
  ret.write<QPainterPath > ((QPainterPath)((QTransform *)cls)->map (arg1));
}


// void QTransform::map(int x, int y, int *tx, int *ty)


static void _init_f_map_c3116 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("tx");
  decl->add_arg<int * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("ty");
  decl->add_arg<int * > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_map_c3116 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int *arg3 = gsi::arg_reader<int * >() (args, heap);
  int *arg4 = gsi::arg_reader<int * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTransform *)cls)->map (arg1, arg2, arg3, arg4);
}


// void QTransform::map(double x, double y, double *tx, double *ty)


static void _init_f_map_c4332 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("tx");
  decl->add_arg<double * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("ty");
  decl->add_arg<double * > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_map_c4332 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  double *arg3 = gsi::arg_reader<double * >() (args, heap);
  double *arg4 = gsi::arg_reader<double * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTransform *)cls)->map (arg1, arg2, arg3, arg4);
}


// QRect QTransform::mapRect(const QRect &)


static void _init_f_mapRect_c1792 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QRect & > (argspec_0);
  decl->set_return<QRect > ();
}

static void _call_f_mapRect_c1792 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRect &arg1 = gsi::arg_reader<const QRect & >() (args, heap);
  ret.write<QRect > ((QRect)((QTransform *)cls)->mapRect (arg1));
}


// QRectF QTransform::mapRect(const QRectF &)


static void _init_f_mapRect_c1862 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QRectF & > (argspec_0);
  decl->set_return<QRectF > ();
}

static void _call_f_mapRect_c1862 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRectF &arg1 = gsi::arg_reader<const QRectF & >() (args, heap);
  ret.write<QRectF > ((QRectF)((QTransform *)cls)->mapRect (arg1));
}


// QPolygon QTransform::mapToPolygon(const QRect &r)


static void _init_f_mapToPolygon_c1792 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("r");
  decl->add_arg<const QRect & > (argspec_0);
  decl->set_return<QPolygon > ();
}

static void _call_f_mapToPolygon_c1792 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRect &arg1 = gsi::arg_reader<const QRect & >() (args, heap);
  ret.write<QPolygon > ((QPolygon)((QTransform *)cls)->mapToPolygon (arg1));
}


// bool QTransform::operator!=(const QTransform &)


static void _init_f_operator_excl__eq__c2350 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QTransform & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_excl__eq__c2350 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QTransform &arg1 = gsi::arg_reader<const QTransform & >() (args, heap);
  ret.write<bool > ((bool)((QTransform *)cls)->operator!= (arg1));
}


// QTransform QTransform::operator*(const QTransform &o)


static void _init_f_operator_star__c2350 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("o");
  decl->add_arg<const QTransform & > (argspec_0);
  decl->set_return<QTransform > ();
}

static void _call_f_operator_star__c2350 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QTransform &arg1 = gsi::arg_reader<const QTransform & >() (args, heap);
  ret.write<QTransform > ((QTransform)((QTransform *)cls)->operator* (arg1));
}


// QTransform &QTransform::operator*=(const QTransform &)


static void _init_f_operator_star__eq__2350 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QTransform & > (argspec_0);
  decl->set_return<QTransform & > ();
}

static void _call_f_operator_star__eq__2350 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QTransform &arg1 = gsi::arg_reader<const QTransform & >() (args, heap);
  ret.write<QTransform & > ((QTransform &)((QTransform *)cls)->operator*= (arg1));
}


// QTransform &QTransform::operator*=(double div)


static void _init_f_operator_star__eq__1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("div");
  decl->add_arg<double > (argspec_0);
  decl->set_return<QTransform & > ();
}

static void _call_f_operator_star__eq__1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  ret.write<QTransform & > ((QTransform &)((QTransform *)cls)->operator*= (arg1));
}


// QTransform &QTransform::operator+=(double div)


static void _init_f_operator_plus__eq__1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("div");
  decl->add_arg<double > (argspec_0);
  decl->set_return<QTransform & > ();
}

static void _call_f_operator_plus__eq__1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  ret.write<QTransform & > ((QTransform &)((QTransform *)cls)->operator+= (arg1));
}


// QTransform &QTransform::operator-=(double div)


static void _init_f_operator_minus__eq__1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("div");
  decl->add_arg<double > (argspec_0);
  decl->set_return<QTransform & > ();
}

static void _call_f_operator_minus__eq__1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  ret.write<QTransform & > ((QTransform &)((QTransform *)cls)->operator-= (arg1));
}


// QTransform &QTransform::operator/=(double div)


static void _init_f_operator_slash__eq__1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("div");
  decl->add_arg<double > (argspec_0);
  decl->set_return<QTransform & > ();
}

static void _call_f_operator_slash__eq__1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  ret.write<QTransform & > ((QTransform &)((QTransform *)cls)->operator/= (arg1));
}


// QTransform &QTransform::operator=(const QTransform &)


static void _init_f_operator_eq__2350 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QTransform & > (argspec_0);
  decl->set_return<QTransform & > ();
}

static void _call_f_operator_eq__2350 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QTransform &arg1 = gsi::arg_reader<const QTransform & >() (args, heap);
  ret.write<QTransform & > ((QTransform &)((QTransform *)cls)->operator= (arg1));
}


// bool QTransform::operator==(const QTransform &)


static void _init_f_operator_eq__eq__c2350 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QTransform & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_eq__eq__c2350 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QTransform &arg1 = gsi::arg_reader<const QTransform & >() (args, heap);
  ret.write<bool > ((bool)((QTransform *)cls)->operator== (arg1));
}


// void QTransform::reset()


static void _init_f_reset_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_reset_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTransform *)cls)->reset ();
}


// QTransform &QTransform::rotate(double a, Qt::Axis axis)


static void _init_f_rotate_2117 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("a");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("axis", true, "Qt::ZAxis");
  decl->add_arg<const qt_gsi::Converter<Qt::Axis>::target_type & > (argspec_1);
  decl->set_return<QTransform & > ();
}

static void _call_f_rotate_2117 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  const qt_gsi::Converter<Qt::Axis>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::Axis>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::Axis>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::Axis>(heap, Qt::ZAxis), heap);
  ret.write<QTransform & > ((QTransform &)((QTransform *)cls)->rotate (arg1, qt_gsi::QtToCppAdaptor<Qt::Axis>(arg2).cref()));
}


// QTransform &QTransform::rotateRadians(double a, Qt::Axis axis)


static void _init_f_rotateRadians_2117 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("a");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("axis", true, "Qt::ZAxis");
  decl->add_arg<const qt_gsi::Converter<Qt::Axis>::target_type & > (argspec_1);
  decl->set_return<QTransform & > ();
}

static void _call_f_rotateRadians_2117 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  const qt_gsi::Converter<Qt::Axis>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::Axis>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::Axis>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::Axis>(heap, Qt::ZAxis), heap);
  ret.write<QTransform & > ((QTransform &)((QTransform *)cls)->rotateRadians (arg1, qt_gsi::QtToCppAdaptor<Qt::Axis>(arg2).cref()));
}


// QTransform &QTransform::scale(double sx, double sy)


static void _init_f_scale_2034 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sx");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("sy");
  decl->add_arg<double > (argspec_1);
  decl->set_return<QTransform & > ();
}

static void _call_f_scale_2034 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  ret.write<QTransform & > ((QTransform &)((QTransform *)cls)->scale (arg1, arg2));
}


// void QTransform::setMatrix(double m11, double m12, double m13, double m21, double m22, double m23, double m31, double m32, double m33)


static void _init_f_setMatrix_8775 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("m11");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("m12");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("m13");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("m21");
  decl->add_arg<double > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("m22");
  decl->add_arg<double > (argspec_4);
  static gsi::ArgSpecBase argspec_5 ("m23");
  decl->add_arg<double > (argspec_5);
  static gsi::ArgSpecBase argspec_6 ("m31");
  decl->add_arg<double > (argspec_6);
  static gsi::ArgSpecBase argspec_7 ("m32");
  decl->add_arg<double > (argspec_7);
  static gsi::ArgSpecBase argspec_8 ("m33");
  decl->add_arg<double > (argspec_8);
  decl->set_return<void > ();
}

static void _call_f_setMatrix_8775 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  double arg3 = gsi::arg_reader<double >() (args, heap);
  double arg4 = gsi::arg_reader<double >() (args, heap);
  double arg5 = gsi::arg_reader<double >() (args, heap);
  double arg6 = gsi::arg_reader<double >() (args, heap);
  double arg7 = gsi::arg_reader<double >() (args, heap);
  double arg8 = gsi::arg_reader<double >() (args, heap);
  double arg9 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTransform *)cls)->setMatrix (arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9);
}


// QTransform &QTransform::shear(double sh, double sv)


static void _init_f_shear_2034 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sh");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("sv");
  decl->add_arg<double > (argspec_1);
  decl->set_return<QTransform & > ();
}

static void _call_f_shear_2034 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  ret.write<QTransform & > ((QTransform &)((QTransform *)cls)->shear (arg1, arg2));
}


// QTransform &QTransform::translate(double dx, double dy)


static void _init_f_translate_2034 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dx");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("dy");
  decl->add_arg<double > (argspec_1);
  decl->set_return<QTransform & > ();
}

static void _call_f_translate_2034 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  ret.write<QTransform & > ((QTransform &)((QTransform *)cls)->translate (arg1, arg2));
}


// QTransform QTransform::transposed()


static void _init_f_transposed_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QTransform > ();
}

static void _call_f_transposed_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QTransform > ((QTransform)((QTransform *)cls)->transposed ());
}


// QTransform::TransformationType QTransform::type()


static void _init_f_type_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QTransform::TransformationType>::target_type > ();
}

static void _call_f_type_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QTransform::TransformationType>::target_type > ((qt_gsi::Converter<QTransform::TransformationType>::target_type)qt_gsi::CppToQtAdaptor<QTransform::TransformationType>(((QTransform *)cls)->type ()));
}


// static QTransform QTransform::fromScale(double dx, double dy)


static void _init_f_fromScale_2034 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dx");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("dy");
  decl->add_arg<double > (argspec_1);
  decl->set_return<QTransform > ();
}

static void _call_f_fromScale_2034 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  ret.write<QTransform > ((QTransform)QTransform::fromScale (arg1, arg2));
}


// static QTransform QTransform::fromTranslate(double dx, double dy)


static void _init_f_fromTranslate_2034 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dx");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("dy");
  decl->add_arg<double > (argspec_1);
  decl->set_return<QTransform > ();
}

static void _call_f_fromTranslate_2034 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  ret.write<QTransform > ((QTransform)QTransform::fromTranslate (arg1, arg2));
}


// static bool QTransform::quadToQuad(const QPolygonF &one, const QPolygonF &two, QTransform &result)


static void _init_f_quadToQuad_5855 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("one");
  decl->add_arg<const QPolygonF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("two");
  decl->add_arg<const QPolygonF & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("result");
  decl->add_arg<QTransform & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_quadToQuad_5855 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPolygonF &arg1 = gsi::arg_reader<const QPolygonF & >() (args, heap);
  const QPolygonF &arg2 = gsi::arg_reader<const QPolygonF & >() (args, heap);
  QTransform &arg3 = gsi::arg_reader<QTransform & >() (args, heap);
  ret.write<bool > ((bool)QTransform::quadToQuad (arg1, arg2, arg3));
}


// static bool QTransform::quadToSquare(const QPolygonF &quad, QTransform &result)


static void _init_f_quadToSquare_3755 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("quad");
  decl->add_arg<const QPolygonF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("result");
  decl->add_arg<QTransform & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_quadToSquare_3755 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPolygonF &arg1 = gsi::arg_reader<const QPolygonF & >() (args, heap);
  QTransform &arg2 = gsi::arg_reader<QTransform & >() (args, heap);
  ret.write<bool > ((bool)QTransform::quadToSquare (arg1, arg2));
}


// static bool QTransform::squareToQuad(const QPolygonF &square, QTransform &result)


static void _init_f_squareToQuad_3755 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("square");
  decl->add_arg<const QPolygonF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("result");
  decl->add_arg<QTransform & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_squareToQuad_3755 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPolygonF &arg1 = gsi::arg_reader<const QPolygonF & >() (args, heap);
  QTransform &arg2 = gsi::arg_reader<QTransform & >() (args, heap);
  ret.write<bool > ((bool)QTransform::squareToQuad (arg1, arg2));
}


//  QTransform ::operator *(const QTransform &a, qreal n)
static QTransform op_QTransform_operator_star__3211(const QTransform *_self, qreal n) {
  return ::operator *(*_self, n);
}

//  QTransform ::operator /(const QTransform &a, qreal n)
static QTransform op_QTransform_operator_slash__3211(const QTransform *_self, qreal n) {
  return ::operator /(*_self, n);
}

//  QTransform ::operator +(const QTransform &a, qreal n)
static QTransform op_QTransform_operator_plus__3211(const QTransform *_self, qreal n) {
  return ::operator +(*_self, n);
}

//  QTransform ::operator -(const QTransform &a, qreal n)
static QTransform op_QTransform_operator_minus__3211(const QTransform *_self, qreal n) {
  return ::operator -(*_self, n);
}


namespace gsi
{

static gsi::Methods methods_QTransform () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QTransform::QTransform()\nThis method creates an object of class QTransform.", &_init_ctor_QTransform_0, &_call_ctor_QTransform_0);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QTransform::QTransform(double h11, double h12, double h13, double h21, double h22, double h23, double h31, double h32, double h33)\nThis method creates an object of class QTransform.", &_init_ctor_QTransform_8775, &_call_ctor_QTransform_8775);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QTransform::QTransform(double h11, double h12, double h21, double h22, double dx, double dy)\nThis method creates an object of class QTransform.", &_init_ctor_QTransform_5886, &_call_ctor_QTransform_5886);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QTransform::QTransform(const QTransform &other)\nThis method creates an object of class QTransform.", &_init_ctor_QTransform_2350, &_call_ctor_QTransform_2350);
  methods += new qt_gsi::GenericMethod ("adjoint", "@brief Method QTransform QTransform::adjoint()\n", true, &_init_f_adjoint_c0, &_call_f_adjoint_c0);
  methods += new qt_gsi::GenericMethod ("determinant", "@brief Method double QTransform::determinant()\n", true, &_init_f_determinant_c0, &_call_f_determinant_c0);
  methods += new qt_gsi::GenericMethod ("dx", "@brief Method double QTransform::dx()\n", true, &_init_f_dx_c0, &_call_f_dx_c0);
  methods += new qt_gsi::GenericMethod ("dy", "@brief Method double QTransform::dy()\n", true, &_init_f_dy_c0, &_call_f_dy_c0);
  methods += new qt_gsi::GenericMethod ("inverted", "@brief Method QTransform QTransform::inverted(bool *invertible)\n", true, &_init_f_inverted_c1050, &_call_f_inverted_c1050);
  methods += new qt_gsi::GenericMethod ("isAffine?", "@brief Method bool QTransform::isAffine()\n", true, &_init_f_isAffine_c0, &_call_f_isAffine_c0);
  methods += new qt_gsi::GenericMethod ("isIdentity?", "@brief Method bool QTransform::isIdentity()\n", true, &_init_f_isIdentity_c0, &_call_f_isIdentity_c0);
  methods += new qt_gsi::GenericMethod ("isInvertible?", "@brief Method bool QTransform::isInvertible()\n", true, &_init_f_isInvertible_c0, &_call_f_isInvertible_c0);
  methods += new qt_gsi::GenericMethod ("isRotating?", "@brief Method bool QTransform::isRotating()\n", true, &_init_f_isRotating_c0, &_call_f_isRotating_c0);
  methods += new qt_gsi::GenericMethod ("isScaling?", "@brief Method bool QTransform::isScaling()\n", true, &_init_f_isScaling_c0, &_call_f_isScaling_c0);
  methods += new qt_gsi::GenericMethod ("isTranslating?", "@brief Method bool QTransform::isTranslating()\n", true, &_init_f_isTranslating_c0, &_call_f_isTranslating_c0);
  methods += new qt_gsi::GenericMethod ("m11", "@brief Method double QTransform::m11()\n", true, &_init_f_m11_c0, &_call_f_m11_c0);
  methods += new qt_gsi::GenericMethod ("m12", "@brief Method double QTransform::m12()\n", true, &_init_f_m12_c0, &_call_f_m12_c0);
  methods += new qt_gsi::GenericMethod ("m13", "@brief Method double QTransform::m13()\n", true, &_init_f_m13_c0, &_call_f_m13_c0);
  methods += new qt_gsi::GenericMethod ("m21", "@brief Method double QTransform::m21()\n", true, &_init_f_m21_c0, &_call_f_m21_c0);
  methods += new qt_gsi::GenericMethod ("m22", "@brief Method double QTransform::m22()\n", true, &_init_f_m22_c0, &_call_f_m22_c0);
  methods += new qt_gsi::GenericMethod ("m23", "@brief Method double QTransform::m23()\n", true, &_init_f_m23_c0, &_call_f_m23_c0);
  methods += new qt_gsi::GenericMethod ("m31", "@brief Method double QTransform::m31()\n", true, &_init_f_m31_c0, &_call_f_m31_c0);
  methods += new qt_gsi::GenericMethod ("m32", "@brief Method double QTransform::m32()\n", true, &_init_f_m32_c0, &_call_f_m32_c0);
  methods += new qt_gsi::GenericMethod ("m33", "@brief Method double QTransform::m33()\n", true, &_init_f_m33_c0, &_call_f_m33_c0);
  methods += new qt_gsi::GenericMethod ("map", "@brief Method QPoint QTransform::map(const QPoint &p)\n", true, &_init_f_map_c1916, &_call_f_map_c1916);
  methods += new qt_gsi::GenericMethod ("map", "@brief Method QPointF QTransform::map(const QPointF &p)\n", true, &_init_f_map_c1986, &_call_f_map_c1986);
  methods += new qt_gsi::GenericMethod ("map", "@brief Method QLine QTransform::map(const QLine &l)\n", true, &_init_f_map_c1786, &_call_f_map_c1786);
  methods += new qt_gsi::GenericMethod ("map", "@brief Method QLineF QTransform::map(const QLineF &l)\n", true, &_init_f_map_c1856, &_call_f_map_c1856);
  methods += new qt_gsi::GenericMethod ("map", "@brief Method QPolygonF QTransform::map(const QPolygonF &a)\n", true, &_init_f_map_c2208, &_call_f_map_c2208);
  methods += new qt_gsi::GenericMethod ("map", "@brief Method QPolygon QTransform::map(const QPolygon &a)\n", true, &_init_f_map_c2138, &_call_f_map_c2138);
  methods += new qt_gsi::GenericMethod ("map", "@brief Method QRegion QTransform::map(const QRegion &r)\n", true, &_init_f_map_c2006, &_call_f_map_c2006);
  methods += new qt_gsi::GenericMethod ("map", "@brief Method QPainterPath QTransform::map(const QPainterPath &p)\n", true, &_init_f_map_c2514, &_call_f_map_c2514);
  methods += new qt_gsi::GenericMethod ("map", "@brief Method void QTransform::map(int x, int y, int *tx, int *ty)\n", true, &_init_f_map_c3116, &_call_f_map_c3116);
  methods += new qt_gsi::GenericMethod ("map", "@brief Method void QTransform::map(double x, double y, double *tx, double *ty)\n", true, &_init_f_map_c4332, &_call_f_map_c4332);
  methods += new qt_gsi::GenericMethod ("mapRect", "@brief Method QRect QTransform::mapRect(const QRect &)\n", true, &_init_f_mapRect_c1792, &_call_f_mapRect_c1792);
  methods += new qt_gsi::GenericMethod ("mapRect", "@brief Method QRectF QTransform::mapRect(const QRectF &)\n", true, &_init_f_mapRect_c1862, &_call_f_mapRect_c1862);
  methods += new qt_gsi::GenericMethod ("mapToPolygon", "@brief Method QPolygon QTransform::mapToPolygon(const QRect &r)\n", true, &_init_f_mapToPolygon_c1792, &_call_f_mapToPolygon_c1792);
  methods += new qt_gsi::GenericMethod ("!=", "@brief Method bool QTransform::operator!=(const QTransform &)\n", true, &_init_f_operator_excl__eq__c2350, &_call_f_operator_excl__eq__c2350);
  methods += new qt_gsi::GenericMethod ("*", "@brief Method QTransform QTransform::operator*(const QTransform &o)\n", true, &_init_f_operator_star__c2350, &_call_f_operator_star__c2350);
  methods += new qt_gsi::GenericMethod ("*=", "@brief Method QTransform &QTransform::operator*=(const QTransform &)\n", false, &_init_f_operator_star__eq__2350, &_call_f_operator_star__eq__2350);
  methods += new qt_gsi::GenericMethod ("*=", "@brief Method QTransform &QTransform::operator*=(double div)\n", false, &_init_f_operator_star__eq__1071, &_call_f_operator_star__eq__1071);
  methods += new qt_gsi::GenericMethod ("+=", "@brief Method QTransform &QTransform::operator+=(double div)\n", false, &_init_f_operator_plus__eq__1071, &_call_f_operator_plus__eq__1071);
  methods += new qt_gsi::GenericMethod ("-=", "@brief Method QTransform &QTransform::operator-=(double div)\n", false, &_init_f_operator_minus__eq__1071, &_call_f_operator_minus__eq__1071);
  methods += new qt_gsi::GenericMethod ("/=", "@brief Method QTransform &QTransform::operator/=(double div)\n", false, &_init_f_operator_slash__eq__1071, &_call_f_operator_slash__eq__1071);
  methods += new qt_gsi::GenericMethod ("assign", "@brief Method QTransform &QTransform::operator=(const QTransform &)\n", false, &_init_f_operator_eq__2350, &_call_f_operator_eq__2350);
  methods += new qt_gsi::GenericMethod ("==", "@brief Method bool QTransform::operator==(const QTransform &)\n", true, &_init_f_operator_eq__eq__c2350, &_call_f_operator_eq__eq__c2350);
  methods += new qt_gsi::GenericMethod ("reset", "@brief Method void QTransform::reset()\n", false, &_init_f_reset_0, &_call_f_reset_0);
  methods += new qt_gsi::GenericMethod ("rotate", "@brief Method QTransform &QTransform::rotate(double a, Qt::Axis axis)\n", false, &_init_f_rotate_2117, &_call_f_rotate_2117);
  methods += new qt_gsi::GenericMethod ("rotateRadians", "@brief Method QTransform &QTransform::rotateRadians(double a, Qt::Axis axis)\n", false, &_init_f_rotateRadians_2117, &_call_f_rotateRadians_2117);
  methods += new qt_gsi::GenericMethod ("scale", "@brief Method QTransform &QTransform::scale(double sx, double sy)\n", false, &_init_f_scale_2034, &_call_f_scale_2034);
  methods += new qt_gsi::GenericMethod ("setMatrix", "@brief Method void QTransform::setMatrix(double m11, double m12, double m13, double m21, double m22, double m23, double m31, double m32, double m33)\n", false, &_init_f_setMatrix_8775, &_call_f_setMatrix_8775);
  methods += new qt_gsi::GenericMethod ("shear", "@brief Method QTransform &QTransform::shear(double sh, double sv)\n", false, &_init_f_shear_2034, &_call_f_shear_2034);
  methods += new qt_gsi::GenericMethod ("translate", "@brief Method QTransform &QTransform::translate(double dx, double dy)\n", false, &_init_f_translate_2034, &_call_f_translate_2034);
  methods += new qt_gsi::GenericMethod ("transposed", "@brief Method QTransform QTransform::transposed()\n", true, &_init_f_transposed_c0, &_call_f_transposed_c0);
  methods += new qt_gsi::GenericMethod ("type", "@brief Method QTransform::TransformationType QTransform::type()\n", true, &_init_f_type_c0, &_call_f_type_c0);
  methods += new qt_gsi::GenericStaticMethod ("fromScale", "@brief Static method QTransform QTransform::fromScale(double dx, double dy)\nThis method is static and can be called without an instance.", &_init_f_fromScale_2034, &_call_f_fromScale_2034);
  methods += new qt_gsi::GenericStaticMethod ("fromTranslate", "@brief Static method QTransform QTransform::fromTranslate(double dx, double dy)\nThis method is static and can be called without an instance.", &_init_f_fromTranslate_2034, &_call_f_fromTranslate_2034);
  methods += new qt_gsi::GenericStaticMethod ("quadToQuad", "@brief Static method bool QTransform::quadToQuad(const QPolygonF &one, const QPolygonF &two, QTransform &result)\nThis method is static and can be called without an instance.", &_init_f_quadToQuad_5855, &_call_f_quadToQuad_5855);
  methods += new qt_gsi::GenericStaticMethod ("quadToSquare", "@brief Static method bool QTransform::quadToSquare(const QPolygonF &quad, QTransform &result)\nThis method is static and can be called without an instance.", &_init_f_quadToSquare_3755, &_call_f_quadToSquare_3755);
  methods += new qt_gsi::GenericStaticMethod ("squareToQuad", "@brief Static method bool QTransform::squareToQuad(const QPolygonF &square, QTransform &result)\nThis method is static and can be called without an instance.", &_init_f_squareToQuad_3755, &_call_f_squareToQuad_3755);
  methods += gsi::method_ext("*", &::op_QTransform_operator_star__3211, gsi::arg ("n"), "@brief Operator QTransform ::operator *(const QTransform &a, qreal n)\nThis is the mapping of the global operator to the instance method.");
  methods += gsi::method_ext("/", &::op_QTransform_operator_slash__3211, gsi::arg ("n"), "@brief Operator QTransform ::operator /(const QTransform &a, qreal n)\nThis is the mapping of the global operator to the instance method.");
  methods += gsi::method_ext("+", &::op_QTransform_operator_plus__3211, gsi::arg ("n"), "@brief Operator QTransform ::operator +(const QTransform &a, qreal n)\nThis is the mapping of the global operator to the instance method.");
  methods += gsi::method_ext("-", &::op_QTransform_operator_minus__3211, gsi::arg ("n"), "@brief Operator QTransform ::operator -(const QTransform &a, qreal n)\nThis is the mapping of the global operator to the instance method.");
  return methods;
}

gsi::Class<QTransform> decl_QTransform ("QtGui", "QTransform",
  methods_QTransform (),
  "@qt\n@brief Binding of QTransform");


GSI_QTGUI_PUBLIC gsi::Class<QTransform> &qtdecl_QTransform () { return decl_QTransform; }

}


//  Implementation of the enum wrapper class for QTransform::TransformationType
namespace qt_gsi
{

static gsi::Enum<QTransform::TransformationType> decl_QTransform_TransformationType_Enum ("QtGui", "QTransform_TransformationType",
    gsi::enum_const ("TxNone", QTransform::TxNone, "@brief Enum constant QTransform::TxNone") +
    gsi::enum_const ("TxTranslate", QTransform::TxTranslate, "@brief Enum constant QTransform::TxTranslate") +
    gsi::enum_const ("TxScale", QTransform::TxScale, "@brief Enum constant QTransform::TxScale") +
    gsi::enum_const ("TxRotate", QTransform::TxRotate, "@brief Enum constant QTransform::TxRotate") +
    gsi::enum_const ("TxShear", QTransform::TxShear, "@brief Enum constant QTransform::TxShear") +
    gsi::enum_const ("TxProject", QTransform::TxProject, "@brief Enum constant QTransform::TxProject"),
  "@qt\n@brief This class represents the QTransform::TransformationType enum");

static gsi::QFlagsClass<QTransform::TransformationType > decl_QTransform_TransformationType_Enums ("QtGui", "QTransform_QFlags_TransformationType",
  "@qt\n@brief This class represents the QFlags<QTransform::TransformationType> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QTransform> inject_QTransform_TransformationType_Enum_in_parent (decl_QTransform_TransformationType_Enum.defs ());
static gsi::ClassExt<QTransform> decl_QTransform_TransformationType_Enum_as_child (decl_QTransform_TransformationType_Enum, "TransformationType");
static gsi::ClassExt<QTransform> decl_QTransform_TransformationType_Enums_as_child (decl_QTransform_TransformationType_Enums, "QFlags_TransformationType");

}

