/*
   SPDX-FileCopyrightText: 2021-2023 Laurent Montel <montel@kde.org>

   SPDX-License-Identifier: LGPL-2.0-or-later
*/

#pragma once

#include <QSortFilterProxyModel>
namespace KPIMTextEdit
{
class EmoticonCategoryModelFilterProxyModel : public QSortFilterProxyModel
{
    Q_OBJECT
public:
    explicit EmoticonCategoryModelFilterProxyModel(QObject *parent = nullptr);
    ~EmoticonCategoryModelFilterProxyModel() override;

    const QString &category() const;
    void setCategory(const QString &newCategory);

protected:
    Q_REQUIRED_RESULT bool lessThan(const QModelIndex &left, const QModelIndex &right) const override;
    bool filterAcceptsRow(int source_row, const QModelIndex &source_parent) const override;

private:
    QString mCategory;
};
}
