.\" $Id: kterm.man,v 6.4 1996/07/12 05:01:34 kagotani Rel $
.\"
.\" Copyright (c) 1988, 1989, 1990, 1991, 1992, 1993, 1994, and 1996
.\" XXI working group in Japan Unix Society (XXI).
.\"
.\" The X Consortium, and any party obtaining a copy of these files from
.\" the X Consortium, directly or indirectly, is granted, free of charge, a
.\" full and unrestricted irrevocable, world-wide, paid up, royalty-free,
.\" nonexclusive right and license to deal in this software and
.\" documentation files (the "Software"), including without limitation the
.\" rights to use, copy, modify, merge, publish, distribute, sublicense,
.\" and/or sell copies of the Software, and to permit persons who receive
.\" copies from any such party to do so.  This license includes without
.\" limitation a license to do the foregoing actions under any patents of
.\" the party supplying this software to the X Consortium.
.\" "
.TH KTERM 1 "12 July 1996" "X Version 11"
.SH NAME
kterm \- multi-lingual terminal emulator for X
.SH SYNOPSIS
.B kterm
[-\fItoolkitoption\fP ...] [-\fIxtermoption\fP ...] [-option ...]
.SH DESCRIPTION
\fIKterm\fP is a multi-lingual terminal emulator based on
\fIxterm\fP(1).  The major differences of \fIkterm\fP from \fIxterm\fP
is that it can handle multi-lingual text encoded in ISO2022, can
display colored text, and has the statusline function.  To input
multi-lingual text, both X Input Method (XIM) protocol and kinput2
protocol can be used.  See the sections USING XIM and USING KINPUT2
for the details.
.PP
.SH OPTIONS
\fIKterm\fP accepts all of the \fIxterm\fP(1) command line options as
well as the following additional options:
.TP 8
.BI \-dfl
This option indicates that \fIkterm\fP should load fonts dynamically
(on demand).  It may freeze \fIkterm\fP and X server in a moment when
a large font is loaded.
.TP 8
.BI \+dfl
This option indicates that \fIkterm\fP should load fonts in advance.
.TP 8
.BI \-fl " fontlist"
This option specifies fonts to be used.  \fIfontlist\fP is a comma
separated list of XLFDs with arbitrary wild-cards.  \fIkterm\fP
chooses fonts containing necessary character sets in the list.  This
release may use the following character sets:
.br
"iso8859-1",
.br
"iso8859-2",
.br
"iso8859-3",
.br
"iso8859-4",
.br
"iso8859-5",
.br
"iso8859-6",
.br
"iso8859-7",
.br
"iso8859-8",
.br
"iso8859-9",
.br
"jisx0201.1976-0",
.br
"jisx0208.1990-0" or "jisx0208.1983-0",
.br
"jisx0212.1990-0",
.br
"gb2312.1980-0",
.br
"ksc5601.1987-0", and
.br
"jisc6226.1978-0" or "jisx0208.1983-0".
.TP 8
.BI \-fn " iso8859/1-font"
This option specifies a normal (non-bold) ISO8859/1 font to be used
when displaying Latin-1 (including ASCII) text.  If it is not
specified, \fIfontlist\fP is used.
.TP 8
.BI \-fr " roman-kana-font"
This option specifies a normal JISX0201 font.  This font must have
same height and width as the ISO8859/1 font.  If it is not specified,
\fIfontlist\fP is used.
.TP 8
.BI \-fk " kanji-font"
This option specifies a normal JISX0208 font to be used when
displaying Kanji text.  This font must have same height and twice
width as the ISO8859/1 font.  If it is not specified, \fIfontlist\fP
is used.
.TP
.BI \-flb " bold-fontlist"
.TP
.BI \-fb " bold-font"
.TP
.BI \-frb " roman-kana-bold-font"
.TP 8
.BI \-fkb " kanji-bold-font"
These options specify bold fonts.
.TP 8
.BI \-lsp " dots"
This option specifies how much space to be inserted between lines.
.TP 8
.BI \-ka
This option indicates that \fIkterm\fP should make connection to the X
server with KEEPALIVE socket option.  It is useful when the server is
a X terminal that is frequently powered off.
.TP 8
.BI \+ka
This option indicates that \fIkterm\fP should make connection to the X
server without KEEPALIVE socket option.
.TP 8
.BI \-km " kanji-mode"
This option specifies the Kanji code from/to the pty.  If kanji-mode
is ``euc'', then it assumes the input/output is coded by Japanese EUC.
If kanji-mode is ``sjis'', then it assumes the input/output is coded
by Shift-JIS code (which is the same as Microsoft Kanji code).
.TP 8
.B \-sn
By default, the status line is in reverse-video (relative to the rest
of the window).  This option causes the status line to be in normal
video (the status line is still enclosed in a box).
.TP 8
.B \+sn
This option causes the status line to be in reverse video.
.TP 8
.B \-st
This option causes the status line to be displayed on startup.
.TP 8
.B \+st
This option causes the status line not to be displayed on startup.
.TP 8
.BI \-version
Just displays the \fIkterm\fP version and exit.
.TP 8
.BI \-xim
This option indicates that \fIkterm\fP should (try to) open IM on
startup.  If no appropriate IM server is running, \fIkterm\fP does
not wait, but connects after a server is available.
.TP 8
.BI \+xim
This option indicates that \fIkterm\fP should not open IM on startup.
.SH RESOURCES
The program uses all of the \fIxterm\fP resources as well as the
following \fIvt100\fP widget specific resources:
.TP 8
.B "dynamicFontLoad (\fPclass\fB DynamicFontLoad)"
Specifies whether or not \fIkterm\fP should load fonts dynamically The
default is ``true.''
.TP 8
.B "fontList (\fPclass\fB FontList)"
Specifies the name of the fonts.  The default is
``-*-fixed-medium-r-normal--14-*,
-*-gothic-medium-r-normal--14-*,
-*-mincho-medium-r-normal--14-*.''
.TP 8
.B "boldFontList (\fPclass\fB FontList)"
Specifies the name of the bold fonts.  The default is not specified
.TP 8
.B "font (\fPclass\fB Font)"
Specifies the name of the Latin-1 font.  The default is not specified.
.TP 8
.B "boldFont (\fPclass\fB Font)"
Specifies the name of the bold Latin-1 font.  The default is not
specified.
.TP 8
.B "romanKanaFont (\fPclass\fB RomanKanaFont)"
Specifies the name of the Roman-Kana font.  The default is not
specified.
.TP 8
.B "romanKanaBoldFont (\fPclass\fB RomanKanaFont)"
Specifies the name of the bold font.  The default is not specified.
.TP 8
.B "kanjiFont (\fPclass\fB KanjiFont)"
Specifies the name of the Kanji font.  The default is not specified.
.TP 8
.B "kanjiBoldFont (\fPclass\fB KanjiFont)"
Specifies the name of the bold font.  The default is not specified.
.TP 8
.B "kanjiMode (\fPclass\fB KanjiMode)"
Specifies the Kanji code of pty.  The default is ``jis.''
.TP 8
.B "lineSpace (\fPclass\fB LineSpace)"
Specifies the space to insert between lines.
The default is ``0.''
.TP 8
.B "keepAlive (\fPclass\fB KeepAlive)"
Specifies whether or not \fIkterm\fP should make connection to the X
server with KEEPALIVE socket option.  The default is ``false.''
.TP 8
.B "statusLine (\fPclass\fB StatusLine)"
Causes the status line to be displayed on startup.  The default is
``false.''
.TP 8
.B "statusNormal (\fPclass\fB StatusNormal)"
Specifies whether or not the status line should be in normal video.
The default is ``false.''
.TP 8
.B "forwardKeyEvent (\fPclass\fB ForwardKeyEvent)"
Specifies whether or not key events should be forwarded to the
conversion server.  If false, the server cannot receive key events if
the keyboard focus is set to \fIkterm\fP window but the pointer is on
other windows.  It may, however, improve response time of the
conversion server on a slow network.  The default is ``true.''
.TP 8
.B "openIm (\fPclass\fB OpenIm)"
Specifies whether or not \fIkterm\fP should (try to) open IM on
startup.  The default is ``false.''
.TP 8
.B "eucJPLocale (\fPclass\fB EucJPLocale)"
Specifies the locale of the input method in the form of a comma
separated list.  The default is
``ja_JP.eucJP,ja_JP.ujis,ja_JP.EUC,japanese.euc,
Japanese-EUC,ja,japan.''
See the section USING XIM for the details.
.TP 8
.B "inputMethod (\fPclass\fB InputMethod)"
Specifies the input method modifier for the current locale.  The
default is not specified.  (That means using the XMODIFIERS
environment variable.)
.TP 8
.B "preeditType (\fPclass\fB PreeditType)"
Specifies the input styles using XIM protocol in the form of a comma
separated list.  Currently, ``OverTheSpot'' and ``Root'' are
supported.  The default is ``OverTheSpot,Root.''
.SH ACTIONS
The following additional actions are provided for using within the
\fIvt100\fP translations resources:
.TP 8
.B "open-im([\fIinput-method\fP])"
This action (tries to) open IM for the specified input method
modifier.  If \fIinput-method\fP is omitted, the last modifier remains
unchanged.  If \fIinput-method\fP is the key-word XMODIFIERS, the
XMODIFIERS environment variable is used.
.TP 8
.B "close-im()"
This action closes IM.
.TP 8
.B "begin-conversion(\fIconversion-atom\fP)"
This action begins conversion to input text using kinput2 protocol.
\fIconversion-atom\fP for Japanese conversion is
``_JAPANESE_CONVERSION.''
.SH TERMCAP
\fITermcap\fP(5) entries that work with \fIkterm\fP include ``kterm,''
``xterm,'' ``vt102,'' ``vt100'' and ``ansi.''
.SH "USING XIM"
\fIKterm\fP first sets its international environment (locale) using
the \fIvt100\fP resource "eucJPLocale" (ignoring the LANG environment
variable), because it uses Japanese EUC encoding for the internal
input code.  If your system does not support any default locale names,
specify an appropriate one in the app-defaults file.  \fIKterm\fP,
then, sets the locale modifiers according to the resource "inputMethod"
or the XMODIFIERS environment variable.
.PP
When \fIkterm\fP is started with the "-xim" option or the "Open Input
Method" entry in the vtMenu is selected, it just registers a callback
for notification of instantiation of IM servers.  If an appropriate IM
server is running or becomes available, \fIkterm\fP connects with the
server.  Start of conversion depends on the configuration of the IM
server.
.PP
If \fIkterm\fP is connecting with a kinput2 protocol server, any IM
can not be opened.
.PP
For further information (how to input/convert/correct text, etc.), see
the conversion server's document (\fIkinput2\fP(1)).
.sp
.B Non-Japanese Languages
.br
To input non-Japanese text, set the \fIvt100\fP resource "eucJPLocale"
to your favorite locale name, and set Kanji mode to Japanese EUC
(using the "-km euc" option, "*vt100.kanjiMode: euc" resource, or the
"Japanese EUC Mode" entry in the vtMenu).  This should work for any
locale because every character input from the IM is passed to the pty
without any modification in Japanese EUC Mode.  Note that this
mechanism will be changed in the future.
.sp
.B CAUTION
.br
\fIKterm\fP may be hanged when the connecting IM server dies on some
specific timing.  Do not kill IM servers on a \fIkterm\fP which is
connected with the server, and IM servers which is establishing
connection with any \fIkterm\fP.  If you want to kill an IM server,
make sure that no \fIkterm\fP is connected with the server.
.sp
.B NOTICE
.br
\fIKterm\fP can not communicate with servers using XIMP protocol based
on X11R5.
.SH "USING KINPUT2"
By default, pressing control-Kanji key starts conversion for Japanese
text using kinput2 protocol.  The conversion server, such as
\fIkinput2\fP(1), must be started by the time, otherwise you will see
warning message `Conversion Server not found'.  For other languages,
if any server is available, you can bind a key to start conversion by
changing the translation table.
.PP
If an IM is (being) open, conversion using kinput2 protocol can not be
started.
.PP
For further information (how to input/convert/correct text, etc.), see
the conversion server's document (\fIkinput2\fP(1)).
.SH "SEE ALSO"
xterm(1), resize(1), X(1), kinput2(1), pty(4), tty(4)
.br
.I ``Xterm Control Sequences''
.SH BUGS
\fIKterm\fP assumes, like \fIxterm\fP, that all single byte characters
have the same widths, and further, assumes that the widths of
multi(two)-byte characters are as twice as that of ASCII characters.
.PP
This version of \fIkterm\fP uses ``ESC $ B'' to designate the Kanji
character set to input Kanji text in JIS mode.
.SH AUTHORS
Far too many people, including:
.sp
Katsuya Sano (Toshiba Corp.),
Michael Irie (Sony Corp.),
Akira Kato (Univ. of Tokyo),
Michiharu Ariza (SRA Inc.),
Makoto Ishisone (SRA Inc.),
Hiroto Kagotani (Okayama Univ.),
Susumu Mukawa (NTT Corp.).
