/**
 * Copyright (c) Members of the EGEE Collaboration. 2004-2010. 
 * See http://www.eu-egee.org/partners/ for details on the copyright
 * holders.  
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at 
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0 
 * 
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS, 
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 *
 *
 *  Authors:
 *  2009-
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     Mischa Sall\'e <msalle@nikhef.nl>
 *     David Groep <davidg@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *     <grid-mw-security@nikhef.nl> 
 *
 *  2007-2009
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     David Groep <davidg@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *
 *  2003-2007
 *     Martijn Steenbakkers <martijn@nikhef.nl>
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     David Groep <davidg@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *
 */


/*!
    \file   lcas_defines.h
    \brief  Public header file with common definitions for the LCAS (authorization modules)
    \author Martijn Steenbakkers for the EU DataGrid.

    Here the return values for the LCAS plugins/modules are defined as well as the
    default locations of the LCAS "etc", "lib" and "modules" directories.
    \ingroup APIforLcasPlugins
*/

#ifndef LCAS_DEFINES_H
#define LCAS_DEFINES_H

/******************************************************************************
                             Define constants
******************************************************************************/

#define LCAS_MOD_SUCCESS (int)(0) /*!< Return value of LCAS plugin module
                                       indicating succes (authorization granted)*/
#define LCAS_MOD_FAIL    (int)(1) /*!< Return value of LCAS plugin module
                                       indicating failure (no authorization) */
#define LCAS_MOD_NOFILE  (int)(2) /*!< Return value of LCAS plugin module
                                       indicating that no file could be found */
#define LCAS_MOD_ENTRY   (int)(3) /*!< Return value of LCAS plugin module
                                       indicating that an entry was found */
#define LCAS_MOD_NOENTRY (int)(4) /*!< Return value of LCAS plugin module
                                       indicating that no entry was found */

#endif /* LCAS_DEFINES_H */

/******************************************************************************
CVS Information:
    $Source: /srv/home/dennisvd/svn/mw-security/lcas/interface/lcas_defines.h,v $
    $Date: 2010-05-03 10:43:18 $
    $Revision: 1.4 $
    $Author: okoeroo $
******************************************************************************/
