/**
 * Copyright (c) Members of the EGEE Collaboration. 2004-2010. 
 * See http://www.eu-egee.org/partners/ for details on the copyright
 * holders.  
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at 
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0 
 * 
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS, 
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 *
 *
 *  Authors:
 *  2009-
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     Mischa Sall\'e <msalle@nikhef.nl>
 *     David Groep <davidg@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *     <grid-mw-security@nikhef.nl> 
 *
 *  2007-2009
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     David Groep <davidg@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *
 *  2003-2007
 *     Martijn Steenbakkers <martijn@nikhef.nl>
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     David Groep <davidg@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *
 */


/*!
    \file   _lcas.h
    \brief  Internal header file for LCAS framework
    \author Martijn Steenbakkers for the EU DataGrid.
    \internal
*/

#ifndef _LCAS_H
#define _LCAS_H

#ifndef LCAS_C
#   define LCAS_C_STORAGE_CLASS extern
#else
#   define LCAS_C_STORAGE_CLASS
#endif

/******************************************************************************
                             Include header files
******************************************************************************/
#include "lcas.h"

/******************************************************************************
                               Type definitions
******************************************************************************/
typedef enum lcas_argtype_e
{
    LCAS_ARG_PEM,    /*!< this value indicates that the PEM-encoded
                          user certificate and chain are presented */
    LCAS_ARG_GSS,    /*!< this value indicates that the user credential is
                          presented in gss format */
    LCAS_ARG_GSS_DN, /*!< this value indicates that the user credential is
                          presented in gss format together with the user DN */
} lcas_argtype_t;

/******************************************************************************
 *                            Module definition
 *****************************************************************************/

LCAS_C_STORAGE_CLASS int lcas_run_va(
        lcas_argtype_t  lcas_arg_type,
        ...
);

#endif /* _LCAS_H */

/******************************************************************************
CVS Information:
    $Source: /srv/home/dennisvd/svn/mw-security/lcas/src/_lcas.h,v $
    $Date: 2010-05-03 10:42:49 $
    $Revision: 2.2 $
    $Author: okoeroo $
******************************************************************************/
