; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -S -instcombine < %s | FileCheck %s

define void @insert_store(<16 x i8>* %q, i8 zeroext %s) {
; CHECK-LABEL: @insert_store(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load <16 x i8>, <16 x i8>* [[Q:%.*]], align 16
; CHECK-NEXT:    [[VECINS:%.*]] = insertelement <16 x i8> [[TMP0]], i8 [[S:%.*]], i32 3
; CHECK-NEXT:    store <16 x i8> [[VECINS]], <16 x i8>* [[Q]], align 16
; CHECK-NEXT:    ret void
;
entry:
  %0 = load <16 x i8>, <16 x i8>* %q
  %vecins = insertelement <16 x i8> %0, i8 %s, i32 3
  store <16 x i8> %vecins, <16 x i8>* %q
  ret void
}

define void @single_shuffle_store(<4 x i32>* %a, i32 %b) {
; CHECK-LABEL: @single_shuffle_store(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load <4 x i32>, <4 x i32>* [[A:%.*]], align 16
; CHECK-NEXT:    [[TMP1:%.*]] = insertelement <4 x i32> [[TMP0]], i32 [[B:%.*]], i32 1
; CHECK-NEXT:    store <4 x i32> [[TMP1]], <4 x i32>* [[A]], align 16, !nontemporal !0
; CHECK-NEXT:    ret void
;
entry:
  %0 = load <4 x i32>, <4 x i32>* %a
  %1 = insertelement <4 x i32> %0, i32 %b, i32 1
  %2 = shufflevector <4 x i32> %0, <4 x i32> %1, <4 x i32> <i32 0, i32 5, i32 2, i32 3>
  store <4 x i32> %2, <4 x i32>* %a, !nontemporal !0
  ret void
}

define void @volatile_update(<16 x i8>* %q, <16 x i8>* %p, i8 zeroext %s) {
; CHECK-LABEL: @volatile_update(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load <16 x i8>, <16 x i8>* [[Q:%.*]], align 16
; CHECK-NEXT:    [[VECINS0:%.*]] = insertelement <16 x i8> [[TMP0]], i8 [[S:%.*]], i32 3
; CHECK-NEXT:    store volatile <16 x i8> [[VECINS0]], <16 x i8>* [[Q]], align 16
; CHECK-NEXT:    [[TMP1:%.*]] = load volatile <16 x i8>, <16 x i8>* [[P:%.*]], align 16
; CHECK-NEXT:    [[VECINS1:%.*]] = insertelement <16 x i8> [[TMP1]], i8 [[S]], i32 1
; CHECK-NEXT:    store <16 x i8> [[VECINS1]], <16 x i8>* [[P]], align 16
; CHECK-NEXT:    ret void
;
entry:
  %0 = load <16 x i8>, <16 x i8>* %q
  %vecins0 = insertelement <16 x i8> %0, i8 %s, i32 3
  store volatile <16 x i8> %vecins0, <16 x i8>* %q

  %1 = load volatile <16 x i8>, <16 x i8>* %p
  %vecins1 = insertelement <16 x i8> %1, i8 %s, i32 1
  store <16 x i8> %vecins1, <16 x i8>* %p
  ret void
}

define void @insert_store_addr_differ(<16 x i8>* %p, <16 x i8>* %q, i8 %s) {
; CHECK-LABEL: @insert_store_addr_differ(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[LD:%.*]] = load <16 x i8>, <16 x i8>* [[P:%.*]], align 16
; CHECK-NEXT:    [[INS:%.*]] = insertelement <16 x i8> [[LD]], i8 [[S:%.*]], i32 3
; CHECK-NEXT:    store <16 x i8> [[INS]], <16 x i8>* [[Q:%.*]], align 16
; CHECK-NEXT:    ret void
;
entry:
  %ld = load <16 x i8>, <16 x i8>* %p
  %ins = insertelement <16 x i8> %ld, i8 %s, i32 3
  store <16 x i8> %ins, <16 x i8>* %q
  ret void
}

define void @insert_store_mem_modify(<16 x i8>* %p, <16 x i8>* %q, <16 x i8>* noalias %r, i8 %s) {
; CHECK-LABEL: @insert_store_mem_modify(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[LD:%.*]] = load <16 x i8>, <16 x i8>* [[P:%.*]], align 16
; CHECK-NEXT:    store <16 x i8> zeroinitializer, <16 x i8>* [[Q:%.*]], align 16
; CHECK-NEXT:    [[INS:%.*]] = insertelement <16 x i8> [[LD]], i8 [[S:%.*]], i32 3
; CHECK-NEXT:    store <16 x i8> [[INS]], <16 x i8>* [[P]], align 16
; CHECK-NEXT:    [[LD2:%.*]] = load <16 x i8>, <16 x i8>* [[Q]], align 16
; CHECK-NEXT:    store <16 x i8> zeroinitializer, <16 x i8>* [[R:%.*]], align 16
; CHECK-NEXT:    [[INS2:%.*]] = insertelement <16 x i8> [[LD2]], i8 [[S]], i32 7
; CHECK-NEXT:    store <16 x i8> [[INS2]], <16 x i8>* [[Q]], align 16
; CHECK-NEXT:    ret void
;
entry:
  %ld = load <16 x i8>, <16 x i8>* %p
  store <16 x i8> zeroinitializer, <16 x i8>* %q
  %ins = insertelement <16 x i8> %ld, i8 %s, i32 3
  store <16 x i8> %ins, <16 x i8>* %p

  %ld2 = load <16 x i8>, <16 x i8>* %q
  store <16 x i8> zeroinitializer, <16 x i8>* %r
  %ins2 = insertelement <16 x i8> %ld2, i8 %s, i32 7
  store <16 x i8> %ins2, <16 x i8>* %q
  ret void
}

!0 = !{}
