// RUN: llvm-mc -arch=amdgcn -mcpu=tonga -show-encoding %s | FileCheck %s

buffer_load_format_x v5, off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x00,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_x v255, off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x00,0xe0,0x00,0xff,0x02,0x03]

buffer_load_format_x v5, off, s[12:15], s3 offset:4095
// CHECK: [0xff,0x0f,0x00,0xe0,0x00,0x05,0x03,0x03]

buffer_load_format_x v5, off, s[96:99], s3 offset:4095
// CHECK: [0xff,0x0f,0x00,0xe0,0x00,0x05,0x18,0x03]

buffer_load_format_x v5, off, ttmp[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x00,0xe0,0x00,0x05,0x1e,0x03]

buffer_load_format_x v5, off, s[8:11], s101 offset:4095
// CHECK: [0xff,0x0f,0x00,0xe0,0x00,0x05,0x02,0x65]

buffer_load_format_x v5, off, s[8:11], flat_scratch_lo offset:4095
// CHECK: [0xff,0x0f,0x00,0xe0,0x00,0x05,0x02,0x66]

buffer_load_format_x v5, off, s[8:11], flat_scratch_hi offset:4095
// CHECK: [0xff,0x0f,0x00,0xe0,0x00,0x05,0x02,0x67]

buffer_load_format_x v5, off, s[8:11], vcc_lo offset:4095
// CHECK: [0xff,0x0f,0x00,0xe0,0x00,0x05,0x02,0x6a]

buffer_load_format_x v5, off, s[8:11], vcc_hi offset:4095
// CHECK: [0xff,0x0f,0x00,0xe0,0x00,0x05,0x02,0x6b]

buffer_load_format_x v5, off, s[8:11], tba_lo offset:4095
// CHECK: [0xff,0x0f,0x00,0xe0,0x00,0x05,0x02,0x6c]

buffer_load_format_x v5, off, s[8:11], tba_hi offset:4095
// CHECK: [0xff,0x0f,0x00,0xe0,0x00,0x05,0x02,0x6d]

buffer_load_format_x v5, off, s[8:11], tma_lo offset:4095
// CHECK: [0xff,0x0f,0x00,0xe0,0x00,0x05,0x02,0x6e]

buffer_load_format_x v5, off, s[8:11], tma_hi offset:4095
// CHECK: [0xff,0x0f,0x00,0xe0,0x00,0x05,0x02,0x6f]

buffer_load_format_x v5, off, s[8:11], ttmp11 offset:4095
// CHECK: [0xff,0x0f,0x00,0xe0,0x00,0x05,0x02,0x7b]

buffer_load_format_x v5, off, s[8:11], m0 offset:4095
// CHECK: [0xff,0x0f,0x00,0xe0,0x00,0x05,0x02,0x7c]

buffer_load_format_x v5, off, s[8:11], exec_lo offset:4095
// CHECK: [0xff,0x0f,0x00,0xe0,0x00,0x05,0x02,0x7e]

buffer_load_format_x v5, off, s[8:11], exec_hi offset:4095
// CHECK: [0xff,0x0f,0x00,0xe0,0x00,0x05,0x02,0x7f]

buffer_load_format_x v5, off, s[8:11], 0 offset:4095
// CHECK: [0xff,0x0f,0x00,0xe0,0x00,0x05,0x02,0x80]

buffer_load_format_x v5, off, s[8:11], -1 offset:4095
// CHECK: [0xff,0x0f,0x00,0xe0,0x00,0x05,0x02,0xc1]

buffer_load_format_x v5, off, s[8:11], 0.5 offset:4095
// CHECK: [0xff,0x0f,0x00,0xe0,0x00,0x05,0x02,0xf0]

buffer_load_format_x v5, off, s[8:11], -4.0 offset:4095
// CHECK: [0xff,0x0f,0x00,0xe0,0x00,0x05,0x02,0xf7]

buffer_load_format_x v5, off, s[8:11], src_vccz offset:4095
// CHECK: [0xff,0x0f,0x00,0xe0,0x00,0x05,0x02,0xfb]

buffer_load_format_x v5, off, s[8:11], src_execz offset:4095
// CHECK: [0xff,0x0f,0x00,0xe0,0x00,0x05,0x02,0xfc]

buffer_load_format_x v5, off, s[8:11], src_scc offset:4095
// CHECK: [0xff,0x0f,0x00,0xe0,0x00,0x05,0x02,0xfd]

buffer_load_format_x v5, v0, s[8:11], s3 idxen offset:4095
// CHECK: [0xff,0x2f,0x00,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_x v5, v0, s[8:11], s3 offen offset:4095
// CHECK: [0xff,0x1f,0x00,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_x v5, off, s[8:11], s3
// CHECK: [0x00,0x00,0x00,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_x v5, off, s[8:11], s3 offset:0
// CHECK: [0x00,0x00,0x00,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_x v5, off, s[8:11], s3 offset:7
// CHECK: [0x07,0x00,0x00,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_x v5, off, s[8:11], s3 offset:4095 glc
// CHECK: [0xff,0x4f,0x00,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_x v5, off, s[8:11], s3 offset:4095 slc
// CHECK: [0xff,0x0f,0x02,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_x off, s[8:11], s3 offset:4095 lds
// CHECK: [0xff,0x0f,0x01,0xe0,0x00,0x00,0x02,0x03]

buffer_load_format_xy v[5:6], off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x04,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xy v[254:255], off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x04,0xe0,0x00,0xfe,0x02,0x03]

buffer_load_format_xy v[5:6], off, s[12:15], s3 offset:4095
// CHECK: [0xff,0x0f,0x04,0xe0,0x00,0x05,0x03,0x03]

buffer_load_format_xy v[5:6], off, s[96:99], s3 offset:4095
// CHECK: [0xff,0x0f,0x04,0xe0,0x00,0x05,0x18,0x03]

buffer_load_format_xy v[5:6], off, ttmp[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x04,0xe0,0x00,0x05,0x1e,0x03]

buffer_load_format_xy v[5:6], off, s[8:11], s101 offset:4095
// CHECK: [0xff,0x0f,0x04,0xe0,0x00,0x05,0x02,0x65]

buffer_load_format_xy v[5:6], off, s[8:11], flat_scratch_lo offset:4095
// CHECK: [0xff,0x0f,0x04,0xe0,0x00,0x05,0x02,0x66]

buffer_load_format_xy v[5:6], off, s[8:11], flat_scratch_hi offset:4095
// CHECK: [0xff,0x0f,0x04,0xe0,0x00,0x05,0x02,0x67]

buffer_load_format_xy v[5:6], off, s[8:11], vcc_lo offset:4095
// CHECK: [0xff,0x0f,0x04,0xe0,0x00,0x05,0x02,0x6a]

buffer_load_format_xy v[5:6], off, s[8:11], vcc_hi offset:4095
// CHECK: [0xff,0x0f,0x04,0xe0,0x00,0x05,0x02,0x6b]

buffer_load_format_xy v[5:6], off, s[8:11], tba_lo offset:4095
// CHECK: [0xff,0x0f,0x04,0xe0,0x00,0x05,0x02,0x6c]

buffer_load_format_xy v[5:6], off, s[8:11], tba_hi offset:4095
// CHECK: [0xff,0x0f,0x04,0xe0,0x00,0x05,0x02,0x6d]

buffer_load_format_xy v[5:6], off, s[8:11], tma_lo offset:4095
// CHECK: [0xff,0x0f,0x04,0xe0,0x00,0x05,0x02,0x6e]

buffer_load_format_xy v[5:6], off, s[8:11], tma_hi offset:4095
// CHECK: [0xff,0x0f,0x04,0xe0,0x00,0x05,0x02,0x6f]

buffer_load_format_xy v[5:6], off, s[8:11], ttmp11 offset:4095
// CHECK: [0xff,0x0f,0x04,0xe0,0x00,0x05,0x02,0x7b]

buffer_load_format_xy v[5:6], off, s[8:11], m0 offset:4095
// CHECK: [0xff,0x0f,0x04,0xe0,0x00,0x05,0x02,0x7c]

buffer_load_format_xy v[5:6], off, s[8:11], exec_lo offset:4095
// CHECK: [0xff,0x0f,0x04,0xe0,0x00,0x05,0x02,0x7e]

buffer_load_format_xy v[5:6], off, s[8:11], exec_hi offset:4095
// CHECK: [0xff,0x0f,0x04,0xe0,0x00,0x05,0x02,0x7f]

buffer_load_format_xy v[5:6], off, s[8:11], 0 offset:4095
// CHECK: [0xff,0x0f,0x04,0xe0,0x00,0x05,0x02,0x80]

buffer_load_format_xy v[5:6], off, s[8:11], -1 offset:4095
// CHECK: [0xff,0x0f,0x04,0xe0,0x00,0x05,0x02,0xc1]

buffer_load_format_xy v[5:6], off, s[8:11], 0.5 offset:4095
// CHECK: [0xff,0x0f,0x04,0xe0,0x00,0x05,0x02,0xf0]

buffer_load_format_xy v[5:6], off, s[8:11], -4.0 offset:4095
// CHECK: [0xff,0x0f,0x04,0xe0,0x00,0x05,0x02,0xf7]

buffer_load_format_xy v[5:6], off, s[8:11], src_vccz offset:4095
// CHECK: [0xff,0x0f,0x04,0xe0,0x00,0x05,0x02,0xfb]

buffer_load_format_xy v[5:6], off, s[8:11], src_execz offset:4095
// CHECK: [0xff,0x0f,0x04,0xe0,0x00,0x05,0x02,0xfc]

buffer_load_format_xy v[5:6], off, s[8:11], src_scc offset:4095
// CHECK: [0xff,0x0f,0x04,0xe0,0x00,0x05,0x02,0xfd]

buffer_load_format_xy v[5:6], v0, s[8:11], s3 idxen offset:4095
// CHECK: [0xff,0x2f,0x04,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xy v[5:6], v0, s[8:11], s3 offen offset:4095
// CHECK: [0xff,0x1f,0x04,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xy v[5:6], off, s[8:11], s3
// CHECK: [0x00,0x00,0x04,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xy v[5:6], off, s[8:11], s3 offset:0
// CHECK: [0x00,0x00,0x04,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xy v[5:6], off, s[8:11], s3 offset:7
// CHECK: [0x07,0x00,0x04,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xy v[5:6], off, s[8:11], s3 offset:4095 glc
// CHECK: [0xff,0x4f,0x04,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xy v[5:6], off, s[8:11], s3 offset:4095 slc
// CHECK: [0xff,0x0f,0x06,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xyz v[5:7], off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x08,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xyz v[253:255], off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x08,0xe0,0x00,0xfd,0x02,0x03]

buffer_load_format_xyz v[5:7], off, s[12:15], s3 offset:4095
// CHECK: [0xff,0x0f,0x08,0xe0,0x00,0x05,0x03,0x03]

buffer_load_format_xyz v[5:7], off, s[96:99], s3 offset:4095
// CHECK: [0xff,0x0f,0x08,0xe0,0x00,0x05,0x18,0x03]

buffer_load_format_xyz v[5:7], off, ttmp[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x08,0xe0,0x00,0x05,0x1e,0x03]

buffer_load_format_xyz v[5:7], off, s[8:11], s101 offset:4095
// CHECK: [0xff,0x0f,0x08,0xe0,0x00,0x05,0x02,0x65]

buffer_load_format_xyz v[5:7], off, s[8:11], flat_scratch_lo offset:4095
// CHECK: [0xff,0x0f,0x08,0xe0,0x00,0x05,0x02,0x66]

buffer_load_format_xyz v[5:7], off, s[8:11], flat_scratch_hi offset:4095
// CHECK: [0xff,0x0f,0x08,0xe0,0x00,0x05,0x02,0x67]

buffer_load_format_xyz v[5:7], off, s[8:11], vcc_lo offset:4095
// CHECK: [0xff,0x0f,0x08,0xe0,0x00,0x05,0x02,0x6a]

buffer_load_format_xyz v[5:7], off, s[8:11], vcc_hi offset:4095
// CHECK: [0xff,0x0f,0x08,0xe0,0x00,0x05,0x02,0x6b]

buffer_load_format_xyz v[5:7], off, s[8:11], tba_lo offset:4095
// CHECK: [0xff,0x0f,0x08,0xe0,0x00,0x05,0x02,0x6c]

buffer_load_format_xyz v[5:7], off, s[8:11], tba_hi offset:4095
// CHECK: [0xff,0x0f,0x08,0xe0,0x00,0x05,0x02,0x6d]

buffer_load_format_xyz v[5:7], off, s[8:11], tma_lo offset:4095
// CHECK: [0xff,0x0f,0x08,0xe0,0x00,0x05,0x02,0x6e]

buffer_load_format_xyz v[5:7], off, s[8:11], tma_hi offset:4095
// CHECK: [0xff,0x0f,0x08,0xe0,0x00,0x05,0x02,0x6f]

buffer_load_format_xyz v[5:7], off, s[8:11], ttmp11 offset:4095
// CHECK: [0xff,0x0f,0x08,0xe0,0x00,0x05,0x02,0x7b]

buffer_load_format_xyz v[5:7], off, s[8:11], m0 offset:4095
// CHECK: [0xff,0x0f,0x08,0xe0,0x00,0x05,0x02,0x7c]

buffer_load_format_xyz v[5:7], off, s[8:11], exec_lo offset:4095
// CHECK: [0xff,0x0f,0x08,0xe0,0x00,0x05,0x02,0x7e]

buffer_load_format_xyz v[5:7], off, s[8:11], exec_hi offset:4095
// CHECK: [0xff,0x0f,0x08,0xe0,0x00,0x05,0x02,0x7f]

buffer_load_format_xyz v[5:7], off, s[8:11], 0 offset:4095
// CHECK: [0xff,0x0f,0x08,0xe0,0x00,0x05,0x02,0x80]

buffer_load_format_xyz v[5:7], off, s[8:11], -1 offset:4095
// CHECK: [0xff,0x0f,0x08,0xe0,0x00,0x05,0x02,0xc1]

buffer_load_format_xyz v[5:7], off, s[8:11], 0.5 offset:4095
// CHECK: [0xff,0x0f,0x08,0xe0,0x00,0x05,0x02,0xf0]

buffer_load_format_xyz v[5:7], off, s[8:11], -4.0 offset:4095
// CHECK: [0xff,0x0f,0x08,0xe0,0x00,0x05,0x02,0xf7]

buffer_load_format_xyz v[5:7], off, s[8:11], src_vccz offset:4095
// CHECK: [0xff,0x0f,0x08,0xe0,0x00,0x05,0x02,0xfb]

buffer_load_format_xyz v[5:7], off, s[8:11], src_execz offset:4095
// CHECK: [0xff,0x0f,0x08,0xe0,0x00,0x05,0x02,0xfc]

buffer_load_format_xyz v[5:7], off, s[8:11], src_scc offset:4095
// CHECK: [0xff,0x0f,0x08,0xe0,0x00,0x05,0x02,0xfd]

buffer_load_format_xyz v[5:7], v0, s[8:11], s3 idxen offset:4095
// CHECK: [0xff,0x2f,0x08,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xyz v[5:7], v0, s[8:11], s3 offen offset:4095
// CHECK: [0xff,0x1f,0x08,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xyz v[5:7], off, s[8:11], s3
// CHECK: [0x00,0x00,0x08,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xyz v[5:7], off, s[8:11], s3 offset:0
// CHECK: [0x00,0x00,0x08,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xyz v[5:7], off, s[8:11], s3 offset:7
// CHECK: [0x07,0x00,0x08,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xyz v[5:7], off, s[8:11], s3 offset:4095 glc
// CHECK: [0xff,0x4f,0x08,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xyz v[5:7], off, s[8:11], s3 offset:4095 slc
// CHECK: [0xff,0x0f,0x0a,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xyzw v[5:8], off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x0c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xyzw v[252:255], off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x0c,0xe0,0x00,0xfc,0x02,0x03]

buffer_load_format_xyzw v[5:8], off, s[12:15], s3 offset:4095
// CHECK: [0xff,0x0f,0x0c,0xe0,0x00,0x05,0x03,0x03]

buffer_load_format_xyzw v[5:8], off, s[96:99], s3 offset:4095
// CHECK: [0xff,0x0f,0x0c,0xe0,0x00,0x05,0x18,0x03]

buffer_load_format_xyzw v[5:8], off, ttmp[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x0c,0xe0,0x00,0x05,0x1e,0x03]

buffer_load_format_xyzw v[5:8], off, s[8:11], s101 offset:4095
// CHECK: [0xff,0x0f,0x0c,0xe0,0x00,0x05,0x02,0x65]

buffer_load_format_xyzw v[5:8], off, s[8:11], flat_scratch_lo offset:4095
// CHECK: [0xff,0x0f,0x0c,0xe0,0x00,0x05,0x02,0x66]

buffer_load_format_xyzw v[5:8], off, s[8:11], flat_scratch_hi offset:4095
// CHECK: [0xff,0x0f,0x0c,0xe0,0x00,0x05,0x02,0x67]

buffer_load_format_xyzw v[5:8], off, s[8:11], vcc_lo offset:4095
// CHECK: [0xff,0x0f,0x0c,0xe0,0x00,0x05,0x02,0x6a]

buffer_load_format_xyzw v[5:8], off, s[8:11], vcc_hi offset:4095
// CHECK: [0xff,0x0f,0x0c,0xe0,0x00,0x05,0x02,0x6b]

buffer_load_format_xyzw v[5:8], off, s[8:11], tba_lo offset:4095
// CHECK: [0xff,0x0f,0x0c,0xe0,0x00,0x05,0x02,0x6c]

buffer_load_format_xyzw v[5:8], off, s[8:11], tba_hi offset:4095
// CHECK: [0xff,0x0f,0x0c,0xe0,0x00,0x05,0x02,0x6d]

buffer_load_format_xyzw v[5:8], off, s[8:11], tma_lo offset:4095
// CHECK: [0xff,0x0f,0x0c,0xe0,0x00,0x05,0x02,0x6e]

buffer_load_format_xyzw v[5:8], off, s[8:11], tma_hi offset:4095
// CHECK: [0xff,0x0f,0x0c,0xe0,0x00,0x05,0x02,0x6f]

buffer_load_format_xyzw v[5:8], off, s[8:11], ttmp11 offset:4095
// CHECK: [0xff,0x0f,0x0c,0xe0,0x00,0x05,0x02,0x7b]

buffer_load_format_xyzw v[5:8], off, s[8:11], m0 offset:4095
// CHECK: [0xff,0x0f,0x0c,0xe0,0x00,0x05,0x02,0x7c]

buffer_load_format_xyzw v[5:8], off, s[8:11], exec_lo offset:4095
// CHECK: [0xff,0x0f,0x0c,0xe0,0x00,0x05,0x02,0x7e]

buffer_load_format_xyzw v[5:8], off, s[8:11], exec_hi offset:4095
// CHECK: [0xff,0x0f,0x0c,0xe0,0x00,0x05,0x02,0x7f]

buffer_load_format_xyzw v[5:8], off, s[8:11], 0 offset:4095
// CHECK: [0xff,0x0f,0x0c,0xe0,0x00,0x05,0x02,0x80]

buffer_load_format_xyzw v[5:8], off, s[8:11], -1 offset:4095
// CHECK: [0xff,0x0f,0x0c,0xe0,0x00,0x05,0x02,0xc1]

buffer_load_format_xyzw v[5:8], off, s[8:11], 0.5 offset:4095
// CHECK: [0xff,0x0f,0x0c,0xe0,0x00,0x05,0x02,0xf0]

buffer_load_format_xyzw v[5:8], off, s[8:11], -4.0 offset:4095
// CHECK: [0xff,0x0f,0x0c,0xe0,0x00,0x05,0x02,0xf7]

buffer_load_format_xyzw v[5:8], off, s[8:11], src_vccz offset:4095
// CHECK: [0xff,0x0f,0x0c,0xe0,0x00,0x05,0x02,0xfb]

buffer_load_format_xyzw v[5:8], off, s[8:11], src_execz offset:4095
// CHECK: [0xff,0x0f,0x0c,0xe0,0x00,0x05,0x02,0xfc]

buffer_load_format_xyzw v[5:8], off, s[8:11], src_scc offset:4095
// CHECK: [0xff,0x0f,0x0c,0xe0,0x00,0x05,0x02,0xfd]

buffer_load_format_xyzw v[5:8], v0, s[8:11], s3 idxen offset:4095
// CHECK: [0xff,0x2f,0x0c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xyzw v[5:8], v0, s[8:11], s3 offen offset:4095
// CHECK: [0xff,0x1f,0x0c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xyzw v[5:8], off, s[8:11], s3
// CHECK: [0x00,0x00,0x0c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xyzw v[5:8], off, s[8:11], s3 offset:0
// CHECK: [0x00,0x00,0x0c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xyzw v[5:8], off, s[8:11], s3 offset:7
// CHECK: [0x07,0x00,0x0c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xyzw v[5:8], off, s[8:11], s3 offset:4095 glc
// CHECK: [0xff,0x4f,0x0c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xyzw v[5:8], off, s[8:11], s3 offset:4095 slc
// CHECK: [0xff,0x0f,0x0e,0xe0,0x00,0x05,0x02,0x03]

buffer_store_format_x v1, off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0x10,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_x v255, off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0x10,0xe0,0x00,0xff,0x03,0x04]

buffer_store_format_x v1, off, s[16:19], s4 offset:4095
// CHECK: [0xff,0x0f,0x10,0xe0,0x00,0x01,0x04,0x04]

buffer_store_format_x v1, off, s[96:99], s4 offset:4095
// CHECK: [0xff,0x0f,0x10,0xe0,0x00,0x01,0x18,0x04]

buffer_store_format_x v1, off, ttmp[8:11], s4 offset:4095
// CHECK: [0xff,0x0f,0x10,0xe0,0x00,0x01,0x1e,0x04]

buffer_store_format_x v1, off, s[12:15], s101 offset:4095
// CHECK: [0xff,0x0f,0x10,0xe0,0x00,0x01,0x03,0x65]

buffer_store_format_x v1, off, s[12:15], flat_scratch_lo offset:4095
// CHECK: [0xff,0x0f,0x10,0xe0,0x00,0x01,0x03,0x66]

buffer_store_format_x v1, off, s[12:15], flat_scratch_hi offset:4095
// CHECK: [0xff,0x0f,0x10,0xe0,0x00,0x01,0x03,0x67]

buffer_store_format_x v1, off, s[12:15], vcc_lo offset:4095
// CHECK: [0xff,0x0f,0x10,0xe0,0x00,0x01,0x03,0x6a]

buffer_store_format_x v1, off, s[12:15], vcc_hi offset:4095
// CHECK: [0xff,0x0f,0x10,0xe0,0x00,0x01,0x03,0x6b]

buffer_store_format_x v1, off, s[12:15], tba_lo offset:4095
// CHECK: [0xff,0x0f,0x10,0xe0,0x00,0x01,0x03,0x6c]

buffer_store_format_x v1, off, s[12:15], tba_hi offset:4095
// CHECK: [0xff,0x0f,0x10,0xe0,0x00,0x01,0x03,0x6d]

buffer_store_format_x v1, off, s[12:15], tma_lo offset:4095
// CHECK: [0xff,0x0f,0x10,0xe0,0x00,0x01,0x03,0x6e]

buffer_store_format_x v1, off, s[12:15], tma_hi offset:4095
// CHECK: [0xff,0x0f,0x10,0xe0,0x00,0x01,0x03,0x6f]

buffer_store_format_x v1, off, s[12:15], ttmp11 offset:4095
// CHECK: [0xff,0x0f,0x10,0xe0,0x00,0x01,0x03,0x7b]

buffer_store_format_x v1, off, s[12:15], m0 offset:4095
// CHECK: [0xff,0x0f,0x10,0xe0,0x00,0x01,0x03,0x7c]

buffer_store_format_x v1, off, s[12:15], exec_lo offset:4095
// CHECK: [0xff,0x0f,0x10,0xe0,0x00,0x01,0x03,0x7e]

buffer_store_format_x v1, off, s[12:15], exec_hi offset:4095
// CHECK: [0xff,0x0f,0x10,0xe0,0x00,0x01,0x03,0x7f]

buffer_store_format_x v1, off, s[12:15], 0 offset:4095
// CHECK: [0xff,0x0f,0x10,0xe0,0x00,0x01,0x03,0x80]

buffer_store_format_x v1, off, s[12:15], -1 offset:4095
// CHECK: [0xff,0x0f,0x10,0xe0,0x00,0x01,0x03,0xc1]

buffer_store_format_x v1, off, s[12:15], 0.5 offset:4095
// CHECK: [0xff,0x0f,0x10,0xe0,0x00,0x01,0x03,0xf0]

buffer_store_format_x v1, off, s[12:15], -4.0 offset:4095
// CHECK: [0xff,0x0f,0x10,0xe0,0x00,0x01,0x03,0xf7]

buffer_store_format_x v1, off, s[12:15], src_vccz offset:4095
// CHECK: [0xff,0x0f,0x10,0xe0,0x00,0x01,0x03,0xfb]

buffer_store_format_x v1, off, s[12:15], src_execz offset:4095
// CHECK: [0xff,0x0f,0x10,0xe0,0x00,0x01,0x03,0xfc]

buffer_store_format_x v1, off, s[12:15], src_scc offset:4095
// CHECK: [0xff,0x0f,0x10,0xe0,0x00,0x01,0x03,0xfd]

buffer_store_format_x v1, v0, s[12:15], s4 idxen offset:4095
// CHECK: [0xff,0x2f,0x10,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_x v1, v0, s[12:15], s4 offen offset:4095
// CHECK: [0xff,0x1f,0x10,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_x v1, off, s[12:15], s4
// CHECK: [0x00,0x00,0x10,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_x v1, off, s[12:15], s4 offset:0
// CHECK: [0x00,0x00,0x10,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_x v1, off, s[12:15], s4 offset:7
// CHECK: [0x07,0x00,0x10,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_x v1, off, s[12:15], s4 offset:4095 glc
// CHECK: [0xff,0x4f,0x10,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_x v1, off, s[12:15], s4 offset:4095 slc
// CHECK: [0xff,0x0f,0x12,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xy v[1:2], off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0x14,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xy v[254:255], off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0x14,0xe0,0x00,0xfe,0x03,0x04]

buffer_store_format_xy v[1:2], off, s[16:19], s4 offset:4095
// CHECK: [0xff,0x0f,0x14,0xe0,0x00,0x01,0x04,0x04]

buffer_store_format_xy v[1:2], off, s[96:99], s4 offset:4095
// CHECK: [0xff,0x0f,0x14,0xe0,0x00,0x01,0x18,0x04]

buffer_store_format_xy v[1:2], off, ttmp[8:11], s4 offset:4095
// CHECK: [0xff,0x0f,0x14,0xe0,0x00,0x01,0x1e,0x04]

buffer_store_format_xy v[1:2], off, s[12:15], s101 offset:4095
// CHECK: [0xff,0x0f,0x14,0xe0,0x00,0x01,0x03,0x65]

buffer_store_format_xy v[1:2], off, s[12:15], flat_scratch_lo offset:4095
// CHECK: [0xff,0x0f,0x14,0xe0,0x00,0x01,0x03,0x66]

buffer_store_format_xy v[1:2], off, s[12:15], flat_scratch_hi offset:4095
// CHECK: [0xff,0x0f,0x14,0xe0,0x00,0x01,0x03,0x67]

buffer_store_format_xy v[1:2], off, s[12:15], vcc_lo offset:4095
// CHECK: [0xff,0x0f,0x14,0xe0,0x00,0x01,0x03,0x6a]

buffer_store_format_xy v[1:2], off, s[12:15], vcc_hi offset:4095
// CHECK: [0xff,0x0f,0x14,0xe0,0x00,0x01,0x03,0x6b]

buffer_store_format_xy v[1:2], off, s[12:15], tba_lo offset:4095
// CHECK: [0xff,0x0f,0x14,0xe0,0x00,0x01,0x03,0x6c]

buffer_store_format_xy v[1:2], off, s[12:15], tba_hi offset:4095
// CHECK: [0xff,0x0f,0x14,0xe0,0x00,0x01,0x03,0x6d]

buffer_store_format_xy v[1:2], off, s[12:15], tma_lo offset:4095
// CHECK: [0xff,0x0f,0x14,0xe0,0x00,0x01,0x03,0x6e]

buffer_store_format_xy v[1:2], off, s[12:15], tma_hi offset:4095
// CHECK: [0xff,0x0f,0x14,0xe0,0x00,0x01,0x03,0x6f]

buffer_store_format_xy v[1:2], off, s[12:15], ttmp11 offset:4095
// CHECK: [0xff,0x0f,0x14,0xe0,0x00,0x01,0x03,0x7b]

buffer_store_format_xy v[1:2], off, s[12:15], m0 offset:4095
// CHECK: [0xff,0x0f,0x14,0xe0,0x00,0x01,0x03,0x7c]

buffer_store_format_xy v[1:2], off, s[12:15], exec_lo offset:4095
// CHECK: [0xff,0x0f,0x14,0xe0,0x00,0x01,0x03,0x7e]

buffer_store_format_xy v[1:2], off, s[12:15], exec_hi offset:4095
// CHECK: [0xff,0x0f,0x14,0xe0,0x00,0x01,0x03,0x7f]

buffer_store_format_xy v[1:2], off, s[12:15], 0 offset:4095
// CHECK: [0xff,0x0f,0x14,0xe0,0x00,0x01,0x03,0x80]

buffer_store_format_xy v[1:2], off, s[12:15], -1 offset:4095
// CHECK: [0xff,0x0f,0x14,0xe0,0x00,0x01,0x03,0xc1]

buffer_store_format_xy v[1:2], off, s[12:15], 0.5 offset:4095
// CHECK: [0xff,0x0f,0x14,0xe0,0x00,0x01,0x03,0xf0]

buffer_store_format_xy v[1:2], off, s[12:15], -4.0 offset:4095
// CHECK: [0xff,0x0f,0x14,0xe0,0x00,0x01,0x03,0xf7]

buffer_store_format_xy v[1:2], off, s[12:15], src_vccz offset:4095
// CHECK: [0xff,0x0f,0x14,0xe0,0x00,0x01,0x03,0xfb]

buffer_store_format_xy v[1:2], off, s[12:15], src_execz offset:4095
// CHECK: [0xff,0x0f,0x14,0xe0,0x00,0x01,0x03,0xfc]

buffer_store_format_xy v[1:2], off, s[12:15], src_scc offset:4095
// CHECK: [0xff,0x0f,0x14,0xe0,0x00,0x01,0x03,0xfd]

buffer_store_format_xy v[1:2], v0, s[12:15], s4 idxen offset:4095
// CHECK: [0xff,0x2f,0x14,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xy v[1:2], v0, s[12:15], s4 offen offset:4095
// CHECK: [0xff,0x1f,0x14,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xy v[1:2], off, s[12:15], s4
// CHECK: [0x00,0x00,0x14,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xy v[1:2], off, s[12:15], s4 offset:0
// CHECK: [0x00,0x00,0x14,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xy v[1:2], off, s[12:15], s4 offset:7
// CHECK: [0x07,0x00,0x14,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xy v[1:2], off, s[12:15], s4 offset:4095 glc
// CHECK: [0xff,0x4f,0x14,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xy v[1:2], off, s[12:15], s4 offset:4095 slc
// CHECK: [0xff,0x0f,0x16,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xyz v[1:3], off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0x18,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xyz v[253:255], off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0x18,0xe0,0x00,0xfd,0x03,0x04]

buffer_store_format_xyz v[1:3], off, s[16:19], s4 offset:4095
// CHECK: [0xff,0x0f,0x18,0xe0,0x00,0x01,0x04,0x04]

buffer_store_format_xyz v[1:3], off, s[96:99], s4 offset:4095
// CHECK: [0xff,0x0f,0x18,0xe0,0x00,0x01,0x18,0x04]

buffer_store_format_xyz v[1:3], off, ttmp[8:11], s4 offset:4095
// CHECK: [0xff,0x0f,0x18,0xe0,0x00,0x01,0x1e,0x04]

buffer_store_format_xyz v[1:3], off, s[12:15], s101 offset:4095
// CHECK: [0xff,0x0f,0x18,0xe0,0x00,0x01,0x03,0x65]

buffer_store_format_xyz v[1:3], off, s[12:15], flat_scratch_lo offset:4095
// CHECK: [0xff,0x0f,0x18,0xe0,0x00,0x01,0x03,0x66]

buffer_store_format_xyz v[1:3], off, s[12:15], flat_scratch_hi offset:4095
// CHECK: [0xff,0x0f,0x18,0xe0,0x00,0x01,0x03,0x67]

buffer_store_format_xyz v[1:3], off, s[12:15], vcc_lo offset:4095
// CHECK: [0xff,0x0f,0x18,0xe0,0x00,0x01,0x03,0x6a]

buffer_store_format_xyz v[1:3], off, s[12:15], vcc_hi offset:4095
// CHECK: [0xff,0x0f,0x18,0xe0,0x00,0x01,0x03,0x6b]

buffer_store_format_xyz v[1:3], off, s[12:15], tba_lo offset:4095
// CHECK: [0xff,0x0f,0x18,0xe0,0x00,0x01,0x03,0x6c]

buffer_store_format_xyz v[1:3], off, s[12:15], tba_hi offset:4095
// CHECK: [0xff,0x0f,0x18,0xe0,0x00,0x01,0x03,0x6d]

buffer_store_format_xyz v[1:3], off, s[12:15], tma_lo offset:4095
// CHECK: [0xff,0x0f,0x18,0xe0,0x00,0x01,0x03,0x6e]

buffer_store_format_xyz v[1:3], off, s[12:15], tma_hi offset:4095
// CHECK: [0xff,0x0f,0x18,0xe0,0x00,0x01,0x03,0x6f]

buffer_store_format_xyz v[1:3], off, s[12:15], ttmp11 offset:4095
// CHECK: [0xff,0x0f,0x18,0xe0,0x00,0x01,0x03,0x7b]

buffer_store_format_xyz v[1:3], off, s[12:15], m0 offset:4095
// CHECK: [0xff,0x0f,0x18,0xe0,0x00,0x01,0x03,0x7c]

buffer_store_format_xyz v[1:3], off, s[12:15], exec_lo offset:4095
// CHECK: [0xff,0x0f,0x18,0xe0,0x00,0x01,0x03,0x7e]

buffer_store_format_xyz v[1:3], off, s[12:15], exec_hi offset:4095
// CHECK: [0xff,0x0f,0x18,0xe0,0x00,0x01,0x03,0x7f]

buffer_store_format_xyz v[1:3], off, s[12:15], 0 offset:4095
// CHECK: [0xff,0x0f,0x18,0xe0,0x00,0x01,0x03,0x80]

buffer_store_format_xyz v[1:3], off, s[12:15], -1 offset:4095
// CHECK: [0xff,0x0f,0x18,0xe0,0x00,0x01,0x03,0xc1]

buffer_store_format_xyz v[1:3], off, s[12:15], 0.5 offset:4095
// CHECK: [0xff,0x0f,0x18,0xe0,0x00,0x01,0x03,0xf0]

buffer_store_format_xyz v[1:3], off, s[12:15], -4.0 offset:4095
// CHECK: [0xff,0x0f,0x18,0xe0,0x00,0x01,0x03,0xf7]

buffer_store_format_xyz v[1:3], off, s[12:15], src_vccz offset:4095
// CHECK: [0xff,0x0f,0x18,0xe0,0x00,0x01,0x03,0xfb]

buffer_store_format_xyz v[1:3], off, s[12:15], src_execz offset:4095
// CHECK: [0xff,0x0f,0x18,0xe0,0x00,0x01,0x03,0xfc]

buffer_store_format_xyz v[1:3], off, s[12:15], src_scc offset:4095
// CHECK: [0xff,0x0f,0x18,0xe0,0x00,0x01,0x03,0xfd]

buffer_store_format_xyz v[1:3], v0, s[12:15], s4 idxen offset:4095
// CHECK: [0xff,0x2f,0x18,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xyz v[1:3], v0, s[12:15], s4 offen offset:4095
// CHECK: [0xff,0x1f,0x18,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xyz v[1:3], off, s[12:15], s4
// CHECK: [0x00,0x00,0x18,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xyz v[1:3], off, s[12:15], s4 offset:0
// CHECK: [0x00,0x00,0x18,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xyz v[1:3], off, s[12:15], s4 offset:7
// CHECK: [0x07,0x00,0x18,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xyz v[1:3], off, s[12:15], s4 offset:4095 glc
// CHECK: [0xff,0x4f,0x18,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xyz v[1:3], off, s[12:15], s4 offset:4095 slc
// CHECK: [0xff,0x0f,0x1a,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xyzw v[1:4], off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0x1c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xyzw v[252:255], off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0x1c,0xe0,0x00,0xfc,0x03,0x04]

buffer_store_format_xyzw v[1:4], off, s[16:19], s4 offset:4095
// CHECK: [0xff,0x0f,0x1c,0xe0,0x00,0x01,0x04,0x04]

buffer_store_format_xyzw v[1:4], off, s[96:99], s4 offset:4095
// CHECK: [0xff,0x0f,0x1c,0xe0,0x00,0x01,0x18,0x04]

buffer_store_format_xyzw v[1:4], off, ttmp[8:11], s4 offset:4095
// CHECK: [0xff,0x0f,0x1c,0xe0,0x00,0x01,0x1e,0x04]

buffer_store_format_xyzw v[1:4], off, s[12:15], s101 offset:4095
// CHECK: [0xff,0x0f,0x1c,0xe0,0x00,0x01,0x03,0x65]

buffer_store_format_xyzw v[1:4], off, s[12:15], flat_scratch_lo offset:4095
// CHECK: [0xff,0x0f,0x1c,0xe0,0x00,0x01,0x03,0x66]

buffer_store_format_xyzw v[1:4], off, s[12:15], flat_scratch_hi offset:4095
// CHECK: [0xff,0x0f,0x1c,0xe0,0x00,0x01,0x03,0x67]

buffer_store_format_xyzw v[1:4], off, s[12:15], vcc_lo offset:4095
// CHECK: [0xff,0x0f,0x1c,0xe0,0x00,0x01,0x03,0x6a]

buffer_store_format_xyzw v[1:4], off, s[12:15], vcc_hi offset:4095
// CHECK: [0xff,0x0f,0x1c,0xe0,0x00,0x01,0x03,0x6b]

buffer_store_format_xyzw v[1:4], off, s[12:15], tba_lo offset:4095
// CHECK: [0xff,0x0f,0x1c,0xe0,0x00,0x01,0x03,0x6c]

buffer_store_format_xyzw v[1:4], off, s[12:15], tba_hi offset:4095
// CHECK: [0xff,0x0f,0x1c,0xe0,0x00,0x01,0x03,0x6d]

buffer_store_format_xyzw v[1:4], off, s[12:15], tma_lo offset:4095
// CHECK: [0xff,0x0f,0x1c,0xe0,0x00,0x01,0x03,0x6e]

buffer_store_format_xyzw v[1:4], off, s[12:15], tma_hi offset:4095
// CHECK: [0xff,0x0f,0x1c,0xe0,0x00,0x01,0x03,0x6f]

buffer_store_format_xyzw v[1:4], off, s[12:15], ttmp11 offset:4095
// CHECK: [0xff,0x0f,0x1c,0xe0,0x00,0x01,0x03,0x7b]

buffer_store_format_xyzw v[1:4], off, s[12:15], m0 offset:4095
// CHECK: [0xff,0x0f,0x1c,0xe0,0x00,0x01,0x03,0x7c]

buffer_store_format_xyzw v[1:4], off, s[12:15], exec_lo offset:4095
// CHECK: [0xff,0x0f,0x1c,0xe0,0x00,0x01,0x03,0x7e]

buffer_store_format_xyzw v[1:4], off, s[12:15], exec_hi offset:4095
// CHECK: [0xff,0x0f,0x1c,0xe0,0x00,0x01,0x03,0x7f]

buffer_store_format_xyzw v[1:4], off, s[12:15], 0 offset:4095
// CHECK: [0xff,0x0f,0x1c,0xe0,0x00,0x01,0x03,0x80]

buffer_store_format_xyzw v[1:4], off, s[12:15], -1 offset:4095
// CHECK: [0xff,0x0f,0x1c,0xe0,0x00,0x01,0x03,0xc1]

buffer_store_format_xyzw v[1:4], off, s[12:15], 0.5 offset:4095
// CHECK: [0xff,0x0f,0x1c,0xe0,0x00,0x01,0x03,0xf0]

buffer_store_format_xyzw v[1:4], off, s[12:15], -4.0 offset:4095
// CHECK: [0xff,0x0f,0x1c,0xe0,0x00,0x01,0x03,0xf7]

buffer_store_format_xyzw v[1:4], off, s[12:15], src_vccz offset:4095
// CHECK: [0xff,0x0f,0x1c,0xe0,0x00,0x01,0x03,0xfb]

buffer_store_format_xyzw v[1:4], off, s[12:15], src_execz offset:4095
// CHECK: [0xff,0x0f,0x1c,0xe0,0x00,0x01,0x03,0xfc]

buffer_store_format_xyzw v[1:4], off, s[12:15], src_scc offset:4095
// CHECK: [0xff,0x0f,0x1c,0xe0,0x00,0x01,0x03,0xfd]

buffer_store_format_xyzw v[1:4], v0, s[12:15], s4 idxen offset:4095
// CHECK: [0xff,0x2f,0x1c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xyzw v[1:4], v0, s[12:15], s4 offen offset:4095
// CHECK: [0xff,0x1f,0x1c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xyzw v[1:4], off, s[12:15], s4
// CHECK: [0x00,0x00,0x1c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xyzw v[1:4], off, s[12:15], s4 offset:0
// CHECK: [0x00,0x00,0x1c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xyzw v[1:4], off, s[12:15], s4 offset:7
// CHECK: [0x07,0x00,0x1c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xyzw v[1:4], off, s[12:15], s4 offset:4095 glc
// CHECK: [0xff,0x4f,0x1c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xyzw v[1:4], off, s[12:15], s4 offset:4095 slc
// CHECK: [0xff,0x0f,0x1e,0xe0,0x00,0x01,0x03,0x04]

buffer_load_format_d16_x v5, off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x20,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_d16_x v255, off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x20,0xe0,0x00,0xff,0x02,0x03]

buffer_load_format_d16_x v5, off, s[12:15], s3 offset:4095
// CHECK: [0xff,0x0f,0x20,0xe0,0x00,0x05,0x03,0x03]

buffer_load_format_d16_x v5, off, s[96:99], s3 offset:4095
// CHECK: [0xff,0x0f,0x20,0xe0,0x00,0x05,0x18,0x03]

buffer_load_format_d16_x v5, off, ttmp[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x20,0xe0,0x00,0x05,0x1e,0x03]

buffer_load_format_d16_x v5, off, s[8:11], s101 offset:4095
// CHECK: [0xff,0x0f,0x20,0xe0,0x00,0x05,0x02,0x65]

buffer_load_format_d16_x v5, off, s[8:11], flat_scratch_lo offset:4095
// CHECK: [0xff,0x0f,0x20,0xe0,0x00,0x05,0x02,0x66]

buffer_load_format_d16_x v5, off, s[8:11], flat_scratch_hi offset:4095
// CHECK: [0xff,0x0f,0x20,0xe0,0x00,0x05,0x02,0x67]

buffer_load_format_d16_x v5, off, s[8:11], vcc_lo offset:4095
// CHECK: [0xff,0x0f,0x20,0xe0,0x00,0x05,0x02,0x6a]

buffer_load_format_d16_x v5, off, s[8:11], vcc_hi offset:4095
// CHECK: [0xff,0x0f,0x20,0xe0,0x00,0x05,0x02,0x6b]

buffer_load_format_d16_x v5, off, s[8:11], tba_lo offset:4095
// CHECK: [0xff,0x0f,0x20,0xe0,0x00,0x05,0x02,0x6c]

buffer_load_format_d16_x v5, off, s[8:11], tba_hi offset:4095
// CHECK: [0xff,0x0f,0x20,0xe0,0x00,0x05,0x02,0x6d]

buffer_load_format_d16_x v5, off, s[8:11], tma_lo offset:4095
// CHECK: [0xff,0x0f,0x20,0xe0,0x00,0x05,0x02,0x6e]

buffer_load_format_d16_x v5, off, s[8:11], tma_hi offset:4095
// CHECK: [0xff,0x0f,0x20,0xe0,0x00,0x05,0x02,0x6f]

buffer_load_format_d16_x v5, off, s[8:11], ttmp11 offset:4095
// CHECK: [0xff,0x0f,0x20,0xe0,0x00,0x05,0x02,0x7b]

buffer_load_format_d16_x v5, off, s[8:11], m0 offset:4095
// CHECK: [0xff,0x0f,0x20,0xe0,0x00,0x05,0x02,0x7c]

buffer_load_format_d16_x v5, off, s[8:11], exec_lo offset:4095
// CHECK: [0xff,0x0f,0x20,0xe0,0x00,0x05,0x02,0x7e]

buffer_load_format_d16_x v5, off, s[8:11], exec_hi offset:4095
// CHECK: [0xff,0x0f,0x20,0xe0,0x00,0x05,0x02,0x7f]

buffer_load_format_d16_x v5, off, s[8:11], 0 offset:4095
// CHECK: [0xff,0x0f,0x20,0xe0,0x00,0x05,0x02,0x80]

buffer_load_format_d16_x v5, off, s[8:11], -1 offset:4095
// CHECK: [0xff,0x0f,0x20,0xe0,0x00,0x05,0x02,0xc1]

buffer_load_format_d16_x v5, off, s[8:11], 0.5 offset:4095
// CHECK: [0xff,0x0f,0x20,0xe0,0x00,0x05,0x02,0xf0]

buffer_load_format_d16_x v5, off, s[8:11], -4.0 offset:4095
// CHECK: [0xff,0x0f,0x20,0xe0,0x00,0x05,0x02,0xf7]

buffer_load_format_d16_x v5, off, s[8:11], src_vccz offset:4095
// CHECK: [0xff,0x0f,0x20,0xe0,0x00,0x05,0x02,0xfb]

buffer_load_format_d16_x v5, off, s[8:11], src_execz offset:4095
// CHECK: [0xff,0x0f,0x20,0xe0,0x00,0x05,0x02,0xfc]

buffer_load_format_d16_x v5, off, s[8:11], src_scc offset:4095
// CHECK: [0xff,0x0f,0x20,0xe0,0x00,0x05,0x02,0xfd]

buffer_load_format_d16_x v5, v0, s[8:11], s3 idxen offset:4095
// CHECK: [0xff,0x2f,0x20,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_d16_x v5, v0, s[8:11], s3 offen offset:4095
// CHECK: [0xff,0x1f,0x20,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_d16_x v5, off, s[8:11], s3
// CHECK: [0x00,0x00,0x20,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_d16_x v5, off, s[8:11], s3 offset:0
// CHECK: [0x00,0x00,0x20,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_d16_x v5, off, s[8:11], s3 offset:7
// CHECK: [0x07,0x00,0x20,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_d16_x v5, off, s[8:11], s3 offset:4095 glc
// CHECK: [0xff,0x4f,0x20,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_d16_x v5, off, s[8:11], s3 offset:4095 slc
// CHECK: [0xff,0x0f,0x22,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_d16_xy v[5:6], off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x24,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_d16_xy v[254:255], off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x24,0xe0,0x00,0xfe,0x02,0x03]

buffer_load_format_d16_xy v[5:6], off, s[12:15], s3 offset:4095
// CHECK: [0xff,0x0f,0x24,0xe0,0x00,0x05,0x03,0x03]

buffer_load_format_d16_xy v[5:6], off, s[96:99], s3 offset:4095
// CHECK: [0xff,0x0f,0x24,0xe0,0x00,0x05,0x18,0x03]

buffer_load_format_d16_xy v[5:6], off, ttmp[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x24,0xe0,0x00,0x05,0x1e,0x03]

buffer_load_format_d16_xy v[5:6], off, s[8:11], s101 offset:4095
// CHECK: [0xff,0x0f,0x24,0xe0,0x00,0x05,0x02,0x65]

buffer_load_format_d16_xy v[5:6], off, s[8:11], flat_scratch_lo offset:4095
// CHECK: [0xff,0x0f,0x24,0xe0,0x00,0x05,0x02,0x66]

buffer_load_format_d16_xy v[5:6], off, s[8:11], flat_scratch_hi offset:4095
// CHECK: [0xff,0x0f,0x24,0xe0,0x00,0x05,0x02,0x67]

buffer_load_format_d16_xy v[5:6], off, s[8:11], vcc_lo offset:4095
// CHECK: [0xff,0x0f,0x24,0xe0,0x00,0x05,0x02,0x6a]

buffer_load_format_d16_xy v[5:6], off, s[8:11], vcc_hi offset:4095
// CHECK: [0xff,0x0f,0x24,0xe0,0x00,0x05,0x02,0x6b]

buffer_load_format_d16_xy v[5:6], off, s[8:11], tba_lo offset:4095
// CHECK: [0xff,0x0f,0x24,0xe0,0x00,0x05,0x02,0x6c]

buffer_load_format_d16_xy v[5:6], off, s[8:11], tba_hi offset:4095
// CHECK: [0xff,0x0f,0x24,0xe0,0x00,0x05,0x02,0x6d]

buffer_load_format_d16_xy v[5:6], off, s[8:11], tma_lo offset:4095
// CHECK: [0xff,0x0f,0x24,0xe0,0x00,0x05,0x02,0x6e]

buffer_load_format_d16_xy v[5:6], off, s[8:11], tma_hi offset:4095
// CHECK: [0xff,0x0f,0x24,0xe0,0x00,0x05,0x02,0x6f]

buffer_load_format_d16_xy v[5:6], off, s[8:11], ttmp11 offset:4095
// CHECK: [0xff,0x0f,0x24,0xe0,0x00,0x05,0x02,0x7b]

buffer_load_format_d16_xy v[5:6], off, s[8:11], m0 offset:4095
// CHECK: [0xff,0x0f,0x24,0xe0,0x00,0x05,0x02,0x7c]

buffer_load_format_d16_xy v[5:6], off, s[8:11], exec_lo offset:4095
// CHECK: [0xff,0x0f,0x24,0xe0,0x00,0x05,0x02,0x7e]

buffer_load_format_d16_xy v[5:6], off, s[8:11], exec_hi offset:4095
// CHECK: [0xff,0x0f,0x24,0xe0,0x00,0x05,0x02,0x7f]

buffer_load_format_d16_xy v[5:6], off, s[8:11], 0 offset:4095
// CHECK: [0xff,0x0f,0x24,0xe0,0x00,0x05,0x02,0x80]

buffer_load_format_d16_xy v[5:6], off, s[8:11], -1 offset:4095
// CHECK: [0xff,0x0f,0x24,0xe0,0x00,0x05,0x02,0xc1]

buffer_load_format_d16_xy v[5:6], off, s[8:11], 0.5 offset:4095
// CHECK: [0xff,0x0f,0x24,0xe0,0x00,0x05,0x02,0xf0]

buffer_load_format_d16_xy v[5:6], off, s[8:11], -4.0 offset:4095
// CHECK: [0xff,0x0f,0x24,0xe0,0x00,0x05,0x02,0xf7]

buffer_load_format_d16_xy v[5:6], off, s[8:11], src_vccz offset:4095
// CHECK: [0xff,0x0f,0x24,0xe0,0x00,0x05,0x02,0xfb]

buffer_load_format_d16_xy v[5:6], off, s[8:11], src_execz offset:4095
// CHECK: [0xff,0x0f,0x24,0xe0,0x00,0x05,0x02,0xfc]

buffer_load_format_d16_xy v[5:6], off, s[8:11], src_scc offset:4095
// CHECK: [0xff,0x0f,0x24,0xe0,0x00,0x05,0x02,0xfd]

buffer_load_format_d16_xy v[5:6], v0, s[8:11], s3 idxen offset:4095
// CHECK: [0xff,0x2f,0x24,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_d16_xy v[5:6], v0, s[8:11], s3 offen offset:4095
// CHECK: [0xff,0x1f,0x24,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_d16_xy v[5:6], off, s[8:11], s3
// CHECK: [0x00,0x00,0x24,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_d16_xy v[5:6], off, s[8:11], s3 offset:0
// CHECK: [0x00,0x00,0x24,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_d16_xy v[5:6], off, s[8:11], s3 offset:7
// CHECK: [0x07,0x00,0x24,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_d16_xy v[5:6], off, s[8:11], s3 offset:4095 glc
// CHECK: [0xff,0x4f,0x24,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_d16_xy v[5:6], off, s[8:11], s3 offset:4095 slc
// CHECK: [0xff,0x0f,0x26,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_d16_xyz v[5:7], off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x28,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_d16_xyz v[253:255], off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x28,0xe0,0x00,0xfd,0x02,0x03]

buffer_load_format_d16_xyz v[5:7], off, s[12:15], s3 offset:4095
// CHECK: [0xff,0x0f,0x28,0xe0,0x00,0x05,0x03,0x03]

buffer_load_format_d16_xyz v[5:7], off, s[96:99], s3 offset:4095
// CHECK: [0xff,0x0f,0x28,0xe0,0x00,0x05,0x18,0x03]

buffer_load_format_d16_xyz v[5:7], off, ttmp[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x28,0xe0,0x00,0x05,0x1e,0x03]

buffer_load_format_d16_xyz v[5:7], off, s[8:11], s101 offset:4095
// CHECK: [0xff,0x0f,0x28,0xe0,0x00,0x05,0x02,0x65]

buffer_load_format_d16_xyz v[5:7], off, s[8:11], flat_scratch_lo offset:4095
// CHECK: [0xff,0x0f,0x28,0xe0,0x00,0x05,0x02,0x66]

buffer_load_format_d16_xyz v[5:7], off, s[8:11], flat_scratch_hi offset:4095
// CHECK: [0xff,0x0f,0x28,0xe0,0x00,0x05,0x02,0x67]

buffer_load_format_d16_xyz v[5:7], off, s[8:11], vcc_lo offset:4095
// CHECK: [0xff,0x0f,0x28,0xe0,0x00,0x05,0x02,0x6a]

buffer_load_format_d16_xyz v[5:7], off, s[8:11], vcc_hi offset:4095
// CHECK: [0xff,0x0f,0x28,0xe0,0x00,0x05,0x02,0x6b]

buffer_load_format_d16_xyz v[5:7], off, s[8:11], tba_lo offset:4095
// CHECK: [0xff,0x0f,0x28,0xe0,0x00,0x05,0x02,0x6c]

buffer_load_format_d16_xyz v[5:7], off, s[8:11], tba_hi offset:4095
// CHECK: [0xff,0x0f,0x28,0xe0,0x00,0x05,0x02,0x6d]

buffer_load_format_d16_xyz v[5:7], off, s[8:11], tma_lo offset:4095
// CHECK: [0xff,0x0f,0x28,0xe0,0x00,0x05,0x02,0x6e]

buffer_load_format_d16_xyz v[5:7], off, s[8:11], tma_hi offset:4095
// CHECK: [0xff,0x0f,0x28,0xe0,0x00,0x05,0x02,0x6f]

buffer_load_format_d16_xyz v[5:7], off, s[8:11], ttmp11 offset:4095
// CHECK: [0xff,0x0f,0x28,0xe0,0x00,0x05,0x02,0x7b]

buffer_load_format_d16_xyz v[5:7], off, s[8:11], m0 offset:4095
// CHECK: [0xff,0x0f,0x28,0xe0,0x00,0x05,0x02,0x7c]

buffer_load_format_d16_xyz v[5:7], off, s[8:11], exec_lo offset:4095
// CHECK: [0xff,0x0f,0x28,0xe0,0x00,0x05,0x02,0x7e]

buffer_load_format_d16_xyz v[5:7], off, s[8:11], exec_hi offset:4095
// CHECK: [0xff,0x0f,0x28,0xe0,0x00,0x05,0x02,0x7f]

buffer_load_format_d16_xyz v[5:7], off, s[8:11], 0 offset:4095
// CHECK: [0xff,0x0f,0x28,0xe0,0x00,0x05,0x02,0x80]

buffer_load_format_d16_xyz v[5:7], off, s[8:11], -1 offset:4095
// CHECK: [0xff,0x0f,0x28,0xe0,0x00,0x05,0x02,0xc1]

buffer_load_format_d16_xyz v[5:7], off, s[8:11], 0.5 offset:4095
// CHECK: [0xff,0x0f,0x28,0xe0,0x00,0x05,0x02,0xf0]

buffer_load_format_d16_xyz v[5:7], off, s[8:11], -4.0 offset:4095
// CHECK: [0xff,0x0f,0x28,0xe0,0x00,0x05,0x02,0xf7]

buffer_load_format_d16_xyz v[5:7], off, s[8:11], src_vccz offset:4095
// CHECK: [0xff,0x0f,0x28,0xe0,0x00,0x05,0x02,0xfb]

buffer_load_format_d16_xyz v[5:7], off, s[8:11], src_execz offset:4095
// CHECK: [0xff,0x0f,0x28,0xe0,0x00,0x05,0x02,0xfc]

buffer_load_format_d16_xyz v[5:7], off, s[8:11], src_scc offset:4095
// CHECK: [0xff,0x0f,0x28,0xe0,0x00,0x05,0x02,0xfd]

buffer_load_format_d16_xyz v[5:7], v0, s[8:11], s3 idxen offset:4095
// CHECK: [0xff,0x2f,0x28,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_d16_xyz v[5:7], v0, s[8:11], s3 offen offset:4095
// CHECK: [0xff,0x1f,0x28,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_d16_xyz v[5:7], off, s[8:11], s3
// CHECK: [0x00,0x00,0x28,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_d16_xyz v[5:7], off, s[8:11], s3 offset:0
// CHECK: [0x00,0x00,0x28,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_d16_xyz v[5:7], off, s[8:11], s3 offset:7
// CHECK: [0x07,0x00,0x28,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_d16_xyz v[5:7], off, s[8:11], s3 offset:4095 glc
// CHECK: [0xff,0x4f,0x28,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_d16_xyz v[5:7], off, s[8:11], s3 offset:4095 slc
// CHECK: [0xff,0x0f,0x2a,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_d16_xyzw v[5:8], off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x2c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_d16_xyzw v[252:255], off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x2c,0xe0,0x00,0xfc,0x02,0x03]

buffer_load_format_d16_xyzw v[5:8], off, s[12:15], s3 offset:4095
// CHECK: [0xff,0x0f,0x2c,0xe0,0x00,0x05,0x03,0x03]

buffer_load_format_d16_xyzw v[5:8], off, s[96:99], s3 offset:4095
// CHECK: [0xff,0x0f,0x2c,0xe0,0x00,0x05,0x18,0x03]

buffer_load_format_d16_xyzw v[5:8], off, ttmp[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x2c,0xe0,0x00,0x05,0x1e,0x03]

buffer_load_format_d16_xyzw v[5:8], off, s[8:11], s101 offset:4095
// CHECK: [0xff,0x0f,0x2c,0xe0,0x00,0x05,0x02,0x65]

buffer_load_format_d16_xyzw v[5:8], off, s[8:11], flat_scratch_lo offset:4095
// CHECK: [0xff,0x0f,0x2c,0xe0,0x00,0x05,0x02,0x66]

buffer_load_format_d16_xyzw v[5:8], off, s[8:11], flat_scratch_hi offset:4095
// CHECK: [0xff,0x0f,0x2c,0xe0,0x00,0x05,0x02,0x67]

buffer_load_format_d16_xyzw v[5:8], off, s[8:11], vcc_lo offset:4095
// CHECK: [0xff,0x0f,0x2c,0xe0,0x00,0x05,0x02,0x6a]

buffer_load_format_d16_xyzw v[5:8], off, s[8:11], vcc_hi offset:4095
// CHECK: [0xff,0x0f,0x2c,0xe0,0x00,0x05,0x02,0x6b]

buffer_load_format_d16_xyzw v[5:8], off, s[8:11], tba_lo offset:4095
// CHECK: [0xff,0x0f,0x2c,0xe0,0x00,0x05,0x02,0x6c]

buffer_load_format_d16_xyzw v[5:8], off, s[8:11], tba_hi offset:4095
// CHECK: [0xff,0x0f,0x2c,0xe0,0x00,0x05,0x02,0x6d]

buffer_load_format_d16_xyzw v[5:8], off, s[8:11], tma_lo offset:4095
// CHECK: [0xff,0x0f,0x2c,0xe0,0x00,0x05,0x02,0x6e]

buffer_load_format_d16_xyzw v[5:8], off, s[8:11], tma_hi offset:4095
// CHECK: [0xff,0x0f,0x2c,0xe0,0x00,0x05,0x02,0x6f]

buffer_load_format_d16_xyzw v[5:8], off, s[8:11], ttmp11 offset:4095
// CHECK: [0xff,0x0f,0x2c,0xe0,0x00,0x05,0x02,0x7b]

buffer_load_format_d16_xyzw v[5:8], off, s[8:11], m0 offset:4095
// CHECK: [0xff,0x0f,0x2c,0xe0,0x00,0x05,0x02,0x7c]

buffer_load_format_d16_xyzw v[5:8], off, s[8:11], exec_lo offset:4095
// CHECK: [0xff,0x0f,0x2c,0xe0,0x00,0x05,0x02,0x7e]

buffer_load_format_d16_xyzw v[5:8], off, s[8:11], exec_hi offset:4095
// CHECK: [0xff,0x0f,0x2c,0xe0,0x00,0x05,0x02,0x7f]

buffer_load_format_d16_xyzw v[5:8], off, s[8:11], 0 offset:4095
// CHECK: [0xff,0x0f,0x2c,0xe0,0x00,0x05,0x02,0x80]

buffer_load_format_d16_xyzw v[5:8], off, s[8:11], -1 offset:4095
// CHECK: [0xff,0x0f,0x2c,0xe0,0x00,0x05,0x02,0xc1]

buffer_load_format_d16_xyzw v[5:8], off, s[8:11], 0.5 offset:4095
// CHECK: [0xff,0x0f,0x2c,0xe0,0x00,0x05,0x02,0xf0]

buffer_load_format_d16_xyzw v[5:8], off, s[8:11], -4.0 offset:4095
// CHECK: [0xff,0x0f,0x2c,0xe0,0x00,0x05,0x02,0xf7]

buffer_load_format_d16_xyzw v[5:8], off, s[8:11], src_vccz offset:4095
// CHECK: [0xff,0x0f,0x2c,0xe0,0x00,0x05,0x02,0xfb]

buffer_load_format_d16_xyzw v[5:8], off, s[8:11], src_execz offset:4095
// CHECK: [0xff,0x0f,0x2c,0xe0,0x00,0x05,0x02,0xfc]

buffer_load_format_d16_xyzw v[5:8], off, s[8:11], src_scc offset:4095
// CHECK: [0xff,0x0f,0x2c,0xe0,0x00,0x05,0x02,0xfd]

buffer_load_format_d16_xyzw v[5:8], v0, s[8:11], s3 idxen offset:4095
// CHECK: [0xff,0x2f,0x2c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_d16_xyzw v[5:8], v0, s[8:11], s3 offen offset:4095
// CHECK: [0xff,0x1f,0x2c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_d16_xyzw v[5:8], off, s[8:11], s3
// CHECK: [0x00,0x00,0x2c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_d16_xyzw v[5:8], off, s[8:11], s3 offset:0
// CHECK: [0x00,0x00,0x2c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_d16_xyzw v[5:8], off, s[8:11], s3 offset:7
// CHECK: [0x07,0x00,0x2c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_d16_xyzw v[5:8], off, s[8:11], s3 offset:4095 glc
// CHECK: [0xff,0x4f,0x2c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_d16_xyzw v[5:8], off, s[8:11], s3 offset:4095 slc
// CHECK: [0xff,0x0f,0x2e,0xe0,0x00,0x05,0x02,0x03]

buffer_store_format_d16_x v1, off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0x30,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_d16_x v255, off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0x30,0xe0,0x00,0xff,0x03,0x04]

buffer_store_format_d16_x v1, off, s[16:19], s4 offset:4095
// CHECK: [0xff,0x0f,0x30,0xe0,0x00,0x01,0x04,0x04]

buffer_store_format_d16_x v1, off, s[96:99], s4 offset:4095
// CHECK: [0xff,0x0f,0x30,0xe0,0x00,0x01,0x18,0x04]

buffer_store_format_d16_x v1, off, ttmp[8:11], s4 offset:4095
// CHECK: [0xff,0x0f,0x30,0xe0,0x00,0x01,0x1e,0x04]

buffer_store_format_d16_x v1, off, s[12:15], s101 offset:4095
// CHECK: [0xff,0x0f,0x30,0xe0,0x00,0x01,0x03,0x65]

buffer_store_format_d16_x v1, off, s[12:15], flat_scratch_lo offset:4095
// CHECK: [0xff,0x0f,0x30,0xe0,0x00,0x01,0x03,0x66]

buffer_store_format_d16_x v1, off, s[12:15], flat_scratch_hi offset:4095
// CHECK: [0xff,0x0f,0x30,0xe0,0x00,0x01,0x03,0x67]

buffer_store_format_d16_x v1, off, s[12:15], vcc_lo offset:4095
// CHECK: [0xff,0x0f,0x30,0xe0,0x00,0x01,0x03,0x6a]

buffer_store_format_d16_x v1, off, s[12:15], vcc_hi offset:4095
// CHECK: [0xff,0x0f,0x30,0xe0,0x00,0x01,0x03,0x6b]

buffer_store_format_d16_x v1, off, s[12:15], tba_lo offset:4095
// CHECK: [0xff,0x0f,0x30,0xe0,0x00,0x01,0x03,0x6c]

buffer_store_format_d16_x v1, off, s[12:15], tba_hi offset:4095
// CHECK: [0xff,0x0f,0x30,0xe0,0x00,0x01,0x03,0x6d]

buffer_store_format_d16_x v1, off, s[12:15], tma_lo offset:4095
// CHECK: [0xff,0x0f,0x30,0xe0,0x00,0x01,0x03,0x6e]

buffer_store_format_d16_x v1, off, s[12:15], tma_hi offset:4095
// CHECK: [0xff,0x0f,0x30,0xe0,0x00,0x01,0x03,0x6f]

buffer_store_format_d16_x v1, off, s[12:15], ttmp11 offset:4095
// CHECK: [0xff,0x0f,0x30,0xe0,0x00,0x01,0x03,0x7b]

buffer_store_format_d16_x v1, off, s[12:15], m0 offset:4095
// CHECK: [0xff,0x0f,0x30,0xe0,0x00,0x01,0x03,0x7c]

buffer_store_format_d16_x v1, off, s[12:15], exec_lo offset:4095
// CHECK: [0xff,0x0f,0x30,0xe0,0x00,0x01,0x03,0x7e]

buffer_store_format_d16_x v1, off, s[12:15], exec_hi offset:4095
// CHECK: [0xff,0x0f,0x30,0xe0,0x00,0x01,0x03,0x7f]

buffer_store_format_d16_x v1, off, s[12:15], 0 offset:4095
// CHECK: [0xff,0x0f,0x30,0xe0,0x00,0x01,0x03,0x80]

buffer_store_format_d16_x v1, off, s[12:15], -1 offset:4095
// CHECK: [0xff,0x0f,0x30,0xe0,0x00,0x01,0x03,0xc1]

buffer_store_format_d16_x v1, off, s[12:15], 0.5 offset:4095
// CHECK: [0xff,0x0f,0x30,0xe0,0x00,0x01,0x03,0xf0]

buffer_store_format_d16_x v1, off, s[12:15], -4.0 offset:4095
// CHECK: [0xff,0x0f,0x30,0xe0,0x00,0x01,0x03,0xf7]

buffer_store_format_d16_x v1, off, s[12:15], src_vccz offset:4095
// CHECK: [0xff,0x0f,0x30,0xe0,0x00,0x01,0x03,0xfb]

buffer_store_format_d16_x v1, off, s[12:15], src_execz offset:4095
// CHECK: [0xff,0x0f,0x30,0xe0,0x00,0x01,0x03,0xfc]

buffer_store_format_d16_x v1, off, s[12:15], src_scc offset:4095
// CHECK: [0xff,0x0f,0x30,0xe0,0x00,0x01,0x03,0xfd]

buffer_store_format_d16_x v1, v0, s[12:15], s4 idxen offset:4095
// CHECK: [0xff,0x2f,0x30,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_d16_x v1, v0, s[12:15], s4 offen offset:4095
// CHECK: [0xff,0x1f,0x30,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_d16_x v1, off, s[12:15], s4
// CHECK: [0x00,0x00,0x30,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_d16_x v1, off, s[12:15], s4 offset:0
// CHECK: [0x00,0x00,0x30,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_d16_x v1, off, s[12:15], s4 offset:7
// CHECK: [0x07,0x00,0x30,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_d16_x v1, off, s[12:15], s4 offset:4095 glc
// CHECK: [0xff,0x4f,0x30,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_d16_x v1, off, s[12:15], s4 offset:4095 slc
// CHECK: [0xff,0x0f,0x32,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_d16_xy v[1:2], off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0x34,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_d16_xy v[254:255], off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0x34,0xe0,0x00,0xfe,0x03,0x04]

buffer_store_format_d16_xy v[1:2], off, s[16:19], s4 offset:4095
// CHECK: [0xff,0x0f,0x34,0xe0,0x00,0x01,0x04,0x04]

buffer_store_format_d16_xy v[1:2], off, s[96:99], s4 offset:4095
// CHECK: [0xff,0x0f,0x34,0xe0,0x00,0x01,0x18,0x04]

buffer_store_format_d16_xy v[1:2], off, ttmp[8:11], s4 offset:4095
// CHECK: [0xff,0x0f,0x34,0xe0,0x00,0x01,0x1e,0x04]

buffer_store_format_d16_xy v[1:2], off, s[12:15], s101 offset:4095
// CHECK: [0xff,0x0f,0x34,0xe0,0x00,0x01,0x03,0x65]

buffer_store_format_d16_xy v[1:2], off, s[12:15], flat_scratch_lo offset:4095
// CHECK: [0xff,0x0f,0x34,0xe0,0x00,0x01,0x03,0x66]

buffer_store_format_d16_xy v[1:2], off, s[12:15], flat_scratch_hi offset:4095
// CHECK: [0xff,0x0f,0x34,0xe0,0x00,0x01,0x03,0x67]

buffer_store_format_d16_xy v[1:2], off, s[12:15], vcc_lo offset:4095
// CHECK: [0xff,0x0f,0x34,0xe0,0x00,0x01,0x03,0x6a]

buffer_store_format_d16_xy v[1:2], off, s[12:15], vcc_hi offset:4095
// CHECK: [0xff,0x0f,0x34,0xe0,0x00,0x01,0x03,0x6b]

buffer_store_format_d16_xy v[1:2], off, s[12:15], tba_lo offset:4095
// CHECK: [0xff,0x0f,0x34,0xe0,0x00,0x01,0x03,0x6c]

buffer_store_format_d16_xy v[1:2], off, s[12:15], tba_hi offset:4095
// CHECK: [0xff,0x0f,0x34,0xe0,0x00,0x01,0x03,0x6d]

buffer_store_format_d16_xy v[1:2], off, s[12:15], tma_lo offset:4095
// CHECK: [0xff,0x0f,0x34,0xe0,0x00,0x01,0x03,0x6e]

buffer_store_format_d16_xy v[1:2], off, s[12:15], tma_hi offset:4095
// CHECK: [0xff,0x0f,0x34,0xe0,0x00,0x01,0x03,0x6f]

buffer_store_format_d16_xy v[1:2], off, s[12:15], ttmp11 offset:4095
// CHECK: [0xff,0x0f,0x34,0xe0,0x00,0x01,0x03,0x7b]

buffer_store_format_d16_xy v[1:2], off, s[12:15], m0 offset:4095
// CHECK: [0xff,0x0f,0x34,0xe0,0x00,0x01,0x03,0x7c]

buffer_store_format_d16_xy v[1:2], off, s[12:15], exec_lo offset:4095
// CHECK: [0xff,0x0f,0x34,0xe0,0x00,0x01,0x03,0x7e]

buffer_store_format_d16_xy v[1:2], off, s[12:15], exec_hi offset:4095
// CHECK: [0xff,0x0f,0x34,0xe0,0x00,0x01,0x03,0x7f]

buffer_store_format_d16_xy v[1:2], off, s[12:15], 0 offset:4095
// CHECK: [0xff,0x0f,0x34,0xe0,0x00,0x01,0x03,0x80]

buffer_store_format_d16_xy v[1:2], off, s[12:15], -1 offset:4095
// CHECK: [0xff,0x0f,0x34,0xe0,0x00,0x01,0x03,0xc1]

buffer_store_format_d16_xy v[1:2], off, s[12:15], 0.5 offset:4095
// CHECK: [0xff,0x0f,0x34,0xe0,0x00,0x01,0x03,0xf0]

buffer_store_format_d16_xy v[1:2], off, s[12:15], -4.0 offset:4095
// CHECK: [0xff,0x0f,0x34,0xe0,0x00,0x01,0x03,0xf7]

buffer_store_format_d16_xy v[1:2], off, s[12:15], src_vccz offset:4095
// CHECK: [0xff,0x0f,0x34,0xe0,0x00,0x01,0x03,0xfb]

buffer_store_format_d16_xy v[1:2], off, s[12:15], src_execz offset:4095
// CHECK: [0xff,0x0f,0x34,0xe0,0x00,0x01,0x03,0xfc]

buffer_store_format_d16_xy v[1:2], off, s[12:15], src_scc offset:4095
// CHECK: [0xff,0x0f,0x34,0xe0,0x00,0x01,0x03,0xfd]

buffer_store_format_d16_xy v[1:2], v0, s[12:15], s4 idxen offset:4095
// CHECK: [0xff,0x2f,0x34,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_d16_xy v[1:2], v0, s[12:15], s4 offen offset:4095
// CHECK: [0xff,0x1f,0x34,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_d16_xy v[1:2], off, s[12:15], s4
// CHECK: [0x00,0x00,0x34,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_d16_xy v[1:2], off, s[12:15], s4 offset:0
// CHECK: [0x00,0x00,0x34,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_d16_xy v[1:2], off, s[12:15], s4 offset:7
// CHECK: [0x07,0x00,0x34,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_d16_xy v[1:2], off, s[12:15], s4 offset:4095 glc
// CHECK: [0xff,0x4f,0x34,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_d16_xy v[1:2], off, s[12:15], s4 offset:4095 slc
// CHECK: [0xff,0x0f,0x36,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_d16_xyz v[1:3], off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0x38,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_d16_xyz v[253:255], off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0x38,0xe0,0x00,0xfd,0x03,0x04]

buffer_store_format_d16_xyz v[1:3], off, s[16:19], s4 offset:4095
// CHECK: [0xff,0x0f,0x38,0xe0,0x00,0x01,0x04,0x04]

buffer_store_format_d16_xyz v[1:3], off, s[96:99], s4 offset:4095
// CHECK: [0xff,0x0f,0x38,0xe0,0x00,0x01,0x18,0x04]

buffer_store_format_d16_xyz v[1:3], off, ttmp[8:11], s4 offset:4095
// CHECK: [0xff,0x0f,0x38,0xe0,0x00,0x01,0x1e,0x04]

buffer_store_format_d16_xyz v[1:3], off, s[12:15], s101 offset:4095
// CHECK: [0xff,0x0f,0x38,0xe0,0x00,0x01,0x03,0x65]

buffer_store_format_d16_xyz v[1:3], off, s[12:15], flat_scratch_lo offset:4095
// CHECK: [0xff,0x0f,0x38,0xe0,0x00,0x01,0x03,0x66]

buffer_store_format_d16_xyz v[1:3], off, s[12:15], flat_scratch_hi offset:4095
// CHECK: [0xff,0x0f,0x38,0xe0,0x00,0x01,0x03,0x67]

buffer_store_format_d16_xyz v[1:3], off, s[12:15], vcc_lo offset:4095
// CHECK: [0xff,0x0f,0x38,0xe0,0x00,0x01,0x03,0x6a]

buffer_store_format_d16_xyz v[1:3], off, s[12:15], vcc_hi offset:4095
// CHECK: [0xff,0x0f,0x38,0xe0,0x00,0x01,0x03,0x6b]

buffer_store_format_d16_xyz v[1:3], off, s[12:15], tba_lo offset:4095
// CHECK: [0xff,0x0f,0x38,0xe0,0x00,0x01,0x03,0x6c]

buffer_store_format_d16_xyz v[1:3], off, s[12:15], tba_hi offset:4095
// CHECK: [0xff,0x0f,0x38,0xe0,0x00,0x01,0x03,0x6d]

buffer_store_format_d16_xyz v[1:3], off, s[12:15], tma_lo offset:4095
// CHECK: [0xff,0x0f,0x38,0xe0,0x00,0x01,0x03,0x6e]

buffer_store_format_d16_xyz v[1:3], off, s[12:15], tma_hi offset:4095
// CHECK: [0xff,0x0f,0x38,0xe0,0x00,0x01,0x03,0x6f]

buffer_store_format_d16_xyz v[1:3], off, s[12:15], ttmp11 offset:4095
// CHECK: [0xff,0x0f,0x38,0xe0,0x00,0x01,0x03,0x7b]

buffer_store_format_d16_xyz v[1:3], off, s[12:15], m0 offset:4095
// CHECK: [0xff,0x0f,0x38,0xe0,0x00,0x01,0x03,0x7c]

buffer_store_format_d16_xyz v[1:3], off, s[12:15], exec_lo offset:4095
// CHECK: [0xff,0x0f,0x38,0xe0,0x00,0x01,0x03,0x7e]

buffer_store_format_d16_xyz v[1:3], off, s[12:15], exec_hi offset:4095
// CHECK: [0xff,0x0f,0x38,0xe0,0x00,0x01,0x03,0x7f]

buffer_store_format_d16_xyz v[1:3], off, s[12:15], 0 offset:4095
// CHECK: [0xff,0x0f,0x38,0xe0,0x00,0x01,0x03,0x80]

buffer_store_format_d16_xyz v[1:3], off, s[12:15], -1 offset:4095
// CHECK: [0xff,0x0f,0x38,0xe0,0x00,0x01,0x03,0xc1]

buffer_store_format_d16_xyz v[1:3], off, s[12:15], 0.5 offset:4095
// CHECK: [0xff,0x0f,0x38,0xe0,0x00,0x01,0x03,0xf0]

buffer_store_format_d16_xyz v[1:3], off, s[12:15], -4.0 offset:4095
// CHECK: [0xff,0x0f,0x38,0xe0,0x00,0x01,0x03,0xf7]

buffer_store_format_d16_xyz v[1:3], off, s[12:15], src_vccz offset:4095
// CHECK: [0xff,0x0f,0x38,0xe0,0x00,0x01,0x03,0xfb]

buffer_store_format_d16_xyz v[1:3], off, s[12:15], src_execz offset:4095
// CHECK: [0xff,0x0f,0x38,0xe0,0x00,0x01,0x03,0xfc]

buffer_store_format_d16_xyz v[1:3], off, s[12:15], src_scc offset:4095
// CHECK: [0xff,0x0f,0x38,0xe0,0x00,0x01,0x03,0xfd]

buffer_store_format_d16_xyz v[1:3], v0, s[12:15], s4 idxen offset:4095
// CHECK: [0xff,0x2f,0x38,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_d16_xyz v[1:3], v0, s[12:15], s4 offen offset:4095
// CHECK: [0xff,0x1f,0x38,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_d16_xyz v[1:3], off, s[12:15], s4
// CHECK: [0x00,0x00,0x38,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_d16_xyz v[1:3], off, s[12:15], s4 offset:0
// CHECK: [0x00,0x00,0x38,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_d16_xyz v[1:3], off, s[12:15], s4 offset:7
// CHECK: [0x07,0x00,0x38,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_d16_xyz v[1:3], off, s[12:15], s4 offset:4095 glc
// CHECK: [0xff,0x4f,0x38,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_d16_xyz v[1:3], off, s[12:15], s4 offset:4095 slc
// CHECK: [0xff,0x0f,0x3a,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_d16_xyzw v[1:4], off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0x3c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_d16_xyzw v[252:255], off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0x3c,0xe0,0x00,0xfc,0x03,0x04]

buffer_store_format_d16_xyzw v[1:4], off, s[16:19], s4 offset:4095
// CHECK: [0xff,0x0f,0x3c,0xe0,0x00,0x01,0x04,0x04]

buffer_store_format_d16_xyzw v[1:4], off, s[96:99], s4 offset:4095
// CHECK: [0xff,0x0f,0x3c,0xe0,0x00,0x01,0x18,0x04]

buffer_store_format_d16_xyzw v[1:4], off, ttmp[8:11], s4 offset:4095
// CHECK: [0xff,0x0f,0x3c,0xe0,0x00,0x01,0x1e,0x04]

buffer_store_format_d16_xyzw v[1:4], off, s[12:15], s101 offset:4095
// CHECK: [0xff,0x0f,0x3c,0xe0,0x00,0x01,0x03,0x65]

buffer_store_format_d16_xyzw v[1:4], off, s[12:15], flat_scratch_lo offset:4095
// CHECK: [0xff,0x0f,0x3c,0xe0,0x00,0x01,0x03,0x66]

buffer_store_format_d16_xyzw v[1:4], off, s[12:15], flat_scratch_hi offset:4095
// CHECK: [0xff,0x0f,0x3c,0xe0,0x00,0x01,0x03,0x67]

buffer_store_format_d16_xyzw v[1:4], off, s[12:15], vcc_lo offset:4095
// CHECK: [0xff,0x0f,0x3c,0xe0,0x00,0x01,0x03,0x6a]

buffer_store_format_d16_xyzw v[1:4], off, s[12:15], vcc_hi offset:4095
// CHECK: [0xff,0x0f,0x3c,0xe0,0x00,0x01,0x03,0x6b]

buffer_store_format_d16_xyzw v[1:4], off, s[12:15], tba_lo offset:4095
// CHECK: [0xff,0x0f,0x3c,0xe0,0x00,0x01,0x03,0x6c]

buffer_store_format_d16_xyzw v[1:4], off, s[12:15], tba_hi offset:4095
// CHECK: [0xff,0x0f,0x3c,0xe0,0x00,0x01,0x03,0x6d]

buffer_store_format_d16_xyzw v[1:4], off, s[12:15], tma_lo offset:4095
// CHECK: [0xff,0x0f,0x3c,0xe0,0x00,0x01,0x03,0x6e]

buffer_store_format_d16_xyzw v[1:4], off, s[12:15], tma_hi offset:4095
// CHECK: [0xff,0x0f,0x3c,0xe0,0x00,0x01,0x03,0x6f]

buffer_store_format_d16_xyzw v[1:4], off, s[12:15], ttmp11 offset:4095
// CHECK: [0xff,0x0f,0x3c,0xe0,0x00,0x01,0x03,0x7b]

buffer_store_format_d16_xyzw v[1:4], off, s[12:15], m0 offset:4095
// CHECK: [0xff,0x0f,0x3c,0xe0,0x00,0x01,0x03,0x7c]

buffer_store_format_d16_xyzw v[1:4], off, s[12:15], exec_lo offset:4095
// CHECK: [0xff,0x0f,0x3c,0xe0,0x00,0x01,0x03,0x7e]

buffer_store_format_d16_xyzw v[1:4], off, s[12:15], exec_hi offset:4095
// CHECK: [0xff,0x0f,0x3c,0xe0,0x00,0x01,0x03,0x7f]

buffer_store_format_d16_xyzw v[1:4], off, s[12:15], 0 offset:4095
// CHECK: [0xff,0x0f,0x3c,0xe0,0x00,0x01,0x03,0x80]

buffer_store_format_d16_xyzw v[1:4], off, s[12:15], -1 offset:4095
// CHECK: [0xff,0x0f,0x3c,0xe0,0x00,0x01,0x03,0xc1]

buffer_store_format_d16_xyzw v[1:4], off, s[12:15], 0.5 offset:4095
// CHECK: [0xff,0x0f,0x3c,0xe0,0x00,0x01,0x03,0xf0]

buffer_store_format_d16_xyzw v[1:4], off, s[12:15], -4.0 offset:4095
// CHECK: [0xff,0x0f,0x3c,0xe0,0x00,0x01,0x03,0xf7]

buffer_store_format_d16_xyzw v[1:4], off, s[12:15], src_vccz offset:4095
// CHECK: [0xff,0x0f,0x3c,0xe0,0x00,0x01,0x03,0xfb]

buffer_store_format_d16_xyzw v[1:4], off, s[12:15], src_execz offset:4095
// CHECK: [0xff,0x0f,0x3c,0xe0,0x00,0x01,0x03,0xfc]

buffer_store_format_d16_xyzw v[1:4], off, s[12:15], src_scc offset:4095
// CHECK: [0xff,0x0f,0x3c,0xe0,0x00,0x01,0x03,0xfd]

buffer_store_format_d16_xyzw v[1:4], v0, s[12:15], s4 idxen offset:4095
// CHECK: [0xff,0x2f,0x3c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_d16_xyzw v[1:4], v0, s[12:15], s4 offen offset:4095
// CHECK: [0xff,0x1f,0x3c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_d16_xyzw v[1:4], off, s[12:15], s4
// CHECK: [0x00,0x00,0x3c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_d16_xyzw v[1:4], off, s[12:15], s4 offset:0
// CHECK: [0x00,0x00,0x3c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_d16_xyzw v[1:4], off, s[12:15], s4 offset:7
// CHECK: [0x07,0x00,0x3c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_d16_xyzw v[1:4], off, s[12:15], s4 offset:4095 glc
// CHECK: [0xff,0x4f,0x3c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_d16_xyzw v[1:4], off, s[12:15], s4 offset:4095 slc
// CHECK: [0xff,0x0f,0x3e,0xe0,0x00,0x01,0x03,0x04]

buffer_load_ubyte v5, off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x40,0xe0,0x00,0x05,0x02,0x03]

buffer_load_ubyte v255, off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x40,0xe0,0x00,0xff,0x02,0x03]

buffer_load_ubyte v5, off, s[12:15], s3 offset:4095
// CHECK: [0xff,0x0f,0x40,0xe0,0x00,0x05,0x03,0x03]

buffer_load_ubyte v5, off, s[96:99], s3 offset:4095
// CHECK: [0xff,0x0f,0x40,0xe0,0x00,0x05,0x18,0x03]

buffer_load_ubyte v5, off, ttmp[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x40,0xe0,0x00,0x05,0x1e,0x03]

buffer_load_ubyte v5, off, s[8:11], s101 offset:4095
// CHECK: [0xff,0x0f,0x40,0xe0,0x00,0x05,0x02,0x65]

buffer_load_ubyte v5, off, s[8:11], flat_scratch_lo offset:4095
// CHECK: [0xff,0x0f,0x40,0xe0,0x00,0x05,0x02,0x66]

buffer_load_ubyte v5, off, s[8:11], flat_scratch_hi offset:4095
// CHECK: [0xff,0x0f,0x40,0xe0,0x00,0x05,0x02,0x67]

buffer_load_ubyte v5, off, s[8:11], vcc_lo offset:4095
// CHECK: [0xff,0x0f,0x40,0xe0,0x00,0x05,0x02,0x6a]

buffer_load_ubyte v5, off, s[8:11], vcc_hi offset:4095
// CHECK: [0xff,0x0f,0x40,0xe0,0x00,0x05,0x02,0x6b]

buffer_load_ubyte v5, off, s[8:11], tba_lo offset:4095
// CHECK: [0xff,0x0f,0x40,0xe0,0x00,0x05,0x02,0x6c]

buffer_load_ubyte v5, off, s[8:11], tba_hi offset:4095
// CHECK: [0xff,0x0f,0x40,0xe0,0x00,0x05,0x02,0x6d]

buffer_load_ubyte v5, off, s[8:11], tma_lo offset:4095
// CHECK: [0xff,0x0f,0x40,0xe0,0x00,0x05,0x02,0x6e]

buffer_load_ubyte v5, off, s[8:11], tma_hi offset:4095
// CHECK: [0xff,0x0f,0x40,0xe0,0x00,0x05,0x02,0x6f]

buffer_load_ubyte v5, off, s[8:11], ttmp11 offset:4095
// CHECK: [0xff,0x0f,0x40,0xe0,0x00,0x05,0x02,0x7b]

buffer_load_ubyte v5, off, s[8:11], m0 offset:4095
// CHECK: [0xff,0x0f,0x40,0xe0,0x00,0x05,0x02,0x7c]

buffer_load_ubyte v5, off, s[8:11], exec_lo offset:4095
// CHECK: [0xff,0x0f,0x40,0xe0,0x00,0x05,0x02,0x7e]

buffer_load_ubyte v5, off, s[8:11], exec_hi offset:4095
// CHECK: [0xff,0x0f,0x40,0xe0,0x00,0x05,0x02,0x7f]

buffer_load_ubyte v5, off, s[8:11], 0 offset:4095
// CHECK: [0xff,0x0f,0x40,0xe0,0x00,0x05,0x02,0x80]

buffer_load_ubyte v5, off, s[8:11], -1 offset:4095
// CHECK: [0xff,0x0f,0x40,0xe0,0x00,0x05,0x02,0xc1]

buffer_load_ubyte v5, off, s[8:11], 0.5 offset:4095
// CHECK: [0xff,0x0f,0x40,0xe0,0x00,0x05,0x02,0xf0]

buffer_load_ubyte v5, off, s[8:11], -4.0 offset:4095
// CHECK: [0xff,0x0f,0x40,0xe0,0x00,0x05,0x02,0xf7]

buffer_load_ubyte v5, off, s[8:11], src_vccz offset:4095
// CHECK: [0xff,0x0f,0x40,0xe0,0x00,0x05,0x02,0xfb]

buffer_load_ubyte v5, off, s[8:11], src_execz offset:4095
// CHECK: [0xff,0x0f,0x40,0xe0,0x00,0x05,0x02,0xfc]

buffer_load_ubyte v5, off, s[8:11], src_scc offset:4095
// CHECK: [0xff,0x0f,0x40,0xe0,0x00,0x05,0x02,0xfd]

buffer_load_ubyte v5, v0, s[8:11], s3 idxen offset:4095
// CHECK: [0xff,0x2f,0x40,0xe0,0x00,0x05,0x02,0x03]

buffer_load_ubyte v5, v0, s[8:11], s3 offen offset:4095
// CHECK: [0xff,0x1f,0x40,0xe0,0x00,0x05,0x02,0x03]

buffer_load_ubyte v5, off, s[8:11], s3
// CHECK: [0x00,0x00,0x40,0xe0,0x00,0x05,0x02,0x03]

buffer_load_ubyte v5, off, s[8:11], s3 offset:0
// CHECK: [0x00,0x00,0x40,0xe0,0x00,0x05,0x02,0x03]

buffer_load_ubyte v5, off, s[8:11], s3 offset:7
// CHECK: [0x07,0x00,0x40,0xe0,0x00,0x05,0x02,0x03]

buffer_load_ubyte v5, off, s[8:11], s3 offset:4095 glc
// CHECK: [0xff,0x4f,0x40,0xe0,0x00,0x05,0x02,0x03]

buffer_load_ubyte v5, off, s[8:11], s3 offset:4095 slc
// CHECK: [0xff,0x0f,0x42,0xe0,0x00,0x05,0x02,0x03]

buffer_load_ubyte off, s[8:11], s3 offset:4095 lds
// CHECK: [0xff,0x0f,0x41,0xe0,0x00,0x00,0x02,0x03]

buffer_load_sbyte v5, off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x44,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sbyte v255, off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x44,0xe0,0x00,0xff,0x02,0x03]

buffer_load_sbyte v5, off, s[12:15], s3 offset:4095
// CHECK: [0xff,0x0f,0x44,0xe0,0x00,0x05,0x03,0x03]

buffer_load_sbyte v5, off, s[96:99], s3 offset:4095
// CHECK: [0xff,0x0f,0x44,0xe0,0x00,0x05,0x18,0x03]

buffer_load_sbyte v5, off, ttmp[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x44,0xe0,0x00,0x05,0x1e,0x03]

buffer_load_sbyte v5, off, s[8:11], s101 offset:4095
// CHECK: [0xff,0x0f,0x44,0xe0,0x00,0x05,0x02,0x65]

buffer_load_sbyte v5, off, s[8:11], flat_scratch_lo offset:4095
// CHECK: [0xff,0x0f,0x44,0xe0,0x00,0x05,0x02,0x66]

buffer_load_sbyte v5, off, s[8:11], flat_scratch_hi offset:4095
// CHECK: [0xff,0x0f,0x44,0xe0,0x00,0x05,0x02,0x67]

buffer_load_sbyte v5, off, s[8:11], vcc_lo offset:4095
// CHECK: [0xff,0x0f,0x44,0xe0,0x00,0x05,0x02,0x6a]

buffer_load_sbyte v5, off, s[8:11], vcc_hi offset:4095
// CHECK: [0xff,0x0f,0x44,0xe0,0x00,0x05,0x02,0x6b]

buffer_load_sbyte v5, off, s[8:11], tba_lo offset:4095
// CHECK: [0xff,0x0f,0x44,0xe0,0x00,0x05,0x02,0x6c]

buffer_load_sbyte v5, off, s[8:11], tba_hi offset:4095
// CHECK: [0xff,0x0f,0x44,0xe0,0x00,0x05,0x02,0x6d]

buffer_load_sbyte v5, off, s[8:11], tma_lo offset:4095
// CHECK: [0xff,0x0f,0x44,0xe0,0x00,0x05,0x02,0x6e]

buffer_load_sbyte v5, off, s[8:11], tma_hi offset:4095
// CHECK: [0xff,0x0f,0x44,0xe0,0x00,0x05,0x02,0x6f]

buffer_load_sbyte v5, off, s[8:11], ttmp11 offset:4095
// CHECK: [0xff,0x0f,0x44,0xe0,0x00,0x05,0x02,0x7b]

buffer_load_sbyte v5, off, s[8:11], m0 offset:4095
// CHECK: [0xff,0x0f,0x44,0xe0,0x00,0x05,0x02,0x7c]

buffer_load_sbyte v5, off, s[8:11], exec_lo offset:4095
// CHECK: [0xff,0x0f,0x44,0xe0,0x00,0x05,0x02,0x7e]

buffer_load_sbyte v5, off, s[8:11], exec_hi offset:4095
// CHECK: [0xff,0x0f,0x44,0xe0,0x00,0x05,0x02,0x7f]

buffer_load_sbyte v5, off, s[8:11], 0 offset:4095
// CHECK: [0xff,0x0f,0x44,0xe0,0x00,0x05,0x02,0x80]

buffer_load_sbyte v5, off, s[8:11], -1 offset:4095
// CHECK: [0xff,0x0f,0x44,0xe0,0x00,0x05,0x02,0xc1]

buffer_load_sbyte v5, off, s[8:11], 0.5 offset:4095
// CHECK: [0xff,0x0f,0x44,0xe0,0x00,0x05,0x02,0xf0]

buffer_load_sbyte v5, off, s[8:11], -4.0 offset:4095
// CHECK: [0xff,0x0f,0x44,0xe0,0x00,0x05,0x02,0xf7]

buffer_load_sbyte v5, off, s[8:11], src_vccz offset:4095
// CHECK: [0xff,0x0f,0x44,0xe0,0x00,0x05,0x02,0xfb]

buffer_load_sbyte v5, off, s[8:11], src_execz offset:4095
// CHECK: [0xff,0x0f,0x44,0xe0,0x00,0x05,0x02,0xfc]

buffer_load_sbyte v5, off, s[8:11], src_scc offset:4095
// CHECK: [0xff,0x0f,0x44,0xe0,0x00,0x05,0x02,0xfd]

buffer_load_sbyte v5, v0, s[8:11], s3 idxen offset:4095
// CHECK: [0xff,0x2f,0x44,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sbyte v5, v0, s[8:11], s3 offen offset:4095
// CHECK: [0xff,0x1f,0x44,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sbyte v5, off, s[8:11], s3
// CHECK: [0x00,0x00,0x44,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sbyte v5, off, s[8:11], s3 offset:0
// CHECK: [0x00,0x00,0x44,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sbyte v5, off, s[8:11], s3 offset:7
// CHECK: [0x07,0x00,0x44,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sbyte v5, off, s[8:11], s3 offset:4095 glc
// CHECK: [0xff,0x4f,0x44,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sbyte v5, off, s[8:11], s3 offset:4095 slc
// CHECK: [0xff,0x0f,0x46,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sbyte off, s[8:11], s3 offset:4095 lds
// CHECK: [0xff,0x0f,0x45,0xe0,0x00,0x00,0x02,0x03]

buffer_load_ushort v5, off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x48,0xe0,0x00,0x05,0x02,0x03]

buffer_load_ushort v255, off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x48,0xe0,0x00,0xff,0x02,0x03]

buffer_load_ushort v5, off, s[12:15], s3 offset:4095
// CHECK: [0xff,0x0f,0x48,0xe0,0x00,0x05,0x03,0x03]

buffer_load_ushort v5, off, s[96:99], s3 offset:4095
// CHECK: [0xff,0x0f,0x48,0xe0,0x00,0x05,0x18,0x03]

buffer_load_ushort v5, off, ttmp[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x48,0xe0,0x00,0x05,0x1e,0x03]

buffer_load_ushort v5, off, s[8:11], s101 offset:4095
// CHECK: [0xff,0x0f,0x48,0xe0,0x00,0x05,0x02,0x65]

buffer_load_ushort v5, off, s[8:11], flat_scratch_lo offset:4095
// CHECK: [0xff,0x0f,0x48,0xe0,0x00,0x05,0x02,0x66]

buffer_load_ushort v5, off, s[8:11], flat_scratch_hi offset:4095
// CHECK: [0xff,0x0f,0x48,0xe0,0x00,0x05,0x02,0x67]

buffer_load_ushort v5, off, s[8:11], vcc_lo offset:4095
// CHECK: [0xff,0x0f,0x48,0xe0,0x00,0x05,0x02,0x6a]

buffer_load_ushort v5, off, s[8:11], vcc_hi offset:4095
// CHECK: [0xff,0x0f,0x48,0xe0,0x00,0x05,0x02,0x6b]

buffer_load_ushort v5, off, s[8:11], tba_lo offset:4095
// CHECK: [0xff,0x0f,0x48,0xe0,0x00,0x05,0x02,0x6c]

buffer_load_ushort v5, off, s[8:11], tba_hi offset:4095
// CHECK: [0xff,0x0f,0x48,0xe0,0x00,0x05,0x02,0x6d]

buffer_load_ushort v5, off, s[8:11], tma_lo offset:4095
// CHECK: [0xff,0x0f,0x48,0xe0,0x00,0x05,0x02,0x6e]

buffer_load_ushort v5, off, s[8:11], tma_hi offset:4095
// CHECK: [0xff,0x0f,0x48,0xe0,0x00,0x05,0x02,0x6f]

buffer_load_ushort v5, off, s[8:11], ttmp11 offset:4095
// CHECK: [0xff,0x0f,0x48,0xe0,0x00,0x05,0x02,0x7b]

buffer_load_ushort v5, off, s[8:11], m0 offset:4095
// CHECK: [0xff,0x0f,0x48,0xe0,0x00,0x05,0x02,0x7c]

buffer_load_ushort v5, off, s[8:11], exec_lo offset:4095
// CHECK: [0xff,0x0f,0x48,0xe0,0x00,0x05,0x02,0x7e]

buffer_load_ushort v5, off, s[8:11], exec_hi offset:4095
// CHECK: [0xff,0x0f,0x48,0xe0,0x00,0x05,0x02,0x7f]

buffer_load_ushort v5, off, s[8:11], 0 offset:4095
// CHECK: [0xff,0x0f,0x48,0xe0,0x00,0x05,0x02,0x80]

buffer_load_ushort v5, off, s[8:11], -1 offset:4095
// CHECK: [0xff,0x0f,0x48,0xe0,0x00,0x05,0x02,0xc1]

buffer_load_ushort v5, off, s[8:11], 0.5 offset:4095
// CHECK: [0xff,0x0f,0x48,0xe0,0x00,0x05,0x02,0xf0]

buffer_load_ushort v5, off, s[8:11], -4.0 offset:4095
// CHECK: [0xff,0x0f,0x48,0xe0,0x00,0x05,0x02,0xf7]

buffer_load_ushort v5, off, s[8:11], src_vccz offset:4095
// CHECK: [0xff,0x0f,0x48,0xe0,0x00,0x05,0x02,0xfb]

buffer_load_ushort v5, off, s[8:11], src_execz offset:4095
// CHECK: [0xff,0x0f,0x48,0xe0,0x00,0x05,0x02,0xfc]

buffer_load_ushort v5, off, s[8:11], src_scc offset:4095
// CHECK: [0xff,0x0f,0x48,0xe0,0x00,0x05,0x02,0xfd]

buffer_load_ushort v5, v0, s[8:11], s3 idxen offset:4095
// CHECK: [0xff,0x2f,0x48,0xe0,0x00,0x05,0x02,0x03]

buffer_load_ushort v5, v0, s[8:11], s3 offen offset:4095
// CHECK: [0xff,0x1f,0x48,0xe0,0x00,0x05,0x02,0x03]

buffer_load_ushort v5, off, s[8:11], s3
// CHECK: [0x00,0x00,0x48,0xe0,0x00,0x05,0x02,0x03]

buffer_load_ushort v5, off, s[8:11], s3 offset:0
// CHECK: [0x00,0x00,0x48,0xe0,0x00,0x05,0x02,0x03]

buffer_load_ushort v5, off, s[8:11], s3 offset:7
// CHECK: [0x07,0x00,0x48,0xe0,0x00,0x05,0x02,0x03]

buffer_load_ushort v5, off, s[8:11], s3 offset:4095 glc
// CHECK: [0xff,0x4f,0x48,0xe0,0x00,0x05,0x02,0x03]

buffer_load_ushort v5, off, s[8:11], s3 offset:4095 slc
// CHECK: [0xff,0x0f,0x4a,0xe0,0x00,0x05,0x02,0x03]

buffer_load_ushort off, s[8:11], s3 offset:4095 lds
// CHECK: [0xff,0x0f,0x49,0xe0,0x00,0x00,0x02,0x03]

buffer_load_sshort v5, off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x4c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sshort v255, off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x4c,0xe0,0x00,0xff,0x02,0x03]

buffer_load_sshort v5, off, s[12:15], s3 offset:4095
// CHECK: [0xff,0x0f,0x4c,0xe0,0x00,0x05,0x03,0x03]

buffer_load_sshort v5, off, s[96:99], s3 offset:4095
// CHECK: [0xff,0x0f,0x4c,0xe0,0x00,0x05,0x18,0x03]

buffer_load_sshort v5, off, ttmp[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x4c,0xe0,0x00,0x05,0x1e,0x03]

buffer_load_sshort v5, off, s[8:11], s101 offset:4095
// CHECK: [0xff,0x0f,0x4c,0xe0,0x00,0x05,0x02,0x65]

buffer_load_sshort v5, off, s[8:11], flat_scratch_lo offset:4095
// CHECK: [0xff,0x0f,0x4c,0xe0,0x00,0x05,0x02,0x66]

buffer_load_sshort v5, off, s[8:11], flat_scratch_hi offset:4095
// CHECK: [0xff,0x0f,0x4c,0xe0,0x00,0x05,0x02,0x67]

buffer_load_sshort v5, off, s[8:11], vcc_lo offset:4095
// CHECK: [0xff,0x0f,0x4c,0xe0,0x00,0x05,0x02,0x6a]

buffer_load_sshort v5, off, s[8:11], vcc_hi offset:4095
// CHECK: [0xff,0x0f,0x4c,0xe0,0x00,0x05,0x02,0x6b]

buffer_load_sshort v5, off, s[8:11], tba_lo offset:4095
// CHECK: [0xff,0x0f,0x4c,0xe0,0x00,0x05,0x02,0x6c]

buffer_load_sshort v5, off, s[8:11], tba_hi offset:4095
// CHECK: [0xff,0x0f,0x4c,0xe0,0x00,0x05,0x02,0x6d]

buffer_load_sshort v5, off, s[8:11], tma_lo offset:4095
// CHECK: [0xff,0x0f,0x4c,0xe0,0x00,0x05,0x02,0x6e]

buffer_load_sshort v5, off, s[8:11], tma_hi offset:4095
// CHECK: [0xff,0x0f,0x4c,0xe0,0x00,0x05,0x02,0x6f]

buffer_load_sshort v5, off, s[8:11], ttmp11 offset:4095
// CHECK: [0xff,0x0f,0x4c,0xe0,0x00,0x05,0x02,0x7b]

buffer_load_sshort v5, off, s[8:11], m0 offset:4095
// CHECK: [0xff,0x0f,0x4c,0xe0,0x00,0x05,0x02,0x7c]

buffer_load_sshort v5, off, s[8:11], exec_lo offset:4095
// CHECK: [0xff,0x0f,0x4c,0xe0,0x00,0x05,0x02,0x7e]

buffer_load_sshort v5, off, s[8:11], exec_hi offset:4095
// CHECK: [0xff,0x0f,0x4c,0xe0,0x00,0x05,0x02,0x7f]

buffer_load_sshort v5, off, s[8:11], 0 offset:4095
// CHECK: [0xff,0x0f,0x4c,0xe0,0x00,0x05,0x02,0x80]

buffer_load_sshort v5, off, s[8:11], -1 offset:4095
// CHECK: [0xff,0x0f,0x4c,0xe0,0x00,0x05,0x02,0xc1]

buffer_load_sshort v5, off, s[8:11], 0.5 offset:4095
// CHECK: [0xff,0x0f,0x4c,0xe0,0x00,0x05,0x02,0xf0]

buffer_load_sshort v5, off, s[8:11], -4.0 offset:4095
// CHECK: [0xff,0x0f,0x4c,0xe0,0x00,0x05,0x02,0xf7]

buffer_load_sshort v5, off, s[8:11], src_vccz offset:4095
// CHECK: [0xff,0x0f,0x4c,0xe0,0x00,0x05,0x02,0xfb]

buffer_load_sshort v5, off, s[8:11], src_execz offset:4095
// CHECK: [0xff,0x0f,0x4c,0xe0,0x00,0x05,0x02,0xfc]

buffer_load_sshort v5, off, s[8:11], src_scc offset:4095
// CHECK: [0xff,0x0f,0x4c,0xe0,0x00,0x05,0x02,0xfd]

buffer_load_sshort v5, v0, s[8:11], s3 idxen offset:4095
// CHECK: [0xff,0x2f,0x4c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sshort v5, v0, s[8:11], s3 offen offset:4095
// CHECK: [0xff,0x1f,0x4c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sshort v5, off, s[8:11], s3
// CHECK: [0x00,0x00,0x4c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sshort v5, off, s[8:11], s3 offset:0
// CHECK: [0x00,0x00,0x4c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sshort v5, off, s[8:11], s3 offset:7
// CHECK: [0x07,0x00,0x4c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sshort v5, off, s[8:11], s3 offset:4095 glc
// CHECK: [0xff,0x4f,0x4c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sshort v5, off, s[8:11], s3 offset:4095 slc
// CHECK: [0xff,0x0f,0x4e,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sshort off, s[8:11], s3 offset:4095 lds
// CHECK: [0xff,0x0f,0x4d,0xe0,0x00,0x00,0x02,0x03]

buffer_load_dword v5, off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x50,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dword v255, off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x50,0xe0,0x00,0xff,0x02,0x03]

buffer_load_dword v5, off, s[12:15], s3 offset:4095
// CHECK: [0xff,0x0f,0x50,0xe0,0x00,0x05,0x03,0x03]

buffer_load_dword v5, off, s[96:99], s3 offset:4095
// CHECK: [0xff,0x0f,0x50,0xe0,0x00,0x05,0x18,0x03]

buffer_load_dword v5, off, ttmp[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x50,0xe0,0x00,0x05,0x1e,0x03]

buffer_load_dword v5, off, s[8:11], s101 offset:4095
// CHECK: [0xff,0x0f,0x50,0xe0,0x00,0x05,0x02,0x65]

buffer_load_dword v5, off, s[8:11], flat_scratch_lo offset:4095
// CHECK: [0xff,0x0f,0x50,0xe0,0x00,0x05,0x02,0x66]

buffer_load_dword v5, off, s[8:11], flat_scratch_hi offset:4095
// CHECK: [0xff,0x0f,0x50,0xe0,0x00,0x05,0x02,0x67]

buffer_load_dword v5, off, s[8:11], vcc_lo offset:4095
// CHECK: [0xff,0x0f,0x50,0xe0,0x00,0x05,0x02,0x6a]

buffer_load_dword v5, off, s[8:11], vcc_hi offset:4095
// CHECK: [0xff,0x0f,0x50,0xe0,0x00,0x05,0x02,0x6b]

buffer_load_dword v5, off, s[8:11], tba_lo offset:4095
// CHECK: [0xff,0x0f,0x50,0xe0,0x00,0x05,0x02,0x6c]

buffer_load_dword v5, off, s[8:11], tba_hi offset:4095
// CHECK: [0xff,0x0f,0x50,0xe0,0x00,0x05,0x02,0x6d]

buffer_load_dword v5, off, s[8:11], tma_lo offset:4095
// CHECK: [0xff,0x0f,0x50,0xe0,0x00,0x05,0x02,0x6e]

buffer_load_dword v5, off, s[8:11], tma_hi offset:4095
// CHECK: [0xff,0x0f,0x50,0xe0,0x00,0x05,0x02,0x6f]

buffer_load_dword v5, off, s[8:11], ttmp11 offset:4095
// CHECK: [0xff,0x0f,0x50,0xe0,0x00,0x05,0x02,0x7b]

buffer_load_dword v5, off, s[8:11], m0 offset:4095
// CHECK: [0xff,0x0f,0x50,0xe0,0x00,0x05,0x02,0x7c]

buffer_load_dword v5, off, s[8:11], exec_lo offset:4095
// CHECK: [0xff,0x0f,0x50,0xe0,0x00,0x05,0x02,0x7e]

buffer_load_dword v5, off, s[8:11], exec_hi offset:4095
// CHECK: [0xff,0x0f,0x50,0xe0,0x00,0x05,0x02,0x7f]

buffer_load_dword v5, off, s[8:11], 0 offset:4095
// CHECK: [0xff,0x0f,0x50,0xe0,0x00,0x05,0x02,0x80]

buffer_load_dword v5, off, s[8:11], -1 offset:4095
// CHECK: [0xff,0x0f,0x50,0xe0,0x00,0x05,0x02,0xc1]

buffer_load_dword v5, off, s[8:11], 0.5 offset:4095
// CHECK: [0xff,0x0f,0x50,0xe0,0x00,0x05,0x02,0xf0]

buffer_load_dword v5, off, s[8:11], -4.0 offset:4095
// CHECK: [0xff,0x0f,0x50,0xe0,0x00,0x05,0x02,0xf7]

buffer_load_dword v5, off, s[8:11], src_vccz offset:4095
// CHECK: [0xff,0x0f,0x50,0xe0,0x00,0x05,0x02,0xfb]

buffer_load_dword v5, off, s[8:11], src_execz offset:4095
// CHECK: [0xff,0x0f,0x50,0xe0,0x00,0x05,0x02,0xfc]

buffer_load_dword v5, off, s[8:11], src_scc offset:4095
// CHECK: [0xff,0x0f,0x50,0xe0,0x00,0x05,0x02,0xfd]

buffer_load_dword v5, v0, s[8:11], s3 idxen offset:4095
// CHECK: [0xff,0x2f,0x50,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dword v5, v0, s[8:11], s3 offen offset:4095
// CHECK: [0xff,0x1f,0x50,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dword v5, off, s[8:11], s3
// CHECK: [0x00,0x00,0x50,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dword v5, off, s[8:11], s3 offset:0
// CHECK: [0x00,0x00,0x50,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dword v5, off, s[8:11], s3 offset:7
// CHECK: [0x07,0x00,0x50,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dword v5, off, s[8:11], s3 offset:4095 glc
// CHECK: [0xff,0x4f,0x50,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dword v5, off, s[8:11], s3 offset:4095 slc
// CHECK: [0xff,0x0f,0x52,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dword off, s[8:11], s3 offset:4095 lds
// CHECK: [0xff,0x0f,0x51,0xe0,0x00,0x00,0x02,0x03]

buffer_load_dwordx2 v[5:6], off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x54,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx2 v[254:255], off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x54,0xe0,0x00,0xfe,0x02,0x03]

buffer_load_dwordx2 v[5:6], off, s[12:15], s3 offset:4095
// CHECK: [0xff,0x0f,0x54,0xe0,0x00,0x05,0x03,0x03]

buffer_load_dwordx2 v[5:6], off, s[96:99], s3 offset:4095
// CHECK: [0xff,0x0f,0x54,0xe0,0x00,0x05,0x18,0x03]

buffer_load_dwordx2 v[5:6], off, ttmp[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x54,0xe0,0x00,0x05,0x1e,0x03]

buffer_load_dwordx2 v[5:6], off, s[8:11], s101 offset:4095
// CHECK: [0xff,0x0f,0x54,0xe0,0x00,0x05,0x02,0x65]

buffer_load_dwordx2 v[5:6], off, s[8:11], flat_scratch_lo offset:4095
// CHECK: [0xff,0x0f,0x54,0xe0,0x00,0x05,0x02,0x66]

buffer_load_dwordx2 v[5:6], off, s[8:11], flat_scratch_hi offset:4095
// CHECK: [0xff,0x0f,0x54,0xe0,0x00,0x05,0x02,0x67]

buffer_load_dwordx2 v[5:6], off, s[8:11], vcc_lo offset:4095
// CHECK: [0xff,0x0f,0x54,0xe0,0x00,0x05,0x02,0x6a]

buffer_load_dwordx2 v[5:6], off, s[8:11], vcc_hi offset:4095
// CHECK: [0xff,0x0f,0x54,0xe0,0x00,0x05,0x02,0x6b]

buffer_load_dwordx2 v[5:6], off, s[8:11], tba_lo offset:4095
// CHECK: [0xff,0x0f,0x54,0xe0,0x00,0x05,0x02,0x6c]

buffer_load_dwordx2 v[5:6], off, s[8:11], tba_hi offset:4095
// CHECK: [0xff,0x0f,0x54,0xe0,0x00,0x05,0x02,0x6d]

buffer_load_dwordx2 v[5:6], off, s[8:11], tma_lo offset:4095
// CHECK: [0xff,0x0f,0x54,0xe0,0x00,0x05,0x02,0x6e]

buffer_load_dwordx2 v[5:6], off, s[8:11], tma_hi offset:4095
// CHECK: [0xff,0x0f,0x54,0xe0,0x00,0x05,0x02,0x6f]

buffer_load_dwordx2 v[5:6], off, s[8:11], ttmp11 offset:4095
// CHECK: [0xff,0x0f,0x54,0xe0,0x00,0x05,0x02,0x7b]

buffer_load_dwordx2 v[5:6], off, s[8:11], m0 offset:4095
// CHECK: [0xff,0x0f,0x54,0xe0,0x00,0x05,0x02,0x7c]

buffer_load_dwordx2 v[5:6], off, s[8:11], exec_lo offset:4095
// CHECK: [0xff,0x0f,0x54,0xe0,0x00,0x05,0x02,0x7e]

buffer_load_dwordx2 v[5:6], off, s[8:11], exec_hi offset:4095
// CHECK: [0xff,0x0f,0x54,0xe0,0x00,0x05,0x02,0x7f]

buffer_load_dwordx2 v[5:6], off, s[8:11], 0 offset:4095
// CHECK: [0xff,0x0f,0x54,0xe0,0x00,0x05,0x02,0x80]

buffer_load_dwordx2 v[5:6], off, s[8:11], -1 offset:4095
// CHECK: [0xff,0x0f,0x54,0xe0,0x00,0x05,0x02,0xc1]

buffer_load_dwordx2 v[5:6], off, s[8:11], 0.5 offset:4095
// CHECK: [0xff,0x0f,0x54,0xe0,0x00,0x05,0x02,0xf0]

buffer_load_dwordx2 v[5:6], off, s[8:11], -4.0 offset:4095
// CHECK: [0xff,0x0f,0x54,0xe0,0x00,0x05,0x02,0xf7]

buffer_load_dwordx2 v[5:6], off, s[8:11], src_vccz offset:4095
// CHECK: [0xff,0x0f,0x54,0xe0,0x00,0x05,0x02,0xfb]

buffer_load_dwordx2 v[5:6], off, s[8:11], src_execz offset:4095
// CHECK: [0xff,0x0f,0x54,0xe0,0x00,0x05,0x02,0xfc]

buffer_load_dwordx2 v[5:6], off, s[8:11], src_scc offset:4095
// CHECK: [0xff,0x0f,0x54,0xe0,0x00,0x05,0x02,0xfd]

buffer_load_dwordx2 v[5:6], v0, s[8:11], s3 idxen offset:4095
// CHECK: [0xff,0x2f,0x54,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx2 v[5:6], v0, s[8:11], s3 offen offset:4095
// CHECK: [0xff,0x1f,0x54,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx2 v[5:6], off, s[8:11], s3
// CHECK: [0x00,0x00,0x54,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx2 v[5:6], off, s[8:11], s3 offset:0
// CHECK: [0x00,0x00,0x54,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx2 v[5:6], off, s[8:11], s3 offset:7
// CHECK: [0x07,0x00,0x54,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx2 v[5:6], off, s[8:11], s3 offset:4095 glc
// CHECK: [0xff,0x4f,0x54,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx2 v[5:6], off, s[8:11], s3 offset:4095 slc
// CHECK: [0xff,0x0f,0x56,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx3 v[5:7], off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x58,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx3 v[253:255], off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x58,0xe0,0x00,0xfd,0x02,0x03]

buffer_load_dwordx3 v[5:7], off, s[12:15], s3 offset:4095
// CHECK: [0xff,0x0f,0x58,0xe0,0x00,0x05,0x03,0x03]

buffer_load_dwordx3 v[5:7], off, s[96:99], s3 offset:4095
// CHECK: [0xff,0x0f,0x58,0xe0,0x00,0x05,0x18,0x03]

buffer_load_dwordx3 v[5:7], off, ttmp[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x58,0xe0,0x00,0x05,0x1e,0x03]

buffer_load_dwordx3 v[5:7], off, s[8:11], s101 offset:4095
// CHECK: [0xff,0x0f,0x58,0xe0,0x00,0x05,0x02,0x65]

buffer_load_dwordx3 v[5:7], off, s[8:11], flat_scratch_lo offset:4095
// CHECK: [0xff,0x0f,0x58,0xe0,0x00,0x05,0x02,0x66]

buffer_load_dwordx3 v[5:7], off, s[8:11], flat_scratch_hi offset:4095
// CHECK: [0xff,0x0f,0x58,0xe0,0x00,0x05,0x02,0x67]

buffer_load_dwordx3 v[5:7], off, s[8:11], vcc_lo offset:4095
// CHECK: [0xff,0x0f,0x58,0xe0,0x00,0x05,0x02,0x6a]

buffer_load_dwordx3 v[5:7], off, s[8:11], vcc_hi offset:4095
// CHECK: [0xff,0x0f,0x58,0xe0,0x00,0x05,0x02,0x6b]

buffer_load_dwordx3 v[5:7], off, s[8:11], tba_lo offset:4095
// CHECK: [0xff,0x0f,0x58,0xe0,0x00,0x05,0x02,0x6c]

buffer_load_dwordx3 v[5:7], off, s[8:11], tba_hi offset:4095
// CHECK: [0xff,0x0f,0x58,0xe0,0x00,0x05,0x02,0x6d]

buffer_load_dwordx3 v[5:7], off, s[8:11], tma_lo offset:4095
// CHECK: [0xff,0x0f,0x58,0xe0,0x00,0x05,0x02,0x6e]

buffer_load_dwordx3 v[5:7], off, s[8:11], tma_hi offset:4095
// CHECK: [0xff,0x0f,0x58,0xe0,0x00,0x05,0x02,0x6f]

buffer_load_dwordx3 v[5:7], off, s[8:11], ttmp11 offset:4095
// CHECK: [0xff,0x0f,0x58,0xe0,0x00,0x05,0x02,0x7b]

buffer_load_dwordx3 v[5:7], off, s[8:11], m0 offset:4095
// CHECK: [0xff,0x0f,0x58,0xe0,0x00,0x05,0x02,0x7c]

buffer_load_dwordx3 v[5:7], off, s[8:11], exec_lo offset:4095
// CHECK: [0xff,0x0f,0x58,0xe0,0x00,0x05,0x02,0x7e]

buffer_load_dwordx3 v[5:7], off, s[8:11], exec_hi offset:4095
// CHECK: [0xff,0x0f,0x58,0xe0,0x00,0x05,0x02,0x7f]

buffer_load_dwordx3 v[5:7], off, s[8:11], 0 offset:4095
// CHECK: [0xff,0x0f,0x58,0xe0,0x00,0x05,0x02,0x80]

buffer_load_dwordx3 v[5:7], off, s[8:11], -1 offset:4095
// CHECK: [0xff,0x0f,0x58,0xe0,0x00,0x05,0x02,0xc1]

buffer_load_dwordx3 v[5:7], off, s[8:11], 0.5 offset:4095
// CHECK: [0xff,0x0f,0x58,0xe0,0x00,0x05,0x02,0xf0]

buffer_load_dwordx3 v[5:7], off, s[8:11], -4.0 offset:4095
// CHECK: [0xff,0x0f,0x58,0xe0,0x00,0x05,0x02,0xf7]

buffer_load_dwordx3 v[5:7], off, s[8:11], src_vccz offset:4095
// CHECK: [0xff,0x0f,0x58,0xe0,0x00,0x05,0x02,0xfb]

buffer_load_dwordx3 v[5:7], off, s[8:11], src_execz offset:4095
// CHECK: [0xff,0x0f,0x58,0xe0,0x00,0x05,0x02,0xfc]

buffer_load_dwordx3 v[5:7], off, s[8:11], src_scc offset:4095
// CHECK: [0xff,0x0f,0x58,0xe0,0x00,0x05,0x02,0xfd]

buffer_load_dwordx3 v[5:7], v0, s[8:11], s3 idxen offset:4095
// CHECK: [0xff,0x2f,0x58,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx3 v[5:7], v0, s[8:11], s3 offen offset:4095
// CHECK: [0xff,0x1f,0x58,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx3 v[5:7], off, s[8:11], s3
// CHECK: [0x00,0x00,0x58,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx3 v[5:7], off, s[8:11], s3 offset:0
// CHECK: [0x00,0x00,0x58,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx3 v[5:7], off, s[8:11], s3 offset:7
// CHECK: [0x07,0x00,0x58,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx3 v[5:7], off, s[8:11], s3 offset:4095 glc
// CHECK: [0xff,0x4f,0x58,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx3 v[5:7], off, s[8:11], s3 offset:4095 slc
// CHECK: [0xff,0x0f,0x5a,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx4 v[5:8], off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x5c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx4 v[252:255], off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x5c,0xe0,0x00,0xfc,0x02,0x03]

buffer_load_dwordx4 v[5:8], off, s[12:15], s3 offset:4095
// CHECK: [0xff,0x0f,0x5c,0xe0,0x00,0x05,0x03,0x03]

buffer_load_dwordx4 v[5:8], off, s[96:99], s3 offset:4095
// CHECK: [0xff,0x0f,0x5c,0xe0,0x00,0x05,0x18,0x03]

buffer_load_dwordx4 v[5:8], off, ttmp[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x5c,0xe0,0x00,0x05,0x1e,0x03]

buffer_load_dwordx4 v[5:8], off, s[8:11], s101 offset:4095
// CHECK: [0xff,0x0f,0x5c,0xe0,0x00,0x05,0x02,0x65]

buffer_load_dwordx4 v[5:8], off, s[8:11], flat_scratch_lo offset:4095
// CHECK: [0xff,0x0f,0x5c,0xe0,0x00,0x05,0x02,0x66]

buffer_load_dwordx4 v[5:8], off, s[8:11], flat_scratch_hi offset:4095
// CHECK: [0xff,0x0f,0x5c,0xe0,0x00,0x05,0x02,0x67]

buffer_load_dwordx4 v[5:8], off, s[8:11], vcc_lo offset:4095
// CHECK: [0xff,0x0f,0x5c,0xe0,0x00,0x05,0x02,0x6a]

buffer_load_dwordx4 v[5:8], off, s[8:11], vcc_hi offset:4095
// CHECK: [0xff,0x0f,0x5c,0xe0,0x00,0x05,0x02,0x6b]

buffer_load_dwordx4 v[5:8], off, s[8:11], tba_lo offset:4095
// CHECK: [0xff,0x0f,0x5c,0xe0,0x00,0x05,0x02,0x6c]

buffer_load_dwordx4 v[5:8], off, s[8:11], tba_hi offset:4095
// CHECK: [0xff,0x0f,0x5c,0xe0,0x00,0x05,0x02,0x6d]

buffer_load_dwordx4 v[5:8], off, s[8:11], tma_lo offset:4095
// CHECK: [0xff,0x0f,0x5c,0xe0,0x00,0x05,0x02,0x6e]

buffer_load_dwordx4 v[5:8], off, s[8:11], tma_hi offset:4095
// CHECK: [0xff,0x0f,0x5c,0xe0,0x00,0x05,0x02,0x6f]

buffer_load_dwordx4 v[5:8], off, s[8:11], ttmp11 offset:4095
// CHECK: [0xff,0x0f,0x5c,0xe0,0x00,0x05,0x02,0x7b]

buffer_load_dwordx4 v[5:8], off, s[8:11], m0 offset:4095
// CHECK: [0xff,0x0f,0x5c,0xe0,0x00,0x05,0x02,0x7c]

buffer_load_dwordx4 v[5:8], off, s[8:11], exec_lo offset:4095
// CHECK: [0xff,0x0f,0x5c,0xe0,0x00,0x05,0x02,0x7e]

buffer_load_dwordx4 v[5:8], off, s[8:11], exec_hi offset:4095
// CHECK: [0xff,0x0f,0x5c,0xe0,0x00,0x05,0x02,0x7f]

buffer_load_dwordx4 v[5:8], off, s[8:11], 0 offset:4095
// CHECK: [0xff,0x0f,0x5c,0xe0,0x00,0x05,0x02,0x80]

buffer_load_dwordx4 v[5:8], off, s[8:11], -1 offset:4095
// CHECK: [0xff,0x0f,0x5c,0xe0,0x00,0x05,0x02,0xc1]

buffer_load_dwordx4 v[5:8], off, s[8:11], 0.5 offset:4095
// CHECK: [0xff,0x0f,0x5c,0xe0,0x00,0x05,0x02,0xf0]

buffer_load_dwordx4 v[5:8], off, s[8:11], -4.0 offset:4095
// CHECK: [0xff,0x0f,0x5c,0xe0,0x00,0x05,0x02,0xf7]

buffer_load_dwordx4 v[5:8], off, s[8:11], src_vccz offset:4095
// CHECK: [0xff,0x0f,0x5c,0xe0,0x00,0x05,0x02,0xfb]

buffer_load_dwordx4 v[5:8], off, s[8:11], src_execz offset:4095
// CHECK: [0xff,0x0f,0x5c,0xe0,0x00,0x05,0x02,0xfc]

buffer_load_dwordx4 v[5:8], off, s[8:11], src_scc offset:4095
// CHECK: [0xff,0x0f,0x5c,0xe0,0x00,0x05,0x02,0xfd]

buffer_load_dwordx4 v[5:8], v0, s[8:11], s3 idxen offset:4095
// CHECK: [0xff,0x2f,0x5c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx4 v[5:8], v0, s[8:11], s3 offen offset:4095
// CHECK: [0xff,0x1f,0x5c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx4 v[5:8], off, s[8:11], s3
// CHECK: [0x00,0x00,0x5c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx4 v[5:8], off, s[8:11], s3 offset:0
// CHECK: [0x00,0x00,0x5c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx4 v[5:8], off, s[8:11], s3 offset:7
// CHECK: [0x07,0x00,0x5c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx4 v[5:8], off, s[8:11], s3 offset:4095 glc
// CHECK: [0xff,0x4f,0x5c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx4 v[5:8], off, s[8:11], s3 offset:4095 slc
// CHECK: [0xff,0x0f,0x5e,0xe0,0x00,0x05,0x02,0x03]

buffer_store_byte v1, off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0x60,0xe0,0x00,0x01,0x03,0x04]

buffer_store_byte v255, off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0x60,0xe0,0x00,0xff,0x03,0x04]

buffer_store_byte v1, off, s[16:19], s4 offset:4095
// CHECK: [0xff,0x0f,0x60,0xe0,0x00,0x01,0x04,0x04]

buffer_store_byte v1, off, s[96:99], s4 offset:4095
// CHECK: [0xff,0x0f,0x60,0xe0,0x00,0x01,0x18,0x04]

buffer_store_byte v1, off, ttmp[8:11], s4 offset:4095
// CHECK: [0xff,0x0f,0x60,0xe0,0x00,0x01,0x1e,0x04]

buffer_store_byte v1, off, s[12:15], s101 offset:4095
// CHECK: [0xff,0x0f,0x60,0xe0,0x00,0x01,0x03,0x65]

buffer_store_byte v1, off, s[12:15], flat_scratch_lo offset:4095
// CHECK: [0xff,0x0f,0x60,0xe0,0x00,0x01,0x03,0x66]

buffer_store_byte v1, off, s[12:15], flat_scratch_hi offset:4095
// CHECK: [0xff,0x0f,0x60,0xe0,0x00,0x01,0x03,0x67]

buffer_store_byte v1, off, s[12:15], vcc_lo offset:4095
// CHECK: [0xff,0x0f,0x60,0xe0,0x00,0x01,0x03,0x6a]

buffer_store_byte v1, off, s[12:15], vcc_hi offset:4095
// CHECK: [0xff,0x0f,0x60,0xe0,0x00,0x01,0x03,0x6b]

buffer_store_byte v1, off, s[12:15], tba_lo offset:4095
// CHECK: [0xff,0x0f,0x60,0xe0,0x00,0x01,0x03,0x6c]

buffer_store_byte v1, off, s[12:15], tba_hi offset:4095
// CHECK: [0xff,0x0f,0x60,0xe0,0x00,0x01,0x03,0x6d]

buffer_store_byte v1, off, s[12:15], tma_lo offset:4095
// CHECK: [0xff,0x0f,0x60,0xe0,0x00,0x01,0x03,0x6e]

buffer_store_byte v1, off, s[12:15], tma_hi offset:4095
// CHECK: [0xff,0x0f,0x60,0xe0,0x00,0x01,0x03,0x6f]

buffer_store_byte v1, off, s[12:15], ttmp11 offset:4095
// CHECK: [0xff,0x0f,0x60,0xe0,0x00,0x01,0x03,0x7b]

buffer_store_byte v1, off, s[12:15], m0 offset:4095
// CHECK: [0xff,0x0f,0x60,0xe0,0x00,0x01,0x03,0x7c]

buffer_store_byte v1, off, s[12:15], exec_lo offset:4095
// CHECK: [0xff,0x0f,0x60,0xe0,0x00,0x01,0x03,0x7e]

buffer_store_byte v1, off, s[12:15], exec_hi offset:4095
// CHECK: [0xff,0x0f,0x60,0xe0,0x00,0x01,0x03,0x7f]

buffer_store_byte v1, off, s[12:15], 0 offset:4095
// CHECK: [0xff,0x0f,0x60,0xe0,0x00,0x01,0x03,0x80]

buffer_store_byte v1, off, s[12:15], -1 offset:4095
// CHECK: [0xff,0x0f,0x60,0xe0,0x00,0x01,0x03,0xc1]

buffer_store_byte v1, off, s[12:15], 0.5 offset:4095
// CHECK: [0xff,0x0f,0x60,0xe0,0x00,0x01,0x03,0xf0]

buffer_store_byte v1, off, s[12:15], -4.0 offset:4095
// CHECK: [0xff,0x0f,0x60,0xe0,0x00,0x01,0x03,0xf7]

buffer_store_byte v1, off, s[12:15], src_vccz offset:4095
// CHECK: [0xff,0x0f,0x60,0xe0,0x00,0x01,0x03,0xfb]

buffer_store_byte v1, off, s[12:15], src_execz offset:4095
// CHECK: [0xff,0x0f,0x60,0xe0,0x00,0x01,0x03,0xfc]

buffer_store_byte v1, off, s[12:15], src_scc offset:4095
// CHECK: [0xff,0x0f,0x60,0xe0,0x00,0x01,0x03,0xfd]

buffer_store_byte v1, v0, s[12:15], s4 idxen offset:4095
// CHECK: [0xff,0x2f,0x60,0xe0,0x00,0x01,0x03,0x04]

buffer_store_byte v1, v0, s[12:15], s4 offen offset:4095
// CHECK: [0xff,0x1f,0x60,0xe0,0x00,0x01,0x03,0x04]

buffer_store_byte v1, off, s[12:15], s4
// CHECK: [0x00,0x00,0x60,0xe0,0x00,0x01,0x03,0x04]

buffer_store_byte v1, off, s[12:15], s4 offset:0
// CHECK: [0x00,0x00,0x60,0xe0,0x00,0x01,0x03,0x04]

buffer_store_byte v1, off, s[12:15], s4 offset:7
// CHECK: [0x07,0x00,0x60,0xe0,0x00,0x01,0x03,0x04]

buffer_store_byte v1, off, s[12:15], s4 offset:4095 glc
// CHECK: [0xff,0x4f,0x60,0xe0,0x00,0x01,0x03,0x04]

buffer_store_byte v1, off, s[12:15], s4 offset:4095 slc
// CHECK: [0xff,0x0f,0x62,0xe0,0x00,0x01,0x03,0x04]

buffer_store_short v1, off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0x68,0xe0,0x00,0x01,0x03,0x04]

buffer_store_short v255, off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0x68,0xe0,0x00,0xff,0x03,0x04]

buffer_store_short v1, off, s[16:19], s4 offset:4095
// CHECK: [0xff,0x0f,0x68,0xe0,0x00,0x01,0x04,0x04]

buffer_store_short v1, off, s[96:99], s4 offset:4095
// CHECK: [0xff,0x0f,0x68,0xe0,0x00,0x01,0x18,0x04]

buffer_store_short v1, off, ttmp[8:11], s4 offset:4095
// CHECK: [0xff,0x0f,0x68,0xe0,0x00,0x01,0x1e,0x04]

buffer_store_short v1, off, s[12:15], s101 offset:4095
// CHECK: [0xff,0x0f,0x68,0xe0,0x00,0x01,0x03,0x65]

buffer_store_short v1, off, s[12:15], flat_scratch_lo offset:4095
// CHECK: [0xff,0x0f,0x68,0xe0,0x00,0x01,0x03,0x66]

buffer_store_short v1, off, s[12:15], flat_scratch_hi offset:4095
// CHECK: [0xff,0x0f,0x68,0xe0,0x00,0x01,0x03,0x67]

buffer_store_short v1, off, s[12:15], vcc_lo offset:4095
// CHECK: [0xff,0x0f,0x68,0xe0,0x00,0x01,0x03,0x6a]

buffer_store_short v1, off, s[12:15], vcc_hi offset:4095
// CHECK: [0xff,0x0f,0x68,0xe0,0x00,0x01,0x03,0x6b]

buffer_store_short v1, off, s[12:15], tba_lo offset:4095
// CHECK: [0xff,0x0f,0x68,0xe0,0x00,0x01,0x03,0x6c]

buffer_store_short v1, off, s[12:15], tba_hi offset:4095
// CHECK: [0xff,0x0f,0x68,0xe0,0x00,0x01,0x03,0x6d]

buffer_store_short v1, off, s[12:15], tma_lo offset:4095
// CHECK: [0xff,0x0f,0x68,0xe0,0x00,0x01,0x03,0x6e]

buffer_store_short v1, off, s[12:15], tma_hi offset:4095
// CHECK: [0xff,0x0f,0x68,0xe0,0x00,0x01,0x03,0x6f]

buffer_store_short v1, off, s[12:15], ttmp11 offset:4095
// CHECK: [0xff,0x0f,0x68,0xe0,0x00,0x01,0x03,0x7b]

buffer_store_short v1, off, s[12:15], m0 offset:4095
// CHECK: [0xff,0x0f,0x68,0xe0,0x00,0x01,0x03,0x7c]

buffer_store_short v1, off, s[12:15], exec_lo offset:4095
// CHECK: [0xff,0x0f,0x68,0xe0,0x00,0x01,0x03,0x7e]

buffer_store_short v1, off, s[12:15], exec_hi offset:4095
// CHECK: [0xff,0x0f,0x68,0xe0,0x00,0x01,0x03,0x7f]

buffer_store_short v1, off, s[12:15], 0 offset:4095
// CHECK: [0xff,0x0f,0x68,0xe0,0x00,0x01,0x03,0x80]

buffer_store_short v1, off, s[12:15], -1 offset:4095
// CHECK: [0xff,0x0f,0x68,0xe0,0x00,0x01,0x03,0xc1]

buffer_store_short v1, off, s[12:15], 0.5 offset:4095
// CHECK: [0xff,0x0f,0x68,0xe0,0x00,0x01,0x03,0xf0]

buffer_store_short v1, off, s[12:15], -4.0 offset:4095
// CHECK: [0xff,0x0f,0x68,0xe0,0x00,0x01,0x03,0xf7]

buffer_store_short v1, off, s[12:15], src_vccz offset:4095
// CHECK: [0xff,0x0f,0x68,0xe0,0x00,0x01,0x03,0xfb]

buffer_store_short v1, off, s[12:15], src_execz offset:4095
// CHECK: [0xff,0x0f,0x68,0xe0,0x00,0x01,0x03,0xfc]

buffer_store_short v1, off, s[12:15], src_scc offset:4095
// CHECK: [0xff,0x0f,0x68,0xe0,0x00,0x01,0x03,0xfd]

buffer_store_short v1, v0, s[12:15], s4 idxen offset:4095
// CHECK: [0xff,0x2f,0x68,0xe0,0x00,0x01,0x03,0x04]

buffer_store_short v1, v0, s[12:15], s4 offen offset:4095
// CHECK: [0xff,0x1f,0x68,0xe0,0x00,0x01,0x03,0x04]

buffer_store_short v1, off, s[12:15], s4
// CHECK: [0x00,0x00,0x68,0xe0,0x00,0x01,0x03,0x04]

buffer_store_short v1, off, s[12:15], s4 offset:0
// CHECK: [0x00,0x00,0x68,0xe0,0x00,0x01,0x03,0x04]

buffer_store_short v1, off, s[12:15], s4 offset:7
// CHECK: [0x07,0x00,0x68,0xe0,0x00,0x01,0x03,0x04]

buffer_store_short v1, off, s[12:15], s4 offset:4095 glc
// CHECK: [0xff,0x4f,0x68,0xe0,0x00,0x01,0x03,0x04]

buffer_store_short v1, off, s[12:15], s4 offset:4095 slc
// CHECK: [0xff,0x0f,0x6a,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dword v1, off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0x70,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dword v255, off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0x70,0xe0,0x00,0xff,0x03,0x04]

buffer_store_dword v1, off, s[16:19], s4 offset:4095
// CHECK: [0xff,0x0f,0x70,0xe0,0x00,0x01,0x04,0x04]

buffer_store_dword v1, off, s[96:99], s4 offset:4095
// CHECK: [0xff,0x0f,0x70,0xe0,0x00,0x01,0x18,0x04]

buffer_store_dword v1, off, ttmp[8:11], s4 offset:4095
// CHECK: [0xff,0x0f,0x70,0xe0,0x00,0x01,0x1e,0x04]

buffer_store_dword v1, off, s[12:15], s101 offset:4095
// CHECK: [0xff,0x0f,0x70,0xe0,0x00,0x01,0x03,0x65]

buffer_store_dword v1, off, s[12:15], flat_scratch_lo offset:4095
// CHECK: [0xff,0x0f,0x70,0xe0,0x00,0x01,0x03,0x66]

buffer_store_dword v1, off, s[12:15], flat_scratch_hi offset:4095
// CHECK: [0xff,0x0f,0x70,0xe0,0x00,0x01,0x03,0x67]

buffer_store_dword v1, off, s[12:15], vcc_lo offset:4095
// CHECK: [0xff,0x0f,0x70,0xe0,0x00,0x01,0x03,0x6a]

buffer_store_dword v1, off, s[12:15], vcc_hi offset:4095
// CHECK: [0xff,0x0f,0x70,0xe0,0x00,0x01,0x03,0x6b]

buffer_store_dword v1, off, s[12:15], tba_lo offset:4095
// CHECK: [0xff,0x0f,0x70,0xe0,0x00,0x01,0x03,0x6c]

buffer_store_dword v1, off, s[12:15], tba_hi offset:4095
// CHECK: [0xff,0x0f,0x70,0xe0,0x00,0x01,0x03,0x6d]

buffer_store_dword v1, off, s[12:15], tma_lo offset:4095
// CHECK: [0xff,0x0f,0x70,0xe0,0x00,0x01,0x03,0x6e]

buffer_store_dword v1, off, s[12:15], tma_hi offset:4095
// CHECK: [0xff,0x0f,0x70,0xe0,0x00,0x01,0x03,0x6f]

buffer_store_dword v1, off, s[12:15], ttmp11 offset:4095
// CHECK: [0xff,0x0f,0x70,0xe0,0x00,0x01,0x03,0x7b]

buffer_store_dword v1, off, s[12:15], m0 offset:4095
// CHECK: [0xff,0x0f,0x70,0xe0,0x00,0x01,0x03,0x7c]

buffer_store_dword v1, off, s[12:15], exec_lo offset:4095
// CHECK: [0xff,0x0f,0x70,0xe0,0x00,0x01,0x03,0x7e]

buffer_store_dword v1, off, s[12:15], exec_hi offset:4095
// CHECK: [0xff,0x0f,0x70,0xe0,0x00,0x01,0x03,0x7f]

buffer_store_dword v1, off, s[12:15], 0 offset:4095
// CHECK: [0xff,0x0f,0x70,0xe0,0x00,0x01,0x03,0x80]

buffer_store_dword v1, off, s[12:15], -1 offset:4095
// CHECK: [0xff,0x0f,0x70,0xe0,0x00,0x01,0x03,0xc1]

buffer_store_dword v1, off, s[12:15], 0.5 offset:4095
// CHECK: [0xff,0x0f,0x70,0xe0,0x00,0x01,0x03,0xf0]

buffer_store_dword v1, off, s[12:15], -4.0 offset:4095
// CHECK: [0xff,0x0f,0x70,0xe0,0x00,0x01,0x03,0xf7]

buffer_store_dword v1, off, s[12:15], src_vccz offset:4095
// CHECK: [0xff,0x0f,0x70,0xe0,0x00,0x01,0x03,0xfb]

buffer_store_dword v1, off, s[12:15], src_execz offset:4095
// CHECK: [0xff,0x0f,0x70,0xe0,0x00,0x01,0x03,0xfc]

buffer_store_dword v1, off, s[12:15], src_scc offset:4095
// CHECK: [0xff,0x0f,0x70,0xe0,0x00,0x01,0x03,0xfd]

buffer_store_dword v1, v0, s[12:15], s4 idxen offset:4095
// CHECK: [0xff,0x2f,0x70,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dword v1, v0, s[12:15], s4 offen offset:4095
// CHECK: [0xff,0x1f,0x70,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dword v1, off, s[12:15], s4
// CHECK: [0x00,0x00,0x70,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dword v1, off, s[12:15], s4 offset:0
// CHECK: [0x00,0x00,0x70,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dword v1, off, s[12:15], s4 offset:7
// CHECK: [0x07,0x00,0x70,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dword v1, off, s[12:15], s4 offset:4095 glc
// CHECK: [0xff,0x4f,0x70,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dword v1, off, s[12:15], s4 offset:4095 slc
// CHECK: [0xff,0x0f,0x72,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx2 v[1:2], off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0x74,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx2 v[254:255], off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0x74,0xe0,0x00,0xfe,0x03,0x04]

buffer_store_dwordx2 v[1:2], off, s[16:19], s4 offset:4095
// CHECK: [0xff,0x0f,0x74,0xe0,0x00,0x01,0x04,0x04]

buffer_store_dwordx2 v[1:2], off, s[96:99], s4 offset:4095
// CHECK: [0xff,0x0f,0x74,0xe0,0x00,0x01,0x18,0x04]

buffer_store_dwordx2 v[1:2], off, ttmp[8:11], s4 offset:4095
// CHECK: [0xff,0x0f,0x74,0xe0,0x00,0x01,0x1e,0x04]

buffer_store_dwordx2 v[1:2], off, s[12:15], s101 offset:4095
// CHECK: [0xff,0x0f,0x74,0xe0,0x00,0x01,0x03,0x65]

buffer_store_dwordx2 v[1:2], off, s[12:15], flat_scratch_lo offset:4095
// CHECK: [0xff,0x0f,0x74,0xe0,0x00,0x01,0x03,0x66]

buffer_store_dwordx2 v[1:2], off, s[12:15], flat_scratch_hi offset:4095
// CHECK: [0xff,0x0f,0x74,0xe0,0x00,0x01,0x03,0x67]

buffer_store_dwordx2 v[1:2], off, s[12:15], vcc_lo offset:4095
// CHECK: [0xff,0x0f,0x74,0xe0,0x00,0x01,0x03,0x6a]

buffer_store_dwordx2 v[1:2], off, s[12:15], vcc_hi offset:4095
// CHECK: [0xff,0x0f,0x74,0xe0,0x00,0x01,0x03,0x6b]

buffer_store_dwordx2 v[1:2], off, s[12:15], tba_lo offset:4095
// CHECK: [0xff,0x0f,0x74,0xe0,0x00,0x01,0x03,0x6c]

buffer_store_dwordx2 v[1:2], off, s[12:15], tba_hi offset:4095
// CHECK: [0xff,0x0f,0x74,0xe0,0x00,0x01,0x03,0x6d]

buffer_store_dwordx2 v[1:2], off, s[12:15], tma_lo offset:4095
// CHECK: [0xff,0x0f,0x74,0xe0,0x00,0x01,0x03,0x6e]

buffer_store_dwordx2 v[1:2], off, s[12:15], tma_hi offset:4095
// CHECK: [0xff,0x0f,0x74,0xe0,0x00,0x01,0x03,0x6f]

buffer_store_dwordx2 v[1:2], off, s[12:15], ttmp11 offset:4095
// CHECK: [0xff,0x0f,0x74,0xe0,0x00,0x01,0x03,0x7b]

buffer_store_dwordx2 v[1:2], off, s[12:15], m0 offset:4095
// CHECK: [0xff,0x0f,0x74,0xe0,0x00,0x01,0x03,0x7c]

buffer_store_dwordx2 v[1:2], off, s[12:15], exec_lo offset:4095
// CHECK: [0xff,0x0f,0x74,0xe0,0x00,0x01,0x03,0x7e]

buffer_store_dwordx2 v[1:2], off, s[12:15], exec_hi offset:4095
// CHECK: [0xff,0x0f,0x74,0xe0,0x00,0x01,0x03,0x7f]

buffer_store_dwordx2 v[1:2], off, s[12:15], 0 offset:4095
// CHECK: [0xff,0x0f,0x74,0xe0,0x00,0x01,0x03,0x80]

buffer_store_dwordx2 v[1:2], off, s[12:15], -1 offset:4095
// CHECK: [0xff,0x0f,0x74,0xe0,0x00,0x01,0x03,0xc1]

buffer_store_dwordx2 v[1:2], off, s[12:15], 0.5 offset:4095
// CHECK: [0xff,0x0f,0x74,0xe0,0x00,0x01,0x03,0xf0]

buffer_store_dwordx2 v[1:2], off, s[12:15], -4.0 offset:4095
// CHECK: [0xff,0x0f,0x74,0xe0,0x00,0x01,0x03,0xf7]

buffer_store_dwordx2 v[1:2], off, s[12:15], src_vccz offset:4095
// CHECK: [0xff,0x0f,0x74,0xe0,0x00,0x01,0x03,0xfb]

buffer_store_dwordx2 v[1:2], off, s[12:15], src_execz offset:4095
// CHECK: [0xff,0x0f,0x74,0xe0,0x00,0x01,0x03,0xfc]

buffer_store_dwordx2 v[1:2], off, s[12:15], src_scc offset:4095
// CHECK: [0xff,0x0f,0x74,0xe0,0x00,0x01,0x03,0xfd]

buffer_store_dwordx2 v[1:2], v0, s[12:15], s4 idxen offset:4095
// CHECK: [0xff,0x2f,0x74,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx2 v[1:2], v0, s[12:15], s4 offen offset:4095
// CHECK: [0xff,0x1f,0x74,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx2 v[1:2], off, s[12:15], s4
// CHECK: [0x00,0x00,0x74,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx2 v[1:2], off, s[12:15], s4 offset:0
// CHECK: [0x00,0x00,0x74,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx2 v[1:2], off, s[12:15], s4 offset:7
// CHECK: [0x07,0x00,0x74,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx2 v[1:2], off, s[12:15], s4 offset:4095 glc
// CHECK: [0xff,0x4f,0x74,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx2 v[1:2], off, s[12:15], s4 offset:4095 slc
// CHECK: [0xff,0x0f,0x76,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx3 v[1:3], off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0x78,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx3 v[253:255], off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0x78,0xe0,0x00,0xfd,0x03,0x04]

buffer_store_dwordx3 v[1:3], off, s[16:19], s4 offset:4095
// CHECK: [0xff,0x0f,0x78,0xe0,0x00,0x01,0x04,0x04]

buffer_store_dwordx3 v[1:3], off, s[96:99], s4 offset:4095
// CHECK: [0xff,0x0f,0x78,0xe0,0x00,0x01,0x18,0x04]

buffer_store_dwordx3 v[1:3], off, ttmp[8:11], s4 offset:4095
// CHECK: [0xff,0x0f,0x78,0xe0,0x00,0x01,0x1e,0x04]

buffer_store_dwordx3 v[1:3], off, s[12:15], s101 offset:4095
// CHECK: [0xff,0x0f,0x78,0xe0,0x00,0x01,0x03,0x65]

buffer_store_dwordx3 v[1:3], off, s[12:15], flat_scratch_lo offset:4095
// CHECK: [0xff,0x0f,0x78,0xe0,0x00,0x01,0x03,0x66]

buffer_store_dwordx3 v[1:3], off, s[12:15], flat_scratch_hi offset:4095
// CHECK: [0xff,0x0f,0x78,0xe0,0x00,0x01,0x03,0x67]

buffer_store_dwordx3 v[1:3], off, s[12:15], vcc_lo offset:4095
// CHECK: [0xff,0x0f,0x78,0xe0,0x00,0x01,0x03,0x6a]

buffer_store_dwordx3 v[1:3], off, s[12:15], vcc_hi offset:4095
// CHECK: [0xff,0x0f,0x78,0xe0,0x00,0x01,0x03,0x6b]

buffer_store_dwordx3 v[1:3], off, s[12:15], tba_lo offset:4095
// CHECK: [0xff,0x0f,0x78,0xe0,0x00,0x01,0x03,0x6c]

buffer_store_dwordx3 v[1:3], off, s[12:15], tba_hi offset:4095
// CHECK: [0xff,0x0f,0x78,0xe0,0x00,0x01,0x03,0x6d]

buffer_store_dwordx3 v[1:3], off, s[12:15], tma_lo offset:4095
// CHECK: [0xff,0x0f,0x78,0xe0,0x00,0x01,0x03,0x6e]

buffer_store_dwordx3 v[1:3], off, s[12:15], tma_hi offset:4095
// CHECK: [0xff,0x0f,0x78,0xe0,0x00,0x01,0x03,0x6f]

buffer_store_dwordx3 v[1:3], off, s[12:15], ttmp11 offset:4095
// CHECK: [0xff,0x0f,0x78,0xe0,0x00,0x01,0x03,0x7b]

buffer_store_dwordx3 v[1:3], off, s[12:15], m0 offset:4095
// CHECK: [0xff,0x0f,0x78,0xe0,0x00,0x01,0x03,0x7c]

buffer_store_dwordx3 v[1:3], off, s[12:15], exec_lo offset:4095
// CHECK: [0xff,0x0f,0x78,0xe0,0x00,0x01,0x03,0x7e]

buffer_store_dwordx3 v[1:3], off, s[12:15], exec_hi offset:4095
// CHECK: [0xff,0x0f,0x78,0xe0,0x00,0x01,0x03,0x7f]

buffer_store_dwordx3 v[1:3], off, s[12:15], 0 offset:4095
// CHECK: [0xff,0x0f,0x78,0xe0,0x00,0x01,0x03,0x80]

buffer_store_dwordx3 v[1:3], off, s[12:15], -1 offset:4095
// CHECK: [0xff,0x0f,0x78,0xe0,0x00,0x01,0x03,0xc1]

buffer_store_dwordx3 v[1:3], off, s[12:15], 0.5 offset:4095
// CHECK: [0xff,0x0f,0x78,0xe0,0x00,0x01,0x03,0xf0]

buffer_store_dwordx3 v[1:3], off, s[12:15], -4.0 offset:4095
// CHECK: [0xff,0x0f,0x78,0xe0,0x00,0x01,0x03,0xf7]

buffer_store_dwordx3 v[1:3], off, s[12:15], src_vccz offset:4095
// CHECK: [0xff,0x0f,0x78,0xe0,0x00,0x01,0x03,0xfb]

buffer_store_dwordx3 v[1:3], off, s[12:15], src_execz offset:4095
// CHECK: [0xff,0x0f,0x78,0xe0,0x00,0x01,0x03,0xfc]

buffer_store_dwordx3 v[1:3], off, s[12:15], src_scc offset:4095
// CHECK: [0xff,0x0f,0x78,0xe0,0x00,0x01,0x03,0xfd]

buffer_store_dwordx3 v[1:3], v0, s[12:15], s4 idxen offset:4095
// CHECK: [0xff,0x2f,0x78,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx3 v[1:3], v0, s[12:15], s4 offen offset:4095
// CHECK: [0xff,0x1f,0x78,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx3 v[1:3], off, s[12:15], s4
// CHECK: [0x00,0x00,0x78,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx3 v[1:3], off, s[12:15], s4 offset:0
// CHECK: [0x00,0x00,0x78,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx3 v[1:3], off, s[12:15], s4 offset:7
// CHECK: [0x07,0x00,0x78,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx3 v[1:3], off, s[12:15], s4 offset:4095 glc
// CHECK: [0xff,0x4f,0x78,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx3 v[1:3], off, s[12:15], s4 offset:4095 slc
// CHECK: [0xff,0x0f,0x7a,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx4 v[1:4], off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0x7c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx4 v[252:255], off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0x7c,0xe0,0x00,0xfc,0x03,0x04]

buffer_store_dwordx4 v[1:4], off, s[16:19], s4 offset:4095
// CHECK: [0xff,0x0f,0x7c,0xe0,0x00,0x01,0x04,0x04]

buffer_store_dwordx4 v[1:4], off, s[96:99], s4 offset:4095
// CHECK: [0xff,0x0f,0x7c,0xe0,0x00,0x01,0x18,0x04]

buffer_store_dwordx4 v[1:4], off, ttmp[8:11], s4 offset:4095
// CHECK: [0xff,0x0f,0x7c,0xe0,0x00,0x01,0x1e,0x04]

buffer_store_dwordx4 v[1:4], off, s[12:15], s101 offset:4095
// CHECK: [0xff,0x0f,0x7c,0xe0,0x00,0x01,0x03,0x65]

buffer_store_dwordx4 v[1:4], off, s[12:15], flat_scratch_lo offset:4095
// CHECK: [0xff,0x0f,0x7c,0xe0,0x00,0x01,0x03,0x66]

buffer_store_dwordx4 v[1:4], off, s[12:15], flat_scratch_hi offset:4095
// CHECK: [0xff,0x0f,0x7c,0xe0,0x00,0x01,0x03,0x67]

buffer_store_dwordx4 v[1:4], off, s[12:15], vcc_lo offset:4095
// CHECK: [0xff,0x0f,0x7c,0xe0,0x00,0x01,0x03,0x6a]

buffer_store_dwordx4 v[1:4], off, s[12:15], vcc_hi offset:4095
// CHECK: [0xff,0x0f,0x7c,0xe0,0x00,0x01,0x03,0x6b]

buffer_store_dwordx4 v[1:4], off, s[12:15], tba_lo offset:4095
// CHECK: [0xff,0x0f,0x7c,0xe0,0x00,0x01,0x03,0x6c]

buffer_store_dwordx4 v[1:4], off, s[12:15], tba_hi offset:4095
// CHECK: [0xff,0x0f,0x7c,0xe0,0x00,0x01,0x03,0x6d]

buffer_store_dwordx4 v[1:4], off, s[12:15], tma_lo offset:4095
// CHECK: [0xff,0x0f,0x7c,0xe0,0x00,0x01,0x03,0x6e]

buffer_store_dwordx4 v[1:4], off, s[12:15], tma_hi offset:4095
// CHECK: [0xff,0x0f,0x7c,0xe0,0x00,0x01,0x03,0x6f]

buffer_store_dwordx4 v[1:4], off, s[12:15], ttmp11 offset:4095
// CHECK: [0xff,0x0f,0x7c,0xe0,0x00,0x01,0x03,0x7b]

buffer_store_dwordx4 v[1:4], off, s[12:15], m0 offset:4095
// CHECK: [0xff,0x0f,0x7c,0xe0,0x00,0x01,0x03,0x7c]

buffer_store_dwordx4 v[1:4], off, s[12:15], exec_lo offset:4095
// CHECK: [0xff,0x0f,0x7c,0xe0,0x00,0x01,0x03,0x7e]

buffer_store_dwordx4 v[1:4], off, s[12:15], exec_hi offset:4095
// CHECK: [0xff,0x0f,0x7c,0xe0,0x00,0x01,0x03,0x7f]

buffer_store_dwordx4 v[1:4], off, s[12:15], 0 offset:4095
// CHECK: [0xff,0x0f,0x7c,0xe0,0x00,0x01,0x03,0x80]

buffer_store_dwordx4 v[1:4], off, s[12:15], -1 offset:4095
// CHECK: [0xff,0x0f,0x7c,0xe0,0x00,0x01,0x03,0xc1]

buffer_store_dwordx4 v[1:4], off, s[12:15], 0.5 offset:4095
// CHECK: [0xff,0x0f,0x7c,0xe0,0x00,0x01,0x03,0xf0]

buffer_store_dwordx4 v[1:4], off, s[12:15], -4.0 offset:4095
// CHECK: [0xff,0x0f,0x7c,0xe0,0x00,0x01,0x03,0xf7]

buffer_store_dwordx4 v[1:4], off, s[12:15], src_vccz offset:4095
// CHECK: [0xff,0x0f,0x7c,0xe0,0x00,0x01,0x03,0xfb]

buffer_store_dwordx4 v[1:4], off, s[12:15], src_execz offset:4095
// CHECK: [0xff,0x0f,0x7c,0xe0,0x00,0x01,0x03,0xfc]

buffer_store_dwordx4 v[1:4], off, s[12:15], src_scc offset:4095
// CHECK: [0xff,0x0f,0x7c,0xe0,0x00,0x01,0x03,0xfd]

buffer_store_dwordx4 v[1:4], v0, s[12:15], s4 idxen offset:4095
// CHECK: [0xff,0x2f,0x7c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx4 v[1:4], v0, s[12:15], s4 offen offset:4095
// CHECK: [0xff,0x1f,0x7c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx4 v[1:4], off, s[12:15], s4
// CHECK: [0x00,0x00,0x7c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx4 v[1:4], off, s[12:15], s4 offset:0
// CHECK: [0x00,0x00,0x7c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx4 v[1:4], off, s[12:15], s4 offset:7
// CHECK: [0x07,0x00,0x7c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx4 v[1:4], off, s[12:15], s4 offset:4095 glc
// CHECK: [0xff,0x4f,0x7c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx4 v[1:4], off, s[12:15], s4 offset:4095 slc
// CHECK: [0xff,0x0f,0x7e,0xe0,0x00,0x01,0x03,0x04]

buffer_store_lds_dword s[4:7], s0 offset:4095 lds
// CHECK: [0xff,0x0f,0xf5,0xe0,0x00,0x00,0x01,0x00]

buffer_store_lds_dword s[8:11], s0 offset:4095 lds
// CHECK: [0xff,0x0f,0xf5,0xe0,0x00,0x00,0x02,0x00]

buffer_store_lds_dword s[96:99], s0 offset:4095 lds
// CHECK: [0xff,0x0f,0xf5,0xe0,0x00,0x00,0x18,0x00]

buffer_store_lds_dword ttmp[8:11], s0 offset:4095 lds
// CHECK: [0xff,0x0f,0xf5,0xe0,0x00,0x00,0x1e,0x00]

buffer_store_lds_dword s[4:7], s101 offset:4095 lds
// CHECK: [0xff,0x0f,0xf5,0xe0,0x00,0x00,0x01,0x65]

buffer_store_lds_dword s[4:7], flat_scratch_lo offset:4095 lds
// CHECK: [0xff,0x0f,0xf5,0xe0,0x00,0x00,0x01,0x66]

buffer_store_lds_dword s[4:7], flat_scratch_hi offset:4095 lds
// CHECK: [0xff,0x0f,0xf5,0xe0,0x00,0x00,0x01,0x67]

buffer_store_lds_dword s[4:7], vcc_lo offset:4095 lds
// CHECK: [0xff,0x0f,0xf5,0xe0,0x00,0x00,0x01,0x6a]

buffer_store_lds_dword s[4:7], vcc_hi offset:4095 lds
// CHECK: [0xff,0x0f,0xf5,0xe0,0x00,0x00,0x01,0x6b]

buffer_store_lds_dword s[4:7], tba_lo offset:4095 lds
// CHECK: [0xff,0x0f,0xf5,0xe0,0x00,0x00,0x01,0x6c]

buffer_store_lds_dword s[4:7], tba_hi offset:4095 lds
// CHECK: [0xff,0x0f,0xf5,0xe0,0x00,0x00,0x01,0x6d]

buffer_store_lds_dword s[4:7], tma_lo offset:4095 lds
// CHECK: [0xff,0x0f,0xf5,0xe0,0x00,0x00,0x01,0x6e]

buffer_store_lds_dword s[4:7], tma_hi offset:4095 lds
// CHECK: [0xff,0x0f,0xf5,0xe0,0x00,0x00,0x01,0x6f]

buffer_store_lds_dword s[4:7], ttmp11 offset:4095 lds
// CHECK: [0xff,0x0f,0xf5,0xe0,0x00,0x00,0x01,0x7b]

buffer_store_lds_dword s[4:7], m0 offset:4095 lds
// CHECK: [0xff,0x0f,0xf5,0xe0,0x00,0x00,0x01,0x7c]

buffer_store_lds_dword s[4:7], exec_lo offset:4095 lds
// CHECK: [0xff,0x0f,0xf5,0xe0,0x00,0x00,0x01,0x7e]

buffer_store_lds_dword s[4:7], exec_hi offset:4095 lds
// CHECK: [0xff,0x0f,0xf5,0xe0,0x00,0x00,0x01,0x7f]

buffer_store_lds_dword s[4:7], 0 offset:4095 lds
// CHECK: [0xff,0x0f,0xf5,0xe0,0x00,0x00,0x01,0x80]

buffer_store_lds_dword s[4:7], -1 offset:4095 lds
// CHECK: [0xff,0x0f,0xf5,0xe0,0x00,0x00,0x01,0xc1]

buffer_store_lds_dword s[4:7], 0.5 offset:4095 lds
// CHECK: [0xff,0x0f,0xf5,0xe0,0x00,0x00,0x01,0xf0]

buffer_store_lds_dword s[4:7], -4.0 offset:4095 lds
// CHECK: [0xff,0x0f,0xf5,0xe0,0x00,0x00,0x01,0xf7]

buffer_store_lds_dword s[4:7], src_vccz offset:4095 lds
// CHECK: [0xff,0x0f,0xf5,0xe0,0x00,0x00,0x01,0xfb]

buffer_store_lds_dword s[4:7], src_execz offset:4095 lds
// CHECK: [0xff,0x0f,0xf5,0xe0,0x00,0x00,0x01,0xfc]

buffer_store_lds_dword s[4:7], src_scc offset:4095 lds
// CHECK: [0xff,0x0f,0xf5,0xe0,0x00,0x00,0x01,0xfd]

buffer_store_lds_dword s[4:7], s0 lds
// CHECK: [0x00,0x00,0xf5,0xe0,0x00,0x00,0x01,0x00]

buffer_store_lds_dword s[4:7], s0 offset:0 lds
// CHECK: [0x00,0x00,0xf5,0xe0,0x00,0x00,0x01,0x00]

buffer_store_lds_dword s[4:7], s0 offset:7 lds
// CHECK: [0x07,0x00,0xf5,0xe0,0x00,0x00,0x01,0x00]

buffer_store_lds_dword s[4:7], s0 offset:4095 lds glc
// CHECK: [0xff,0x4f,0xf5,0xe0,0x00,0x00,0x01,0x00]

buffer_store_lds_dword s[4:7], s0 offset:4095 lds slc
// CHECK: [0xff,0x0f,0xf7,0xe0,0x00,0x00,0x01,0x00]

buffer_wbinvl1
// CHECK: [0x00,0x00,0xf8,0xe0,0x00,0x00,0x00,0x00]

buffer_wbinvl1_vol
// CHECK: [0x00,0x00,0xfc,0xe0,0x00,0x00,0x00,0x00]

buffer_atomic_swap v5, off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x00,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_swap v255, off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x00,0xe1,0x00,0xff,0x02,0x03]

buffer_atomic_swap v5, off, s[12:15], s3 offset:4095
// CHECK: [0xff,0x0f,0x00,0xe1,0x00,0x05,0x03,0x03]

buffer_atomic_swap v5, off, s[96:99], s3 offset:4095
// CHECK: [0xff,0x0f,0x00,0xe1,0x00,0x05,0x18,0x03]

buffer_atomic_swap v5, off, ttmp[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x00,0xe1,0x00,0x05,0x1e,0x03]

buffer_atomic_swap v5, off, s[8:11], s101 offset:4095
// CHECK: [0xff,0x0f,0x00,0xe1,0x00,0x05,0x02,0x65]

buffer_atomic_swap v5, off, s[8:11], flat_scratch_lo offset:4095
// CHECK: [0xff,0x0f,0x00,0xe1,0x00,0x05,0x02,0x66]

buffer_atomic_swap v5, off, s[8:11], flat_scratch_hi offset:4095
// CHECK: [0xff,0x0f,0x00,0xe1,0x00,0x05,0x02,0x67]

buffer_atomic_swap v5, off, s[8:11], vcc_lo offset:4095
// CHECK: [0xff,0x0f,0x00,0xe1,0x00,0x05,0x02,0x6a]

buffer_atomic_swap v5, off, s[8:11], vcc_hi offset:4095
// CHECK: [0xff,0x0f,0x00,0xe1,0x00,0x05,0x02,0x6b]

buffer_atomic_swap v5, off, s[8:11], tba_lo offset:4095
// CHECK: [0xff,0x0f,0x00,0xe1,0x00,0x05,0x02,0x6c]

buffer_atomic_swap v5, off, s[8:11], tba_hi offset:4095
// CHECK: [0xff,0x0f,0x00,0xe1,0x00,0x05,0x02,0x6d]

buffer_atomic_swap v5, off, s[8:11], tma_lo offset:4095
// CHECK: [0xff,0x0f,0x00,0xe1,0x00,0x05,0x02,0x6e]

buffer_atomic_swap v5, off, s[8:11], tma_hi offset:4095
// CHECK: [0xff,0x0f,0x00,0xe1,0x00,0x05,0x02,0x6f]

buffer_atomic_swap v5, off, s[8:11], ttmp11 offset:4095
// CHECK: [0xff,0x0f,0x00,0xe1,0x00,0x05,0x02,0x7b]

buffer_atomic_swap v5, off, s[8:11], m0 offset:4095
// CHECK: [0xff,0x0f,0x00,0xe1,0x00,0x05,0x02,0x7c]

buffer_atomic_swap v5, off, s[8:11], exec_lo offset:4095
// CHECK: [0xff,0x0f,0x00,0xe1,0x00,0x05,0x02,0x7e]

buffer_atomic_swap v5, off, s[8:11], exec_hi offset:4095
// CHECK: [0xff,0x0f,0x00,0xe1,0x00,0x05,0x02,0x7f]

buffer_atomic_swap v5, off, s[8:11], 0 offset:4095
// CHECK: [0xff,0x0f,0x00,0xe1,0x00,0x05,0x02,0x80]

buffer_atomic_swap v5, off, s[8:11], -1 offset:4095
// CHECK: [0xff,0x0f,0x00,0xe1,0x00,0x05,0x02,0xc1]

buffer_atomic_swap v5, off, s[8:11], 0.5 offset:4095
// CHECK: [0xff,0x0f,0x00,0xe1,0x00,0x05,0x02,0xf0]

buffer_atomic_swap v5, off, s[8:11], -4.0 offset:4095
// CHECK: [0xff,0x0f,0x00,0xe1,0x00,0x05,0x02,0xf7]

buffer_atomic_swap v5, off, s[8:11], src_vccz offset:4095
// CHECK: [0xff,0x0f,0x00,0xe1,0x00,0x05,0x02,0xfb]

buffer_atomic_swap v5, off, s[8:11], src_execz offset:4095
// CHECK: [0xff,0x0f,0x00,0xe1,0x00,0x05,0x02,0xfc]

buffer_atomic_swap v5, off, s[8:11], src_scc offset:4095
// CHECK: [0xff,0x0f,0x00,0xe1,0x00,0x05,0x02,0xfd]

buffer_atomic_swap v5, v0, s[8:11], s3 idxen offset:4095
// CHECK: [0xff,0x2f,0x00,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_swap v5, v0, s[8:11], s3 offen offset:4095
// CHECK: [0xff,0x1f,0x00,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_swap v5, off, s[8:11], s3
// CHECK: [0x00,0x00,0x00,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_swap v5, off, s[8:11], s3 offset:0
// CHECK: [0x00,0x00,0x00,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_swap v5, off, s[8:11], s3 offset:7
// CHECK: [0x07,0x00,0x00,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_swap v5, off, s[8:11], s3 offset:4095 glc
// CHECK: [0xff,0x4f,0x00,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_swap v5, off, s[8:11], s3 offset:4095 slc
// CHECK: [0xff,0x0f,0x02,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_cmpswap v[5:6], off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x04,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_cmpswap v[254:255], off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x04,0xe1,0x00,0xfe,0x02,0x03]

buffer_atomic_cmpswap v[5:6], off, s[12:15], s3 offset:4095
// CHECK: [0xff,0x0f,0x04,0xe1,0x00,0x05,0x03,0x03]

buffer_atomic_cmpswap v[5:6], off, s[96:99], s3 offset:4095
// CHECK: [0xff,0x0f,0x04,0xe1,0x00,0x05,0x18,0x03]

buffer_atomic_cmpswap v[5:6], off, ttmp[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x04,0xe1,0x00,0x05,0x1e,0x03]

buffer_atomic_cmpswap v[5:6], off, s[8:11], s101 offset:4095
// CHECK: [0xff,0x0f,0x04,0xe1,0x00,0x05,0x02,0x65]

buffer_atomic_cmpswap v[5:6], off, s[8:11], flat_scratch_lo offset:4095
// CHECK: [0xff,0x0f,0x04,0xe1,0x00,0x05,0x02,0x66]

buffer_atomic_cmpswap v[5:6], off, s[8:11], flat_scratch_hi offset:4095
// CHECK: [0xff,0x0f,0x04,0xe1,0x00,0x05,0x02,0x67]

buffer_atomic_cmpswap v[5:6], off, s[8:11], vcc_lo offset:4095
// CHECK: [0xff,0x0f,0x04,0xe1,0x00,0x05,0x02,0x6a]

buffer_atomic_cmpswap v[5:6], off, s[8:11], vcc_hi offset:4095
// CHECK: [0xff,0x0f,0x04,0xe1,0x00,0x05,0x02,0x6b]

buffer_atomic_cmpswap v[5:6], off, s[8:11], tba_lo offset:4095
// CHECK: [0xff,0x0f,0x04,0xe1,0x00,0x05,0x02,0x6c]

buffer_atomic_cmpswap v[5:6], off, s[8:11], tba_hi offset:4095
// CHECK: [0xff,0x0f,0x04,0xe1,0x00,0x05,0x02,0x6d]

buffer_atomic_cmpswap v[5:6], off, s[8:11], tma_lo offset:4095
// CHECK: [0xff,0x0f,0x04,0xe1,0x00,0x05,0x02,0x6e]

buffer_atomic_cmpswap v[5:6], off, s[8:11], tma_hi offset:4095
// CHECK: [0xff,0x0f,0x04,0xe1,0x00,0x05,0x02,0x6f]

buffer_atomic_cmpswap v[5:6], off, s[8:11], ttmp11 offset:4095
// CHECK: [0xff,0x0f,0x04,0xe1,0x00,0x05,0x02,0x7b]

buffer_atomic_cmpswap v[5:6], off, s[8:11], m0 offset:4095
// CHECK: [0xff,0x0f,0x04,0xe1,0x00,0x05,0x02,0x7c]

buffer_atomic_cmpswap v[5:6], off, s[8:11], exec_lo offset:4095
// CHECK: [0xff,0x0f,0x04,0xe1,0x00,0x05,0x02,0x7e]

buffer_atomic_cmpswap v[5:6], off, s[8:11], exec_hi offset:4095
// CHECK: [0xff,0x0f,0x04,0xe1,0x00,0x05,0x02,0x7f]

buffer_atomic_cmpswap v[5:6], off, s[8:11], 0 offset:4095
// CHECK: [0xff,0x0f,0x04,0xe1,0x00,0x05,0x02,0x80]

buffer_atomic_cmpswap v[5:6], off, s[8:11], -1 offset:4095
// CHECK: [0xff,0x0f,0x04,0xe1,0x00,0x05,0x02,0xc1]

buffer_atomic_cmpswap v[5:6], off, s[8:11], 0.5 offset:4095
// CHECK: [0xff,0x0f,0x04,0xe1,0x00,0x05,0x02,0xf0]

buffer_atomic_cmpswap v[5:6], off, s[8:11], -4.0 offset:4095
// CHECK: [0xff,0x0f,0x04,0xe1,0x00,0x05,0x02,0xf7]

buffer_atomic_cmpswap v[5:6], off, s[8:11], src_vccz offset:4095
// CHECK: [0xff,0x0f,0x04,0xe1,0x00,0x05,0x02,0xfb]

buffer_atomic_cmpswap v[5:6], off, s[8:11], src_execz offset:4095
// CHECK: [0xff,0x0f,0x04,0xe1,0x00,0x05,0x02,0xfc]

buffer_atomic_cmpswap v[5:6], off, s[8:11], src_scc offset:4095
// CHECK: [0xff,0x0f,0x04,0xe1,0x00,0x05,0x02,0xfd]

buffer_atomic_cmpswap v[5:6], v0, s[8:11], s3 idxen offset:4095
// CHECK: [0xff,0x2f,0x04,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_cmpswap v[5:6], v0, s[8:11], s3 offen offset:4095
// CHECK: [0xff,0x1f,0x04,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_cmpswap v[5:6], off, s[8:11], s3
// CHECK: [0x00,0x00,0x04,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_cmpswap v[5:6], off, s[8:11], s3 offset:0
// CHECK: [0x00,0x00,0x04,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_cmpswap v[5:6], off, s[8:11], s3 offset:7
// CHECK: [0x07,0x00,0x04,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_cmpswap v[5:6], off, s[8:11], s3 offset:4095 glc
// CHECK: [0xff,0x4f,0x04,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_cmpswap v[5:6], off, s[8:11], s3 offset:4095 slc
// CHECK: [0xff,0x0f,0x06,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_add v5, off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x08,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_add v255, off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x08,0xe1,0x00,0xff,0x02,0x03]

buffer_atomic_add v5, off, s[12:15], s3 offset:4095
// CHECK: [0xff,0x0f,0x08,0xe1,0x00,0x05,0x03,0x03]

buffer_atomic_add v5, off, s[96:99], s3 offset:4095
// CHECK: [0xff,0x0f,0x08,0xe1,0x00,0x05,0x18,0x03]

buffer_atomic_add v5, off, ttmp[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x08,0xe1,0x00,0x05,0x1e,0x03]

buffer_atomic_add v5, off, s[8:11], s101 offset:4095
// CHECK: [0xff,0x0f,0x08,0xe1,0x00,0x05,0x02,0x65]

buffer_atomic_add v5, off, s[8:11], flat_scratch_lo offset:4095
// CHECK: [0xff,0x0f,0x08,0xe1,0x00,0x05,0x02,0x66]

buffer_atomic_add v5, off, s[8:11], flat_scratch_hi offset:4095
// CHECK: [0xff,0x0f,0x08,0xe1,0x00,0x05,0x02,0x67]

buffer_atomic_add v5, off, s[8:11], vcc_lo offset:4095
// CHECK: [0xff,0x0f,0x08,0xe1,0x00,0x05,0x02,0x6a]

buffer_atomic_add v5, off, s[8:11], vcc_hi offset:4095
// CHECK: [0xff,0x0f,0x08,0xe1,0x00,0x05,0x02,0x6b]

buffer_atomic_add v5, off, s[8:11], tba_lo offset:4095
// CHECK: [0xff,0x0f,0x08,0xe1,0x00,0x05,0x02,0x6c]

buffer_atomic_add v5, off, s[8:11], tba_hi offset:4095
// CHECK: [0xff,0x0f,0x08,0xe1,0x00,0x05,0x02,0x6d]

buffer_atomic_add v5, off, s[8:11], tma_lo offset:4095
// CHECK: [0xff,0x0f,0x08,0xe1,0x00,0x05,0x02,0x6e]

buffer_atomic_add v5, off, s[8:11], tma_hi offset:4095
// CHECK: [0xff,0x0f,0x08,0xe1,0x00,0x05,0x02,0x6f]

buffer_atomic_add v5, off, s[8:11], ttmp11 offset:4095
// CHECK: [0xff,0x0f,0x08,0xe1,0x00,0x05,0x02,0x7b]

buffer_atomic_add v5, off, s[8:11], m0 offset:4095
// CHECK: [0xff,0x0f,0x08,0xe1,0x00,0x05,0x02,0x7c]

buffer_atomic_add v5, off, s[8:11], exec_lo offset:4095
// CHECK: [0xff,0x0f,0x08,0xe1,0x00,0x05,0x02,0x7e]

buffer_atomic_add v5, off, s[8:11], exec_hi offset:4095
// CHECK: [0xff,0x0f,0x08,0xe1,0x00,0x05,0x02,0x7f]

buffer_atomic_add v5, off, s[8:11], 0 offset:4095
// CHECK: [0xff,0x0f,0x08,0xe1,0x00,0x05,0x02,0x80]

buffer_atomic_add v5, off, s[8:11], -1 offset:4095
// CHECK: [0xff,0x0f,0x08,0xe1,0x00,0x05,0x02,0xc1]

buffer_atomic_add v5, off, s[8:11], 0.5 offset:4095
// CHECK: [0xff,0x0f,0x08,0xe1,0x00,0x05,0x02,0xf0]

buffer_atomic_add v5, off, s[8:11], -4.0 offset:4095
// CHECK: [0xff,0x0f,0x08,0xe1,0x00,0x05,0x02,0xf7]

buffer_atomic_add v5, off, s[8:11], src_vccz offset:4095
// CHECK: [0xff,0x0f,0x08,0xe1,0x00,0x05,0x02,0xfb]

buffer_atomic_add v5, off, s[8:11], src_execz offset:4095
// CHECK: [0xff,0x0f,0x08,0xe1,0x00,0x05,0x02,0xfc]

buffer_atomic_add v5, off, s[8:11], src_scc offset:4095
// CHECK: [0xff,0x0f,0x08,0xe1,0x00,0x05,0x02,0xfd]

buffer_atomic_add v5, v0, s[8:11], s3 idxen offset:4095
// CHECK: [0xff,0x2f,0x08,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_add v5, v0, s[8:11], s3 offen offset:4095
// CHECK: [0xff,0x1f,0x08,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_add v5, off, s[8:11], s3
// CHECK: [0x00,0x00,0x08,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_add v5, off, s[8:11], s3 offset:0
// CHECK: [0x00,0x00,0x08,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_add v5, off, s[8:11], s3 offset:7
// CHECK: [0x07,0x00,0x08,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_add v5, off, s[8:11], s3 offset:4095 glc
// CHECK: [0xff,0x4f,0x08,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_add v5, off, s[8:11], s3 offset:4095 slc
// CHECK: [0xff,0x0f,0x0a,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_sub v5, off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x0c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_sub v255, off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x0c,0xe1,0x00,0xff,0x02,0x03]

buffer_atomic_sub v5, off, s[12:15], s3 offset:4095
// CHECK: [0xff,0x0f,0x0c,0xe1,0x00,0x05,0x03,0x03]

buffer_atomic_sub v5, off, s[96:99], s3 offset:4095
// CHECK: [0xff,0x0f,0x0c,0xe1,0x00,0x05,0x18,0x03]

buffer_atomic_sub v5, off, ttmp[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x0c,0xe1,0x00,0x05,0x1e,0x03]

buffer_atomic_sub v5, off, s[8:11], s101 offset:4095
// CHECK: [0xff,0x0f,0x0c,0xe1,0x00,0x05,0x02,0x65]

buffer_atomic_sub v5, off, s[8:11], flat_scratch_lo offset:4095
// CHECK: [0xff,0x0f,0x0c,0xe1,0x00,0x05,0x02,0x66]

buffer_atomic_sub v5, off, s[8:11], flat_scratch_hi offset:4095
// CHECK: [0xff,0x0f,0x0c,0xe1,0x00,0x05,0x02,0x67]

buffer_atomic_sub v5, off, s[8:11], vcc_lo offset:4095
// CHECK: [0xff,0x0f,0x0c,0xe1,0x00,0x05,0x02,0x6a]

buffer_atomic_sub v5, off, s[8:11], vcc_hi offset:4095
// CHECK: [0xff,0x0f,0x0c,0xe1,0x00,0x05,0x02,0x6b]

buffer_atomic_sub v5, off, s[8:11], tba_lo offset:4095
// CHECK: [0xff,0x0f,0x0c,0xe1,0x00,0x05,0x02,0x6c]

buffer_atomic_sub v5, off, s[8:11], tba_hi offset:4095
// CHECK: [0xff,0x0f,0x0c,0xe1,0x00,0x05,0x02,0x6d]

buffer_atomic_sub v5, off, s[8:11], tma_lo offset:4095
// CHECK: [0xff,0x0f,0x0c,0xe1,0x00,0x05,0x02,0x6e]

buffer_atomic_sub v5, off, s[8:11], tma_hi offset:4095
// CHECK: [0xff,0x0f,0x0c,0xe1,0x00,0x05,0x02,0x6f]

buffer_atomic_sub v5, off, s[8:11], ttmp11 offset:4095
// CHECK: [0xff,0x0f,0x0c,0xe1,0x00,0x05,0x02,0x7b]

buffer_atomic_sub v5, off, s[8:11], m0 offset:4095
// CHECK: [0xff,0x0f,0x0c,0xe1,0x00,0x05,0x02,0x7c]

buffer_atomic_sub v5, off, s[8:11], exec_lo offset:4095
// CHECK: [0xff,0x0f,0x0c,0xe1,0x00,0x05,0x02,0x7e]

buffer_atomic_sub v5, off, s[8:11], exec_hi offset:4095
// CHECK: [0xff,0x0f,0x0c,0xe1,0x00,0x05,0x02,0x7f]

buffer_atomic_sub v5, off, s[8:11], 0 offset:4095
// CHECK: [0xff,0x0f,0x0c,0xe1,0x00,0x05,0x02,0x80]

buffer_atomic_sub v5, off, s[8:11], -1 offset:4095
// CHECK: [0xff,0x0f,0x0c,0xe1,0x00,0x05,0x02,0xc1]

buffer_atomic_sub v5, off, s[8:11], 0.5 offset:4095
// CHECK: [0xff,0x0f,0x0c,0xe1,0x00,0x05,0x02,0xf0]

buffer_atomic_sub v5, off, s[8:11], -4.0 offset:4095
// CHECK: [0xff,0x0f,0x0c,0xe1,0x00,0x05,0x02,0xf7]

buffer_atomic_sub v5, off, s[8:11], src_vccz offset:4095
// CHECK: [0xff,0x0f,0x0c,0xe1,0x00,0x05,0x02,0xfb]

buffer_atomic_sub v5, off, s[8:11], src_execz offset:4095
// CHECK: [0xff,0x0f,0x0c,0xe1,0x00,0x05,0x02,0xfc]

buffer_atomic_sub v5, off, s[8:11], src_scc offset:4095
// CHECK: [0xff,0x0f,0x0c,0xe1,0x00,0x05,0x02,0xfd]

buffer_atomic_sub v5, v0, s[8:11], s3 idxen offset:4095
// CHECK: [0xff,0x2f,0x0c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_sub v5, v0, s[8:11], s3 offen offset:4095
// CHECK: [0xff,0x1f,0x0c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_sub v5, off, s[8:11], s3
// CHECK: [0x00,0x00,0x0c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_sub v5, off, s[8:11], s3 offset:0
// CHECK: [0x00,0x00,0x0c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_sub v5, off, s[8:11], s3 offset:7
// CHECK: [0x07,0x00,0x0c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_sub v5, off, s[8:11], s3 offset:4095 glc
// CHECK: [0xff,0x4f,0x0c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_sub v5, off, s[8:11], s3 offset:4095 slc
// CHECK: [0xff,0x0f,0x0e,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_smin v5, off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x10,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_smin v255, off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x10,0xe1,0x00,0xff,0x02,0x03]

buffer_atomic_smin v5, off, s[12:15], s3 offset:4095
// CHECK: [0xff,0x0f,0x10,0xe1,0x00,0x05,0x03,0x03]

buffer_atomic_smin v5, off, s[96:99], s3 offset:4095
// CHECK: [0xff,0x0f,0x10,0xe1,0x00,0x05,0x18,0x03]

buffer_atomic_smin v5, off, ttmp[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x10,0xe1,0x00,0x05,0x1e,0x03]

buffer_atomic_smin v5, off, s[8:11], s101 offset:4095
// CHECK: [0xff,0x0f,0x10,0xe1,0x00,0x05,0x02,0x65]

buffer_atomic_smin v5, off, s[8:11], flat_scratch_lo offset:4095
// CHECK: [0xff,0x0f,0x10,0xe1,0x00,0x05,0x02,0x66]

buffer_atomic_smin v5, off, s[8:11], flat_scratch_hi offset:4095
// CHECK: [0xff,0x0f,0x10,0xe1,0x00,0x05,0x02,0x67]

buffer_atomic_smin v5, off, s[8:11], vcc_lo offset:4095
// CHECK: [0xff,0x0f,0x10,0xe1,0x00,0x05,0x02,0x6a]

buffer_atomic_smin v5, off, s[8:11], vcc_hi offset:4095
// CHECK: [0xff,0x0f,0x10,0xe1,0x00,0x05,0x02,0x6b]

buffer_atomic_smin v5, off, s[8:11], tba_lo offset:4095
// CHECK: [0xff,0x0f,0x10,0xe1,0x00,0x05,0x02,0x6c]

buffer_atomic_smin v5, off, s[8:11], tba_hi offset:4095
// CHECK: [0xff,0x0f,0x10,0xe1,0x00,0x05,0x02,0x6d]

buffer_atomic_smin v5, off, s[8:11], tma_lo offset:4095
// CHECK: [0xff,0x0f,0x10,0xe1,0x00,0x05,0x02,0x6e]

buffer_atomic_smin v5, off, s[8:11], tma_hi offset:4095
// CHECK: [0xff,0x0f,0x10,0xe1,0x00,0x05,0x02,0x6f]

buffer_atomic_smin v5, off, s[8:11], ttmp11 offset:4095
// CHECK: [0xff,0x0f,0x10,0xe1,0x00,0x05,0x02,0x7b]

buffer_atomic_smin v5, off, s[8:11], m0 offset:4095
// CHECK: [0xff,0x0f,0x10,0xe1,0x00,0x05,0x02,0x7c]

buffer_atomic_smin v5, off, s[8:11], exec_lo offset:4095
// CHECK: [0xff,0x0f,0x10,0xe1,0x00,0x05,0x02,0x7e]

buffer_atomic_smin v5, off, s[8:11], exec_hi offset:4095
// CHECK: [0xff,0x0f,0x10,0xe1,0x00,0x05,0x02,0x7f]

buffer_atomic_smin v5, off, s[8:11], 0 offset:4095
// CHECK: [0xff,0x0f,0x10,0xe1,0x00,0x05,0x02,0x80]

buffer_atomic_smin v5, off, s[8:11], -1 offset:4095
// CHECK: [0xff,0x0f,0x10,0xe1,0x00,0x05,0x02,0xc1]

buffer_atomic_smin v5, off, s[8:11], 0.5 offset:4095
// CHECK: [0xff,0x0f,0x10,0xe1,0x00,0x05,0x02,0xf0]

buffer_atomic_smin v5, off, s[8:11], -4.0 offset:4095
// CHECK: [0xff,0x0f,0x10,0xe1,0x00,0x05,0x02,0xf7]

buffer_atomic_smin v5, off, s[8:11], src_vccz offset:4095
// CHECK: [0xff,0x0f,0x10,0xe1,0x00,0x05,0x02,0xfb]

buffer_atomic_smin v5, off, s[8:11], src_execz offset:4095
// CHECK: [0xff,0x0f,0x10,0xe1,0x00,0x05,0x02,0xfc]

buffer_atomic_smin v5, off, s[8:11], src_scc offset:4095
// CHECK: [0xff,0x0f,0x10,0xe1,0x00,0x05,0x02,0xfd]

buffer_atomic_smin v5, v0, s[8:11], s3 idxen offset:4095
// CHECK: [0xff,0x2f,0x10,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_smin v5, v0, s[8:11], s3 offen offset:4095
// CHECK: [0xff,0x1f,0x10,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_smin v5, off, s[8:11], s3
// CHECK: [0x00,0x00,0x10,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_smin v5, off, s[8:11], s3 offset:0
// CHECK: [0x00,0x00,0x10,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_smin v5, off, s[8:11], s3 offset:7
// CHECK: [0x07,0x00,0x10,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_smin v5, off, s[8:11], s3 offset:4095 glc
// CHECK: [0xff,0x4f,0x10,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_smin v5, off, s[8:11], s3 offset:4095 slc
// CHECK: [0xff,0x0f,0x12,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_umin v5, off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x14,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_umin v255, off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x14,0xe1,0x00,0xff,0x02,0x03]

buffer_atomic_umin v5, off, s[12:15], s3 offset:4095
// CHECK: [0xff,0x0f,0x14,0xe1,0x00,0x05,0x03,0x03]

buffer_atomic_umin v5, off, s[96:99], s3 offset:4095
// CHECK: [0xff,0x0f,0x14,0xe1,0x00,0x05,0x18,0x03]

buffer_atomic_umin v5, off, ttmp[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x14,0xe1,0x00,0x05,0x1e,0x03]

buffer_atomic_umin v5, off, s[8:11], s101 offset:4095
// CHECK: [0xff,0x0f,0x14,0xe1,0x00,0x05,0x02,0x65]

buffer_atomic_umin v5, off, s[8:11], flat_scratch_lo offset:4095
// CHECK: [0xff,0x0f,0x14,0xe1,0x00,0x05,0x02,0x66]

buffer_atomic_umin v5, off, s[8:11], flat_scratch_hi offset:4095
// CHECK: [0xff,0x0f,0x14,0xe1,0x00,0x05,0x02,0x67]

buffer_atomic_umin v5, off, s[8:11], vcc_lo offset:4095
// CHECK: [0xff,0x0f,0x14,0xe1,0x00,0x05,0x02,0x6a]

buffer_atomic_umin v5, off, s[8:11], vcc_hi offset:4095
// CHECK: [0xff,0x0f,0x14,0xe1,0x00,0x05,0x02,0x6b]

buffer_atomic_umin v5, off, s[8:11], tba_lo offset:4095
// CHECK: [0xff,0x0f,0x14,0xe1,0x00,0x05,0x02,0x6c]

buffer_atomic_umin v5, off, s[8:11], tba_hi offset:4095
// CHECK: [0xff,0x0f,0x14,0xe1,0x00,0x05,0x02,0x6d]

buffer_atomic_umin v5, off, s[8:11], tma_lo offset:4095
// CHECK: [0xff,0x0f,0x14,0xe1,0x00,0x05,0x02,0x6e]

buffer_atomic_umin v5, off, s[8:11], tma_hi offset:4095
// CHECK: [0xff,0x0f,0x14,0xe1,0x00,0x05,0x02,0x6f]

buffer_atomic_umin v5, off, s[8:11], ttmp11 offset:4095
// CHECK: [0xff,0x0f,0x14,0xe1,0x00,0x05,0x02,0x7b]

buffer_atomic_umin v5, off, s[8:11], m0 offset:4095
// CHECK: [0xff,0x0f,0x14,0xe1,0x00,0x05,0x02,0x7c]

buffer_atomic_umin v5, off, s[8:11], exec_lo offset:4095
// CHECK: [0xff,0x0f,0x14,0xe1,0x00,0x05,0x02,0x7e]

buffer_atomic_umin v5, off, s[8:11], exec_hi offset:4095
// CHECK: [0xff,0x0f,0x14,0xe1,0x00,0x05,0x02,0x7f]

buffer_atomic_umin v5, off, s[8:11], 0 offset:4095
// CHECK: [0xff,0x0f,0x14,0xe1,0x00,0x05,0x02,0x80]

buffer_atomic_umin v5, off, s[8:11], -1 offset:4095
// CHECK: [0xff,0x0f,0x14,0xe1,0x00,0x05,0x02,0xc1]

buffer_atomic_umin v5, off, s[8:11], 0.5 offset:4095
// CHECK: [0xff,0x0f,0x14,0xe1,0x00,0x05,0x02,0xf0]

buffer_atomic_umin v5, off, s[8:11], -4.0 offset:4095
// CHECK: [0xff,0x0f,0x14,0xe1,0x00,0x05,0x02,0xf7]

buffer_atomic_umin v5, off, s[8:11], src_vccz offset:4095
// CHECK: [0xff,0x0f,0x14,0xe1,0x00,0x05,0x02,0xfb]

buffer_atomic_umin v5, off, s[8:11], src_execz offset:4095
// CHECK: [0xff,0x0f,0x14,0xe1,0x00,0x05,0x02,0xfc]

buffer_atomic_umin v5, off, s[8:11], src_scc offset:4095
// CHECK: [0xff,0x0f,0x14,0xe1,0x00,0x05,0x02,0xfd]

buffer_atomic_umin v5, v0, s[8:11], s3 idxen offset:4095
// CHECK: [0xff,0x2f,0x14,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_umin v5, v0, s[8:11], s3 offen offset:4095
// CHECK: [0xff,0x1f,0x14,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_umin v5, off, s[8:11], s3
// CHECK: [0x00,0x00,0x14,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_umin v5, off, s[8:11], s3 offset:0
// CHECK: [0x00,0x00,0x14,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_umin v5, off, s[8:11], s3 offset:7
// CHECK: [0x07,0x00,0x14,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_umin v5, off, s[8:11], s3 offset:4095 glc
// CHECK: [0xff,0x4f,0x14,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_umin v5, off, s[8:11], s3 offset:4095 slc
// CHECK: [0xff,0x0f,0x16,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_smax v5, off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x18,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_smax v255, off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x18,0xe1,0x00,0xff,0x02,0x03]

buffer_atomic_smax v5, off, s[12:15], s3 offset:4095
// CHECK: [0xff,0x0f,0x18,0xe1,0x00,0x05,0x03,0x03]

buffer_atomic_smax v5, off, s[96:99], s3 offset:4095
// CHECK: [0xff,0x0f,0x18,0xe1,0x00,0x05,0x18,0x03]

buffer_atomic_smax v5, off, ttmp[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x18,0xe1,0x00,0x05,0x1e,0x03]

buffer_atomic_smax v5, off, s[8:11], s101 offset:4095
// CHECK: [0xff,0x0f,0x18,0xe1,0x00,0x05,0x02,0x65]

buffer_atomic_smax v5, off, s[8:11], flat_scratch_lo offset:4095
// CHECK: [0xff,0x0f,0x18,0xe1,0x00,0x05,0x02,0x66]

buffer_atomic_smax v5, off, s[8:11], flat_scratch_hi offset:4095
// CHECK: [0xff,0x0f,0x18,0xe1,0x00,0x05,0x02,0x67]

buffer_atomic_smax v5, off, s[8:11], vcc_lo offset:4095
// CHECK: [0xff,0x0f,0x18,0xe1,0x00,0x05,0x02,0x6a]

buffer_atomic_smax v5, off, s[8:11], vcc_hi offset:4095
// CHECK: [0xff,0x0f,0x18,0xe1,0x00,0x05,0x02,0x6b]

buffer_atomic_smax v5, off, s[8:11], tba_lo offset:4095
// CHECK: [0xff,0x0f,0x18,0xe1,0x00,0x05,0x02,0x6c]

buffer_atomic_smax v5, off, s[8:11], tba_hi offset:4095
// CHECK: [0xff,0x0f,0x18,0xe1,0x00,0x05,0x02,0x6d]

buffer_atomic_smax v5, off, s[8:11], tma_lo offset:4095
// CHECK: [0xff,0x0f,0x18,0xe1,0x00,0x05,0x02,0x6e]

buffer_atomic_smax v5, off, s[8:11], tma_hi offset:4095
// CHECK: [0xff,0x0f,0x18,0xe1,0x00,0x05,0x02,0x6f]

buffer_atomic_smax v5, off, s[8:11], ttmp11 offset:4095
// CHECK: [0xff,0x0f,0x18,0xe1,0x00,0x05,0x02,0x7b]

buffer_atomic_smax v5, off, s[8:11], m0 offset:4095
// CHECK: [0xff,0x0f,0x18,0xe1,0x00,0x05,0x02,0x7c]

buffer_atomic_smax v5, off, s[8:11], exec_lo offset:4095
// CHECK: [0xff,0x0f,0x18,0xe1,0x00,0x05,0x02,0x7e]

buffer_atomic_smax v5, off, s[8:11], exec_hi offset:4095
// CHECK: [0xff,0x0f,0x18,0xe1,0x00,0x05,0x02,0x7f]

buffer_atomic_smax v5, off, s[8:11], 0 offset:4095
// CHECK: [0xff,0x0f,0x18,0xe1,0x00,0x05,0x02,0x80]

buffer_atomic_smax v5, off, s[8:11], -1 offset:4095
// CHECK: [0xff,0x0f,0x18,0xe1,0x00,0x05,0x02,0xc1]

buffer_atomic_smax v5, off, s[8:11], 0.5 offset:4095
// CHECK: [0xff,0x0f,0x18,0xe1,0x00,0x05,0x02,0xf0]

buffer_atomic_smax v5, off, s[8:11], -4.0 offset:4095
// CHECK: [0xff,0x0f,0x18,0xe1,0x00,0x05,0x02,0xf7]

buffer_atomic_smax v5, off, s[8:11], src_vccz offset:4095
// CHECK: [0xff,0x0f,0x18,0xe1,0x00,0x05,0x02,0xfb]

buffer_atomic_smax v5, off, s[8:11], src_execz offset:4095
// CHECK: [0xff,0x0f,0x18,0xe1,0x00,0x05,0x02,0xfc]

buffer_atomic_smax v5, off, s[8:11], src_scc offset:4095
// CHECK: [0xff,0x0f,0x18,0xe1,0x00,0x05,0x02,0xfd]

buffer_atomic_smax v5, v0, s[8:11], s3 idxen offset:4095
// CHECK: [0xff,0x2f,0x18,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_smax v5, v0, s[8:11], s3 offen offset:4095
// CHECK: [0xff,0x1f,0x18,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_smax v5, off, s[8:11], s3
// CHECK: [0x00,0x00,0x18,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_smax v5, off, s[8:11], s3 offset:0
// CHECK: [0x00,0x00,0x18,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_smax v5, off, s[8:11], s3 offset:7
// CHECK: [0x07,0x00,0x18,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_smax v5, off, s[8:11], s3 offset:4095 glc
// CHECK: [0xff,0x4f,0x18,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_smax v5, off, s[8:11], s3 offset:4095 slc
// CHECK: [0xff,0x0f,0x1a,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_umax v5, off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x1c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_umax v255, off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x1c,0xe1,0x00,0xff,0x02,0x03]

buffer_atomic_umax v5, off, s[12:15], s3 offset:4095
// CHECK: [0xff,0x0f,0x1c,0xe1,0x00,0x05,0x03,0x03]

buffer_atomic_umax v5, off, s[96:99], s3 offset:4095
// CHECK: [0xff,0x0f,0x1c,0xe1,0x00,0x05,0x18,0x03]

buffer_atomic_umax v5, off, ttmp[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x1c,0xe1,0x00,0x05,0x1e,0x03]

buffer_atomic_umax v5, off, s[8:11], s101 offset:4095
// CHECK: [0xff,0x0f,0x1c,0xe1,0x00,0x05,0x02,0x65]

buffer_atomic_umax v5, off, s[8:11], flat_scratch_lo offset:4095
// CHECK: [0xff,0x0f,0x1c,0xe1,0x00,0x05,0x02,0x66]

buffer_atomic_umax v5, off, s[8:11], flat_scratch_hi offset:4095
// CHECK: [0xff,0x0f,0x1c,0xe1,0x00,0x05,0x02,0x67]

buffer_atomic_umax v5, off, s[8:11], vcc_lo offset:4095
// CHECK: [0xff,0x0f,0x1c,0xe1,0x00,0x05,0x02,0x6a]

buffer_atomic_umax v5, off, s[8:11], vcc_hi offset:4095
// CHECK: [0xff,0x0f,0x1c,0xe1,0x00,0x05,0x02,0x6b]

buffer_atomic_umax v5, off, s[8:11], tba_lo offset:4095
// CHECK: [0xff,0x0f,0x1c,0xe1,0x00,0x05,0x02,0x6c]

buffer_atomic_umax v5, off, s[8:11], tba_hi offset:4095
// CHECK: [0xff,0x0f,0x1c,0xe1,0x00,0x05,0x02,0x6d]

buffer_atomic_umax v5, off, s[8:11], tma_lo offset:4095
// CHECK: [0xff,0x0f,0x1c,0xe1,0x00,0x05,0x02,0x6e]

buffer_atomic_umax v5, off, s[8:11], tma_hi offset:4095
// CHECK: [0xff,0x0f,0x1c,0xe1,0x00,0x05,0x02,0x6f]

buffer_atomic_umax v5, off, s[8:11], ttmp11 offset:4095
// CHECK: [0xff,0x0f,0x1c,0xe1,0x00,0x05,0x02,0x7b]

buffer_atomic_umax v5, off, s[8:11], m0 offset:4095
// CHECK: [0xff,0x0f,0x1c,0xe1,0x00,0x05,0x02,0x7c]

buffer_atomic_umax v5, off, s[8:11], exec_lo offset:4095
// CHECK: [0xff,0x0f,0x1c,0xe1,0x00,0x05,0x02,0x7e]

buffer_atomic_umax v5, off, s[8:11], exec_hi offset:4095
// CHECK: [0xff,0x0f,0x1c,0xe1,0x00,0x05,0x02,0x7f]

buffer_atomic_umax v5, off, s[8:11], 0 offset:4095
// CHECK: [0xff,0x0f,0x1c,0xe1,0x00,0x05,0x02,0x80]

buffer_atomic_umax v5, off, s[8:11], -1 offset:4095
// CHECK: [0xff,0x0f,0x1c,0xe1,0x00,0x05,0x02,0xc1]

buffer_atomic_umax v5, off, s[8:11], 0.5 offset:4095
// CHECK: [0xff,0x0f,0x1c,0xe1,0x00,0x05,0x02,0xf0]

buffer_atomic_umax v5, off, s[8:11], -4.0 offset:4095
// CHECK: [0xff,0x0f,0x1c,0xe1,0x00,0x05,0x02,0xf7]

buffer_atomic_umax v5, off, s[8:11], src_vccz offset:4095
// CHECK: [0xff,0x0f,0x1c,0xe1,0x00,0x05,0x02,0xfb]

buffer_atomic_umax v5, off, s[8:11], src_execz offset:4095
// CHECK: [0xff,0x0f,0x1c,0xe1,0x00,0x05,0x02,0xfc]

buffer_atomic_umax v5, off, s[8:11], src_scc offset:4095
// CHECK: [0xff,0x0f,0x1c,0xe1,0x00,0x05,0x02,0xfd]

buffer_atomic_umax v5, v0, s[8:11], s3 idxen offset:4095
// CHECK: [0xff,0x2f,0x1c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_umax v5, v0, s[8:11], s3 offen offset:4095
// CHECK: [0xff,0x1f,0x1c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_umax v5, off, s[8:11], s3
// CHECK: [0x00,0x00,0x1c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_umax v5, off, s[8:11], s3 offset:0
// CHECK: [0x00,0x00,0x1c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_umax v5, off, s[8:11], s3 offset:7
// CHECK: [0x07,0x00,0x1c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_umax v5, off, s[8:11], s3 offset:4095 glc
// CHECK: [0xff,0x4f,0x1c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_umax v5, off, s[8:11], s3 offset:4095 slc
// CHECK: [0xff,0x0f,0x1e,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_and v5, off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x20,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_and v255, off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x20,0xe1,0x00,0xff,0x02,0x03]

buffer_atomic_and v5, off, s[12:15], s3 offset:4095
// CHECK: [0xff,0x0f,0x20,0xe1,0x00,0x05,0x03,0x03]

buffer_atomic_and v5, off, s[96:99], s3 offset:4095
// CHECK: [0xff,0x0f,0x20,0xe1,0x00,0x05,0x18,0x03]

buffer_atomic_and v5, off, ttmp[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x20,0xe1,0x00,0x05,0x1e,0x03]

buffer_atomic_and v5, off, s[8:11], s101 offset:4095
// CHECK: [0xff,0x0f,0x20,0xe1,0x00,0x05,0x02,0x65]

buffer_atomic_and v5, off, s[8:11], flat_scratch_lo offset:4095
// CHECK: [0xff,0x0f,0x20,0xe1,0x00,0x05,0x02,0x66]

buffer_atomic_and v5, off, s[8:11], flat_scratch_hi offset:4095
// CHECK: [0xff,0x0f,0x20,0xe1,0x00,0x05,0x02,0x67]

buffer_atomic_and v5, off, s[8:11], vcc_lo offset:4095
// CHECK: [0xff,0x0f,0x20,0xe1,0x00,0x05,0x02,0x6a]

buffer_atomic_and v5, off, s[8:11], vcc_hi offset:4095
// CHECK: [0xff,0x0f,0x20,0xe1,0x00,0x05,0x02,0x6b]

buffer_atomic_and v5, off, s[8:11], tba_lo offset:4095
// CHECK: [0xff,0x0f,0x20,0xe1,0x00,0x05,0x02,0x6c]

buffer_atomic_and v5, off, s[8:11], tba_hi offset:4095
// CHECK: [0xff,0x0f,0x20,0xe1,0x00,0x05,0x02,0x6d]

buffer_atomic_and v5, off, s[8:11], tma_lo offset:4095
// CHECK: [0xff,0x0f,0x20,0xe1,0x00,0x05,0x02,0x6e]

buffer_atomic_and v5, off, s[8:11], tma_hi offset:4095
// CHECK: [0xff,0x0f,0x20,0xe1,0x00,0x05,0x02,0x6f]

buffer_atomic_and v5, off, s[8:11], ttmp11 offset:4095
// CHECK: [0xff,0x0f,0x20,0xe1,0x00,0x05,0x02,0x7b]

buffer_atomic_and v5, off, s[8:11], m0 offset:4095
// CHECK: [0xff,0x0f,0x20,0xe1,0x00,0x05,0x02,0x7c]

buffer_atomic_and v5, off, s[8:11], exec_lo offset:4095
// CHECK: [0xff,0x0f,0x20,0xe1,0x00,0x05,0x02,0x7e]

buffer_atomic_and v5, off, s[8:11], exec_hi offset:4095
// CHECK: [0xff,0x0f,0x20,0xe1,0x00,0x05,0x02,0x7f]

buffer_atomic_and v5, off, s[8:11], 0 offset:4095
// CHECK: [0xff,0x0f,0x20,0xe1,0x00,0x05,0x02,0x80]

buffer_atomic_and v5, off, s[8:11], -1 offset:4095
// CHECK: [0xff,0x0f,0x20,0xe1,0x00,0x05,0x02,0xc1]

buffer_atomic_and v5, off, s[8:11], 0.5 offset:4095
// CHECK: [0xff,0x0f,0x20,0xe1,0x00,0x05,0x02,0xf0]

buffer_atomic_and v5, off, s[8:11], -4.0 offset:4095
// CHECK: [0xff,0x0f,0x20,0xe1,0x00,0x05,0x02,0xf7]

buffer_atomic_and v5, off, s[8:11], src_vccz offset:4095
// CHECK: [0xff,0x0f,0x20,0xe1,0x00,0x05,0x02,0xfb]

buffer_atomic_and v5, off, s[8:11], src_execz offset:4095
// CHECK: [0xff,0x0f,0x20,0xe1,0x00,0x05,0x02,0xfc]

buffer_atomic_and v5, off, s[8:11], src_scc offset:4095
// CHECK: [0xff,0x0f,0x20,0xe1,0x00,0x05,0x02,0xfd]

buffer_atomic_and v5, v0, s[8:11], s3 idxen offset:4095
// CHECK: [0xff,0x2f,0x20,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_and v5, v0, s[8:11], s3 offen offset:4095
// CHECK: [0xff,0x1f,0x20,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_and v5, off, s[8:11], s3
// CHECK: [0x00,0x00,0x20,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_and v5, off, s[8:11], s3 offset:0
// CHECK: [0x00,0x00,0x20,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_and v5, off, s[8:11], s3 offset:7
// CHECK: [0x07,0x00,0x20,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_and v5, off, s[8:11], s3 offset:4095 glc
// CHECK: [0xff,0x4f,0x20,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_and v5, off, s[8:11], s3 offset:4095 slc
// CHECK: [0xff,0x0f,0x22,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_or v5, off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x24,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_or v255, off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x24,0xe1,0x00,0xff,0x02,0x03]

buffer_atomic_or v5, off, s[12:15], s3 offset:4095
// CHECK: [0xff,0x0f,0x24,0xe1,0x00,0x05,0x03,0x03]

buffer_atomic_or v5, off, s[96:99], s3 offset:4095
// CHECK: [0xff,0x0f,0x24,0xe1,0x00,0x05,0x18,0x03]

buffer_atomic_or v5, off, ttmp[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x24,0xe1,0x00,0x05,0x1e,0x03]

buffer_atomic_or v5, off, s[8:11], s101 offset:4095
// CHECK: [0xff,0x0f,0x24,0xe1,0x00,0x05,0x02,0x65]

buffer_atomic_or v5, off, s[8:11], flat_scratch_lo offset:4095
// CHECK: [0xff,0x0f,0x24,0xe1,0x00,0x05,0x02,0x66]

buffer_atomic_or v5, off, s[8:11], flat_scratch_hi offset:4095
// CHECK: [0xff,0x0f,0x24,0xe1,0x00,0x05,0x02,0x67]

buffer_atomic_or v5, off, s[8:11], vcc_lo offset:4095
// CHECK: [0xff,0x0f,0x24,0xe1,0x00,0x05,0x02,0x6a]

buffer_atomic_or v5, off, s[8:11], vcc_hi offset:4095
// CHECK: [0xff,0x0f,0x24,0xe1,0x00,0x05,0x02,0x6b]

buffer_atomic_or v5, off, s[8:11], tba_lo offset:4095
// CHECK: [0xff,0x0f,0x24,0xe1,0x00,0x05,0x02,0x6c]

buffer_atomic_or v5, off, s[8:11], tba_hi offset:4095
// CHECK: [0xff,0x0f,0x24,0xe1,0x00,0x05,0x02,0x6d]

buffer_atomic_or v5, off, s[8:11], tma_lo offset:4095
// CHECK: [0xff,0x0f,0x24,0xe1,0x00,0x05,0x02,0x6e]

buffer_atomic_or v5, off, s[8:11], tma_hi offset:4095
// CHECK: [0xff,0x0f,0x24,0xe1,0x00,0x05,0x02,0x6f]

buffer_atomic_or v5, off, s[8:11], ttmp11 offset:4095
// CHECK: [0xff,0x0f,0x24,0xe1,0x00,0x05,0x02,0x7b]

buffer_atomic_or v5, off, s[8:11], m0 offset:4095
// CHECK: [0xff,0x0f,0x24,0xe1,0x00,0x05,0x02,0x7c]

buffer_atomic_or v5, off, s[8:11], exec_lo offset:4095
// CHECK: [0xff,0x0f,0x24,0xe1,0x00,0x05,0x02,0x7e]

buffer_atomic_or v5, off, s[8:11], exec_hi offset:4095
// CHECK: [0xff,0x0f,0x24,0xe1,0x00,0x05,0x02,0x7f]

buffer_atomic_or v5, off, s[8:11], 0 offset:4095
// CHECK: [0xff,0x0f,0x24,0xe1,0x00,0x05,0x02,0x80]

buffer_atomic_or v5, off, s[8:11], -1 offset:4095
// CHECK: [0xff,0x0f,0x24,0xe1,0x00,0x05,0x02,0xc1]

buffer_atomic_or v5, off, s[8:11], 0.5 offset:4095
// CHECK: [0xff,0x0f,0x24,0xe1,0x00,0x05,0x02,0xf0]

buffer_atomic_or v5, off, s[8:11], -4.0 offset:4095
// CHECK: [0xff,0x0f,0x24,0xe1,0x00,0x05,0x02,0xf7]

buffer_atomic_or v5, off, s[8:11], src_vccz offset:4095
// CHECK: [0xff,0x0f,0x24,0xe1,0x00,0x05,0x02,0xfb]

buffer_atomic_or v5, off, s[8:11], src_execz offset:4095
// CHECK: [0xff,0x0f,0x24,0xe1,0x00,0x05,0x02,0xfc]

buffer_atomic_or v5, off, s[8:11], src_scc offset:4095
// CHECK: [0xff,0x0f,0x24,0xe1,0x00,0x05,0x02,0xfd]

buffer_atomic_or v5, v0, s[8:11], s3 idxen offset:4095
// CHECK: [0xff,0x2f,0x24,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_or v5, v0, s[8:11], s3 offen offset:4095
// CHECK: [0xff,0x1f,0x24,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_or v5, off, s[8:11], s3
// CHECK: [0x00,0x00,0x24,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_or v5, off, s[8:11], s3 offset:0
// CHECK: [0x00,0x00,0x24,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_or v5, off, s[8:11], s3 offset:7
// CHECK: [0x07,0x00,0x24,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_or v5, off, s[8:11], s3 offset:4095 glc
// CHECK: [0xff,0x4f,0x24,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_or v5, off, s[8:11], s3 offset:4095 slc
// CHECK: [0xff,0x0f,0x26,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_xor v5, off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x28,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_xor v255, off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x28,0xe1,0x00,0xff,0x02,0x03]

buffer_atomic_xor v5, off, s[12:15], s3 offset:4095
// CHECK: [0xff,0x0f,0x28,0xe1,0x00,0x05,0x03,0x03]

buffer_atomic_xor v5, off, s[96:99], s3 offset:4095
// CHECK: [0xff,0x0f,0x28,0xe1,0x00,0x05,0x18,0x03]

buffer_atomic_xor v5, off, ttmp[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x28,0xe1,0x00,0x05,0x1e,0x03]

buffer_atomic_xor v5, off, s[8:11], s101 offset:4095
// CHECK: [0xff,0x0f,0x28,0xe1,0x00,0x05,0x02,0x65]

buffer_atomic_xor v5, off, s[8:11], flat_scratch_lo offset:4095
// CHECK: [0xff,0x0f,0x28,0xe1,0x00,0x05,0x02,0x66]

buffer_atomic_xor v5, off, s[8:11], flat_scratch_hi offset:4095
// CHECK: [0xff,0x0f,0x28,0xe1,0x00,0x05,0x02,0x67]

buffer_atomic_xor v5, off, s[8:11], vcc_lo offset:4095
// CHECK: [0xff,0x0f,0x28,0xe1,0x00,0x05,0x02,0x6a]

buffer_atomic_xor v5, off, s[8:11], vcc_hi offset:4095
// CHECK: [0xff,0x0f,0x28,0xe1,0x00,0x05,0x02,0x6b]

buffer_atomic_xor v5, off, s[8:11], tba_lo offset:4095
// CHECK: [0xff,0x0f,0x28,0xe1,0x00,0x05,0x02,0x6c]

buffer_atomic_xor v5, off, s[8:11], tba_hi offset:4095
// CHECK: [0xff,0x0f,0x28,0xe1,0x00,0x05,0x02,0x6d]

buffer_atomic_xor v5, off, s[8:11], tma_lo offset:4095
// CHECK: [0xff,0x0f,0x28,0xe1,0x00,0x05,0x02,0x6e]

buffer_atomic_xor v5, off, s[8:11], tma_hi offset:4095
// CHECK: [0xff,0x0f,0x28,0xe1,0x00,0x05,0x02,0x6f]

buffer_atomic_xor v5, off, s[8:11], ttmp11 offset:4095
// CHECK: [0xff,0x0f,0x28,0xe1,0x00,0x05,0x02,0x7b]

buffer_atomic_xor v5, off, s[8:11], m0 offset:4095
// CHECK: [0xff,0x0f,0x28,0xe1,0x00,0x05,0x02,0x7c]

buffer_atomic_xor v5, off, s[8:11], exec_lo offset:4095
// CHECK: [0xff,0x0f,0x28,0xe1,0x00,0x05,0x02,0x7e]

buffer_atomic_xor v5, off, s[8:11], exec_hi offset:4095
// CHECK: [0xff,0x0f,0x28,0xe1,0x00,0x05,0x02,0x7f]

buffer_atomic_xor v5, off, s[8:11], 0 offset:4095
// CHECK: [0xff,0x0f,0x28,0xe1,0x00,0x05,0x02,0x80]

buffer_atomic_xor v5, off, s[8:11], -1 offset:4095
// CHECK: [0xff,0x0f,0x28,0xe1,0x00,0x05,0x02,0xc1]

buffer_atomic_xor v5, off, s[8:11], 0.5 offset:4095
// CHECK: [0xff,0x0f,0x28,0xe1,0x00,0x05,0x02,0xf0]

buffer_atomic_xor v5, off, s[8:11], -4.0 offset:4095
// CHECK: [0xff,0x0f,0x28,0xe1,0x00,0x05,0x02,0xf7]

buffer_atomic_xor v5, off, s[8:11], src_vccz offset:4095
// CHECK: [0xff,0x0f,0x28,0xe1,0x00,0x05,0x02,0xfb]

buffer_atomic_xor v5, off, s[8:11], src_execz offset:4095
// CHECK: [0xff,0x0f,0x28,0xe1,0x00,0x05,0x02,0xfc]

buffer_atomic_xor v5, off, s[8:11], src_scc offset:4095
// CHECK: [0xff,0x0f,0x28,0xe1,0x00,0x05,0x02,0xfd]

buffer_atomic_xor v5, v0, s[8:11], s3 idxen offset:4095
// CHECK: [0xff,0x2f,0x28,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_xor v5, v0, s[8:11], s3 offen offset:4095
// CHECK: [0xff,0x1f,0x28,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_xor v5, off, s[8:11], s3
// CHECK: [0x00,0x00,0x28,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_xor v5, off, s[8:11], s3 offset:0
// CHECK: [0x00,0x00,0x28,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_xor v5, off, s[8:11], s3 offset:7
// CHECK: [0x07,0x00,0x28,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_xor v5, off, s[8:11], s3 offset:4095 glc
// CHECK: [0xff,0x4f,0x28,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_xor v5, off, s[8:11], s3 offset:4095 slc
// CHECK: [0xff,0x0f,0x2a,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_inc v5, off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x2c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_inc v255, off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x2c,0xe1,0x00,0xff,0x02,0x03]

buffer_atomic_inc v5, off, s[12:15], s3 offset:4095
// CHECK: [0xff,0x0f,0x2c,0xe1,0x00,0x05,0x03,0x03]

buffer_atomic_inc v5, off, s[96:99], s3 offset:4095
// CHECK: [0xff,0x0f,0x2c,0xe1,0x00,0x05,0x18,0x03]

buffer_atomic_inc v5, off, ttmp[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x2c,0xe1,0x00,0x05,0x1e,0x03]

buffer_atomic_inc v5, off, s[8:11], s101 offset:4095
// CHECK: [0xff,0x0f,0x2c,0xe1,0x00,0x05,0x02,0x65]

buffer_atomic_inc v5, off, s[8:11], flat_scratch_lo offset:4095
// CHECK: [0xff,0x0f,0x2c,0xe1,0x00,0x05,0x02,0x66]

buffer_atomic_inc v5, off, s[8:11], flat_scratch_hi offset:4095
// CHECK: [0xff,0x0f,0x2c,0xe1,0x00,0x05,0x02,0x67]

buffer_atomic_inc v5, off, s[8:11], vcc_lo offset:4095
// CHECK: [0xff,0x0f,0x2c,0xe1,0x00,0x05,0x02,0x6a]

buffer_atomic_inc v5, off, s[8:11], vcc_hi offset:4095
// CHECK: [0xff,0x0f,0x2c,0xe1,0x00,0x05,0x02,0x6b]

buffer_atomic_inc v5, off, s[8:11], tba_lo offset:4095
// CHECK: [0xff,0x0f,0x2c,0xe1,0x00,0x05,0x02,0x6c]

buffer_atomic_inc v5, off, s[8:11], tba_hi offset:4095
// CHECK: [0xff,0x0f,0x2c,0xe1,0x00,0x05,0x02,0x6d]

buffer_atomic_inc v5, off, s[8:11], tma_lo offset:4095
// CHECK: [0xff,0x0f,0x2c,0xe1,0x00,0x05,0x02,0x6e]

buffer_atomic_inc v5, off, s[8:11], tma_hi offset:4095
// CHECK: [0xff,0x0f,0x2c,0xe1,0x00,0x05,0x02,0x6f]

buffer_atomic_inc v5, off, s[8:11], ttmp11 offset:4095
// CHECK: [0xff,0x0f,0x2c,0xe1,0x00,0x05,0x02,0x7b]

buffer_atomic_inc v5, off, s[8:11], m0 offset:4095
// CHECK: [0xff,0x0f,0x2c,0xe1,0x00,0x05,0x02,0x7c]

buffer_atomic_inc v5, off, s[8:11], exec_lo offset:4095
// CHECK: [0xff,0x0f,0x2c,0xe1,0x00,0x05,0x02,0x7e]

buffer_atomic_inc v5, off, s[8:11], exec_hi offset:4095
// CHECK: [0xff,0x0f,0x2c,0xe1,0x00,0x05,0x02,0x7f]

buffer_atomic_inc v5, off, s[8:11], 0 offset:4095
// CHECK: [0xff,0x0f,0x2c,0xe1,0x00,0x05,0x02,0x80]

buffer_atomic_inc v5, off, s[8:11], -1 offset:4095
// CHECK: [0xff,0x0f,0x2c,0xe1,0x00,0x05,0x02,0xc1]

buffer_atomic_inc v5, off, s[8:11], 0.5 offset:4095
// CHECK: [0xff,0x0f,0x2c,0xe1,0x00,0x05,0x02,0xf0]

buffer_atomic_inc v5, off, s[8:11], -4.0 offset:4095
// CHECK: [0xff,0x0f,0x2c,0xe1,0x00,0x05,0x02,0xf7]

buffer_atomic_inc v5, off, s[8:11], src_vccz offset:4095
// CHECK: [0xff,0x0f,0x2c,0xe1,0x00,0x05,0x02,0xfb]

buffer_atomic_inc v5, off, s[8:11], src_execz offset:4095
// CHECK: [0xff,0x0f,0x2c,0xe1,0x00,0x05,0x02,0xfc]

buffer_atomic_inc v5, off, s[8:11], src_scc offset:4095
// CHECK: [0xff,0x0f,0x2c,0xe1,0x00,0x05,0x02,0xfd]

buffer_atomic_inc v5, v0, s[8:11], s3 idxen offset:4095
// CHECK: [0xff,0x2f,0x2c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_inc v5, v0, s[8:11], s3 offen offset:4095
// CHECK: [0xff,0x1f,0x2c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_inc v5, off, s[8:11], s3
// CHECK: [0x00,0x00,0x2c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_inc v5, off, s[8:11], s3 offset:0
// CHECK: [0x00,0x00,0x2c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_inc v5, off, s[8:11], s3 offset:7
// CHECK: [0x07,0x00,0x2c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_inc v5, off, s[8:11], s3 offset:4095 glc
// CHECK: [0xff,0x4f,0x2c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_inc v5, off, s[8:11], s3 offset:4095 slc
// CHECK: [0xff,0x0f,0x2e,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_dec v5, off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x30,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_dec v255, off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x30,0xe1,0x00,0xff,0x02,0x03]

buffer_atomic_dec v5, off, s[12:15], s3 offset:4095
// CHECK: [0xff,0x0f,0x30,0xe1,0x00,0x05,0x03,0x03]

buffer_atomic_dec v5, off, s[96:99], s3 offset:4095
// CHECK: [0xff,0x0f,0x30,0xe1,0x00,0x05,0x18,0x03]

buffer_atomic_dec v5, off, ttmp[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x30,0xe1,0x00,0x05,0x1e,0x03]

buffer_atomic_dec v5, off, s[8:11], s101 offset:4095
// CHECK: [0xff,0x0f,0x30,0xe1,0x00,0x05,0x02,0x65]

buffer_atomic_dec v5, off, s[8:11], flat_scratch_lo offset:4095
// CHECK: [0xff,0x0f,0x30,0xe1,0x00,0x05,0x02,0x66]

buffer_atomic_dec v5, off, s[8:11], flat_scratch_hi offset:4095
// CHECK: [0xff,0x0f,0x30,0xe1,0x00,0x05,0x02,0x67]

buffer_atomic_dec v5, off, s[8:11], vcc_lo offset:4095
// CHECK: [0xff,0x0f,0x30,0xe1,0x00,0x05,0x02,0x6a]

buffer_atomic_dec v5, off, s[8:11], vcc_hi offset:4095
// CHECK: [0xff,0x0f,0x30,0xe1,0x00,0x05,0x02,0x6b]

buffer_atomic_dec v5, off, s[8:11], tba_lo offset:4095
// CHECK: [0xff,0x0f,0x30,0xe1,0x00,0x05,0x02,0x6c]

buffer_atomic_dec v5, off, s[8:11], tba_hi offset:4095
// CHECK: [0xff,0x0f,0x30,0xe1,0x00,0x05,0x02,0x6d]

buffer_atomic_dec v5, off, s[8:11], tma_lo offset:4095
// CHECK: [0xff,0x0f,0x30,0xe1,0x00,0x05,0x02,0x6e]

buffer_atomic_dec v5, off, s[8:11], tma_hi offset:4095
// CHECK: [0xff,0x0f,0x30,0xe1,0x00,0x05,0x02,0x6f]

buffer_atomic_dec v5, off, s[8:11], ttmp11 offset:4095
// CHECK: [0xff,0x0f,0x30,0xe1,0x00,0x05,0x02,0x7b]

buffer_atomic_dec v5, off, s[8:11], m0 offset:4095
// CHECK: [0xff,0x0f,0x30,0xe1,0x00,0x05,0x02,0x7c]

buffer_atomic_dec v5, off, s[8:11], exec_lo offset:4095
// CHECK: [0xff,0x0f,0x30,0xe1,0x00,0x05,0x02,0x7e]

buffer_atomic_dec v5, off, s[8:11], exec_hi offset:4095
// CHECK: [0xff,0x0f,0x30,0xe1,0x00,0x05,0x02,0x7f]

buffer_atomic_dec v5, off, s[8:11], 0 offset:4095
// CHECK: [0xff,0x0f,0x30,0xe1,0x00,0x05,0x02,0x80]

buffer_atomic_dec v5, off, s[8:11], -1 offset:4095
// CHECK: [0xff,0x0f,0x30,0xe1,0x00,0x05,0x02,0xc1]

buffer_atomic_dec v5, off, s[8:11], 0.5 offset:4095
// CHECK: [0xff,0x0f,0x30,0xe1,0x00,0x05,0x02,0xf0]

buffer_atomic_dec v5, off, s[8:11], -4.0 offset:4095
// CHECK: [0xff,0x0f,0x30,0xe1,0x00,0x05,0x02,0xf7]

buffer_atomic_dec v5, off, s[8:11], src_vccz offset:4095
// CHECK: [0xff,0x0f,0x30,0xe1,0x00,0x05,0x02,0xfb]

buffer_atomic_dec v5, off, s[8:11], src_execz offset:4095
// CHECK: [0xff,0x0f,0x30,0xe1,0x00,0x05,0x02,0xfc]

buffer_atomic_dec v5, off, s[8:11], src_scc offset:4095
// CHECK: [0xff,0x0f,0x30,0xe1,0x00,0x05,0x02,0xfd]

buffer_atomic_dec v5, v0, s[8:11], s3 idxen offset:4095
// CHECK: [0xff,0x2f,0x30,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_dec v5, v0, s[8:11], s3 offen offset:4095
// CHECK: [0xff,0x1f,0x30,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_dec v5, off, s[8:11], s3
// CHECK: [0x00,0x00,0x30,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_dec v5, off, s[8:11], s3 offset:0
// CHECK: [0x00,0x00,0x30,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_dec v5, off, s[8:11], s3 offset:7
// CHECK: [0x07,0x00,0x30,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_dec v5, off, s[8:11], s3 offset:4095 glc
// CHECK: [0xff,0x4f,0x30,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_dec v5, off, s[8:11], s3 offset:4095 slc
// CHECK: [0xff,0x0f,0x32,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_swap_x2 v[5:6], off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x80,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_swap_x2 v[254:255], off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x80,0xe1,0x00,0xfe,0x02,0x03]

buffer_atomic_swap_x2 v[5:6], off, s[12:15], s3 offset:4095
// CHECK: [0xff,0x0f,0x80,0xe1,0x00,0x05,0x03,0x03]

buffer_atomic_swap_x2 v[5:6], off, s[96:99], s3 offset:4095
// CHECK: [0xff,0x0f,0x80,0xe1,0x00,0x05,0x18,0x03]

buffer_atomic_swap_x2 v[5:6], off, ttmp[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x80,0xe1,0x00,0x05,0x1e,0x03]

buffer_atomic_swap_x2 v[5:6], off, s[8:11], s101 offset:4095
// CHECK: [0xff,0x0f,0x80,0xe1,0x00,0x05,0x02,0x65]

buffer_atomic_swap_x2 v[5:6], off, s[8:11], flat_scratch_lo offset:4095
// CHECK: [0xff,0x0f,0x80,0xe1,0x00,0x05,0x02,0x66]

buffer_atomic_swap_x2 v[5:6], off, s[8:11], flat_scratch_hi offset:4095
// CHECK: [0xff,0x0f,0x80,0xe1,0x00,0x05,0x02,0x67]

buffer_atomic_swap_x2 v[5:6], off, s[8:11], vcc_lo offset:4095
// CHECK: [0xff,0x0f,0x80,0xe1,0x00,0x05,0x02,0x6a]

buffer_atomic_swap_x2 v[5:6], off, s[8:11], vcc_hi offset:4095
// CHECK: [0xff,0x0f,0x80,0xe1,0x00,0x05,0x02,0x6b]

buffer_atomic_swap_x2 v[5:6], off, s[8:11], tba_lo offset:4095
// CHECK: [0xff,0x0f,0x80,0xe1,0x00,0x05,0x02,0x6c]

buffer_atomic_swap_x2 v[5:6], off, s[8:11], tba_hi offset:4095
// CHECK: [0xff,0x0f,0x80,0xe1,0x00,0x05,0x02,0x6d]

buffer_atomic_swap_x2 v[5:6], off, s[8:11], tma_lo offset:4095
// CHECK: [0xff,0x0f,0x80,0xe1,0x00,0x05,0x02,0x6e]

buffer_atomic_swap_x2 v[5:6], off, s[8:11], tma_hi offset:4095
// CHECK: [0xff,0x0f,0x80,0xe1,0x00,0x05,0x02,0x6f]

buffer_atomic_swap_x2 v[5:6], off, s[8:11], ttmp11 offset:4095
// CHECK: [0xff,0x0f,0x80,0xe1,0x00,0x05,0x02,0x7b]

buffer_atomic_swap_x2 v[5:6], off, s[8:11], m0 offset:4095
// CHECK: [0xff,0x0f,0x80,0xe1,0x00,0x05,0x02,0x7c]

buffer_atomic_swap_x2 v[5:6], off, s[8:11], exec_lo offset:4095
// CHECK: [0xff,0x0f,0x80,0xe1,0x00,0x05,0x02,0x7e]

buffer_atomic_swap_x2 v[5:6], off, s[8:11], exec_hi offset:4095
// CHECK: [0xff,0x0f,0x80,0xe1,0x00,0x05,0x02,0x7f]

buffer_atomic_swap_x2 v[5:6], off, s[8:11], 0 offset:4095
// CHECK: [0xff,0x0f,0x80,0xe1,0x00,0x05,0x02,0x80]

buffer_atomic_swap_x2 v[5:6], off, s[8:11], -1 offset:4095
// CHECK: [0xff,0x0f,0x80,0xe1,0x00,0x05,0x02,0xc1]

buffer_atomic_swap_x2 v[5:6], off, s[8:11], 0.5 offset:4095
// CHECK: [0xff,0x0f,0x80,0xe1,0x00,0x05,0x02,0xf0]

buffer_atomic_swap_x2 v[5:6], off, s[8:11], -4.0 offset:4095
// CHECK: [0xff,0x0f,0x80,0xe1,0x00,0x05,0x02,0xf7]

buffer_atomic_swap_x2 v[5:6], off, s[8:11], src_vccz offset:4095
// CHECK: [0xff,0x0f,0x80,0xe1,0x00,0x05,0x02,0xfb]

buffer_atomic_swap_x2 v[5:6], off, s[8:11], src_execz offset:4095
// CHECK: [0xff,0x0f,0x80,0xe1,0x00,0x05,0x02,0xfc]

buffer_atomic_swap_x2 v[5:6], off, s[8:11], src_scc offset:4095
// CHECK: [0xff,0x0f,0x80,0xe1,0x00,0x05,0x02,0xfd]

buffer_atomic_swap_x2 v[5:6], v0, s[8:11], s3 idxen offset:4095
// CHECK: [0xff,0x2f,0x80,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_swap_x2 v[5:6], v0, s[8:11], s3 offen offset:4095
// CHECK: [0xff,0x1f,0x80,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_swap_x2 v[5:6], off, s[8:11], s3
// CHECK: [0x00,0x00,0x80,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_swap_x2 v[5:6], off, s[8:11], s3 offset:0
// CHECK: [0x00,0x00,0x80,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_swap_x2 v[5:6], off, s[8:11], s3 offset:7
// CHECK: [0x07,0x00,0x80,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_swap_x2 v[5:6], off, s[8:11], s3 offset:4095 glc
// CHECK: [0xff,0x4f,0x80,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_swap_x2 v[5:6], off, s[8:11], s3 offset:4095 slc
// CHECK: [0xff,0x0f,0x82,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_cmpswap_x2 v[5:8], off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x84,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_cmpswap_x2 v[252:255], off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x84,0xe1,0x00,0xfc,0x02,0x03]

buffer_atomic_cmpswap_x2 v[5:8], off, s[12:15], s3 offset:4095
// CHECK: [0xff,0x0f,0x84,0xe1,0x00,0x05,0x03,0x03]

buffer_atomic_cmpswap_x2 v[5:8], off, s[96:99], s3 offset:4095
// CHECK: [0xff,0x0f,0x84,0xe1,0x00,0x05,0x18,0x03]

buffer_atomic_cmpswap_x2 v[5:8], off, ttmp[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x84,0xe1,0x00,0x05,0x1e,0x03]

buffer_atomic_cmpswap_x2 v[5:8], off, s[8:11], s101 offset:4095
// CHECK: [0xff,0x0f,0x84,0xe1,0x00,0x05,0x02,0x65]

buffer_atomic_cmpswap_x2 v[5:8], off, s[8:11], flat_scratch_lo offset:4095
// CHECK: [0xff,0x0f,0x84,0xe1,0x00,0x05,0x02,0x66]

buffer_atomic_cmpswap_x2 v[5:8], off, s[8:11], flat_scratch_hi offset:4095
// CHECK: [0xff,0x0f,0x84,0xe1,0x00,0x05,0x02,0x67]

buffer_atomic_cmpswap_x2 v[5:8], off, s[8:11], vcc_lo offset:4095
// CHECK: [0xff,0x0f,0x84,0xe1,0x00,0x05,0x02,0x6a]

buffer_atomic_cmpswap_x2 v[5:8], off, s[8:11], vcc_hi offset:4095
// CHECK: [0xff,0x0f,0x84,0xe1,0x00,0x05,0x02,0x6b]

buffer_atomic_cmpswap_x2 v[5:8], off, s[8:11], tba_lo offset:4095
// CHECK: [0xff,0x0f,0x84,0xe1,0x00,0x05,0x02,0x6c]

buffer_atomic_cmpswap_x2 v[5:8], off, s[8:11], tba_hi offset:4095
// CHECK: [0xff,0x0f,0x84,0xe1,0x00,0x05,0x02,0x6d]

buffer_atomic_cmpswap_x2 v[5:8], off, s[8:11], tma_lo offset:4095
// CHECK: [0xff,0x0f,0x84,0xe1,0x00,0x05,0x02,0x6e]

buffer_atomic_cmpswap_x2 v[5:8], off, s[8:11], tma_hi offset:4095
// CHECK: [0xff,0x0f,0x84,0xe1,0x00,0x05,0x02,0x6f]

buffer_atomic_cmpswap_x2 v[5:8], off, s[8:11], ttmp11 offset:4095
// CHECK: [0xff,0x0f,0x84,0xe1,0x00,0x05,0x02,0x7b]

buffer_atomic_cmpswap_x2 v[5:8], off, s[8:11], m0 offset:4095
// CHECK: [0xff,0x0f,0x84,0xe1,0x00,0x05,0x02,0x7c]

buffer_atomic_cmpswap_x2 v[5:8], off, s[8:11], exec_lo offset:4095
// CHECK: [0xff,0x0f,0x84,0xe1,0x00,0x05,0x02,0x7e]

buffer_atomic_cmpswap_x2 v[5:8], off, s[8:11], exec_hi offset:4095
// CHECK: [0xff,0x0f,0x84,0xe1,0x00,0x05,0x02,0x7f]

buffer_atomic_cmpswap_x2 v[5:8], off, s[8:11], 0 offset:4095
// CHECK: [0xff,0x0f,0x84,0xe1,0x00,0x05,0x02,0x80]

buffer_atomic_cmpswap_x2 v[5:8], off, s[8:11], -1 offset:4095
// CHECK: [0xff,0x0f,0x84,0xe1,0x00,0x05,0x02,0xc1]

buffer_atomic_cmpswap_x2 v[5:8], off, s[8:11], 0.5 offset:4095
// CHECK: [0xff,0x0f,0x84,0xe1,0x00,0x05,0x02,0xf0]

buffer_atomic_cmpswap_x2 v[5:8], off, s[8:11], -4.0 offset:4095
// CHECK: [0xff,0x0f,0x84,0xe1,0x00,0x05,0x02,0xf7]

buffer_atomic_cmpswap_x2 v[5:8], off, s[8:11], src_vccz offset:4095
// CHECK: [0xff,0x0f,0x84,0xe1,0x00,0x05,0x02,0xfb]

buffer_atomic_cmpswap_x2 v[5:8], off, s[8:11], src_execz offset:4095
// CHECK: [0xff,0x0f,0x84,0xe1,0x00,0x05,0x02,0xfc]

buffer_atomic_cmpswap_x2 v[5:8], off, s[8:11], src_scc offset:4095
// CHECK: [0xff,0x0f,0x84,0xe1,0x00,0x05,0x02,0xfd]

buffer_atomic_cmpswap_x2 v[5:8], v0, s[8:11], s3 idxen offset:4095
// CHECK: [0xff,0x2f,0x84,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_cmpswap_x2 v[5:8], v0, s[8:11], s3 offen offset:4095
// CHECK: [0xff,0x1f,0x84,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_cmpswap_x2 v[5:8], off, s[8:11], s3
// CHECK: [0x00,0x00,0x84,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_cmpswap_x2 v[5:8], off, s[8:11], s3 offset:0
// CHECK: [0x00,0x00,0x84,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_cmpswap_x2 v[5:8], off, s[8:11], s3 offset:7
// CHECK: [0x07,0x00,0x84,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_cmpswap_x2 v[5:8], off, s[8:11], s3 offset:4095 glc
// CHECK: [0xff,0x4f,0x84,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_cmpswap_x2 v[5:8], off, s[8:11], s3 offset:4095 slc
// CHECK: [0xff,0x0f,0x86,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_add_x2 v[5:6], off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x88,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_add_x2 v[254:255], off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x88,0xe1,0x00,0xfe,0x02,0x03]

buffer_atomic_add_x2 v[5:6], off, s[12:15], s3 offset:4095
// CHECK: [0xff,0x0f,0x88,0xe1,0x00,0x05,0x03,0x03]

buffer_atomic_add_x2 v[5:6], off, s[96:99], s3 offset:4095
// CHECK: [0xff,0x0f,0x88,0xe1,0x00,0x05,0x18,0x03]

buffer_atomic_add_x2 v[5:6], off, ttmp[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x88,0xe1,0x00,0x05,0x1e,0x03]

buffer_atomic_add_x2 v[5:6], off, s[8:11], s101 offset:4095
// CHECK: [0xff,0x0f,0x88,0xe1,0x00,0x05,0x02,0x65]

buffer_atomic_add_x2 v[5:6], off, s[8:11], flat_scratch_lo offset:4095
// CHECK: [0xff,0x0f,0x88,0xe1,0x00,0x05,0x02,0x66]

buffer_atomic_add_x2 v[5:6], off, s[8:11], flat_scratch_hi offset:4095
// CHECK: [0xff,0x0f,0x88,0xe1,0x00,0x05,0x02,0x67]

buffer_atomic_add_x2 v[5:6], off, s[8:11], vcc_lo offset:4095
// CHECK: [0xff,0x0f,0x88,0xe1,0x00,0x05,0x02,0x6a]

buffer_atomic_add_x2 v[5:6], off, s[8:11], vcc_hi offset:4095
// CHECK: [0xff,0x0f,0x88,0xe1,0x00,0x05,0x02,0x6b]

buffer_atomic_add_x2 v[5:6], off, s[8:11], tba_lo offset:4095
// CHECK: [0xff,0x0f,0x88,0xe1,0x00,0x05,0x02,0x6c]

buffer_atomic_add_x2 v[5:6], off, s[8:11], tba_hi offset:4095
// CHECK: [0xff,0x0f,0x88,0xe1,0x00,0x05,0x02,0x6d]

buffer_atomic_add_x2 v[5:6], off, s[8:11], tma_lo offset:4095
// CHECK: [0xff,0x0f,0x88,0xe1,0x00,0x05,0x02,0x6e]

buffer_atomic_add_x2 v[5:6], off, s[8:11], tma_hi offset:4095
// CHECK: [0xff,0x0f,0x88,0xe1,0x00,0x05,0x02,0x6f]

buffer_atomic_add_x2 v[5:6], off, s[8:11], ttmp11 offset:4095
// CHECK: [0xff,0x0f,0x88,0xe1,0x00,0x05,0x02,0x7b]

buffer_atomic_add_x2 v[5:6], off, s[8:11], m0 offset:4095
// CHECK: [0xff,0x0f,0x88,0xe1,0x00,0x05,0x02,0x7c]

buffer_atomic_add_x2 v[5:6], off, s[8:11], exec_lo offset:4095
// CHECK: [0xff,0x0f,0x88,0xe1,0x00,0x05,0x02,0x7e]

buffer_atomic_add_x2 v[5:6], off, s[8:11], exec_hi offset:4095
// CHECK: [0xff,0x0f,0x88,0xe1,0x00,0x05,0x02,0x7f]

buffer_atomic_add_x2 v[5:6], off, s[8:11], 0 offset:4095
// CHECK: [0xff,0x0f,0x88,0xe1,0x00,0x05,0x02,0x80]

buffer_atomic_add_x2 v[5:6], off, s[8:11], -1 offset:4095
// CHECK: [0xff,0x0f,0x88,0xe1,0x00,0x05,0x02,0xc1]

buffer_atomic_add_x2 v[5:6], off, s[8:11], 0.5 offset:4095
// CHECK: [0xff,0x0f,0x88,0xe1,0x00,0x05,0x02,0xf0]

buffer_atomic_add_x2 v[5:6], off, s[8:11], -4.0 offset:4095
// CHECK: [0xff,0x0f,0x88,0xe1,0x00,0x05,0x02,0xf7]

buffer_atomic_add_x2 v[5:6], off, s[8:11], src_vccz offset:4095
// CHECK: [0xff,0x0f,0x88,0xe1,0x00,0x05,0x02,0xfb]

buffer_atomic_add_x2 v[5:6], off, s[8:11], src_execz offset:4095
// CHECK: [0xff,0x0f,0x88,0xe1,0x00,0x05,0x02,0xfc]

buffer_atomic_add_x2 v[5:6], off, s[8:11], src_scc offset:4095
// CHECK: [0xff,0x0f,0x88,0xe1,0x00,0x05,0x02,0xfd]

buffer_atomic_add_x2 v[5:6], v0, s[8:11], s3 idxen offset:4095
// CHECK: [0xff,0x2f,0x88,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_add_x2 v[5:6], v0, s[8:11], s3 offen offset:4095
// CHECK: [0xff,0x1f,0x88,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_add_x2 v[5:6], off, s[8:11], s3
// CHECK: [0x00,0x00,0x88,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_add_x2 v[5:6], off, s[8:11], s3 offset:0
// CHECK: [0x00,0x00,0x88,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_add_x2 v[5:6], off, s[8:11], s3 offset:7
// CHECK: [0x07,0x00,0x88,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_add_x2 v[5:6], off, s[8:11], s3 offset:4095 glc
// CHECK: [0xff,0x4f,0x88,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_add_x2 v[5:6], off, s[8:11], s3 offset:4095 slc
// CHECK: [0xff,0x0f,0x8a,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_sub_x2 v[5:6], off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x8c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_sub_x2 v[254:255], off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x8c,0xe1,0x00,0xfe,0x02,0x03]

buffer_atomic_sub_x2 v[5:6], off, s[12:15], s3 offset:4095
// CHECK: [0xff,0x0f,0x8c,0xe1,0x00,0x05,0x03,0x03]

buffer_atomic_sub_x2 v[5:6], off, s[96:99], s3 offset:4095
// CHECK: [0xff,0x0f,0x8c,0xe1,0x00,0x05,0x18,0x03]

buffer_atomic_sub_x2 v[5:6], off, ttmp[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x8c,0xe1,0x00,0x05,0x1e,0x03]

buffer_atomic_sub_x2 v[5:6], off, s[8:11], s101 offset:4095
// CHECK: [0xff,0x0f,0x8c,0xe1,0x00,0x05,0x02,0x65]

buffer_atomic_sub_x2 v[5:6], off, s[8:11], flat_scratch_lo offset:4095
// CHECK: [0xff,0x0f,0x8c,0xe1,0x00,0x05,0x02,0x66]

buffer_atomic_sub_x2 v[5:6], off, s[8:11], flat_scratch_hi offset:4095
// CHECK: [0xff,0x0f,0x8c,0xe1,0x00,0x05,0x02,0x67]

buffer_atomic_sub_x2 v[5:6], off, s[8:11], vcc_lo offset:4095
// CHECK: [0xff,0x0f,0x8c,0xe1,0x00,0x05,0x02,0x6a]

buffer_atomic_sub_x2 v[5:6], off, s[8:11], vcc_hi offset:4095
// CHECK: [0xff,0x0f,0x8c,0xe1,0x00,0x05,0x02,0x6b]

buffer_atomic_sub_x2 v[5:6], off, s[8:11], tba_lo offset:4095
// CHECK: [0xff,0x0f,0x8c,0xe1,0x00,0x05,0x02,0x6c]

buffer_atomic_sub_x2 v[5:6], off, s[8:11], tba_hi offset:4095
// CHECK: [0xff,0x0f,0x8c,0xe1,0x00,0x05,0x02,0x6d]

buffer_atomic_sub_x2 v[5:6], off, s[8:11], tma_lo offset:4095
// CHECK: [0xff,0x0f,0x8c,0xe1,0x00,0x05,0x02,0x6e]

buffer_atomic_sub_x2 v[5:6], off, s[8:11], tma_hi offset:4095
// CHECK: [0xff,0x0f,0x8c,0xe1,0x00,0x05,0x02,0x6f]

buffer_atomic_sub_x2 v[5:6], off, s[8:11], ttmp11 offset:4095
// CHECK: [0xff,0x0f,0x8c,0xe1,0x00,0x05,0x02,0x7b]

buffer_atomic_sub_x2 v[5:6], off, s[8:11], m0 offset:4095
// CHECK: [0xff,0x0f,0x8c,0xe1,0x00,0x05,0x02,0x7c]

buffer_atomic_sub_x2 v[5:6], off, s[8:11], exec_lo offset:4095
// CHECK: [0xff,0x0f,0x8c,0xe1,0x00,0x05,0x02,0x7e]

buffer_atomic_sub_x2 v[5:6], off, s[8:11], exec_hi offset:4095
// CHECK: [0xff,0x0f,0x8c,0xe1,0x00,0x05,0x02,0x7f]

buffer_atomic_sub_x2 v[5:6], off, s[8:11], 0 offset:4095
// CHECK: [0xff,0x0f,0x8c,0xe1,0x00,0x05,0x02,0x80]

buffer_atomic_sub_x2 v[5:6], off, s[8:11], -1 offset:4095
// CHECK: [0xff,0x0f,0x8c,0xe1,0x00,0x05,0x02,0xc1]

buffer_atomic_sub_x2 v[5:6], off, s[8:11], 0.5 offset:4095
// CHECK: [0xff,0x0f,0x8c,0xe1,0x00,0x05,0x02,0xf0]

buffer_atomic_sub_x2 v[5:6], off, s[8:11], -4.0 offset:4095
// CHECK: [0xff,0x0f,0x8c,0xe1,0x00,0x05,0x02,0xf7]

buffer_atomic_sub_x2 v[5:6], off, s[8:11], src_vccz offset:4095
// CHECK: [0xff,0x0f,0x8c,0xe1,0x00,0x05,0x02,0xfb]

buffer_atomic_sub_x2 v[5:6], off, s[8:11], src_execz offset:4095
// CHECK: [0xff,0x0f,0x8c,0xe1,0x00,0x05,0x02,0xfc]

buffer_atomic_sub_x2 v[5:6], off, s[8:11], src_scc offset:4095
// CHECK: [0xff,0x0f,0x8c,0xe1,0x00,0x05,0x02,0xfd]

buffer_atomic_sub_x2 v[5:6], v0, s[8:11], s3 idxen offset:4095
// CHECK: [0xff,0x2f,0x8c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_sub_x2 v[5:6], v0, s[8:11], s3 offen offset:4095
// CHECK: [0xff,0x1f,0x8c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_sub_x2 v[5:6], off, s[8:11], s3
// CHECK: [0x00,0x00,0x8c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_sub_x2 v[5:6], off, s[8:11], s3 offset:0
// CHECK: [0x00,0x00,0x8c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_sub_x2 v[5:6], off, s[8:11], s3 offset:7
// CHECK: [0x07,0x00,0x8c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_sub_x2 v[5:6], off, s[8:11], s3 offset:4095 glc
// CHECK: [0xff,0x4f,0x8c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_sub_x2 v[5:6], off, s[8:11], s3 offset:4095 slc
// CHECK: [0xff,0x0f,0x8e,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_smin_x2 v[5:6], off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x90,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_smin_x2 v[254:255], off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x90,0xe1,0x00,0xfe,0x02,0x03]

buffer_atomic_smin_x2 v[5:6], off, s[12:15], s3 offset:4095
// CHECK: [0xff,0x0f,0x90,0xe1,0x00,0x05,0x03,0x03]

buffer_atomic_smin_x2 v[5:6], off, s[96:99], s3 offset:4095
// CHECK: [0xff,0x0f,0x90,0xe1,0x00,0x05,0x18,0x03]

buffer_atomic_smin_x2 v[5:6], off, ttmp[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x90,0xe1,0x00,0x05,0x1e,0x03]

buffer_atomic_smin_x2 v[5:6], off, s[8:11], s101 offset:4095
// CHECK: [0xff,0x0f,0x90,0xe1,0x00,0x05,0x02,0x65]

buffer_atomic_smin_x2 v[5:6], off, s[8:11], flat_scratch_lo offset:4095
// CHECK: [0xff,0x0f,0x90,0xe1,0x00,0x05,0x02,0x66]

buffer_atomic_smin_x2 v[5:6], off, s[8:11], flat_scratch_hi offset:4095
// CHECK: [0xff,0x0f,0x90,0xe1,0x00,0x05,0x02,0x67]

buffer_atomic_smin_x2 v[5:6], off, s[8:11], vcc_lo offset:4095
// CHECK: [0xff,0x0f,0x90,0xe1,0x00,0x05,0x02,0x6a]

buffer_atomic_smin_x2 v[5:6], off, s[8:11], vcc_hi offset:4095
// CHECK: [0xff,0x0f,0x90,0xe1,0x00,0x05,0x02,0x6b]

buffer_atomic_smin_x2 v[5:6], off, s[8:11], tba_lo offset:4095
// CHECK: [0xff,0x0f,0x90,0xe1,0x00,0x05,0x02,0x6c]

buffer_atomic_smin_x2 v[5:6], off, s[8:11], tba_hi offset:4095
// CHECK: [0xff,0x0f,0x90,0xe1,0x00,0x05,0x02,0x6d]

buffer_atomic_smin_x2 v[5:6], off, s[8:11], tma_lo offset:4095
// CHECK: [0xff,0x0f,0x90,0xe1,0x00,0x05,0x02,0x6e]

buffer_atomic_smin_x2 v[5:6], off, s[8:11], tma_hi offset:4095
// CHECK: [0xff,0x0f,0x90,0xe1,0x00,0x05,0x02,0x6f]

buffer_atomic_smin_x2 v[5:6], off, s[8:11], ttmp11 offset:4095
// CHECK: [0xff,0x0f,0x90,0xe1,0x00,0x05,0x02,0x7b]

buffer_atomic_smin_x2 v[5:6], off, s[8:11], m0 offset:4095
// CHECK: [0xff,0x0f,0x90,0xe1,0x00,0x05,0x02,0x7c]

buffer_atomic_smin_x2 v[5:6], off, s[8:11], exec_lo offset:4095
// CHECK: [0xff,0x0f,0x90,0xe1,0x00,0x05,0x02,0x7e]

buffer_atomic_smin_x2 v[5:6], off, s[8:11], exec_hi offset:4095
// CHECK: [0xff,0x0f,0x90,0xe1,0x00,0x05,0x02,0x7f]

buffer_atomic_smin_x2 v[5:6], off, s[8:11], 0 offset:4095
// CHECK: [0xff,0x0f,0x90,0xe1,0x00,0x05,0x02,0x80]

buffer_atomic_smin_x2 v[5:6], off, s[8:11], -1 offset:4095
// CHECK: [0xff,0x0f,0x90,0xe1,0x00,0x05,0x02,0xc1]

buffer_atomic_smin_x2 v[5:6], off, s[8:11], 0.5 offset:4095
// CHECK: [0xff,0x0f,0x90,0xe1,0x00,0x05,0x02,0xf0]

buffer_atomic_smin_x2 v[5:6], off, s[8:11], -4.0 offset:4095
// CHECK: [0xff,0x0f,0x90,0xe1,0x00,0x05,0x02,0xf7]

buffer_atomic_smin_x2 v[5:6], off, s[8:11], src_vccz offset:4095
// CHECK: [0xff,0x0f,0x90,0xe1,0x00,0x05,0x02,0xfb]

buffer_atomic_smin_x2 v[5:6], off, s[8:11], src_execz offset:4095
// CHECK: [0xff,0x0f,0x90,0xe1,0x00,0x05,0x02,0xfc]

buffer_atomic_smin_x2 v[5:6], off, s[8:11], src_scc offset:4095
// CHECK: [0xff,0x0f,0x90,0xe1,0x00,0x05,0x02,0xfd]

buffer_atomic_smin_x2 v[5:6], v0, s[8:11], s3 idxen offset:4095
// CHECK: [0xff,0x2f,0x90,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_smin_x2 v[5:6], v0, s[8:11], s3 offen offset:4095
// CHECK: [0xff,0x1f,0x90,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_smin_x2 v[5:6], off, s[8:11], s3
// CHECK: [0x00,0x00,0x90,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_smin_x2 v[5:6], off, s[8:11], s3 offset:0
// CHECK: [0x00,0x00,0x90,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_smin_x2 v[5:6], off, s[8:11], s3 offset:7
// CHECK: [0x07,0x00,0x90,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_smin_x2 v[5:6], off, s[8:11], s3 offset:4095 glc
// CHECK: [0xff,0x4f,0x90,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_smin_x2 v[5:6], off, s[8:11], s3 offset:4095 slc
// CHECK: [0xff,0x0f,0x92,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_umin_x2 v[5:6], off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x94,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_umin_x2 v[254:255], off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x94,0xe1,0x00,0xfe,0x02,0x03]

buffer_atomic_umin_x2 v[5:6], off, s[12:15], s3 offset:4095
// CHECK: [0xff,0x0f,0x94,0xe1,0x00,0x05,0x03,0x03]

buffer_atomic_umin_x2 v[5:6], off, s[96:99], s3 offset:4095
// CHECK: [0xff,0x0f,0x94,0xe1,0x00,0x05,0x18,0x03]

buffer_atomic_umin_x2 v[5:6], off, ttmp[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x94,0xe1,0x00,0x05,0x1e,0x03]

buffer_atomic_umin_x2 v[5:6], off, s[8:11], s101 offset:4095
// CHECK: [0xff,0x0f,0x94,0xe1,0x00,0x05,0x02,0x65]

buffer_atomic_umin_x2 v[5:6], off, s[8:11], flat_scratch_lo offset:4095
// CHECK: [0xff,0x0f,0x94,0xe1,0x00,0x05,0x02,0x66]

buffer_atomic_umin_x2 v[5:6], off, s[8:11], flat_scratch_hi offset:4095
// CHECK: [0xff,0x0f,0x94,0xe1,0x00,0x05,0x02,0x67]

buffer_atomic_umin_x2 v[5:6], off, s[8:11], vcc_lo offset:4095
// CHECK: [0xff,0x0f,0x94,0xe1,0x00,0x05,0x02,0x6a]

buffer_atomic_umin_x2 v[5:6], off, s[8:11], vcc_hi offset:4095
// CHECK: [0xff,0x0f,0x94,0xe1,0x00,0x05,0x02,0x6b]

buffer_atomic_umin_x2 v[5:6], off, s[8:11], tba_lo offset:4095
// CHECK: [0xff,0x0f,0x94,0xe1,0x00,0x05,0x02,0x6c]

buffer_atomic_umin_x2 v[5:6], off, s[8:11], tba_hi offset:4095
// CHECK: [0xff,0x0f,0x94,0xe1,0x00,0x05,0x02,0x6d]

buffer_atomic_umin_x2 v[5:6], off, s[8:11], tma_lo offset:4095
// CHECK: [0xff,0x0f,0x94,0xe1,0x00,0x05,0x02,0x6e]

buffer_atomic_umin_x2 v[5:6], off, s[8:11], tma_hi offset:4095
// CHECK: [0xff,0x0f,0x94,0xe1,0x00,0x05,0x02,0x6f]

buffer_atomic_umin_x2 v[5:6], off, s[8:11], ttmp11 offset:4095
// CHECK: [0xff,0x0f,0x94,0xe1,0x00,0x05,0x02,0x7b]

buffer_atomic_umin_x2 v[5:6], off, s[8:11], m0 offset:4095
// CHECK: [0xff,0x0f,0x94,0xe1,0x00,0x05,0x02,0x7c]

buffer_atomic_umin_x2 v[5:6], off, s[8:11], exec_lo offset:4095
// CHECK: [0xff,0x0f,0x94,0xe1,0x00,0x05,0x02,0x7e]

buffer_atomic_umin_x2 v[5:6], off, s[8:11], exec_hi offset:4095
// CHECK: [0xff,0x0f,0x94,0xe1,0x00,0x05,0x02,0x7f]

buffer_atomic_umin_x2 v[5:6], off, s[8:11], 0 offset:4095
// CHECK: [0xff,0x0f,0x94,0xe1,0x00,0x05,0x02,0x80]

buffer_atomic_umin_x2 v[5:6], off, s[8:11], -1 offset:4095
// CHECK: [0xff,0x0f,0x94,0xe1,0x00,0x05,0x02,0xc1]

buffer_atomic_umin_x2 v[5:6], off, s[8:11], 0.5 offset:4095
// CHECK: [0xff,0x0f,0x94,0xe1,0x00,0x05,0x02,0xf0]

buffer_atomic_umin_x2 v[5:6], off, s[8:11], -4.0 offset:4095
// CHECK: [0xff,0x0f,0x94,0xe1,0x00,0x05,0x02,0xf7]

buffer_atomic_umin_x2 v[5:6], off, s[8:11], src_vccz offset:4095
// CHECK: [0xff,0x0f,0x94,0xe1,0x00,0x05,0x02,0xfb]

buffer_atomic_umin_x2 v[5:6], off, s[8:11], src_execz offset:4095
// CHECK: [0xff,0x0f,0x94,0xe1,0x00,0x05,0x02,0xfc]

buffer_atomic_umin_x2 v[5:6], off, s[8:11], src_scc offset:4095
// CHECK: [0xff,0x0f,0x94,0xe1,0x00,0x05,0x02,0xfd]

buffer_atomic_umin_x2 v[5:6], v0, s[8:11], s3 idxen offset:4095
// CHECK: [0xff,0x2f,0x94,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_umin_x2 v[5:6], v0, s[8:11], s3 offen offset:4095
// CHECK: [0xff,0x1f,0x94,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_umin_x2 v[5:6], off, s[8:11], s3
// CHECK: [0x00,0x00,0x94,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_umin_x2 v[5:6], off, s[8:11], s3 offset:0
// CHECK: [0x00,0x00,0x94,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_umin_x2 v[5:6], off, s[8:11], s3 offset:7
// CHECK: [0x07,0x00,0x94,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_umin_x2 v[5:6], off, s[8:11], s3 offset:4095 glc
// CHECK: [0xff,0x4f,0x94,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_umin_x2 v[5:6], off, s[8:11], s3 offset:4095 slc
// CHECK: [0xff,0x0f,0x96,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_smax_x2 v[5:6], off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x98,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_smax_x2 v[254:255], off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x98,0xe1,0x00,0xfe,0x02,0x03]

buffer_atomic_smax_x2 v[5:6], off, s[12:15], s3 offset:4095
// CHECK: [0xff,0x0f,0x98,0xe1,0x00,0x05,0x03,0x03]

buffer_atomic_smax_x2 v[5:6], off, s[96:99], s3 offset:4095
// CHECK: [0xff,0x0f,0x98,0xe1,0x00,0x05,0x18,0x03]

buffer_atomic_smax_x2 v[5:6], off, ttmp[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x98,0xe1,0x00,0x05,0x1e,0x03]

buffer_atomic_smax_x2 v[5:6], off, s[8:11], s101 offset:4095
// CHECK: [0xff,0x0f,0x98,0xe1,0x00,0x05,0x02,0x65]

buffer_atomic_smax_x2 v[5:6], off, s[8:11], flat_scratch_lo offset:4095
// CHECK: [0xff,0x0f,0x98,0xe1,0x00,0x05,0x02,0x66]

buffer_atomic_smax_x2 v[5:6], off, s[8:11], flat_scratch_hi offset:4095
// CHECK: [0xff,0x0f,0x98,0xe1,0x00,0x05,0x02,0x67]

buffer_atomic_smax_x2 v[5:6], off, s[8:11], vcc_lo offset:4095
// CHECK: [0xff,0x0f,0x98,0xe1,0x00,0x05,0x02,0x6a]

buffer_atomic_smax_x2 v[5:6], off, s[8:11], vcc_hi offset:4095
// CHECK: [0xff,0x0f,0x98,0xe1,0x00,0x05,0x02,0x6b]

buffer_atomic_smax_x2 v[5:6], off, s[8:11], tba_lo offset:4095
// CHECK: [0xff,0x0f,0x98,0xe1,0x00,0x05,0x02,0x6c]

buffer_atomic_smax_x2 v[5:6], off, s[8:11], tba_hi offset:4095
// CHECK: [0xff,0x0f,0x98,0xe1,0x00,0x05,0x02,0x6d]

buffer_atomic_smax_x2 v[5:6], off, s[8:11], tma_lo offset:4095
// CHECK: [0xff,0x0f,0x98,0xe1,0x00,0x05,0x02,0x6e]

buffer_atomic_smax_x2 v[5:6], off, s[8:11], tma_hi offset:4095
// CHECK: [0xff,0x0f,0x98,0xe1,0x00,0x05,0x02,0x6f]

buffer_atomic_smax_x2 v[5:6], off, s[8:11], ttmp11 offset:4095
// CHECK: [0xff,0x0f,0x98,0xe1,0x00,0x05,0x02,0x7b]

buffer_atomic_smax_x2 v[5:6], off, s[8:11], m0 offset:4095
// CHECK: [0xff,0x0f,0x98,0xe1,0x00,0x05,0x02,0x7c]

buffer_atomic_smax_x2 v[5:6], off, s[8:11], exec_lo offset:4095
// CHECK: [0xff,0x0f,0x98,0xe1,0x00,0x05,0x02,0x7e]

buffer_atomic_smax_x2 v[5:6], off, s[8:11], exec_hi offset:4095
// CHECK: [0xff,0x0f,0x98,0xe1,0x00,0x05,0x02,0x7f]

buffer_atomic_smax_x2 v[5:6], off, s[8:11], 0 offset:4095
// CHECK: [0xff,0x0f,0x98,0xe1,0x00,0x05,0x02,0x80]

buffer_atomic_smax_x2 v[5:6], off, s[8:11], -1 offset:4095
// CHECK: [0xff,0x0f,0x98,0xe1,0x00,0x05,0x02,0xc1]

buffer_atomic_smax_x2 v[5:6], off, s[8:11], 0.5 offset:4095
// CHECK: [0xff,0x0f,0x98,0xe1,0x00,0x05,0x02,0xf0]

buffer_atomic_smax_x2 v[5:6], off, s[8:11], -4.0 offset:4095
// CHECK: [0xff,0x0f,0x98,0xe1,0x00,0x05,0x02,0xf7]

buffer_atomic_smax_x2 v[5:6], off, s[8:11], src_vccz offset:4095
// CHECK: [0xff,0x0f,0x98,0xe1,0x00,0x05,0x02,0xfb]

buffer_atomic_smax_x2 v[5:6], off, s[8:11], src_execz offset:4095
// CHECK: [0xff,0x0f,0x98,0xe1,0x00,0x05,0x02,0xfc]

buffer_atomic_smax_x2 v[5:6], off, s[8:11], src_scc offset:4095
// CHECK: [0xff,0x0f,0x98,0xe1,0x00,0x05,0x02,0xfd]

buffer_atomic_smax_x2 v[5:6], v0, s[8:11], s3 idxen offset:4095
// CHECK: [0xff,0x2f,0x98,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_smax_x2 v[5:6], v0, s[8:11], s3 offen offset:4095
// CHECK: [0xff,0x1f,0x98,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_smax_x2 v[5:6], off, s[8:11], s3
// CHECK: [0x00,0x00,0x98,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_smax_x2 v[5:6], off, s[8:11], s3 offset:0
// CHECK: [0x00,0x00,0x98,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_smax_x2 v[5:6], off, s[8:11], s3 offset:7
// CHECK: [0x07,0x00,0x98,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_smax_x2 v[5:6], off, s[8:11], s3 offset:4095 glc
// CHECK: [0xff,0x4f,0x98,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_smax_x2 v[5:6], off, s[8:11], s3 offset:4095 slc
// CHECK: [0xff,0x0f,0x9a,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_umax_x2 v[5:6], off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x9c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_umax_x2 v[254:255], off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x9c,0xe1,0x00,0xfe,0x02,0x03]

buffer_atomic_umax_x2 v[5:6], off, s[12:15], s3 offset:4095
// CHECK: [0xff,0x0f,0x9c,0xe1,0x00,0x05,0x03,0x03]

buffer_atomic_umax_x2 v[5:6], off, s[96:99], s3 offset:4095
// CHECK: [0xff,0x0f,0x9c,0xe1,0x00,0x05,0x18,0x03]

buffer_atomic_umax_x2 v[5:6], off, ttmp[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x9c,0xe1,0x00,0x05,0x1e,0x03]

buffer_atomic_umax_x2 v[5:6], off, s[8:11], s101 offset:4095
// CHECK: [0xff,0x0f,0x9c,0xe1,0x00,0x05,0x02,0x65]

buffer_atomic_umax_x2 v[5:6], off, s[8:11], flat_scratch_lo offset:4095
// CHECK: [0xff,0x0f,0x9c,0xe1,0x00,0x05,0x02,0x66]

buffer_atomic_umax_x2 v[5:6], off, s[8:11], flat_scratch_hi offset:4095
// CHECK: [0xff,0x0f,0x9c,0xe1,0x00,0x05,0x02,0x67]

buffer_atomic_umax_x2 v[5:6], off, s[8:11], vcc_lo offset:4095
// CHECK: [0xff,0x0f,0x9c,0xe1,0x00,0x05,0x02,0x6a]

buffer_atomic_umax_x2 v[5:6], off, s[8:11], vcc_hi offset:4095
// CHECK: [0xff,0x0f,0x9c,0xe1,0x00,0x05,0x02,0x6b]

buffer_atomic_umax_x2 v[5:6], off, s[8:11], tba_lo offset:4095
// CHECK: [0xff,0x0f,0x9c,0xe1,0x00,0x05,0x02,0x6c]

buffer_atomic_umax_x2 v[5:6], off, s[8:11], tba_hi offset:4095
// CHECK: [0xff,0x0f,0x9c,0xe1,0x00,0x05,0x02,0x6d]

buffer_atomic_umax_x2 v[5:6], off, s[8:11], tma_lo offset:4095
// CHECK: [0xff,0x0f,0x9c,0xe1,0x00,0x05,0x02,0x6e]

buffer_atomic_umax_x2 v[5:6], off, s[8:11], tma_hi offset:4095
// CHECK: [0xff,0x0f,0x9c,0xe1,0x00,0x05,0x02,0x6f]

buffer_atomic_umax_x2 v[5:6], off, s[8:11], ttmp11 offset:4095
// CHECK: [0xff,0x0f,0x9c,0xe1,0x00,0x05,0x02,0x7b]

buffer_atomic_umax_x2 v[5:6], off, s[8:11], m0 offset:4095
// CHECK: [0xff,0x0f,0x9c,0xe1,0x00,0x05,0x02,0x7c]

buffer_atomic_umax_x2 v[5:6], off, s[8:11], exec_lo offset:4095
// CHECK: [0xff,0x0f,0x9c,0xe1,0x00,0x05,0x02,0x7e]

buffer_atomic_umax_x2 v[5:6], off, s[8:11], exec_hi offset:4095
// CHECK: [0xff,0x0f,0x9c,0xe1,0x00,0x05,0x02,0x7f]

buffer_atomic_umax_x2 v[5:6], off, s[8:11], 0 offset:4095
// CHECK: [0xff,0x0f,0x9c,0xe1,0x00,0x05,0x02,0x80]

buffer_atomic_umax_x2 v[5:6], off, s[8:11], -1 offset:4095
// CHECK: [0xff,0x0f,0x9c,0xe1,0x00,0x05,0x02,0xc1]

buffer_atomic_umax_x2 v[5:6], off, s[8:11], 0.5 offset:4095
// CHECK: [0xff,0x0f,0x9c,0xe1,0x00,0x05,0x02,0xf0]

buffer_atomic_umax_x2 v[5:6], off, s[8:11], -4.0 offset:4095
// CHECK: [0xff,0x0f,0x9c,0xe1,0x00,0x05,0x02,0xf7]

buffer_atomic_umax_x2 v[5:6], off, s[8:11], src_vccz offset:4095
// CHECK: [0xff,0x0f,0x9c,0xe1,0x00,0x05,0x02,0xfb]

buffer_atomic_umax_x2 v[5:6], off, s[8:11], src_execz offset:4095
// CHECK: [0xff,0x0f,0x9c,0xe1,0x00,0x05,0x02,0xfc]

buffer_atomic_umax_x2 v[5:6], off, s[8:11], src_scc offset:4095
// CHECK: [0xff,0x0f,0x9c,0xe1,0x00,0x05,0x02,0xfd]

buffer_atomic_umax_x2 v[5:6], v0, s[8:11], s3 idxen offset:4095
// CHECK: [0xff,0x2f,0x9c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_umax_x2 v[5:6], v0, s[8:11], s3 offen offset:4095
// CHECK: [0xff,0x1f,0x9c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_umax_x2 v[5:6], off, s[8:11], s3
// CHECK: [0x00,0x00,0x9c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_umax_x2 v[5:6], off, s[8:11], s3 offset:0
// CHECK: [0x00,0x00,0x9c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_umax_x2 v[5:6], off, s[8:11], s3 offset:7
// CHECK: [0x07,0x00,0x9c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_umax_x2 v[5:6], off, s[8:11], s3 offset:4095 glc
// CHECK: [0xff,0x4f,0x9c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_umax_x2 v[5:6], off, s[8:11], s3 offset:4095 slc
// CHECK: [0xff,0x0f,0x9e,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_and_x2 v[5:6], off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0xa0,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_and_x2 v[254:255], off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0xa0,0xe1,0x00,0xfe,0x02,0x03]

buffer_atomic_and_x2 v[5:6], off, s[12:15], s3 offset:4095
// CHECK: [0xff,0x0f,0xa0,0xe1,0x00,0x05,0x03,0x03]

buffer_atomic_and_x2 v[5:6], off, s[96:99], s3 offset:4095
// CHECK: [0xff,0x0f,0xa0,0xe1,0x00,0x05,0x18,0x03]

buffer_atomic_and_x2 v[5:6], off, ttmp[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0xa0,0xe1,0x00,0x05,0x1e,0x03]

buffer_atomic_and_x2 v[5:6], off, s[8:11], s101 offset:4095
// CHECK: [0xff,0x0f,0xa0,0xe1,0x00,0x05,0x02,0x65]

buffer_atomic_and_x2 v[5:6], off, s[8:11], flat_scratch_lo offset:4095
// CHECK: [0xff,0x0f,0xa0,0xe1,0x00,0x05,0x02,0x66]

buffer_atomic_and_x2 v[5:6], off, s[8:11], flat_scratch_hi offset:4095
// CHECK: [0xff,0x0f,0xa0,0xe1,0x00,0x05,0x02,0x67]

buffer_atomic_and_x2 v[5:6], off, s[8:11], vcc_lo offset:4095
// CHECK: [0xff,0x0f,0xa0,0xe1,0x00,0x05,0x02,0x6a]

buffer_atomic_and_x2 v[5:6], off, s[8:11], vcc_hi offset:4095
// CHECK: [0xff,0x0f,0xa0,0xe1,0x00,0x05,0x02,0x6b]

buffer_atomic_and_x2 v[5:6], off, s[8:11], tba_lo offset:4095
// CHECK: [0xff,0x0f,0xa0,0xe1,0x00,0x05,0x02,0x6c]

buffer_atomic_and_x2 v[5:6], off, s[8:11], tba_hi offset:4095
// CHECK: [0xff,0x0f,0xa0,0xe1,0x00,0x05,0x02,0x6d]

buffer_atomic_and_x2 v[5:6], off, s[8:11], tma_lo offset:4095
// CHECK: [0xff,0x0f,0xa0,0xe1,0x00,0x05,0x02,0x6e]

buffer_atomic_and_x2 v[5:6], off, s[8:11], tma_hi offset:4095
// CHECK: [0xff,0x0f,0xa0,0xe1,0x00,0x05,0x02,0x6f]

buffer_atomic_and_x2 v[5:6], off, s[8:11], ttmp11 offset:4095
// CHECK: [0xff,0x0f,0xa0,0xe1,0x00,0x05,0x02,0x7b]

buffer_atomic_and_x2 v[5:6], off, s[8:11], m0 offset:4095
// CHECK: [0xff,0x0f,0xa0,0xe1,0x00,0x05,0x02,0x7c]

buffer_atomic_and_x2 v[5:6], off, s[8:11], exec_lo offset:4095
// CHECK: [0xff,0x0f,0xa0,0xe1,0x00,0x05,0x02,0x7e]

buffer_atomic_and_x2 v[5:6], off, s[8:11], exec_hi offset:4095
// CHECK: [0xff,0x0f,0xa0,0xe1,0x00,0x05,0x02,0x7f]

buffer_atomic_and_x2 v[5:6], off, s[8:11], 0 offset:4095
// CHECK: [0xff,0x0f,0xa0,0xe1,0x00,0x05,0x02,0x80]

buffer_atomic_and_x2 v[5:6], off, s[8:11], -1 offset:4095
// CHECK: [0xff,0x0f,0xa0,0xe1,0x00,0x05,0x02,0xc1]

buffer_atomic_and_x2 v[5:6], off, s[8:11], 0.5 offset:4095
// CHECK: [0xff,0x0f,0xa0,0xe1,0x00,0x05,0x02,0xf0]

buffer_atomic_and_x2 v[5:6], off, s[8:11], -4.0 offset:4095
// CHECK: [0xff,0x0f,0xa0,0xe1,0x00,0x05,0x02,0xf7]

buffer_atomic_and_x2 v[5:6], off, s[8:11], src_vccz offset:4095
// CHECK: [0xff,0x0f,0xa0,0xe1,0x00,0x05,0x02,0xfb]

buffer_atomic_and_x2 v[5:6], off, s[8:11], src_execz offset:4095
// CHECK: [0xff,0x0f,0xa0,0xe1,0x00,0x05,0x02,0xfc]

buffer_atomic_and_x2 v[5:6], off, s[8:11], src_scc offset:4095
// CHECK: [0xff,0x0f,0xa0,0xe1,0x00,0x05,0x02,0xfd]

buffer_atomic_and_x2 v[5:6], v0, s[8:11], s3 idxen offset:4095
// CHECK: [0xff,0x2f,0xa0,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_and_x2 v[5:6], v0, s[8:11], s3 offen offset:4095
// CHECK: [0xff,0x1f,0xa0,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_and_x2 v[5:6], off, s[8:11], s3
// CHECK: [0x00,0x00,0xa0,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_and_x2 v[5:6], off, s[8:11], s3 offset:0
// CHECK: [0x00,0x00,0xa0,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_and_x2 v[5:6], off, s[8:11], s3 offset:7
// CHECK: [0x07,0x00,0xa0,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_and_x2 v[5:6], off, s[8:11], s3 offset:4095 glc
// CHECK: [0xff,0x4f,0xa0,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_and_x2 v[5:6], off, s[8:11], s3 offset:4095 slc
// CHECK: [0xff,0x0f,0xa2,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_or_x2 v[5:6], off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0xa4,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_or_x2 v[254:255], off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0xa4,0xe1,0x00,0xfe,0x02,0x03]

buffer_atomic_or_x2 v[5:6], off, s[12:15], s3 offset:4095
// CHECK: [0xff,0x0f,0xa4,0xe1,0x00,0x05,0x03,0x03]

buffer_atomic_or_x2 v[5:6], off, s[96:99], s3 offset:4095
// CHECK: [0xff,0x0f,0xa4,0xe1,0x00,0x05,0x18,0x03]

buffer_atomic_or_x2 v[5:6], off, ttmp[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0xa4,0xe1,0x00,0x05,0x1e,0x03]

buffer_atomic_or_x2 v[5:6], off, s[8:11], s101 offset:4095
// CHECK: [0xff,0x0f,0xa4,0xe1,0x00,0x05,0x02,0x65]

buffer_atomic_or_x2 v[5:6], off, s[8:11], flat_scratch_lo offset:4095
// CHECK: [0xff,0x0f,0xa4,0xe1,0x00,0x05,0x02,0x66]

buffer_atomic_or_x2 v[5:6], off, s[8:11], flat_scratch_hi offset:4095
// CHECK: [0xff,0x0f,0xa4,0xe1,0x00,0x05,0x02,0x67]

buffer_atomic_or_x2 v[5:6], off, s[8:11], vcc_lo offset:4095
// CHECK: [0xff,0x0f,0xa4,0xe1,0x00,0x05,0x02,0x6a]

buffer_atomic_or_x2 v[5:6], off, s[8:11], vcc_hi offset:4095
// CHECK: [0xff,0x0f,0xa4,0xe1,0x00,0x05,0x02,0x6b]

buffer_atomic_or_x2 v[5:6], off, s[8:11], tba_lo offset:4095
// CHECK: [0xff,0x0f,0xa4,0xe1,0x00,0x05,0x02,0x6c]

buffer_atomic_or_x2 v[5:6], off, s[8:11], tba_hi offset:4095
// CHECK: [0xff,0x0f,0xa4,0xe1,0x00,0x05,0x02,0x6d]

buffer_atomic_or_x2 v[5:6], off, s[8:11], tma_lo offset:4095
// CHECK: [0xff,0x0f,0xa4,0xe1,0x00,0x05,0x02,0x6e]

buffer_atomic_or_x2 v[5:6], off, s[8:11], tma_hi offset:4095
// CHECK: [0xff,0x0f,0xa4,0xe1,0x00,0x05,0x02,0x6f]

buffer_atomic_or_x2 v[5:6], off, s[8:11], ttmp11 offset:4095
// CHECK: [0xff,0x0f,0xa4,0xe1,0x00,0x05,0x02,0x7b]

buffer_atomic_or_x2 v[5:6], off, s[8:11], m0 offset:4095
// CHECK: [0xff,0x0f,0xa4,0xe1,0x00,0x05,0x02,0x7c]

buffer_atomic_or_x2 v[5:6], off, s[8:11], exec_lo offset:4095
// CHECK: [0xff,0x0f,0xa4,0xe1,0x00,0x05,0x02,0x7e]

buffer_atomic_or_x2 v[5:6], off, s[8:11], exec_hi offset:4095
// CHECK: [0xff,0x0f,0xa4,0xe1,0x00,0x05,0x02,0x7f]

buffer_atomic_or_x2 v[5:6], off, s[8:11], 0 offset:4095
// CHECK: [0xff,0x0f,0xa4,0xe1,0x00,0x05,0x02,0x80]

buffer_atomic_or_x2 v[5:6], off, s[8:11], -1 offset:4095
// CHECK: [0xff,0x0f,0xa4,0xe1,0x00,0x05,0x02,0xc1]

buffer_atomic_or_x2 v[5:6], off, s[8:11], 0.5 offset:4095
// CHECK: [0xff,0x0f,0xa4,0xe1,0x00,0x05,0x02,0xf0]

buffer_atomic_or_x2 v[5:6], off, s[8:11], -4.0 offset:4095
// CHECK: [0xff,0x0f,0xa4,0xe1,0x00,0x05,0x02,0xf7]

buffer_atomic_or_x2 v[5:6], off, s[8:11], src_vccz offset:4095
// CHECK: [0xff,0x0f,0xa4,0xe1,0x00,0x05,0x02,0xfb]

buffer_atomic_or_x2 v[5:6], off, s[8:11], src_execz offset:4095
// CHECK: [0xff,0x0f,0xa4,0xe1,0x00,0x05,0x02,0xfc]

buffer_atomic_or_x2 v[5:6], off, s[8:11], src_scc offset:4095
// CHECK: [0xff,0x0f,0xa4,0xe1,0x00,0x05,0x02,0xfd]

buffer_atomic_or_x2 v[5:6], v0, s[8:11], s3 idxen offset:4095
// CHECK: [0xff,0x2f,0xa4,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_or_x2 v[5:6], v0, s[8:11], s3 offen offset:4095
// CHECK: [0xff,0x1f,0xa4,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_or_x2 v[5:6], off, s[8:11], s3
// CHECK: [0x00,0x00,0xa4,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_or_x2 v[5:6], off, s[8:11], s3 offset:0
// CHECK: [0x00,0x00,0xa4,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_or_x2 v[5:6], off, s[8:11], s3 offset:7
// CHECK: [0x07,0x00,0xa4,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_or_x2 v[5:6], off, s[8:11], s3 offset:4095 glc
// CHECK: [0xff,0x4f,0xa4,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_or_x2 v[5:6], off, s[8:11], s3 offset:4095 slc
// CHECK: [0xff,0x0f,0xa6,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_xor_x2 v[5:6], off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0xa8,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_xor_x2 v[254:255], off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0xa8,0xe1,0x00,0xfe,0x02,0x03]

buffer_atomic_xor_x2 v[5:6], off, s[12:15], s3 offset:4095
// CHECK: [0xff,0x0f,0xa8,0xe1,0x00,0x05,0x03,0x03]

buffer_atomic_xor_x2 v[5:6], off, s[96:99], s3 offset:4095
// CHECK: [0xff,0x0f,0xa8,0xe1,0x00,0x05,0x18,0x03]

buffer_atomic_xor_x2 v[5:6], off, ttmp[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0xa8,0xe1,0x00,0x05,0x1e,0x03]

buffer_atomic_xor_x2 v[5:6], off, s[8:11], s101 offset:4095
// CHECK: [0xff,0x0f,0xa8,0xe1,0x00,0x05,0x02,0x65]

buffer_atomic_xor_x2 v[5:6], off, s[8:11], flat_scratch_lo offset:4095
// CHECK: [0xff,0x0f,0xa8,0xe1,0x00,0x05,0x02,0x66]

buffer_atomic_xor_x2 v[5:6], off, s[8:11], flat_scratch_hi offset:4095
// CHECK: [0xff,0x0f,0xa8,0xe1,0x00,0x05,0x02,0x67]

buffer_atomic_xor_x2 v[5:6], off, s[8:11], vcc_lo offset:4095
// CHECK: [0xff,0x0f,0xa8,0xe1,0x00,0x05,0x02,0x6a]

buffer_atomic_xor_x2 v[5:6], off, s[8:11], vcc_hi offset:4095
// CHECK: [0xff,0x0f,0xa8,0xe1,0x00,0x05,0x02,0x6b]

buffer_atomic_xor_x2 v[5:6], off, s[8:11], tba_lo offset:4095
// CHECK: [0xff,0x0f,0xa8,0xe1,0x00,0x05,0x02,0x6c]

buffer_atomic_xor_x2 v[5:6], off, s[8:11], tba_hi offset:4095
// CHECK: [0xff,0x0f,0xa8,0xe1,0x00,0x05,0x02,0x6d]

buffer_atomic_xor_x2 v[5:6], off, s[8:11], tma_lo offset:4095
// CHECK: [0xff,0x0f,0xa8,0xe1,0x00,0x05,0x02,0x6e]

buffer_atomic_xor_x2 v[5:6], off, s[8:11], tma_hi offset:4095
// CHECK: [0xff,0x0f,0xa8,0xe1,0x00,0x05,0x02,0x6f]

buffer_atomic_xor_x2 v[5:6], off, s[8:11], ttmp11 offset:4095
// CHECK: [0xff,0x0f,0xa8,0xe1,0x00,0x05,0x02,0x7b]

buffer_atomic_xor_x2 v[5:6], off, s[8:11], m0 offset:4095
// CHECK: [0xff,0x0f,0xa8,0xe1,0x00,0x05,0x02,0x7c]

buffer_atomic_xor_x2 v[5:6], off, s[8:11], exec_lo offset:4095
// CHECK: [0xff,0x0f,0xa8,0xe1,0x00,0x05,0x02,0x7e]

buffer_atomic_xor_x2 v[5:6], off, s[8:11], exec_hi offset:4095
// CHECK: [0xff,0x0f,0xa8,0xe1,0x00,0x05,0x02,0x7f]

buffer_atomic_xor_x2 v[5:6], off, s[8:11], 0 offset:4095
// CHECK: [0xff,0x0f,0xa8,0xe1,0x00,0x05,0x02,0x80]

buffer_atomic_xor_x2 v[5:6], off, s[8:11], -1 offset:4095
// CHECK: [0xff,0x0f,0xa8,0xe1,0x00,0x05,0x02,0xc1]

buffer_atomic_xor_x2 v[5:6], off, s[8:11], 0.5 offset:4095
// CHECK: [0xff,0x0f,0xa8,0xe1,0x00,0x05,0x02,0xf0]

buffer_atomic_xor_x2 v[5:6], off, s[8:11], -4.0 offset:4095
// CHECK: [0xff,0x0f,0xa8,0xe1,0x00,0x05,0x02,0xf7]

buffer_atomic_xor_x2 v[5:6], off, s[8:11], src_vccz offset:4095
// CHECK: [0xff,0x0f,0xa8,0xe1,0x00,0x05,0x02,0xfb]

buffer_atomic_xor_x2 v[5:6], off, s[8:11], src_execz offset:4095
// CHECK: [0xff,0x0f,0xa8,0xe1,0x00,0x05,0x02,0xfc]

buffer_atomic_xor_x2 v[5:6], off, s[8:11], src_scc offset:4095
// CHECK: [0xff,0x0f,0xa8,0xe1,0x00,0x05,0x02,0xfd]

buffer_atomic_xor_x2 v[5:6], v0, s[8:11], s3 idxen offset:4095
// CHECK: [0xff,0x2f,0xa8,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_xor_x2 v[5:6], v0, s[8:11], s3 offen offset:4095
// CHECK: [0xff,0x1f,0xa8,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_xor_x2 v[5:6], off, s[8:11], s3
// CHECK: [0x00,0x00,0xa8,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_xor_x2 v[5:6], off, s[8:11], s3 offset:0
// CHECK: [0x00,0x00,0xa8,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_xor_x2 v[5:6], off, s[8:11], s3 offset:7
// CHECK: [0x07,0x00,0xa8,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_xor_x2 v[5:6], off, s[8:11], s3 offset:4095 glc
// CHECK: [0xff,0x4f,0xa8,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_xor_x2 v[5:6], off, s[8:11], s3 offset:4095 slc
// CHECK: [0xff,0x0f,0xaa,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_inc_x2 v[5:6], off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0xac,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_inc_x2 v[254:255], off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0xac,0xe1,0x00,0xfe,0x02,0x03]

buffer_atomic_inc_x2 v[5:6], off, s[12:15], s3 offset:4095
// CHECK: [0xff,0x0f,0xac,0xe1,0x00,0x05,0x03,0x03]

buffer_atomic_inc_x2 v[5:6], off, s[96:99], s3 offset:4095
// CHECK: [0xff,0x0f,0xac,0xe1,0x00,0x05,0x18,0x03]

buffer_atomic_inc_x2 v[5:6], off, ttmp[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0xac,0xe1,0x00,0x05,0x1e,0x03]

buffer_atomic_inc_x2 v[5:6], off, s[8:11], s101 offset:4095
// CHECK: [0xff,0x0f,0xac,0xe1,0x00,0x05,0x02,0x65]

buffer_atomic_inc_x2 v[5:6], off, s[8:11], flat_scratch_lo offset:4095
// CHECK: [0xff,0x0f,0xac,0xe1,0x00,0x05,0x02,0x66]

buffer_atomic_inc_x2 v[5:6], off, s[8:11], flat_scratch_hi offset:4095
// CHECK: [0xff,0x0f,0xac,0xe1,0x00,0x05,0x02,0x67]

buffer_atomic_inc_x2 v[5:6], off, s[8:11], vcc_lo offset:4095
// CHECK: [0xff,0x0f,0xac,0xe1,0x00,0x05,0x02,0x6a]

buffer_atomic_inc_x2 v[5:6], off, s[8:11], vcc_hi offset:4095
// CHECK: [0xff,0x0f,0xac,0xe1,0x00,0x05,0x02,0x6b]

buffer_atomic_inc_x2 v[5:6], off, s[8:11], tba_lo offset:4095
// CHECK: [0xff,0x0f,0xac,0xe1,0x00,0x05,0x02,0x6c]

buffer_atomic_inc_x2 v[5:6], off, s[8:11], tba_hi offset:4095
// CHECK: [0xff,0x0f,0xac,0xe1,0x00,0x05,0x02,0x6d]

buffer_atomic_inc_x2 v[5:6], off, s[8:11], tma_lo offset:4095
// CHECK: [0xff,0x0f,0xac,0xe1,0x00,0x05,0x02,0x6e]

buffer_atomic_inc_x2 v[5:6], off, s[8:11], tma_hi offset:4095
// CHECK: [0xff,0x0f,0xac,0xe1,0x00,0x05,0x02,0x6f]

buffer_atomic_inc_x2 v[5:6], off, s[8:11], ttmp11 offset:4095
// CHECK: [0xff,0x0f,0xac,0xe1,0x00,0x05,0x02,0x7b]

buffer_atomic_inc_x2 v[5:6], off, s[8:11], m0 offset:4095
// CHECK: [0xff,0x0f,0xac,0xe1,0x00,0x05,0x02,0x7c]

buffer_atomic_inc_x2 v[5:6], off, s[8:11], exec_lo offset:4095
// CHECK: [0xff,0x0f,0xac,0xe1,0x00,0x05,0x02,0x7e]

buffer_atomic_inc_x2 v[5:6], off, s[8:11], exec_hi offset:4095
// CHECK: [0xff,0x0f,0xac,0xe1,0x00,0x05,0x02,0x7f]

buffer_atomic_inc_x2 v[5:6], off, s[8:11], 0 offset:4095
// CHECK: [0xff,0x0f,0xac,0xe1,0x00,0x05,0x02,0x80]

buffer_atomic_inc_x2 v[5:6], off, s[8:11], -1 offset:4095
// CHECK: [0xff,0x0f,0xac,0xe1,0x00,0x05,0x02,0xc1]

buffer_atomic_inc_x2 v[5:6], off, s[8:11], 0.5 offset:4095
// CHECK: [0xff,0x0f,0xac,0xe1,0x00,0x05,0x02,0xf0]

buffer_atomic_inc_x2 v[5:6], off, s[8:11], -4.0 offset:4095
// CHECK: [0xff,0x0f,0xac,0xe1,0x00,0x05,0x02,0xf7]

buffer_atomic_inc_x2 v[5:6], off, s[8:11], src_vccz offset:4095
// CHECK: [0xff,0x0f,0xac,0xe1,0x00,0x05,0x02,0xfb]

buffer_atomic_inc_x2 v[5:6], off, s[8:11], src_execz offset:4095
// CHECK: [0xff,0x0f,0xac,0xe1,0x00,0x05,0x02,0xfc]

buffer_atomic_inc_x2 v[5:6], off, s[8:11], src_scc offset:4095
// CHECK: [0xff,0x0f,0xac,0xe1,0x00,0x05,0x02,0xfd]

buffer_atomic_inc_x2 v[5:6], v0, s[8:11], s3 idxen offset:4095
// CHECK: [0xff,0x2f,0xac,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_inc_x2 v[5:6], v0, s[8:11], s3 offen offset:4095
// CHECK: [0xff,0x1f,0xac,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_inc_x2 v[5:6], off, s[8:11], s3
// CHECK: [0x00,0x00,0xac,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_inc_x2 v[5:6], off, s[8:11], s3 offset:0
// CHECK: [0x00,0x00,0xac,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_inc_x2 v[5:6], off, s[8:11], s3 offset:7
// CHECK: [0x07,0x00,0xac,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_inc_x2 v[5:6], off, s[8:11], s3 offset:4095 glc
// CHECK: [0xff,0x4f,0xac,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_inc_x2 v[5:6], off, s[8:11], s3 offset:4095 slc
// CHECK: [0xff,0x0f,0xae,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_dec_x2 v[5:6], off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0xb0,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_dec_x2 v[254:255], off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0xb0,0xe1,0x00,0xfe,0x02,0x03]

buffer_atomic_dec_x2 v[5:6], off, s[12:15], s3 offset:4095
// CHECK: [0xff,0x0f,0xb0,0xe1,0x00,0x05,0x03,0x03]

buffer_atomic_dec_x2 v[5:6], off, s[96:99], s3 offset:4095
// CHECK: [0xff,0x0f,0xb0,0xe1,0x00,0x05,0x18,0x03]

buffer_atomic_dec_x2 v[5:6], off, ttmp[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0xb0,0xe1,0x00,0x05,0x1e,0x03]

buffer_atomic_dec_x2 v[5:6], off, s[8:11], s101 offset:4095
// CHECK: [0xff,0x0f,0xb0,0xe1,0x00,0x05,0x02,0x65]

buffer_atomic_dec_x2 v[5:6], off, s[8:11], flat_scratch_lo offset:4095
// CHECK: [0xff,0x0f,0xb0,0xe1,0x00,0x05,0x02,0x66]

buffer_atomic_dec_x2 v[5:6], off, s[8:11], flat_scratch_hi offset:4095
// CHECK: [0xff,0x0f,0xb0,0xe1,0x00,0x05,0x02,0x67]

buffer_atomic_dec_x2 v[5:6], off, s[8:11], vcc_lo offset:4095
// CHECK: [0xff,0x0f,0xb0,0xe1,0x00,0x05,0x02,0x6a]

buffer_atomic_dec_x2 v[5:6], off, s[8:11], vcc_hi offset:4095
// CHECK: [0xff,0x0f,0xb0,0xe1,0x00,0x05,0x02,0x6b]

buffer_atomic_dec_x2 v[5:6], off, s[8:11], tba_lo offset:4095
// CHECK: [0xff,0x0f,0xb0,0xe1,0x00,0x05,0x02,0x6c]

buffer_atomic_dec_x2 v[5:6], off, s[8:11], tba_hi offset:4095
// CHECK: [0xff,0x0f,0xb0,0xe1,0x00,0x05,0x02,0x6d]

buffer_atomic_dec_x2 v[5:6], off, s[8:11], tma_lo offset:4095
// CHECK: [0xff,0x0f,0xb0,0xe1,0x00,0x05,0x02,0x6e]

buffer_atomic_dec_x2 v[5:6], off, s[8:11], tma_hi offset:4095
// CHECK: [0xff,0x0f,0xb0,0xe1,0x00,0x05,0x02,0x6f]

buffer_atomic_dec_x2 v[5:6], off, s[8:11], ttmp11 offset:4095
// CHECK: [0xff,0x0f,0xb0,0xe1,0x00,0x05,0x02,0x7b]

buffer_atomic_dec_x2 v[5:6], off, s[8:11], m0 offset:4095
// CHECK: [0xff,0x0f,0xb0,0xe1,0x00,0x05,0x02,0x7c]

buffer_atomic_dec_x2 v[5:6], off, s[8:11], exec_lo offset:4095
// CHECK: [0xff,0x0f,0xb0,0xe1,0x00,0x05,0x02,0x7e]

buffer_atomic_dec_x2 v[5:6], off, s[8:11], exec_hi offset:4095
// CHECK: [0xff,0x0f,0xb0,0xe1,0x00,0x05,0x02,0x7f]

buffer_atomic_dec_x2 v[5:6], off, s[8:11], 0 offset:4095
// CHECK: [0xff,0x0f,0xb0,0xe1,0x00,0x05,0x02,0x80]

buffer_atomic_dec_x2 v[5:6], off, s[8:11], -1 offset:4095
// CHECK: [0xff,0x0f,0xb0,0xe1,0x00,0x05,0x02,0xc1]

buffer_atomic_dec_x2 v[5:6], off, s[8:11], 0.5 offset:4095
// CHECK: [0xff,0x0f,0xb0,0xe1,0x00,0x05,0x02,0xf0]

buffer_atomic_dec_x2 v[5:6], off, s[8:11], -4.0 offset:4095
// CHECK: [0xff,0x0f,0xb0,0xe1,0x00,0x05,0x02,0xf7]

buffer_atomic_dec_x2 v[5:6], off, s[8:11], src_vccz offset:4095
// CHECK: [0xff,0x0f,0xb0,0xe1,0x00,0x05,0x02,0xfb]

buffer_atomic_dec_x2 v[5:6], off, s[8:11], src_execz offset:4095
// CHECK: [0xff,0x0f,0xb0,0xe1,0x00,0x05,0x02,0xfc]

buffer_atomic_dec_x2 v[5:6], off, s[8:11], src_scc offset:4095
// CHECK: [0xff,0x0f,0xb0,0xe1,0x00,0x05,0x02,0xfd]

buffer_atomic_dec_x2 v[5:6], v0, s[8:11], s3 idxen offset:4095
// CHECK: [0xff,0x2f,0xb0,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_dec_x2 v[5:6], v0, s[8:11], s3 offen offset:4095
// CHECK: [0xff,0x1f,0xb0,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_dec_x2 v[5:6], off, s[8:11], s3
// CHECK: [0x00,0x00,0xb0,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_dec_x2 v[5:6], off, s[8:11], s3 offset:0
// CHECK: [0x00,0x00,0xb0,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_dec_x2 v[5:6], off, s[8:11], s3 offset:7
// CHECK: [0x07,0x00,0xb0,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_dec_x2 v[5:6], off, s[8:11], s3 offset:4095 glc
// CHECK: [0xff,0x4f,0xb0,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_dec_x2 v[5:6], off, s[8:11], s3 offset:4095 slc
// CHECK: [0xff,0x0f,0xb2,0xe1,0x00,0x05,0x02,0x03]
