with Ada.Text_IO; use Ada.Text_IO;
with GNATCOLL.Email.Mailboxes; use GNATCOLL.Email, GNATCOLL.Email.Mailboxes;
with GNATCOLL.VFS; use GNATCOLL.VFS;

procedure Dump_Box is
   Box : Mbox;
   Msg : Message;
begin
   Open (Box, Create (+"comment"));
   declare
      Curs : Cursor'Class := First (Box);
   begin
      while Has_Element (Curs) loop
         Get_Message (Curs, Box, Msg);
         if Msg = Null_Message then
            Put_Line ("NULL message???");
         else
            Put_Line (To_String (Get_Header (Msg, "message-id")));
         end if;
         Next (Curs, Box);
      end loop;
   end;
end Dump_Box;

