//start of PreLh2Decoder.java
//TEXT_STYLE:CODE=Shift_JIS(Japanese):RET_CODE=CRLF

/**
 * PreLh2Decoder.java
 * 
 * Copyright (C) 2002  Michel Ishizuka  All rights reserved.
 * 
 * ȉ̏ɓӂȂ΃\[XƃoCi`̍ĔzzƎgp
 * ύX̗Lɂ炸B
 * 
 * PD\[XR[h̍ĔzzɂĒ쌠\ ̏̃Xg
 *     щL̐ێȂĂ͂ȂȂB
 * 
 * QDoCi`̍ĔzzɂĒ쌠\ ̏̃Xg
 *     щL̐gp ̑̔zz
 *     ܂ގɋLqȂ΂ȂȂB
 * 
 * ̃\tgEFA͐Β˔ڂɂĖۏ؂Œ񋟂A̖
 * IBłƂۏ؁AilLƂۏ؂ɂƂǂ܂炸A
 * Ȃ閾IшÎIȕۏ؂ȂB
 * Β˔ڂ ̃\tgEFA̎gpɂ钼ړIAԐړIA
 * IAȁAT^IȁA邢͕KRIȑQ(gpɂf[^
 * AƖ̒f〈܂Ăv̈⎸A֐i
 * T[rX̓l邪AĂꂾɌ肳Ȃ
 * Q)ɑ΂āAȂ鎖Ԃ̌ƂȂƂĂA_̐
 * C△ߎӔC܂ ȂӔC낤ƂAƂꂪs
 * ŝׂ߂łƂĂA܂͂̂悤ȑQ̉\
 * ĂƂĂ؂̐ӔC𕉂Ȃ̂ƂB
 */

package jp.gr.java_conf.dangan.util.lha;

//import classes and interfaces
import java.io.InputStream;
import java.lang.Math;
import jp.gr.java_conf.dangan.io.BitInputStream;
import jp.gr.java_conf.dangan.util.lha.PreLzssDecoder;
import jp.gr.java_conf.dangan.util.lha.DynamicHuffman;

//import exceptions
import java.io.IOException;
import java.io.EOFException;
import java.lang.NullPointerException;
import jp.gr.java_conf.dangan.io.BitDataBrokenException;


/**
 * -lh2- 𓀗p PreLzssDecoderB<br>
 * 
 * <pre>
 * -- revision history --
 * $Log: PreLh2Decoder.java,v $
 * Revision 1.1  2002/12/06 00:00:00  dangan
 * [maintenance]
 *     \[X
 *
 * Revision 1.0  2002/08/05 00:00:00  dangan
 * [bug fix]
 *     available() ̌vZÂ̂CB
 * [maintenance]
 *     \[X
 *
 * </pre>
 * 
 * @author  $Author: dangan $
 * @version $Revision: 1.1 $
 */
public class PreLh2Decoder implements PreLzssDecoder{


    //------------------------------------------------------------------
    //  class field
    //------------------------------------------------------------------
    //  LZSS parameter
    //------------------------------------------------------------------
    //  private static final int DictionarySize
    //  private static final int MaxMatch
    //  private static final int Threshold
    //------------------------------------------------------------------
    /** TCY */
    private static final int DictionarySize = 8192;

    /** őv */
    private static final int MaxMatch       = 256;

    /** ŏv */
    private static final int Threshold      = 3;


    //------------------------------------------------------------------
    //  class field
    //------------------------------------------------------------------
    //  private static final int CodeSize
    //------------------------------------------------------------------
    /**
     * codẽnt}؂̃TCY 
     * codeȏ̒lꍇ͗]vȃrbgo͂ĕ₤B
     */
    private static final int CodeSize = 286;


    //------------------------------------------------------------------
    //  instance field
    //------------------------------------------------------------------
    //  source
    //------------------------------------------------------------------
    //  private BitInputStream
    //------------------------------------------------------------------
    /**
     * -lh2- ̈kf[^ BitInputStream
     */
     private BitInputStream in;


    //------------------------------------------------------------------
    //  instance field
    //------------------------------------------------------------------
    //  huffman tree
    //------------------------------------------------------------------
    //  private DynamicHuffman codeHuffman
    //  private DynamicHuffman offHiHuffman
    //------------------------------------------------------------------
    /**
     * Lzss񈳏kf[^ 1byte  LzsskR[ĥv
     * 邽߂ Int}
     */
    private DynamicHuffman codeHuffman;

    /**
     * LzsskR[h̏7bit̒l𓾂邽߂̓Int}
     */
    private DynamicHuffman offHiHuffman;


    //------------------------------------------------------------------
    //  instance field
    //------------------------------------------------------------------
    //  current position
    //------------------------------------------------------------------
    //  private int position
    //  private int nextPosition
    //  private int matchLength
    //------------------------------------------------------------------
    /**
     * (𓀌̃f[^)ݏʒu
     */
    private int position;

    /**
     *  addLeaf() ׂ position
     */
    private int nextPosition;

    /**
     * v
     */
    private int matchLength;


    //------------------------------------------------------------------
    //  instance field
    //------------------------------------------------------------------
    //  backup for mark method
    //------------------------------------------------------------------
    //  private DynamicHuffman markCodeHuffman
    //  private DynamicHuffman markOffHiHuffman
    //  private int markPosition
    //  private int markNextPosition
    //  private int markMatchLength
    //------------------------------------------------------------------
    /** codeHuffman ̃obNAbvp */
    private DynamicHuffman markCodeHuffman;

    /** offHiHuffman ̃obNAbvp */
    private DynamicHuffman markOffHiHuffman;

    /** position ̃obNAbvp */
    private int markPosition;

    /** nextPosition ̃obNAbvp */
    private int markNextPosition;

    /** matchLength ̃obNAbvp */
    private int markMatchLength;


    //------------------------------------------------------------------
    //  constructer
    //------------------------------------------------------------------
    //  private PreLh2Decoder()
    //  public PreLh2Decoder( InputStream in )
    //------------------------------------------------------------------
    /**
     * ftHgRXgN^B
     * gpsB
     */
    private PreLh2Decoder(){    }


    /**
     * -lh2- 𓀗p PreLzssDecoder \zB<br>
     * 
     * @param in kf[^̓Xg[
     */
    public PreLh2Decoder( InputStream in ){
        if( in != null ){
            if( in instanceof BitInputStream ){
                this.in       = (BitInputStream)in;
            }else{
                this.in       = new BitInputStream( in );
            }
            this.codeHuffman  = new DynamicHuffman( PreLh2Decoder.CodeSize );
            this.offHiHuffman = new DynamicHuffman( 
                                       PreLh2Decoder.DictionarySize >> 6, 1 );

            this.position     = 0;
            this.nextPosition = 1 << 6;
            this.matchLength  = 0;
        }else{
            throw new NullPointerException( "in" );
        }
    }


    //------------------------------------------------------------------
    //  method of jp.gr.java_conf.dangan.util.lha.PreLzssDecoder
    //------------------------------------------------------------------
    //  read
    //------------------------------------------------------------------
    //  public int readCode()
    //  public int readOffset()
    //------------------------------------------------------------------
    /**
     * -lh2- ňkꂽ 
     * 1byte LZSSk̃f[^A
     * ͈kR[ĥvǂݍށB<br>
     * 
     * @return 1byte  k̃f[^́A
     *         kꂽkR[ĥv
     * 
     * @exception IOException  o̓G[ꍇ
     * @exception EOFException EndOfStreamɒBꍇ
     */
    public int readCode() throws IOException {
        final int CodeMax = PreLh2Decoder.CodeSize - 1;

        int node = this.codeHuffman.childNode( DynamicHuffman.ROOT );
        while( 0 <= node ){
            node = this.codeHuffman.childNode( node - ( in.readBoolean() ? 1 : 0 ) );//throws EOFException,IOException
        }
        int code = ~node;
        this.codeHuffman.update( code );

        if( code < 0x100 ){
            this.position++;
        }else{
            if( code == CodeMax ){
                try{
                    code += this.in.readBits( 8 );
                }catch( BitDataBrokenException exception ){
                    if( exception.getCause() instanceof EOFException )
                        throw (EOFException)exception.getCause();
                }
            }
            this.matchLength = code - 0x100 + PreLh2Decoder.Threshold;
        }
        return code;
    }

    /**
     * -lh2- ňkꂽ
     * LZSSkR[ĥvʒuǂݍށB<br>
     * 
     * @return -lh2- ňkꂽkR[ĥvʒu
     * 
     * @exception IOException o̓G[ꍇ
     * @exception EOFException EndOfStreamɒBꍇ
     */
    public int readOffset() throws IOException {
        if( this.nextPosition < PreLh2Decoder.DictionarySize ){
            while( this.nextPosition < this.position ){
                this.offHiHuffman.addLeaf( this.nextPosition >> 6 );
                this.nextPosition += 64;

                if( PreLh2Decoder.DictionarySize <= this.nextPosition )
                    break;
            }
        }
        this.position += this.matchLength;

        int node = this.offHiHuffman.childNode( DynamicHuffman.ROOT );
        while( 0 <= node ){
            node = this.offHiHuffman.childNode( node - ( in.readBoolean() ? 1 : 0 ) );//throws EOFException,IOException
        }
        int offHi = ~node;
        this.offHiHuffman.update( offHi );

        return ( offHi << 6 ) | this.in.readBits( 6 );
    }


    //------------------------------------------------------------------
    //  method of jp.gr.java_conf.dangan.util.lha.PreLzssDecoder
    //------------------------------------------------------------------
    //  mark / reset
    //------------------------------------------------------------------
    //  public void mark( int readLimit )
    //  public void reset()
    //  public boolean markSupported()
    //------------------------------------------------------------------
    /**
     * ڑꂽ̓Xg[݈̌ʒuɃ}[Nݒ肵A
     * reset() \bhŃ}[N_ ǂݍ݈ʒu
     * ߂悤ɂB<br>
     * InputStream  mark() ƈႢAreadLimit Őݒ肵
     * EoCgOɃ}[NʒuɂȂ\
     * 鎖ɒӂ邱ƁB<br>
     * 
     * @param readLimit }[Nʒuɖ߂ẼoCgB
     *                  ̃oCg𒴂ăf[^ǂ
     *                  񂾏ꍇ reset()łȂȂ
     *                  \B<br>
     * 
     * @see PreLzssDecoder#available()
     */
    public void mark( int readLimit ){
        this.in.mark( readLimit * 18 / 8 + 4 );
        this.markCodeHuffman  = (DynamicHuffman)this.codeHuffman.clone();
        this.markOffHiHuffman = (DynamicHuffman)this.offHiHuffman.clone();
        this.markPosition     = this.position;
        this.markNextPosition = this.nextPosition;
        this.markMatchLength  = this.matchLength;
    }

    /**
     * ڑꂽ̓Xg[̓ǂݍ݈ʒuŌ
     * mark() \bhĂяoꂽƂ̈ʒuɐݒ肷B<br>
     * 
     * @exception IOException o̓G[ꍇ
     */
    public void reset() throws IOException {
        //mark()Ȃ reset() 悤ƂꍇA
        //readLimit 𒴂 reset() 悤ƂꍇA
        //ڑꂽ InputStream  markSupported()  false Ԃꍇ
        //BitInputStream  IOException 𓊂B
        this.in.reset();                                                        //throws IOException

        this.codeHuffman  = (DynamicHuffman)this.markCodeHuffman.clone();
        this.offHiHuffman = (DynamicHuffman)this.markOffHiHuffman.clone();
        this.position     = this.markPosition;
        this.nextPosition = this.markNextPosition;
        this.matchLength  = this.markMatchLength;
    }

    /**
     * ڑꂽ̓Xg[ mark()  reset() 
     * T|[g邩𓾂B<br>
     * 
     * @return Xg[ mark()  reset() 
     *         T|[gꍇ trueB<br>
     *         T|[gȂꍇ falseB<br>
     */
    public boolean markSupported(){
        return this.in.markSupported();
    }


    //------------------------------------------------------------------
    //  method of jp.gr.java_conf.dangan.util.lha.PreLzssDecoder
    //------------------------------------------------------------------
    //  other
    //------------------------------------------------------------------
    //  public int available()
    //  public void close()
    //------------------------------------------------------------------
    /**
     * ubNɓǂݏoƂ̏oŒoCg𓾂B<br>
     * InputStream  available() ƈႢA
     * ̍ŒoCg͕KۏႳĂȂɒӂ邱ƁB<br>
     * 
     * @return ubNȂœǂݏoŒoCgB<br>
     * 
     * @exception IOException o̓G[ꍇ
     * 
     * @see PreLzssDecoder#available()
     */
    public int available() throws IOException {
        return Math.max( this.in.availableBits() / 18 - 4, 0 );                 //throws IOException
    }

    /**
     * ̃Xg[AgpĂSĂ̎B
     * 
     * @exception IOException o̓G[ꍇ
     */
    public void close() throws IOException {
        this.in.close();                                                        //throws IOException

        this.in               = null;
        this.codeHuffman      = null;
        this.offHiHuffman     = null;
        this.markCodeHuffman  = null;
        this.markOffHiHuffman = null;
    }


    //------------------------------------------------------------------
    //  method of jp.gr.java_conf.dangan.util.lha.PostLzssEncoder
    //------------------------------------------------------------------
    //  get LZSS parameter
    //------------------------------------------------------------------
    //  public int getDictionarySize()
    //  public int getMaxMatch()
    //  public int getThreshold()
    //------------------------------------------------------------------
    /**
     * -lh2-` LZSS̃TCY𓾂B
     * 
     * @return -lh2-` LZSS̃TCY
     */
    public int getDictionarySize(){
        return PreLh2Decoder.DictionarySize;
    }

    /**
     * -lh2-` LZSS̍őv𓾂B
     * 
     * @return -lh2-` LZSS̍őv
     */
    public int getMaxMatch(){
        return PreLh2Decoder.MaxMatch;
    }

    /**
     * -lh2-` LZSS̈kA񈳏k臒l𓾂B
     * 
     * @return -lh2-` LZSS̈kA񈳏k臒l
     */
    public int getThreshold(){
        return PreLh2Decoder.Threshold;
    }

}
//end of PreLh2Decoder.java
