/* The following code was generated by JFlex 1.4.3 on 2023/04/25 20:22 */

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.netbeans.modules.php.latte.lexer;

import java.util.Objects;
import org.netbeans.spi.lexer.LexerInput;
import org.netbeans.spi.lexer.LexerRestartInfo;
import org.netbeans.modules.web.common.api.ByteStack;

@org.netbeans.api.annotations.common.SuppressWarnings({"SF_SWITCH_FALLTHROUGH", "URF_UNREAD_FIELD", "DLS_DEAD_LOCAL_STORE", "DM_DEFAULT_ENCODING"})

/**
 * This class is a scanner generated by
 * <a href="http://www.jflex.de/">JFlex</a> 1.4.3
 * on 2023/04/25 20:22 from the specification file
 * <tt>/home/junichi11/NetBeansProjects/netbeans/php/php.latte/tools/LatteMarkupColoringLexer.flex</tt>
 */
public class LatteMarkupColoringLexer {

  /** This character denotes the end of file */
  public static final int YYEOF = LexerInput.EOF;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int ST_HIGHLIGHTING_ERROR = 8;
  public static final int ST_END_MACRO = 4;
  public static final int ST_OTHER = 2;
  public static final int YYINITIAL = 0;
  public static final int ST_IN_D_STRING = 6;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = {
     0,  0,  1,  1,  2,  2,  3,  3,  4, 4
  };

  /**
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED =
    "\11\0\1\1\1\54\2\0\1\1\22\0\1\1\1\0\1\2\1\0"+
    "\1\4\2\0\1\6\1\31\1\36\1\0\1\40\1\0\1\46\1\42"+
    "\1\53\12\41\1\43\2\0\1\44\1\45\2\0\1\15\1\27\1\24"+
    "\1\21\1\13\1\14\1\33\1\47\1\26\1\35\1\30\1\16\1\51"+
    "\1\20\1\22\1\32\1\37\1\11\1\17\1\10\1\12\1\52\1\25"+
    "\1\23\1\34\1\37\1\0\1\7\2\0\1\50\1\0\1\15\1\27"+
    "\1\24\1\21\1\13\1\14\1\33\1\47\1\26\1\35\1\30\1\16"+
    "\1\51\1\20\1\22\1\32\1\37\1\11\1\17\1\10\1\12\1\52"+
    "\1\25\1\23\1\34\1\37\1\3\1\0\1\5\uff82\0";

  /**
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /**
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\5\0\1\1\1\2\1\1\1\3\3\1\1\3\10\1"+
    "\1\4\1\5\1\6\1\5\1\6\13\7\2\5\1\10"+
    "\3\5\1\11\1\6\1\12\2\6\1\0\1\13\1\14"+
    "\22\0\1\3\6\0\1\15\1\16\1\0\1\12\1\0"+
    "\1\7\1\0\2\7\1\5\3\7\1\17\4\7\7\0"+
    "\1\10\1\7\12\0\1\11\1\20\4\0\1\12\4\0"+
    "\1\3\25\0\10\7\10\0\2\10\12\0\1\11\2\0"+
    "\2\21\1\12\2\0\1\3\16\0\4\7\7\0\1\10"+
    "\1\0\1\11\14\0\1\20\17\0\3\7\6\0\1\22"+
    "\14\0\1\3\7\0\1\7\17\0\1\3\1\7\10\0"+
    "\1\7\3\0\1\7";

  private static int [] zzUnpackAction() {
    int [] result = new int[300];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /**
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\55\0\132\0\207\0\264\0\341\0\u010e\0\u013b"+
    "\0\341\0\u0168\0\u0195\0\u01c2\0\u01ef\0\u021c\0\u0249\0\u0276"+
    "\0\u02a3\0\u02d0\0\u02fd\0\u032a\0\u0357\0\341\0\341\0\u0384"+
    "\0\u03b1\0\u03de\0\u040b\0\u0438\0\u0465\0\u0492\0\u04bf\0\u04ec"+
    "\0\u0519\0\u0546\0\u0573\0\u05a0\0\u05cd\0\u05fa\0\u0627\0\u0654"+
    "\0\u0681\0\u06ae\0\u06db\0\u0708\0\u0735\0\u0762\0\u078f\0\u07bc"+
    "\0\u0735\0\341\0\u07e9\0\u0816\0\u0843\0\u0870\0\u089d\0\u08ca"+
    "\0\u08f7\0\u0924\0\u0951\0\u097e\0\u09ab\0\u09d8\0\u0a05\0\u0a32"+
    "\0\u0a5f\0\u0a8c\0\u0ab9\0\u0ae6\0\u0b13\0\u0b40\0\u0b6d\0\u0b9a"+
    "\0\u0bc7\0\u0bf4\0\u0c21\0\u0384\0\341\0\u03b1\0\u03de\0\341"+
    "\0\u0c4e\0\u0c7b\0\u0ca8\0\u0cd5\0\u0d02\0\u0465\0\u0d2f\0\u0d5c"+
    "\0\u0d89\0\u0465\0\u0db6\0\u0de3\0\u0e10\0\u0e3d\0\u0e6a\0\u0e97"+
    "\0\u0ec4\0\u0ef1\0\u0f1e\0\u0f4b\0\u0f78\0\u0fa5\0\u0fd2\0\u0fff"+
    "\0\u102c\0\u1059\0\u1086\0\u10b3\0\u10e0\0\u110d\0\u113a\0\u1167"+
    "\0\u1194\0\341\0\u11c1\0\u11ee\0\u121b\0\u11c1\0\u1248\0\u1275"+
    "\0\u12a2\0\u12cf\0\u12fc\0\u1329\0\u1356\0\u1383\0\u13b0\0\u13dd"+
    "\0\u140a\0\u1437\0\u1464\0\u1491\0\u14be\0\u14eb\0\u1518\0\u1545"+
    "\0\u1572\0\u159f\0\u15cc\0\u15f9\0\u1626\0\u1653\0\u1680\0\u16ad"+
    "\0\u16da\0\u1707\0\u1734\0\u1761\0\u178e\0\u17bb\0\u17e8\0\u1815"+
    "\0\u1842\0\u186f\0\u189c\0\u18c9\0\u18f6\0\u1923\0\u1950\0\u197d"+
    "\0\u19aa\0\u19d7\0\u0fd2\0\u1a04\0\u1a31\0\u1a5e\0\u1a8b\0\u1ab8"+
    "\0\u1ae5\0\u1b12\0\u1b3f\0\u1b6c\0\u1b99\0\u1bc6\0\u1bf3\0\u1c20"+
    "\0\u1c4d\0\u12a2\0\341\0\u1c7a\0\u1ca7\0\u1cd4\0\u1d01\0\u1d2e"+
    "\0\u1d5b\0\u1d88\0\u1db5\0\u1de2\0\u1e0f\0\u1e3c\0\u1e69\0\u1e96"+
    "\0\u1ec3\0\u1ef0\0\u1f1d\0\u1f4a\0\u1f77\0\u1fa4\0\u1fd1\0\u1ffe"+
    "\0\u202b\0\u2058\0\u2085\0\u20b2\0\u20df\0\u210c\0\u2139\0\u2166"+
    "\0\u19d7\0\u2193\0\u21c0\0\u21ed\0\u221a\0\u2247\0\u2274\0\u22a1"+
    "\0\u22ce\0\u22fb\0\u2328\0\u2355\0\u2382\0\u23af\0\u23dc\0\341"+
    "\0\u2409\0\u2436\0\u2463\0\u2490\0\u24bd\0\u24ea\0\u2517\0\u2544"+
    "\0\u2571\0\u259e\0\u25cb\0\u25f8\0\u2625\0\u2652\0\u267f\0\u26ac"+
    "\0\u26d9\0\u2706\0\u2733\0\u2760\0\u278d\0\u27ba\0\u27e7\0\u2814"+
    "\0\341\0\u2841\0\u286e\0\u289b\0\u28c8\0\u28f5\0\u2922\0\u294f"+
    "\0\u297c\0\u29a9\0\u29d6\0\u2a03\0\u2a30\0\u2a5d\0\u2a8a\0\u2ab7"+
    "\0\u2ae4\0\u2b11\0\u2b3e\0\u2b6b\0\u2b98\0\u2bc5\0\u2bf2\0\u2c1f"+
    "\0\u2c4c\0\u2c79\0\u2ca6\0\u2cd3\0\u2d00\0\u2d2d\0\u2d5a\0\u2d87"+
    "\0\u2db4\0\u2de1\0\u2e0e\0\u2e3b\0\u2e68\0\u2e95\0\u2ec2\0\u2eef"+
    "\0\u2f1c\0\u2f49\0\u2f76\0\u2fa3\0\u2fd0\0\u2ffd\0\u302a\0\u3057"+
    "\0\u3084\0\u30b1\0\u30de\0\u310b";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[300];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /**
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\6\1\7\6\6\1\10\1\11\1\12\1\13\1\14"+
    "\1\6\1\15\1\16\1\6\1\17\2\6\1\20\1\21"+
    "\1\22\1\23\2\6\1\24\15\6\1\11\1\6\1\25"+
    "\1\26\1\7\1\27\1\7\1\30\1\27\1\31\1\27"+
    "\1\32\1\27\1\33\1\34\2\35\1\36\1\37\2\35"+
    "\1\40\1\35\1\41\1\42\1\43\1\35\1\44\1\45"+
    "\1\35\1\46\4\35\1\27\1\35\1\47\1\50\1\27"+
    "\1\51\1\52\1\27\1\53\4\35\1\27\1\7\1\6"+
    "\1\7\51\6\1\54\1\7\2\55\1\56\1\57\1\60"+
    "\47\55\1\61\1\62\1\63\52\62\1\63\56\0\1\7"+
    "\52\0\1\7\11\0\1\64\62\0\1\65\53\0\1\66"+
    "\4\0\1\67\53\0\1\70\3\0\1\71\43\0\1\72"+
    "\10\0\1\73\36\0\1\74\2\0\1\75\4\0\1\76"+
    "\13\0\1\77\32\0\1\100\1\101\56\0\1\102\4\0"+
    "\1\103\60\0\1\104\20\0\1\105\21\0\1\106\3\0"+
    "\1\107\45\0\1\110\4\0\1\111\54\0\1\112\53\0"+
    "\1\113\37\0\2\114\1\115\52\114\10\0\21\116\1\0"+
    "\4\116\1\0\1\116\1\0\1\116\5\0\4\116\2\0"+
    "\6\117\1\120\1\121\45\117\10\0\1\35\1\122\17\35"+
    "\1\0\4\35\1\0\1\35\1\0\1\35\4\0\1\123"+
    "\4\35\12\0\3\35\1\124\15\35\1\0\4\35\1\0"+
    "\1\35\1\0\1\35\4\0\1\123\4\35\12\0\21\35"+
    "\1\0\4\35\1\0\1\35\1\0\1\35\4\0\1\123"+
    "\4\35\12\0\5\35\1\125\13\35\1\0\4\35\1\0"+
    "\1\35\1\0\1\35\4\0\1\123\4\35\12\0\7\35"+
    "\1\126\1\127\10\35\1\0\4\35\1\0\1\35\1\0"+
    "\1\35\4\0\1\123\4\35\12\0\2\35\1\130\1\131"+
    "\15\35\1\0\4\35\1\0\1\35\1\0\1\35\4\0"+
    "\1\123\4\35\12\0\1\35\1\132\17\35\1\0\4\35"+
    "\1\0\1\35\1\0\1\35\4\0\1\123\4\35\12\0"+
    "\12\35\1\41\6\35\1\0\4\35\1\0\1\35\1\0"+
    "\1\35\4\0\1\123\4\35\12\0\6\35\1\133\3\35"+
    "\1\134\6\35\1\0\4\35\1\0\1\35\1\0\1\35"+
    "\4\0\1\123\4\35\12\0\10\35\1\135\10\35\1\0"+
    "\4\35\1\0\1\35\1\0\1\35\4\0\1\123\4\35"+
    "\12\0\1\35\1\136\17\35\1\0\4\35\1\0\1\35"+
    "\1\0\1\35\4\0\1\123\4\35\15\0\1\137\1\140"+
    "\1\141\1\0\1\142\2\0\1\143\3\0\1\144\1\145"+
    "\66\0\1\146\23\0\3\35\1\147\15\35\1\0\4\35"+
    "\1\0\1\35\1\0\1\50\1\150\3\0\1\123\4\35"+
    "\45\0\1\27\56\0\1\27\50\0\1\146\3\0\1\27"+
    "\17\0\1\151\3\0\1\152\1\0\1\153\1\154\1\0"+
    "\1\155\2\0\1\156\1\157\1\160\1\161\20\0\1\162"+
    "\4\0\2\61\1\163\1\164\1\165\50\61\2\56\1\166"+
    "\1\167\1\170\50\56\2\61\1\163\1\61\1\171\50\61"+
    "\5\0\1\61\2\0\21\116\1\0\4\116\1\0\1\116"+
    "\1\0\1\116\5\0\4\116\3\0\1\63\52\0\1\63"+
    "\15\0\1\172\52\0\1\11\60\0\1\173\45\0\1\174"+
    "\55\0\1\175\54\0\1\176\62\0\1\177\7\0\1\200"+
    "\4\0\1\201\40\0\1\202\51\0\1\203\71\0\1\11"+
    "\50\0\1\204\46\0\1\205\105\0\1\75\17\0\1\206"+
    "\12\0\1\207\51\0\1\210\5\0\1\211\42\0\1\212"+
    "\55\0\1\213\61\0\1\214\45\0\1\215\4\0\1\216"+
    "\54\0\1\217\5\0\1\220\35\0\1\221\63\0\1\222"+
    "\60\0\1\73\37\0\1\11\43\0\55\117\10\0\2\35"+
    "\1\223\16\35\1\0\4\35\1\0\1\35\1\0\1\35"+
    "\4\0\1\123\4\35\12\0\21\35\1\0\4\35\1\0"+
    "\1\35\1\0\1\35\5\0\4\35\12\0\1\224\20\35"+
    "\1\0\4\35\1\0\1\35\1\0\1\35\4\0\1\123"+
    "\4\35\12\0\6\35\1\225\12\35\1\0\4\35\1\0"+
    "\1\35\1\0\1\35\4\0\1\123\4\35\12\0\11\35"+
    "\1\132\7\35\1\0\4\35\1\0\1\35\1\0\1\35"+
    "\4\0\1\123\4\35\12\0\6\35\1\226\12\35\1\0"+
    "\4\35\1\0\1\35\1\0\1\35\4\0\1\123\4\35"+
    "\12\0\15\35\1\132\3\35\1\0\4\35\1\0\1\35"+
    "\1\0\1\35\4\0\1\123\4\35\12\0\12\35\1\227"+
    "\6\35\1\0\4\35\1\0\1\35\1\0\1\35\4\0"+
    "\1\123\4\35\12\0\10\35\1\230\10\35\1\0\4\35"+
    "\1\0\1\35\1\0\1\35\4\0\1\123\4\35\12\0"+
    "\7\35\1\231\11\35\1\0\4\35\1\0\1\35\1\0"+
    "\1\35\4\0\1\123\4\35\12\0\3\35\1\232\15\35"+
    "\1\0\4\35\1\0\1\35\1\0\1\35\4\0\1\123"+
    "\4\35\25\0\1\233\47\0\1\234\47\0\1\235\53\0"+
    "\1\236\73\0\1\237\45\0\1\240\56\0\1\241\45\0"+
    "\1\242\25\0\1\146\1\150\22\0\21\35\1\0\4\35"+
    "\1\0\1\35\1\0\1\243\4\0\1\123\4\35\43\0"+
    "\1\244\24\0\1\245\65\0\1\246\3\0\1\247\43\0"+
    "\1\250\52\0\1\251\4\0\1\252\13\0\1\253\33\0"+
    "\1\254\56\0\1\255\106\0\1\256\21\0\1\257\56\0"+
    "\1\260\36\0\3\166\1\167\1\261\50\166\2\61\1\163"+
    "\1\61\1\262\50\61\5\0\1\61\47\0\4\166\1\263"+
    "\50\166\2\264\2\0\1\264\1\56\47\264\5\0\1\265"+
    "\67\0\1\266\47\0\1\267\54\0\1\270\54\0\1\271"+
    "\35\0\1\11\22\0\1\177\45\0\1\11\57\0\1\272"+
    "\63\0\1\220\62\0\1\11\34\0\1\273\76\0\1\274"+
    "\32\0\1\275\61\0\1\276\10\0\1\277\40\0\1\300"+
    "\111\0\1\65\15\0\1\301\54\0\1\302\77\0\1\215"+
    "\37\0\1\65\51\0\1\177\53\0\1\303\60\0\1\304"+
    "\50\0\1\177\57\0\1\305\63\0\1\202\40\0\3\35"+
    "\1\132\15\35\1\0\4\35\1\0\1\35\1\0\1\35"+
    "\4\0\1\123\4\35\12\0\2\35\1\306\16\35\1\0"+
    "\4\35\1\0\1\35\1\0\1\35\4\0\1\123\4\35"+
    "\12\0\7\35\1\223\11\35\1\0\4\35\1\0\1\35"+
    "\1\0\1\35\4\0\1\123\4\35\12\0\6\35\1\132"+
    "\12\35\1\0\4\35\1\0\1\35\1\0\1\35\4\0"+
    "\1\123\4\35\12\0\10\35\1\223\10\35\1\0\4\35"+
    "\1\0\1\35\1\0\1\35\4\0\1\123\4\35\12\0"+
    "\1\307\20\35\1\0\4\35\1\0\1\35\1\0\1\35"+
    "\4\0\1\123\4\35\12\0\1\310\20\35\1\0\4\35"+
    "\1\0\1\35\1\0\1\35\4\0\1\123\4\35\12\0"+
    "\5\35\1\311\13\35\1\0\4\35\1\0\1\35\1\0"+
    "\1\35\4\0\1\123\4\35\34\0\1\312\44\0\1\313"+
    "\43\0\1\314\54\0\1\315\100\0\1\316\27\0\1\317"+
    "\66\0\1\320\73\0\1\321\26\0\1\242\25\0\1\244"+
    "\30\0\1\322\50\0\1\323\54\0\1\324\62\0\1\325"+
    "\7\0\1\326\57\0\1\162\50\0\1\327\46\0\1\330"+
    "\50\0\1\331\64\0\1\332\5\0\1\333\50\0\1\334"+
    "\45\0\1\335\4\0\1\336\52\0\1\337\37\0\1\166"+
    "\47\0\2\264\2\0\51\264\2\265\1\340\1\265\1\171"+
    "\50\265\17\0\1\341\63\0\1\342\46\0\1\343\51\0"+
    "\1\344\55\0\1\11\50\0\1\345\74\0\1\215\37\0"+
    "\1\346\51\0\1\347\62\0\1\65\67\0\1\350\33\0"+
    "\1\351\53\0\1\352\1\0\1\353\12\0\1\354\37\0"+
    "\1\355\55\0\1\356\72\0\1\357\34\0\1\35\1\360"+
    "\17\35\1\0\4\35\1\0\1\35\1\0\1\35\4\0"+
    "\1\123\4\35\12\0\16\35\1\361\2\35\1\0\4\35"+
    "\1\0\1\35\1\0\1\35\4\0\1\123\4\35\12\0"+
    "\5\35\1\362\13\35\1\0\4\35\1\0\1\35\1\0"+
    "\1\35\4\0\1\123\4\35\12\0\20\35\1\132\1\0"+
    "\4\35\1\0\1\35\1\0\1\35\4\0\1\123\4\35"+
    "\17\0\1\363\54\0\1\364\54\0\1\365\65\0\1\366"+
    "\41\0\1\367\54\0\1\370\22\0\1\371\34\0\1\372"+
    "\56\0\1\373\47\0\1\374\35\0\1\162\22\0\1\325"+
    "\45\0\1\162\57\0\1\375\73\0\1\376\32\0\1\377"+
    "\72\0\1\u0100\75\0\1\u0101\15\0\1\u0102\62\0\1\u0101"+
    "\51\0\1\325\53\0\1\u0103\66\0\1\u0104\46\0\1\u0105"+
    "\52\0\1\u0106\61\0\1\345\57\0\1\u0107\47\0\1\11"+
    "\60\0\1\11\47\0\1\177\65\0\1\u0108\36\0\1\65"+
    "\65\0\1\272\52\0\1\u0109\54\0\1\u010a\45\0\1\u010b"+
    "\64\0\1\u010c\61\0\1\u010d\36\0\10\35\1\132\10\35"+
    "\1\0\4\35\1\0\1\35\1\0\1\35\4\0\1\123"+
    "\4\35\12\0\10\35\1\122\10\35\1\0\4\35\1\0"+
    "\1\35\1\0\1\35\4\0\1\123\4\35\12\0\10\35"+
    "\1\u010e\10\35\1\0\4\35\1\0\1\35\1\0\1\35"+
    "\4\0\1\123\4\35\22\0\1\u010f\44\0\1\u0110\100\0"+
    "\1\u0110\40\0\1\u0111\60\0\1\364\63\0\1\u0112\34\0"+
    "\1\u0113\22\0\1\371\35\0\1\u0114\52\0\1\u0115\55\0"+
    "\1\162\70\0\1\335\37\0\1\u0116\57\0\1\u0101\47\0"+
    "\1\162\53\0\1\u0117\53\0\1\u0118\73\0\1\162\41\0"+
    "\1\u0119\56\0\1\215\104\0\1\11\16\0\1\u011a\53\0"+
    "\1\u011b\56\0\1\u011c\55\0\1\u011d\54\0\1\u011e\55\0"+
    "\1\11\50\0\14\35\1\u011f\4\35\1\0\4\35\1\0"+
    "\1\35\1\0\1\35\4\0\1\123\4\35\23\0\1\u0110"+
    "\71\0\1\371\51\0\1\u0110\34\0\1\u0120\56\0\1\u0121"+
    "\55\0\1\u0122\62\0\1\u0123\53\0\1\162\42\0\1\u0101"+
    "\54\0\1\u0124\53\0\1\65\57\0\1\u0125\51\0\1\u0126"+
    "\57\0\1\357\61\0\1\177\63\0\1\u0127\35\0\3\35"+
    "\1\u0128\15\35\1\0\4\35\1\0\1\35\1\0\1\35"+
    "\4\0\1\123\4\35\13\0\1\u0110\63\0\1\u0110\51\0"+
    "\1\u0129\106\0\1\162\20\0\1\u012a\56\0\1\202\73\0"+
    "\1\u012b\36\0\1\111\46\0\12\35\1\u012c\6\35\1\0"+
    "\4\35\1\0\1\35\1\0\1\35\4\0\1\123\4\35"+
    "\12\0\1\u0101\64\0\1\325\66\0\1\65\32\0\4\35"+
    "\1\132\14\35\1\0\4\35\1\0\1\35\1\0\1\35"+
    "\4\0\1\123\4\35\2\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[12600];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\5\0\1\11\2\1\1\11\14\1\2\11\31\1\1\0"+
    "\1\11\1\1\22\0\1\1\6\0\1\11\1\1\1\0"+
    "\1\11\1\0\1\1\1\0\13\1\7\0\2\1\12\0"+
    "\1\11\1\1\4\0\1\1\4\0\1\1\25\0\10\1"+
    "\10\0\2\1\12\0\1\1\2\0\1\1\1\11\1\1"+
    "\2\0\1\1\16\0\4\1\7\0\1\1\1\0\1\1"+
    "\14\0\1\11\17\0\3\1\6\0\1\11\14\0\1\1"+
    "\7\0\1\1\17\0\2\1\10\0\1\1\3\0\1\1";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[300];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the textposition at the last state to be included in yytext */
  private int zzPushbackPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the
   * matched text
   */
  private int yycolumn;

  /**
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF = false;

  /* user code: */

    private ByteStack stack = new ByteStack();
    private LexerInput input;

    public LatteMarkupColoringLexer(LexerRestartInfo info) {
        this.input = info.input();
        if(info.state() != null) {
            //reset state
            setState((LexerState) info.state());
        } else {
            zzState = zzLexicalState = YYINITIAL;
            stack.clear();
        }

    }

    private enum Syntax {
        LATTE,
        DOUBLE,
        ASP,
        PYTHON,
        OFF;
    }

    public static final class LexerState  {
        final ByteStack stack;
        /** the current state of the DFA */
        final int zzState;
        /** the current lexical state */
        final int zzLexicalState;

        LexerState(ByteStack stack, int zzState, int zzLexicalState) {
            this.stack = stack;
            this.zzState = zzState;
            this.zzLexicalState = zzLexicalState;
        }

        @Override
        public int hashCode() {
            int hash = 5;
            hash = 29 * hash + Objects.hashCode(this.stack);
            hash = 29 * hash + this.zzState;
            hash = 29 * hash + this.zzLexicalState;
            return hash;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (getClass() != obj.getClass()) {
                return false;
            }
            final LexerState other = (LexerState) obj;
            if (!Objects.equals(this.stack, other.stack)) {
                return false;
            }
            if (this.zzState != other.zzState) {
                return false;
            }
            if (this.zzLexicalState != other.zzLexicalState) {
                return false;
            }
            return true;
        }
    }

    public LexerState getState() {
        return new LexerState(stack.copyOf(), zzState, zzLexicalState);
    }

    public void setState(LexerState state) {
        this.stack.copyFrom(state.stack);
        this.zzState = state.zzState;
        this.zzLexicalState = state.zzLexicalState;
    }

    protected int getZZLexicalState() {
        return zzLexicalState;
    }

    protected void popState() {
        yybegin(stack.pop());
    }

    protected void pushState(final int state) {
        stack.push(getZZLexicalState());
        yybegin(state);
    }


 // End user code



  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public LatteMarkupColoringLexer(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public LatteMarkupColoringLexer(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /**
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 176) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }



  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * @param reader   the new input stream
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = zzPushbackPos = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return input.readText().toString();
  }


  /**
   * Returns the character at position <tt>pos</tt> from the
   * matched text.
   *
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch.
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
     return input.readText().charAt(pos);
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return input.readLength();
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of
   * yypushback(int) and a match-all fallback rule) this method
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  }


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    input.backup(number);
    //zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  @SuppressWarnings("fallthrough")
  public LatteMarkupTokenId findNextToken() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    //int zzCurrentPosL;
    //int zzMarkedPosL;
    //int zzEndReadL = zzEndRead;
    //char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      //zzMarkedPosL = zzMarkedPos;

      zzAction = -1;

      //zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
      int tokenLength = 0;

      zzState = ZZ_LEXSTATE[zzLexicalState];


      zzForAction: {
        while (true) {
            zzInput = input.read();

            if(zzInput == LexerInput.EOF) {
                //end of input reached
                zzInput = YYEOF;
                break zzForAction;
                //notice: currently LexerInput.EOF == YYEOF
            }

          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          int zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            tokenLength = input.readLength();
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      if(zzInput != YYEOF) {
         input.backup(input.readLength() - tokenLength);
      }

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 15:
          { return LatteMarkupTokenId.T_KEYWORD;
          }
        case 19: break;
        case 1:
          { yypushback(yylength());
        pushState(ST_OTHER);
          }
        case 20: break;
        case 6:
          { yypushback(1);
        pushState(ST_HIGHLIGHTING_ERROR);
          }
        case 21: break;
        case 3:
          { pushState(ST_OTHER);
        return LatteMarkupTokenId.T_MACRO_START;
          }
        case 22: break;
        case 16:
          { popState();
        return LatteMarkupTokenId.T_STRING;
          }
        case 23: break;
        case 17:
          { yypushback(1);
        return LatteMarkupTokenId.T_STRING;
          }
        case 24: break;
        case 5:
          { return LatteMarkupTokenId.T_CHAR;
          }
        case 25: break;
        case 11:
          { return LatteMarkupTokenId.T_ERROR;
          }
        case 26: break;
        case 7:
          { return LatteMarkupTokenId.T_SYMBOL;
          }
        case 27: break;
        case 2:
          { return LatteMarkupTokenId.T_WHITESPACE;
          }
        case 28: break;
        case 14:
          { return LatteMarkupTokenId.T_VARIABLE;
          }
        case 29: break;
        case 9:
          { pushState(ST_OTHER);
        return LatteMarkupTokenId.T_MACRO_END;
          }
        case 30: break;
        case 4:
          { yypushback(yylength());
        pushState(ST_END_MACRO);
          }
        case 31: break;
        case 10:
          { return LatteMarkupTokenId.T_STRING;
          }
        case 32: break;
        case 13:
          { yypushback(yylength());
        pushState(ST_IN_D_STRING);
          }
        case 33: break;
        case 8:
          { return LatteMarkupTokenId.T_NUMBER;
          }
        case 34: break;
        case 18:
          { return LatteMarkupTokenId.T_CAST;
          }
        case 35: break;
        case 12:
          { popState();
          }
        case 36: break;
        default:
          if (zzInput == YYEOF)
            //zzAtEOF = true;
              {         if(input.readLength() > 0) {
            // backup eof
            input.backup(1);
            //and return the text as error token
            return LatteMarkupTokenId.T_ERROR;
        } else {
            return null;
        }
 }

          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
