/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef EditorButton_H
#include "EditorButton.h"
#endif

#ifndef XPixmap_H
#include "XPixmap.h"
#endif


#include <Xm/PushB.h>

template<class E>
EditorButton<E>::EditorButton(E& e,const string& name,Proc p):
	EditorTool(e,name),
	editor_(e),
	proc_(p)
{
	Widget w = XmCreatePushButton(e.tool(),(char*)name.c_str(),0,0);
	XtAddCallback(w,XmNactivateCallback,activateCB,this);
	XPixmap(name).setLabel(w);
	XtVaSetValues(w,
		XmNmarginWidth, (Dimension)0,
		XmNmarginHeight, (Dimension)0,
		XmNdefaultButtonShadowThickness, (Dimension)0,
		(void*)0);
	XtManageChild(w);
}

template<class E>
EditorButton<E>::~EditorButton()
{
}

template<class E>
void EditorButton<E>::activateCB(Widget,XtPointer o,XtPointer)
{
	EditorButton<E> *e = (EditorButton<E>*)o;
	(e->editor_.*e->proc_)();
}
