/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#include <MTab.hpp>

void MTabWidget::init(MWidget *parent, const char *name, ...)
{
        va_list argptr;
        Arg al[64];           /* Arg List */
        register int ac = 0;      /* Arg Count */
 
        va_start(argptr, name);
        ac = MInitArgs(al, NULL, argptr);
        ident = mTab;
        widget = (Widget) CreateTab( parent->widget, (char*)name, al, ac);
        attachObject();
	MFreeArgs(al, ac);
}
 

void MTabWidget::open()
{
	TabOpen(widget);
}

void MTabWidget::close()
{
	TabClose(widget);
}

Boolean MTabWidget::closed()
{
	return TabClosed(widget);
}

void MTabWidget::set(MWidget& w)
{
	TabSetCurrent(widget,w.widget,True);
}
