/* 
  Copyright (C) 2008 Kai Hertel

	This file is part of mmpong.

	mmpong is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	mmpong is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with mmpong.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <stdlib.h>
#include <string.h>
#include <sys/time.h>
#include <math.h>
#include "helpers.h"

// This linearised bounce back model expects small timesteps to work fine.
/*
EXPORT int bounce_ball_linear(igame, pos_old, dir_old, mu, mp, mw)
struct gameplay* igame;
float *pos_old, *dir_old;
float mu, mp, mw; // drag on paddle, multipliers for paddle and wall velocity
{
	int l_min= (-1);
	float alpha_min; // To detect first hit with wall
	float alpha,beta,det;

	// Add paddles to wall struct
	int nl= 0; //igame->geo.num_lines;
	// paddles
	for (int idx= 0; idx<= 1; idx++) {
		igame->geo.start[nl +idx][0]= (float)idx;
		igame->geo.start[nl +idx][1]= igame->pad[idx].mean + 0.5*igame->pad[idx].size;
		igame->geo.end[nl +idx][0]= (float)idx;
		igame->geo.end[nl +idx][1]= igame->pad[idx].mean - 0.5*igame->pad[idx].size;
		igame->geo.normal[nl +idx][0]= idx? (-1.f):1.f;
		igame->geo.normal[nl +idx][1]= 0.0;
	}

	float m11= igame->ball.pos[0] - pos_old[0];
	float m21= igame->ball.pos[1] - pos_old[1];

	for (int l= 0; l< nl+2; ++l) {
		// check for each line if there is an intersection with
		// the linearised trajectory of the ball
		// this results in a 2x2 linear system of equations.
		float m12= igame->geo.end[l][0] - igame->geo.start[l][0];
		float m22= igame->geo.end[l][1] - igame->geo.start[l][1];
		det= m11*m22 - m12*m21;
		if ( abs(det) > GAME_NUM_EPS ) { // if not, trajectory is parallel to wall
			float r1= igame->geo.start[l][0] - pos_old[0];
			float r2= igame->geo.start[l][1] - pos_old[1];
			// solve   | m11   m12  | | alpha | = | r1 |
			//         | m21   m22  | | beta  | = | r2 |
			alpha= ( m22*r1 - m12*r2 )/det;
			beta = ( m11*r2 - m21*r1 )/det;

			// alpha_min detects the first hit for multiline enviroments
			if (GAME_NUM_EPS<alpha && alpha <=1.f && alpha < alpha_min &&
				0.<=beta && beta <=1.) {
				alpha_min= alpha;
				l_min= l;
			}
		}
	}

	if ( l_min != (-1) ) {
		// calculate new old positions at reflection point
		pos_old[0]+= alpha_min*(igame->ball.pos[0] - pos_old[0]);
		pos_old[1]+= alpha_min*(igame->ball.pos[1] - pos_old[1]);
		// calculate intermediate velocity:
		float dir[2],tmean;
		dir[0]= 0.5*(igame->ball.dir[0] + dir_old[0]);
		dir[1]= 0.5*(igame->ball.dir[1] + dir_old[1]);
		tmean= distance(igame->ball.pos,pos_old)/sqrt(dir[0]*dir[0]+dir[1]*dir[1]);
		// reflect mean velocity
		float vdn= dir[0]*igame->geo.normal[l_min][0] + dir[1]*igame->geo.normal[l_min][1]; 
		if( l_min == nl ) { 
			dir[0]= mp*(dir[0]-2.*vdn*igame->geo.normal[l_min][0]);
			dir[1]= mp*(dir[1]-2.*vdn*igame->geo.normal[l_min][1]) + mu*igame->pad[0].dir;
		}    
		if( l_min == nl+1 ) {
			dir[0]= mp*(dir[0]-2.*vdn*igame->geo.normal[l_min][0]);
			dir[1]= mp*(dir[1]-2.*vdn*igame->geo.normal[l_min][1]) + mu*igame->pad[1].dir;
		}    
		if( l_min < nl ) {
			dir[0]= mw*(dir[0]-2.*vdn*igame->geo.normal[l_min][0]);
			dir[1]= mw*(dir[1]-2.*vdn*igame->geo.normal[l_min][1]);
		}
		dir_old[0]= dir[0];
		dir_old[1]= dir[1];
		igame->ball.dir[0]= dir[0];
		igame->ball.dir[1]= dir[1];
		igame->ball.pos[0]= dir[0]*tmean + pos_old[0];    
		igame->ball.pos[0]= dir[0]*tmean + pos_old[0]; 

	}
	else {
		pos_old[0]=  igame->ball.pos[0];
		pos_old[1]=  igame->ball.pos[1];
	}

  return PONG_SUCCESS;
}
*/
