//=============================================================================
//  MusE Score
//  Linux Music Score Editor
//  $Id: image.h 2460 2009-12-15 18:01:39Z wschweer $
//
//  Copyright (C) 2002-2009 Werner Schweer and others
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License version 2.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//=============================================================================

#ifndef __IMAGE_H__
#define __IMAGE_H__

#include "ui_imageproperties.h"
#include "bsymbol.h"

class ScoreView;
class ImagePath;

//---------------------------------------------------------
//   Image
//---------------------------------------------------------

class Image : public BSymbol {
      Q_DECLARE_TR_FUNCTIONS(Image)

   protected:
      ImagePath* _ip;
      mutable QPixmap buffer;        ///< cached rendering
      QSizeF sz;
      bool _lockAspectRatio;
      mutable bool _dirty;

      virtual bool isEditable() { return true; }
      virtual void editDrag(int, const QPointF&);
      virtual void endEdit();
      virtual void draw(QPainter&) const;
      virtual void updateGrips(int*, QRectF*) const;
      virtual QPointF gripAnchor(int grip) const;

   public:
      Image(Score*);
      virtual ElementType type() const { return IMAGE; }
      virtual void write(Xml& xml) const;
      virtual void read(QDomElement);
      virtual void setPath(const QString& s);
      QString path() const;
      virtual QRectF bbox() const;
      void setSize(QSizeF s)          { sz = s; }
      bool lockAspectRatio() const    { return _lockAspectRatio; }
      void setLockAspectRatio(bool v) { _lockAspectRatio = v; }

      virtual bool genPropertyMenu(QMenu*) const;
      virtual void propertyAction(ScoreView*, const QString&);
      void reference();
      void dereference();
      };

//---------------------------------------------------------
//   RasterImage
//---------------------------------------------------------

class RasterImage : public Image {
      QImage doc;

   public:
      RasterImage(Score*);
      ~RasterImage();
      virtual RasterImage* clone() const;
      virtual void draw(QPainter&) const;
      virtual void setPath(const QString& s);
      };

//---------------------------------------------------------
//   SvgImage
//---------------------------------------------------------

class SvgImage : public Image {
      QSvgRenderer* doc;

   public:
      SvgImage(Score*);
      ~SvgImage();
      virtual SvgImage* clone() const;
      virtual void draw(QPainter&) const;
      virtual void setPath(const QString& s);
      };

//---------------------------------------------------------
//   ImageProperties
//---------------------------------------------------------

class ImageProperties : public QDialog, public Ui::ImageProperties {
      Q_OBJECT

      Image* img;

   private slots:
      void clicked(QAbstractButton*);

   public:
      ImageProperties(Image*, QWidget* parent = 0);
      };

#endif

