# -*-ruby; coding: utf-8 -*- vim:set ft=ruby:
#
# Copyright (c) 2012 Kazuhiro NISHIYAMA
#
# This program is free software with ABSOLUTELY NO WARRANTY.
# You can re-distribute and/or modify this program under
# the same terms of the Ruby's license.
#

require 'open-uri'
require 'uri'
require 'nkf'

module CodeSearch
  ResultRegexp = /number of (regexp results: \d+)<br>\s*number of (source results: \d+)/

  # https://code.google.com/p/codesearch/
  EngineURI = {
    'debian' => 'http://codesearch.debian.net/',
  }

  def codesearch_result engine, key
    engine ||= 'debian'
    key_uri = URI.encode(NKF.nkf('-w', key))
    engine_uri = EngineURI[engine.downcase]
    return "unknown engine: #{engine}" unless engine_uri 

    url = "#{engine_uri}search?q=#{key_uri}"
    open(url){|f|
      result = f.read
      if ResultRegexp =~ result
        "#{$~.captures.join(', ')} for #{key} - #{url}"
      else
        "#{key} - not found in #{engine} codesearch"
      end
    }
  end
end

if __FILE__ == $0
  if ARGV.empty?
    abort("usage: #{$0} keyword")
  end
  include CodeSearch
  puts codesearch_result('debian', ARGV.join(' '))
  exit
end

class CodeSearchBot < Nadoka::NDK_Bot
  include CodeSearch

  def bot_initialize
    if @bot_config.key?(:channels)
      channels = '\A(?:' + @bot_config[:channels].collect{|ch|
        Regexp.quote(ch)
      }.join('|') + ')\z'
      @available_channel = Regexp.compile(channels)
    else
      @available_channel = @bot_config[:ch] || //
    end

    @bot_name = @bot_config[:bot_name] || 'CodeSearchBot'
    @open_search = OpenSearch.new(@bot_config)
    @ch_kcode = @bot_config[:ch_kcode]
  end

  def on_privmsg prefix, ch, msg
    return unless /\Acodesearch(\:([a-z]+))?>\s*(.+)/ =~ msg
    msg = "codesearch#$1 bot: #{codesearch_result($2, $3.toutf8)}"
    if @ch_kcode == :jis
      msg = msg.tojis
    end
    send_notice ch, msg
  end
end
