<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/collectors/python.d.plugin/openldap/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/collectors/python.d.plugin/openldap/metadata.yaml"
sidebar_label: "OpenLDAP"
learn_status: "Published"
learn_rel_path: "Data Collection/Authentication and Authorization"
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# OpenLDAP


<img src="https://netdata.cloud/img/statsd.png" width="150"/>


Plugin: python.d.plugin
Module: openldap

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

This collector monitors OpenLDAP metrics about connections, operations, referrals and more.

Statistics are taken from the monitoring interface of a openLDAP (slapd) server


This collector is supported on all platforms.

This collector only supports collecting metrics from a single instance of this integration.


### Default Behavior

#### Auto-Detection

This collector doesn't work until all the prerequisites are checked.


#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.


## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per OpenLDAP instance

These metrics refer to the entire monitored application.

This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| openldap.total_connections | connections | connections/s |
| openldap.traffic_stats | sent | KiB/s |
| openldap.operations_status | completed, initiated | ops/s |
| openldap.referrals | sent | referrals/s |
| openldap.entries | sent | entries/s |
| openldap.ldap_operations | bind, search, unbind, add, delete, modify, compare | ops/s |
| openldap.waiters | write, read | waiters/s |



## Alerts

There are no alerts configured by default for this integration.


## Setup

### Prerequisites

#### Configure the openLDAP server to expose metrics to monitor it.

Follow instructions from https://www.openldap.org/doc/admin24/monitoringslapd.html to activate monitoring interface.


#### Install python-ldap module

Install python ldap module 

1. From pip package manager

```bash
pip install ldap
```

2. With apt package manager (in most deb based distros)


```bash
apt-get install python-ldap
```


3. With yum package manager (in most rpm based distros)


```bash
yum install python-ldap
```


#### Insert credentials for Netdata to access openLDAP server

Use the `ldappasswd` utility to set a password for the username you will use.



### Configuration

#### File

The configuration file name for this integration is `python.d/openldap.conf`.


You can edit the configuration file using the `edit-config` script from the
Netdata [config directory](https://github.com/netdata/netdata/blob/master/docs/configure/nodes.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config python.d/openldap.conf
```
#### Options

There are 2 sections:

* Global variables
* One or more JOBS that can define multiple different instances to monitor.

The following options can be defined globally: priority, penalty, autodetection_retry, update_every, but can also be defined per JOB to override the global values.

Additionally, the following collapsed table contains all the options that can be configured inside a JOB definition.

Every configuration JOB starts with a `job_name` value which will appear in the dashboard, unless a `name` parameter is specified.


<details><summary>Config options</summary>

| Name | Description | Default | Required |
|:----|:-----------|:-------|:--------:|
| update_every | Sets the default data collection frequency. | 5 | False |
| priority | Controls the order of charts at the netdata dashboard. | 60000 | False |
| autodetection_retry | Sets the job re-check interval in seconds. | 0 | False |
| penalty | Indicates whether to apply penalty to update_every in case of failures. | yes | False |
| name | Job name. This value will overwrite the `job_name` value. JOBS with the same name are mutually exclusive. Only one of them will be allowed running at any time. This allows autodetection to try several alternatives and pick the one that works. |  | False |
| username | The bind user with right to access monitor statistics |  | True |
| password | The password for the binded user |  | True |
| server | The listening address of the LDAP server. In case of TLS, use the hostname which the certificate is published for. |  | True |
| port | The listening port of the LDAP server. Change to 636 port in case of TLS connection. | 389 | True |
| use_tls | Make True if a TLS connection is used over ldaps:// | False | False |
| use_start_tls | Make True if a TLS connection is used over ldap:// | False | False |
| cert_check | False if you want to ignore certificate check | True | True |
| timeout | Seconds to timeout if no connection exist |  | True |

</details>

#### Examples

##### Basic

A basic example configuration.

```yaml
username: "cn=admin"
password: "pass"
server: "localhost"
port: "389"
check_cert: True
timeout: 1

```


## Troubleshooting

### Debug Mode

To troubleshoot issues with the `openldap` collector, run the `python.d.plugin` with the debug option enabled. The output
should give you clues as to why the collector isn't working.

- Navigate to the `plugins.d` directory, usually at `/usr/libexec/netdata/plugins.d/`. If that's not the case on
  your system, open `netdata.conf` and look for the `plugins` setting under `[directories]`.

  ```bash
  cd /usr/libexec/netdata/plugins.d/
  ```

- Switch to the `netdata` user.

  ```bash
  sudo -u netdata -s
  ```

- Run the `python.d.plugin` to debug the collector:

  ```bash
  ./python.d.plugin openldap debug trace
  ```


