/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.net.URI;
import java.net.URISyntaxException;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.expr.ItemMappingIterator;
import net.sf.saxon.expr.JPConverter;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.GlobalParameterSet;
import net.sf.saxon.instruct.GlobalVariable;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.DocumentPool;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;

public final class Bindery {
    private ValueRepresentation[] globals;
    private boolean[] busy;
    private GlobalParameterSet globalParameters;
    private SlotManager globalVariableMap;

    public void allocateGlobals(SlotManager map) {
        this.globalVariableMap = map;
        int n = map.getNumberOfVariables() + 1;
        this.globals = new ValueRepresentation[n];
        this.busy = new boolean[n];
        for (int i = 0; i < n; ++i) {
            this.globals[i] = null;
            this.busy[i] = false;
        }
    }

    public void defineGlobalParameters(GlobalParameterSet params) {
        this.globalParameters = params;
    }

    public boolean useGlobalParameter(StructuredQName qName, int slot, SequenceType requiredType, XPathContext context) throws XPathException {
        JPConverter converter;
        ValueRepresentation val;
        if (this.globals[slot] != null) {
            return true;
        }
        if (this.globalParameters == null) {
            return false;
        }
        Object obj = this.globalParameters.get(qName);
        if (obj == null) {
            return false;
        }
        if (obj instanceof DocumentInfo) {
            String systemId = ((DocumentInfo)obj).getSystemId();
            try {
                DocumentPool pool;
                if (systemId != null && new URI(systemId).isAbsolute() && (pool = context.getController().getDocumentPool()).find(systemId) == null) {
                    pool.add((DocumentInfo)obj, systemId);
                }
            }
            catch (URISyntaxException err) {
                // empty catch block
            }
        }
        if ((val = (converter = JPConverter.allocate(obj.getClass(), context.getConfiguration())).convert(obj, context)) == null) {
            val = EmptySequence.getInstance();
        }
        this.globals[slot] = val = Bindery.applyFunctionConversionRules(val, requiredType, context);
        return true;
    }

    public static Value applyFunctionConversionRules(ValueRepresentation value, SequenceType requiredType, final XPathContext context) throws XPathException {
        Value result;
        XPathException err;
        TypeHierarchy th = context.getConfiguration().getTypeHierarchy();
        final ItemType requiredItemType = requiredType.getPrimaryType();
        ItemType suppliedItemType = value instanceof NodeInfo ? new NameTest((NodeInfo)value) : ((Value)value).getItemType(th);
        SequenceIterator iterator = Value.asIterator(value);
        if (requiredItemType.isAtomicType()) {
            ItemMappingFunction promoter;
            if (!suppliedItemType.isAtomicType()) {
                iterator = Atomizer.getAtomizingIterator(iterator);
                suppliedItemType = suppliedItemType.getAtomizedItemType();
            }
            if (th.relationship(suppliedItemType, BuiltInAtomicType.UNTYPED_ATOMIC) != 4) {
                ItemMappingFunction converter = new ItemMappingFunction(){

                    public Item map(Item item) throws XPathException {
                        if (item instanceof UntypedAtomicValue) {
                            ConversionResult val = ((UntypedAtomicValue)item).convert((AtomicType)requiredItemType, true, context);
                            if (val instanceof ValidationFailure) {
                                ValidationFailure vex = (ValidationFailure)val;
                                throw vex.makeException();
                            }
                            return (AtomicValue)val;
                        }
                        return item;
                    }
                };
                iterator = new ItemMappingIterator(iterator, converter, true);
            }
            if (th.isSubType(requiredItemType, BuiltInAtomicType.NUMERIC)) {
                promoter = new ItemMappingFunction(){

                    public Item map(Item item) throws XPathException {
                        if (!(item instanceof NumericValue) && !(item instanceof UntypedAtomicValue)) {
                            throw new XPathException("Cannot promote non-numeric value to " + requiredItemType.toString(), "XPTY0004", context);
                        }
                        return ((AtomicValue)item).convert((AtomicType)requiredItemType, true, context).asAtomic();
                    }
                };
                iterator = new ItemMappingIterator(iterator, promoter, true);
            }
            if (requiredItemType.equals(BuiltInAtomicType.STRING) && th.relationship(suppliedItemType, BuiltInAtomicType.ANY_URI) != 4) {
                promoter = new ItemMappingFunction(){

                    public Item map(Item item) throws XPathException {
                        if (item instanceof AnyURIValue) {
                            return new StringValue(item.getStringValueCS());
                        }
                        return item;
                    }
                };
                iterator = new ItemMappingIterator(iterator, promoter, true);
            }
        }
        if ((err = TypeChecker.testConformance(result = Value.asValue(SequenceExtent.makeSequenceExtent(iterator)), requiredType, context)) != null) {
            throw err;
        }
        return result;
    }

    public void defineGlobalVariable(GlobalVariable binding, ValueRepresentation value) {
        this.globals[binding.getSlotNumber()] = value;
    }

    public void setExecuting(GlobalVariable binding, boolean executing) throws XPathException {
        int slot = binding.getSlotNumber();
        if (executing) {
            if (this.busy[slot]) {
                throw new XPathException.Circularity("Circular definition");
            }
            this.busy[slot] = true;
        } else {
            this.busy[slot] = false;
        }
    }

    public ValueRepresentation getGlobalVariableValue(GlobalVariable binding) {
        return this.globals[binding.getSlotNumber()];
    }

    public ValueRepresentation getGlobalVariable(int slot) {
        return this.globals[slot];
    }

    public void setGlobalVariable(int slot, ValueRepresentation value) {
        this.globals[slot] = value;
    }

    public void assignGlobalVariable(GlobalVariable binding, ValueRepresentation value) {
        this.defineGlobalVariable(binding, value);
    }

    public SlotManager getGlobalVariableMap() {
        return this.globalVariableMap;
    }

    public ValueRepresentation[] getGlobalVariables() {
        return this.globals;
    }
}

