/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.type;

import java.io.Serializable;
import net.sf.saxon.sort.IntHashMap;
import net.sf.saxon.type.AnySimpleType;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.BuiltInListType;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Untyped;

public abstract class BuiltInType
implements Serializable {
    private static IntHashMap<SchemaType> lookup = new IntHashMap(100);

    private BuiltInType() {
    }

    public static SchemaType getSchemaType(int fingerprint) {
        SchemaType st = lookup.get(fingerprint);
        if (st == null) {
            if (BuiltInAtomicType.DOUBLE == null || BuiltInListType.NMTOKENS == null) {
                // empty if block
            }
            st = lookup.get(fingerprint);
        }
        return st;
    }

    static void register(int fingerprint, SchemaType type) {
        lookup.put(fingerprint, type);
    }

    static {
        BuiltInType.register(573, AnySimpleType.getInstance());
        BuiltInType.register(572, AnyType.getInstance());
        BuiltInType.register(630, Untyped.getInstance());
        BuiltInType.register(575, ErrorType.getInstance());
    }
}

