import _ from 'lodash';

const reportWeakType = (context, weakType) => {
  return (node) => {
    context.report({
      data: {weakType},
      message: 'Unexpected use of weak type "{{weakType}}"',
      node
    });
  };
};

const genericTypeEvaluator = (context, {checkFunction, checkObject}) => {
  return (node) => {
    const name = _.get(node, 'id.name');

    if (checkFunction && name === 'Function' || checkObject && name === 'Object') {
      reportWeakType(context, name)(node);
    }
  };
};

export default (context) => {
  const checkAny = _.get(context, 'options[0].any', true) === true;
  const checkFunction = _.get(context, 'options[0].Function', true) === true;
  const checkObject = _.get(context, 'options[0].Object', true) === true;

  const checks = {};

  if (checkAny) {
    checks.AnyTypeAnnotation = reportWeakType(context, 'any');
  }

  if (checkFunction || checkObject) {
    checks.GenericTypeAnnotation = genericTypeEvaluator(context, {
      checkFunction,
      checkObject
    });
  }

  return checks;
};
