## Usage

```js
const isDescriptor = require('{%= name %}');

isDescriptor({ value: 'foo' })
//=> true
isDescriptor({ get: function() {}, set: function() {} })
//=> true
isDescriptor({ get: 'foo', set: function() {} })
//=> false
```

You may also check for a descriptor by passing an object as the first argument and property name (`string`) as the second argument.

```js
const obj = {};
obj.foo = null;

Object.defineProperty(obj, 'bar', { value: 'xyz' });
Reflect.defineProperty(obj, 'baz', { value: 'xyz' });

isDescriptor(obj, 'foo'); //=> true
isDescriptor(obj, 'bar'); //=> true
isDescriptor(obj, 'baz'); //=> true
```

## Examples

### value type

Returns `false` when not an object

```js
isDescriptor('a'); //=> false
isDescriptor(null); //=> false
isDescriptor([]); //=> false
```

### data descriptor

Returns `true` when the object has valid properties with valid values.

```js
isDescriptor({ value: 'foo' }); //=> true
isDescriptor({ value: function() {} }); //=> true
```

Returns `false` when the object has invalid properties

```js
isDescriptor({ value: 'foo', bar: 'baz' }); //=> false
isDescriptor({ value: 'foo', bar: 'baz' }); //=> false
isDescriptor({ value: 'foo', get: function() {} }); //=> false
isDescriptor({ get: function() {}, value: function() {} }); //=> false
```

`false` when a value is not the correct type

```js
isDescriptor({ value: 'foo', enumerable: 'foo' }); //=> false
isDescriptor({ value: 'foo', configurable: 'foo' }); //=> false
isDescriptor({ value: 'foo', writable: 'foo' }); //=> false
```

### accessor descriptor

`true` when the object has valid properties with valid values.

```js
isDescriptor({ get: function() {}, set: function() {} }); //=> true
isDescriptor({ get: function() {} }); //=> true
isDescriptor({ set: function() {} }); //=> true
```

`false` when the object has invalid properties

```js
isDescriptor({ get: function() {}, set: function() {}, bar: 'baz' }); //=> false
isDescriptor({ get: function() {}, writable: true }); //=> false
isDescriptor({ get: function() {}, value: true }); //=> false
```

Returns `false` when an accessor is not a function

```js
isDescriptor({ get: function() {}, set: 'baz' }); //=> false
isDescriptor({ get: 'foo', set: function() {} }); //=> false
isDescriptor({ get: 'foo', bar: 'baz' }); //=> false
isDescriptor({ get: 'foo', set: 'baz' }); //=> false
```

Returns `false` when a value is not the correct type

```js
isDescriptor({ get: function() {}, set: function() {}, enumerable: 'foo' }); //=> false
isDescriptor({ set: function() {}, configurable: 'foo' }); //=> false
isDescriptor({ get: function() {}, configurable: 'foo' }); //=> false
```
