(function(){"use strict";var root=this;var Springy;if(typeof exports!=="undefined"){Springy=exports}else{Springy=root.Springy={}}var Graph=Springy.Graph=function(){this.nodeSet={};this.nodes=[];this.edges=[];this.adjacency={};this.nextNodeId=0;this.nextEdgeId=0;this.eventListeners=[]};var Node=Springy.Node=function(id,data){this.id=id;this.data=data!==undefined?data:{}};var Edge=Springy.Edge=function(id,source,target,data){this.id=id;this.source=source;this.target=target;this.data=data!==undefined?data:{}};Graph.prototype.addNode=function(node){if(!(node.id in this.nodeSet)){this.nodes.push(node)}this.nodeSet[node.id]=node;this.notify();return node};Graph.prototype.addNodes=function(){for(var i=0;i<arguments.length;i++){var name=arguments[i];var node=new Node(name,{label:name});this.addNode(node)}};Graph.prototype.addEdge=function(edge){var exists=false;this.edges.forEach(function(e){if(edge.id===e.id){exists=true}});if(!exists){this.edges.push(edge)}if(!(edge.source.id in this.adjacency)){this.adjacency[edge.source.id]={}}if(!(edge.target.id in this.adjacency[edge.source.id])){this.adjacency[edge.source.id][edge.target.id]=[]}exists=false;this.adjacency[edge.source.id][edge.target.id].forEach(function(e){if(edge.id===e.id){exists=true}});if(!exists){this.adjacency[edge.source.id][edge.target.id].push(edge)}this.notify();return edge};Graph.prototype.addEdges=function(){for(var i=0;i<arguments.length;i++){var e=arguments[i];var node1=this.nodeSet[e[0]];if(node1==undefined){throw new TypeError("invalid node name: "+e[0])}var node2=this.nodeSet[e[1]];if(node2==undefined){throw new TypeError("invalid node name: "+e[1])}var attr=e[2];this.newEdge(node1,node2,attr)}};Graph.prototype.addNodes2=function(){for(var i=0;i<arguments.length;i++){var data=arguments[i];var node=new Node(data.label,data);this.addNode(node)}};Graph.prototype.addEdges2=function(){for(var i=0;i<arguments.length;i++){var e=arguments[i];var node1=this.nodeSet[e.source];if(node1==undefined){throw new TypeError("invalid node name: "+e.source)}var node2=this.nodeSet[e.target];if(node2==undefined){throw new TypeError("invalid node name: "+e.target)}var attr=e.attributes;this.newEdge(node1,node2,attr)}};Graph.prototype.newNode=function(data){var node=new Node(this.nextNodeId++,data);this.addNode(node);return node};Graph.prototype.newEdge=function(source,target,data){var edge=new Edge(this.nextEdgeId++,source,target,data);this.addEdge(edge);return edge};Graph.prototype.loadJSON=function(json){if(typeof json=="string"||json instanceof String){json=JSON.parse(json)}if("nodes"in json||"edges"in json){this.addNodes2.apply(this,json["nodes"]);this.addEdges2.apply(this,json["edges"])}};Graph.prototype.getEdges=function(node1,node2){if(node1.id in this.adjacency&&node2.id in this.adjacency[node1.id]){return this.adjacency[node1.id][node2.id]}return[]};Graph.prototype.removeNode=function(node){if(node.id in this.nodeSet){delete this.nodeSet[node.id]}for(var i=this.nodes.length-1;i>=0;i--){if(this.nodes[i].id===node.id){this.nodes.splice(i,1)}}this.detachNode(node)};Graph.prototype.detachNode=function(node){var tmpEdges=this.edges.slice();tmpEdges.forEach(function(e){if(e.source.id===node.id||e.target.id===node.id){this.removeEdge(e)}},this);this.notify()};Graph.prototype.removeEdge=function(edge){for(var i=this.edges.length-1;i>=0;i--){if(this.edges[i].id===edge.id){this.edges.splice(i,1)}}for(var x in this.adjacency){for(var y in this.adjacency[x]){var edges=this.adjacency[x][y];for(var j=edges.length-1;j>=0;j--){if(this.adjacency[x][y][j].id===edge.id){this.adjacency[x][y].splice(j,1)}}if(this.adjacency[x][y].length==0){delete this.adjacency[x][y]}}if(isEmpty(this.adjacency[x])){delete this.adjacency[x]}}this.notify()};Graph.prototype.merge=function(data){var nodes=[];data.nodes.forEach(function(n){nodes.push(this.addNode(new Node(n.id,n.data)))},this);data.edges.forEach(function(e){var from=nodes[e.from];var to=nodes[e.to];var id=e.directed?id=e.type+"-"+from.id+"-"+to.id:from.id<to.id?e.type+"-"+from.id+"-"+to.id:e.type+"-"+to.id+"-"+from.id;var edge=this.addEdge(new Edge(id,from,to,e.data));edge.data.type=e.type},this)};Graph.prototype.filterNodes=function(fn){var tmpNodes=this.nodes.slice();tmpNodes.forEach(function(n){if(!fn(n)){this.removeNode(n)}},this)};Graph.prototype.filterEdges=function(fn){var tmpEdges=this.edges.slice();tmpEdges.forEach(function(e){if(!fn(e)){this.removeEdge(e)}},this)};Graph.prototype.addGraphListener=function(obj){this.eventListeners.push(obj)};Graph.prototype.notify=function(){this.eventListeners.forEach(function(obj){obj.graphChanged()})};var Layout=Springy.Layout={};Layout.ForceDirected=function(graph,stiffness,repulsion,damping){this.graph=graph;this.stiffness=stiffness;this.repulsion=repulsion;this.damping=damping;this.nodePoints={};this.edgeSprings={}};Layout.ForceDirected.prototype.point=function(node){if(!(node.id in this.nodePoints)){var mass=node.data.mass!==undefined?node.data.mass:1;this.nodePoints[node.id]=new Layout.ForceDirected.Point(Vector.random(),mass)}return this.nodePoints[node.id]};Layout.ForceDirected.prototype.spring=function(edge){if(!(edge.id in this.edgeSprings)){var length=edge.data.length!==undefined?edge.data.length:1;var existingSpring=false;var from=this.graph.getEdges(edge.source,edge.target);from.forEach(function(e){if(existingSpring===false&&e.id in this.edgeSprings){existingSpring=this.edgeSprings[e.id]}},this);if(existingSpring!==false){return new Layout.ForceDirected.Spring(existingSpring.point1,existingSpring.point2,0,0)}var to=this.graph.getEdges(edge.target,edge.source);from.forEach(function(e){if(existingSpring===false&&e.id in this.edgeSprings){existingSpring=this.edgeSprings[e.id]}},this);if(existingSpring!==false){return new Layout.ForceDirected.Spring(existingSpring.point2,existingSpring.point1,0,0)}this.edgeSprings[edge.id]=new Layout.ForceDirected.Spring(this.point(edge.source),this.point(edge.target),length,this.stiffness)}return this.edgeSprings[edge.id]};Layout.ForceDirected.prototype.eachNode=function(callback){var t=this;this.graph.nodes.forEach(function(n){callback.call(t,n,t.point(n))})};Layout.ForceDirected.prototype.eachEdge=function(callback){var t=this;this.graph.edges.forEach(function(e){callback.call(t,e,t.spring(e))})};Layout.ForceDirected.prototype.eachSpring=function(callback){var t=this;this.graph.edges.forEach(function(e){callback.call(t,t.spring(e))})};Layout.ForceDirected.prototype.applyCoulombsLaw=function(){this.eachNode(function(n1,point1){this.eachNode(function(n2,point2){if(point1!==point2){var d=point1.p.subtract(point2.p);var distance=d.magnitude()+.1;var direction=d.normalise();point1.applyForce(direction.multiply(this.repulsion).divide(distance*distance*.5));point2.applyForce(direction.multiply(this.repulsion).divide(distance*distance*-.5))}})})};Layout.ForceDirected.prototype.applyHookesLaw=function(){this.eachSpring(function(spring){var d=spring.point2.p.subtract(spring.point1.p);var displacement=spring.length-d.magnitude();var direction=d.normalise();spring.point1.applyForce(direction.multiply(spring.k*displacement*-.5));spring.point2.applyForce(direction.multiply(spring.k*displacement*.5))})};Layout.ForceDirected.prototype.attractToCentre=function(){this.eachNode(function(node,point){var direction=point.p.multiply(-1);point.applyForce(direction.multiply(this.repulsion/50))})};Layout.ForceDirected.prototype.updateVelocity=function(timestep){this.eachNode(function(node,point){point.v=point.v.add(point.a.multiply(timestep)).multiply(this.damping);point.a=new Vector(0,0)})};Layout.ForceDirected.prototype.updatePosition=function(timestep){this.eachNode(function(node,point){point.p=point.p.add(point.v.multiply(timestep))})};Layout.ForceDirected.prototype.totalEnergy=function(timestep){var energy=0;this.eachNode(function(node,point){var speed=point.v.magnitude();energy+=.5*point.m*speed*speed});return energy};var __bind=function(fn,me){return function(){return fn.apply(me,arguments)}};Springy.requestAnimationFrame=__bind(root.requestAnimationFrame||root.webkitRequestAnimationFrame||root.mozRequestAnimationFrame||root.oRequestAnimationFrame||root.msRequestAnimationFrame||function(callback,element){root.setTimeout(callback,10)},root);Layout.ForceDirected.prototype.start=function(render,onRenderStop,onRenderStart){var t=this;if(this._started)return;this._started=true;this._stop=false;if(onRenderStart!==undefined){onRenderStart()}Springy.requestAnimationFrame(function step(){t.applyCoulombsLaw();t.applyHookesLaw();t.attractToCentre();t.updateVelocity(.03);t.updatePosition(.03);if(render!==undefined){render()}if(t._stop||t.totalEnergy()<.01){t._started=false;if(onRenderStop!==undefined){onRenderStop()}}else{Springy.requestAnimationFrame(step)}})};Layout.ForceDirected.prototype.stop=function(){this._stop=true};Layout.ForceDirected.prototype.nearest=function(pos){var min={node:null,point:null,distance:null};var t=this;this.graph.nodes.forEach(function(n){var point=t.point(n);var distance=point.p.subtract(pos).magnitude();if(min.distance===null||distance<min.distance){min={node:n,point:point,distance:distance}}});return min};Layout.ForceDirected.prototype.getBoundingBox=function(){var bottomleft=new Vector(-2,-2);var topright=new Vector(2,2);this.eachNode(function(n,point){if(point.p.x<bottomleft.x){bottomleft.x=point.p.x}if(point.p.y<bottomleft.y){bottomleft.y=point.p.y}if(point.p.x>topright.x){topright.x=point.p.x}if(point.p.y>topright.y){topright.y=point.p.y}});var padding=topright.subtract(bottomleft).multiply(.07);return{bottomleft:bottomleft.subtract(padding),topright:topright.add(padding)}};var Vector=Springy.Vector=function(x,y){this.x=x;this.y=y};Vector.random=function(){return new Vector(10*(Math.random()-.5),10*(Math.random()-.5))};Vector.prototype.add=function(v2){return new Vector(this.x+v2.x,this.y+v2.y)};Vector.prototype.subtract=function(v2){return new Vector(this.x-v2.x,this.y-v2.y)};Vector.prototype.multiply=function(n){return new Vector(this.x*n,this.y*n)};Vector.prototype.divide=function(n){return new Vector(this.x/n||0,this.y/n||0)};Vector.prototype.magnitude=function(){return Math.sqrt(this.x*this.x+this.y*this.y)};Vector.prototype.normal=function(){return new Vector(-this.y,this.x)};Vector.prototype.normalise=function(){return this.divide(this.magnitude())};Layout.ForceDirected.Point=function(position,mass){this.p=position;this.m=mass;this.v=new Vector(0,0);this.a=new Vector(0,0)};Layout.ForceDirected.Point.prototype.applyForce=function(force){this.a=this.a.add(force.divide(this.m))};Layout.ForceDirected.Spring=function(point1,point2,length,k){this.point1=point1;this.point2=point2;this.length=length;this.k=k};var Renderer=Springy.Renderer=function(layout,clear,drawEdge,drawNode,onRenderStop,onRenderStart){this.layout=layout;this.clear=clear;this.drawEdge=drawEdge;this.drawNode=drawNode;this.onRenderStop=onRenderStop;this.onRenderStart=onRenderStart;this.layout.graph.addGraphListener(this)};Renderer.prototype.graphChanged=function(e){this.start()};Renderer.prototype.start=function(done){var t=this;this.layout.start(function render(){t.clear();t.layout.eachEdge(function(edge,spring){t.drawEdge(edge,spring.point1.p,spring.point2.p)});t.layout.eachNode(function(node,point){t.drawNode(node,point.p)})},this.onRenderStart,this.onRenderStop)};Renderer.prototype.stop=function(){this.layout.stop()};if(!Array.prototype.forEach){Array.prototype.forEach=function(callback,thisArg){var T,k;if(this==null){throw new TypeError(" this is null or not defined")}var O=Object(this);var len=O.length>>>0;if({}.toString.call(callback)!="[object Function]"){throw new TypeError(callback+" is not a function")}if(thisArg){T=thisArg}k=0;while(k<len){var kValue;if(k in O){kValue=O[k];callback.call(T,kValue,k,O)}k++}}}var isEmpty=function(obj){for(var k in obj){if(obj.hasOwnProperty(k)){return false}}return true}}).call(this);(function(){jQuery.fn.springy=function(params){var graph=this.graph=params.graph||new Springy.Graph;var nodeFont="16px Verdana, sans-serif";var edgeFont="8px Verdana, sans-serif";var stiffness=params.stiffness||400;var repulsion=params.repulsion||400;var damping=params.damping||.5;var nodeSelected=params.nodeSelected||null;var nodeImages={};var edgeLabelsUpright=true;var canvas=this[0];var ctx=canvas.getContext("2d");var layout=this.layout=new Springy.Layout.ForceDirected(graph,stiffness,repulsion,damping);var currentBB=layout.getBoundingBox();var targetBB={bottomleft:new Springy.Vector(-2,-2),topright:new Springy.Vector(2,2)};Springy.requestAnimationFrame(function adjust(){targetBB=layout.getBoundingBox();currentBB={bottomleft:currentBB.bottomleft.add(targetBB.bottomleft.subtract(currentBB.bottomleft).divide(10)),topright:currentBB.topright.add(targetBB.topright.subtract(currentBB.topright).divide(10))};Springy.requestAnimationFrame(adjust)});var toScreen=function(p){var size=currentBB.topright.subtract(currentBB.bottomleft);var sx=p.subtract(currentBB.bottomleft).divide(size.x).x*canvas.width;var sy=p.subtract(currentBB.bottomleft).divide(size.y).y*canvas.height;return new Springy.Vector(sx,sy)};var fromScreen=function(s){var size=currentBB.topright.subtract(currentBB.bottomleft);var px=s.x/canvas.width*size.x+currentBB.bottomleft.x;var py=s.y/canvas.height*size.y+currentBB.bottomleft.y;return new Springy.Vector(px,py)};var selected=null;var nearest=null;var dragged=null;jQuery(canvas).mousedown(function(e){var pos=jQuery(this).offset();var p=fromScreen({x:e.pageX-pos.left,y:e.pageY-pos.top});selected=nearest=dragged=layout.nearest(p);if(selected.node!==null){dragged.point.m=1e4;if(nodeSelected){nodeSelected(selected.node)}}renderer.start()});jQuery(canvas).dblclick(function(e){var pos=jQuery(this).offset();var p=fromScreen({x:e.pageX-pos.left,y:e.pageY-pos.top});selected=layout.nearest(p);node=selected.node;if(node&&node.data&&node.data.ondoubleclick){node.data.ondoubleclick(node.data)}});jQuery(canvas).mousemove(function(e){var pos=jQuery(this).offset();var p=fromScreen({x:e.pageX-pos.left,y:e.pageY-pos.top});nearest=layout.nearest(p);if(dragged!==null&&dragged.node!==null){dragged.point.p.x=p.x;dragged.point.p.y=p.y}renderer.start()});jQuery(window).bind("mouseup",function(e){dragged=null});var getTextWidth=function(node){var text=node.data.label!==undefined?node.data.label:node.id;if(node._width&&node._width[text])return node._width[text];ctx.save();ctx.font=node.data.font!==undefined?node.data.font:nodeFont;var width=ctx.measureText(text).width;ctx.restore();node._width||(node._width={});node._width[text]=width;return width};var getTextHeight=function(node){return 16};var getImageWidth=function(node){var width=node.data.image.width!==undefined?node.data.image.width:nodeImages[node.data.image.src].object.width;return width};var getImageHeight=function(node){var height=node.data.image.height!==undefined?node.data.image.height:nodeImages[node.data.image.src].object.height;return height};Springy.Node.prototype.getHeight=function(){var height;if(this.data.image==undefined){height=getTextHeight(this)}else{if(this.data.image.src in nodeImages&&nodeImages[this.data.image.src].loaded){height=getImageHeight(this)}else{height=10}}return height};Springy.Node.prototype.getWidth=function(){var width;if(this.data.image==undefined){width=getTextWidth(this)}else{if(this.data.image.src in nodeImages&&nodeImages[this.data.image.src].loaded){width=getImageWidth(this)}else{width=10}}return width};var renderer=this.renderer=new Springy.Renderer(layout,function clear(){ctx.clearRect(0,0,canvas.width,canvas.height)},function drawEdge(edge,p1,p2){var x1=toScreen(p1).x;var y1=toScreen(p1).y;var x2=toScreen(p2).x;var y2=toScreen(p2).y;var direction=new Springy.Vector(x2-x1,y2-y1);var normal=direction.normal().normalise();var from=graph.getEdges(edge.source,edge.target);var to=graph.getEdges(edge.target,edge.source);var total=from.length+to.length;var n=0;for(var i=0;i<from.length;i++){if(from[i].id===edge.id){n=i}}var spacing=12;var offset=normal.multiply(-((total-1)*spacing)/2+n*spacing);var paddingX=6;var paddingY=6;var s1=toScreen(p1).add(offset);var s2=toScreen(p2).add(offset);var boxWidth=edge.target.getWidth()+paddingX;var boxHeight=edge.target.getHeight()+paddingY;var intersection=intersect_line_box(s1,s2,{x:x2-boxWidth/2,y:y2-boxHeight/2},boxWidth,boxHeight);if(!intersection){intersection=s2}var stroke=edge.data.color!==undefined?edge.data.color:"#000000";var arrowWidth;var arrowLength;var weight=edge.data.weight!==undefined?edge.data.weight:1;ctx.lineWidth=Math.max(weight*2,.1);arrowWidth=1+ctx.lineWidth;arrowLength=8;var directional=edge.data.directional!==undefined?edge.data.directional:true;var lineEnd;if(directional){lineEnd=intersection.subtract(direction.normalise().multiply(arrowLength*.5))}else{lineEnd=s2}ctx.strokeStyle=stroke;ctx.beginPath();ctx.moveTo(s1.x,s1.y);ctx.lineTo(lineEnd.x,lineEnd.y);ctx.stroke();if(directional){ctx.save();ctx.fillStyle=stroke;ctx.translate(intersection.x,intersection.y);ctx.rotate(Math.atan2(y2-y1,x2-x1));ctx.beginPath();ctx.moveTo(-arrowLength,arrowWidth);ctx.lineTo(0,0);ctx.lineTo(-arrowLength,-arrowWidth);ctx.lineTo(-arrowLength*.8,-0);ctx.closePath();ctx.fill();ctx.restore()}if(edge.data.label!==undefined){text=edge.data.label;ctx.save();ctx.textAlign="center";ctx.textBaseline="top";ctx.font=edge.data.font!==undefined?edge.data.font:edgeFont;ctx.fillStyle=stroke;var angle=Math.atan2(s2.y-s1.y,s2.x-s1.x);var displacement=-8;if(edgeLabelsUpright&&(angle>Math.PI/2||angle<-Math.PI/2)){displacement=8;angle+=Math.PI}var textPos=s1.add(s2).divide(2).add(normal.multiply(displacement));ctx.translate(textPos.x,textPos.y);ctx.rotate(angle);ctx.fillText(text,0,-2);ctx.restore()}},function drawNode(node,p){var s=toScreen(p);ctx.save();var paddingX=6;var paddingY=6;var contentWidth=node.getWidth();var contentHeight=node.getHeight();var boxWidth=contentWidth+paddingX;var boxHeight=contentHeight+paddingY;ctx.clearRect(s.x-boxWidth/2,s.y-boxHeight/2,boxWidth,boxHeight);if(selected!==null&&selected.node!==null&&selected.node.id===node.id){ctx.fillStyle="#FFFFE0"}else if(nearest!==null&&nearest.node!==null&&nearest.node.id===node.id){ctx.fillStyle="#EEEEEE"}else{ctx.fillStyle="#FFFFFF"}ctx.fillRect(s.x-boxWidth/2,s.y-boxHeight/2,boxWidth,boxHeight);if(node.data.image==undefined){ctx.textAlign="left";ctx.textBaseline="top";ctx.font=node.data.font!==undefined?node.data.font:nodeFont;ctx.fillStyle="#000000";var text=node.data.label!==undefined?node.data.label:node.id;ctx.fillText(text,s.x-contentWidth/2,s.y-contentHeight/2);if(node.data.ip!==undefined){ctx.textBaseline="top";ctx.textAlign="center";ctx.font="8px Verdana, sans-serif";ctx.fillStyle="#000000";ctx.fillText(node.data.ip,s.x,s.y+contentHeight/2)}}else{var src=node.data.image.src;if(src in nodeImages){if(nodeImages[src].loaded){ctx.drawImage(nodeImages[src].object,s.x-contentWidth/2,s.y-contentHeight/2,contentWidth,contentHeight);if(node.data.ip!==undefined){ctx.textBaseline="top";ctx.textAlign="center";ctx.font="8px Verdana, sans-serif";ctx.fillStyle="#000000";ctx.fillText(node.data.ip,s.x,s.y+contentHeight/2)}}}else{nodeImages[src]={};var img=new Image;nodeImages[src].object=img;img.addEventListener("load",function(){nodeImages[src].loaded=true});img.src=src}}ctx.restore()});renderer.start();function intersect_line_line(p1,p2,p3,p4){var denom=(p4.y-p3.y)*(p2.x-p1.x)-(p4.x-p3.x)*(p2.y-p1.y);if(denom===0){return false}var ua=((p4.x-p3.x)*(p1.y-p3.y)-(p4.y-p3.y)*(p1.x-p3.x))/denom;var ub=((p2.x-p1.x)*(p1.y-p3.y)-(p2.y-p1.y)*(p1.x-p3.x))/denom;if(ua<0||ua>1||ub<0||ub>1){return false}return new Springy.Vector(p1.x+ua*(p2.x-p1.x),p1.y+ua*(p2.y-p1.y))}function intersect_line_box(p1,p2,p3,w,h){var tl={x:p3.x,y:p3.y};var tr={x:p3.x+w,y:p3.y};var bl={x:p3.x,y:p3.y+h};var br={x:p3.x+w,y:p3.y+h};var result;if(result=intersect_line_line(p1,p2,tl,tr)){return result}if(result=intersect_line_line(p1,p2,tr,br)){return result}if(result=intersect_line_line(p1,p2,br,bl)){return result}if(result=intersect_line_line(p1,p2,bl,tl)){return result}return false}return this}})();function datatableRemoveEmptyRow(table){$("tbody tr.emptyRow",$(table)).remove()}function datatableAddEmptyRow(table,empty_str){var columns=$("thead th",$(table)).filter(function(){return $(this).css("display")!="none"}).length;$("tbody",$(table)).html('<tr class="emptyRow"><td colspan="'+columns+'"><i>'+empty_str+"</i></td></tr>")}function datatableGetNumDisplayedItems(table){return $("tr:not(.emptyRow)",$(table)).length-1}function datatableIsEmpty(table){return datatableGetNumDisplayedItems(table)==0}function datatableGetTotalItems(table){if(datatableIsEmpty(table))return 0;return $("#dt-bottom-details div.pull-left",$(table)).html().match(/of (\d+) rows/)[1]}function datatableGetByForm(form){return $("table",$("#dt-top-details",$(form)).parent())}function datatableUndoAddRow(new_row,empty_str,bt_to_enable,callback_str){if(bt_to_enable)$(bt_to_enable).removeAttr("disabled");var form=$(new_row).closest("form");$(new_row).remove();aysUpdateForm(form);var dt=datatableGetByForm(form);if(datatableIsEmpty(dt))datatableAddEmptyRow(dt,empty_str);if(callback_str)window[callback_str](new_row)}function datatableForEachRow(table,callbacks){$("tr:not(:first)",table).each(function(row_i){if(typeof callbacks==="function"){callbacks.bind(this)(row_i)}else{var i;for(i=0;i<callbacks.length;i++)callbacks[i].bind(this)(row_i)}})}function datatableAddButtonCallback(td_idx,label,bs_class,callback_str,link){$("td:nth-child("+td_idx+")",$(this)).append('<a href="'+link+'" class="add-on btn" style="padding:0.2em;" onclick="'+callback_str+'" role="button"><span class="label '+bs_class+'">'+label+"</span></a>")}function datatableAddDeleteButtonCallback(td_idx,callback_str,label){datatableAddButtonCallback.bind(this)(td_idx,label,"label-danger",callback_str,"javascript:void(0)")}function datatableAddActionButtonCallback(td_idx,callback_str,label){datatableAddButtonCallback.bind(this)(td_idx,label,"label-info",callback_str,"javascript:void(0)")}function datatableAddLinkButtonCallback(td_idx,link,label){datatableAddButtonCallback.bind(this)(td_idx,label,"label-info","",link)}function datatableMakeSelectUnique(tr_obj,added_rows_prefix,options){options=paramsExtend({on_change:$.noop,selector_fn:function(obj){return obj.find("select").first()}},options);function datatableForeachSelectOtherThan(this_select,added_rows_prefix,selector_fn,callback){$("[id^="+added_rows_prefix+"]").each(function(){var other=selector_fn($(this));if(other[0]!=this_select[0])callback(other)})}function datatableOptionChangeStatus(option_obj,enable){if(enable){option_obj.removeAttr("disabled")}else{var select_obj=option_obj.closest("select");var should_reset=select_obj.val()==option_obj.val();option_obj.attr("disabled","disabled");if(should_reset){var new_val=select_obj.find("option:not([disabled])").first().val();select_obj.val(new_val);select_obj.attr("data-old-val",new_val)}}}function datatableOnSelectEntryChange(added_rows_prefix,selector_fn,change_callback){var old_value=$(this).attr("data-old-val")||"";var new_value=$(this).val()||"";var others=[];if(old_value==new_value)old_value="";datatableForeachSelectOtherThan($(this),added_rows_prefix,selector_fn,function(other){datatableOptionChangeStatus(other.find("option[value='"+old_value+"']"),true);datatableOptionChangeStatus(other.find("option[value='"+new_value+"']"),false);others.push(other)});change_callback($(this),old_value,new_value,others,datatableOptionChangeStatus);$(this).attr("data-old-val",new_value)}function datatableOnAddSelectEntry(select_obj,added_rows_prefix,selector_fn){select_obj.val("");datatableForeachSelectOtherThan(select_obj,added_rows_prefix,selector_fn,function(other){other.trigger("change")});var new_sel=select_obj.find("option:not([disabled])").first();var new_val=new_sel.val();select_obj.val(new_val);select_obj.trigger("change")}var select=options.selector_fn(tr_obj);select.on("change",function(){datatableOnSelectEntryChange.bind(this)(added_rows_prefix,options.selector_fn,options.on_change)});select.on("remove",function(){$(this).val("").trigger("change")});datatableOnAddSelectEntry(select,added_rows_prefix,options.selector_fn)}function datatableOrderedInsert(table,td_idx,to_insert,to_insert_val,cmp_fn){var cmp_fn=cmp_fn||function(a,b){return b-a};var inserted=false;datatableForEachRow(table,function(){if(inserted)return;var tr=$(this);var cmp_val=parseInt($("td:nth-child("+td_idx+")",tr).html());if(!isNaN(cmp_val)&&cmp_fn(cmp_val,to_insert_val)<0){tr.before(to_insert);inserted=true}});if(!inserted)$(table).append(to_insert)}function datatableIsLastPage(table){var lastpage=$("#dt-bottom-details .pagination li:nth-last-child(3)",$(table));return!(lastpage.length==1&&lastpage.hasClass("active")==false)}function aysHandleForm(form_selector,options){if(!form_selector)form_selector="form";if(form_selector==="form"){form_selector='form:not([data-ays-ignore="true"])'}var default_options={submit_selector:'button[type="submit"]:not([data-ays-ignore="true"])',on_dirty_callback:$.noop,on_clean_callback:$.noop,handle_submit_buttons:true,handle_datatable:false,handle_tabs:false,ays_options:{}};var o=$.extend(true,{},default_options,options);o.form_selector=form_selector;$(function(){$(o.form_selector).areYouSure(o.ays_options);if(o.handle_submit_buttons)$(o.form_selector).find(o.submit_selector).attr("disabled","disabled");$(o.form_selector).on("dirty.areYouSure",function(){if(o.handle_submit_buttons)$(this).find(o.submit_selector).removeAttr("disabled");if(o.handle_datatable){$(this).find("a.dropdown-toggle").attr("disabled","disabled");$(this).find("ul.pagination a").css("pointer-events","none").css("cursor","default")}if(o.handle_tabs){$(".nav-tabs").find("a").each(function(){if(!$(this).closest("li").hasClass("active"))$(this).removeAttr("data-toggle").closest("li").addClass("disabled")})}o.on_dirty_callback.bind(this)()});$(o.form_selector).on("clean.areYouSure",function(){if(o.handle_submit_buttons)$(this).find(o.submit_selector).attr("disabled","disabled");if(o.handle_datatable){$(this).find("a.dropdown-toggle").removeAttr("disabled");$(this).find("ul.pagination a").css("pointer-events","").css("cursor","")}if(o.handle_tabs){$(".nav-tabs").find("a").each(function(){$(this).attr("data-toggle","tab").closest("li").removeClass("disabled")})}o.on_clean_callback.bind(this)()})})}function aysResetForm(form_selector){$(form_selector).trigger("reinitialize.areYouSure")}function aysUpdateForm(form_selector){$(form_selector).trigger("rescan.areYouSure")}function aysRecheckForm(form_selector){$(form_selector).trigger("checkform.areYouSure")}function aysGetDirty(form_selector,fields_selector){fields_selector=fields_selector||":input:not(input[type=submit]):not(input[type=button])";var getValue=function($field){if($field.hasClass("ays-ignore")||$field.hasClass("aysIgnore")||$field.attr("data-ays-ignore")||$field.attr("name")===undefined){return null}if($field.is(":disabled")){return"ays-disabled"}var val;var type=$field.attr("type");if($field.is("select")){type="select"}switch(type){case"checkbox":case"radio":val=$field.is(":checked");break;case"select":val="";$field.find("option").each(function(o){var $option=$(this);if($option.is(":selected")){val+=$option.val()}});break;default:val=$field.val()}return val};var isFieldDirty=function($field){var origValue=$field.data("ays-orig");var curValue=getValue($field);var dirty=undefined!==origValue&&origValue!=curValue;return{dirty:dirty,origValue:origValue,curValue:curValue}};var l=[];$(form_selector).find(fields_selector).each(function(){var dirty_status=isFieldDirty($(this));if(dirty_status.dirty){dirty_status.input=$(this);l.push(dirty_status)}});return l}function is_good_ipv4(ipv4){if(/^(?:(?:25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])\.){3}(?:25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])$/.test(ipv4)){return true}else{return false}}function is_good_ipv6(ipv6){if(/^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\:){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$|^\s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(%.+)?\s*$/.test(ipv6)){return true}else{return false}}function isNumeric(value){return/^\d+$/.test(value)}function is_mac_address(what){return/^([0-9A-Fa-f]{2}:){5}([0-9A-Fa-f]{2})$/.test(what)}function is_network_mask(what,optional_mask){var elems=what.split("/");var mask=null;var ip_addr;if(elems.length!=2){if(!optional_mask)return null;else ip_addr=what}else{ip_addr=elems[0];if(!isNumeric(elems[1]))return null;mask=parseInt(elems[1]);if(mask<0)return null}if(is_good_ipv4(ip_addr)){if(mask===null)mask=32;else if(mask>32)return null;return{type:"ipv4",address:ip_addr,mask:mask}}else if(is_good_ipv6(elems[0])){if(mask===null)mask=128;else if(mask>128)return false;return{type:"ipv6",address:ip_addr,mask:mask}}return null}function makeUniqueValidator(items_function){return function(field){var cmp_name=field.val();var count=0;if(!cmp_name)return true;items_function(field).each(function(){var name=$(this).val();if(name==cmp_name)count=count+1});return count==1}}function fbits(bits){var sizes=["bps","kbit/s","Mbit/s","Gbit/s","Tbit/s"];if(bits<=0)return"0";var bits_log1000=Math.log(bits)/Math.log(1e3);var i=parseInt(Math.floor(bits_log1000));if(i<0||isNaN(i)){i=0}else if(i>=sizes.length){return"> "+sizes[sizes.length-1]}if(i<=1){return Math.round(bits/Math.pow(1e3,i)*100)/100+" "+sizes[i]}else{var ret=parseFloat(bits/Math.pow(1e3,i)).toFixed(2);if(ret%1==0)ret=Math.round(ret);return ret+" "+sizes[i]}}function fpackets(pps){var sizes=["pps","Kpps","Mpps","Gpps","Tpps"];if(pps==0)return"0";var i=parseInt(Math.floor(Math.log(pps)/Math.log(1e3)));if(i<0||isNaN(i)){i=0}return Math.round(pps/Math.pow(1e3,i)*100)/100+" "+sizes[i]}function fint(value){var x=Math.round(value);return x.toString().replace(/\B(?=(\d{3})+(?!\d))/g,",")}function fdate(when){var epoch=when*1e3;var d=new Date(epoch);return d}function capitaliseFirstLetter(string){return string.charAt(0).toUpperCase()+string.slice(1)}String.prototype.startsWith=function(string){return this.indexOf(string)===0};function get_trend(actual,before){if(before===undefined||actual==before){return'<i class="fa fa-minus"></i>'}else{return'<i class="fa fa-arrow-up"></i>'}}function getOSIcon(name){var icon="";if(name.search("Linux")!=-1||name.search("Ubuntu")!=-1)icon="<i class='fa fa-linux fa-lg'></i> ";else if(name.search("Android")!=-1)icon="<i class='fa fa-android fa-lg'></i> ";else if(name.search("Windows")!=-1||name.search("Win32")!=-1||name.search("MSIE")!=-1)icon="<i class='fa fa-windows fa-lg'></i> ";else if(name.search("iPhone")!=-1||name.search("iPad")!=-1||name.search("OS X")!=-1)icon="<i class='fa fa-apple fa-lg'></i> ";return icon}function abbreviateString(str,len){if(!str)return"";if(str.length<len)return str;return str.substring(0,len)+"..."}function bytesToSize(bytes){var precision=2;var kilobyte=1024;var megabyte=kilobyte*1024;var gigabyte=megabyte*1024;var terabyte=gigabyte*1024;if(bytes>=0&&bytes<kilobyte)return bytes+" Bytes";
else if(bytes>=kilobyte&&bytes<megabyte)return(bytes/kilobyte).toFixed(precision)+" KB";else if(bytes>=megabyte&&bytes<gigabyte)return(bytes/megabyte).toFixed(precision)+" MB";else if(bytes>=gigabyte&&bytes<terabyte)return(bytes/gigabyte).toFixed(precision)+" GB";else if(bytes>=terabyte)return(bytes/terabyte).toFixed(precision)+" TB";else return bytes+" Bytes"}String.prototype.capitalizeSingleWord=function(){var uc=this.toUpperCase();if(uc=="ASN"||uc=="OS")return uc;else return this.charAt(0).toUpperCase()+this.slice(1)};String.prototype.capitalize=function(){var res=this.split(" ");for(var i in res){res[i]=res[i].capitalizeSingleWord()}return res.join(" ")};function drawTrend(current,last,withColor){if(current==last){return'<i class="fa fa-minus"></i>'}else if(current>last){return'<i class="fa fa-arrow-up"'+withColor+"></i>"}else{return'<i class="fa fa-arrow-down"></i>'}}function toggleAllTabs(enabled){if(enabled===true)$("#historical-tabs-container").find("li").removeClass("disabled").find("a").attr("data-toggle","tab");else $("#historical-tabs-container").find("li").addClass("disabled").find("a").removeAttr("data-toggle")}function disableAllDropdownsAndTabs(){$("select").each(function(){$(this).prop("disabled",true)});toggleAllTabs(false)}function enableAllDropdownsAndTabs(){$("select").each(function(){$(this).prop("disabled",false)});toggleAllTabs(true)}function capitalize(s){return s&&s[0].toUpperCase()+s.slice(1)}function addCommas(nStr){nStr+="";var x=nStr.split(".");var x1=x[0];var x2=x.length>1?"."+x[1]:"";var rgx=/(\d+)(\d{3})/;while(rgx.test(x1)){x1=x1.replace(rgx,"$1"+","+"$2")}return x1+x2}function formatPackets(n){return addCommas(n)+" Pkts"}function bytesToVolume(bytes){var sizes=["Bytes","KB","MB","GB","TB"];if(bytes==0)return"0 Bytes";var i=parseInt(Math.floor(Math.log(bytes)/Math.log(1024)));return(bytes/Math.pow(1024,i)).toFixed(2)+" "+sizes[i]}function bytesToVolumeAndLabel(bytes){var sizes=["Bytes","KB","MB","GB","TB"];if(bytes==0)return"0 Bytes";var i=parseInt(Math.floor(Math.log(bytes)/Math.log(1024)));return[(bytes/Math.pow(1024,i)).toFixed(2),sizes[i]]}function bitsToSize(bits,factor){var sizes=["bit/s","kbit/s","Mbit/s","Gbit/s","Tbit/s"];if(bits==0)return"0 bps";var i=parseInt(Math.floor(Math.log(bits)/Math.log(1e3)));if(i==0)return bits+" "+sizes[i];return(bits/Math.pow(factor,i)).toFixed(2)+" "+sizes[i]}function secondsToTime(seconds){if(seconds<1){return"< 1 sec"}var days=Math.floor(seconds/86400);var hours=Math.floor(seconds/3600-days*24);var minutes=Math.floor(seconds/60-days*1440-hours*60);var sec=seconds%60;var msg="",msg_array=[];if(days>0){years=Math.floor(days/365);if(years>0){days=days%365;msg=years+" year";if(years>1){msg+="s"}msg_array.push(msg);msg=""}msg=days+" day";if(days>1){msg+="s"}msg_array.push(msg);msg=""}if(hours>0){msg=hours+" hour";if(hours>1){msg+="s"}msg_array.push(msg);msg=""}if(minutes>0){msg_array.push(minutes+" min")}if(sec>0){msg_array.push(sec+" sec")}return msg_array.join(", ")}Date.prototype.format=function(format){var o={"M+":this.getMonth()+1,"d+":this.getDate(),"h+":this.getHours(),"m+":this.getMinutes(),"s+":this.getSeconds(),"q+":Math.floor((this.getMonth()+3)/3),S:this.getMilliseconds()};if(/(y+)/.test(format))format=format.replace(RegExp.$1,(this.getFullYear()+"").substr(4-RegExp.$1.length));for(var k in o)if(new RegExp("("+k+")").test(format))format=format.replace(RegExp.$1,RegExp.$1.length==1?o[k]:("00"+o[k]).substr((""+o[k]).length));return format};function epoch2Seen(epoch){var d=new Date(epoch*1e3);var tdiff=Math.floor((new Date).getTime()/1e3-epoch);return d.format("dd/MM/yyyy hh:mm:ss")+" ["+secondsToTime(tdiff)+" ago]"}function graphGetXAxisTicksFormat(diff_epoch){var tickFormat;if(diff_epoch<=86400){tickFormat="%H:%M:%S"}else if(diff_epoch<=2*86400){tickFormat="%b %e, %H:%M:%S"}else{tickFormat="%b %e"}return tickFormat}function graphGetHeaderTicksFormat(diff_epoch){var tickFormat;tickFormat="%b %e, %H:%M:%S";return tickFormat}function nvGraphSetXTicksFormat(chart,diff_epoch){chart.interactiveLayer.tooltip.headerFormatter(function(d){return d3.time.format(graphGetHeaderTicksFormat(diff_epoch))(new Date(d*1e3))});chart.xAxis.tickFormat(function(d){return d3.time.format(graphGetXAxisTicksFormat(diff_epoch))(new Date(d*1e3))})}function paramsExtend(defaults,override){return $.extend({},defaults,override)}function paramsToForm(form,params){form=$(form);for(var k in params){if(params.hasOwnProperty(k)){var input=$('<input type="hidden" name="'+k+'" value="'+params[k]+'">');input.appendTo(form)}}return form}function paramsPairsEncode(params){var i=0;var res={};for(var k in params){res["key_"+i]=k;res["val_"+i]=params[k];i=i+1}return res}jQuery.fn.extend({disable:function(state){return this.each(function(){var $this=$(this);if($this.is("input, button, textarea, select"))this.disabled=state;else $this.toggleClass("disabled",state)})}});function hostkey2hostInfo(host_key){var info;var hostinfo=[];host_key=host_key.replace(/____/g,":");host_key=host_key.replace(/___/g,"/");host_key=host_key.replace(/__/g,".");info=host_key.split("@");return info}function handle_tab_state(nav_object,default_tab){$("a",nav_object).click(function(e){e.preventDefault()});$(" > li > a",nav_object).on("shown.bs.tab",function(e){var id=$(e.target).attr("href").substr(1);if(history.replaceState){history.replaceState(null,null,"#"+id)}else{window.location.hash=id}});var hash=window.location.hash;if(!hash)hash="#"+default_tab;$('a[href="'+hash+'"]',nav_object).tab("show")}if(typeof Math.sign==="undefined"){Math.sign=function(x){return x>=0?1:-1}}function memberValueValidator(input){var member=input.val();if(member==="")return true;return is_mac_address(member)||is_network_mask(member,true)}function makeFindHostBeforeSubmitCallback(http_prefix){return function(form,data){if(data.isMac)form.attr("action",http_prefix+"/lua/mac_details.lua");else form.attr("action",http_prefix+"/lua/host_details.lua");return true}}
//# sourceMappingURL=ntop.min.js.map